/*
 * Decompiled with CFR 0.152.
 */
package hara.lib.foundation;

import hara.lib.foundation.Clock;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;

public class Flake
implements Comparable<Flake> {
    private final long timePart;
    private final long rand1Part;
    private final long rand2Part;
    private static final char[] chars = new char[]{'-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Flake(long l, long l2, long l3) {
        this.timePart = l;
        this.rand1Part = l2;
        this.rand2Part = l3;
    }

    public static final Flake flake() {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        return new Flake(Clock.currentTimeNanos(), threadLocalRandom.nextLong(), threadLocalRandom.nextLong());
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[24];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putLong(this.timePart).putLong(this.rand1Part).putLong(this.rand2Part);
        return byArray;
    }

    public String toString() {
        return Flake.formatFlake(this);
    }

    public long getTimestampNanos() {
        return this.timePart;
    }

    public long getTimestampMicros() {
        return this.timePart / 1000L;
    }

    public long getTimestampMillis() {
        return this.timePart / 1000000L;
    }

    @Override
    public int compareTo(Flake flake) {
        if (flake == null) {
            return 1;
        }
        int n = Long.compareUnsigned(this.timePart, flake.timePart);
        if (n != 0) {
            return n;
        }
        n = Long.compareUnsigned(this.rand1Part, flake.rand1Part);
        if (n != 0) {
            return n;
        }
        n = Long.compareUnsigned(this.rand2Part, flake.rand2Part);
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof Flake) {
            return this.compareTo((Flake)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.timePart) ^ Long.hashCode(this.rand1Part) ^ Long.hashCode(this.rand1Part);
    }

    public static final Flake makeFlake(long l, long l2, long l3) {
        return new Flake(l, l2, l3);
    }

    public static final Flake makeFlake(byte[] byArray) {
        if (byArray == null || byArray.length != 24) {
            throw new IllegalArgumentException("Invalid flake length");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        return new Flake(byteBuffer.getLong(), byteBuffer.getLong(), byteBuffer.getLong());
    }

    public static final String formatFlake(Flake flake) {
        byte[] byArray = flake.getBytes();
        char[] cArray = new char[32];
        int n = 0;
        for (int i = 0; i < byArray.length; i += 3) {
            int n2 = (byArray[i] & 0xFC) >>> 2;
            int n3 = (byArray[i] & 3) << 4 | (byArray[i + 1] & 0xF0) >>> 4;
            int n4 = (byArray[i + 1] & 0xF) << 2 | (byArray[i + 2] & 0xC0) >>> 6;
            int n5 = byArray[i + 2] & 0x3F;
            cArray[n++] = chars[n2];
            cArray[n++] = chars[n3];
            cArray[n++] = chars[n4];
            cArray[n++] = chars[n5];
        }
        return new String(cArray);
    }

    public static final String formatFlakeHex(Flake flake) {
        byte[] byArray = flake.getBytes();
        char[] cArray = new char[48];
        for (int i = 0; i < byArray.length; ++i) {
            int n = (byArray[i] & 0xF0) >>> 4;
            int n2 = byArray[i] & 0xF;
            cArray[i * 2] = hexChars[n];
            cArray[i * 2 + 1] = hexChars[n2];
        }
        return new String(cArray);
    }
}

