/*
 * Decompiled with CFR 0.152.
 */
package hara.lib.security.shamir;

import hara.lib.security.shamir.SecretShare;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;

public final class Shamir {
    public static SecretShare[] split(BigInteger bigInteger, int n, int n2, BigInteger bigInteger2, Random random) {
        BigInteger[] bigIntegerArray = new BigInteger[n];
        bigIntegerArray[0] = bigInteger;
        for (int i = 1; i < n; ++i) {
            BigInteger bigInteger3;
            while ((bigInteger3 = new BigInteger(bigInteger2.bitLength(), random)).compareTo(BigInteger.ZERO) <= 0 || bigInteger3.compareTo(bigInteger2) >= 0) {
            }
            bigIntegerArray[i] = bigInteger3;
        }
        SecretShare[] secretShareArray = new SecretShare[n2];
        for (int i = 1; i <= n2; ++i) {
            BigInteger bigInteger4 = bigInteger;
            for (int j = 1; j < n; ++j) {
                bigInteger4 = bigInteger4.add(bigIntegerArray[j].multiply(BigInteger.valueOf(i).pow(j).mod(bigInteger2))).mod(bigInteger2);
            }
            secretShareArray[i - 1] = new SecretShare(i, bigInteger4);
        }
        return secretShareArray;
    }

    public static BigInteger combine(SecretShare[] secretShareArray, BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.ZERO;
        for (int i = 0; i < secretShareArray.length; ++i) {
            BigInteger bigInteger3 = BigInteger.ONE;
            BigInteger bigInteger4 = BigInteger.ONE;
            for (int j = 0; j < secretShareArray.length; ++j) {
                if (i == j) continue;
                int n = secretShareArray[i].getNumber();
                int n2 = secretShareArray[j].getNumber();
                bigInteger3 = bigInteger3.multiply(BigInteger.valueOf(n2).negate()).mod(bigInteger);
                bigInteger4 = bigInteger4.multiply(BigInteger.valueOf(n - n2)).mod(bigInteger);
            }
            BigInteger bigInteger5 = secretShareArray[i].getShare();
            BigInteger bigInteger6 = bigInteger5.multiply(bigInteger3).multiply(Shamir.modInverse(bigInteger4, bigInteger));
            bigInteger2 = bigInteger.add(bigInteger2).add(bigInteger6).mod(bigInteger);
        }
        return bigInteger2;
    }

    private static BigInteger[] gcdD(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.compareTo(BigInteger.ZERO) == 0) {
            return new BigInteger[]{bigInteger, BigInteger.ONE, BigInteger.ZERO};
        }
        BigInteger bigInteger3 = bigInteger.divide(bigInteger2);
        BigInteger bigInteger4 = bigInteger.mod(bigInteger2);
        BigInteger[] bigIntegerArray = Shamir.gcdD(bigInteger2, bigInteger4);
        return new BigInteger[]{bigIntegerArray[0], bigIntegerArray[2], bigIntegerArray[1].subtract(bigIntegerArray[2].multiply(bigInteger3))};
    }

    private static BigInteger modInverse(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = (bigInteger = bigInteger.mod(bigInteger2)).compareTo(BigInteger.ZERO) == -1 ? Shamir.gcdD(bigInteger2, bigInteger.negate())[2].negate() : Shamir.gcdD(bigInteger2, bigInteger)[2];
        return bigInteger2.add(bigInteger3).mod(bigInteger2);
    }

    public static void main(String[] stringArray) {
        SecureRandom secureRandom = new SecureRandom();
        BigInteger bigInteger = new BigInteger("123");
        BigInteger bigInteger2 = new BigInteger(bigInteger.bitLength() + 1, 256, secureRandom);
        SecretShare[] secretShareArray = Shamir.split(bigInteger, 2, 5, bigInteger2, secureRandom);
        SecretShare[] secretShareArray2 = new SecretShare[]{secretShareArray[0], secretShareArray[1]};
        BigInteger bigInteger3 = Shamir.combine(secretShareArray2, bigInteger2);
        secretShareArray2 = new SecretShare[]{secretShareArray[1], secretShareArray[4]};
        bigInteger3 = Shamir.combine(secretShareArray2, bigInteger2);
        secretShareArray2 = new SecretShare[]{secretShareArray[0], secretShareArray[1], secretShareArray[3]};
        bigInteger3 = Shamir.combine(secretShareArray2, bigInteger2);
    }
}

