/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.apns;

import java.util.HashMap;
import java.util.Map;

public enum NotificationRequestError {
    BadRequest(400),
    BadMethod(405),
    DeviceTokenInactiveForTopic(410),
    PayloadTooLarge(413),
    TooManyRequestsForToken(429),
    InternalServerError(500),
    ServerUnavailable(503),
    InvalidProviderToken(403);

    public final int errorCode;
    private static Map<Integer, NotificationRequestError> errorMap;

    private NotificationRequestError(int errorCode) {
        this.errorCode = errorCode;
    }

    public static NotificationRequestError get(int errorCode) {
        return errorMap.get(errorCode);
    }

    static {
        errorMap = new HashMap<Integer, NotificationRequestError>();
        for (NotificationRequestError notificationRequestError : NotificationRequestError.values()) {
            errorMap.put(notificationRequestError.errorCode, notificationRequestError);
        }
    }
}

