/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.apns.clients;

import com.clevertap.apns.ApnsClient;
import com.clevertap.apns.clients.AsyncOkHttpApnsClient;
import com.clevertap.apns.clients.SyncOkHttpApnsClient;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;

public class ApnsClientBuilder {
    private InputStream certificate;
    private boolean production;
    private String password;
    private int connectionPort = 443;
    private boolean asynchronous = false;
    private String defaultTopic = null;
    private OkHttpClient.Builder builder;
    private ConnectionPool connectionPool;
    private String apnsAuthKey;
    private String teamID;
    private String keyID;

    public static OkHttpClient.Builder createDefaultOkHttpClientBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS);
        builder.connectionPool(new ConnectionPool(10, 10L, TimeUnit.MINUTES));
        return builder;
    }

    public ApnsClientBuilder withOkHttpClientBuilder(OkHttpClient.Builder clientBuilder) {
        this.builder = clientBuilder;
        return this;
    }

    public ApnsClientBuilder withPort(int port) {
        if (port != 443 && port != 2197) {
            throw new IllegalArgumentException("APNs only supports ports 443 and 2197. Invalid port " + port);
        }
        this.connectionPort = port;
        return this;
    }

    public ApnsClientBuilder withConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        return this;
    }

    public ApnsClientBuilder withCertificate(InputStream inputStream) {
        this.certificate = inputStream;
        return this;
    }

    public ApnsClientBuilder withPassword(String password) {
        this.password = password;
        return this;
    }

    public ApnsClientBuilder withApnsAuthKey(String apnsAuthKey) {
        this.apnsAuthKey = apnsAuthKey;
        return this;
    }

    public ApnsClientBuilder withTeamID(String teamID) {
        this.teamID = teamID;
        return this;
    }

    public ApnsClientBuilder withKeyID(String keyID) {
        this.keyID = keyID;
        return this;
    }

    public ApnsClientBuilder withProductionGateway() {
        this.production = true;
        return this;
    }

    public ApnsClientBuilder withProductionGateway(boolean production) {
        if (production) {
            return this.withProductionGateway();
        }
        return this.withDevelopmentGateway();
    }

    public ApnsClientBuilder withDevelopmentGateway() {
        this.production = false;
        return this;
    }

    public ApnsClientBuilder inSynchronousMode() {
        this.asynchronous = false;
        return this;
    }

    public ApnsClientBuilder inAsynchronousMode() {
        this.asynchronous = true;
        return this;
    }

    public ApnsClientBuilder withDefaultTopic(String defaultTopic) {
        this.defaultTopic = defaultTopic;
        return this;
    }

    public ApnsClient build() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException, KeyManagementException {
        if (this.builder == null) {
            this.builder = ApnsClientBuilder.createDefaultOkHttpClientBuilder();
        }
        if (this.connectionPool != null) {
            this.builder.connectionPool(this.connectionPool);
        }
        if (this.certificate != null) {
            if (this.asynchronous) {
                return new AsyncOkHttpApnsClient(this.certificate, this.password, this.production, this.defaultTopic, this.builder, this.connectionPort);
            }
            return new SyncOkHttpApnsClient(this.certificate, this.password, this.production, this.defaultTopic, this.builder, this.connectionPort);
        }
        if (this.keyID != null && this.teamID != null && this.apnsAuthKey != null) {
            if (this.asynchronous) {
                return new AsyncOkHttpApnsClient(this.apnsAuthKey, this.teamID, this.keyID, this.production, this.defaultTopic, this.builder, this.connectionPort);
            }
            return new SyncOkHttpApnsClient(this.apnsAuthKey, this.teamID, this.keyID, this.production, this.defaultTopic, this.builder, this.connectionPort);
        }
        throw new IllegalArgumentException("Either the token credentials (team ID, key ID, and the private key) or a certificate must be provided");
    }
}

