(ns clj-fn.rest
  (:use compojure.core))

;;;;; route rest
(defn root []
  {:body {:helo "world"}})

(defn ret [code msg data]
  {:body {:code code :msg msg :data data}})

(defn succ [data]
  (ret 0 "succ" data))

(defn fail [msg & code]
  (let [msg (or msg "fail")
        code (or code 1)]
    (ret code msg {})))

(defmacro defrest [name ns-str]
  (let [base-name   (str name "s" )
        root-name   (str "/" base-name)
        routes-name (symbol (str base-name "-routes"))
        route-name  (symbol (str name "-routes"))
        sym-all     (symbol (str "db/get-" base-name))
        sym-get     (symbol (str "db/get-"    name))
        sym-create  (symbol (str "db/create-" name))
        sym-update  (symbol (str "db/update-" name))
        sym-delete  (symbol (str "db/delete-" name))
        limit       10
        bind-ns     (symbol ns-str)
        exp
        `(defroutes ~routes-name
           (GET     "/" {{page# :page
                          size# :size}
                          :params}                (succ (~sym-all page# size# 1)))
           (POST    "/" {body# :params}      (succ (~sym-create body#)))
           (OPTIONS "/" []                        (~root))
           (context
            "/:id" [~'id]
            (defroutes ~route-name
              (OPTIONS "/" []                     (~root))
              (GET     "/" []                     (succ (~sym-get ~'id)))
              (PUT     "/" {body# :params}   (succ (~sym-update ~'id body#)))
              (DELETE  "/" []                     (succ (~sym-delete ~'id))))))]

    (context root-name []
             (binding [*ns*
                       (find-ns bind-ns)]
               (eval exp)))))
