(ns clj-fn.rest
  (:use compojure.core)
  (:require [clojure.tools.macro :as ctm]))

;;;;; route rest
(defn root []
  {:body {:helo "world"}})

(defn ret [code msg data & [res-name count page size]]
  (let [res-name (or res-name "")
        count (or count 0)
        page (or page 1)
        size (or size 10)]
    {:body {:code code :msg msg :data data 
            :page page :size size :count count 
            :res-name res-name}}))

(defn succ [data & [res-name]]
    (ret 0 "succ" data res-name))

(defn succ-all [data & [res-name page size]]
  (let [data1 (:data data)
        count (:count data)]
    (ret 0 "succ" data1 res-name count page size)))

(defn fail [msg & [code]]
  (let [msg (or msg "fail")
        code (or code 1)]
    (ret code msg {})))

(defn defrest [name ns-str]
  (let [base-name   (str name "s" )
        root-name   (str "/" base-name)
        routes-name (symbol (str base-name "-routes"))
        route-name  (symbol (str name "-routes"))
        sym-all     (symbol (str "db/get-" base-name))
        sym-get     (symbol (str "db/get-"    name))
        sym-create  (symbol (str "db/create-" name))
        sym-update  (symbol (str "db/update-" name))
        sym-delete  (symbol (str "db/delete-" name))
        limit       10
        bind-ns     (symbol ns-str)
        exp
        `(defroutes ~routes-name
           (GET     "/" {{page# :page
                          size# :size
                          :as params#}
                          :params}                (succ (~sym-all page# size# params#) ~base-name))
           (POST    "/" {body# :params}      (succ (~sym-create body#) ~base-name))
           (OPTIONS "/" []                        (~root))
           (context
            "/:id" [~'id]
            (defroutes ~route-name
              (OPTIONS "/" []                     (~root))
              (GET     "/" []                     (succ (~sym-get ~'id) (str ~name ~'id)))
              (PUT     "/" {body# :params}   (succ (~sym-update ~'id body#) (str ~name ~'id)))
              (DELETE  "/" []                     (succ (~sym-delete ~'id))))))]

    ;exp
    (context root-name []
             (binding [*ns*
                       (find-ns bind-ns)]
               (eval exp)))))

(defn gen-rest-routes [name]
  (let [base-name   (str name "s" )
        root-name   (str "/" base-name)
        routes-name (symbol (str base-name "-routes"))
        route-name  (symbol (str name "-routes"))
        sym-all     (symbol (str "db/get-" base-name))
        sym-get     (symbol (str "db/get-"    name))
        sym-create  (symbol (str "db/create-" name))
        sym-update  (symbol (str "db/update-" name))
        sym-delete  (symbol (str "db/delete-" name))
        limit       10
        item-name   (str root-name "/:id")

        exp
        `(defroutes ~routes-name
           (GET     "/" {{page# :page
                          size# :size
                          :as params#}
                         :params}                (succ (~sym-all page# size# params#) ~base-name))
           (POST    "/" {body# :params}      (succ (~sym-create body#) ~base-name))
           (OPTIONS "/" []                        (~root))
           (context
             "/:id" [~'id]
             (defroutes ~route-name
               (OPTIONS "/" []                     (~root))
               (GET     "/" []                     (succ (~sym-get ~'id) (str ~name ~'id)))
               (PUT     "/" {body# :params}   (succ (~sym-update ~'id body#) (str ~name ~'id)))
               (DELETE  "/" []                     (succ (~sym-delete ~'id))))))

        exp1      
        `((OPTIONS ~root-name [] (~root))
          (GET     ~root-name {{page# :page size# :size :as params#} :params} (succ-all (~sym-all page# size# params#) ~base-name page# size#))
          (POST    ~root-name {body# :params} (succ (~sym-create (dissoc body# :token)) ~base-name))

          (OPTIONS ~item-name [] (~root))
          (GET     ~item-name {{id# :id uid# :uid :as body#} :params} (succ (~sym-get id#) (str ~name id# uid#)))
          (PUT     ~item-name {{id# :id :as body#} :params}           (succ (~sym-update id# (dissoc body# :token)) (str ~name id#)))
          (DELETE  ~item-name {{id# :id uid# :uid :as body#} :params} (succ (~sym-delete id# uid#)))
          )
        ]
    exp1
    ))

(defmacro def-rest-routes [symb names]
  (let [[symb body] (ctm/name-with-attributes symb names)]
    (let [exp (reduce into '() (map gen-rest-routes names))]
      `(def ~symb (routes ~@exp)))))
