/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BlockStoreException;
import com.google.bitcoin.store.FullPrunedBlockStore;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointManager {
    private static final Logger log = LoggerFactory.getLogger(CheckpointManager.class);
    protected final TreeMap<Long, StoredBlock> checkpoints = new TreeMap();
    protected final NetworkParameters params;
    protected final Sha256Hash dataHash;

    public CheckpointManager(NetworkParameters params, InputStream inputStream) throws IOException {
        this.params = (NetworkParameters)Preconditions.checkNotNull((Object)params);
        FilterInputStream dis = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            DigestInputStream digestInputStream = new DigestInputStream((InputStream)Preconditions.checkNotNull((Object)inputStream), digest);
            dis = new DataInputStream(digestInputStream);
            digestInputStream.on(false);
            String magic = "CHECKPOINTS 1";
            byte[] header = new byte[magic.length()];
            ((DataInputStream)dis).readFully(header);
            if (!Arrays.equals(header, magic.getBytes("US-ASCII"))) {
                throw new IOException("Header bytes did not match expected version");
            }
            int numSignatures = ((DataInputStream)dis).readInt();
            for (int i = 0; i < numSignatures; ++i) {
                byte[] sig = new byte[65];
                ((DataInputStream)dis).readFully(sig);
            }
            digestInputStream.on(true);
            int numCheckpoints = ((DataInputStream)dis).readInt();
            Preconditions.checkState((numCheckpoints > 0 ? 1 : 0) != 0);
            int size = 96;
            ByteBuffer buffer = ByteBuffer.allocate(96);
            for (int i = 0; i < numCheckpoints; ++i) {
                if (((DataInputStream)dis).read(buffer.array(), 0, 96) < 96) {
                    throw new IOException("Incomplete read whilst loading checkpoints.");
                }
                StoredBlock block = StoredBlock.deserializeCompact(params, buffer);
                buffer.position(0);
                this.checkpoints.put(block.getHeader().getTimeSeconds(), block);
            }
            this.dataHash = new Sha256Hash(digest.digest());
            log.info("Read {} checkpoints, hash is {}", (Object)this.checkpoints.size(), (Object)this.dataHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (ProtocolException e) {
            throw new IOException(e);
        }
        finally {
            if (dis != null) {
                dis.close();
            }
            inputStream.close();
        }
    }

    public StoredBlock getCheckpointBefore(long time) {
        Preconditions.checkArgument((time > this.params.genesisBlock.getTimeSeconds() ? 1 : 0) != 0);
        Map.Entry<Long, StoredBlock> entry = this.checkpoints.floorEntry(time);
        if (entry == null) {
            try {
                Block genesis = this.params.genesisBlock.cloneAsHeader();
                return new StoredBlock(genesis, genesis.getWork(), 0);
            }
            catch (VerificationException e) {
                throw new RuntimeException(e);
            }
        }
        return entry.getValue();
    }

    public int numCheckpoints() {
        return this.checkpoints.size();
    }

    public Sha256Hash getDataHash() {
        return this.dataHash;
    }

    public static void checkpoint(NetworkParameters params, InputStream checkpoints, BlockStore store, long time) throws IOException, BlockStoreException {
        Preconditions.checkNotNull((Object)params);
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkArgument((!(store instanceof FullPrunedBlockStore) ? 1 : 0) != 0, (Object)"You cannot use checkpointing with a full store.");
        BufferedInputStream stream = new BufferedInputStream(checkpoints);
        CheckpointManager manager = new CheckpointManager(params, stream);
        StoredBlock checkpoint = manager.getCheckpointBefore(time);
        store.put(checkpoint);
        store.setChainHead(checkpoint);
    }
}

