/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.utils.Locks;
import com.google.common.base.Preconditions;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryPool {
    private static final Logger log = LoggerFactory.getLogger(MemoryPool.class);
    protected ReentrantLock lock = Locks.lock("mempool");
    private LinkedHashMap<Sha256Hash, Entry> memoryPool;
    private ReferenceQueue<Transaction> referenceQueue;
    public static final int MAX_SIZE = 1000;

    public MemoryPool(final int size) {
        this.memoryPool = new LinkedHashMap<Sha256Hash, Entry>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Sha256Hash, Entry> entry) {
                return this.size() > size;
            }
        };
        this.referenceQueue = new ReferenceQueue();
    }

    public MemoryPool() {
        this(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanPool() {
        this.lock.lock();
        try {
            Reference<Transaction> ref;
            while ((ref = this.referenceQueue.poll()) != null) {
                WeakTransactionReference txRef = (WeakTransactionReference)ref;
                this.memoryPool.remove(txRef.hash);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numBroadcastPeers(Sha256Hash txHash) {
        this.lock.lock();
        try {
            this.cleanPool();
            Entry entry = this.memoryPool.get(txHash);
            if (entry == null) {
                int n = 0;
                return n;
            }
            if (entry.tx == null) {
                Preconditions.checkNotNull(entry.addresses);
                int n = entry.addresses.size();
                return n;
            }
            Transaction tx = (Transaction)entry.tx.get();
            if (tx == null) {
                this.memoryPool.remove(txHash);
                int n = 0;
                return n;
            }
            Preconditions.checkState((entry.addresses == null ? 1 : 0) != 0);
            int n = tx.getConfidence().numBroadcastPeers();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction seen(Transaction tx, PeerAddress byPeer) {
        boolean skipUnlock = false;
        this.lock.lock();
        try {
            this.cleanPool();
            Entry entry = this.memoryPool.get(tx.getHash());
            if (entry != null) {
                if (entry.tx != null) {
                    Preconditions.checkState((entry.addresses == null ? 1 : 0) != 0);
                    Transaction transaction = (Transaction)entry.tx.get();
                    if (transaction == null) {
                        log.info("{}: Provided with a transaction that we previously threw away: {}", (Object)byPeer, (Object)tx.getHash());
                    } else {
                        tx = transaction;
                        log.info("{}: Provided with a transaction downloaded before: [{}] {}", new Object[]{byPeer, tx.getConfidence().numBroadcastPeers(), tx.getHash()});
                    }
                    this.markBroadcast(byPeer, tx);
                    Transaction transaction2 = tx;
                    return transaction2;
                }
                Preconditions.checkNotNull(entry.addresses);
                entry.tx = new WeakTransactionReference(tx, this.referenceQueue);
                Set<PeerAddress> addrs = entry.addresses;
                entry.addresses = null;
                TransactionConfidence confidence = tx.getConfidence();
                log.debug("{}: Adding tx [{}] {} to the memory pool", new Object[]{byPeer, confidence.numBroadcastPeers(), tx.getHashAsString()});
                skipUnlock = true;
                this.lock.unlock();
                for (PeerAddress a : addrs) {
                    confidence.markBroadcastBy(a);
                }
                Transaction transaction = tx;
                return transaction;
            }
            log.debug("{}: Provided with a downloaded transaction we didn't see announced yet: {}", (Object)byPeer, (Object)tx.getHashAsString());
            entry = new Entry();
            entry.tx = new WeakTransactionReference(tx, this.referenceQueue);
            this.memoryPool.put(tx.getHash(), entry);
            this.markBroadcast(byPeer, tx);
            Transaction transaction = tx;
            return transaction;
        }
        finally {
            if (!skipUnlock) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seen(Sha256Hash hash, PeerAddress byPeer) {
        this.lock.lock();
        try {
            this.cleanPool();
            Entry entry = this.memoryPool.get(hash);
            if (entry != null) {
                if (entry.tx != null) {
                    Preconditions.checkState((entry.addresses == null ? 1 : 0) != 0);
                    Transaction tx = (Transaction)entry.tx.get();
                    if (tx != null) {
                        this.markBroadcast(byPeer, tx);
                        log.debug("{}: Announced transaction we have seen before [{}] {}", new Object[]{byPeer, tx.getConfidence().numBroadcastPeers(), tx.getHashAsString()});
                    }
                } else {
                    Preconditions.checkNotNull(entry.addresses);
                    entry.addresses.add(byPeer);
                    log.debug("{}: Announced transaction we have seen announced before [{}] {}", new Object[]{byPeer, entry.addresses.size(), hash});
                }
            } else {
                entry = new Entry();
                entry.addresses = new HashSet<PeerAddress>();
                entry.addresses.add(byPeer);
                this.memoryPool.put(hash, entry);
                log.info("{}: Announced new transaction [1] {}", (Object)byPeer, (Object)hash);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markBroadcast(PeerAddress byPeer, Transaction tx) {
        Preconditions.checkState((boolean)this.lock.isLocked());
        this.lock.unlock();
        try {
            tx.getConfidence().markBroadcastBy(byPeer);
        }
        finally {
            this.lock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction get(Sha256Hash hash) {
        this.lock.lock();
        try {
            Entry entry = this.memoryPool.get(hash);
            if (entry == null) {
                Transaction transaction = null;
                return transaction;
            }
            if (entry.tx == null) {
                Transaction transaction = null;
                return transaction;
            }
            if (entry.tx.get() == null) {
                Transaction transaction = null;
                return transaction;
            }
            Transaction tx = (Transaction)entry.tx.get();
            Preconditions.checkNotNull((Object)tx);
            Transaction transaction = tx;
            return transaction;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maybeWasSeen(Sha256Hash hash) {
        this.lock.lock();
        try {
            Entry entry = this.memoryPool.get(hash);
            boolean bl = entry != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class Entry {
        Set<PeerAddress> addresses;
        WeakTransactionReference tx;

        private Entry() {
        }
    }

    private static class WeakTransactionReference
    extends WeakReference<Transaction> {
        public Sha256Hash hash;

        public WeakTransactionReference(Transaction tx, ReferenceQueue<Transaction> queue) {
            super(tx, queue);
            this.hash = tx.getHash();
        }
    }
}

