/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AbstractBlockChain;
import com.google.bitcoin.core.AddressMessage;
import com.google.bitcoin.core.AlertMessage;
import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.BloomFilter;
import com.google.bitcoin.core.FilteredBlock;
import com.google.bitcoin.core.GetBlocksMessage;
import com.google.bitcoin.core.GetDataMessage;
import com.google.bitcoin.core.GetHeadersMessage;
import com.google.bitcoin.core.HeadersMessage;
import com.google.bitcoin.core.InventoryItem;
import com.google.bitcoin.core.InventoryMessage;
import com.google.bitcoin.core.MemoryPool;
import com.google.bitcoin.core.MemoryPoolMessage;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.NotFoundMessage;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerEventListener;
import com.google.bitcoin.core.Ping;
import com.google.bitcoin.core.Pong;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.PrunedException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.VersionAck;
import com.google.bitcoin.core.VersionMessage;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BlockStoreException;
import com.google.bitcoin.utils.Locks;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer {
    private static final Logger log = LoggerFactory.getLogger(Peer.class);
    protected final ReentrantLock lock = Locks.lock("peer");
    private final NetworkParameters params;
    private final AbstractBlockChain blockChain;
    private volatile PeerAddress vAddress;
    private final CopyOnWriteArrayList<PeerEventListener> eventListeners;
    private final CopyOnWriteArrayList<PeerLifecycleListener> lifecycleListeners;
    private volatile boolean vDownloadData;
    private final VersionMessage versionMessage;
    private final AtomicInteger blocksAnnounced = new AtomicInteger();
    private final MemoryPool memoryPool;
    private final CopyOnWriteArrayList<Wallet> wallets;
    @GuardedBy(value="lock")
    private long fastCatchupTimeSecs;
    @GuardedBy(value="lock")
    private boolean downloadBlockBodies = true;
    @GuardedBy(value="lock")
    private boolean useFilteredBlocks = false;
    private volatile BloomFilter vBloomFilter;
    private FilteredBlock currentFilteredBlock = null;
    private int filteredBlocksReceived;
    private static final int RESEND_BLOOM_FILTER_BLOCK_COUNT = 25000;
    private final HashSet<Sha256Hash> pendingBlockDownloads = new HashSet();
    private volatile int vMinProtocolVersion = 60001;
    private final CopyOnWriteArrayList<GetDataRequest> getDataFutures;
    private final ReentrantLock lastPingTimesLock = new ReentrantLock();
    @GuardedBy(value="lastPingTimesLock")
    private long[] lastPingTimes = null;
    private final CopyOnWriteArrayList<PendingPing> pendingPings;
    private static final int PING_MOVING_AVERAGE_WINDOW = 20;
    private volatile Channel vChannel;
    private volatile VersionMessage vPeerVersionMessage;
    private boolean isAcked;
    private final PeerHandler handler;
    private Sha256Hash lastGetBlocksBegin;
    private Sha256Hash lastGetBlocksEnd;

    public Peer(NetworkParameters params, AbstractBlockChain chain, VersionMessage ver) {
        this(params, chain, ver, null);
    }

    public Peer(NetworkParameters params, AbstractBlockChain chain, VersionMessage ver, MemoryPool mempool) {
        this.params = (NetworkParameters)Preconditions.checkNotNull((Object)params);
        this.versionMessage = (VersionMessage)Preconditions.checkNotNull((Object)ver);
        this.blockChain = chain;
        this.vDownloadData = chain != null;
        this.getDataFutures = new CopyOnWriteArrayList();
        this.eventListeners = new CopyOnWriteArrayList();
        this.lifecycleListeners = new CopyOnWriteArrayList();
        this.fastCatchupTimeSecs = params.genesisBlock.getTimeSeconds();
        this.isAcked = false;
        this.handler = new PeerHandler();
        this.pendingPings = new CopyOnWriteArrayList();
        this.wallets = new CopyOnWriteArrayList();
        this.memoryPool = mempool;
    }

    public Peer(NetworkParameters params, AbstractBlockChain blockChain, String thisSoftwareName, String thisSoftwareVersion) {
        this(params, blockChain, new VersionMessage(params, blockChain.getBestChainHeight(), true));
        this.versionMessage.appendToSubVer(thisSoftwareName, thisSoftwareVersion, null);
    }

    public void addEventListener(PeerEventListener listener) {
        this.eventListeners.add(listener);
    }

    public boolean removeEventListener(PeerEventListener listener) {
        return this.eventListeners.remove(listener);
    }

    void addLifecycleListener(PeerLifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    boolean removeLifecycleListener(PeerLifecycleListener listener) {
        return this.lifecycleListeners.remove(listener);
    }

    public String toString() {
        PeerAddress addr = this.vAddress;
        if (addr == null) {
            return "Peer()";
        }
        return addr.toString();
    }

    private void notifyDisconnect() {
        for (PeerLifecycleListener listener : this.lifecycleListeners) {
            listener.onPeerDisconnected(this);
        }
    }

    private void processMessage(MessageEvent e, Message m) throws IOException, VerificationException, ProtocolException {
        block31: {
            try {
                PeerEventListener peerEventListener;
                Iterator<Object> i$ = this.eventListeners.iterator();
                while (i$.hasNext() && (m = (peerEventListener = i$.next()).onPreMessageReceived(this, m)) != null) {
                }
                if (m == null) {
                    return;
                }
                if (this.currentFilteredBlock != null && !(m instanceof Transaction)) {
                    this.endFilteredBlock(this.currentFilteredBlock);
                    this.currentFilteredBlock = null;
                }
                if (m instanceof NotFoundMessage) {
                    this.processNotFoundMessage((NotFoundMessage)m);
                    break block31;
                }
                if (m instanceof InventoryMessage) {
                    this.processInv((InventoryMessage)m);
                    break block31;
                }
                if (m instanceof Block) {
                    this.processBlock((Block)m);
                    break block31;
                }
                if (m instanceof FilteredBlock) {
                    this.startFilteredBlock((FilteredBlock)m);
                    break block31;
                }
                if (m instanceof Transaction) {
                    this.processTransaction((Transaction)m);
                    break block31;
                }
                if (m instanceof GetDataMessage) {
                    this.processGetData((GetDataMessage)m);
                    break block31;
                }
                if (m instanceof AddressMessage) break block31;
                if (m instanceof HeadersMessage) {
                    this.processHeaders((HeadersMessage)m);
                } else if (m instanceof AlertMessage) {
                    this.processAlert((AlertMessage)m);
                } else if (m instanceof VersionMessage) {
                    this.vPeerVersionMessage = (VersionMessage)m;
                    for (PeerLifecycleListener peerLifecycleListener : this.lifecycleListeners) {
                        peerLifecycleListener.onPeerConnected(this);
                    }
                    int version = this.vMinProtocolVersion;
                    if (this.vPeerVersionMessage.clientVersion < version) {
                        log.warn("Connected to a peer speaking protocol version {} but need {}, closing", (Object)this.vPeerVersionMessage.clientVersion, (Object)version);
                        e.getChannel().close();
                    }
                } else if (m instanceof VersionAck) {
                    if (this.vPeerVersionMessage == null) {
                        throw new ProtocolException("got a version ack before version");
                    }
                    if (this.isAcked) {
                        throw new ProtocolException("got more than one version ack");
                    }
                    this.isAcked = true;
                } else if (m instanceof Ping) {
                    if (((Ping)m).hasNonce()) {
                        this.sendMessage(new Pong(((Ping)m).getNonce()));
                    }
                } else if (m instanceof Pong) {
                    this.processPong((Pong)m);
                } else {
                    log.warn("Received unhandled message: {}", (Object)m);
                }
            }
            catch (Throwable throwable) {
                log.warn("Caught exception in peer thread: {}", (Object)throwable.getMessage());
                throwable.printStackTrace();
                for (PeerEventListener listener : this.eventListeners) {
                    try {
                        listener.onException(throwable);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    private void startFilteredBlock(FilteredBlock m) throws IOException {
        this.currentFilteredBlock = m;
        ++this.filteredBlocksReceived;
        if (this.filteredBlocksReceived % 25000 == 24999) {
            this.sendMessage(this.vBloomFilter);
        }
    }

    private void processNotFoundMessage(NotFoundMessage m) {
        block0: for (GetDataRequest req : this.getDataFutures) {
            for (InventoryItem item : m.getItems()) {
                if (!item.hash.equals(req.hash)) continue;
                log.info("{}: Bottomed out dep tree at {}", (Object)this, (Object)req.hash);
                req.future.cancel(true);
                this.getDataFutures.remove(req);
                continue block0;
            }
        }
    }

    private void processAlert(AlertMessage m) {
        try {
            if (m.isSignatureValid()) {
                log.info("Received alert from peer {}: {}", (Object)this.toString(), (Object)m.getStatusBar());
            } else {
                log.warn("Received alert with invalid signature from peer {}: {}", (Object)this.toString(), (Object)m.getStatusBar());
            }
        }
        catch (Throwable t) {
            log.error("Failed to check signature: bug in platform libraries?", t);
        }
    }

    public PeerHandler getHandler() {
        return this.handler;
    }

    private void processHeaders(HeadersMessage m) throws IOException, ProtocolException {
        this.lock.lock();
        long fastCatchupTimeSecs = this.fastCatchupTimeSecs;
        boolean downloadBlockBodies = this.downloadBlockBodies;
        this.lock.unlock();
        try {
            Preconditions.checkState((!downloadBlockBodies ? 1 : 0) != 0, (Object)this.toString());
            for (int i = 0; i < m.getBlockHeaders().size(); ++i) {
                Block header = m.getBlockHeaders().get(i);
                if (header.getTimeSeconds() < fastCatchupTimeSecs) {
                    if (!this.vDownloadData) {
                        log.info("Lost download peer status, throwing away downloaded headers.");
                        return;
                    }
                    if (!this.blockChain.add(header)) {
                        throw new ProtocolException("Got unconnected header from peer: " + header.getHashAsString());
                    }
                } else {
                    log.info("Passed the fast catchup time, discarding {} headers and requesting full blocks", (Object)(m.getBlockHeaders().size() - i));
                    this.downloadBlockBodies = true;
                    this.lastGetBlocksBegin = Sha256Hash.ZERO_HASH;
                    this.blockChainDownload(Sha256Hash.ZERO_HASH);
                    return;
                }
                this.invokeOnBlocksDownloaded(header);
            }
            if (m.getBlockHeaders().size() >= 2000) {
                this.blockChainDownload(Sha256Hash.ZERO_HASH);
            }
        }
        catch (VerificationException e) {
            log.warn("Block header verification failed", (Throwable)e);
        }
        catch (PrunedException e) {
            throw new RuntimeException(e);
        }
    }

    private void processGetData(GetDataMessage getdata) throws IOException {
        log.info("{}: Received getdata message: {}", (Object)this.vAddress, (Object)getdata.toString());
        ArrayList<Message> items = new ArrayList<Message>();
        for (PeerEventListener listener : this.eventListeners) {
            List<Message> listenerItems = listener.getData(this, getdata);
            if (listenerItems == null) continue;
            items.addAll(listenerItems);
        }
        if (items.size() == 0) {
            return;
        }
        log.info("{}: Sending {} items gathered from listeners to peer", (Object)this.vAddress, (Object)items.size());
        for (Message item : items) {
            this.sendMessage(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransaction(Transaction tx) throws VerificationException, IOException {
        this.lock.lock();
        try {
            log.debug("{}: Received tx {}", (Object)this.vAddress, (Object)tx.getHashAsString());
            if (this.memoryPool != null) {
                tx = this.memoryPool.seen(tx, this.getAddress());
            }
            final Transaction fTx = tx;
            fTx.getConfidence().setSource(TransactionConfidence.Source.NETWORK);
            if (this.maybeHandleRequestedData(fTx)) {
                return;
            }
            if (this.currentFilteredBlock != null) {
                if (!this.currentFilteredBlock.provideTransaction(tx)) {
                    this.endFilteredBlock(this.currentFilteredBlock);
                    this.currentFilteredBlock = null;
                }
                return;
            }
            for (final Wallet wallet : this.wallets) {
                try {
                    if (!wallet.isPendingTransactionRelevant(fTx)) continue;
                    Futures.addCallback(this.downloadDependencies(fTx), (FutureCallback)new FutureCallback<List<Transaction>>(){

                        public void onSuccess(List<Transaction> dependencies) {
                            try {
                                log.info("{}: Dependency download complete!", (Object)Peer.this.vAddress);
                                wallet.receivePending(fTx, dependencies);
                            }
                            catch (VerificationException e) {
                                log.error("{}: Wallet failed to process pending transaction {}", (Object)Peer.this.vAddress, (Object)fTx.getHashAsString());
                                log.error("Error was: ", (Throwable)e);
                            }
                        }

                        public void onFailure(Throwable throwable) {
                            log.error("Could not download dependencies of tx {}", (Object)fTx.getHashAsString());
                            log.error("Error was: ", throwable);
                        }
                    });
                }
                catch (VerificationException e) {
                    log.error("Wallet failed to verify tx", (Throwable)e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        for (PeerEventListener listener : this.eventListeners) {
            listener.onTransaction(this, tx);
        }
    }

    public ListenableFuture<List<Transaction>> downloadDependencies(Transaction tx) {
        TransactionConfidence.ConfidenceType txConfidence = tx.getConfidence().getConfidenceType();
        Preconditions.checkArgument((txConfidence != TransactionConfidence.ConfidenceType.BUILDING ? 1 : 0) != 0);
        log.info("{}: Downloading dependencies of {}", (Object)this.vAddress, (Object)tx.getHashAsString());
        final LinkedList<Transaction> results = new LinkedList<Transaction>();
        ListenableFuture<Object> future = this.downloadDependenciesInternal(tx, new Object(), results);
        final SettableFuture resultFuture = SettableFuture.create();
        Futures.addCallback(future, (FutureCallback)new FutureCallback(){

            public void onSuccess(Object _) {
                resultFuture.set((Object)results);
            }

            public void onFailure(Throwable throwable) {
                resultFuture.setException(throwable);
            }
        });
        return resultFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<Object> downloadDependenciesInternal(Transaction tx, final Object marker, final List<Transaction> results) {
        final SettableFuture resultFuture = SettableFuture.create();
        final Sha256Hash rootTxHash = tx.getHash();
        CopyOnWriteArraySet<Transaction> dependencies = new CopyOnWriteArraySet<Transaction>();
        CopyOnWriteArraySet<Sha256Hash> needToRequest = new CopyOnWriteArraySet<Sha256Hash>();
        for (TransactionInput input : tx.getInputs()) {
            Sha256Hash hash = input.getOutpoint().getHash();
            Transaction dep = this.memoryPool.get(hash);
            if (dep == null) {
                needToRequest.add(hash);
                continue;
            }
            dependencies.add(dep);
        }
        results.addAll(dependencies);
        this.lock.lock();
        try {
            ArrayList futures = Lists.newArrayList();
            GetDataMessage getdata = new GetDataMessage(this.params);
            final long nonce = (long)(Math.random() * 9.223372036854776E18);
            if (needToRequest.size() > 1) {
                log.info("{}: Requesting {} transactions for dep resolution", (Object)needToRequest.size());
            }
            for (Sha256Hash hash : needToRequest) {
                getdata.addTransaction(hash);
                GetDataRequest req = new GetDataRequest();
                req.hash = hash;
                req.future = SettableFuture.create();
                if (!this.isNotFoundMessageSupported()) {
                    req.nonce = nonce;
                }
                futures.add(req.future);
                this.getDataFutures.add(req);
            }
            for (Transaction dep : dependencies) {
                futures.add(Futures.immediateFuture((Object)dep));
            }
            ListenableFuture successful = Futures.successfulAsList((Iterable)futures);
            Futures.addCallback((ListenableFuture)successful, (FutureCallback)new FutureCallback<List<Transaction>>(){

                public void onSuccess(List<Transaction> transactions) {
                    LinkedList childFutures = Lists.newLinkedList();
                    for (Transaction tx : transactions) {
                        if (tx == null) continue;
                        log.info("{}: Downloaded dependency of {}: {}", new Object[]{Peer.this.vAddress, rootTxHash, tx.getHashAsString()});
                        results.add(tx);
                        childFutures.add(Peer.this.downloadDependenciesInternal(tx, marker, results));
                    }
                    if (childFutures.size() == 0) {
                        resultFuture.set(marker);
                    } else {
                        Futures.addCallback((ListenableFuture)Futures.successfulAsList((Iterable)childFutures), (FutureCallback)new FutureCallback<List<Object>>(){

                            public void onSuccess(List<Object> objects) {
                                resultFuture.set(marker);
                            }

                            public void onFailure(Throwable throwable) {
                                resultFuture.setException(throwable);
                            }
                        });
                    }
                }

                public void onFailure(Throwable throwable) {
                    resultFuture.setException(throwable);
                }
            });
            this.sendMessage(getdata);
            if (!this.isNotFoundMessageSupported()) {
                log.info("{}: Dep resolution waiting for a pong with nonce {}", (Object)this, (Object)nonce);
                this.ping(nonce).addListener(new Runnable(){

                    @Override
                    public void run() {
                        for (GetDataRequest req : Peer.this.getDataFutures) {
                            if (req.nonce != nonce) continue;
                            log.info("{}: Bottomed out dep tree at {}", (Object)this, (Object)req.hash);
                            req.future.cancel(true);
                            Peer.this.getDataFutures.remove(req);
                        }
                    }
                }, (Executor)MoreExecutors.sameThreadExecutor());
            }
        }
        catch (Exception e) {
            log.error("{}: Couldn't send getdata in downloadDependencies({})", (Object)this, (Object)tx.getHash());
            resultFuture.setException((Throwable)e);
            SettableFuture settableFuture = resultFuture;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
        return resultFuture;
    }

    private void processBlock(Block m) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("{}: Received broadcast block {}", (Object)this.vAddress, (Object)m.getHashAsString());
        }
        if (this.maybeHandleRequestedData(m)) {
            return;
        }
        if (!this.vDownloadData) {
            log.debug("{}: Received block we did not ask for: {}", (Object)this.vAddress, (Object)m.getHashAsString());
            return;
        }
        this.pendingBlockDownloads.remove(m.getHash());
        try {
            if (this.blockChain.add(m)) {
                this.invokeOnBlocksDownloaded(m);
            } else if (this.downloadBlockBodies) {
                this.blockChainDownload(this.blockChain.getOrphanRoot(m.getHash()).getHash());
            } else {
                log.info("Did not start chain download on solved block due to in-flight header download.");
            }
        }
        catch (VerificationException e) {
            log.warn("{}: Block verification failed", (Object)this.vAddress, (Object)e);
        }
        catch (PrunedException e) {
            throw new RuntimeException(e);
        }
    }

    private void endFilteredBlock(FilteredBlock m) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("{}: Received broadcast filtered block {}", (Object)this.vAddress, (Object)m.getHash().toString());
        }
        if (!this.vDownloadData) {
            log.debug("{}: Received block we did not ask for: {}", (Object)this.vAddress, (Object)m.getHash().toString());
            return;
        }
        this.pendingBlockDownloads.remove(m.getBlockHeader().getHash());
        try {
            if (this.blockChain.add(m)) {
                this.invokeOnBlocksDownloaded(m.getBlockHeader());
            } else {
                this.blockChainDownload(this.blockChain.getOrphanRoot(m.getHash()).getHash());
            }
        }
        catch (VerificationException e) {
            log.warn("{}: FilteredBlock verification failed", (Object)this.vAddress, (Object)e);
        }
        catch (PrunedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean maybeHandleRequestedData(Message m) {
        boolean found = false;
        Sha256Hash hash = m.getHash();
        for (GetDataRequest req : this.getDataFutures) {
            if (!hash.equals(req.hash)) continue;
            req.future.set((Object)m);
            this.getDataFutures.remove(req);
            found = true;
        }
        return found;
    }

    private void invokeOnBlocksDownloaded(Block m) {
        int blocksLeft = Math.max(0, (int)this.vPeerVersionMessage.bestHeight - this.blockChain.getBestChainHeight());
        for (PeerEventListener listener : this.eventListeners) {
            listener.onBlocksDownloaded(this, m, blocksLeft);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInv(InventoryMessage inv) throws IOException {
        List<InventoryItem> items = inv.getItems();
        LinkedList<InventoryItem> transactions = new LinkedList<InventoryItem>();
        LinkedList<InventoryItem> blocks = new LinkedList<InventoryItem>();
        block7: for (InventoryItem item : items) {
            switch (item.type) {
                case Transaction: {
                    transactions.add(item);
                    continue block7;
                }
                case Block: {
                    blocks.add(item);
                    continue block7;
                }
            }
            throw new IllegalStateException("Not implemented: " + (Object)((Object)item.type));
        }
        boolean downloadData = this.vDownloadData;
        if (transactions.size() == 0 && blocks.size() == 1) {
            if (downloadData) {
                if (!this.blockChain.isOrphan(((InventoryItem)blocks.get((int)0)).hash)) {
                    this.blocksAnnounced.incrementAndGet();
                }
            } else {
                this.blocksAnnounced.incrementAndGet();
            }
        }
        GetDataMessage getdata = new GetDataMessage(this.params);
        Iterator it = transactions.iterator();
        while (it.hasNext()) {
            InventoryItem item = (InventoryItem)it.next();
            if (this.memoryPool == null) {
                if (!downloadData) continue;
                getdata.addItem(item);
                continue;
            }
            if (this.memoryPool.maybeWasSeen(item.hash)) {
                it.remove();
            } else {
                log.debug("{}: getdata on tx {}", (Object)this.vAddress, (Object)item.hash);
                getdata.addItem(item);
            }
            this.memoryPool.seen(item.hash, this.getAddress());
        }
        boolean pingAfterGetData = false;
        this.lock.lock();
        try {
            if (blocks.size() > 0 && downloadData && this.blockChain != null) {
                for (InventoryItem item : blocks) {
                    if (this.blockChain.isOrphan(item.hash) && this.downloadBlockBodies) {
                        this.blockChainDownload(this.blockChain.getOrphanRoot(item.hash).getHash());
                        continue;
                    }
                    if (this.pendingBlockDownloads.contains(item.hash)) continue;
                    if (this.vPeerVersionMessage.isBloomFilteringSupported() && this.useFilteredBlocks) {
                        getdata.addItem(new InventoryItem(InventoryItem.Type.FilteredBlock, item.hash));
                        pingAfterGetData = true;
                    } else {
                        getdata.addItem(item);
                    }
                    this.pendingBlockDownloads.add(item.hash);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!getdata.getItems().isEmpty()) {
            this.sendMessage(getdata);
        }
        if (pingAfterGetData) {
            this.sendMessage(new Ping((long)(Math.random() * 9.223372036854776E18)));
        }
    }

    public ListenableFuture<Block> getBlock(Sha256Hash blockHash) throws IOException {
        log.info("Request to fetch block {}", (Object)blockHash);
        GetDataMessage getdata = new GetDataMessage(this.params);
        getdata.addBlock(blockHash);
        return this.sendSingleGetData(getdata);
    }

    public ListenableFuture<Transaction> getPeerMempoolTransaction(Sha256Hash hash) throws IOException {
        log.info("Request to fetch peer mempool tx  {}", (Object)hash);
        GetDataMessage getdata = new GetDataMessage(this.params);
        getdata.addTransaction(hash);
        return this.sendSingleGetData(getdata);
    }

    private ListenableFuture sendSingleGetData(GetDataMessage getdata) throws IOException {
        Preconditions.checkArgument((getdata.getItems().size() == 1 ? 1 : 0) != 0);
        GetDataRequest req = new GetDataRequest();
        req.future = SettableFuture.create();
        req.hash = getdata.getItems().get((int)0).hash;
        this.getDataFutures.add(req);
        this.sendMessage(getdata);
        return req.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDownloadParameters(long secondsSinceEpoch, boolean useFilteredBlocks) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)this.blockChain);
            if (secondsSinceEpoch == 0L) {
                this.fastCatchupTimeSecs = this.params.genesisBlock.getTimeSeconds();
                this.downloadBlockBodies = true;
            } else {
                this.fastCatchupTimeSecs = secondsSinceEpoch;
                if (this.fastCatchupTimeSecs > this.blockChain.getChainHead().getHeader().getTimeSeconds()) {
                    this.downloadBlockBodies = false;
                }
            }
            this.useFilteredBlocks = useFilteredBlocks;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addWallet(Wallet wallet) {
        this.wallets.add(wallet);
    }

    public void removeWallet(Wallet wallet) {
        this.wallets.remove(wallet);
    }

    public ChannelFuture sendMessage(Message m) {
        return Channels.write((Channel)this.vChannel, (Object)m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockChainDownload(Sha256Hash toHash) throws IOException {
        this.lock.lock();
        try {
            ArrayList<Sha256Hash> blockLocator = new ArrayList<Sha256Hash>(51);
            BlockStore store = this.blockChain.getBlockStore();
            StoredBlock chainHead = this.blockChain.getChainHead();
            Sha256Hash chainHeadHash = chainHead.getHeader().getHash();
            if (Objects.equal((Object)this.lastGetBlocksBegin, (Object)chainHeadHash) && Objects.equal((Object)this.lastGetBlocksEnd, (Object)toHash)) {
                log.info("blockChainDownload({}): ignoring duplicated request", (Object)toHash.toString());
                return;
            }
            log.debug("{}: blockChainDownload({}) current head = {}", new Object[]{this.toString(), toHash.toString(), chainHead.getHeader().getHashAsString()});
            StoredBlock cursor = chainHead;
            for (int i = 100; cursor != null && i > 0; cursor = cursor.getPrev(store), --i) {
                blockLocator.add(cursor.getHeader().getHash());
                try {
                    continue;
                }
                catch (BlockStoreException e) {
                    log.error("Failed to walk the block chain whilst constructing a locator");
                    throw new RuntimeException(e);
                }
            }
            if (cursor != null) {
                blockLocator.add(this.params.genesisBlock.getHash());
            }
            this.lastGetBlocksBegin = chainHeadHash;
            this.lastGetBlocksEnd = toHash;
            if (this.downloadBlockBodies) {
                GetBlocksMessage message = new GetBlocksMessage(this.params, blockLocator, toHash);
                this.sendMessage(message);
            } else {
                GetHeadersMessage message = new GetHeadersMessage(this.params, blockLocator, toHash);
                this.sendMessage(message);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void startBlockChainDownload() throws IOException {
        this.setDownloadData(true);
        int blocksLeft = this.getPeerBlockHeightDifference();
        if (blocksLeft >= 0) {
            for (PeerEventListener listener : this.eventListeners) {
                listener.onChainDownloadStarted(this, blocksLeft);
            }
            this.blockChainDownload(Sha256Hash.ZERO_HASH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPingTimeData(long sample) {
        this.lastPingTimesLock.lock();
        try {
            if (this.lastPingTimes == null) {
                this.lastPingTimes = new long[20];
                Arrays.fill(this.lastPingTimes, sample);
            } else {
                System.arraycopy(this.lastPingTimes, 1, this.lastPingTimes, 0, this.lastPingTimes.length - 1);
                this.lastPingTimes[this.lastPingTimes.length - 1] = sample;
            }
        }
        finally {
            this.lastPingTimesLock.unlock();
        }
    }

    public ListenableFuture<Long> ping() throws IOException, ProtocolException {
        return this.ping((long)(Math.random() * 9.223372036854776E18));
    }

    protected ListenableFuture<Long> ping(long nonce) throws IOException, ProtocolException {
        VersionMessage ver = this.vPeerVersionMessage;
        if (!ver.isPingPongSupported()) {
            throw new ProtocolException("Peer version is too low for measurable pings: " + ver);
        }
        PendingPing pendingPing = new PendingPing(nonce);
        this.pendingPings.add(pendingPing);
        this.sendMessage(new Ping(pendingPing.nonce));
        return pendingPing.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastPingTime() {
        this.lastPingTimesLock.lock();
        try {
            if (this.lastPingTimes == null) {
                long l = Long.MAX_VALUE;
                return l;
            }
            long l = this.lastPingTimes[this.lastPingTimes.length - 1];
            return l;
        }
        finally {
            this.lastPingTimesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPingTime() {
        this.lastPingTimesLock.lock();
        try {
            if (this.lastPingTimes == null) {
                long l = Long.MAX_VALUE;
                return l;
            }
            long sum = 0L;
            for (long i : this.lastPingTimes) {
                sum += i;
            }
            long l = (long)((double)sum / (double)this.lastPingTimes.length);
            return l;
        }
        finally {
            this.lastPingTimesLock.unlock();
        }
    }

    private void processPong(Pong m) {
        for (PendingPing ping : this.pendingPings) {
            if (m.getNonce() != ping.nonce) continue;
            this.pendingPings.remove(ping);
            ping.complete();
            return;
        }
    }

    public int getPeerBlockHeightDifference() {
        int chainHeight = (int)this.getBestHeight();
        Preconditions.checkState((this.params.allowEmptyPeerChains || chainHeight > 0 ? 1 : 0) != 0, (String)"Connected to peer with zero/negative chain height", (Object[])new Object[]{chainHeight});
        return chainHeight - this.blockChain.getBestChainHeight();
    }

    private boolean isNotFoundMessageSupported() {
        return this.vPeerVersionMessage.clientVersion >= 70001;
    }

    public boolean getDownloadData() {
        return this.vDownloadData;
    }

    public void setDownloadData(boolean downloadData) {
        this.vDownloadData = downloadData;
    }

    public PeerAddress getAddress() {
        return this.vAddress;
    }

    public VersionMessage getPeerVersionMessage() {
        return this.vPeerVersionMessage;
    }

    public VersionMessage getVersionMessage() {
        return this.versionMessage;
    }

    public long getBestHeight() {
        return this.vPeerVersionMessage.bestHeight + (long)this.blocksAnnounced.get();
    }

    public ChannelFuture setMinProtocolVersion(int minProtocolVersion) {
        this.vMinProtocolVersion = minProtocolVersion;
        if (this.getVersionMessage().clientVersion < minProtocolVersion) {
            log.warn("{}: Disconnecting due to new min protocol version {}", (Object)this, (Object)minProtocolVersion);
            return Channels.close((Channel)this.vChannel);
        }
        return null;
    }

    public void setBloomFilter(BloomFilter filter) throws IOException {
        Preconditions.checkNotNull((Object)filter, (Object)"Clearing filters is not currently supported");
        VersionMessage ver = this.vPeerVersionMessage;
        if (ver == null || !ver.isBloomFilteringSupported()) {
            return;
        }
        this.vBloomFilter = filter;
        boolean shouldQueryMemPool = this.memoryPool != null || this.vDownloadData;
        log.info("{}: Sending Bloom filter{}", (Object)this, (Object)(shouldQueryMemPool ? " and querying mempool" : ""));
        ChannelFuture future = this.sendMessage(filter);
        if (shouldQueryMemPool) {
            future.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    Peer.this.sendMessage(new MemoryPoolMessage());
                }
            });
        }
    }

    public BloomFilter getBloomFilter() {
        return this.vBloomFilter;
    }

    private class PendingPing {
        public SettableFuture<Long> future = SettableFuture.create();
        public final long nonce;
        public final long startTimeMsec;

        public PendingPing(long nonce) {
            this.nonce = nonce;
            this.startTimeMsec = Utils.now().getTime();
        }

        public void complete() {
            Preconditions.checkNotNull(this.future, (Object)"Already completed");
            Long elapsed = Utils.now().getTime() - this.startTimeMsec;
            Peer.this.addPingTimeData(elapsed);
            log.debug("{}: ping time is {} msec", (Object)Peer.this.toString(), (Object)elapsed);
            this.future.set((Object)elapsed);
            this.future = null;
        }
    }

    class PeerHandler
    extends SimpleChannelHandler {
        PeerHandler() {
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            super.channelClosed(ctx, e);
            Peer.this.notifyDisconnect();
        }

        public void connectRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Peer.this.vAddress = new PeerAddress((InetSocketAddress)e.getValue());
            Peer.this.vChannel = e.getChannel();
            super.connectRequested(ctx, e);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            String s;
            PeerAddress addr = Peer.this.vAddress;
            String string = s = addr == null ? "?" : addr.toString();
            if (e.getCause() instanceof ConnectException || e.getCause() instanceof IOException) {
                log.info(s + " - " + e.getCause().getMessage());
            } else {
                log.warn(s + " - ", e.getCause());
            }
            e.getChannel().close();
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Message m = (Message)e.getMessage();
            Peer.this.processMessage(e, m);
        }

        public Peer getPeer() {
            return Peer.this;
        }
    }

    private static class GetDataRequest {
        Sha256Hash hash;
        SettableFuture future;
        long nonce;

        private GetDataRequest() {
        }
    }

    static interface PeerLifecycleListener {
        public void onPeerConnected(Peer var1);

        public void onPeerDisconnected(Peer var1);
    }
}

