/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Utils;
import java.io.IOException;
import java.io.OutputStream;

public class Ping
extends Message {
    private long nonce;
    private boolean hasNonce;

    public Ping(NetworkParameters params, byte[] payloadBytes) throws ProtocolException {
        super(params, payloadBytes, 0);
    }

    public Ping(long nonce) {
        this.nonce = nonce;
        this.hasNonce = true;
    }

    public Ping() {
        this.hasNonce = false;
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        if (this.hasNonce) {
            Utils.int64ToByteStreamLE(this.nonce, stream);
        }
    }

    @Override
    void parse() throws ProtocolException {
        try {
            this.nonce = this.readInt64();
            this.hasNonce = true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.hasNonce = false;
        }
        this.length = this.hasNonce ? 8 : 0;
    }

    @Override
    protected void parseLite() {
    }

    boolean hasNonce() {
        return this.hasNonce;
    }

    long getNonce() {
        return this.nonce;
    }
}

