/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.VerificationException;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class TransactionConfidence
implements Serializable {
    private static final long serialVersionUID = 4577920141400556444L;
    private CopyOnWriteArrayList<PeerAddress> broadcastBy;
    private Transaction transaction;
    private transient CopyOnWriteArrayList<Listener> listeners;
    private int depth;
    private BigInteger workDone = BigInteger.ZERO;
    private ConfidenceType confidenceType = ConfidenceType.UNKNOWN;
    private int appearedAtChainHeight = -1;
    private Transaction overridingTransaction;
    private Source source = Source.UNKNOWN;

    public TransactionConfidence(Transaction tx) {
        this.broadcastBy = new CopyOnWriteArrayList();
        this.listeners = new CopyOnWriteArrayList();
        this.transaction = tx;
    }

    public void addEventListener(Listener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.listeners.addIfAbsent(listener);
    }

    public void removeEventListener(Listener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.listeners.remove(listener);
    }

    public synchronized int getAppearedAtChainHeight() {
        if (this.getConfidenceType() != ConfidenceType.BUILDING) {
            throw new IllegalStateException("Confidence type is " + (Object)((Object)this.getConfidenceType()) + ", not BUILDING");
        }
        return this.appearedAtChainHeight;
    }

    public synchronized void setAppearedAtChainHeight(int appearedAtChainHeight) {
        if (appearedAtChainHeight < 0) {
            throw new IllegalArgumentException("appearedAtChainHeight out of range");
        }
        this.appearedAtChainHeight = appearedAtChainHeight;
        this.setConfidenceType(ConfidenceType.BUILDING);
    }

    public synchronized ConfidenceType getConfidenceType() {
        return this.confidenceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfidenceType(ConfidenceType confidenceType) {
        TransactionConfidence transactionConfidence = this;
        synchronized (transactionConfidence) {
            if (confidenceType == this.confidenceType) {
                return;
            }
            this.confidenceType = confidenceType;
        }
        this.runListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markBroadcastBy(PeerAddress address) {
        if (!this.broadcastBy.addIfAbsent(address)) {
            return;
        }
        TransactionConfidence transactionConfidence = this;
        synchronized (transactionConfidence) {
            if (this.getConfidenceType() == ConfidenceType.UNKNOWN) {
                this.confidenceType = ConfidenceType.NOT_SEEN_IN_CHAIN;
            }
        }
        this.runListeners();
    }

    public int numBroadcastPeers() {
        return this.broadcastBy.size();
    }

    public ListIterator<PeerAddress> getBroadcastBy() {
        return this.broadcastBy.listIterator();
    }

    public boolean wasBroadcastBy(PeerAddress address) {
        return this.broadcastBy.contains(address);
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        int peers = this.numBroadcastPeers();
        if (peers > 0) {
            builder.append("Seen by ");
            builder.append(peers);
            if (peers > 1) {
                builder.append(" peers. ");
            } else {
                builder.append(" peer. ");
            }
        }
        switch (this.getConfidenceType()) {
            case UNKNOWN: {
                builder.append("Unknown confidence level.");
                break;
            }
            case DEAD: {
                builder.append("Dead: overridden by double spend and will not confirm.");
                break;
            }
            case NOT_IN_BEST_CHAIN: {
                builder.append("Seen in side chain but not best chain.");
                break;
            }
            case NOT_SEEN_IN_CHAIN: {
                builder.append("Not seen in chain.");
                break;
            }
            case BUILDING: {
                builder.append(String.format("Appeared in best chain at height %d, depth %d, work done %s.", this.getAppearedAtChainHeight(), this.getDepthInBlocks(), this.getWorkDone()));
            }
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWorkDone(Block block) throws VerificationException {
        boolean notify = false;
        TransactionConfidence transactionConfidence = this;
        synchronized (transactionConfidence) {
            if (this.getConfidenceType() == ConfidenceType.BUILDING) {
                ++this.depth;
                this.workDone = this.workDone.add(block.getWork());
                notify = true;
            }
        }
        if (notify) {
            this.runListeners();
        }
    }

    public synchronized int getDepthInBlocks() {
        if (this.getConfidenceType() != ConfidenceType.BUILDING) {
            throw new IllegalStateException("Confidence type is not BUILDING");
        }
        return this.depth;
    }

    public synchronized void setDepthInBlocks(int depth) {
        this.depth = depth;
    }

    public synchronized BigInteger getWorkDone() {
        if (this.getConfidenceType() != ConfidenceType.BUILDING) {
            throw new IllegalStateException("Confidence type is not BUILDING");
        }
        return this.workDone;
    }

    public synchronized void setWorkDone(BigInteger workDone) {
        this.workDone = workDone;
    }

    public synchronized Transaction getOverridingTransaction() {
        if (this.getConfidenceType() != ConfidenceType.DEAD) {
            throw new IllegalStateException("Confidence type is " + (Object)((Object)this.getConfidenceType()) + ", not OVERRIDDEN_BY_DOUBLE_SPEND");
        }
        return this.overridingTransaction;
    }

    public synchronized void setOverridingTransaction(Transaction overridingTransaction) {
        this.overridingTransaction = overridingTransaction;
        this.setConfidenceType(ConfidenceType.DEAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TransactionConfidence duplicate() {
        TransactionConfidence c;
        TransactionConfidence transactionConfidence = c = new TransactionConfidence(this.transaction);
        synchronized (transactionConfidence) {
            c.broadcastBy.addAll(this.broadcastBy);
            c.confidenceType = this.confidenceType;
            c.overridingTransaction = this.overridingTransaction;
            c.appearedAtChainHeight = this.appearedAtChainHeight;
            return c;
        }
    }

    private void runListeners() {
        for (Listener listener : this.listeners) {
            listener.onConfidenceChanged(this.transaction);
        }
    }

    public synchronized Source getSource() {
        return this.source;
    }

    public synchronized void setSource(Source source) {
        this.source = source;
    }

    public static interface Listener {
        public void onConfidenceChanged(Transaction var1);
    }

    public static enum Source {
        UNKNOWN,
        NETWORK,
        SELF;

    }

    public static enum ConfidenceType {
        BUILDING(1),
        NOT_SEEN_IN_CHAIN(2),
        NOT_IN_BEST_CHAIN(3),
        DEAD(4),
        UNKNOWN(0);

        private int value;

        private ConfidenceType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ConfidenceType valueOf(int value) {
            switch (value) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return BUILDING;
                }
                case 2: {
                    return NOT_SEEN_IN_CHAIN;
                }
                case 3: {
                    return NOT_IN_BEST_CHAIN;
                }
                case 4: {
                    return DEAD;
                }
            }
            return null;
        }
    }
}

