/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.store;

import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.StoredTransactionOutput;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.TransactionOutput;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

class StoredTransaction
implements Serializable {
    private static final long serialVersionUID = 6243881368122528323L;
    private List<StoredTransactionOutput> outputs;
    private List<TransactionInput> inputs = new LinkedList<TransactionInput>();
    private long version;
    private long lockTime;
    private Sha256Hash hash;

    public StoredTransaction(NetworkParameters params, Transaction tx, int height) {
        this.outputs = new LinkedList<StoredTransactionOutput>();
        for (TransactionInput in : tx.getInputs()) {
            this.inputs.add(new TransactionInput(params, null, in.getScriptBytes(), in.getOutpoint()));
        }
        for (TransactionOutput out : tx.getOutputs()) {
            this.outputs.add(new StoredTransactionOutput(null, out, height, tx.isCoinBase()));
        }
        this.version = tx.getVersion();
        this.lockTime = tx.getLockTime();
        this.hash = tx.getHash();
    }

    public List<TransactionInput> getInputs() {
        return this.inputs;
    }

    public List<StoredTransactionOutput> getOutputs() {
        return this.outputs;
    }

    public Sha256Hash getHash() {
        return this.hash;
    }

    public long getLockTime() {
        return this.lockTime;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean isCoinBase() {
        return this.inputs.get(0).isCoinBase();
    }

    public String toString() {
        return "Stored Transaction: " + this.hash.toString();
    }

    public int hashCode() {
        return this.getHash().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StoredTransaction)) {
            return false;
        }
        return ((StoredTransaction)o).getHash().equals(this.getHash());
    }
}

