/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;

public class NamedSemaphores {
    private Map<String, Semaphore> lockMap = new HashMap<String, Semaphore>();

    public void acquire(String name) throws InterruptedException {
        Semaphore s = this.getSemaphore(name);
        s.acquire();
    }

    public boolean tryAcquire(String name) {
        Semaphore s = this.getSemaphore(name);
        return s.tryAcquire();
    }

    public void release(String name) {
        Semaphore s = this.getSemaphore(name);
        s.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Semaphore getSemaphore(String name) {
        Map<String, Semaphore> map = this.lockMap;
        synchronized (map) {
            Semaphore s = this.lockMap.get(name);
            if (s == null) {
                s = new Semaphore(1);
                this.lockMap.put(name, s);
            }
            return s;
        }
    }
}

