/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VarInt;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class BloomFilter
extends Message {
    private byte[] data;
    private long hashFuncs;
    private long nTweak;
    private byte nFlags;
    private static final long MAX_FILTER_SIZE = 36000L;
    private static final int MAX_HASH_FUNCS = 50;

    public BloomFilter(NetworkParameters params, byte[] payloadBytes) throws ProtocolException {
        super(params, payloadBytes, 0);
    }

    public BloomFilter(int elements, double falsePositiveRate, long randomNonce) {
        this(elements, falsePositiveRate, randomNonce, BloomUpdate.UPDATE_P2PUBKEY_ONLY);
    }

    public BloomFilter(int elements, double falsePositiveRate, long randomNonce, BloomUpdate updateFlag) {
        int size = Math.min((int)(-1.0 / Math.pow(Math.log(2.0), 2.0) * (double)elements * Math.log(falsePositiveRate)), 288000) / 8;
        this.data = new byte[size <= 0 ? 1 : size];
        this.hashFuncs = Math.min((int)((double)(this.data.length * 8) / (double)elements * Math.log(2.0)), 50);
        this.nTweak = randomNonce;
        this.nFlags = (byte)(0xFF & updateFlag.ordinal());
    }

    public double getFalsePositiveRate(int elements) {
        return Math.pow(1.0 - Math.pow(Math.E, -1.0 * (double)(this.hashFuncs * (long)elements) / (double)(this.data.length * 8)), this.hashFuncs);
    }

    public String toString() {
        return "Bloom Filter of size " + this.data.length + " with " + this.hashFuncs + " hash functions.";
    }

    @Override
    void parse() throws ProtocolException {
        this.data = this.readByteArray();
        if ((long)this.data.length > 36000L) {
            throw new ProtocolException("Bloom filter out of size range.");
        }
        this.hashFuncs = this.readUint32();
        if (this.hashFuncs > 50L) {
            throw new ProtocolException("Bloom filter hash function count out of range");
        }
        this.nTweak = this.readUint32();
        this.nFlags = this.readBytes(1)[0];
        this.length = this.cursor - this.offset;
    }

    @Override
    void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        stream.write(new VarInt(this.data.length).encode());
        stream.write(this.data);
        Utils.uint32ToByteStreamLE(this.hashFuncs, stream);
        Utils.uint32ToByteStreamLE(this.nTweak, stream);
        stream.write(this.nFlags);
    }

    @Override
    protected void parseLite() throws ProtocolException {
    }

    private int ROTL32(int x, int r) {
        return x << r | x >>> 32 - r;
    }

    private int hash(int hashNum, byte[] object) {
        int h1 = (int)((long)hashNum * 4221880213L + this.nTweak);
        int c1 = -862048943;
        int c2 = 461845907;
        int numBlocks = object.length / 4 * 4;
        for (int i = 0; i < numBlocks; i += 4) {
            int k1 = object[i] & 0xFF | (object[i + 1] & 0xFF) << 8 | (object[i + 2] & 0xFF) << 16 | (object[i + 3] & 0xFF) << 24;
            k1 *= -862048943;
            k1 = this.ROTL32(k1, 15);
            h1 ^= (k1 *= 461845907);
            h1 = this.ROTL32(h1, 13);
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (object.length & 3) {
            case 3: {
                k1 ^= (object[numBlocks + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 ^= (object[numBlocks + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 ^= object[numBlocks] & 0xFF;
                k1 *= -862048943;
                k1 = this.ROTL32(k1, 15);
                h1 ^= (k1 *= 461845907);
            }
        }
        h1 ^= object.length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return (int)(((long)h1 & 0xFFFFFFFFL) % (long)(this.data.length * 8));
    }

    public boolean contains(byte[] object) {
        int i = 0;
        while ((long)i < this.hashFuncs) {
            if (!Utils.checkBitLE(this.data, this.hash(i, object))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void insert(byte[] object) {
        int i = 0;
        while ((long)i < this.hashFuncs) {
            Utils.setBitLE(this.data, this.hash(i, object));
            ++i;
        }
    }

    public void merge(BloomFilter filter) {
        Preconditions.checkArgument((filter.data.length == this.data.length && filter.hashFuncs == this.hashFuncs && filter.nTweak == this.nTweak ? 1 : 0) != 0);
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = (byte)(this.data[n] | filter.data[i]);
        }
    }

    public boolean equals(Object other) {
        return other instanceof BloomFilter && ((BloomFilter)other).hashFuncs == this.hashFuncs && ((BloomFilter)other).nTweak == this.nTweak && Arrays.equals(((BloomFilter)other).data, this.data);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hashFuncs, this.nTweak, Arrays.hashCode(this.data)});
    }

    public static enum BloomUpdate {
        UPDATE_NONE,
        UPDATE_ALL,
        UPDATE_P2PUBKEY_ONLY;

    }
}

