/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadersMessage
extends Message {
    private static final Logger log = LoggerFactory.getLogger(HeadersMessage.class);
    public static final int MAX_HEADERS = 2000;
    private List<Block> blockHeaders;

    public HeadersMessage(NetworkParameters params, byte[] payload) throws ProtocolException {
        super(params, payload, 0);
    }

    public HeadersMessage(NetworkParameters params, Block ... headers) throws ProtocolException {
        super(params);
        this.blockHeaders = Arrays.asList(headers);
    }

    @Override
    protected void parseLite() throws ProtocolException {
        if (this.length == Integer.MIN_VALUE) {
            int saveCursor = this.cursor;
            long numHeaders = this.readVarInt();
            this.cursor = saveCursor;
            this.length = 81 * (int)numHeaders;
        }
    }

    @Override
    void parse() throws ProtocolException {
        long numHeaders = this.readVarInt();
        if (numHeaders > 2000L) {
            throw new ProtocolException("Too many headers: got " + numHeaders + " which is larger than " + 2000);
        }
        this.blockHeaders = new ArrayList<Block>();
        int i = 0;
        while ((long)i < numHeaders) {
            byte[] blockHeader = this.readBytes(81);
            if (blockHeader[80] != 0) {
                throw new ProtocolException("Block header does not end with a null byte");
            }
            Block newBlockHeader = new Block(this.params, blockHeader, true, true, 81);
            this.blockHeaders.add(newBlockHeader);
            ++i;
        }
        if (log.isDebugEnabled()) {
            i = 0;
            while ((long)i < numHeaders) {
                log.debug(this.blockHeaders.get(i).toString());
                ++i;
            }
        }
    }

    public List<Block> getBlockHeaders() {
        return this.blockHeaders;
    }
}

