/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ScriptChunk;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.UnsafeByteArrayOutputStream;
import com.google.bitcoin.core.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.spongycastle.crypto.digests.RIPEMD160Digest;

public class Script {
    public static final int OP_0 = 0;
    public static final int OP_FALSE = 0;
    public static final int OP_PUSHDATA1 = 76;
    public static final int OP_PUSHDATA2 = 77;
    public static final int OP_PUSHDATA4 = 78;
    public static final int OP_1NEGATE = 79;
    public static final int OP_RESERVED = 80;
    public static final int OP_1 = 81;
    public static final int OP_TRUE = 81;
    public static final int OP_2 = 82;
    public static final int OP_3 = 83;
    public static final int OP_4 = 84;
    public static final int OP_5 = 85;
    public static final int OP_6 = 86;
    public static final int OP_7 = 87;
    public static final int OP_8 = 88;
    public static final int OP_9 = 89;
    public static final int OP_10 = 90;
    public static final int OP_11 = 91;
    public static final int OP_12 = 92;
    public static final int OP_13 = 93;
    public static final int OP_14 = 94;
    public static final int OP_15 = 95;
    public static final int OP_16 = 96;
    public static final int OP_NOP = 97;
    public static final int OP_VER = 98;
    public static final int OP_IF = 99;
    public static final int OP_NOTIF = 100;
    public static final int OP_VERIF = 101;
    public static final int OP_VERNOTIF = 102;
    public static final int OP_ELSE = 103;
    public static final int OP_ENDIF = 104;
    public static final int OP_VERIFY = 105;
    public static final int OP_RETURN = 106;
    public static final int OP_TOALTSTACK = 107;
    public static final int OP_FROMALTSTACK = 108;
    public static final int OP_2DROP = 109;
    public static final int OP_2DUP = 110;
    public static final int OP_3DUP = 111;
    public static final int OP_2OVER = 112;
    public static final int OP_2ROT = 113;
    public static final int OP_2SWAP = 114;
    public static final int OP_IFDUP = 115;
    public static final int OP_DEPTH = 116;
    public static final int OP_DROP = 117;
    public static final int OP_DUP = 118;
    public static final int OP_NIP = 119;
    public static final int OP_OVER = 120;
    public static final int OP_PICK = 121;
    public static final int OP_ROLL = 122;
    public static final int OP_ROT = 123;
    public static final int OP_SWAP = 124;
    public static final int OP_TUCK = 125;
    public static final int OP_CAT = 126;
    public static final int OP_SUBSTR = 127;
    public static final int OP_LEFT = 128;
    public static final int OP_RIGHT = 129;
    public static final int OP_SIZE = 130;
    public static final int OP_INVERT = 131;
    public static final int OP_AND = 132;
    public static final int OP_OR = 133;
    public static final int OP_XOR = 134;
    public static final int OP_EQUAL = 135;
    public static final int OP_EQUALVERIFY = 136;
    public static final int OP_RESERVED1 = 137;
    public static final int OP_RESERVED2 = 138;
    public static final int OP_1ADD = 139;
    public static final int OP_1SUB = 140;
    public static final int OP_2MUL = 141;
    public static final int OP_2DIV = 142;
    public static final int OP_NEGATE = 143;
    public static final int OP_ABS = 144;
    public static final int OP_NOT = 145;
    public static final int OP_0NOTEQUAL = 146;
    public static final int OP_ADD = 147;
    public static final int OP_SUB = 148;
    public static final int OP_MUL = 149;
    public static final int OP_DIV = 150;
    public static final int OP_MOD = 151;
    public static final int OP_LSHIFT = 152;
    public static final int OP_RSHIFT = 153;
    public static final int OP_BOOLAND = 154;
    public static final int OP_BOOLOR = 155;
    public static final int OP_NUMEQUAL = 156;
    public static final int OP_NUMEQUALVERIFY = 157;
    public static final int OP_NUMNOTEQUAL = 158;
    public static final int OP_LESSTHAN = 159;
    public static final int OP_GREATERTHAN = 160;
    public static final int OP_LESSTHANOREQUAL = 161;
    public static final int OP_GREATERTHANOREQUAL = 162;
    public static final int OP_MIN = 163;
    public static final int OP_MAX = 164;
    public static final int OP_WITHIN = 165;
    public static final int OP_RIPEMD160 = 166;
    public static final int OP_SHA1 = 167;
    public static final int OP_SHA256 = 168;
    public static final int OP_HASH160 = 169;
    public static final int OP_HASH256 = 170;
    public static final int OP_CODESEPARATOR = 171;
    public static final int OP_CHECKSIG = 172;
    public static final int OP_CHECKSIGVERIFY = 173;
    public static final int OP_CHECKMULTISIG = 174;
    public static final int OP_CHECKMULTISIGVERIFY = 175;
    public static final int OP_NOP1 = 176;
    public static final int OP_NOP2 = 177;
    public static final int OP_NOP3 = 178;
    public static final int OP_NOP4 = 179;
    public static final int OP_NOP5 = 180;
    public static final int OP_NOP6 = 181;
    public static final int OP_NOP7 = 182;
    public static final int OP_NOP8 = 183;
    public static final int OP_NOP9 = 184;
    public static final int OP_NOP10 = 185;
    public static final int OP_INVALIDOPCODE = 255;
    byte[] program;
    private int cursor;
    List<ScriptChunk> chunks;
    private final NetworkParameters params;

    private Script() {
        this.params = null;
    }

    public Script(NetworkParameters params, byte[] programBytes, int offset, int length) throws ScriptException {
        this.params = params;
        this.parse(programBytes, offset, length);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (ScriptChunk chunk : this.chunks) {
            if (chunk.isOpCode) {
                buf.append(Script.getOpCodeName(chunk.data[0]));
                buf.append(" ");
                continue;
            }
            buf.append("[");
            buf.append(Utils.bytesToHexString(chunk.data));
            buf.append("] ");
        }
        return buf.toString();
    }

    public static String getOpCodeName(byte opCode) {
        int opcode = opCode & 0xFF;
        switch (opcode) {
            case 0: {
                return "0";
            }
            case 76: {
                return "PUSHDATA1";
            }
            case 77: {
                return "PUSHDATA1";
            }
            case 78: {
                return "PUSHDATA4";
            }
            case 79: {
                return "1NEGATE";
            }
            case 80: {
                return "RESERVED";
            }
            case 81: {
                return "1";
            }
            case 82: {
                return "2";
            }
            case 83: {
                return "3";
            }
            case 84: {
                return "4";
            }
            case 85: {
                return "5";
            }
            case 86: {
                return "6";
            }
            case 87: {
                return "7";
            }
            case 88: {
                return "8";
            }
            case 89: {
                return "9";
            }
            case 90: {
                return "10";
            }
            case 91: {
                return "11";
            }
            case 92: {
                return "12";
            }
            case 93: {
                return "13";
            }
            case 94: {
                return "14";
            }
            case 95: {
                return "15";
            }
            case 96: {
                return "16";
            }
            case 97: {
                return "NOP";
            }
            case 98: {
                return "VER";
            }
            case 99: {
                return "IF";
            }
            case 100: {
                return "NOTIF";
            }
            case 101: {
                return "VERIF";
            }
            case 102: {
                return "VERNOTIF";
            }
            case 103: {
                return "ELSE";
            }
            case 104: {
                return "ENDIF";
            }
            case 105: {
                return "VERIFY";
            }
            case 106: {
                return "RETURN";
            }
            case 107: {
                return "TOALTSTACK";
            }
            case 108: {
                return "FROMALTSTACK";
            }
            case 109: {
                return "2DROP";
            }
            case 110: {
                return "2DUP";
            }
            case 111: {
                return "3DUP";
            }
            case 112: {
                return "2OVER";
            }
            case 113: {
                return "2ROT";
            }
            case 114: {
                return "2SWAP";
            }
            case 115: {
                return "IFDUP";
            }
            case 116: {
                return "DEPTH";
            }
            case 117: {
                return "DROP";
            }
            case 118: {
                return "DUP";
            }
            case 119: {
                return "NIP";
            }
            case 120: {
                return "OVER";
            }
            case 121: {
                return "PICK";
            }
            case 122: {
                return "ROLL";
            }
            case 123: {
                return "ROT";
            }
            case 124: {
                return "SWAP";
            }
            case 125: {
                return "TUCK";
            }
            case 126: {
                return "CAT";
            }
            case 127: {
                return "SUBSTR";
            }
            case 128: {
                return "LEFT";
            }
            case 129: {
                return "RIGHT";
            }
            case 130: {
                return "SIZE";
            }
            case 131: {
                return "INVERT";
            }
            case 132: {
                return "AND";
            }
            case 133: {
                return "OR";
            }
            case 134: {
                return "XOR";
            }
            case 135: {
                return "EQUAL";
            }
            case 136: {
                return "EQUALVERIFY";
            }
            case 137: {
                return "RESERVED1";
            }
            case 138: {
                return "RESERVED2";
            }
            case 139: {
                return "1ADD";
            }
            case 140: {
                return "1SUB";
            }
            case 141: {
                return "2MUL";
            }
            case 142: {
                return "2DIV";
            }
            case 143: {
                return "NEGATE";
            }
            case 144: {
                return "ABS";
            }
            case 145: {
                return "NOT";
            }
            case 146: {
                return "0NOTEQUAL";
            }
            case 147: {
                return "ADD";
            }
            case 148: {
                return "SUB";
            }
            case 149: {
                return "MUL";
            }
            case 150: {
                return "DIV";
            }
            case 151: {
                return "MOD";
            }
            case 152: {
                return "LSHIFT";
            }
            case 153: {
                return "RSHIFT";
            }
            case 154: {
                return "BOOLAND";
            }
            case 155: {
                return "BOOLOR";
            }
            case 156: {
                return "NUMEQUAL";
            }
            case 157: {
                return "NUMEQUALVERIFY";
            }
            case 158: {
                return "NUMNOTEQUAL";
            }
            case 159: {
                return "LESSTHAN";
            }
            case 160: {
                return "GREATERTHAN";
            }
            case 161: {
                return "LESSTHANOREQUAL";
            }
            case 162: {
                return "GREATERTHANOREQUAL";
            }
            case 163: {
                return "MIN";
            }
            case 164: {
                return "MAX";
            }
            case 165: {
                return "WITHIN";
            }
            case 166: {
                return "RIPEMD160";
            }
            case 167: {
                return "SHA1";
            }
            case 168: {
                return "SHA256";
            }
            case 169: {
                return "HASH160";
            }
            case 170: {
                return "HASH256";
            }
            case 171: {
                return "CODESEPARATOR";
            }
            case 172: {
                return "CHECKSIG";
            }
            case 173: {
                return "CHECKSIGVERIFY";
            }
            case 174: {
                return "CHECKMULTISIG";
            }
            case 175: {
                return "CHECKMULTISIGVERIFY";
            }
            case 176: {
                return "NOP1";
            }
            case 177: {
                return "NOP2";
            }
            case 178: {
                return "NOP3";
            }
            case 179: {
                return "NOP4";
            }
            case 180: {
                return "NOP5";
            }
            case 181: {
                return "NOP6";
            }
            case 182: {
                return "NOP7";
            }
            case 183: {
                return "NOP8";
            }
            case 184: {
                return "NOP9";
            }
            case 185: {
                return "NOP10";
            }
        }
        return "NON_OP(" + opcode + ")";
    }

    private byte[] getData(int len) throws ScriptException {
        if (len > this.program.length - this.cursor) {
            throw new ScriptException("Failed read of " + len + " bytes");
        }
        try {
            byte[] buf = new byte[len];
            System.arraycopy(this.program, this.cursor, buf, 0, len);
            this.cursor += len;
            return buf;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ScriptException("Failed read of " + len + " bytes", e);
        }
        catch (NegativeArraySizeException e) {
            throw new ScriptException("Failed read of " + len + " bytes", e);
        }
    }

    private int readByte() throws ScriptException {
        try {
            return 0xFF & this.program[this.cursor++];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ScriptException("Attempted to read outside of script boundaries");
        }
    }

    private void parse(byte[] programBytes, int offset, int length) throws ScriptException {
        this.program = new byte[length];
        System.arraycopy(programBytes, offset, this.program, 0, length);
        offset = 0;
        this.chunks = new ArrayList<ScriptChunk>(10);
        this.cursor = offset;
        while (this.cursor < offset + length) {
            int startLocationInProgram = this.cursor - offset;
            int opcode = this.readByte();
            if (opcode >= 0 && opcode < 76) {
                this.chunks.add(new ScriptChunk(false, this.getData(opcode), startLocationInProgram));
                continue;
            }
            if (opcode == 76) {
                int len = this.readByte();
                this.chunks.add(new ScriptChunk(false, this.getData(len), startLocationInProgram));
                continue;
            }
            if (opcode == 77) {
                int len = this.readByte() | this.readByte() << 8;
                this.chunks.add(new ScriptChunk(false, this.getData(len), startLocationInProgram));
                continue;
            }
            if (opcode == 78) {
                long len = this.readByte() | this.readByte() << 8 | this.readByte() << 16 | this.readByte() << 24;
                this.chunks.add(new ScriptChunk(false, this.getData((int)len), startLocationInProgram));
                continue;
            }
            this.chunks.add(new ScriptChunk(true, new byte[]{(byte)opcode}, startLocationInProgram));
        }
    }

    public boolean isSentToRawPubKey() {
        if (this.chunks.size() != 2) {
            return false;
        }
        return this.chunks.get(1).equalsOpCode(172) && !this.chunks.get((int)0).isOpCode && this.chunks.get((int)0).data.length > 1;
    }

    public boolean isSentToAddress() {
        if (this.chunks.size() != 5) {
            return false;
        }
        return this.chunks.get(0).equalsOpCode(118) && this.chunks.get(1).equalsOpCode(169) && this.chunks.get((int)2).data.length == 20 && this.chunks.get(3).equalsOpCode(136) && this.chunks.get(4).equalsOpCode(172);
    }

    public byte[] getPubKeyHash() throws ScriptException {
        if (!this.isSentToAddress()) {
            throw new ScriptException("Script not in the standard scriptPubKey form");
        }
        return this.chunks.get((int)2).data;
    }

    public byte[] getPubKey() throws ScriptException {
        if (this.chunks.size() != 2) {
            throw new ScriptException("Script not of right size, expecting 2 but got " + this.chunks.size());
        }
        if (this.chunks.get((int)0).data.length > 2 && this.chunks.get((int)1).data.length > 2) {
            return this.chunks.get((int)1).data;
        }
        if (this.chunks.get((int)1).data.length == 1 && this.chunks.get(1).equalsOpCode(172) && this.chunks.get((int)0).data.length > 2) {
            return this.chunks.get((int)0).data;
        }
        throw new ScriptException("Script did not match expected form: " + this.toString());
    }

    public Address getFromAddress() throws ScriptException {
        return new Address(this.params, Utils.sha256hash160(this.getPubKey()));
    }

    public Address getToAddress() throws ScriptException {
        return new Address(this.params, this.getPubKeyHash());
    }

    static void writeBytes(OutputStream os, byte[] buf) throws IOException {
        if (buf.length < 76) {
            os.write(buf.length);
            os.write(buf);
        } else if (buf.length < 256) {
            os.write(76);
            os.write(buf.length);
            os.write(buf);
        } else if (buf.length < 65536) {
            os.write(77);
            os.write(0xFF & buf.length);
            os.write(0xFF & buf.length >> 8);
            os.write(buf);
        } else {
            throw new RuntimeException("Unimplemented");
        }
    }

    public static byte[] createOutputScript(Address to) {
        try {
            UnsafeByteArrayOutputStream bits = new UnsafeByteArrayOutputStream(24);
            ((ByteArrayOutputStream)bits).write(118);
            ((ByteArrayOutputStream)bits).write(169);
            Script.writeBytes(bits, to.getHash160());
            ((ByteArrayOutputStream)bits).write(136);
            ((ByteArrayOutputStream)bits).write(172);
            return ((ByteArrayOutputStream)bits).toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] createOutputScript(byte[] pubkey) {
        try {
            UnsafeByteArrayOutputStream bits = new UnsafeByteArrayOutputStream(pubkey.length + 1);
            Script.writeBytes(bits, pubkey);
            ((ByteArrayOutputStream)bits).write(172);
            return ((ByteArrayOutputStream)bits).toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] createOutputScript(ECKey pubkey) {
        return Script.createOutputScript(pubkey.getPubKey());
    }

    public static byte[] createInputScript(byte[] signature, byte[] pubkey) {
        try {
            UnsafeByteArrayOutputStream bits = new UnsafeByteArrayOutputStream(signature.length + pubkey.length + 2);
            Script.writeBytes(bits, signature);
            Script.writeBytes(bits, pubkey);
            return ((ByteArrayOutputStream)bits).toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] createInputScript(byte[] signature) {
        try {
            UnsafeByteArrayOutputStream bits = new UnsafeByteArrayOutputStream(signature.length + 2);
            Script.writeBytes(bits, signature);
            return ((ByteArrayOutputStream)bits).toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getSigOpCount(List<ScriptChunk> chunks, boolean accurate) throws ScriptException {
        int sigOps = 0;
        int lastOpCode = 255;
        for (ScriptChunk chunk : chunks) {
            if (!chunk.isOpCode) continue;
            int opcode = 0xFF & chunk.data[0];
            switch (opcode) {
                case 172: 
                case 173: {
                    ++sigOps;
                    break;
                }
                case 174: 
                case 175: {
                    if (accurate && lastOpCode >= 81 && lastOpCode <= 96) {
                        sigOps += Script.getOpNValue(lastOpCode);
                        break;
                    }
                    sigOps += 20;
                    break;
                }
            }
            lastOpCode = opcode;
        }
        return sigOps;
    }

    private static int getOpNValue(int opcode) throws ScriptException {
        if (opcode == 0) {
            return 0;
        }
        if (opcode < 81 || opcode > 96) {
            throw new ScriptException("getOpNValue called on non OP_N opcode");
        }
        return opcode + 1 - 81;
    }

    public static int getSigOpCount(byte[] program) throws ScriptException {
        Script script = new Script();
        try {
            script.parse(program, 0, program.length);
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        return Script.getSigOpCount(script.chunks, false);
    }

    public static long getP2SHSigOpCount(byte[] scriptSig) throws ScriptException {
        Script script = new Script();
        try {
            script.parse(scriptSig, 0, scriptSig.length);
        }
        catch (ScriptException e) {
            // empty catch block
        }
        for (int i = script.chunks.size() - 1; i >= 0; --i) {
            if (script.chunks.get((int)i).isOpCode) continue;
            Script subScript = new Script();
            subScript.parse(script.chunks.get((int)i).data, 0, script.chunks.get((int)i).data.length);
            return Script.getSigOpCount(subScript.chunks, true);
        }
        return 0L;
    }

    public boolean isPayToScriptHash() {
        return this.program.length == 23 && (this.program[0] & 0xFF) == 169 && (this.program[1] & 0xFF) == 20 && (this.program[22] & 0xFF) == 135;
    }

    private static boolean equalsRange(byte[] a, int start, byte[] b) {
        if (start + b.length > a.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (a[i + start] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] removeAllInstancesOf(byte[] inputScript, byte[] chunkToRemove) {
        int additionalBytes;
        UnsafeByteArrayOutputStream bos = new UnsafeByteArrayOutputStream(inputScript.length);
        for (int cursor = 0; cursor < inputScript.length; cursor += additionalBytes) {
            boolean skip = Script.equalsRange(inputScript, cursor, chunkToRemove);
            int opcode = inputScript[cursor++] & 0xFF;
            additionalBytes = 0;
            if (opcode >= 0 && opcode < 76) {
                additionalBytes = opcode;
            } else if (opcode == 76) {
                additionalBytes = inputScript[cursor] + 1;
            } else if (opcode == 77) {
                additionalBytes = (0xFF & inputScript[cursor] | (0xFF & inputScript[cursor + 1]) << 8) + 2;
            } else if (opcode == 78) {
                additionalBytes = (0xFF & inputScript[cursor] | (0xFF & inputScript[cursor + 1]) << 8 | (0xFF & inputScript[cursor + 1]) << 16 | (0xFF & inputScript[cursor + 1]) << 24) + 4;
            }
            if (skip) continue;
            try {
                bos.write(opcode);
                bos.write(Arrays.copyOfRange(inputScript, cursor, cursor + additionalBytes));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return bos.toByteArray();
    }

    public static byte[] removeAllInstancesOfOp(byte[] inputScript, int opCode) {
        return Script.removeAllInstancesOf(inputScript, new byte[]{(byte)opCode});
    }

    private static boolean castToBool(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 0) continue;
            return i != data.length - 1 || (data[i] & 0xFF) != 128;
        }
        return false;
    }

    private static BigInteger castToBigInteger(byte[] chunk) throws ScriptException {
        if (chunk.length > 4) {
            throw new ScriptException("Script attempted to use an integer larger than 4 bytes");
        }
        return Utils.decodeMPI(Utils.reverseBytes(chunk), false);
    }

    private static void executeScript(Transaction txContainingThis, long index, Script script, LinkedList<byte[]> stack) throws ScriptException {
        int opCount = 0;
        int lastCodeSepLocation = 0;
        LinkedList<byte[]> altstack = new LinkedList<byte[]>();
        LinkedList<Boolean> ifStack = new LinkedList<Boolean>();
        block84: for (ScriptChunk chunk : script.chunks) {
            boolean shouldExecute;
            boolean bl = shouldExecute = !ifStack.contains(false);
            if (!chunk.isOpCode) {
                if (chunk.data.length > 520) {
                    throw new ScriptException("Attempted to push a data string larger than 520 bytes");
                }
                if (!shouldExecute) continue;
                stack.add(chunk.data);
            } else {
                int opcode = 0xFF & chunk.data[0];
                if (opcode > 96 && ++opCount > 201) {
                    throw new ScriptException("More script operations than is allowed");
                }
                if (opcode == 101 || opcode == 102) {
                    throw new ScriptException("Script included OP_VERIF or OP_VERNOTIF");
                }
                if (opcode == 126 || opcode == 127 || opcode == 128 || opcode == 129 || opcode == 131 || opcode == 132 || opcode == 133 || opcode == 134 || opcode == 141 || opcode == 142 || opcode == 149 || opcode == 150 || opcode == 151 || opcode == 152 || opcode == 153) {
                    throw new ScriptException("Script included a disabled Script Op.");
                }
                switch (opcode) {
                    case 99: {
                        if (!shouldExecute) {
                            ifStack.add(false);
                            continue block84;
                        }
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_IF on an empty stack");
                        }
                        ifStack.add(Script.castToBool(stack.pollLast()));
                        continue block84;
                    }
                    case 100: {
                        if (!shouldExecute) {
                            ifStack.add(false);
                            continue block84;
                        }
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_NOTIF on an empty stack");
                        }
                        ifStack.add(!Script.castToBool(stack.pollLast()));
                        continue block84;
                    }
                    case 103: {
                        if (ifStack.isEmpty()) {
                            throw new ScriptException("Attempted OP_ELSE without OP_IF/NOTIF");
                        }
                        ifStack.add((Boolean)ifStack.pollLast() == false);
                        continue block84;
                    }
                    case 104: {
                        if (ifStack.isEmpty()) {
                            throw new ScriptException("Attempted OP_ENDIF without OP_IF/NOTIF");
                        }
                        ifStack.pollLast();
                        continue block84;
                    }
                }
                if (!shouldExecute) continue;
                switch (opcode) {
                    case 79: {
                        stack.add(Utils.reverseBytes(Utils.encodeMPI(BigInteger.ONE.negate(), false)));
                        break;
                    }
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: {
                        stack.add(Utils.reverseBytes(Utils.encodeMPI(BigInteger.valueOf(Script.getOpNValue(opcode)), false)));
                        break;
                    }
                    case 97: {
                        break;
                    }
                    case 105: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_VERIFY on an empty stack");
                        }
                        if (Script.castToBool(stack.pollLast())) break;
                        throw new ScriptException("OP_VERIFY failed");
                    }
                    case 106: {
                        throw new ScriptException("Script called OP_RETURN");
                    }
                    case 107: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_TOALTSTACK on an empty stack");
                        }
                        altstack.add(stack.pollLast());
                        break;
                    }
                    case 108: {
                        if (altstack.size() < 1) {
                            throw new ScriptException("Attempted OP_TOALTSTACK on an empty altstack");
                        }
                        stack.add((byte[])altstack.pollLast());
                        break;
                    }
                    case 109: {
                        if (stack.size() < 2) {
                            throw new ScriptException("Attempted OP_2DROP on a stack with size < 2");
                        }
                        stack.pollLast();
                        stack.pollLast();
                        break;
                    }
                    case 110: {
                        if (stack.size() < 2) {
                            throw new ScriptException("Attempted OP_2DUP on a stack with size < 2");
                        }
                        Iterator<byte[]> it2DUP = stack.descendingIterator();
                        byte[] OP2DUPtmpChunk2 = it2DUP.next();
                        stack.add(it2DUP.next());
                        stack.add(OP2DUPtmpChunk2);
                        break;
                    }
                    case 111: {
                        if (stack.size() < 3) {
                            throw new ScriptException("Attempted OP_3DUP on a stack with size < 3");
                        }
                        Iterator<byte[]> it3DUP = stack.descendingIterator();
                        byte[] OP3DUPtmpChunk3 = it3DUP.next();
                        byte[] OP3DUPtmpChunk2 = it3DUP.next();
                        stack.add(it3DUP.next());
                        stack.add(OP3DUPtmpChunk2);
                        stack.add(OP3DUPtmpChunk3);
                        break;
                    }
                    case 112: {
                        if (stack.size() < 4) {
                            throw new ScriptException("Attempted OP_2OVER on a stack with size < 4");
                        }
                        Iterator<byte[]> it2OVER = stack.descendingIterator();
                        it2OVER.next();
                        it2OVER.next();
                        byte[] OP2OVERtmpChunk2 = it2OVER.next();
                        stack.add(it2OVER.next());
                        stack.add(OP2OVERtmpChunk2);
                        break;
                    }
                    case 113: {
                        if (stack.size() < 6) {
                            throw new ScriptException("Attempted OP_2ROT on a stack with size < 6");
                        }
                        byte[] OP2ROTtmpChunk6 = stack.pollLast();
                        byte[] OP2ROTtmpChunk5 = stack.pollLast();
                        byte[] OP2ROTtmpChunk4 = stack.pollLast();
                        byte[] OP2ROTtmpChunk3 = stack.pollLast();
                        byte[] OP2ROTtmpChunk2 = stack.pollLast();
                        byte[] OP2ROTtmpChunk1 = stack.pollLast();
                        stack.add(OP2ROTtmpChunk3);
                        stack.add(OP2ROTtmpChunk4);
                        stack.add(OP2ROTtmpChunk5);
                        stack.add(OP2ROTtmpChunk6);
                        stack.add(OP2ROTtmpChunk1);
                        stack.add(OP2ROTtmpChunk2);
                        break;
                    }
                    case 114: {
                        if (stack.size() < 4) {
                            throw new ScriptException("Attempted OP_2SWAP on a stack with size < 4");
                        }
                        byte[] OP2SWAPtmpChunk4 = stack.pollLast();
                        byte[] OP2SWAPtmpChunk3 = stack.pollLast();
                        byte[] OP2SWAPtmpChunk2 = stack.pollLast();
                        byte[] OP2SWAPtmpChunk1 = stack.pollLast();
                        stack.add(OP2SWAPtmpChunk3);
                        stack.add(OP2SWAPtmpChunk4);
                        stack.add(OP2SWAPtmpChunk1);
                        stack.add(OP2SWAPtmpChunk2);
                        break;
                    }
                    case 115: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_IFDUP on an empty stack");
                        }
                        if (!Script.castToBool(stack.getLast())) break;
                        stack.add(stack.getLast());
                        break;
                    }
                    case 116: {
                        stack.add(Utils.reverseBytes(Utils.encodeMPI(BigInteger.valueOf(stack.size()), false)));
                        break;
                    }
                    case 117: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_DROP on an empty stack");
                        }
                        stack.pollLast();
                        break;
                    }
                    case 118: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_DUP on an empty stack");
                        }
                        stack.add(stack.getLast());
                        break;
                    }
                    case 119: {
                        if (stack.size() < 2) {
                            throw new ScriptException("Attempted OP_NIP on a stack with size < 2");
                        }
                        byte[] OPNIPtmpChunk = stack.pollLast();
                        stack.pollLast();
                        stack.add(OPNIPtmpChunk);
                        break;
                    }
                    case 120: {
                        if (stack.size() < 2) {
                            throw new ScriptException("Attempted OP_OVER on a stack with size < 2");
                        }
                        Iterator<byte[]> itOVER = stack.descendingIterator();
                        itOVER.next();
                        stack.add(itOVER.next());
                        break;
                    }
                    case 121: 
                    case 122: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_PICK/OP_ROLL on an empty stack");
                        }
                        long val = Script.castToBigInteger(stack.pollLast()).longValue();
                        if (val < 0L || val >= (long)stack.size()) {
                            throw new ScriptException("OP_PICK/OP_ROLL attempted to get data deeper than stack size");
                        }
                        Iterator<byte[]> itPICK = stack.descendingIterator();
                        for (long i = 0L; i < val; ++i) {
                            itPICK.next();
                        }
                        byte[] OPROLLtmpChunk = itPICK.next();
                        if (opcode == 122) {
                            itPICK.remove();
                        }
                        stack.add(OPROLLtmpChunk);
                        break;
                    }
                    case 123: {
                        if (stack.size() < 3) {
                            throw new ScriptException("Attempted OP_ROT on a stack with size < 3");
                        }
                        byte[] OPROTtmpChunk3 = stack.pollLast();
                        byte[] OPROTtmpChunk2 = stack.pollLast();
                        byte[] OPROTtmpChunk1 = stack.pollLast();
                        stack.add(OPROTtmpChunk2);
                        stack.add(OPROTtmpChunk3);
                        stack.add(OPROTtmpChunk1);
                        break;
                    }
                    case 124: 
                    case 125: {
                        if (stack.size() < 2) {
                            throw new ScriptException("Attempted OP_SWAP on a stack with size < 2");
                        }
                        byte[] OPSWAPtmpChunk2 = stack.pollLast();
                        byte[] OPSWAPtmpChunk1 = stack.pollLast();
                        stack.add(OPSWAPtmpChunk2);
                        stack.add(OPSWAPtmpChunk1);
                        if (opcode != 125) break;
                        stack.add(OPSWAPtmpChunk2);
                        break;
                    }
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: {
                        throw new ScriptException("Attempted to use disabled Script Op.");
                    }
                    case 130: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_SIZE on an empty stack");
                        }
                        stack.add(Utils.reverseBytes(Utils.encodeMPI(BigInteger.valueOf(stack.getLast().length), false)));
                        break;
                    }
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: {
                        throw new ScriptException("Attempted to use disabled Script Op.");
                    }
                    case 135: {
                        byte[] byArray;
                        if (stack.size() < 2) {
                            throw new ScriptException("Attempted OP_EQUALVERIFY on a stack with size < 2");
                        }
                        if (Arrays.equals(stack.pollLast(), stack.pollLast())) {
                            byte[] byArray2 = new byte[1];
                            byArray = byArray2;
                            byArray2[0] = 1;
                        } else {
                            byte[] byArray3 = new byte[1];
                            byArray = byArray3;
                            byArray3[0] = 0;
                        }
                        stack.add(byArray);
                        break;
                    }
                    case 136: {
                        if (stack.size() < 2) {
                            throw new ScriptException("Attempted OP_EQUALVERIFY on a stack with size < 2");
                        }
                        if (Arrays.equals(stack.pollLast(), stack.pollLast())) break;
                        throw new ScriptException("OP_EQUALVERIFY: non-equal data");
                    }
                    case 139: 
                    case 140: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted a numeric op on an empty stack");
                        }
                        BigInteger numericOPnum = Script.castToBigInteger(stack.pollLast());
                        switch (opcode) {
                            case 139: {
                                numericOPnum = numericOPnum.add(BigInteger.ONE);
                                break;
                            }
                            case 140: {
                                numericOPnum = numericOPnum.subtract(BigInteger.ONE);
                                break;
                            }
                            case 143: {
                                numericOPnum = numericOPnum.negate();
                                break;
                            }
                            case 144: {
                                if (numericOPnum.compareTo(BigInteger.ZERO) >= 0) break;
                                numericOPnum = numericOPnum.negate();
                                break;
                            }
                            case 145: {
                                if (numericOPnum.equals(BigInteger.ZERO)) {
                                    numericOPnum = BigInteger.ONE;
                                    break;
                                }
                                numericOPnum = BigInteger.ZERO;
                                break;
                            }
                            case 146: {
                                if (numericOPnum.equals(BigInteger.ZERO)) {
                                    numericOPnum = BigInteger.ZERO;
                                    break;
                                }
                                numericOPnum = BigInteger.ONE;
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)"Unreachable");
                            }
                        }
                        stack.add(Utils.reverseBytes(Utils.encodeMPI(numericOPnum, false)));
                        break;
                    }
                    case 141: 
                    case 142: {
                        throw new ScriptException("Attempted to use disabled Script Op.");
                    }
                    case 147: 
                    case 148: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: {
                        BigInteger numericOPresult;
                        if (stack.size() < 2) {
                            throw new ScriptException("Attempted a numeric op on a stack with size < 2");
                        }
                        BigInteger numericOPnum2 = Script.castToBigInteger(stack.pollLast());
                        BigInteger numericOPnum1 = Script.castToBigInteger(stack.pollLast());
                        switch (opcode) {
                            case 147: {
                                numericOPresult = numericOPnum1.add(numericOPnum2);
                                break;
                            }
                            case 148: {
                                numericOPresult = numericOPnum1.subtract(numericOPnum2);
                                break;
                            }
                            case 154: {
                                if (!numericOPnum1.equals(BigInteger.ZERO) && !numericOPnum2.equals(BigInteger.ZERO)) {
                                    numericOPresult = BigInteger.ONE;
                                    break;
                                }
                                numericOPresult = BigInteger.ZERO;
                                break;
                            }
                            case 155: {
                                if (!numericOPnum1.equals(BigInteger.ZERO) || !numericOPnum2.equals(BigInteger.ZERO)) {
                                    numericOPresult = BigInteger.ONE;
                                    break;
                                }
                                numericOPresult = BigInteger.ZERO;
                                break;
                            }
                            case 156: {
                                if (numericOPnum1.equals(numericOPnum2)) {
                                    numericOPresult = BigInteger.ONE;
                                    break;
                                }
                                numericOPresult = BigInteger.ZERO;
                                break;
                            }
                            case 158: {
                                if (!numericOPnum1.equals(numericOPnum2)) {
                                    numericOPresult = BigInteger.ONE;
                                    break;
                                }
                                numericOPresult = BigInteger.ZERO;
                                break;
                            }
                            case 159: {
                                if (numericOPnum1.compareTo(numericOPnum2) < 0) {
                                    numericOPresult = BigInteger.ONE;
                                    break;
                                }
                                numericOPresult = BigInteger.ZERO;
                                break;
                            }
                            case 160: {
                                if (numericOPnum1.compareTo(numericOPnum2) > 0) {
                                    numericOPresult = BigInteger.ONE;
                                    break;
                                }
                                numericOPresult = BigInteger.ZERO;
                                break;
                            }
                            case 161: {
                                if (numericOPnum1.compareTo(numericOPnum2) <= 0) {
                                    numericOPresult = BigInteger.ONE;
                                    break;
                                }
                                numericOPresult = BigInteger.ZERO;
                                break;
                            }
                            case 162: {
                                if (numericOPnum1.compareTo(numericOPnum2) >= 0) {
                                    numericOPresult = BigInteger.ONE;
                                    break;
                                }
                                numericOPresult = BigInteger.ZERO;
                                break;
                            }
                            case 163: {
                                if (numericOPnum1.compareTo(numericOPnum2) < 0) {
                                    numericOPresult = numericOPnum1;
                                    break;
                                }
                                numericOPresult = numericOPnum2;
                                break;
                            }
                            case 164: {
                                if (numericOPnum1.compareTo(numericOPnum2) > 0) {
                                    numericOPresult = numericOPnum1;
                                    break;
                                }
                                numericOPresult = numericOPnum2;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Opcode switched at runtime?");
                            }
                        }
                        stack.add(Utils.reverseBytes(Utils.encodeMPI(numericOPresult, false)));
                        break;
                    }
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: {
                        throw new ScriptException("Attempted to use disabled Script Op.");
                    }
                    case 157: {
                        if (stack.size() < 2) {
                            throw new ScriptException("Attempted OP_NUMEQUALVERIFY on a stack with size < 2");
                        }
                        BigInteger OPNUMEQUALVERIFYnum2 = Script.castToBigInteger(stack.pollLast());
                        BigInteger OPNUMEQUALVERIFYnum1 = Script.castToBigInteger(stack.pollLast());
                        if (OPNUMEQUALVERIFYnum1.equals(OPNUMEQUALVERIFYnum2)) break;
                        throw new ScriptException("OP_NUMEQUALVERIFY failed");
                    }
                    case 165: {
                        BigInteger OPWITHINnum1;
                        if (stack.size() < 3) {
                            throw new ScriptException("Attempted OP_WITHIN on a stack with size < 3");
                        }
                        BigInteger OPWITHINnum3 = Script.castToBigInteger(stack.pollLast());
                        BigInteger OPWITHINnum2 = Script.castToBigInteger(stack.pollLast());
                        if (OPWITHINnum2.compareTo(OPWITHINnum1 = Script.castToBigInteger(stack.pollLast())) <= 0 && OPWITHINnum1.compareTo(OPWITHINnum3) < 0) {
                            stack.add(Utils.reverseBytes(Utils.encodeMPI(BigInteger.ONE, false)));
                            break;
                        }
                        stack.add(Utils.reverseBytes(Utils.encodeMPI(BigInteger.ZERO, false)));
                        break;
                    }
                    case 166: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_RIPEMD160 on an empty stack");
                        }
                        RIPEMD160Digest digest = new RIPEMD160Digest();
                        byte[] dataToHash = stack.pollLast();
                        digest.update(dataToHash, 0, dataToHash.length);
                        byte[] ripmemdHash = new byte[20];
                        digest.doFinal(ripmemdHash, 0);
                        stack.add(ripmemdHash);
                        break;
                    }
                    case 167: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_SHA1 on an empty stack");
                        }
                        try {
                            stack.add(MessageDigest.getInstance("SHA-1").digest(stack.pollLast()));
                            break;
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case 168: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_SHA256 on an empty stack");
                        }
                        try {
                            stack.add(MessageDigest.getInstance("SHA-256").digest(stack.pollLast()));
                            break;
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case 169: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_HASH160 on an empty stack");
                        }
                        stack.add(Utils.sha256hash160(stack.pollLast()));
                        break;
                    }
                    case 170: {
                        if (stack.size() < 1) {
                            throw new ScriptException("Attempted OP_SHA256 on an empty stack");
                        }
                        stack.add(Utils.doubleDigest(stack.pollLast()));
                        break;
                    }
                    case 171: {
                        lastCodeSepLocation = chunk.startLocationInProgram + 1;
                        break;
                    }
                    case 172: 
                    case 173: {
                        boolean CHECKSIGsigValid;
                        if (stack.size() < 2) {
                            throw new ScriptException("Attempted OP_CHECKSIG(VERIFY) on a stack with size < 2");
                        }
                        byte[] CHECKSIGpubKey = stack.pollLast();
                        byte[] CHECKSIGsig = stack.pollLast();
                        byte[] CHECKSIGconnectedScript = Arrays.copyOfRange(script.program, lastCodeSepLocation, script.program.length);
                        UnsafeByteArrayOutputStream OPCHECKSIGOutStream = new UnsafeByteArrayOutputStream(CHECKSIGsig.length + 1);
                        try {
                            Script.writeBytes(OPCHECKSIGOutStream, CHECKSIGsig);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        CHECKSIGconnectedScript = Script.removeAllInstancesOf(CHECKSIGconnectedScript, OPCHECKSIGOutStream.toByteArray());
                        Sha256Hash CHECKSIGhash = txContainingThis.hashTransactionForSignature((int)index, CHECKSIGconnectedScript, CHECKSIGsig[CHECKSIGsig.length - 1]);
                        try {
                            CHECKSIGsigValid = ECKey.verify(CHECKSIGhash.getBytes(), Arrays.copyOf(CHECKSIGsig, CHECKSIGsig.length - 1), CHECKSIGpubKey);
                        }
                        catch (Exception e1) {
                            CHECKSIGsigValid = false;
                        }
                        if (opcode == 172) {
                            byte[] byArray;
                            if (CHECKSIGsigValid) {
                                byte[] byArray4 = new byte[1];
                                byArray = byArray4;
                                byArray4[0] = 1;
                            } else {
                                byte[] byArray5 = new byte[1];
                                byArray = byArray5;
                                byArray5[0] = 0;
                            }
                            stack.add(byArray);
                            break;
                        }
                        if (opcode != 173 || CHECKSIGsigValid) break;
                        throw new ScriptException("Script failed OP_CHECKSIGVERIFY");
                    }
                    case 174: 
                    case 175: {
                        if (stack.size() < 2) {
                            throw new ScriptException("Attempted OP_CHECKMULTISIG(VERIFY) on a stack with size < 2");
                        }
                        int CHECKMULTISIGpubKeyCount = Script.castToBigInteger(stack.pollLast()).intValue();
                        if (CHECKMULTISIGpubKeyCount < 0 || CHECKMULTISIGpubKeyCount > 20) {
                            throw new ScriptException("OP_CHECKMULTISIG(VERIFY) with pubkey count out of range");
                        }
                        if ((opCount += CHECKMULTISIGpubKeyCount) > 201) {
                            throw new ScriptException("Total op count > 201 during OP_CHECKMULTISIG(VERIFY)");
                        }
                        if (stack.size() < CHECKMULTISIGpubKeyCount + 1) {
                            throw new ScriptException("Attempted OP_CHECKMULTISIG(VERIFY) on a stack with size < num_of_pubkeys + 2");
                        }
                        LinkedList<byte[]> CHECKMULTISIGpubkeys = new LinkedList<byte[]>();
                        for (int i = 0; i < CHECKMULTISIGpubKeyCount; ++i) {
                            CHECKMULTISIGpubkeys.add(stack.pollLast());
                        }
                        int CHECKMULTISIGsigCount = Script.castToBigInteger(stack.pollLast()).intValue();
                        if (CHECKMULTISIGsigCount < 0 || CHECKMULTISIGsigCount > CHECKMULTISIGpubKeyCount) {
                            throw new ScriptException("OP_CHECKMULTISIG(VERIFY) with sig count out of range");
                        }
                        if (stack.size() < CHECKMULTISIGsigCount + 1) {
                            throw new ScriptException("Attempted OP_CHECKMULTISIG(VERIFY) on a stack with size < num_of_pubkeys + num_of_signatures + 3");
                        }
                        LinkedList<byte[]> CHECKMULTISIGsigs = new LinkedList<byte[]>();
                        for (int i = 0; i < CHECKMULTISIGsigCount; ++i) {
                            CHECKMULTISIGsigs.add(stack.pollLast());
                        }
                        byte[] CHECKMULTISIGconnectedScript = Arrays.copyOfRange(script.program, lastCodeSepLocation, script.program.length);
                        for (byte[] CHECKMULTISIGsig : CHECKMULTISIGsigs) {
                            UnsafeByteArrayOutputStream OPCHECKMULTISIGOutStream = new UnsafeByteArrayOutputStream(CHECKMULTISIGsig.length + 1);
                            try {
                                Script.writeBytes(OPCHECKMULTISIGOutStream, CHECKMULTISIGsig);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            CHECKMULTISIGconnectedScript = Script.removeAllInstancesOf(CHECKMULTISIGconnectedScript, OPCHECKMULTISIGOutStream.toByteArray());
                        }
                        boolean CHECKMULTISIGValid = true;
                        while (CHECKMULTISIGsigs.size() > 0) {
                            byte[] CHECKMULTISIGsig;
                            CHECKMULTISIGsig = (byte[])CHECKMULTISIGsigs.getFirst();
                            byte[] CHECKMULTISIGpubKey = (byte[])CHECKMULTISIGpubkeys.pollFirst();
                            Sha256Hash CHECKMULTISIGhash = txContainingThis.hashTransactionForSignature((int)index, CHECKMULTISIGconnectedScript, CHECKMULTISIGsig[CHECKMULTISIGsig.length - 1]);
                            try {
                                if (ECKey.verify(CHECKMULTISIGhash.getBytes(), Arrays.copyOf(CHECKMULTISIGsig, CHECKMULTISIGsig.length - 1), CHECKMULTISIGpubKey)) {
                                    CHECKMULTISIGsigs.pollFirst();
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (CHECKMULTISIGsigs.size() <= CHECKMULTISIGpubkeys.size()) continue;
                            CHECKMULTISIGValid = false;
                            break;
                        }
                        stack.pollLast();
                        if (opcode == 174) {
                            byte[] byArray;
                            if (CHECKMULTISIGValid) {
                                byte[] byArray6 = new byte[1];
                                byArray = byArray6;
                                byArray6[0] = 1;
                            } else {
                                byte[] byArray7 = new byte[1];
                                byArray = byArray7;
                                byArray7[0] = 0;
                            }
                            stack.add(byArray);
                            break;
                        }
                        if (opcode != 175 || CHECKMULTISIGValid) break;
                        throw new ScriptException("Script failed OP_CHECKMULTISIGVERIFY");
                    }
                    case 176: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        break;
                    }
                    default: {
                        throw new ScriptException("Script used a reserved Op Code");
                    }
                }
            }
            if (stack.size() + altstack.size() <= 1000 && stack.size() + altstack.size() >= 0) continue;
            throw new ScriptException("Stack size exceeded range");
        }
        if (!ifStack.isEmpty()) {
            throw new ScriptException("OP_IF/OP_NOTIF without OP_ENDIF");
        }
    }

    public void correctlySpends(Transaction txContainingThis, long scriptSigIndex, Script scriptPubKey, boolean enforceP2SH) throws ScriptException {
        if (this.program.length > 10000 || scriptPubKey.program.length > 10000) {
            throw new ScriptException("Script larger than 10,000 bytes");
        }
        LinkedList<byte[]> stack = new LinkedList<byte[]>();
        LinkedList<byte[]> p2shStack = null;
        Script.executeScript(txContainingThis, scriptSigIndex, this, stack);
        if (enforceP2SH) {
            p2shStack = new LinkedList<byte[]>(stack);
        }
        Script.executeScript(txContainingThis, scriptSigIndex, scriptPubKey, stack);
        if (stack.size() == 0) {
            throw new ScriptException("Stack empty at end of script execution.");
        }
        if (!Script.castToBool(stack.pollLast())) {
            throw new ScriptException("Script resulted in a non-true stack");
        }
        if (enforceP2SH && scriptPubKey.isPayToScriptHash()) {
            for (ScriptChunk chunk : this.chunks) {
                if (!chunk.isOpCode || (chunk.data[0] & 0xFF) <= 96) continue;
                throw new ScriptException("Attempted to spend a P2SH scriptPubKey with a script that contained script ops");
            }
            byte[] scriptPubKeyBytes = p2shStack.pollLast();
            Script scriptPubKeyP2SH = new Script(this.params, scriptPubKeyBytes, 0, scriptPubKeyBytes.length);
            Script.executeScript(txContainingThis, scriptSigIndex, scriptPubKeyP2SH, p2shStack);
            if (p2shStack.size() == 0) {
                throw new ScriptException("P2SH stack empty at end of script execution.");
            }
            if (!Script.castToBool(p2shStack.pollLast())) {
                throw new ScriptException("P2SH script execution resulted in a non-true stack");
            }
        }
    }
}

