/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BlockStoreException;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class StoredBlock
implements Serializable {
    private static final long serialVersionUID = -6097565241243701771L;
    public static final int CHAIN_WORK_BYTES = 12;
    public static final byte[] EMPTY_BYTES = new byte[12];
    public static final int COMPACT_SERIALIZED_SIZE = 96;
    private Block header;
    private BigInteger chainWork;
    private int height;

    public StoredBlock(Block header, BigInteger chainWork, int height) {
        this.header = header;
        this.chainWork = chainWork;
        this.height = height;
    }

    public Block getHeader() {
        return this.header;
    }

    public BigInteger getChainWork() {
        return this.chainWork;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean moreWorkThan(StoredBlock other) {
        return this.chainWork.compareTo(other.chainWork) > 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof StoredBlock)) {
            return false;
        }
        StoredBlock o = (StoredBlock)other;
        return o.header.equals(this.header) && o.chainWork.equals(this.chainWork) && o.height == this.height;
    }

    public int hashCode() {
        return this.header.hashCode() ^ this.chainWork.hashCode() ^ this.height;
    }

    public StoredBlock build(Block block) throws VerificationException {
        BigInteger chainWork = this.chainWork.add(block.getWork());
        int height = this.height + 1;
        return new StoredBlock(block, chainWork, height);
    }

    public StoredBlock getPrev(BlockStore store) throws BlockStoreException {
        return store.get(this.getHeader().getPrevBlockHash());
    }

    public void serializeCompact(ByteBuffer buffer) {
        byte[] chainWorkBytes = this.getChainWork().toByteArray();
        Preconditions.checkState((chainWorkBytes.length <= 12 ? 1 : 0) != 0, (Object)"Ran out of space to store chain work!");
        if (chainWorkBytes.length < 12) {
            buffer.put(EMPTY_BYTES, 0, 12 - chainWorkBytes.length);
        }
        buffer.put(chainWorkBytes);
        buffer.putInt(this.getHeight());
        byte[] bytes = this.getHeader().unsafeBitcoinSerialize();
        buffer.put(bytes, 0, 80);
    }

    public static StoredBlock deserializeCompact(NetworkParameters params, ByteBuffer buffer) throws ProtocolException {
        byte[] chainWorkBytes = new byte[12];
        buffer.get(chainWorkBytes);
        BigInteger chainWork = new BigInteger(1, chainWorkBytes);
        int height = buffer.getInt();
        byte[] header = new byte[81];
        buffer.get(header, 0, 80);
        return new StoredBlock(new Block(params, header), chainWork, height);
    }

    public String toString() {
        return String.format("Block %s at height %d: %s", this.getHeader().getHashAsString(), this.getHeight(), this.getHeader().toString());
    }
}

