/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.Utils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;

public class StoredTransactionOutput
implements Serializable {
    private static final long serialVersionUID = -8744924157056340509L;
    private BigInteger value;
    private byte[] scriptBytes;
    private Sha256Hash hash;
    private long index;
    private static final int NONCOINBASE_HEIGHT = -200;
    private int height;

    public StoredTransactionOutput(Sha256Hash hash, long index, BigInteger value, int height, boolean isCoinbase, byte[] scriptBytes) {
        this.hash = hash;
        this.index = index;
        this.value = value;
        this.height = isCoinbase ? height : -200;
        this.scriptBytes = scriptBytes;
    }

    public StoredTransactionOutput(Sha256Hash hash, TransactionOutput out, int height, boolean isCoinbase) {
        this.hash = hash;
        this.index = out.getIndex();
        this.value = out.getValue();
        this.height = isCoinbase ? height : -200;
        this.scriptBytes = out.getScriptBytes();
    }

    public StoredTransactionOutput(InputStream in) throws IOException {
        byte[] valueBytes = new byte[8];
        if (in.read(valueBytes, 0, 8) != 8) {
            throw new EOFException();
        }
        this.value = BigInteger.valueOf(Utils.readInt64(valueBytes, 0));
        int scriptBytesLength = (in.read() & 0xFF) << 0 | (in.read() & 0xFF) << 8 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 24;
        this.scriptBytes = new byte[scriptBytesLength];
        if (in.read(this.scriptBytes) != scriptBytesLength) {
            throw new EOFException();
        }
        byte[] hashBytes = new byte[32];
        if (in.read(hashBytes) != 32) {
            throw new EOFException();
        }
        this.hash = new Sha256Hash(hashBytes);
        byte[] indexBytes = new byte[4];
        if (in.read(indexBytes) != 4) {
            throw new EOFException();
        }
        this.index = Utils.readUint32(indexBytes, 0);
        this.height = (in.read() & 0xFF) << 0 | (in.read() & 0xFF) << 8 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 24;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public byte[] getScriptBytes() {
        return this.scriptBytes;
    }

    public Sha256Hash getHash() {
        return this.hash;
    }

    public long getIndex() {
        return this.index;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return String.format("Stored TxOut of %s (%s:%d)", Utils.bitcoinValueToFriendlyString(this.value), this.hash.toString(), this.index);
    }

    public int hashCode() {
        return this.hash.hashCode() + (int)this.index;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StoredTransactionOutput)) {
            return false;
        }
        return ((StoredTransactionOutput)o).getIndex() == this.getIndex() && ((StoredTransactionOutput)o).getHash().equals(this.getHash());
    }

    public void serializeToStream(OutputStream bos) throws IOException {
        Utils.uint64ToByteStreamLE(this.value, bos);
        bos.write(0xFF & this.scriptBytes.length >> 0);
        bos.write(0xFF & this.scriptBytes.length >> 8);
        bos.write(0xFF & this.scriptBytes.length >> 16);
        bos.write(0xFF & this.scriptBytes.length >> 24);
        bos.write(this.scriptBytes);
        bos.write(this.hash.getBytes());
        Utils.uint32ToByteStreamLE(this.index, bos);
        bos.write(0xFF & this.height >> 0);
        bos.write(0xFF & this.height >> 8);
        bos.write(0xFF & this.height >> 16);
        bos.write(0xFF & this.height >> 24);
    }
}

