/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.store;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BlockStoreException;
import com.google.bitcoin.utils.NamedSemaphores;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BoundedOverheadBlockStore
implements BlockStore {
    private static final Logger log = LoggerFactory.getLogger(BoundedOverheadBlockStore.class);
    private static final byte FILE_FORMAT_VERSION = 1;
    private static NamedSemaphores semaphores = new NamedSemaphores();
    private RandomAccessFile file;
    private LinkedHashMap<Sha256Hash, StoredBlock> blockCache = new LinkedHashMap<Sha256Hash, StoredBlock>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Sha256Hash, StoredBlock> entry) {
            return this.size() > 2050;
        }
    };
    private static final StoredBlock notFoundMarker = new StoredBlock(null, null, -1);
    private LinkedHashMap<Sha256Hash, StoredBlock> notFoundCache = new LinkedHashMap<Sha256Hash, StoredBlock>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Sha256Hash, StoredBlock> entry) {
            return this.size() > 100;
        }
    };
    private Sha256Hash chainHead;
    private final NetworkParameters params;
    private FileChannel channel;
    private FileLock lock;
    private String fileName;
    private ByteBuffer buf = ByteBuffer.allocateDirect(100);

    public BoundedOverheadBlockStore(NetworkParameters params, File file) throws BlockStoreException {
        this.params = params;
        try {
            this.fileName = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file.exists()) {
            try {
                this.load(file);
                return;
            }
            catch (IOException e) {
                log.error("Failed to load block chain from " + file, (Throwable)e);
            }
        }
        this.createNewStore(params, file);
    }

    private void createNewStore(NetworkParameters params, File file) throws BlockStoreException {
        this.blockCache.clear();
        try {
            if (file.exists() && !file.delete()) {
                throw new BlockStoreException("Could not delete old store in order to recreate it");
            }
            this.file = new RandomAccessFile(file, "rwd");
            this.channel = this.file.getChannel();
            this.lock();
            this.file.write(1);
        }
        catch (IOException e1) {
            throw new BlockStoreException(e1);
        }
        try {
            Block genesis = params.genesisBlock.cloneAsHeader();
            StoredBlock storedGenesis = new StoredBlock(genesis, genesis.getWork(), 0);
            this.chainHead = storedGenesis.getHeader().getHash();
            this.file.write(this.chainHead.getBytes());
            this.put(storedGenesis);
        }
        catch (VerificationException e1) {
            throw new RuntimeException(e1);
        }
        catch (IOException e) {
            throw new BlockStoreException(e);
        }
    }

    private void load(File file) throws IOException, BlockStoreException {
        log.info("Reading block store from {}", (Object)file);
        this.file = new RandomAccessFile(file, "rwd");
        this.channel = this.file.getChannel();
        this.lock();
        try {
            int version = this.file.read();
            if (version == -1) {
                this.close();
                throw new FileNotFoundException(file.getName() + " does not exist or is empty");
            }
            if (version != 1) {
                throw new BlockStoreException("Bad version number: " + version);
            }
            byte[] chainHeadHash = new byte[32];
            if (this.file.read(chainHeadHash) < chainHeadHash.length) {
                throw new BlockStoreException("Truncated store: could not read chain head hash.");
            }
            this.chainHead = new Sha256Hash(chainHeadHash);
            log.info("Read chain head from disk: {}", (Object)this.chainHead);
            this.channel.position(this.channel.size() - 100L);
        }
        catch (IOException e) {
            if (this.file != null) {
                this.file.close();
            }
            throw e;
        }
        catch (BlockStoreException e) {
            this.file.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock() throws IOException, BlockStoreException {
        if (!semaphores.tryAcquire(this.fileName)) {
            throw new BlockStoreException("File in use");
        }
        try {
            this.lock = this.channel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            semaphores.release(this.fileName);
            this.lock = null;
        }
        if (this.lock == null) {
            try {
                this.file.close();
            }
            finally {
                this.file = null;
            }
            throw new BlockStoreException("Could not lock file");
        }
    }

    private void ensureOpen() throws BlockStoreException {
        if (this.file == null) {
            throw new BlockStoreException("BlockStore was closed");
        }
    }

    @Override
    public synchronized void put(StoredBlock block) throws BlockStoreException {
        this.ensureOpen();
        try {
            Sha256Hash hash = block.getHeader().getHash();
            Record.write(this.channel, block);
            this.blockCache.put(hash, block);
        }
        catch (IOException e) {
            throw new BlockStoreException(e);
        }
    }

    @Override
    public synchronized StoredBlock get(Sha256Hash hash) throws BlockStoreException {
        this.ensureOpen();
        StoredBlock fromMem = this.blockCache.get(hash);
        if (fromMem != null) {
            return fromMem;
        }
        if (this.notFoundCache.get(hash) == notFoundMarker) {
            return null;
        }
        try {
            Record fromDisk = this.getRecord(hash);
            StoredBlock block = null;
            if (fromDisk == null) {
                this.notFoundCache.put(hash, notFoundMarker);
            } else {
                block = fromDisk.toStoredBlock(this.params);
                this.blockCache.put(hash, block);
            }
            return block;
        }
        catch (IOException e) {
            throw new BlockStoreException(e);
        }
        catch (ProtocolException e) {
            throw new BlockStoreException(e);
        }
    }

    private Record getRecord(Sha256Hash hash) throws IOException, ProtocolException {
        long startPos;
        long pos = startPos = this.channel.position();
        Record record = new Record();
        int numMoves = 0;
        long startTime = new Date().getTime();
        do {
            if (!record.read(this.channel, pos, this.buf)) {
                throw new IOException("Failed to read buffer");
            }
            if (record.getHeader(this.params).getHash().equals(hash)) {
                this.channel.position(pos);
                long endTime = new Date().getTime();
                if (endTime - startTime > 100L) {
                    log.info("Spent {} seconds doing {} backwards seeks", (Object)((double)(endTime - startTime) / 1000.0), (Object)numMoves);
                }
                return record;
            }
            if (pos == 33L) {
                pos = this.channel.size() - 100L;
            } else {
                Preconditions.checkState(((pos -= 100L) >= 33L ? 1 : 0) != 0, (Object)pos);
            }
            ++numMoves;
        } while (pos != startPos);
        this.channel.position(pos);
        long endTime = new Date().getTime();
        if (endTime - startTime > 1000L) {
            log.info("Spent {} seconds doing {} backwards seeks", (Object)((double)(endTime - startTime) / 1000.0), (Object)numMoves);
        }
        return null;
    }

    @Override
    public synchronized StoredBlock getChainHead() throws BlockStoreException {
        this.ensureOpen();
        StoredBlock head = this.get(this.chainHead);
        if (head == null) {
            throw new BlockStoreException("Corrupted block store: chain head not found");
        }
        return head;
    }

    @Override
    public synchronized void setChainHead(StoredBlock chainHead) throws BlockStoreException {
        this.ensureOpen();
        try {
            this.chainHead = chainHead.getHeader().getHash();
            this.channel.write(ByteBuffer.wrap(this.chainHead.getBytes()), 1L);
        }
        catch (IOException e) {
            throw new BlockStoreException(e);
        }
    }

    @Override
    public void close() throws BlockStoreException {
        this.ensureOpen();
        try {
            this.file.close();
        }
        catch (IOException e) {
            throw new BlockStoreException(e);
        }
        finally {
            semaphores.release(this.fileName);
            this.file = null;
        }
    }

    private static class Record {
        private static final int CHAIN_WORK_BYTES = 16;
        private static final byte[] EMPTY_BYTES = new byte[16];
        private int height = 0;
        private byte[] chainWork = new byte[16];
        private byte[] blockHeader = new byte[80];
        public static final int SIZE = 100;

        public static void write(FileChannel channel, StoredBlock block) throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(100);
            buf.putInt(block.getHeight());
            byte[] chainWorkBytes = block.getChainWork().toByteArray();
            Preconditions.checkState((chainWorkBytes.length <= 16 ? 1 : 0) != 0, (Object)"Ran out of space to store chain work!");
            if (chainWorkBytes.length < 16) {
                buf.put(EMPTY_BYTES, 0, 16 - chainWorkBytes.length);
            }
            buf.put(chainWorkBytes);
            buf.put(block.getHeader().cloneAsHeader().bitcoinSerialize());
            buf.position(0);
            channel.position(channel.size());
            if (channel.write(buf) < 100) {
                throw new IOException("Failed to write record!");
            }
            channel.position(channel.size() - 100L);
        }

        public boolean read(FileChannel channel, long position, ByteBuffer buffer) throws IOException {
            buffer.position(0);
            long bytesRead = channel.read(buffer, position);
            if (bytesRead < 100L) {
                return false;
            }
            buffer.position(0);
            this.height = buffer.getInt();
            buffer.get(this.chainWork);
            buffer.get(this.blockHeader);
            return true;
        }

        public BigInteger getChainWork() {
            return new BigInteger(1, this.chainWork);
        }

        public Block getHeader(NetworkParameters params) throws ProtocolException {
            return new Block(params, this.blockHeader);
        }

        public int getHeight() {
            return this.height;
        }

        public StoredBlock toStoredBlock(NetworkParameters params) throws ProtocolException {
            return new StoredBlock(this.getHeader(params), this.getChainWork(), this.getHeight());
        }
    }
}

