/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.store;

import com.google.bitcoin.store.TransactionalHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class TransactionalMultiKeyHashMap<UniqueKeyType, MultiKeyType, ValueType> {
    TransactionalHashMap<UniqueKeyType, ValueType> mapValues = new TransactionalHashMap();
    HashMap<MultiKeyType, Set<UniqueKeyType>> mapKeys = new HashMap();

    public void BeginTransaction() {
        this.mapValues.beginDatabaseBatchWrite();
    }

    public void CommitTransaction() {
        this.mapValues.commitDatabaseBatchWrite();
    }

    public void AbortTransaction() {
        this.mapValues.abortDatabaseBatchWrite();
    }

    public ValueType get(UniqueKeyType key) {
        return this.mapValues.get(key);
    }

    public void put(UniqueKeyType uniqueKey, MultiKeyType multiKey, ValueType value) {
        this.mapValues.put(uniqueKey, value);
        Set<UniqueKeyType> set = this.mapKeys.get(multiKey);
        if (set == null) {
            set = new HashSet<UniqueKeyType>();
            set.add(uniqueKey);
            this.mapKeys.put(multiKey, set);
        } else {
            set.add(uniqueKey);
        }
    }

    public ValueType removeByUniqueKey(UniqueKeyType key) {
        return this.mapValues.remove(key);
    }

    public void removeByMultiKey(MultiKeyType key) {
        Set<UniqueKeyType> set = this.mapKeys.remove(key);
        if (set != null) {
            for (UniqueKeyType uniqueKey : set) {
                this.removeByUniqueKey(uniqueKey);
            }
        }
    }
}

