(ns warpcore.emailqueue
  (:require [clojure.core.async :as async :refer [>! <! chan go go-loop]]
            [postal.core :as postal]
            [environ.core :refer [env]]
            [taoensso.timbre :as timbre]))

(timbre/refer-timbre)

(defonce ^:dynamic *queue* (chan))

(defn send! [{:keys [to from subject body] :as email}]
  {:pre [to from subject body]}
  (info "[EMAIL] Sending email:" email)
  (postal/send-message
   {:host (env :smtp-hostname)
    :ssl :yes
    :user (env :smtp-login)
    :pass (env :smtp-password)}
   email))

(defn send-safe! [{:keys [to from subject body] :as email}]
  (if (and to from subject body)
    (send! email)
    (error "Invalid email, could not send:" email)))

(defn init! []
  (info "Initializing email queue")
  (go-loop []
    (let [email (<! *queue*)]
      (try (send-safe! email)
           (catch Exception e
             (error e)
             (.printStackTrace e))))
    (recur))
  *queue*)

(defn enqueue! [email]
  (info "Enqueueing email: " email)
  (go (>! *queue* email)))
