![Prismo](prismo.gif)

# prismo

A Clojure wrapping the java couchbase-client 2.x

## Usage

### Synopsis

```clojure
user> (require '[prismo.core :as p])
nil
user> (def cluster (p/create-cluster ["couchbase-1.example.com"
                                      "couchbase-2.exampled.com"]))
#'user/cluster
user> (def bucket (p/open-bucket cluster "default"))
#'user/bucket
user> (p/insert bucket (p/make-raw-json-document "foo" {"pi" 3.14}))
#<RawJsonDocument RawJsonDocument{id='foo', cas=593401636448764, expiry=0, content={"pi":3.14}}>
user> (p/get bucket (p/make-raw-json-document "foo"))
#<RawJsonDocument RawJsonDocument{id='foo', cas=593401636448764, expiry=0, content={"pi":3.14}}>
user> (p/content *1)
{"pi" 3.14}
user> (p/remove bucket (p/make-raw-json-document "foo"))
#<RawJsonDocument RawJsonDocument{id='foo', cas=593401636448765, expiry=0, content=null}>
```

### Inserting, removing, or getting multiple documents at once

The functions `multi-insert`, `multi-get`, and `multi-remove` submit
multiple operations asyncronously to Couchbase, then waits for them
all to continue before returning.

All the `multi-…` functions take two arguments: a bucket, and a
sequence of documents. They return a sequence of results. There is a
result for each input document, and the results are in the same order
as the input documents. The results are typically documents but they
can also be `Exception` instances or `nil`, as explained in the
following:

* If you specify `:on-error :collect` to any of the `multi-…`
  functions, then any exceptions that are thrown during the
  asyncronous operations will be caught, and the `Exception` instances
  will be included at the appropriate place in the results sequence.
  ```clojure
user> (p/multi-insert bucket [(p/make-raw-json-document "foo" 3.14)
                                  (p/make-raw-json-document "bar" 2.72)]
                                  :on-error :collect)
(#<DocumentAlreadyExistsException com.couchbase.client.java.error.DocumentAlreadyExistsException>
     #<RawJsonDocument RawJsonDocument{id='bar', cas=586974473324637, expiry=0, content=2.72}>)
```

* If you specify `:on-error :throw` (the default), an `ExceptionInfo`
  will be thrown if any of the operations throws an exception. In the
  exception data, `:results` maps to the sequence of results that
  would have been returned if you had specified `:on-error :collect`.
  ```clojure
user> (p/multi-insert bucket [(p/make-raw-json-document "foo" 3.14)
                                  (p/make-raw-json-document "bar" 2.72)])
ExceptionInfo Some :insert operations failed.  clojure.core/ex-info (core.clj:4577)
user> (:results (ex-data *e))
(#<DocumentAlreadyExistsException com.couchbase.client.java.error.DocumentAlreadyExistsException>
     #<RawJsonDocument RawJsonDocument{id='bar', cas=587239143980322, expiry=0, content=2.72}>)
```

* If you specify `:if-does-not-exist` to `multi-remove`, a missing
  document will lead to a `nil` in the results list:
  ```clojure
user> (p/multi-remove bucket [(p/make-raw-json-document "foo")
                                  (p/make-raw-json-document "bar")]
                                  :if-does-not-exist :ignore)
(#<RawJsonDocument RawJsonDocument{id='foo', cas=591891927054114, expiry=0, content=null}>
     nil)
```

## License

Copyright © 2015 Yieldbot, Inc.

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
