(ns prismo.rx
  (:require [rx.lang.clojure.interop :as rx]
            [clojure.tools.logging :as log])
  (:import [rx Observable]))

(defn- get-multi-operator [operator]
  ;; Java methods are not first-class functions, so we make our own.
  (case operator
    :insert #(.insert %1 %2)
    :upsert #(.upsert %1 %2)
    :remove #(.remove %1 %2)
    :get #(.get %1 %2)))

(defn multi
  "Apply an operation to documents or keys (depending on the
  operation) in parallel. Emits vectors, each with two elements: (1) a
  document or key and (2) the result of the operation or an
  exception."
  [operator bucket coll]
  (-> (Observable/from coll)
      (.flatMap (rx/fn [d]
                  (-> bucket 
                      .async
                      ((get-multi-operator operator) d)
                      (.onErrorReturn (rx/fn [e] e))
                      (.map (rx/fn [v] [d v])))))))
