package prismo;

import rx.Observable;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.RawJsonDocument;
import rx.functions.Func1;
import java.util.concurrent.TimeUnit;
import java.util.List;
import java.util.Collection;

public class BulkGet {
  public static Observable<List<RawJsonDocument>> bulkGet(final Bucket bucket, final Collection<RawJsonDocument> docs) {
    return Observable
        .from(docs)
        .flatMap(new Func1<RawJsonDocument, Observable<RawJsonDocument>>() {
            @Override
            public Observable<RawJsonDocument> call(RawJsonDocument doc) {
               return bucket.async().get(doc).timeout(10, TimeUnit.MILLISECONDS);
            }
        })
      .toList();
  }
}
