// Compiled by ClojureScript 1.7.122 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async37959 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37959 = (function (fn_handler,f,meta37960){
this.fn_handler = fn_handler;
this.f = f;
this.meta37960 = meta37960;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37959.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37961,meta37960__$1){
var self__ = this;
var _37961__$1 = this;
return (new cljs.core.async.t_cljs$core$async37959(self__.fn_handler,self__.f,meta37960__$1));
});

cljs.core.async.t_cljs$core$async37959.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37961){
var self__ = this;
var _37961__$1 = this;
return self__.meta37960;
});

cljs.core.async.t_cljs$core$async37959.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async37959.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async37959.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async37959.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta37960","meta37960",993674472,null)], null);
});

cljs.core.async.t_cljs$core$async37959.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37959.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37959";

cljs.core.async.t_cljs$core$async37959.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cljs.core.async/t_cljs$core$async37959");
});

cljs.core.async.__GT_t_cljs$core$async37959 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async37959(fn_handler__$1,f__$1,meta37960){
return (new cljs.core.async.t_cljs$core$async37959(fn_handler__$1,f__$1,meta37960));
});

}

return (new cljs.core.async.t_cljs$core$async37959(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args37964 = [];
var len__17407__auto___37967 = arguments.length;
var i__17408__auto___37968 = (0);
while(true){
if((i__17408__auto___37968 < len__17407__auto___37967)){
args37964.push((arguments[i__17408__auto___37968]));

var G__37969 = (i__17408__auto___37968 + (1));
i__17408__auto___37968 = G__37969;
continue;
} else {
}
break;
}

var G__37966 = args37964.length;
switch (G__37966) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37964.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args37971 = [];
var len__17407__auto___37974 = arguments.length;
var i__17408__auto___37975 = (0);
while(true){
if((i__17408__auto___37975 < len__17407__auto___37974)){
args37971.push((arguments[i__17408__auto___37975]));

var G__37976 = (i__17408__auto___37975 + (1));
i__17408__auto___37975 = G__37976;
continue;
} else {
}
break;
}

var G__37973 = args37971.length;
switch (G__37973) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37971.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_37978 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_37978);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_37978,ret){
return (function (){
return fn1.call(null,val_37978);
});})(val_37978,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args37979 = [];
var len__17407__auto___37982 = arguments.length;
var i__17408__auto___37983 = (0);
while(true){
if((i__17408__auto___37983 < len__17407__auto___37982)){
args37979.push((arguments[i__17408__auto___37983]));

var G__37984 = (i__17408__auto___37983 + (1));
i__17408__auto___37983 = G__37984;
continue;
} else {
}
break;
}

var G__37981 = args37979.length;
switch (G__37981) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37979.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__17252__auto___37986 = n;
var x_37987 = (0);
while(true){
if((x_37987 < n__17252__auto___37986)){
(a[x_37987] = (0));

var G__37988 = (x_37987 + (1));
x_37987 = G__37988;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__37989 = (i + (1));
i = G__37989;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async37993 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37993 = (function (alt_flag,flag,meta37994){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta37994 = meta37994;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37993.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_37995,meta37994__$1){
var self__ = this;
var _37995__$1 = this;
return (new cljs.core.async.t_cljs$core$async37993(self__.alt_flag,self__.flag,meta37994__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async37993.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_37995){
var self__ = this;
var _37995__$1 = this;
return self__.meta37994;
});})(flag))
;

cljs.core.async.t_cljs$core$async37993.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async37993.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async37993.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async37993.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta37994","meta37994",902134948,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async37993.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37993.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37993";

cljs.core.async.t_cljs$core$async37993.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cljs.core.async/t_cljs$core$async37993");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async37993 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async37993(alt_flag__$1,flag__$1,meta37994){
return (new cljs.core.async.t_cljs$core$async37993(alt_flag__$1,flag__$1,meta37994));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async37993(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async37999 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37999 = (function (alt_handler,flag,cb,meta38000){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta38000 = meta38000;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async37999.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38001,meta38000__$1){
var self__ = this;
var _38001__$1 = this;
return (new cljs.core.async.t_cljs$core$async37999(self__.alt_handler,self__.flag,self__.cb,meta38000__$1));
});

cljs.core.async.t_cljs$core$async37999.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38001){
var self__ = this;
var _38001__$1 = this;
return self__.meta38000;
});

cljs.core.async.t_cljs$core$async37999.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async37999.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async37999.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async37999.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta38000","meta38000",1786447982,null)], null);
});

cljs.core.async.t_cljs$core$async37999.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37999.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37999";

cljs.core.async.t_cljs$core$async37999.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cljs.core.async/t_cljs$core$async37999");
});

cljs.core.async.__GT_t_cljs$core$async37999 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async37999(alt_handler__$1,flag__$1,cb__$1,meta38000){
return (new cljs.core.async.t_cljs$core$async37999(alt_handler__$1,flag__$1,cb__$1,meta38000));
});

}

return (new cljs.core.async.t_cljs$core$async37999(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__38002_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__38002_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__38003_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__38003_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__16349__auto__ = wport;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return port;
}
})()], null));
} else {
var G__38004 = (i + (1));
i = G__38004;
continue;
}
} else {
return null;
}
break;
}
})();
var or__16349__auto__ = ret;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__16337__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__16337__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__16337__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__17414__auto__ = [];
var len__17407__auto___38010 = arguments.length;
var i__17408__auto___38011 = (0);
while(true){
if((i__17408__auto___38011 < len__17407__auto___38010)){
args__17414__auto__.push((arguments[i__17408__auto___38011]));

var G__38012 = (i__17408__auto___38011 + (1));
i__17408__auto___38011 = G__38012;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__38007){
var map__38008 = p__38007;
var map__38008__$1 = ((((!((map__38008 == null)))?((((map__38008.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38008.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38008):map__38008);
var opts = map__38008__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq38005){
var G__38006 = cljs.core.first.call(null,seq38005);
var seq38005__$1 = cljs.core.next.call(null,seq38005);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__38006,seq38005__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args38013 = [];
var len__17407__auto___38063 = arguments.length;
var i__17408__auto___38064 = (0);
while(true){
if((i__17408__auto___38064 < len__17407__auto___38063)){
args38013.push((arguments[i__17408__auto___38064]));

var G__38065 = (i__17408__auto___38064 + (1));
i__17408__auto___38064 = G__38065;
continue;
} else {
}
break;
}

var G__38015 = args38013.length;
switch (G__38015) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38013.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__19429__auto___38067 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___38067){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___38067){
return (function (state_38039){
var state_val_38040 = (state_38039[(1)]);
if((state_val_38040 === (7))){
var inst_38035 = (state_38039[(2)]);
var state_38039__$1 = state_38039;
var statearr_38041_38068 = state_38039__$1;
(statearr_38041_38068[(2)] = inst_38035);

(statearr_38041_38068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38040 === (1))){
var state_38039__$1 = state_38039;
var statearr_38042_38069 = state_38039__$1;
(statearr_38042_38069[(2)] = null);

(statearr_38042_38069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38040 === (4))){
var inst_38018 = (state_38039[(7)]);
var inst_38018__$1 = (state_38039[(2)]);
var inst_38019 = (inst_38018__$1 == null);
var state_38039__$1 = (function (){var statearr_38043 = state_38039;
(statearr_38043[(7)] = inst_38018__$1);

return statearr_38043;
})();
if(cljs.core.truth_(inst_38019)){
var statearr_38044_38070 = state_38039__$1;
(statearr_38044_38070[(1)] = (5));

} else {
var statearr_38045_38071 = state_38039__$1;
(statearr_38045_38071[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38040 === (13))){
var state_38039__$1 = state_38039;
var statearr_38046_38072 = state_38039__$1;
(statearr_38046_38072[(2)] = null);

(statearr_38046_38072[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38040 === (6))){
var inst_38018 = (state_38039[(7)]);
var state_38039__$1 = state_38039;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38039__$1,(11),to,inst_38018);
} else {
if((state_val_38040 === (3))){
var inst_38037 = (state_38039[(2)]);
var state_38039__$1 = state_38039;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38039__$1,inst_38037);
} else {
if((state_val_38040 === (12))){
var state_38039__$1 = state_38039;
var statearr_38047_38073 = state_38039__$1;
(statearr_38047_38073[(2)] = null);

(statearr_38047_38073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38040 === (2))){
var state_38039__$1 = state_38039;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38039__$1,(4),from);
} else {
if((state_val_38040 === (11))){
var inst_38028 = (state_38039[(2)]);
var state_38039__$1 = state_38039;
if(cljs.core.truth_(inst_38028)){
var statearr_38048_38074 = state_38039__$1;
(statearr_38048_38074[(1)] = (12));

} else {
var statearr_38049_38075 = state_38039__$1;
(statearr_38049_38075[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38040 === (9))){
var state_38039__$1 = state_38039;
var statearr_38050_38076 = state_38039__$1;
(statearr_38050_38076[(2)] = null);

(statearr_38050_38076[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38040 === (5))){
var state_38039__$1 = state_38039;
if(cljs.core.truth_(close_QMARK_)){
var statearr_38051_38077 = state_38039__$1;
(statearr_38051_38077[(1)] = (8));

} else {
var statearr_38052_38078 = state_38039__$1;
(statearr_38052_38078[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38040 === (14))){
var inst_38033 = (state_38039[(2)]);
var state_38039__$1 = state_38039;
var statearr_38053_38079 = state_38039__$1;
(statearr_38053_38079[(2)] = inst_38033);

(statearr_38053_38079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38040 === (10))){
var inst_38025 = (state_38039[(2)]);
var state_38039__$1 = state_38039;
var statearr_38054_38080 = state_38039__$1;
(statearr_38054_38080[(2)] = inst_38025);

(statearr_38054_38080[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38040 === (8))){
var inst_38022 = cljs.core.async.close_BANG_.call(null,to);
var state_38039__$1 = state_38039;
var statearr_38055_38081 = state_38039__$1;
(statearr_38055_38081[(2)] = inst_38022);

(statearr_38055_38081[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___38067))
;
return ((function (switch__19364__auto__,c__19429__auto___38067){
return (function() {
var cljs$core$async$state_machine__19365__auto__ = null;
var cljs$core$async$state_machine__19365__auto____0 = (function (){
var statearr_38059 = [null,null,null,null,null,null,null,null];
(statearr_38059[(0)] = cljs$core$async$state_machine__19365__auto__);

(statearr_38059[(1)] = (1));

return statearr_38059;
});
var cljs$core$async$state_machine__19365__auto____1 = (function (state_38039){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_38039);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e38060){if((e38060 instanceof Object)){
var ex__19368__auto__ = e38060;
var statearr_38061_38082 = state_38039;
(statearr_38061_38082[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38039);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38060;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38083 = state_38039;
state_38039 = G__38083;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$state_machine__19365__auto__ = function(state_38039){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19365__auto____1.call(this,state_38039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19365__auto____0;
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19365__auto____1;
return cljs$core$async$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___38067))
})();
var state__19431__auto__ = (function (){var statearr_38062 = f__19430__auto__.call(null);
(statearr_38062[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___38067);

return statearr_38062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___38067))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__38267){
var vec__38268 = p__38267;
var v = cljs.core.nth.call(null,vec__38268,(0),null);
var p = cljs.core.nth.call(null,vec__38268,(1),null);
var job = vec__38268;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__19429__auto___38450 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___38450,res,vec__38268,v,p,job,jobs,results){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___38450,res,vec__38268,v,p,job,jobs,results){
return (function (state_38273){
var state_val_38274 = (state_38273[(1)]);
if((state_val_38274 === (1))){
var state_38273__$1 = state_38273;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38273__$1,(2),res,v);
} else {
if((state_val_38274 === (2))){
var inst_38270 = (state_38273[(2)]);
var inst_38271 = cljs.core.async.close_BANG_.call(null,res);
var state_38273__$1 = (function (){var statearr_38275 = state_38273;
(statearr_38275[(7)] = inst_38270);

return statearr_38275;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38273__$1,inst_38271);
} else {
return null;
}
}
});})(c__19429__auto___38450,res,vec__38268,v,p,job,jobs,results))
;
return ((function (switch__19364__auto__,c__19429__auto___38450,res,vec__38268,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0 = (function (){
var statearr_38279 = [null,null,null,null,null,null,null,null];
(statearr_38279[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__);

(statearr_38279[(1)] = (1));

return statearr_38279;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1 = (function (state_38273){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_38273);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e38280){if((e38280 instanceof Object)){
var ex__19368__auto__ = e38280;
var statearr_38281_38451 = state_38273;
(statearr_38281_38451[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38273);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38280;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38452 = state_38273;
state_38273 = G__38452;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__ = function(state_38273){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1.call(this,state_38273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___38450,res,vec__38268,v,p,job,jobs,results))
})();
var state__19431__auto__ = (function (){var statearr_38282 = f__19430__auto__.call(null);
(statearr_38282[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___38450);

return statearr_38282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___38450,res,vec__38268,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__38283){
var vec__38284 = p__38283;
var v = cljs.core.nth.call(null,vec__38284,(0),null);
var p = cljs.core.nth.call(null,vec__38284,(1),null);
var job = vec__38284;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__17252__auto___38453 = n;
var __38454 = (0);
while(true){
if((__38454 < n__17252__auto___38453)){
var G__38285_38455 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__38285_38455) {
case "compute":
var c__19429__auto___38457 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__38454,c__19429__auto___38457,G__38285_38455,n__17252__auto___38453,jobs,results,process,async){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (__38454,c__19429__auto___38457,G__38285_38455,n__17252__auto___38453,jobs,results,process,async){
return (function (state_38298){
var state_val_38299 = (state_38298[(1)]);
if((state_val_38299 === (1))){
var state_38298__$1 = state_38298;
var statearr_38300_38458 = state_38298__$1;
(statearr_38300_38458[(2)] = null);

(statearr_38300_38458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38299 === (2))){
var state_38298__$1 = state_38298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38298__$1,(4),jobs);
} else {
if((state_val_38299 === (3))){
var inst_38296 = (state_38298[(2)]);
var state_38298__$1 = state_38298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38298__$1,inst_38296);
} else {
if((state_val_38299 === (4))){
var inst_38288 = (state_38298[(2)]);
var inst_38289 = process.call(null,inst_38288);
var state_38298__$1 = state_38298;
if(cljs.core.truth_(inst_38289)){
var statearr_38301_38459 = state_38298__$1;
(statearr_38301_38459[(1)] = (5));

} else {
var statearr_38302_38460 = state_38298__$1;
(statearr_38302_38460[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38299 === (5))){
var state_38298__$1 = state_38298;
var statearr_38303_38461 = state_38298__$1;
(statearr_38303_38461[(2)] = null);

(statearr_38303_38461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38299 === (6))){
var state_38298__$1 = state_38298;
var statearr_38304_38462 = state_38298__$1;
(statearr_38304_38462[(2)] = null);

(statearr_38304_38462[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38299 === (7))){
var inst_38294 = (state_38298[(2)]);
var state_38298__$1 = state_38298;
var statearr_38305_38463 = state_38298__$1;
(statearr_38305_38463[(2)] = inst_38294);

(statearr_38305_38463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__38454,c__19429__auto___38457,G__38285_38455,n__17252__auto___38453,jobs,results,process,async))
;
return ((function (__38454,switch__19364__auto__,c__19429__auto___38457,G__38285_38455,n__17252__auto___38453,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0 = (function (){
var statearr_38309 = [null,null,null,null,null,null,null];
(statearr_38309[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__);

(statearr_38309[(1)] = (1));

return statearr_38309;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1 = (function (state_38298){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_38298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e38310){if((e38310 instanceof Object)){
var ex__19368__auto__ = e38310;
var statearr_38311_38464 = state_38298;
(statearr_38311_38464[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38310;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38465 = state_38298;
state_38298 = G__38465;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__ = function(state_38298){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1.call(this,state_38298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__;
})()
;})(__38454,switch__19364__auto__,c__19429__auto___38457,G__38285_38455,n__17252__auto___38453,jobs,results,process,async))
})();
var state__19431__auto__ = (function (){var statearr_38312 = f__19430__auto__.call(null);
(statearr_38312[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___38457);

return statearr_38312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(__38454,c__19429__auto___38457,G__38285_38455,n__17252__auto___38453,jobs,results,process,async))
);


break;
case "async":
var c__19429__auto___38466 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__38454,c__19429__auto___38466,G__38285_38455,n__17252__auto___38453,jobs,results,process,async){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (__38454,c__19429__auto___38466,G__38285_38455,n__17252__auto___38453,jobs,results,process,async){
return (function (state_38325){
var state_val_38326 = (state_38325[(1)]);
if((state_val_38326 === (1))){
var state_38325__$1 = state_38325;
var statearr_38327_38467 = state_38325__$1;
(statearr_38327_38467[(2)] = null);

(statearr_38327_38467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38326 === (2))){
var state_38325__$1 = state_38325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38325__$1,(4),jobs);
} else {
if((state_val_38326 === (3))){
var inst_38323 = (state_38325[(2)]);
var state_38325__$1 = state_38325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38325__$1,inst_38323);
} else {
if((state_val_38326 === (4))){
var inst_38315 = (state_38325[(2)]);
var inst_38316 = async.call(null,inst_38315);
var state_38325__$1 = state_38325;
if(cljs.core.truth_(inst_38316)){
var statearr_38328_38468 = state_38325__$1;
(statearr_38328_38468[(1)] = (5));

} else {
var statearr_38329_38469 = state_38325__$1;
(statearr_38329_38469[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38326 === (5))){
var state_38325__$1 = state_38325;
var statearr_38330_38470 = state_38325__$1;
(statearr_38330_38470[(2)] = null);

(statearr_38330_38470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38326 === (6))){
var state_38325__$1 = state_38325;
var statearr_38331_38471 = state_38325__$1;
(statearr_38331_38471[(2)] = null);

(statearr_38331_38471[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38326 === (7))){
var inst_38321 = (state_38325[(2)]);
var state_38325__$1 = state_38325;
var statearr_38332_38472 = state_38325__$1;
(statearr_38332_38472[(2)] = inst_38321);

(statearr_38332_38472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__38454,c__19429__auto___38466,G__38285_38455,n__17252__auto___38453,jobs,results,process,async))
;
return ((function (__38454,switch__19364__auto__,c__19429__auto___38466,G__38285_38455,n__17252__auto___38453,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0 = (function (){
var statearr_38336 = [null,null,null,null,null,null,null];
(statearr_38336[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__);

(statearr_38336[(1)] = (1));

return statearr_38336;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1 = (function (state_38325){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_38325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e38337){if((e38337 instanceof Object)){
var ex__19368__auto__ = e38337;
var statearr_38338_38473 = state_38325;
(statearr_38338_38473[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38325);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38337;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38474 = state_38325;
state_38325 = G__38474;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__ = function(state_38325){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1.call(this,state_38325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__;
})()
;})(__38454,switch__19364__auto__,c__19429__auto___38466,G__38285_38455,n__17252__auto___38453,jobs,results,process,async))
})();
var state__19431__auto__ = (function (){var statearr_38339 = f__19430__auto__.call(null);
(statearr_38339[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___38466);

return statearr_38339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(__38454,c__19429__auto___38466,G__38285_38455,n__17252__auto___38453,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__38475 = (__38454 + (1));
__38454 = G__38475;
continue;
} else {
}
break;
}

var c__19429__auto___38476 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___38476,jobs,results,process,async){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___38476,jobs,results,process,async){
return (function (state_38361){
var state_val_38362 = (state_38361[(1)]);
if((state_val_38362 === (1))){
var state_38361__$1 = state_38361;
var statearr_38363_38477 = state_38361__$1;
(statearr_38363_38477[(2)] = null);

(statearr_38363_38477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38362 === (2))){
var state_38361__$1 = state_38361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38361__$1,(4),from);
} else {
if((state_val_38362 === (3))){
var inst_38359 = (state_38361[(2)]);
var state_38361__$1 = state_38361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38361__$1,inst_38359);
} else {
if((state_val_38362 === (4))){
var inst_38342 = (state_38361[(7)]);
var inst_38342__$1 = (state_38361[(2)]);
var inst_38343 = (inst_38342__$1 == null);
var state_38361__$1 = (function (){var statearr_38364 = state_38361;
(statearr_38364[(7)] = inst_38342__$1);

return statearr_38364;
})();
if(cljs.core.truth_(inst_38343)){
var statearr_38365_38478 = state_38361__$1;
(statearr_38365_38478[(1)] = (5));

} else {
var statearr_38366_38479 = state_38361__$1;
(statearr_38366_38479[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38362 === (5))){
var inst_38345 = cljs.core.async.close_BANG_.call(null,jobs);
var state_38361__$1 = state_38361;
var statearr_38367_38480 = state_38361__$1;
(statearr_38367_38480[(2)] = inst_38345);

(statearr_38367_38480[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38362 === (6))){
var inst_38347 = (state_38361[(8)]);
var inst_38342 = (state_38361[(7)]);
var inst_38347__$1 = cljs.core.async.chan.call(null,(1));
var inst_38348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38349 = [inst_38342,inst_38347__$1];
var inst_38350 = (new cljs.core.PersistentVector(null,2,(5),inst_38348,inst_38349,null));
var state_38361__$1 = (function (){var statearr_38368 = state_38361;
(statearr_38368[(8)] = inst_38347__$1);

return statearr_38368;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38361__$1,(8),jobs,inst_38350);
} else {
if((state_val_38362 === (7))){
var inst_38357 = (state_38361[(2)]);
var state_38361__$1 = state_38361;
var statearr_38369_38481 = state_38361__$1;
(statearr_38369_38481[(2)] = inst_38357);

(statearr_38369_38481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38362 === (8))){
var inst_38347 = (state_38361[(8)]);
var inst_38352 = (state_38361[(2)]);
var state_38361__$1 = (function (){var statearr_38370 = state_38361;
(statearr_38370[(9)] = inst_38352);

return statearr_38370;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38361__$1,(9),results,inst_38347);
} else {
if((state_val_38362 === (9))){
var inst_38354 = (state_38361[(2)]);
var state_38361__$1 = (function (){var statearr_38371 = state_38361;
(statearr_38371[(10)] = inst_38354);

return statearr_38371;
})();
var statearr_38372_38482 = state_38361__$1;
(statearr_38372_38482[(2)] = null);

(statearr_38372_38482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___38476,jobs,results,process,async))
;
return ((function (switch__19364__auto__,c__19429__auto___38476,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0 = (function (){
var statearr_38376 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38376[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__);

(statearr_38376[(1)] = (1));

return statearr_38376;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1 = (function (state_38361){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_38361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e38377){if((e38377 instanceof Object)){
var ex__19368__auto__ = e38377;
var statearr_38378_38483 = state_38361;
(statearr_38378_38483[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38361);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38377;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38484 = state_38361;
state_38361 = G__38484;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__ = function(state_38361){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1.call(this,state_38361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___38476,jobs,results,process,async))
})();
var state__19431__auto__ = (function (){var statearr_38379 = f__19430__auto__.call(null);
(statearr_38379[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___38476);

return statearr_38379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___38476,jobs,results,process,async))
);


var c__19429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto__,jobs,results,process,async){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto__,jobs,results,process,async){
return (function (state_38417){
var state_val_38418 = (state_38417[(1)]);
if((state_val_38418 === (7))){
var inst_38413 = (state_38417[(2)]);
var state_38417__$1 = state_38417;
var statearr_38419_38485 = state_38417__$1;
(statearr_38419_38485[(2)] = inst_38413);

(statearr_38419_38485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (20))){
var state_38417__$1 = state_38417;
var statearr_38420_38486 = state_38417__$1;
(statearr_38420_38486[(2)] = null);

(statearr_38420_38486[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (1))){
var state_38417__$1 = state_38417;
var statearr_38421_38487 = state_38417__$1;
(statearr_38421_38487[(2)] = null);

(statearr_38421_38487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (4))){
var inst_38382 = (state_38417[(7)]);
var inst_38382__$1 = (state_38417[(2)]);
var inst_38383 = (inst_38382__$1 == null);
var state_38417__$1 = (function (){var statearr_38422 = state_38417;
(statearr_38422[(7)] = inst_38382__$1);

return statearr_38422;
})();
if(cljs.core.truth_(inst_38383)){
var statearr_38423_38488 = state_38417__$1;
(statearr_38423_38488[(1)] = (5));

} else {
var statearr_38424_38489 = state_38417__$1;
(statearr_38424_38489[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (15))){
var inst_38395 = (state_38417[(8)]);
var state_38417__$1 = state_38417;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38417__$1,(18),to,inst_38395);
} else {
if((state_val_38418 === (21))){
var inst_38408 = (state_38417[(2)]);
var state_38417__$1 = state_38417;
var statearr_38425_38490 = state_38417__$1;
(statearr_38425_38490[(2)] = inst_38408);

(statearr_38425_38490[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (13))){
var inst_38410 = (state_38417[(2)]);
var state_38417__$1 = (function (){var statearr_38426 = state_38417;
(statearr_38426[(9)] = inst_38410);

return statearr_38426;
})();
var statearr_38427_38491 = state_38417__$1;
(statearr_38427_38491[(2)] = null);

(statearr_38427_38491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (6))){
var inst_38382 = (state_38417[(7)]);
var state_38417__$1 = state_38417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38417__$1,(11),inst_38382);
} else {
if((state_val_38418 === (17))){
var inst_38403 = (state_38417[(2)]);
var state_38417__$1 = state_38417;
if(cljs.core.truth_(inst_38403)){
var statearr_38428_38492 = state_38417__$1;
(statearr_38428_38492[(1)] = (19));

} else {
var statearr_38429_38493 = state_38417__$1;
(statearr_38429_38493[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (3))){
var inst_38415 = (state_38417[(2)]);
var state_38417__$1 = state_38417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38417__$1,inst_38415);
} else {
if((state_val_38418 === (12))){
var inst_38392 = (state_38417[(10)]);
var state_38417__$1 = state_38417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38417__$1,(14),inst_38392);
} else {
if((state_val_38418 === (2))){
var state_38417__$1 = state_38417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38417__$1,(4),results);
} else {
if((state_val_38418 === (19))){
var state_38417__$1 = state_38417;
var statearr_38430_38494 = state_38417__$1;
(statearr_38430_38494[(2)] = null);

(statearr_38430_38494[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (11))){
var inst_38392 = (state_38417[(2)]);
var state_38417__$1 = (function (){var statearr_38431 = state_38417;
(statearr_38431[(10)] = inst_38392);

return statearr_38431;
})();
var statearr_38432_38495 = state_38417__$1;
(statearr_38432_38495[(2)] = null);

(statearr_38432_38495[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (9))){
var state_38417__$1 = state_38417;
var statearr_38433_38496 = state_38417__$1;
(statearr_38433_38496[(2)] = null);

(statearr_38433_38496[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (5))){
var state_38417__$1 = state_38417;
if(cljs.core.truth_(close_QMARK_)){
var statearr_38434_38497 = state_38417__$1;
(statearr_38434_38497[(1)] = (8));

} else {
var statearr_38435_38498 = state_38417__$1;
(statearr_38435_38498[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (14))){
var inst_38395 = (state_38417[(8)]);
var inst_38397 = (state_38417[(11)]);
var inst_38395__$1 = (state_38417[(2)]);
var inst_38396 = (inst_38395__$1 == null);
var inst_38397__$1 = cljs.core.not.call(null,inst_38396);
var state_38417__$1 = (function (){var statearr_38436 = state_38417;
(statearr_38436[(8)] = inst_38395__$1);

(statearr_38436[(11)] = inst_38397__$1);

return statearr_38436;
})();
if(inst_38397__$1){
var statearr_38437_38499 = state_38417__$1;
(statearr_38437_38499[(1)] = (15));

} else {
var statearr_38438_38500 = state_38417__$1;
(statearr_38438_38500[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (16))){
var inst_38397 = (state_38417[(11)]);
var state_38417__$1 = state_38417;
var statearr_38439_38501 = state_38417__$1;
(statearr_38439_38501[(2)] = inst_38397);

(statearr_38439_38501[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (10))){
var inst_38389 = (state_38417[(2)]);
var state_38417__$1 = state_38417;
var statearr_38440_38502 = state_38417__$1;
(statearr_38440_38502[(2)] = inst_38389);

(statearr_38440_38502[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (18))){
var inst_38400 = (state_38417[(2)]);
var state_38417__$1 = state_38417;
var statearr_38441_38503 = state_38417__$1;
(statearr_38441_38503[(2)] = inst_38400);

(statearr_38441_38503[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38418 === (8))){
var inst_38386 = cljs.core.async.close_BANG_.call(null,to);
var state_38417__$1 = state_38417;
var statearr_38442_38504 = state_38417__$1;
(statearr_38442_38504[(2)] = inst_38386);

(statearr_38442_38504[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto__,jobs,results,process,async))
;
return ((function (switch__19364__auto__,c__19429__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0 = (function (){
var statearr_38446 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38446[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__);

(statearr_38446[(1)] = (1));

return statearr_38446;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1 = (function (state_38417){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_38417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e38447){if((e38447 instanceof Object)){
var ex__19368__auto__ = e38447;
var statearr_38448_38505 = state_38417;
(statearr_38448_38505[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38417);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38447;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38506 = state_38417;
state_38417 = G__38506;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__ = function(state_38417){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1.call(this,state_38417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto__,jobs,results,process,async))
})();
var state__19431__auto__ = (function (){var statearr_38449 = f__19430__auto__.call(null);
(statearr_38449[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto__);

return statearr_38449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto__,jobs,results,process,async))
);

return c__19429__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args38507 = [];
var len__17407__auto___38510 = arguments.length;
var i__17408__auto___38511 = (0);
while(true){
if((i__17408__auto___38511 < len__17407__auto___38510)){
args38507.push((arguments[i__17408__auto___38511]));

var G__38512 = (i__17408__auto___38511 + (1));
i__17408__auto___38511 = G__38512;
continue;
} else {
}
break;
}

var G__38509 = args38507.length;
switch (G__38509) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38507.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args38514 = [];
var len__17407__auto___38517 = arguments.length;
var i__17408__auto___38518 = (0);
while(true){
if((i__17408__auto___38518 < len__17407__auto___38517)){
args38514.push((arguments[i__17408__auto___38518]));

var G__38519 = (i__17408__auto___38518 + (1));
i__17408__auto___38518 = G__38519;
continue;
} else {
}
break;
}

var G__38516 = args38514.length;
switch (G__38516) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38514.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args38521 = [];
var len__17407__auto___38574 = arguments.length;
var i__17408__auto___38575 = (0);
while(true){
if((i__17408__auto___38575 < len__17407__auto___38574)){
args38521.push((arguments[i__17408__auto___38575]));

var G__38576 = (i__17408__auto___38575 + (1));
i__17408__auto___38575 = G__38576;
continue;
} else {
}
break;
}

var G__38523 = args38521.length;
switch (G__38523) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38521.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__19429__auto___38578 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___38578,tc,fc){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___38578,tc,fc){
return (function (state_38549){
var state_val_38550 = (state_38549[(1)]);
if((state_val_38550 === (7))){
var inst_38545 = (state_38549[(2)]);
var state_38549__$1 = state_38549;
var statearr_38551_38579 = state_38549__$1;
(statearr_38551_38579[(2)] = inst_38545);

(statearr_38551_38579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38550 === (1))){
var state_38549__$1 = state_38549;
var statearr_38552_38580 = state_38549__$1;
(statearr_38552_38580[(2)] = null);

(statearr_38552_38580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38550 === (4))){
var inst_38526 = (state_38549[(7)]);
var inst_38526__$1 = (state_38549[(2)]);
var inst_38527 = (inst_38526__$1 == null);
var state_38549__$1 = (function (){var statearr_38553 = state_38549;
(statearr_38553[(7)] = inst_38526__$1);

return statearr_38553;
})();
if(cljs.core.truth_(inst_38527)){
var statearr_38554_38581 = state_38549__$1;
(statearr_38554_38581[(1)] = (5));

} else {
var statearr_38555_38582 = state_38549__$1;
(statearr_38555_38582[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38550 === (13))){
var state_38549__$1 = state_38549;
var statearr_38556_38583 = state_38549__$1;
(statearr_38556_38583[(2)] = null);

(statearr_38556_38583[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38550 === (6))){
var inst_38526 = (state_38549[(7)]);
var inst_38532 = p.call(null,inst_38526);
var state_38549__$1 = state_38549;
if(cljs.core.truth_(inst_38532)){
var statearr_38557_38584 = state_38549__$1;
(statearr_38557_38584[(1)] = (9));

} else {
var statearr_38558_38585 = state_38549__$1;
(statearr_38558_38585[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38550 === (3))){
var inst_38547 = (state_38549[(2)]);
var state_38549__$1 = state_38549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38549__$1,inst_38547);
} else {
if((state_val_38550 === (12))){
var state_38549__$1 = state_38549;
var statearr_38559_38586 = state_38549__$1;
(statearr_38559_38586[(2)] = null);

(statearr_38559_38586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38550 === (2))){
var state_38549__$1 = state_38549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38549__$1,(4),ch);
} else {
if((state_val_38550 === (11))){
var inst_38526 = (state_38549[(7)]);
var inst_38536 = (state_38549[(2)]);
var state_38549__$1 = state_38549;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38549__$1,(8),inst_38536,inst_38526);
} else {
if((state_val_38550 === (9))){
var state_38549__$1 = state_38549;
var statearr_38560_38587 = state_38549__$1;
(statearr_38560_38587[(2)] = tc);

(statearr_38560_38587[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38550 === (5))){
var inst_38529 = cljs.core.async.close_BANG_.call(null,tc);
var inst_38530 = cljs.core.async.close_BANG_.call(null,fc);
var state_38549__$1 = (function (){var statearr_38561 = state_38549;
(statearr_38561[(8)] = inst_38529);

return statearr_38561;
})();
var statearr_38562_38588 = state_38549__$1;
(statearr_38562_38588[(2)] = inst_38530);

(statearr_38562_38588[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38550 === (14))){
var inst_38543 = (state_38549[(2)]);
var state_38549__$1 = state_38549;
var statearr_38563_38589 = state_38549__$1;
(statearr_38563_38589[(2)] = inst_38543);

(statearr_38563_38589[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38550 === (10))){
var state_38549__$1 = state_38549;
var statearr_38564_38590 = state_38549__$1;
(statearr_38564_38590[(2)] = fc);

(statearr_38564_38590[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38550 === (8))){
var inst_38538 = (state_38549[(2)]);
var state_38549__$1 = state_38549;
if(cljs.core.truth_(inst_38538)){
var statearr_38565_38591 = state_38549__$1;
(statearr_38565_38591[(1)] = (12));

} else {
var statearr_38566_38592 = state_38549__$1;
(statearr_38566_38592[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___38578,tc,fc))
;
return ((function (switch__19364__auto__,c__19429__auto___38578,tc,fc){
return (function() {
var cljs$core$async$state_machine__19365__auto__ = null;
var cljs$core$async$state_machine__19365__auto____0 = (function (){
var statearr_38570 = [null,null,null,null,null,null,null,null,null];
(statearr_38570[(0)] = cljs$core$async$state_machine__19365__auto__);

(statearr_38570[(1)] = (1));

return statearr_38570;
});
var cljs$core$async$state_machine__19365__auto____1 = (function (state_38549){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_38549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e38571){if((e38571 instanceof Object)){
var ex__19368__auto__ = e38571;
var statearr_38572_38593 = state_38549;
(statearr_38572_38593[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38549);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38571;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38594 = state_38549;
state_38549 = G__38594;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$state_machine__19365__auto__ = function(state_38549){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19365__auto____1.call(this,state_38549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19365__auto____0;
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19365__auto____1;
return cljs$core$async$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___38578,tc,fc))
})();
var state__19431__auto__ = (function (){var statearr_38573 = f__19430__auto__.call(null);
(statearr_38573[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___38578);

return statearr_38573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___38578,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__19429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto__){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto__){
return (function (state_38641){
var state_val_38642 = (state_38641[(1)]);
if((state_val_38642 === (1))){
var inst_38627 = init;
var state_38641__$1 = (function (){var statearr_38643 = state_38641;
(statearr_38643[(7)] = inst_38627);

return statearr_38643;
})();
var statearr_38644_38659 = state_38641__$1;
(statearr_38644_38659[(2)] = null);

(statearr_38644_38659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38642 === (2))){
var state_38641__$1 = state_38641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38641__$1,(4),ch);
} else {
if((state_val_38642 === (3))){
var inst_38639 = (state_38641[(2)]);
var state_38641__$1 = state_38641;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38641__$1,inst_38639);
} else {
if((state_val_38642 === (4))){
var inst_38630 = (state_38641[(8)]);
var inst_38630__$1 = (state_38641[(2)]);
var inst_38631 = (inst_38630__$1 == null);
var state_38641__$1 = (function (){var statearr_38645 = state_38641;
(statearr_38645[(8)] = inst_38630__$1);

return statearr_38645;
})();
if(cljs.core.truth_(inst_38631)){
var statearr_38646_38660 = state_38641__$1;
(statearr_38646_38660[(1)] = (5));

} else {
var statearr_38647_38661 = state_38641__$1;
(statearr_38647_38661[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38642 === (5))){
var inst_38627 = (state_38641[(7)]);
var state_38641__$1 = state_38641;
var statearr_38648_38662 = state_38641__$1;
(statearr_38648_38662[(2)] = inst_38627);

(statearr_38648_38662[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38642 === (6))){
var inst_38630 = (state_38641[(8)]);
var inst_38627 = (state_38641[(7)]);
var inst_38634 = f.call(null,inst_38627,inst_38630);
var inst_38627__$1 = inst_38634;
var state_38641__$1 = (function (){var statearr_38649 = state_38641;
(statearr_38649[(7)] = inst_38627__$1);

return statearr_38649;
})();
var statearr_38650_38663 = state_38641__$1;
(statearr_38650_38663[(2)] = null);

(statearr_38650_38663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38642 === (7))){
var inst_38637 = (state_38641[(2)]);
var state_38641__$1 = state_38641;
var statearr_38651_38664 = state_38641__$1;
(statearr_38651_38664[(2)] = inst_38637);

(statearr_38651_38664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__19429__auto__))
;
return ((function (switch__19364__auto__,c__19429__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__19365__auto__ = null;
var cljs$core$async$reduce_$_state_machine__19365__auto____0 = (function (){
var statearr_38655 = [null,null,null,null,null,null,null,null,null];
(statearr_38655[(0)] = cljs$core$async$reduce_$_state_machine__19365__auto__);

(statearr_38655[(1)] = (1));

return statearr_38655;
});
var cljs$core$async$reduce_$_state_machine__19365__auto____1 = (function (state_38641){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_38641);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e38656){if((e38656 instanceof Object)){
var ex__19368__auto__ = e38656;
var statearr_38657_38665 = state_38641;
(statearr_38657_38665[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38641);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38656;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38666 = state_38641;
state_38641 = G__38666;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__19365__auto__ = function(state_38641){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__19365__auto____1.call(this,state_38641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__19365__auto____0;
cljs$core$async$reduce_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__19365__auto____1;
return cljs$core$async$reduce_$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto__))
})();
var state__19431__auto__ = (function (){var statearr_38658 = f__19430__auto__.call(null);
(statearr_38658[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto__);

return statearr_38658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto__))
);

return c__19429__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args38667 = [];
var len__17407__auto___38719 = arguments.length;
var i__17408__auto___38720 = (0);
while(true){
if((i__17408__auto___38720 < len__17407__auto___38719)){
args38667.push((arguments[i__17408__auto___38720]));

var G__38721 = (i__17408__auto___38720 + (1));
i__17408__auto___38720 = G__38721;
continue;
} else {
}
break;
}

var G__38669 = args38667.length;
switch (G__38669) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38667.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__19429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto__){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto__){
return (function (state_38694){
var state_val_38695 = (state_38694[(1)]);
if((state_val_38695 === (7))){
var inst_38676 = (state_38694[(2)]);
var state_38694__$1 = state_38694;
var statearr_38696_38723 = state_38694__$1;
(statearr_38696_38723[(2)] = inst_38676);

(statearr_38696_38723[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38695 === (1))){
var inst_38670 = cljs.core.seq.call(null,coll);
var inst_38671 = inst_38670;
var state_38694__$1 = (function (){var statearr_38697 = state_38694;
(statearr_38697[(7)] = inst_38671);

return statearr_38697;
})();
var statearr_38698_38724 = state_38694__$1;
(statearr_38698_38724[(2)] = null);

(statearr_38698_38724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38695 === (4))){
var inst_38671 = (state_38694[(7)]);
var inst_38674 = cljs.core.first.call(null,inst_38671);
var state_38694__$1 = state_38694;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38694__$1,(7),ch,inst_38674);
} else {
if((state_val_38695 === (13))){
var inst_38688 = (state_38694[(2)]);
var state_38694__$1 = state_38694;
var statearr_38699_38725 = state_38694__$1;
(statearr_38699_38725[(2)] = inst_38688);

(statearr_38699_38725[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38695 === (6))){
var inst_38679 = (state_38694[(2)]);
var state_38694__$1 = state_38694;
if(cljs.core.truth_(inst_38679)){
var statearr_38700_38726 = state_38694__$1;
(statearr_38700_38726[(1)] = (8));

} else {
var statearr_38701_38727 = state_38694__$1;
(statearr_38701_38727[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38695 === (3))){
var inst_38692 = (state_38694[(2)]);
var state_38694__$1 = state_38694;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38694__$1,inst_38692);
} else {
if((state_val_38695 === (12))){
var state_38694__$1 = state_38694;
var statearr_38702_38728 = state_38694__$1;
(statearr_38702_38728[(2)] = null);

(statearr_38702_38728[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38695 === (2))){
var inst_38671 = (state_38694[(7)]);
var state_38694__$1 = state_38694;
if(cljs.core.truth_(inst_38671)){
var statearr_38703_38729 = state_38694__$1;
(statearr_38703_38729[(1)] = (4));

} else {
var statearr_38704_38730 = state_38694__$1;
(statearr_38704_38730[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38695 === (11))){
var inst_38685 = cljs.core.async.close_BANG_.call(null,ch);
var state_38694__$1 = state_38694;
var statearr_38705_38731 = state_38694__$1;
(statearr_38705_38731[(2)] = inst_38685);

(statearr_38705_38731[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38695 === (9))){
var state_38694__$1 = state_38694;
if(cljs.core.truth_(close_QMARK_)){
var statearr_38706_38732 = state_38694__$1;
(statearr_38706_38732[(1)] = (11));

} else {
var statearr_38707_38733 = state_38694__$1;
(statearr_38707_38733[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38695 === (5))){
var inst_38671 = (state_38694[(7)]);
var state_38694__$1 = state_38694;
var statearr_38708_38734 = state_38694__$1;
(statearr_38708_38734[(2)] = inst_38671);

(statearr_38708_38734[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38695 === (10))){
var inst_38690 = (state_38694[(2)]);
var state_38694__$1 = state_38694;
var statearr_38709_38735 = state_38694__$1;
(statearr_38709_38735[(2)] = inst_38690);

(statearr_38709_38735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38695 === (8))){
var inst_38671 = (state_38694[(7)]);
var inst_38681 = cljs.core.next.call(null,inst_38671);
var inst_38671__$1 = inst_38681;
var state_38694__$1 = (function (){var statearr_38710 = state_38694;
(statearr_38710[(7)] = inst_38671__$1);

return statearr_38710;
})();
var statearr_38711_38736 = state_38694__$1;
(statearr_38711_38736[(2)] = null);

(statearr_38711_38736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto__))
;
return ((function (switch__19364__auto__,c__19429__auto__){
return (function() {
var cljs$core$async$state_machine__19365__auto__ = null;
var cljs$core$async$state_machine__19365__auto____0 = (function (){
var statearr_38715 = [null,null,null,null,null,null,null,null];
(statearr_38715[(0)] = cljs$core$async$state_machine__19365__auto__);

(statearr_38715[(1)] = (1));

return statearr_38715;
});
var cljs$core$async$state_machine__19365__auto____1 = (function (state_38694){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_38694);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e38716){if((e38716 instanceof Object)){
var ex__19368__auto__ = e38716;
var statearr_38717_38737 = state_38694;
(statearr_38717_38737[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38694);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38716;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38738 = state_38694;
state_38694 = G__38738;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$state_machine__19365__auto__ = function(state_38694){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19365__auto____1.call(this,state_38694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19365__auto____0;
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19365__auto____1;
return cljs$core$async$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto__))
})();
var state__19431__auto__ = (function (){var statearr_38718 = f__19430__auto__.call(null);
(statearr_38718[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto__);

return statearr_38718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto__))
);

return c__19429__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__17004__auto__ = (((_ == null))?null:_);
var m__17005__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,_);
} else {
var m__17005__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__17004__auto__ = (((m == null))?null:m);
var m__17005__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__17005__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__17004__auto__ = (((m == null))?null:m);
var m__17005__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,m,ch);
} else {
var m__17005__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__17004__auto__ = (((m == null))?null:m);
var m__17005__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,m);
} else {
var m__17005__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async38960 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38960 = (function (mult,ch,cs,meta38961){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta38961 = meta38961;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38960.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_38962,meta38961__$1){
var self__ = this;
var _38962__$1 = this;
return (new cljs.core.async.t_cljs$core$async38960(self__.mult,self__.ch,self__.cs,meta38961__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async38960.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_38962){
var self__ = this;
var _38962__$1 = this;
return self__.meta38961;
});})(cs))
;

cljs.core.async.t_cljs$core$async38960.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async38960.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async38960.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async38960.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async38960.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async38960.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async38960.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta38961","meta38961",1643736302,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async38960.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38960.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38960";

cljs.core.async.t_cljs$core$async38960.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cljs.core.async/t_cljs$core$async38960");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async38960 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async38960(mult__$1,ch__$1,cs__$1,meta38961){
return (new cljs.core.async.t_cljs$core$async38960(mult__$1,ch__$1,cs__$1,meta38961));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async38960(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__19429__auto___39181 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___39181,cs,m,dchan,dctr,done){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___39181,cs,m,dchan,dctr,done){
return (function (state_39093){
var state_val_39094 = (state_39093[(1)]);
if((state_val_39094 === (7))){
var inst_39089 = (state_39093[(2)]);
var state_39093__$1 = state_39093;
var statearr_39095_39182 = state_39093__$1;
(statearr_39095_39182[(2)] = inst_39089);

(statearr_39095_39182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (20))){
var inst_38994 = (state_39093[(7)]);
var inst_39004 = cljs.core.first.call(null,inst_38994);
var inst_39005 = cljs.core.nth.call(null,inst_39004,(0),null);
var inst_39006 = cljs.core.nth.call(null,inst_39004,(1),null);
var state_39093__$1 = (function (){var statearr_39096 = state_39093;
(statearr_39096[(8)] = inst_39005);

return statearr_39096;
})();
if(cljs.core.truth_(inst_39006)){
var statearr_39097_39183 = state_39093__$1;
(statearr_39097_39183[(1)] = (22));

} else {
var statearr_39098_39184 = state_39093__$1;
(statearr_39098_39184[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (27))){
var inst_39034 = (state_39093[(9)]);
var inst_39041 = (state_39093[(10)]);
var inst_39036 = (state_39093[(11)]);
var inst_38965 = (state_39093[(12)]);
var inst_39041__$1 = cljs.core._nth.call(null,inst_39034,inst_39036);
var inst_39042 = cljs.core.async.put_BANG_.call(null,inst_39041__$1,inst_38965,done);
var state_39093__$1 = (function (){var statearr_39099 = state_39093;
(statearr_39099[(10)] = inst_39041__$1);

return statearr_39099;
})();
if(cljs.core.truth_(inst_39042)){
var statearr_39100_39185 = state_39093__$1;
(statearr_39100_39185[(1)] = (30));

} else {
var statearr_39101_39186 = state_39093__$1;
(statearr_39101_39186[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (1))){
var state_39093__$1 = state_39093;
var statearr_39102_39187 = state_39093__$1;
(statearr_39102_39187[(2)] = null);

(statearr_39102_39187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (24))){
var inst_38994 = (state_39093[(7)]);
var inst_39011 = (state_39093[(2)]);
var inst_39012 = cljs.core.next.call(null,inst_38994);
var inst_38974 = inst_39012;
var inst_38975 = null;
var inst_38976 = (0);
var inst_38977 = (0);
var state_39093__$1 = (function (){var statearr_39103 = state_39093;
(statearr_39103[(13)] = inst_38976);

(statearr_39103[(14)] = inst_38974);

(statearr_39103[(15)] = inst_38975);

(statearr_39103[(16)] = inst_38977);

(statearr_39103[(17)] = inst_39011);

return statearr_39103;
})();
var statearr_39104_39188 = state_39093__$1;
(statearr_39104_39188[(2)] = null);

(statearr_39104_39188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (39))){
var state_39093__$1 = state_39093;
var statearr_39108_39189 = state_39093__$1;
(statearr_39108_39189[(2)] = null);

(statearr_39108_39189[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (4))){
var inst_38965 = (state_39093[(12)]);
var inst_38965__$1 = (state_39093[(2)]);
var inst_38966 = (inst_38965__$1 == null);
var state_39093__$1 = (function (){var statearr_39109 = state_39093;
(statearr_39109[(12)] = inst_38965__$1);

return statearr_39109;
})();
if(cljs.core.truth_(inst_38966)){
var statearr_39110_39190 = state_39093__$1;
(statearr_39110_39190[(1)] = (5));

} else {
var statearr_39111_39191 = state_39093__$1;
(statearr_39111_39191[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (15))){
var inst_38976 = (state_39093[(13)]);
var inst_38974 = (state_39093[(14)]);
var inst_38975 = (state_39093[(15)]);
var inst_38977 = (state_39093[(16)]);
var inst_38990 = (state_39093[(2)]);
var inst_38991 = (inst_38977 + (1));
var tmp39105 = inst_38976;
var tmp39106 = inst_38974;
var tmp39107 = inst_38975;
var inst_38974__$1 = tmp39106;
var inst_38975__$1 = tmp39107;
var inst_38976__$1 = tmp39105;
var inst_38977__$1 = inst_38991;
var state_39093__$1 = (function (){var statearr_39112 = state_39093;
(statearr_39112[(13)] = inst_38976__$1);

(statearr_39112[(14)] = inst_38974__$1);

(statearr_39112[(15)] = inst_38975__$1);

(statearr_39112[(18)] = inst_38990);

(statearr_39112[(16)] = inst_38977__$1);

return statearr_39112;
})();
var statearr_39113_39192 = state_39093__$1;
(statearr_39113_39192[(2)] = null);

(statearr_39113_39192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (21))){
var inst_39015 = (state_39093[(2)]);
var state_39093__$1 = state_39093;
var statearr_39117_39193 = state_39093__$1;
(statearr_39117_39193[(2)] = inst_39015);

(statearr_39117_39193[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (31))){
var inst_39041 = (state_39093[(10)]);
var inst_39045 = done.call(null,null);
var inst_39046 = cljs.core.async.untap_STAR_.call(null,m,inst_39041);
var state_39093__$1 = (function (){var statearr_39118 = state_39093;
(statearr_39118[(19)] = inst_39045);

return statearr_39118;
})();
var statearr_39119_39194 = state_39093__$1;
(statearr_39119_39194[(2)] = inst_39046);

(statearr_39119_39194[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (32))){
var inst_39033 = (state_39093[(20)]);
var inst_39034 = (state_39093[(9)]);
var inst_39035 = (state_39093[(21)]);
var inst_39036 = (state_39093[(11)]);
var inst_39048 = (state_39093[(2)]);
var inst_39049 = (inst_39036 + (1));
var tmp39114 = inst_39033;
var tmp39115 = inst_39034;
var tmp39116 = inst_39035;
var inst_39033__$1 = tmp39114;
var inst_39034__$1 = tmp39115;
var inst_39035__$1 = tmp39116;
var inst_39036__$1 = inst_39049;
var state_39093__$1 = (function (){var statearr_39120 = state_39093;
(statearr_39120[(20)] = inst_39033__$1);

(statearr_39120[(9)] = inst_39034__$1);

(statearr_39120[(21)] = inst_39035__$1);

(statearr_39120[(22)] = inst_39048);

(statearr_39120[(11)] = inst_39036__$1);

return statearr_39120;
})();
var statearr_39121_39195 = state_39093__$1;
(statearr_39121_39195[(2)] = null);

(statearr_39121_39195[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (40))){
var inst_39061 = (state_39093[(23)]);
var inst_39065 = done.call(null,null);
var inst_39066 = cljs.core.async.untap_STAR_.call(null,m,inst_39061);
var state_39093__$1 = (function (){var statearr_39122 = state_39093;
(statearr_39122[(24)] = inst_39065);

return statearr_39122;
})();
var statearr_39123_39196 = state_39093__$1;
(statearr_39123_39196[(2)] = inst_39066);

(statearr_39123_39196[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (33))){
var inst_39052 = (state_39093[(25)]);
var inst_39054 = cljs.core.chunked_seq_QMARK_.call(null,inst_39052);
var state_39093__$1 = state_39093;
if(inst_39054){
var statearr_39124_39197 = state_39093__$1;
(statearr_39124_39197[(1)] = (36));

} else {
var statearr_39125_39198 = state_39093__$1;
(statearr_39125_39198[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (13))){
var inst_38984 = (state_39093[(26)]);
var inst_38987 = cljs.core.async.close_BANG_.call(null,inst_38984);
var state_39093__$1 = state_39093;
var statearr_39126_39199 = state_39093__$1;
(statearr_39126_39199[(2)] = inst_38987);

(statearr_39126_39199[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (22))){
var inst_39005 = (state_39093[(8)]);
var inst_39008 = cljs.core.async.close_BANG_.call(null,inst_39005);
var state_39093__$1 = state_39093;
var statearr_39127_39200 = state_39093__$1;
(statearr_39127_39200[(2)] = inst_39008);

(statearr_39127_39200[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (36))){
var inst_39052 = (state_39093[(25)]);
var inst_39056 = cljs.core.chunk_first.call(null,inst_39052);
var inst_39057 = cljs.core.chunk_rest.call(null,inst_39052);
var inst_39058 = cljs.core.count.call(null,inst_39056);
var inst_39033 = inst_39057;
var inst_39034 = inst_39056;
var inst_39035 = inst_39058;
var inst_39036 = (0);
var state_39093__$1 = (function (){var statearr_39128 = state_39093;
(statearr_39128[(20)] = inst_39033);

(statearr_39128[(9)] = inst_39034);

(statearr_39128[(21)] = inst_39035);

(statearr_39128[(11)] = inst_39036);

return statearr_39128;
})();
var statearr_39129_39201 = state_39093__$1;
(statearr_39129_39201[(2)] = null);

(statearr_39129_39201[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (41))){
var inst_39052 = (state_39093[(25)]);
var inst_39068 = (state_39093[(2)]);
var inst_39069 = cljs.core.next.call(null,inst_39052);
var inst_39033 = inst_39069;
var inst_39034 = null;
var inst_39035 = (0);
var inst_39036 = (0);
var state_39093__$1 = (function (){var statearr_39130 = state_39093;
(statearr_39130[(20)] = inst_39033);

(statearr_39130[(9)] = inst_39034);

(statearr_39130[(21)] = inst_39035);

(statearr_39130[(11)] = inst_39036);

(statearr_39130[(27)] = inst_39068);

return statearr_39130;
})();
var statearr_39131_39202 = state_39093__$1;
(statearr_39131_39202[(2)] = null);

(statearr_39131_39202[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (43))){
var state_39093__$1 = state_39093;
var statearr_39132_39203 = state_39093__$1;
(statearr_39132_39203[(2)] = null);

(statearr_39132_39203[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (29))){
var inst_39077 = (state_39093[(2)]);
var state_39093__$1 = state_39093;
var statearr_39133_39204 = state_39093__$1;
(statearr_39133_39204[(2)] = inst_39077);

(statearr_39133_39204[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (44))){
var inst_39086 = (state_39093[(2)]);
var state_39093__$1 = (function (){var statearr_39134 = state_39093;
(statearr_39134[(28)] = inst_39086);

return statearr_39134;
})();
var statearr_39135_39205 = state_39093__$1;
(statearr_39135_39205[(2)] = null);

(statearr_39135_39205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (6))){
var inst_39025 = (state_39093[(29)]);
var inst_39024 = cljs.core.deref.call(null,cs);
var inst_39025__$1 = cljs.core.keys.call(null,inst_39024);
var inst_39026 = cljs.core.count.call(null,inst_39025__$1);
var inst_39027 = cljs.core.reset_BANG_.call(null,dctr,inst_39026);
var inst_39032 = cljs.core.seq.call(null,inst_39025__$1);
var inst_39033 = inst_39032;
var inst_39034 = null;
var inst_39035 = (0);
var inst_39036 = (0);
var state_39093__$1 = (function (){var statearr_39136 = state_39093;
(statearr_39136[(29)] = inst_39025__$1);

(statearr_39136[(20)] = inst_39033);

(statearr_39136[(9)] = inst_39034);

(statearr_39136[(30)] = inst_39027);

(statearr_39136[(21)] = inst_39035);

(statearr_39136[(11)] = inst_39036);

return statearr_39136;
})();
var statearr_39137_39206 = state_39093__$1;
(statearr_39137_39206[(2)] = null);

(statearr_39137_39206[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (28))){
var inst_39033 = (state_39093[(20)]);
var inst_39052 = (state_39093[(25)]);
var inst_39052__$1 = cljs.core.seq.call(null,inst_39033);
var state_39093__$1 = (function (){var statearr_39138 = state_39093;
(statearr_39138[(25)] = inst_39052__$1);

return statearr_39138;
})();
if(inst_39052__$1){
var statearr_39139_39207 = state_39093__$1;
(statearr_39139_39207[(1)] = (33));

} else {
var statearr_39140_39208 = state_39093__$1;
(statearr_39140_39208[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (25))){
var inst_39035 = (state_39093[(21)]);
var inst_39036 = (state_39093[(11)]);
var inst_39038 = (inst_39036 < inst_39035);
var inst_39039 = inst_39038;
var state_39093__$1 = state_39093;
if(cljs.core.truth_(inst_39039)){
var statearr_39141_39209 = state_39093__$1;
(statearr_39141_39209[(1)] = (27));

} else {
var statearr_39142_39210 = state_39093__$1;
(statearr_39142_39210[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (34))){
var state_39093__$1 = state_39093;
var statearr_39143_39211 = state_39093__$1;
(statearr_39143_39211[(2)] = null);

(statearr_39143_39211[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (17))){
var state_39093__$1 = state_39093;
var statearr_39144_39212 = state_39093__$1;
(statearr_39144_39212[(2)] = null);

(statearr_39144_39212[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (3))){
var inst_39091 = (state_39093[(2)]);
var state_39093__$1 = state_39093;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39093__$1,inst_39091);
} else {
if((state_val_39094 === (12))){
var inst_39020 = (state_39093[(2)]);
var state_39093__$1 = state_39093;
var statearr_39145_39213 = state_39093__$1;
(statearr_39145_39213[(2)] = inst_39020);

(statearr_39145_39213[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (2))){
var state_39093__$1 = state_39093;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39093__$1,(4),ch);
} else {
if((state_val_39094 === (23))){
var state_39093__$1 = state_39093;
var statearr_39146_39214 = state_39093__$1;
(statearr_39146_39214[(2)] = null);

(statearr_39146_39214[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (35))){
var inst_39075 = (state_39093[(2)]);
var state_39093__$1 = state_39093;
var statearr_39147_39215 = state_39093__$1;
(statearr_39147_39215[(2)] = inst_39075);

(statearr_39147_39215[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (19))){
var inst_38994 = (state_39093[(7)]);
var inst_38998 = cljs.core.chunk_first.call(null,inst_38994);
var inst_38999 = cljs.core.chunk_rest.call(null,inst_38994);
var inst_39000 = cljs.core.count.call(null,inst_38998);
var inst_38974 = inst_38999;
var inst_38975 = inst_38998;
var inst_38976 = inst_39000;
var inst_38977 = (0);
var state_39093__$1 = (function (){var statearr_39148 = state_39093;
(statearr_39148[(13)] = inst_38976);

(statearr_39148[(14)] = inst_38974);

(statearr_39148[(15)] = inst_38975);

(statearr_39148[(16)] = inst_38977);

return statearr_39148;
})();
var statearr_39149_39216 = state_39093__$1;
(statearr_39149_39216[(2)] = null);

(statearr_39149_39216[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (11))){
var inst_38974 = (state_39093[(14)]);
var inst_38994 = (state_39093[(7)]);
var inst_38994__$1 = cljs.core.seq.call(null,inst_38974);
var state_39093__$1 = (function (){var statearr_39150 = state_39093;
(statearr_39150[(7)] = inst_38994__$1);

return statearr_39150;
})();
if(inst_38994__$1){
var statearr_39151_39217 = state_39093__$1;
(statearr_39151_39217[(1)] = (16));

} else {
var statearr_39152_39218 = state_39093__$1;
(statearr_39152_39218[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (9))){
var inst_39022 = (state_39093[(2)]);
var state_39093__$1 = state_39093;
var statearr_39153_39219 = state_39093__$1;
(statearr_39153_39219[(2)] = inst_39022);

(statearr_39153_39219[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (5))){
var inst_38972 = cljs.core.deref.call(null,cs);
var inst_38973 = cljs.core.seq.call(null,inst_38972);
var inst_38974 = inst_38973;
var inst_38975 = null;
var inst_38976 = (0);
var inst_38977 = (0);
var state_39093__$1 = (function (){var statearr_39154 = state_39093;
(statearr_39154[(13)] = inst_38976);

(statearr_39154[(14)] = inst_38974);

(statearr_39154[(15)] = inst_38975);

(statearr_39154[(16)] = inst_38977);

return statearr_39154;
})();
var statearr_39155_39220 = state_39093__$1;
(statearr_39155_39220[(2)] = null);

(statearr_39155_39220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (14))){
var state_39093__$1 = state_39093;
var statearr_39156_39221 = state_39093__$1;
(statearr_39156_39221[(2)] = null);

(statearr_39156_39221[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (45))){
var inst_39083 = (state_39093[(2)]);
var state_39093__$1 = state_39093;
var statearr_39157_39222 = state_39093__$1;
(statearr_39157_39222[(2)] = inst_39083);

(statearr_39157_39222[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (26))){
var inst_39025 = (state_39093[(29)]);
var inst_39079 = (state_39093[(2)]);
var inst_39080 = cljs.core.seq.call(null,inst_39025);
var state_39093__$1 = (function (){var statearr_39158 = state_39093;
(statearr_39158[(31)] = inst_39079);

return statearr_39158;
})();
if(inst_39080){
var statearr_39159_39223 = state_39093__$1;
(statearr_39159_39223[(1)] = (42));

} else {
var statearr_39160_39224 = state_39093__$1;
(statearr_39160_39224[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (16))){
var inst_38994 = (state_39093[(7)]);
var inst_38996 = cljs.core.chunked_seq_QMARK_.call(null,inst_38994);
var state_39093__$1 = state_39093;
if(inst_38996){
var statearr_39161_39225 = state_39093__$1;
(statearr_39161_39225[(1)] = (19));

} else {
var statearr_39162_39226 = state_39093__$1;
(statearr_39162_39226[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (38))){
var inst_39072 = (state_39093[(2)]);
var state_39093__$1 = state_39093;
var statearr_39163_39227 = state_39093__$1;
(statearr_39163_39227[(2)] = inst_39072);

(statearr_39163_39227[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (30))){
var state_39093__$1 = state_39093;
var statearr_39164_39228 = state_39093__$1;
(statearr_39164_39228[(2)] = null);

(statearr_39164_39228[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (10))){
var inst_38975 = (state_39093[(15)]);
var inst_38977 = (state_39093[(16)]);
var inst_38983 = cljs.core._nth.call(null,inst_38975,inst_38977);
var inst_38984 = cljs.core.nth.call(null,inst_38983,(0),null);
var inst_38985 = cljs.core.nth.call(null,inst_38983,(1),null);
var state_39093__$1 = (function (){var statearr_39165 = state_39093;
(statearr_39165[(26)] = inst_38984);

return statearr_39165;
})();
if(cljs.core.truth_(inst_38985)){
var statearr_39166_39229 = state_39093__$1;
(statearr_39166_39229[(1)] = (13));

} else {
var statearr_39167_39230 = state_39093__$1;
(statearr_39167_39230[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (18))){
var inst_39018 = (state_39093[(2)]);
var state_39093__$1 = state_39093;
var statearr_39168_39231 = state_39093__$1;
(statearr_39168_39231[(2)] = inst_39018);

(statearr_39168_39231[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (42))){
var state_39093__$1 = state_39093;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39093__$1,(45),dchan);
} else {
if((state_val_39094 === (37))){
var inst_39061 = (state_39093[(23)]);
var inst_38965 = (state_39093[(12)]);
var inst_39052 = (state_39093[(25)]);
var inst_39061__$1 = cljs.core.first.call(null,inst_39052);
var inst_39062 = cljs.core.async.put_BANG_.call(null,inst_39061__$1,inst_38965,done);
var state_39093__$1 = (function (){var statearr_39169 = state_39093;
(statearr_39169[(23)] = inst_39061__$1);

return statearr_39169;
})();
if(cljs.core.truth_(inst_39062)){
var statearr_39170_39232 = state_39093__$1;
(statearr_39170_39232[(1)] = (39));

} else {
var statearr_39171_39233 = state_39093__$1;
(statearr_39171_39233[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39094 === (8))){
var inst_38976 = (state_39093[(13)]);
var inst_38977 = (state_39093[(16)]);
var inst_38979 = (inst_38977 < inst_38976);
var inst_38980 = inst_38979;
var state_39093__$1 = state_39093;
if(cljs.core.truth_(inst_38980)){
var statearr_39172_39234 = state_39093__$1;
(statearr_39172_39234[(1)] = (10));

} else {
var statearr_39173_39235 = state_39093__$1;
(statearr_39173_39235[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___39181,cs,m,dchan,dctr,done))
;
return ((function (switch__19364__auto__,c__19429__auto___39181,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__19365__auto__ = null;
var cljs$core$async$mult_$_state_machine__19365__auto____0 = (function (){
var statearr_39177 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39177[(0)] = cljs$core$async$mult_$_state_machine__19365__auto__);

(statearr_39177[(1)] = (1));

return statearr_39177;
});
var cljs$core$async$mult_$_state_machine__19365__auto____1 = (function (state_39093){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_39093);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e39178){if((e39178 instanceof Object)){
var ex__19368__auto__ = e39178;
var statearr_39179_39236 = state_39093;
(statearr_39179_39236[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39093);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39178;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39237 = state_39093;
state_39093 = G__39237;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__19365__auto__ = function(state_39093){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__19365__auto____1.call(this,state_39093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__19365__auto____0;
cljs$core$async$mult_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__19365__auto____1;
return cljs$core$async$mult_$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___39181,cs,m,dchan,dctr,done))
})();
var state__19431__auto__ = (function (){var statearr_39180 = f__19430__auto__.call(null);
(statearr_39180[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___39181);

return statearr_39180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___39181,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args39238 = [];
var len__17407__auto___39241 = arguments.length;
var i__17408__auto___39242 = (0);
while(true){
if((i__17408__auto___39242 < len__17407__auto___39241)){
args39238.push((arguments[i__17408__auto___39242]));

var G__39243 = (i__17408__auto___39242 + (1));
i__17408__auto___39242 = G__39243;
continue;
} else {
}
break;
}

var G__39240 = args39238.length;
switch (G__39240) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39238.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__17004__auto__ = (((m == null))?null:m);
var m__17005__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,m,ch);
} else {
var m__17005__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__17004__auto__ = (((m == null))?null:m);
var m__17005__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,m,ch);
} else {
var m__17005__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__17004__auto__ = (((m == null))?null:m);
var m__17005__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,m);
} else {
var m__17005__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__17004__auto__ = (((m == null))?null:m);
var m__17005__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,m,state_map);
} else {
var m__17005__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__17004__auto__ = (((m == null))?null:m);
var m__17005__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,m,mode);
} else {
var m__17005__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__17414__auto__ = [];
var len__17407__auto___39255 = arguments.length;
var i__17408__auto___39256 = (0);
while(true){
if((i__17408__auto___39256 < len__17407__auto___39255)){
args__17414__auto__.push((arguments[i__17408__auto___39256]));

var G__39257 = (i__17408__auto___39256 + (1));
i__17408__auto___39256 = G__39257;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((3) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__17415__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__39249){
var map__39250 = p__39249;
var map__39250__$1 = ((((!((map__39250 == null)))?((((map__39250.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39250.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__39250):map__39250);
var opts = map__39250__$1;
var statearr_39252_39258 = state;
(statearr_39252_39258[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__39250,map__39250__$1,opts){
return (function (val){
var statearr_39253_39259 = state;
(statearr_39253_39259[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__39250,map__39250__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_39254_39260 = state;
(statearr_39254_39260[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq39245){
var G__39246 = cljs.core.first.call(null,seq39245);
var seq39245__$1 = cljs.core.next.call(null,seq39245);
var G__39247 = cljs.core.first.call(null,seq39245__$1);
var seq39245__$2 = cljs.core.next.call(null,seq39245__$1);
var G__39248 = cljs.core.first.call(null,seq39245__$2);
var seq39245__$3 = cljs.core.next.call(null,seq39245__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__39246,G__39247,G__39248,seq39245__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async39424 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39424 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta39425){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta39425 = meta39425;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async39424.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_39426,meta39425__$1){
var self__ = this;
var _39426__$1 = this;
return (new cljs.core.async.t_cljs$core$async39424(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta39425__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39424.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_39426){
var self__ = this;
var _39426__$1 = this;
return self__.meta39425;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39424.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async39424.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39424.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async39424.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39424.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39424.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39424.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39424.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39424.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta39425","meta39425",-640294903,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39424.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39424.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39424";

cljs.core.async.t_cljs$core$async39424.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cljs.core.async/t_cljs$core$async39424");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async39424 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async39424(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta39425){
return (new cljs.core.async.t_cljs$core$async39424(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta39425));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async39424(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19429__auto___39587 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___39587,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___39587,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_39524){
var state_val_39525 = (state_39524[(1)]);
if((state_val_39525 === (7))){
var inst_39442 = (state_39524[(2)]);
var state_39524__$1 = state_39524;
var statearr_39526_39588 = state_39524__$1;
(statearr_39526_39588[(2)] = inst_39442);

(statearr_39526_39588[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (20))){
var inst_39454 = (state_39524[(7)]);
var state_39524__$1 = state_39524;
var statearr_39527_39589 = state_39524__$1;
(statearr_39527_39589[(2)] = inst_39454);

(statearr_39527_39589[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (27))){
var state_39524__$1 = state_39524;
var statearr_39528_39590 = state_39524__$1;
(statearr_39528_39590[(2)] = null);

(statearr_39528_39590[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (1))){
var inst_39430 = (state_39524[(8)]);
var inst_39430__$1 = calc_state.call(null);
var inst_39432 = (inst_39430__$1 == null);
var inst_39433 = cljs.core.not.call(null,inst_39432);
var state_39524__$1 = (function (){var statearr_39529 = state_39524;
(statearr_39529[(8)] = inst_39430__$1);

return statearr_39529;
})();
if(inst_39433){
var statearr_39530_39591 = state_39524__$1;
(statearr_39530_39591[(1)] = (2));

} else {
var statearr_39531_39592 = state_39524__$1;
(statearr_39531_39592[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (24))){
var inst_39477 = (state_39524[(9)]);
var inst_39484 = (state_39524[(10)]);
var inst_39498 = (state_39524[(11)]);
var inst_39498__$1 = inst_39477.call(null,inst_39484);
var state_39524__$1 = (function (){var statearr_39532 = state_39524;
(statearr_39532[(11)] = inst_39498__$1);

return statearr_39532;
})();
if(cljs.core.truth_(inst_39498__$1)){
var statearr_39533_39593 = state_39524__$1;
(statearr_39533_39593[(1)] = (29));

} else {
var statearr_39534_39594 = state_39524__$1;
(statearr_39534_39594[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (4))){
var inst_39445 = (state_39524[(2)]);
var state_39524__$1 = state_39524;
if(cljs.core.truth_(inst_39445)){
var statearr_39535_39595 = state_39524__$1;
(statearr_39535_39595[(1)] = (8));

} else {
var statearr_39536_39596 = state_39524__$1;
(statearr_39536_39596[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (15))){
var inst_39471 = (state_39524[(2)]);
var state_39524__$1 = state_39524;
if(cljs.core.truth_(inst_39471)){
var statearr_39537_39597 = state_39524__$1;
(statearr_39537_39597[(1)] = (19));

} else {
var statearr_39538_39598 = state_39524__$1;
(statearr_39538_39598[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (21))){
var inst_39476 = (state_39524[(12)]);
var inst_39476__$1 = (state_39524[(2)]);
var inst_39477 = cljs.core.get.call(null,inst_39476__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_39478 = cljs.core.get.call(null,inst_39476__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_39479 = cljs.core.get.call(null,inst_39476__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_39524__$1 = (function (){var statearr_39539 = state_39524;
(statearr_39539[(9)] = inst_39477);

(statearr_39539[(12)] = inst_39476__$1);

(statearr_39539[(13)] = inst_39478);

return statearr_39539;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_39524__$1,(22),inst_39479);
} else {
if((state_val_39525 === (31))){
var inst_39506 = (state_39524[(2)]);
var state_39524__$1 = state_39524;
if(cljs.core.truth_(inst_39506)){
var statearr_39540_39599 = state_39524__$1;
(statearr_39540_39599[(1)] = (32));

} else {
var statearr_39541_39600 = state_39524__$1;
(statearr_39541_39600[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (32))){
var inst_39483 = (state_39524[(14)]);
var state_39524__$1 = state_39524;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39524__$1,(35),out,inst_39483);
} else {
if((state_val_39525 === (33))){
var inst_39476 = (state_39524[(12)]);
var inst_39454 = inst_39476;
var state_39524__$1 = (function (){var statearr_39542 = state_39524;
(statearr_39542[(7)] = inst_39454);

return statearr_39542;
})();
var statearr_39543_39601 = state_39524__$1;
(statearr_39543_39601[(2)] = null);

(statearr_39543_39601[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (13))){
var inst_39454 = (state_39524[(7)]);
var inst_39461 = inst_39454.cljs$lang$protocol_mask$partition0$;
var inst_39462 = (inst_39461 & (64));
var inst_39463 = inst_39454.cljs$core$ISeq$;
var inst_39464 = (inst_39462) || (inst_39463);
var state_39524__$1 = state_39524;
if(cljs.core.truth_(inst_39464)){
var statearr_39544_39602 = state_39524__$1;
(statearr_39544_39602[(1)] = (16));

} else {
var statearr_39545_39603 = state_39524__$1;
(statearr_39545_39603[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (22))){
var inst_39484 = (state_39524[(10)]);
var inst_39483 = (state_39524[(14)]);
var inst_39482 = (state_39524[(2)]);
var inst_39483__$1 = cljs.core.nth.call(null,inst_39482,(0),null);
var inst_39484__$1 = cljs.core.nth.call(null,inst_39482,(1),null);
var inst_39485 = (inst_39483__$1 == null);
var inst_39486 = cljs.core._EQ_.call(null,inst_39484__$1,change);
var inst_39487 = (inst_39485) || (inst_39486);
var state_39524__$1 = (function (){var statearr_39546 = state_39524;
(statearr_39546[(10)] = inst_39484__$1);

(statearr_39546[(14)] = inst_39483__$1);

return statearr_39546;
})();
if(cljs.core.truth_(inst_39487)){
var statearr_39547_39604 = state_39524__$1;
(statearr_39547_39604[(1)] = (23));

} else {
var statearr_39548_39605 = state_39524__$1;
(statearr_39548_39605[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (36))){
var inst_39476 = (state_39524[(12)]);
var inst_39454 = inst_39476;
var state_39524__$1 = (function (){var statearr_39549 = state_39524;
(statearr_39549[(7)] = inst_39454);

return statearr_39549;
})();
var statearr_39550_39606 = state_39524__$1;
(statearr_39550_39606[(2)] = null);

(statearr_39550_39606[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (29))){
var inst_39498 = (state_39524[(11)]);
var state_39524__$1 = state_39524;
var statearr_39551_39607 = state_39524__$1;
(statearr_39551_39607[(2)] = inst_39498);

(statearr_39551_39607[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (6))){
var state_39524__$1 = state_39524;
var statearr_39552_39608 = state_39524__$1;
(statearr_39552_39608[(2)] = false);

(statearr_39552_39608[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (28))){
var inst_39494 = (state_39524[(2)]);
var inst_39495 = calc_state.call(null);
var inst_39454 = inst_39495;
var state_39524__$1 = (function (){var statearr_39553 = state_39524;
(statearr_39553[(7)] = inst_39454);

(statearr_39553[(15)] = inst_39494);

return statearr_39553;
})();
var statearr_39554_39609 = state_39524__$1;
(statearr_39554_39609[(2)] = null);

(statearr_39554_39609[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (25))){
var inst_39520 = (state_39524[(2)]);
var state_39524__$1 = state_39524;
var statearr_39555_39610 = state_39524__$1;
(statearr_39555_39610[(2)] = inst_39520);

(statearr_39555_39610[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (34))){
var inst_39518 = (state_39524[(2)]);
var state_39524__$1 = state_39524;
var statearr_39556_39611 = state_39524__$1;
(statearr_39556_39611[(2)] = inst_39518);

(statearr_39556_39611[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (17))){
var state_39524__$1 = state_39524;
var statearr_39557_39612 = state_39524__$1;
(statearr_39557_39612[(2)] = false);

(statearr_39557_39612[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (3))){
var state_39524__$1 = state_39524;
var statearr_39558_39613 = state_39524__$1;
(statearr_39558_39613[(2)] = false);

(statearr_39558_39613[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (12))){
var inst_39522 = (state_39524[(2)]);
var state_39524__$1 = state_39524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39524__$1,inst_39522);
} else {
if((state_val_39525 === (2))){
var inst_39430 = (state_39524[(8)]);
var inst_39435 = inst_39430.cljs$lang$protocol_mask$partition0$;
var inst_39436 = (inst_39435 & (64));
var inst_39437 = inst_39430.cljs$core$ISeq$;
var inst_39438 = (inst_39436) || (inst_39437);
var state_39524__$1 = state_39524;
if(cljs.core.truth_(inst_39438)){
var statearr_39559_39614 = state_39524__$1;
(statearr_39559_39614[(1)] = (5));

} else {
var statearr_39560_39615 = state_39524__$1;
(statearr_39560_39615[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (23))){
var inst_39483 = (state_39524[(14)]);
var inst_39489 = (inst_39483 == null);
var state_39524__$1 = state_39524;
if(cljs.core.truth_(inst_39489)){
var statearr_39561_39616 = state_39524__$1;
(statearr_39561_39616[(1)] = (26));

} else {
var statearr_39562_39617 = state_39524__$1;
(statearr_39562_39617[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (35))){
var inst_39509 = (state_39524[(2)]);
var state_39524__$1 = state_39524;
if(cljs.core.truth_(inst_39509)){
var statearr_39563_39618 = state_39524__$1;
(statearr_39563_39618[(1)] = (36));

} else {
var statearr_39564_39619 = state_39524__$1;
(statearr_39564_39619[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (19))){
var inst_39454 = (state_39524[(7)]);
var inst_39473 = cljs.core.apply.call(null,cljs.core.hash_map,inst_39454);
var state_39524__$1 = state_39524;
var statearr_39565_39620 = state_39524__$1;
(statearr_39565_39620[(2)] = inst_39473);

(statearr_39565_39620[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (11))){
var inst_39454 = (state_39524[(7)]);
var inst_39458 = (inst_39454 == null);
var inst_39459 = cljs.core.not.call(null,inst_39458);
var state_39524__$1 = state_39524;
if(inst_39459){
var statearr_39566_39621 = state_39524__$1;
(statearr_39566_39621[(1)] = (13));

} else {
var statearr_39567_39622 = state_39524__$1;
(statearr_39567_39622[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (9))){
var inst_39430 = (state_39524[(8)]);
var state_39524__$1 = state_39524;
var statearr_39568_39623 = state_39524__$1;
(statearr_39568_39623[(2)] = inst_39430);

(statearr_39568_39623[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (5))){
var state_39524__$1 = state_39524;
var statearr_39569_39624 = state_39524__$1;
(statearr_39569_39624[(2)] = true);

(statearr_39569_39624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (14))){
var state_39524__$1 = state_39524;
var statearr_39570_39625 = state_39524__$1;
(statearr_39570_39625[(2)] = false);

(statearr_39570_39625[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (26))){
var inst_39484 = (state_39524[(10)]);
var inst_39491 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_39484);
var state_39524__$1 = state_39524;
var statearr_39571_39626 = state_39524__$1;
(statearr_39571_39626[(2)] = inst_39491);

(statearr_39571_39626[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (16))){
var state_39524__$1 = state_39524;
var statearr_39572_39627 = state_39524__$1;
(statearr_39572_39627[(2)] = true);

(statearr_39572_39627[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (38))){
var inst_39514 = (state_39524[(2)]);
var state_39524__$1 = state_39524;
var statearr_39573_39628 = state_39524__$1;
(statearr_39573_39628[(2)] = inst_39514);

(statearr_39573_39628[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (30))){
var inst_39477 = (state_39524[(9)]);
var inst_39484 = (state_39524[(10)]);
var inst_39478 = (state_39524[(13)]);
var inst_39501 = cljs.core.empty_QMARK_.call(null,inst_39477);
var inst_39502 = inst_39478.call(null,inst_39484);
var inst_39503 = cljs.core.not.call(null,inst_39502);
var inst_39504 = (inst_39501) && (inst_39503);
var state_39524__$1 = state_39524;
var statearr_39574_39629 = state_39524__$1;
(statearr_39574_39629[(2)] = inst_39504);

(statearr_39574_39629[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (10))){
var inst_39430 = (state_39524[(8)]);
var inst_39450 = (state_39524[(2)]);
var inst_39451 = cljs.core.get.call(null,inst_39450,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_39452 = cljs.core.get.call(null,inst_39450,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_39453 = cljs.core.get.call(null,inst_39450,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_39454 = inst_39430;
var state_39524__$1 = (function (){var statearr_39575 = state_39524;
(statearr_39575[(7)] = inst_39454);

(statearr_39575[(16)] = inst_39452);

(statearr_39575[(17)] = inst_39453);

(statearr_39575[(18)] = inst_39451);

return statearr_39575;
})();
var statearr_39576_39630 = state_39524__$1;
(statearr_39576_39630[(2)] = null);

(statearr_39576_39630[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (18))){
var inst_39468 = (state_39524[(2)]);
var state_39524__$1 = state_39524;
var statearr_39577_39631 = state_39524__$1;
(statearr_39577_39631[(2)] = inst_39468);

(statearr_39577_39631[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (37))){
var state_39524__$1 = state_39524;
var statearr_39578_39632 = state_39524__$1;
(statearr_39578_39632[(2)] = null);

(statearr_39578_39632[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39525 === (8))){
var inst_39430 = (state_39524[(8)]);
var inst_39447 = cljs.core.apply.call(null,cljs.core.hash_map,inst_39430);
var state_39524__$1 = state_39524;
var statearr_39579_39633 = state_39524__$1;
(statearr_39579_39633[(2)] = inst_39447);

(statearr_39579_39633[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___39587,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__19364__auto__,c__19429__auto___39587,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__19365__auto__ = null;
var cljs$core$async$mix_$_state_machine__19365__auto____0 = (function (){
var statearr_39583 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39583[(0)] = cljs$core$async$mix_$_state_machine__19365__auto__);

(statearr_39583[(1)] = (1));

return statearr_39583;
});
var cljs$core$async$mix_$_state_machine__19365__auto____1 = (function (state_39524){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_39524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e39584){if((e39584 instanceof Object)){
var ex__19368__auto__ = e39584;
var statearr_39585_39634 = state_39524;
(statearr_39585_39634[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39524);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39584;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39635 = state_39524;
state_39524 = G__39635;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__19365__auto__ = function(state_39524){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__19365__auto____1.call(this,state_39524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__19365__auto____0;
cljs$core$async$mix_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__19365__auto____1;
return cljs$core$async$mix_$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___39587,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__19431__auto__ = (function (){var statearr_39586 = f__19430__auto__.call(null);
(statearr_39586[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___39587);

return statearr_39586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___39587,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__17004__auto__ = (((p == null))?null:p);
var m__17005__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__17005__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__17004__auto__ = (((p == null))?null:p);
var m__17005__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,p,v,ch);
} else {
var m__17005__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args39636 = [];
var len__17407__auto___39639 = arguments.length;
var i__17408__auto___39640 = (0);
while(true){
if((i__17408__auto___39640 < len__17407__auto___39639)){
args39636.push((arguments[i__17408__auto___39640]));

var G__39641 = (i__17408__auto___39640 + (1));
i__17408__auto___39640 = G__39641;
continue;
} else {
}
break;
}

var G__39638 = args39636.length;
switch (G__39638) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39636.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__17004__auto__ = (((p == null))?null:p);
var m__17005__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,p);
} else {
var m__17005__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__17004__auto__ = (((p == null))?null:p);
var m__17005__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,p,v);
} else {
var m__17005__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args39644 = [];
var len__17407__auto___39769 = arguments.length;
var i__17408__auto___39770 = (0);
while(true){
if((i__17408__auto___39770 < len__17407__auto___39769)){
args39644.push((arguments[i__17408__auto___39770]));

var G__39771 = (i__17408__auto___39770 + (1));
i__17408__auto___39770 = G__39771;
continue;
} else {
}
break;
}

var G__39646 = args39644.length;
switch (G__39646) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39644.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__16349__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__16349__auto__,mults){
return (function (p1__39643_SHARP_){
if(cljs.core.truth_(p1__39643_SHARP_.call(null,topic))){
return p1__39643_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__39643_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__16349__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async39647 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39647 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta39648){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta39648 = meta39648;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async39647.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_39649,meta39648__$1){
var self__ = this;
var _39649__$1 = this;
return (new cljs.core.async.t_cljs$core$async39647(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta39648__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39647.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_39649){
var self__ = this;
var _39649__$1 = this;
return self__.meta39648;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39647.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async39647.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39647.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async39647.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39647.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39647.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39647.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39647.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta39648","meta39648",-122445705,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39647.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39647.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39647";

cljs.core.async.t_cljs$core$async39647.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cljs.core.async/t_cljs$core$async39647");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async39647 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async39647(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta39648){
return (new cljs.core.async.t_cljs$core$async39647(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta39648));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async39647(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19429__auto___39773 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___39773,mults,ensure_mult,p){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___39773,mults,ensure_mult,p){
return (function (state_39721){
var state_val_39722 = (state_39721[(1)]);
if((state_val_39722 === (7))){
var inst_39717 = (state_39721[(2)]);
var state_39721__$1 = state_39721;
var statearr_39723_39774 = state_39721__$1;
(statearr_39723_39774[(2)] = inst_39717);

(statearr_39723_39774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (20))){
var state_39721__$1 = state_39721;
var statearr_39724_39775 = state_39721__$1;
(statearr_39724_39775[(2)] = null);

(statearr_39724_39775[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (1))){
var state_39721__$1 = state_39721;
var statearr_39725_39776 = state_39721__$1;
(statearr_39725_39776[(2)] = null);

(statearr_39725_39776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (24))){
var inst_39700 = (state_39721[(7)]);
var inst_39709 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_39700);
var state_39721__$1 = state_39721;
var statearr_39726_39777 = state_39721__$1;
(statearr_39726_39777[(2)] = inst_39709);

(statearr_39726_39777[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (4))){
var inst_39652 = (state_39721[(8)]);
var inst_39652__$1 = (state_39721[(2)]);
var inst_39653 = (inst_39652__$1 == null);
var state_39721__$1 = (function (){var statearr_39727 = state_39721;
(statearr_39727[(8)] = inst_39652__$1);

return statearr_39727;
})();
if(cljs.core.truth_(inst_39653)){
var statearr_39728_39778 = state_39721__$1;
(statearr_39728_39778[(1)] = (5));

} else {
var statearr_39729_39779 = state_39721__$1;
(statearr_39729_39779[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (15))){
var inst_39694 = (state_39721[(2)]);
var state_39721__$1 = state_39721;
var statearr_39730_39780 = state_39721__$1;
(statearr_39730_39780[(2)] = inst_39694);

(statearr_39730_39780[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (21))){
var inst_39714 = (state_39721[(2)]);
var state_39721__$1 = (function (){var statearr_39731 = state_39721;
(statearr_39731[(9)] = inst_39714);

return statearr_39731;
})();
var statearr_39732_39781 = state_39721__$1;
(statearr_39732_39781[(2)] = null);

(statearr_39732_39781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (13))){
var inst_39676 = (state_39721[(10)]);
var inst_39678 = cljs.core.chunked_seq_QMARK_.call(null,inst_39676);
var state_39721__$1 = state_39721;
if(inst_39678){
var statearr_39733_39782 = state_39721__$1;
(statearr_39733_39782[(1)] = (16));

} else {
var statearr_39734_39783 = state_39721__$1;
(statearr_39734_39783[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (22))){
var inst_39706 = (state_39721[(2)]);
var state_39721__$1 = state_39721;
if(cljs.core.truth_(inst_39706)){
var statearr_39735_39784 = state_39721__$1;
(statearr_39735_39784[(1)] = (23));

} else {
var statearr_39736_39785 = state_39721__$1;
(statearr_39736_39785[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (6))){
var inst_39700 = (state_39721[(7)]);
var inst_39652 = (state_39721[(8)]);
var inst_39702 = (state_39721[(11)]);
var inst_39700__$1 = topic_fn.call(null,inst_39652);
var inst_39701 = cljs.core.deref.call(null,mults);
var inst_39702__$1 = cljs.core.get.call(null,inst_39701,inst_39700__$1);
var state_39721__$1 = (function (){var statearr_39737 = state_39721;
(statearr_39737[(7)] = inst_39700__$1);

(statearr_39737[(11)] = inst_39702__$1);

return statearr_39737;
})();
if(cljs.core.truth_(inst_39702__$1)){
var statearr_39738_39786 = state_39721__$1;
(statearr_39738_39786[(1)] = (19));

} else {
var statearr_39739_39787 = state_39721__$1;
(statearr_39739_39787[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (25))){
var inst_39711 = (state_39721[(2)]);
var state_39721__$1 = state_39721;
var statearr_39740_39788 = state_39721__$1;
(statearr_39740_39788[(2)] = inst_39711);

(statearr_39740_39788[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (17))){
var inst_39676 = (state_39721[(10)]);
var inst_39685 = cljs.core.first.call(null,inst_39676);
var inst_39686 = cljs.core.async.muxch_STAR_.call(null,inst_39685);
var inst_39687 = cljs.core.async.close_BANG_.call(null,inst_39686);
var inst_39688 = cljs.core.next.call(null,inst_39676);
var inst_39662 = inst_39688;
var inst_39663 = null;
var inst_39664 = (0);
var inst_39665 = (0);
var state_39721__$1 = (function (){var statearr_39741 = state_39721;
(statearr_39741[(12)] = inst_39662);

(statearr_39741[(13)] = inst_39665);

(statearr_39741[(14)] = inst_39687);

(statearr_39741[(15)] = inst_39664);

(statearr_39741[(16)] = inst_39663);

return statearr_39741;
})();
var statearr_39742_39789 = state_39721__$1;
(statearr_39742_39789[(2)] = null);

(statearr_39742_39789[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (3))){
var inst_39719 = (state_39721[(2)]);
var state_39721__$1 = state_39721;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39721__$1,inst_39719);
} else {
if((state_val_39722 === (12))){
var inst_39696 = (state_39721[(2)]);
var state_39721__$1 = state_39721;
var statearr_39743_39790 = state_39721__$1;
(statearr_39743_39790[(2)] = inst_39696);

(statearr_39743_39790[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (2))){
var state_39721__$1 = state_39721;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39721__$1,(4),ch);
} else {
if((state_val_39722 === (23))){
var state_39721__$1 = state_39721;
var statearr_39744_39791 = state_39721__$1;
(statearr_39744_39791[(2)] = null);

(statearr_39744_39791[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (19))){
var inst_39652 = (state_39721[(8)]);
var inst_39702 = (state_39721[(11)]);
var inst_39704 = cljs.core.async.muxch_STAR_.call(null,inst_39702);
var state_39721__$1 = state_39721;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39721__$1,(22),inst_39704,inst_39652);
} else {
if((state_val_39722 === (11))){
var inst_39662 = (state_39721[(12)]);
var inst_39676 = (state_39721[(10)]);
var inst_39676__$1 = cljs.core.seq.call(null,inst_39662);
var state_39721__$1 = (function (){var statearr_39745 = state_39721;
(statearr_39745[(10)] = inst_39676__$1);

return statearr_39745;
})();
if(inst_39676__$1){
var statearr_39746_39792 = state_39721__$1;
(statearr_39746_39792[(1)] = (13));

} else {
var statearr_39747_39793 = state_39721__$1;
(statearr_39747_39793[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (9))){
var inst_39698 = (state_39721[(2)]);
var state_39721__$1 = state_39721;
var statearr_39748_39794 = state_39721__$1;
(statearr_39748_39794[(2)] = inst_39698);

(statearr_39748_39794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (5))){
var inst_39659 = cljs.core.deref.call(null,mults);
var inst_39660 = cljs.core.vals.call(null,inst_39659);
var inst_39661 = cljs.core.seq.call(null,inst_39660);
var inst_39662 = inst_39661;
var inst_39663 = null;
var inst_39664 = (0);
var inst_39665 = (0);
var state_39721__$1 = (function (){var statearr_39749 = state_39721;
(statearr_39749[(12)] = inst_39662);

(statearr_39749[(13)] = inst_39665);

(statearr_39749[(15)] = inst_39664);

(statearr_39749[(16)] = inst_39663);

return statearr_39749;
})();
var statearr_39750_39795 = state_39721__$1;
(statearr_39750_39795[(2)] = null);

(statearr_39750_39795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (14))){
var state_39721__$1 = state_39721;
var statearr_39754_39796 = state_39721__$1;
(statearr_39754_39796[(2)] = null);

(statearr_39754_39796[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (16))){
var inst_39676 = (state_39721[(10)]);
var inst_39680 = cljs.core.chunk_first.call(null,inst_39676);
var inst_39681 = cljs.core.chunk_rest.call(null,inst_39676);
var inst_39682 = cljs.core.count.call(null,inst_39680);
var inst_39662 = inst_39681;
var inst_39663 = inst_39680;
var inst_39664 = inst_39682;
var inst_39665 = (0);
var state_39721__$1 = (function (){var statearr_39755 = state_39721;
(statearr_39755[(12)] = inst_39662);

(statearr_39755[(13)] = inst_39665);

(statearr_39755[(15)] = inst_39664);

(statearr_39755[(16)] = inst_39663);

return statearr_39755;
})();
var statearr_39756_39797 = state_39721__$1;
(statearr_39756_39797[(2)] = null);

(statearr_39756_39797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (10))){
var inst_39662 = (state_39721[(12)]);
var inst_39665 = (state_39721[(13)]);
var inst_39664 = (state_39721[(15)]);
var inst_39663 = (state_39721[(16)]);
var inst_39670 = cljs.core._nth.call(null,inst_39663,inst_39665);
var inst_39671 = cljs.core.async.muxch_STAR_.call(null,inst_39670);
var inst_39672 = cljs.core.async.close_BANG_.call(null,inst_39671);
var inst_39673 = (inst_39665 + (1));
var tmp39751 = inst_39662;
var tmp39752 = inst_39664;
var tmp39753 = inst_39663;
var inst_39662__$1 = tmp39751;
var inst_39663__$1 = tmp39753;
var inst_39664__$1 = tmp39752;
var inst_39665__$1 = inst_39673;
var state_39721__$1 = (function (){var statearr_39757 = state_39721;
(statearr_39757[(12)] = inst_39662__$1);

(statearr_39757[(13)] = inst_39665__$1);

(statearr_39757[(17)] = inst_39672);

(statearr_39757[(15)] = inst_39664__$1);

(statearr_39757[(16)] = inst_39663__$1);

return statearr_39757;
})();
var statearr_39758_39798 = state_39721__$1;
(statearr_39758_39798[(2)] = null);

(statearr_39758_39798[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (18))){
var inst_39691 = (state_39721[(2)]);
var state_39721__$1 = state_39721;
var statearr_39759_39799 = state_39721__$1;
(statearr_39759_39799[(2)] = inst_39691);

(statearr_39759_39799[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39722 === (8))){
var inst_39665 = (state_39721[(13)]);
var inst_39664 = (state_39721[(15)]);
var inst_39667 = (inst_39665 < inst_39664);
var inst_39668 = inst_39667;
var state_39721__$1 = state_39721;
if(cljs.core.truth_(inst_39668)){
var statearr_39760_39800 = state_39721__$1;
(statearr_39760_39800[(1)] = (10));

} else {
var statearr_39761_39801 = state_39721__$1;
(statearr_39761_39801[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___39773,mults,ensure_mult,p))
;
return ((function (switch__19364__auto__,c__19429__auto___39773,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__19365__auto__ = null;
var cljs$core$async$state_machine__19365__auto____0 = (function (){
var statearr_39765 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39765[(0)] = cljs$core$async$state_machine__19365__auto__);

(statearr_39765[(1)] = (1));

return statearr_39765;
});
var cljs$core$async$state_machine__19365__auto____1 = (function (state_39721){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_39721);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e39766){if((e39766 instanceof Object)){
var ex__19368__auto__ = e39766;
var statearr_39767_39802 = state_39721;
(statearr_39767_39802[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39721);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39766;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39803 = state_39721;
state_39721 = G__39803;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$state_machine__19365__auto__ = function(state_39721){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19365__auto____1.call(this,state_39721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19365__auto____0;
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19365__auto____1;
return cljs$core$async$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___39773,mults,ensure_mult,p))
})();
var state__19431__auto__ = (function (){var statearr_39768 = f__19430__auto__.call(null);
(statearr_39768[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___39773);

return statearr_39768;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___39773,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args39804 = [];
var len__17407__auto___39807 = arguments.length;
var i__17408__auto___39808 = (0);
while(true){
if((i__17408__auto___39808 < len__17407__auto___39807)){
args39804.push((arguments[i__17408__auto___39808]));

var G__39809 = (i__17408__auto___39808 + (1));
i__17408__auto___39808 = G__39809;
continue;
} else {
}
break;
}

var G__39806 = args39804.length;
switch (G__39806) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39804.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args39811 = [];
var len__17407__auto___39814 = arguments.length;
var i__17408__auto___39815 = (0);
while(true){
if((i__17408__auto___39815 < len__17407__auto___39814)){
args39811.push((arguments[i__17408__auto___39815]));

var G__39816 = (i__17408__auto___39815 + (1));
i__17408__auto___39815 = G__39816;
continue;
} else {
}
break;
}

var G__39813 = args39811.length;
switch (G__39813) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39811.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args39818 = [];
var len__17407__auto___39889 = arguments.length;
var i__17408__auto___39890 = (0);
while(true){
if((i__17408__auto___39890 < len__17407__auto___39889)){
args39818.push((arguments[i__17408__auto___39890]));

var G__39891 = (i__17408__auto___39890 + (1));
i__17408__auto___39890 = G__39891;
continue;
} else {
}
break;
}

var G__39820 = args39818.length;
switch (G__39820) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39818.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__19429__auto___39893 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___39893,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___39893,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_39859){
var state_val_39860 = (state_39859[(1)]);
if((state_val_39860 === (7))){
var state_39859__$1 = state_39859;
var statearr_39861_39894 = state_39859__$1;
(statearr_39861_39894[(2)] = null);

(statearr_39861_39894[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39860 === (1))){
var state_39859__$1 = state_39859;
var statearr_39862_39895 = state_39859__$1;
(statearr_39862_39895[(2)] = null);

(statearr_39862_39895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39860 === (4))){
var inst_39823 = (state_39859[(7)]);
var inst_39825 = (inst_39823 < cnt);
var state_39859__$1 = state_39859;
if(cljs.core.truth_(inst_39825)){
var statearr_39863_39896 = state_39859__$1;
(statearr_39863_39896[(1)] = (6));

} else {
var statearr_39864_39897 = state_39859__$1;
(statearr_39864_39897[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39860 === (15))){
var inst_39855 = (state_39859[(2)]);
var state_39859__$1 = state_39859;
var statearr_39865_39898 = state_39859__$1;
(statearr_39865_39898[(2)] = inst_39855);

(statearr_39865_39898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39860 === (13))){
var inst_39848 = cljs.core.async.close_BANG_.call(null,out);
var state_39859__$1 = state_39859;
var statearr_39866_39899 = state_39859__$1;
(statearr_39866_39899[(2)] = inst_39848);

(statearr_39866_39899[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39860 === (6))){
var state_39859__$1 = state_39859;
var statearr_39867_39900 = state_39859__$1;
(statearr_39867_39900[(2)] = null);

(statearr_39867_39900[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39860 === (3))){
var inst_39857 = (state_39859[(2)]);
var state_39859__$1 = state_39859;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39859__$1,inst_39857);
} else {
if((state_val_39860 === (12))){
var inst_39845 = (state_39859[(8)]);
var inst_39845__$1 = (state_39859[(2)]);
var inst_39846 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_39845__$1);
var state_39859__$1 = (function (){var statearr_39868 = state_39859;
(statearr_39868[(8)] = inst_39845__$1);

return statearr_39868;
})();
if(cljs.core.truth_(inst_39846)){
var statearr_39869_39901 = state_39859__$1;
(statearr_39869_39901[(1)] = (13));

} else {
var statearr_39870_39902 = state_39859__$1;
(statearr_39870_39902[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39860 === (2))){
var inst_39822 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_39823 = (0);
var state_39859__$1 = (function (){var statearr_39871 = state_39859;
(statearr_39871[(9)] = inst_39822);

(statearr_39871[(7)] = inst_39823);

return statearr_39871;
})();
var statearr_39872_39903 = state_39859__$1;
(statearr_39872_39903[(2)] = null);

(statearr_39872_39903[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39860 === (11))){
var inst_39823 = (state_39859[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_39859,(10),Object,null,(9));
var inst_39832 = chs__$1.call(null,inst_39823);
var inst_39833 = done.call(null,inst_39823);
var inst_39834 = cljs.core.async.take_BANG_.call(null,inst_39832,inst_39833);
var state_39859__$1 = state_39859;
var statearr_39873_39904 = state_39859__$1;
(statearr_39873_39904[(2)] = inst_39834);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39859__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39860 === (9))){
var inst_39823 = (state_39859[(7)]);
var inst_39836 = (state_39859[(2)]);
var inst_39837 = (inst_39823 + (1));
var inst_39823__$1 = inst_39837;
var state_39859__$1 = (function (){var statearr_39874 = state_39859;
(statearr_39874[(10)] = inst_39836);

(statearr_39874[(7)] = inst_39823__$1);

return statearr_39874;
})();
var statearr_39875_39905 = state_39859__$1;
(statearr_39875_39905[(2)] = null);

(statearr_39875_39905[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39860 === (5))){
var inst_39843 = (state_39859[(2)]);
var state_39859__$1 = (function (){var statearr_39876 = state_39859;
(statearr_39876[(11)] = inst_39843);

return statearr_39876;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39859__$1,(12),dchan);
} else {
if((state_val_39860 === (14))){
var inst_39845 = (state_39859[(8)]);
var inst_39850 = cljs.core.apply.call(null,f,inst_39845);
var state_39859__$1 = state_39859;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39859__$1,(16),out,inst_39850);
} else {
if((state_val_39860 === (16))){
var inst_39852 = (state_39859[(2)]);
var state_39859__$1 = (function (){var statearr_39877 = state_39859;
(statearr_39877[(12)] = inst_39852);

return statearr_39877;
})();
var statearr_39878_39906 = state_39859__$1;
(statearr_39878_39906[(2)] = null);

(statearr_39878_39906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39860 === (10))){
var inst_39827 = (state_39859[(2)]);
var inst_39828 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_39859__$1 = (function (){var statearr_39879 = state_39859;
(statearr_39879[(13)] = inst_39827);

return statearr_39879;
})();
var statearr_39880_39907 = state_39859__$1;
(statearr_39880_39907[(2)] = inst_39828);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39859__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39860 === (8))){
var inst_39841 = (state_39859[(2)]);
var state_39859__$1 = state_39859;
var statearr_39881_39908 = state_39859__$1;
(statearr_39881_39908[(2)] = inst_39841);

(statearr_39881_39908[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___39893,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__19364__auto__,c__19429__auto___39893,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__19365__auto__ = null;
var cljs$core$async$state_machine__19365__auto____0 = (function (){
var statearr_39885 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39885[(0)] = cljs$core$async$state_machine__19365__auto__);

(statearr_39885[(1)] = (1));

return statearr_39885;
});
var cljs$core$async$state_machine__19365__auto____1 = (function (state_39859){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_39859);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e39886){if((e39886 instanceof Object)){
var ex__19368__auto__ = e39886;
var statearr_39887_39909 = state_39859;
(statearr_39887_39909[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39859);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39886;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39910 = state_39859;
state_39859 = G__39910;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$state_machine__19365__auto__ = function(state_39859){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19365__auto____1.call(this,state_39859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19365__auto____0;
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19365__auto____1;
return cljs$core$async$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___39893,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__19431__auto__ = (function (){var statearr_39888 = f__19430__auto__.call(null);
(statearr_39888[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___39893);

return statearr_39888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___39893,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args39912 = [];
var len__17407__auto___39968 = arguments.length;
var i__17408__auto___39969 = (0);
while(true){
if((i__17408__auto___39969 < len__17407__auto___39968)){
args39912.push((arguments[i__17408__auto___39969]));

var G__39970 = (i__17408__auto___39969 + (1));
i__17408__auto___39969 = G__39970;
continue;
} else {
}
break;
}

var G__39914 = args39912.length;
switch (G__39914) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39912.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19429__auto___39972 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___39972,out){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___39972,out){
return (function (state_39944){
var state_val_39945 = (state_39944[(1)]);
if((state_val_39945 === (7))){
var inst_39924 = (state_39944[(7)]);
var inst_39923 = (state_39944[(8)]);
var inst_39923__$1 = (state_39944[(2)]);
var inst_39924__$1 = cljs.core.nth.call(null,inst_39923__$1,(0),null);
var inst_39925 = cljs.core.nth.call(null,inst_39923__$1,(1),null);
var inst_39926 = (inst_39924__$1 == null);
var state_39944__$1 = (function (){var statearr_39946 = state_39944;
(statearr_39946[(7)] = inst_39924__$1);

(statearr_39946[(8)] = inst_39923__$1);

(statearr_39946[(9)] = inst_39925);

return statearr_39946;
})();
if(cljs.core.truth_(inst_39926)){
var statearr_39947_39973 = state_39944__$1;
(statearr_39947_39973[(1)] = (8));

} else {
var statearr_39948_39974 = state_39944__$1;
(statearr_39948_39974[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (1))){
var inst_39915 = cljs.core.vec.call(null,chs);
var inst_39916 = inst_39915;
var state_39944__$1 = (function (){var statearr_39949 = state_39944;
(statearr_39949[(10)] = inst_39916);

return statearr_39949;
})();
var statearr_39950_39975 = state_39944__$1;
(statearr_39950_39975[(2)] = null);

(statearr_39950_39975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (4))){
var inst_39916 = (state_39944[(10)]);
var state_39944__$1 = state_39944;
return cljs.core.async.ioc_alts_BANG_.call(null,state_39944__$1,(7),inst_39916);
} else {
if((state_val_39945 === (6))){
var inst_39940 = (state_39944[(2)]);
var state_39944__$1 = state_39944;
var statearr_39951_39976 = state_39944__$1;
(statearr_39951_39976[(2)] = inst_39940);

(statearr_39951_39976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (3))){
var inst_39942 = (state_39944[(2)]);
var state_39944__$1 = state_39944;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39944__$1,inst_39942);
} else {
if((state_val_39945 === (2))){
var inst_39916 = (state_39944[(10)]);
var inst_39918 = cljs.core.count.call(null,inst_39916);
var inst_39919 = (inst_39918 > (0));
var state_39944__$1 = state_39944;
if(cljs.core.truth_(inst_39919)){
var statearr_39953_39977 = state_39944__$1;
(statearr_39953_39977[(1)] = (4));

} else {
var statearr_39954_39978 = state_39944__$1;
(statearr_39954_39978[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (11))){
var inst_39916 = (state_39944[(10)]);
var inst_39933 = (state_39944[(2)]);
var tmp39952 = inst_39916;
var inst_39916__$1 = tmp39952;
var state_39944__$1 = (function (){var statearr_39955 = state_39944;
(statearr_39955[(11)] = inst_39933);

(statearr_39955[(10)] = inst_39916__$1);

return statearr_39955;
})();
var statearr_39956_39979 = state_39944__$1;
(statearr_39956_39979[(2)] = null);

(statearr_39956_39979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (9))){
var inst_39924 = (state_39944[(7)]);
var state_39944__$1 = state_39944;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39944__$1,(11),out,inst_39924);
} else {
if((state_val_39945 === (5))){
var inst_39938 = cljs.core.async.close_BANG_.call(null,out);
var state_39944__$1 = state_39944;
var statearr_39957_39980 = state_39944__$1;
(statearr_39957_39980[(2)] = inst_39938);

(statearr_39957_39980[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (10))){
var inst_39936 = (state_39944[(2)]);
var state_39944__$1 = state_39944;
var statearr_39958_39981 = state_39944__$1;
(statearr_39958_39981[(2)] = inst_39936);

(statearr_39958_39981[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (8))){
var inst_39924 = (state_39944[(7)]);
var inst_39923 = (state_39944[(8)]);
var inst_39925 = (state_39944[(9)]);
var inst_39916 = (state_39944[(10)]);
var inst_39928 = (function (){var cs = inst_39916;
var vec__39921 = inst_39923;
var v = inst_39924;
var c = inst_39925;
return ((function (cs,vec__39921,v,c,inst_39924,inst_39923,inst_39925,inst_39916,state_val_39945,c__19429__auto___39972,out){
return (function (p1__39911_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__39911_SHARP_);
});
;})(cs,vec__39921,v,c,inst_39924,inst_39923,inst_39925,inst_39916,state_val_39945,c__19429__auto___39972,out))
})();
var inst_39929 = cljs.core.filterv.call(null,inst_39928,inst_39916);
var inst_39916__$1 = inst_39929;
var state_39944__$1 = (function (){var statearr_39959 = state_39944;
(statearr_39959[(10)] = inst_39916__$1);

return statearr_39959;
})();
var statearr_39960_39982 = state_39944__$1;
(statearr_39960_39982[(2)] = null);

(statearr_39960_39982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___39972,out))
;
return ((function (switch__19364__auto__,c__19429__auto___39972,out){
return (function() {
var cljs$core$async$state_machine__19365__auto__ = null;
var cljs$core$async$state_machine__19365__auto____0 = (function (){
var statearr_39964 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39964[(0)] = cljs$core$async$state_machine__19365__auto__);

(statearr_39964[(1)] = (1));

return statearr_39964;
});
var cljs$core$async$state_machine__19365__auto____1 = (function (state_39944){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_39944);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e39965){if((e39965 instanceof Object)){
var ex__19368__auto__ = e39965;
var statearr_39966_39983 = state_39944;
(statearr_39966_39983[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39944);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39965;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39984 = state_39944;
state_39944 = G__39984;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$state_machine__19365__auto__ = function(state_39944){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19365__auto____1.call(this,state_39944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19365__auto____0;
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19365__auto____1;
return cljs$core$async$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___39972,out))
})();
var state__19431__auto__ = (function (){var statearr_39967 = f__19430__auto__.call(null);
(statearr_39967[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___39972);

return statearr_39967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___39972,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args39985 = [];
var len__17407__auto___40034 = arguments.length;
var i__17408__auto___40035 = (0);
while(true){
if((i__17408__auto___40035 < len__17407__auto___40034)){
args39985.push((arguments[i__17408__auto___40035]));

var G__40036 = (i__17408__auto___40035 + (1));
i__17408__auto___40035 = G__40036;
continue;
} else {
}
break;
}

var G__39987 = args39985.length;
switch (G__39987) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39985.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19429__auto___40038 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___40038,out){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___40038,out){
return (function (state_40011){
var state_val_40012 = (state_40011[(1)]);
if((state_val_40012 === (7))){
var inst_39993 = (state_40011[(7)]);
var inst_39993__$1 = (state_40011[(2)]);
var inst_39994 = (inst_39993__$1 == null);
var inst_39995 = cljs.core.not.call(null,inst_39994);
var state_40011__$1 = (function (){var statearr_40013 = state_40011;
(statearr_40013[(7)] = inst_39993__$1);

return statearr_40013;
})();
if(inst_39995){
var statearr_40014_40039 = state_40011__$1;
(statearr_40014_40039[(1)] = (8));

} else {
var statearr_40015_40040 = state_40011__$1;
(statearr_40015_40040[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40012 === (1))){
var inst_39988 = (0);
var state_40011__$1 = (function (){var statearr_40016 = state_40011;
(statearr_40016[(8)] = inst_39988);

return statearr_40016;
})();
var statearr_40017_40041 = state_40011__$1;
(statearr_40017_40041[(2)] = null);

(statearr_40017_40041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40012 === (4))){
var state_40011__$1 = state_40011;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40011__$1,(7),ch);
} else {
if((state_val_40012 === (6))){
var inst_40006 = (state_40011[(2)]);
var state_40011__$1 = state_40011;
var statearr_40018_40042 = state_40011__$1;
(statearr_40018_40042[(2)] = inst_40006);

(statearr_40018_40042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40012 === (3))){
var inst_40008 = (state_40011[(2)]);
var inst_40009 = cljs.core.async.close_BANG_.call(null,out);
var state_40011__$1 = (function (){var statearr_40019 = state_40011;
(statearr_40019[(9)] = inst_40008);

return statearr_40019;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40011__$1,inst_40009);
} else {
if((state_val_40012 === (2))){
var inst_39988 = (state_40011[(8)]);
var inst_39990 = (inst_39988 < n);
var state_40011__$1 = state_40011;
if(cljs.core.truth_(inst_39990)){
var statearr_40020_40043 = state_40011__$1;
(statearr_40020_40043[(1)] = (4));

} else {
var statearr_40021_40044 = state_40011__$1;
(statearr_40021_40044[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40012 === (11))){
var inst_39988 = (state_40011[(8)]);
var inst_39998 = (state_40011[(2)]);
var inst_39999 = (inst_39988 + (1));
var inst_39988__$1 = inst_39999;
var state_40011__$1 = (function (){var statearr_40022 = state_40011;
(statearr_40022[(8)] = inst_39988__$1);

(statearr_40022[(10)] = inst_39998);

return statearr_40022;
})();
var statearr_40023_40045 = state_40011__$1;
(statearr_40023_40045[(2)] = null);

(statearr_40023_40045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40012 === (9))){
var state_40011__$1 = state_40011;
var statearr_40024_40046 = state_40011__$1;
(statearr_40024_40046[(2)] = null);

(statearr_40024_40046[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40012 === (5))){
var state_40011__$1 = state_40011;
var statearr_40025_40047 = state_40011__$1;
(statearr_40025_40047[(2)] = null);

(statearr_40025_40047[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40012 === (10))){
var inst_40003 = (state_40011[(2)]);
var state_40011__$1 = state_40011;
var statearr_40026_40048 = state_40011__$1;
(statearr_40026_40048[(2)] = inst_40003);

(statearr_40026_40048[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40012 === (8))){
var inst_39993 = (state_40011[(7)]);
var state_40011__$1 = state_40011;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40011__$1,(11),out,inst_39993);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___40038,out))
;
return ((function (switch__19364__auto__,c__19429__auto___40038,out){
return (function() {
var cljs$core$async$state_machine__19365__auto__ = null;
var cljs$core$async$state_machine__19365__auto____0 = (function (){
var statearr_40030 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40030[(0)] = cljs$core$async$state_machine__19365__auto__);

(statearr_40030[(1)] = (1));

return statearr_40030;
});
var cljs$core$async$state_machine__19365__auto____1 = (function (state_40011){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_40011);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e40031){if((e40031 instanceof Object)){
var ex__19368__auto__ = e40031;
var statearr_40032_40049 = state_40011;
(statearr_40032_40049[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40011);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40031;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40050 = state_40011;
state_40011 = G__40050;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$state_machine__19365__auto__ = function(state_40011){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19365__auto____1.call(this,state_40011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19365__auto____0;
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19365__auto____1;
return cljs$core$async$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___40038,out))
})();
var state__19431__auto__ = (function (){var statearr_40033 = f__19430__auto__.call(null);
(statearr_40033[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___40038);

return statearr_40033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___40038,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async40058 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40058 = (function (map_LT_,f,ch,meta40059){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta40059 = meta40059;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async40058.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40060,meta40059__$1){
var self__ = this;
var _40060__$1 = this;
return (new cljs.core.async.t_cljs$core$async40058(self__.map_LT_,self__.f,self__.ch,meta40059__$1));
});

cljs.core.async.t_cljs$core$async40058.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40060){
var self__ = this;
var _40060__$1 = this;
return self__.meta40059;
});

cljs.core.async.t_cljs$core$async40058.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async40058.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40058.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40058.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async40058.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async40061 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40061 = (function (map_LT_,f,ch,meta40059,_,fn1,meta40062){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta40059 = meta40059;
this._ = _;
this.fn1 = fn1;
this.meta40062 = meta40062;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async40061.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_40063,meta40062__$1){
var self__ = this;
var _40063__$1 = this;
return (new cljs.core.async.t_cljs$core$async40061(self__.map_LT_,self__.f,self__.ch,self__.meta40059,self__._,self__.fn1,meta40062__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async40061.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_40063){
var self__ = this;
var _40063__$1 = this;
return self__.meta40062;
});})(___$1))
;

cljs.core.async.t_cljs$core$async40061.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async40061.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async40061.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__40051_SHARP_){
return f1.call(null,(((p1__40051_SHARP_ == null))?null:self__.f.call(null,p1__40051_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async40061.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40059","meta40059",-975344576,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async40058","cljs.core.async/t_cljs$core$async40058",-1387266503,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta40062","meta40062",-956334256,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async40061.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40061.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40061";

cljs.core.async.t_cljs$core$async40061.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cljs.core.async/t_cljs$core$async40061");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async40061 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async40061(map_LT___$1,f__$1,ch__$1,meta40059__$1,___$2,fn1__$1,meta40062){
return (new cljs.core.async.t_cljs$core$async40061(map_LT___$1,f__$1,ch__$1,meta40059__$1,___$2,fn1__$1,meta40062));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async40061(self__.map_LT_,self__.f,self__.ch,self__.meta40059,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__16337__auto__ = ret;
if(cljs.core.truth_(and__16337__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__16337__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async40058.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async40058.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async40058.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40059","meta40059",-975344576,null)], null);
});

cljs.core.async.t_cljs$core$async40058.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40058.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40058";

cljs.core.async.t_cljs$core$async40058.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cljs.core.async/t_cljs$core$async40058");
});

cljs.core.async.__GT_t_cljs$core$async40058 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async40058(map_LT___$1,f__$1,ch__$1,meta40059){
return (new cljs.core.async.t_cljs$core$async40058(map_LT___$1,f__$1,ch__$1,meta40059));
});

}

return (new cljs.core.async.t_cljs$core$async40058(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async40067 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40067 = (function (map_GT_,f,ch,meta40068){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta40068 = meta40068;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async40067.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40069,meta40068__$1){
var self__ = this;
var _40069__$1 = this;
return (new cljs.core.async.t_cljs$core$async40067(self__.map_GT_,self__.f,self__.ch,meta40068__$1));
});

cljs.core.async.t_cljs$core$async40067.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40069){
var self__ = this;
var _40069__$1 = this;
return self__.meta40068;
});

cljs.core.async.t_cljs$core$async40067.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async40067.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40067.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async40067.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async40067.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async40067.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async40067.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40068","meta40068",-970084145,null)], null);
});

cljs.core.async.t_cljs$core$async40067.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40067.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40067";

cljs.core.async.t_cljs$core$async40067.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cljs.core.async/t_cljs$core$async40067");
});

cljs.core.async.__GT_t_cljs$core$async40067 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async40067(map_GT___$1,f__$1,ch__$1,meta40068){
return (new cljs.core.async.t_cljs$core$async40067(map_GT___$1,f__$1,ch__$1,meta40068));
});

}

return (new cljs.core.async.t_cljs$core$async40067(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async40073 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40073 = (function (filter_GT_,p,ch,meta40074){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta40074 = meta40074;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async40073.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40075,meta40074__$1){
var self__ = this;
var _40075__$1 = this;
return (new cljs.core.async.t_cljs$core$async40073(self__.filter_GT_,self__.p,self__.ch,meta40074__$1));
});

cljs.core.async.t_cljs$core$async40073.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40075){
var self__ = this;
var _40075__$1 = this;
return self__.meta40074;
});

cljs.core.async.t_cljs$core$async40073.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async40073.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40073.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40073.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async40073.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async40073.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async40073.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async40073.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40074","meta40074",-382097336,null)], null);
});

cljs.core.async.t_cljs$core$async40073.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40073.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40073";

cljs.core.async.t_cljs$core$async40073.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cljs.core.async/t_cljs$core$async40073");
});

cljs.core.async.__GT_t_cljs$core$async40073 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async40073(filter_GT___$1,p__$1,ch__$1,meta40074){
return (new cljs.core.async.t_cljs$core$async40073(filter_GT___$1,p__$1,ch__$1,meta40074));
});

}

return (new cljs.core.async.t_cljs$core$async40073(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args40076 = [];
var len__17407__auto___40120 = arguments.length;
var i__17408__auto___40121 = (0);
while(true){
if((i__17408__auto___40121 < len__17407__auto___40120)){
args40076.push((arguments[i__17408__auto___40121]));

var G__40122 = (i__17408__auto___40121 + (1));
i__17408__auto___40121 = G__40122;
continue;
} else {
}
break;
}

var G__40078 = args40076.length;
switch (G__40078) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40076.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19429__auto___40124 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___40124,out){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___40124,out){
return (function (state_40099){
var state_val_40100 = (state_40099[(1)]);
if((state_val_40100 === (7))){
var inst_40095 = (state_40099[(2)]);
var state_40099__$1 = state_40099;
var statearr_40101_40125 = state_40099__$1;
(statearr_40101_40125[(2)] = inst_40095);

(statearr_40101_40125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40100 === (1))){
var state_40099__$1 = state_40099;
var statearr_40102_40126 = state_40099__$1;
(statearr_40102_40126[(2)] = null);

(statearr_40102_40126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40100 === (4))){
var inst_40081 = (state_40099[(7)]);
var inst_40081__$1 = (state_40099[(2)]);
var inst_40082 = (inst_40081__$1 == null);
var state_40099__$1 = (function (){var statearr_40103 = state_40099;
(statearr_40103[(7)] = inst_40081__$1);

return statearr_40103;
})();
if(cljs.core.truth_(inst_40082)){
var statearr_40104_40127 = state_40099__$1;
(statearr_40104_40127[(1)] = (5));

} else {
var statearr_40105_40128 = state_40099__$1;
(statearr_40105_40128[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40100 === (6))){
var inst_40081 = (state_40099[(7)]);
var inst_40086 = p.call(null,inst_40081);
var state_40099__$1 = state_40099;
if(cljs.core.truth_(inst_40086)){
var statearr_40106_40129 = state_40099__$1;
(statearr_40106_40129[(1)] = (8));

} else {
var statearr_40107_40130 = state_40099__$1;
(statearr_40107_40130[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40100 === (3))){
var inst_40097 = (state_40099[(2)]);
var state_40099__$1 = state_40099;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40099__$1,inst_40097);
} else {
if((state_val_40100 === (2))){
var state_40099__$1 = state_40099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40099__$1,(4),ch);
} else {
if((state_val_40100 === (11))){
var inst_40089 = (state_40099[(2)]);
var state_40099__$1 = state_40099;
var statearr_40108_40131 = state_40099__$1;
(statearr_40108_40131[(2)] = inst_40089);

(statearr_40108_40131[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40100 === (9))){
var state_40099__$1 = state_40099;
var statearr_40109_40132 = state_40099__$1;
(statearr_40109_40132[(2)] = null);

(statearr_40109_40132[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40100 === (5))){
var inst_40084 = cljs.core.async.close_BANG_.call(null,out);
var state_40099__$1 = state_40099;
var statearr_40110_40133 = state_40099__$1;
(statearr_40110_40133[(2)] = inst_40084);

(statearr_40110_40133[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40100 === (10))){
var inst_40092 = (state_40099[(2)]);
var state_40099__$1 = (function (){var statearr_40111 = state_40099;
(statearr_40111[(8)] = inst_40092);

return statearr_40111;
})();
var statearr_40112_40134 = state_40099__$1;
(statearr_40112_40134[(2)] = null);

(statearr_40112_40134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40100 === (8))){
var inst_40081 = (state_40099[(7)]);
var state_40099__$1 = state_40099;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40099__$1,(11),out,inst_40081);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___40124,out))
;
return ((function (switch__19364__auto__,c__19429__auto___40124,out){
return (function() {
var cljs$core$async$state_machine__19365__auto__ = null;
var cljs$core$async$state_machine__19365__auto____0 = (function (){
var statearr_40116 = [null,null,null,null,null,null,null,null,null];
(statearr_40116[(0)] = cljs$core$async$state_machine__19365__auto__);

(statearr_40116[(1)] = (1));

return statearr_40116;
});
var cljs$core$async$state_machine__19365__auto____1 = (function (state_40099){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_40099);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e40117){if((e40117 instanceof Object)){
var ex__19368__auto__ = e40117;
var statearr_40118_40135 = state_40099;
(statearr_40118_40135[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40099);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40117;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40136 = state_40099;
state_40099 = G__40136;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$state_machine__19365__auto__ = function(state_40099){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19365__auto____1.call(this,state_40099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19365__auto____0;
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19365__auto____1;
return cljs$core$async$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___40124,out))
})();
var state__19431__auto__ = (function (){var statearr_40119 = f__19430__auto__.call(null);
(statearr_40119[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___40124);

return statearr_40119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___40124,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args40137 = [];
var len__17407__auto___40140 = arguments.length;
var i__17408__auto___40141 = (0);
while(true){
if((i__17408__auto___40141 < len__17407__auto___40140)){
args40137.push((arguments[i__17408__auto___40141]));

var G__40142 = (i__17408__auto___40141 + (1));
i__17408__auto___40141 = G__40142;
continue;
} else {
}
break;
}

var G__40139 = args40137.length;
switch (G__40139) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40137.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__19429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto__){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto__){
return (function (state_40309){
var state_val_40310 = (state_40309[(1)]);
if((state_val_40310 === (7))){
var inst_40305 = (state_40309[(2)]);
var state_40309__$1 = state_40309;
var statearr_40311_40352 = state_40309__$1;
(statearr_40311_40352[(2)] = inst_40305);

(statearr_40311_40352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (20))){
var inst_40275 = (state_40309[(7)]);
var inst_40286 = (state_40309[(2)]);
var inst_40287 = cljs.core.next.call(null,inst_40275);
var inst_40261 = inst_40287;
var inst_40262 = null;
var inst_40263 = (0);
var inst_40264 = (0);
var state_40309__$1 = (function (){var statearr_40312 = state_40309;
(statearr_40312[(8)] = inst_40286);

(statearr_40312[(9)] = inst_40264);

(statearr_40312[(10)] = inst_40261);

(statearr_40312[(11)] = inst_40263);

(statearr_40312[(12)] = inst_40262);

return statearr_40312;
})();
var statearr_40313_40353 = state_40309__$1;
(statearr_40313_40353[(2)] = null);

(statearr_40313_40353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (1))){
var state_40309__$1 = state_40309;
var statearr_40314_40354 = state_40309__$1;
(statearr_40314_40354[(2)] = null);

(statearr_40314_40354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (4))){
var inst_40250 = (state_40309[(13)]);
var inst_40250__$1 = (state_40309[(2)]);
var inst_40251 = (inst_40250__$1 == null);
var state_40309__$1 = (function (){var statearr_40315 = state_40309;
(statearr_40315[(13)] = inst_40250__$1);

return statearr_40315;
})();
if(cljs.core.truth_(inst_40251)){
var statearr_40316_40355 = state_40309__$1;
(statearr_40316_40355[(1)] = (5));

} else {
var statearr_40317_40356 = state_40309__$1;
(statearr_40317_40356[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (15))){
var state_40309__$1 = state_40309;
var statearr_40321_40357 = state_40309__$1;
(statearr_40321_40357[(2)] = null);

(statearr_40321_40357[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (21))){
var state_40309__$1 = state_40309;
var statearr_40322_40358 = state_40309__$1;
(statearr_40322_40358[(2)] = null);

(statearr_40322_40358[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (13))){
var inst_40264 = (state_40309[(9)]);
var inst_40261 = (state_40309[(10)]);
var inst_40263 = (state_40309[(11)]);
var inst_40262 = (state_40309[(12)]);
var inst_40271 = (state_40309[(2)]);
var inst_40272 = (inst_40264 + (1));
var tmp40318 = inst_40261;
var tmp40319 = inst_40263;
var tmp40320 = inst_40262;
var inst_40261__$1 = tmp40318;
var inst_40262__$1 = tmp40320;
var inst_40263__$1 = tmp40319;
var inst_40264__$1 = inst_40272;
var state_40309__$1 = (function (){var statearr_40323 = state_40309;
(statearr_40323[(9)] = inst_40264__$1);

(statearr_40323[(10)] = inst_40261__$1);

(statearr_40323[(11)] = inst_40263__$1);

(statearr_40323[(12)] = inst_40262__$1);

(statearr_40323[(14)] = inst_40271);

return statearr_40323;
})();
var statearr_40324_40359 = state_40309__$1;
(statearr_40324_40359[(2)] = null);

(statearr_40324_40359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (22))){
var state_40309__$1 = state_40309;
var statearr_40325_40360 = state_40309__$1;
(statearr_40325_40360[(2)] = null);

(statearr_40325_40360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (6))){
var inst_40250 = (state_40309[(13)]);
var inst_40259 = f.call(null,inst_40250);
var inst_40260 = cljs.core.seq.call(null,inst_40259);
var inst_40261 = inst_40260;
var inst_40262 = null;
var inst_40263 = (0);
var inst_40264 = (0);
var state_40309__$1 = (function (){var statearr_40326 = state_40309;
(statearr_40326[(9)] = inst_40264);

(statearr_40326[(10)] = inst_40261);

(statearr_40326[(11)] = inst_40263);

(statearr_40326[(12)] = inst_40262);

return statearr_40326;
})();
var statearr_40327_40361 = state_40309__$1;
(statearr_40327_40361[(2)] = null);

(statearr_40327_40361[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (17))){
var inst_40275 = (state_40309[(7)]);
var inst_40279 = cljs.core.chunk_first.call(null,inst_40275);
var inst_40280 = cljs.core.chunk_rest.call(null,inst_40275);
var inst_40281 = cljs.core.count.call(null,inst_40279);
var inst_40261 = inst_40280;
var inst_40262 = inst_40279;
var inst_40263 = inst_40281;
var inst_40264 = (0);
var state_40309__$1 = (function (){var statearr_40328 = state_40309;
(statearr_40328[(9)] = inst_40264);

(statearr_40328[(10)] = inst_40261);

(statearr_40328[(11)] = inst_40263);

(statearr_40328[(12)] = inst_40262);

return statearr_40328;
})();
var statearr_40329_40362 = state_40309__$1;
(statearr_40329_40362[(2)] = null);

(statearr_40329_40362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (3))){
var inst_40307 = (state_40309[(2)]);
var state_40309__$1 = state_40309;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40309__$1,inst_40307);
} else {
if((state_val_40310 === (12))){
var inst_40295 = (state_40309[(2)]);
var state_40309__$1 = state_40309;
var statearr_40330_40363 = state_40309__$1;
(statearr_40330_40363[(2)] = inst_40295);

(statearr_40330_40363[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (2))){
var state_40309__$1 = state_40309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40309__$1,(4),in$);
} else {
if((state_val_40310 === (23))){
var inst_40303 = (state_40309[(2)]);
var state_40309__$1 = state_40309;
var statearr_40331_40364 = state_40309__$1;
(statearr_40331_40364[(2)] = inst_40303);

(statearr_40331_40364[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (19))){
var inst_40290 = (state_40309[(2)]);
var state_40309__$1 = state_40309;
var statearr_40332_40365 = state_40309__$1;
(statearr_40332_40365[(2)] = inst_40290);

(statearr_40332_40365[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (11))){
var inst_40275 = (state_40309[(7)]);
var inst_40261 = (state_40309[(10)]);
var inst_40275__$1 = cljs.core.seq.call(null,inst_40261);
var state_40309__$1 = (function (){var statearr_40333 = state_40309;
(statearr_40333[(7)] = inst_40275__$1);

return statearr_40333;
})();
if(inst_40275__$1){
var statearr_40334_40366 = state_40309__$1;
(statearr_40334_40366[(1)] = (14));

} else {
var statearr_40335_40367 = state_40309__$1;
(statearr_40335_40367[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (9))){
var inst_40297 = (state_40309[(2)]);
var inst_40298 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_40309__$1 = (function (){var statearr_40336 = state_40309;
(statearr_40336[(15)] = inst_40297);

return statearr_40336;
})();
if(cljs.core.truth_(inst_40298)){
var statearr_40337_40368 = state_40309__$1;
(statearr_40337_40368[(1)] = (21));

} else {
var statearr_40338_40369 = state_40309__$1;
(statearr_40338_40369[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (5))){
var inst_40253 = cljs.core.async.close_BANG_.call(null,out);
var state_40309__$1 = state_40309;
var statearr_40339_40370 = state_40309__$1;
(statearr_40339_40370[(2)] = inst_40253);

(statearr_40339_40370[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (14))){
var inst_40275 = (state_40309[(7)]);
var inst_40277 = cljs.core.chunked_seq_QMARK_.call(null,inst_40275);
var state_40309__$1 = state_40309;
if(inst_40277){
var statearr_40340_40371 = state_40309__$1;
(statearr_40340_40371[(1)] = (17));

} else {
var statearr_40341_40372 = state_40309__$1;
(statearr_40341_40372[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (16))){
var inst_40293 = (state_40309[(2)]);
var state_40309__$1 = state_40309;
var statearr_40342_40373 = state_40309__$1;
(statearr_40342_40373[(2)] = inst_40293);

(statearr_40342_40373[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40310 === (10))){
var inst_40264 = (state_40309[(9)]);
var inst_40262 = (state_40309[(12)]);
var inst_40269 = cljs.core._nth.call(null,inst_40262,inst_40264);
var state_40309__$1 = state_40309;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40309__$1,(13),out,inst_40269);
} else {
if((state_val_40310 === (18))){
var inst_40275 = (state_40309[(7)]);
var inst_40284 = cljs.core.first.call(null,inst_40275);
var state_40309__$1 = state_40309;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40309__$1,(20),out,inst_40284);
} else {
if((state_val_40310 === (8))){
var inst_40264 = (state_40309[(9)]);
var inst_40263 = (state_40309[(11)]);
var inst_40266 = (inst_40264 < inst_40263);
var inst_40267 = inst_40266;
var state_40309__$1 = state_40309;
if(cljs.core.truth_(inst_40267)){
var statearr_40343_40374 = state_40309__$1;
(statearr_40343_40374[(1)] = (10));

} else {
var statearr_40344_40375 = state_40309__$1;
(statearr_40344_40375[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto__))
;
return ((function (switch__19364__auto__,c__19429__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__19365__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__19365__auto____0 = (function (){
var statearr_40348 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40348[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__19365__auto__);

(statearr_40348[(1)] = (1));

return statearr_40348;
});
var cljs$core$async$mapcat_STAR__$_state_machine__19365__auto____1 = (function (state_40309){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_40309);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e40349){if((e40349 instanceof Object)){
var ex__19368__auto__ = e40349;
var statearr_40350_40376 = state_40309;
(statearr_40350_40376[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40309);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40349;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40377 = state_40309;
state_40309 = G__40377;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__19365__auto__ = function(state_40309){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__19365__auto____1.call(this,state_40309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__19365__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__19365__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto__))
})();
var state__19431__auto__ = (function (){var statearr_40351 = f__19430__auto__.call(null);
(statearr_40351[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto__);

return statearr_40351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto__))
);

return c__19429__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args40378 = [];
var len__17407__auto___40381 = arguments.length;
var i__17408__auto___40382 = (0);
while(true){
if((i__17408__auto___40382 < len__17407__auto___40381)){
args40378.push((arguments[i__17408__auto___40382]));

var G__40383 = (i__17408__auto___40382 + (1));
i__17408__auto___40382 = G__40383;
continue;
} else {
}
break;
}

var G__40380 = args40378.length;
switch (G__40380) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40378.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args40385 = [];
var len__17407__auto___40388 = arguments.length;
var i__17408__auto___40389 = (0);
while(true){
if((i__17408__auto___40389 < len__17407__auto___40388)){
args40385.push((arguments[i__17408__auto___40389]));

var G__40390 = (i__17408__auto___40389 + (1));
i__17408__auto___40389 = G__40390;
continue;
} else {
}
break;
}

var G__40387 = args40385.length;
switch (G__40387) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40385.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args40392 = [];
var len__17407__auto___40443 = arguments.length;
var i__17408__auto___40444 = (0);
while(true){
if((i__17408__auto___40444 < len__17407__auto___40443)){
args40392.push((arguments[i__17408__auto___40444]));

var G__40445 = (i__17408__auto___40444 + (1));
i__17408__auto___40444 = G__40445;
continue;
} else {
}
break;
}

var G__40394 = args40392.length;
switch (G__40394) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40392.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19429__auto___40447 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___40447,out){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___40447,out){
return (function (state_40418){
var state_val_40419 = (state_40418[(1)]);
if((state_val_40419 === (7))){
var inst_40413 = (state_40418[(2)]);
var state_40418__$1 = state_40418;
var statearr_40420_40448 = state_40418__$1;
(statearr_40420_40448[(2)] = inst_40413);

(statearr_40420_40448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40419 === (1))){
var inst_40395 = null;
var state_40418__$1 = (function (){var statearr_40421 = state_40418;
(statearr_40421[(7)] = inst_40395);

return statearr_40421;
})();
var statearr_40422_40449 = state_40418__$1;
(statearr_40422_40449[(2)] = null);

(statearr_40422_40449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40419 === (4))){
var inst_40398 = (state_40418[(8)]);
var inst_40398__$1 = (state_40418[(2)]);
var inst_40399 = (inst_40398__$1 == null);
var inst_40400 = cljs.core.not.call(null,inst_40399);
var state_40418__$1 = (function (){var statearr_40423 = state_40418;
(statearr_40423[(8)] = inst_40398__$1);

return statearr_40423;
})();
if(inst_40400){
var statearr_40424_40450 = state_40418__$1;
(statearr_40424_40450[(1)] = (5));

} else {
var statearr_40425_40451 = state_40418__$1;
(statearr_40425_40451[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40419 === (6))){
var state_40418__$1 = state_40418;
var statearr_40426_40452 = state_40418__$1;
(statearr_40426_40452[(2)] = null);

(statearr_40426_40452[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40419 === (3))){
var inst_40415 = (state_40418[(2)]);
var inst_40416 = cljs.core.async.close_BANG_.call(null,out);
var state_40418__$1 = (function (){var statearr_40427 = state_40418;
(statearr_40427[(9)] = inst_40415);

return statearr_40427;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40418__$1,inst_40416);
} else {
if((state_val_40419 === (2))){
var state_40418__$1 = state_40418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40418__$1,(4),ch);
} else {
if((state_val_40419 === (11))){
var inst_40398 = (state_40418[(8)]);
var inst_40407 = (state_40418[(2)]);
var inst_40395 = inst_40398;
var state_40418__$1 = (function (){var statearr_40428 = state_40418;
(statearr_40428[(7)] = inst_40395);

(statearr_40428[(10)] = inst_40407);

return statearr_40428;
})();
var statearr_40429_40453 = state_40418__$1;
(statearr_40429_40453[(2)] = null);

(statearr_40429_40453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40419 === (9))){
var inst_40398 = (state_40418[(8)]);
var state_40418__$1 = state_40418;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40418__$1,(11),out,inst_40398);
} else {
if((state_val_40419 === (5))){
var inst_40395 = (state_40418[(7)]);
var inst_40398 = (state_40418[(8)]);
var inst_40402 = cljs.core._EQ_.call(null,inst_40398,inst_40395);
var state_40418__$1 = state_40418;
if(inst_40402){
var statearr_40431_40454 = state_40418__$1;
(statearr_40431_40454[(1)] = (8));

} else {
var statearr_40432_40455 = state_40418__$1;
(statearr_40432_40455[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40419 === (10))){
var inst_40410 = (state_40418[(2)]);
var state_40418__$1 = state_40418;
var statearr_40433_40456 = state_40418__$1;
(statearr_40433_40456[(2)] = inst_40410);

(statearr_40433_40456[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40419 === (8))){
var inst_40395 = (state_40418[(7)]);
var tmp40430 = inst_40395;
var inst_40395__$1 = tmp40430;
var state_40418__$1 = (function (){var statearr_40434 = state_40418;
(statearr_40434[(7)] = inst_40395__$1);

return statearr_40434;
})();
var statearr_40435_40457 = state_40418__$1;
(statearr_40435_40457[(2)] = null);

(statearr_40435_40457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___40447,out))
;
return ((function (switch__19364__auto__,c__19429__auto___40447,out){
return (function() {
var cljs$core$async$state_machine__19365__auto__ = null;
var cljs$core$async$state_machine__19365__auto____0 = (function (){
var statearr_40439 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40439[(0)] = cljs$core$async$state_machine__19365__auto__);

(statearr_40439[(1)] = (1));

return statearr_40439;
});
var cljs$core$async$state_machine__19365__auto____1 = (function (state_40418){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_40418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e40440){if((e40440 instanceof Object)){
var ex__19368__auto__ = e40440;
var statearr_40441_40458 = state_40418;
(statearr_40441_40458[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40418);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40440;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40459 = state_40418;
state_40418 = G__40459;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$state_machine__19365__auto__ = function(state_40418){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19365__auto____1.call(this,state_40418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19365__auto____0;
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19365__auto____1;
return cljs$core$async$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___40447,out))
})();
var state__19431__auto__ = (function (){var statearr_40442 = f__19430__auto__.call(null);
(statearr_40442[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___40447);

return statearr_40442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___40447,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args40460 = [];
var len__17407__auto___40530 = arguments.length;
var i__17408__auto___40531 = (0);
while(true){
if((i__17408__auto___40531 < len__17407__auto___40530)){
args40460.push((arguments[i__17408__auto___40531]));

var G__40532 = (i__17408__auto___40531 + (1));
i__17408__auto___40531 = G__40532;
continue;
} else {
}
break;
}

var G__40462 = args40460.length;
switch (G__40462) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40460.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19429__auto___40534 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___40534,out){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___40534,out){
return (function (state_40500){
var state_val_40501 = (state_40500[(1)]);
if((state_val_40501 === (7))){
var inst_40496 = (state_40500[(2)]);
var state_40500__$1 = state_40500;
var statearr_40502_40535 = state_40500__$1;
(statearr_40502_40535[(2)] = inst_40496);

(statearr_40502_40535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40501 === (1))){
var inst_40463 = (new Array(n));
var inst_40464 = inst_40463;
var inst_40465 = (0);
var state_40500__$1 = (function (){var statearr_40503 = state_40500;
(statearr_40503[(7)] = inst_40464);

(statearr_40503[(8)] = inst_40465);

return statearr_40503;
})();
var statearr_40504_40536 = state_40500__$1;
(statearr_40504_40536[(2)] = null);

(statearr_40504_40536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40501 === (4))){
var inst_40468 = (state_40500[(9)]);
var inst_40468__$1 = (state_40500[(2)]);
var inst_40469 = (inst_40468__$1 == null);
var inst_40470 = cljs.core.not.call(null,inst_40469);
var state_40500__$1 = (function (){var statearr_40505 = state_40500;
(statearr_40505[(9)] = inst_40468__$1);

return statearr_40505;
})();
if(inst_40470){
var statearr_40506_40537 = state_40500__$1;
(statearr_40506_40537[(1)] = (5));

} else {
var statearr_40507_40538 = state_40500__$1;
(statearr_40507_40538[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40501 === (15))){
var inst_40490 = (state_40500[(2)]);
var state_40500__$1 = state_40500;
var statearr_40508_40539 = state_40500__$1;
(statearr_40508_40539[(2)] = inst_40490);

(statearr_40508_40539[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40501 === (13))){
var state_40500__$1 = state_40500;
var statearr_40509_40540 = state_40500__$1;
(statearr_40509_40540[(2)] = null);

(statearr_40509_40540[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40501 === (6))){
var inst_40465 = (state_40500[(8)]);
var inst_40486 = (inst_40465 > (0));
var state_40500__$1 = state_40500;
if(cljs.core.truth_(inst_40486)){
var statearr_40510_40541 = state_40500__$1;
(statearr_40510_40541[(1)] = (12));

} else {
var statearr_40511_40542 = state_40500__$1;
(statearr_40511_40542[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40501 === (3))){
var inst_40498 = (state_40500[(2)]);
var state_40500__$1 = state_40500;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40500__$1,inst_40498);
} else {
if((state_val_40501 === (12))){
var inst_40464 = (state_40500[(7)]);
var inst_40488 = cljs.core.vec.call(null,inst_40464);
var state_40500__$1 = state_40500;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40500__$1,(15),out,inst_40488);
} else {
if((state_val_40501 === (2))){
var state_40500__$1 = state_40500;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40500__$1,(4),ch);
} else {
if((state_val_40501 === (11))){
var inst_40480 = (state_40500[(2)]);
var inst_40481 = (new Array(n));
var inst_40464 = inst_40481;
var inst_40465 = (0);
var state_40500__$1 = (function (){var statearr_40512 = state_40500;
(statearr_40512[(7)] = inst_40464);

(statearr_40512[(8)] = inst_40465);

(statearr_40512[(10)] = inst_40480);

return statearr_40512;
})();
var statearr_40513_40543 = state_40500__$1;
(statearr_40513_40543[(2)] = null);

(statearr_40513_40543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40501 === (9))){
var inst_40464 = (state_40500[(7)]);
var inst_40478 = cljs.core.vec.call(null,inst_40464);
var state_40500__$1 = state_40500;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40500__$1,(11),out,inst_40478);
} else {
if((state_val_40501 === (5))){
var inst_40473 = (state_40500[(11)]);
var inst_40464 = (state_40500[(7)]);
var inst_40465 = (state_40500[(8)]);
var inst_40468 = (state_40500[(9)]);
var inst_40472 = (inst_40464[inst_40465] = inst_40468);
var inst_40473__$1 = (inst_40465 + (1));
var inst_40474 = (inst_40473__$1 < n);
var state_40500__$1 = (function (){var statearr_40514 = state_40500;
(statearr_40514[(11)] = inst_40473__$1);

(statearr_40514[(12)] = inst_40472);

return statearr_40514;
})();
if(cljs.core.truth_(inst_40474)){
var statearr_40515_40544 = state_40500__$1;
(statearr_40515_40544[(1)] = (8));

} else {
var statearr_40516_40545 = state_40500__$1;
(statearr_40516_40545[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40501 === (14))){
var inst_40493 = (state_40500[(2)]);
var inst_40494 = cljs.core.async.close_BANG_.call(null,out);
var state_40500__$1 = (function (){var statearr_40518 = state_40500;
(statearr_40518[(13)] = inst_40493);

return statearr_40518;
})();
var statearr_40519_40546 = state_40500__$1;
(statearr_40519_40546[(2)] = inst_40494);

(statearr_40519_40546[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40501 === (10))){
var inst_40484 = (state_40500[(2)]);
var state_40500__$1 = state_40500;
var statearr_40520_40547 = state_40500__$1;
(statearr_40520_40547[(2)] = inst_40484);

(statearr_40520_40547[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40501 === (8))){
var inst_40473 = (state_40500[(11)]);
var inst_40464 = (state_40500[(7)]);
var tmp40517 = inst_40464;
var inst_40464__$1 = tmp40517;
var inst_40465 = inst_40473;
var state_40500__$1 = (function (){var statearr_40521 = state_40500;
(statearr_40521[(7)] = inst_40464__$1);

(statearr_40521[(8)] = inst_40465);

return statearr_40521;
})();
var statearr_40522_40548 = state_40500__$1;
(statearr_40522_40548[(2)] = null);

(statearr_40522_40548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___40534,out))
;
return ((function (switch__19364__auto__,c__19429__auto___40534,out){
return (function() {
var cljs$core$async$state_machine__19365__auto__ = null;
var cljs$core$async$state_machine__19365__auto____0 = (function (){
var statearr_40526 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40526[(0)] = cljs$core$async$state_machine__19365__auto__);

(statearr_40526[(1)] = (1));

return statearr_40526;
});
var cljs$core$async$state_machine__19365__auto____1 = (function (state_40500){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_40500);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e40527){if((e40527 instanceof Object)){
var ex__19368__auto__ = e40527;
var statearr_40528_40549 = state_40500;
(statearr_40528_40549[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40500);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40527;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40550 = state_40500;
state_40500 = G__40550;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$state_machine__19365__auto__ = function(state_40500){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19365__auto____1.call(this,state_40500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19365__auto____0;
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19365__auto____1;
return cljs$core$async$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___40534,out))
})();
var state__19431__auto__ = (function (){var statearr_40529 = f__19430__auto__.call(null);
(statearr_40529[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___40534);

return statearr_40529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___40534,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args40551 = [];
var len__17407__auto___40625 = arguments.length;
var i__17408__auto___40626 = (0);
while(true){
if((i__17408__auto___40626 < len__17407__auto___40625)){
args40551.push((arguments[i__17408__auto___40626]));

var G__40627 = (i__17408__auto___40626 + (1));
i__17408__auto___40626 = G__40627;
continue;
} else {
}
break;
}

var G__40553 = args40551.length;
switch (G__40553) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40551.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__19429__auto___40629 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___40629,out){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___40629,out){
return (function (state_40595){
var state_val_40596 = (state_40595[(1)]);
if((state_val_40596 === (7))){
var inst_40591 = (state_40595[(2)]);
var state_40595__$1 = state_40595;
var statearr_40597_40630 = state_40595__$1;
(statearr_40597_40630[(2)] = inst_40591);

(statearr_40597_40630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40596 === (1))){
var inst_40554 = [];
var inst_40555 = inst_40554;
var inst_40556 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_40595__$1 = (function (){var statearr_40598 = state_40595;
(statearr_40598[(7)] = inst_40556);

(statearr_40598[(8)] = inst_40555);

return statearr_40598;
})();
var statearr_40599_40631 = state_40595__$1;
(statearr_40599_40631[(2)] = null);

(statearr_40599_40631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40596 === (4))){
var inst_40559 = (state_40595[(9)]);
var inst_40559__$1 = (state_40595[(2)]);
var inst_40560 = (inst_40559__$1 == null);
var inst_40561 = cljs.core.not.call(null,inst_40560);
var state_40595__$1 = (function (){var statearr_40600 = state_40595;
(statearr_40600[(9)] = inst_40559__$1);

return statearr_40600;
})();
if(inst_40561){
var statearr_40601_40632 = state_40595__$1;
(statearr_40601_40632[(1)] = (5));

} else {
var statearr_40602_40633 = state_40595__$1;
(statearr_40602_40633[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40596 === (15))){
var inst_40585 = (state_40595[(2)]);
var state_40595__$1 = state_40595;
var statearr_40603_40634 = state_40595__$1;
(statearr_40603_40634[(2)] = inst_40585);

(statearr_40603_40634[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40596 === (13))){
var state_40595__$1 = state_40595;
var statearr_40604_40635 = state_40595__$1;
(statearr_40604_40635[(2)] = null);

(statearr_40604_40635[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40596 === (6))){
var inst_40555 = (state_40595[(8)]);
var inst_40580 = inst_40555.length;
var inst_40581 = (inst_40580 > (0));
var state_40595__$1 = state_40595;
if(cljs.core.truth_(inst_40581)){
var statearr_40605_40636 = state_40595__$1;
(statearr_40605_40636[(1)] = (12));

} else {
var statearr_40606_40637 = state_40595__$1;
(statearr_40606_40637[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40596 === (3))){
var inst_40593 = (state_40595[(2)]);
var state_40595__$1 = state_40595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40595__$1,inst_40593);
} else {
if((state_val_40596 === (12))){
var inst_40555 = (state_40595[(8)]);
var inst_40583 = cljs.core.vec.call(null,inst_40555);
var state_40595__$1 = state_40595;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40595__$1,(15),out,inst_40583);
} else {
if((state_val_40596 === (2))){
var state_40595__$1 = state_40595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40595__$1,(4),ch);
} else {
if((state_val_40596 === (11))){
var inst_40559 = (state_40595[(9)]);
var inst_40563 = (state_40595[(10)]);
var inst_40573 = (state_40595[(2)]);
var inst_40574 = [];
var inst_40575 = inst_40574.push(inst_40559);
var inst_40555 = inst_40574;
var inst_40556 = inst_40563;
var state_40595__$1 = (function (){var statearr_40607 = state_40595;
(statearr_40607[(7)] = inst_40556);

(statearr_40607[(11)] = inst_40573);

(statearr_40607[(8)] = inst_40555);

(statearr_40607[(12)] = inst_40575);

return statearr_40607;
})();
var statearr_40608_40638 = state_40595__$1;
(statearr_40608_40638[(2)] = null);

(statearr_40608_40638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40596 === (9))){
var inst_40555 = (state_40595[(8)]);
var inst_40571 = cljs.core.vec.call(null,inst_40555);
var state_40595__$1 = state_40595;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40595__$1,(11),out,inst_40571);
} else {
if((state_val_40596 === (5))){
var inst_40556 = (state_40595[(7)]);
var inst_40559 = (state_40595[(9)]);
var inst_40563 = (state_40595[(10)]);
var inst_40563__$1 = f.call(null,inst_40559);
var inst_40564 = cljs.core._EQ_.call(null,inst_40563__$1,inst_40556);
var inst_40565 = cljs.core.keyword_identical_QMARK_.call(null,inst_40556,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_40566 = (inst_40564) || (inst_40565);
var state_40595__$1 = (function (){var statearr_40609 = state_40595;
(statearr_40609[(10)] = inst_40563__$1);

return statearr_40609;
})();
if(cljs.core.truth_(inst_40566)){
var statearr_40610_40639 = state_40595__$1;
(statearr_40610_40639[(1)] = (8));

} else {
var statearr_40611_40640 = state_40595__$1;
(statearr_40611_40640[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40596 === (14))){
var inst_40588 = (state_40595[(2)]);
var inst_40589 = cljs.core.async.close_BANG_.call(null,out);
var state_40595__$1 = (function (){var statearr_40613 = state_40595;
(statearr_40613[(13)] = inst_40588);

return statearr_40613;
})();
var statearr_40614_40641 = state_40595__$1;
(statearr_40614_40641[(2)] = inst_40589);

(statearr_40614_40641[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40596 === (10))){
var inst_40578 = (state_40595[(2)]);
var state_40595__$1 = state_40595;
var statearr_40615_40642 = state_40595__$1;
(statearr_40615_40642[(2)] = inst_40578);

(statearr_40615_40642[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40596 === (8))){
var inst_40559 = (state_40595[(9)]);
var inst_40555 = (state_40595[(8)]);
var inst_40563 = (state_40595[(10)]);
var inst_40568 = inst_40555.push(inst_40559);
var tmp40612 = inst_40555;
var inst_40555__$1 = tmp40612;
var inst_40556 = inst_40563;
var state_40595__$1 = (function (){var statearr_40616 = state_40595;
(statearr_40616[(7)] = inst_40556);

(statearr_40616[(8)] = inst_40555__$1);

(statearr_40616[(14)] = inst_40568);

return statearr_40616;
})();
var statearr_40617_40643 = state_40595__$1;
(statearr_40617_40643[(2)] = null);

(statearr_40617_40643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___40629,out))
;
return ((function (switch__19364__auto__,c__19429__auto___40629,out){
return (function() {
var cljs$core$async$state_machine__19365__auto__ = null;
var cljs$core$async$state_machine__19365__auto____0 = (function (){
var statearr_40621 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40621[(0)] = cljs$core$async$state_machine__19365__auto__);

(statearr_40621[(1)] = (1));

return statearr_40621;
});
var cljs$core$async$state_machine__19365__auto____1 = (function (state_40595){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_40595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e40622){if((e40622 instanceof Object)){
var ex__19368__auto__ = e40622;
var statearr_40623_40644 = state_40595;
(statearr_40623_40644[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40595);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40622;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40645 = state_40595;
state_40595 = G__40645;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
cljs$core$async$state_machine__19365__auto__ = function(state_40595){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19365__auto____1.call(this,state_40595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19365__auto____0;
cljs$core$async$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19365__auto____1;
return cljs$core$async$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___40629,out))
})();
var state__19431__auto__ = (function (){var statearr_40624 = f__19430__auto__.call(null);
(statearr_40624[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___40629);

return statearr_40624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___40629,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1449783513134