// Compiled by ClojureScript 1.7.122 {}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('com.cognitect.transit');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit.eq');
goog.require('goog.math.Long');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = true;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
cljs.core.UUID.prototype.cljs$core$IComparable$ = true;

cljs.core.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});
goog.math.Long.prototype.cljs$core$IEquiv$ = true;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv.call(null,other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
goog.math.Long.prototype.cljs$core$IHash$ = true;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});
com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (uuid,writer,_){
var uuid__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#uuid \""),cljs.core.str(uuid__$1.toString()),cljs.core.str("\"")].join(''));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__32917_32921 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,b));
var chunk__32918_32922 = null;
var count__32919_32923 = (0);
var i__32920_32924 = (0);
while(true){
if((i__32920_32924 < count__32919_32923)){
var k_32925 = cljs.core._nth.call(null,chunk__32918_32922,i__32920_32924);
var v_32926 = (b[k_32925]);
(a[k_32925] = v_32926);

var G__32927 = seq__32917_32921;
var G__32928 = chunk__32918_32922;
var G__32929 = count__32919_32923;
var G__32930 = (i__32920_32924 + (1));
seq__32917_32921 = G__32927;
chunk__32918_32922 = G__32928;
count__32919_32923 = G__32929;
i__32920_32924 = G__32930;
continue;
} else {
var temp__4425__auto___32931 = cljs.core.seq.call(null,seq__32917_32921);
if(temp__4425__auto___32931){
var seq__32917_32932__$1 = temp__4425__auto___32931;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32917_32932__$1)){
var c__17152__auto___32933 = cljs.core.chunk_first.call(null,seq__32917_32932__$1);
var G__32934 = cljs.core.chunk_rest.call(null,seq__32917_32932__$1);
var G__32935 = c__17152__auto___32933;
var G__32936 = cljs.core.count.call(null,c__17152__auto___32933);
var G__32937 = (0);
seq__32917_32921 = G__32934;
chunk__32918_32922 = G__32935;
count__32919_32923 = G__32936;
i__32920_32924 = G__32937;
continue;
} else {
var k_32938 = cljs.core.first.call(null,seq__32917_32932__$1);
var v_32939 = (b[k_32938]);
(a[k_32938] = v_32939);

var G__32940 = cljs.core.next.call(null,seq__32917_32932__$1);
var G__32941 = null;
var G__32942 = (0);
var G__32943 = (0);
seq__32917_32921 = G__32940;
chunk__32918_32922 = G__32941;
count__32919_32923 = G__32942;
i__32920_32924 = G__32943;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.call(null,m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentArrayMap.fromArray.call(null,arr,true,true);
});

cognitect.transit.MapBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.call(null,v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentVector.fromArray.call(null,arr,true);
});

cognitect.transit.VectorBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(var_args){
var args32944 = [];
var len__17407__auto___32947 = arguments.length;
var i__17408__auto___32948 = (0);
while(true){
if((i__17408__auto___32948 < len__17407__auto___32947)){
args32944.push((arguments[i__17408__auto___32948]));

var G__32949 = (i__17408__auto___32948 + (1));
i__17408__auto___32948 = G__32949;
continue;
} else {
}
break;
}

var G__32946 = args32944.length;
switch (G__32946) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32944.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.call(null,type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
return com.cognitect.transit.reader.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"handlers": cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, ["$",(function (v){
return cljs.core.symbol.call(null,v);
}),":",(function (v){
return cljs.core.keyword.call(null,v);
}),"set",(function (v){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,v);
}),"list",(function (v){
return cljs.core.into.call(null,cljs.core.List.EMPTY,v.reverse());
}),"cmap",(function (v){
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__32951 = (i + (2));
var G__32952 = cljs.core.assoc_BANG_.call(null,ret,(v[i]),(v[(i + (1))]));
i = G__32951;
ret = G__32952;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,ret);
}
break;
}
})], null),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts))), "mapBuilder": (new cognitect.transit.MapBuilder()), "arrayBuilder": (new cognitect.transit.VectorBuilder()), "prefersStrings": false},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;
/**
 * Read a transit encoded string into ClojureScript values given a 
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__32953_32957 = cljs.core.seq.call(null,v);
var chunk__32954_32958 = null;
var count__32955_32959 = (0);
var i__32956_32960 = (0);
while(true){
if((i__32956_32960 < count__32955_32959)){
var x_32961 = cljs.core._nth.call(null,chunk__32954_32958,i__32956_32960);
ret.push(x_32961);

var G__32962 = seq__32953_32957;
var G__32963 = chunk__32954_32958;
var G__32964 = count__32955_32959;
var G__32965 = (i__32956_32960 + (1));
seq__32953_32957 = G__32962;
chunk__32954_32958 = G__32963;
count__32955_32959 = G__32964;
i__32956_32960 = G__32965;
continue;
} else {
var temp__4425__auto___32966 = cljs.core.seq.call(null,seq__32953_32957);
if(temp__4425__auto___32966){
var seq__32953_32967__$1 = temp__4425__auto___32966;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32953_32967__$1)){
var c__17152__auto___32968 = cljs.core.chunk_first.call(null,seq__32953_32967__$1);
var G__32969 = cljs.core.chunk_rest.call(null,seq__32953_32967__$1);
var G__32970 = c__17152__auto___32968;
var G__32971 = cljs.core.count.call(null,c__17152__auto___32968);
var G__32972 = (0);
seq__32953_32957 = G__32969;
chunk__32954_32958 = G__32970;
count__32955_32959 = G__32971;
i__32956_32960 = G__32972;
continue;
} else {
var x_32973 = cljs.core.first.call(null,seq__32953_32967__$1);
ret.push(x_32973);

var G__32974 = cljs.core.next.call(null,seq__32953_32967__$1);
var G__32975 = null;
var G__32976 = (0);
var G__32977 = (0);
seq__32953_32957 = G__32974;
chunk__32954_32958 = G__32975;
count__32955_32959 = G__32976;
i__32956_32960 = G__32977;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__32978_32982 = cljs.core.seq.call(null,v);
var chunk__32979_32983 = null;
var count__32980_32984 = (0);
var i__32981_32985 = (0);
while(true){
if((i__32981_32985 < count__32980_32984)){
var x_32986 = cljs.core._nth.call(null,chunk__32979_32983,i__32981_32985);
ret.push(x_32986);

var G__32987 = seq__32978_32982;
var G__32988 = chunk__32979_32983;
var G__32989 = count__32980_32984;
var G__32990 = (i__32981_32985 + (1));
seq__32978_32982 = G__32987;
chunk__32979_32983 = G__32988;
count__32980_32984 = G__32989;
i__32981_32985 = G__32990;
continue;
} else {
var temp__4425__auto___32991 = cljs.core.seq.call(null,seq__32978_32982);
if(temp__4425__auto___32991){
var seq__32978_32992__$1 = temp__4425__auto___32991;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32978_32992__$1)){
var c__17152__auto___32993 = cljs.core.chunk_first.call(null,seq__32978_32992__$1);
var G__32994 = cljs.core.chunk_rest.call(null,seq__32978_32992__$1);
var G__32995 = c__17152__auto___32993;
var G__32996 = cljs.core.count.call(null,c__17152__auto___32993);
var G__32997 = (0);
seq__32978_32982 = G__32994;
chunk__32979_32983 = G__32995;
count__32980_32984 = G__32996;
i__32981_32985 = G__32997;
continue;
} else {
var x_32998 = cljs.core.first.call(null,seq__32978_32992__$1);
ret.push(x_32998);

var G__32999 = cljs.core.next.call(null,seq__32978_32992__$1);
var G__33000 = null;
var G__33001 = (0);
var G__33002 = (0);
seq__32978_32982 = G__32999;
chunk__32979_32983 = G__33000;
count__32980_32984 = G__33001;
i__32981_32985 = G__33002;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__33003_33007 = cljs.core.seq.call(null,v);
var chunk__33004_33008 = null;
var count__33005_33009 = (0);
var i__33006_33010 = (0);
while(true){
if((i__33006_33010 < count__33005_33009)){
var x_33011 = cljs.core._nth.call(null,chunk__33004_33008,i__33006_33010);
ret.push(x_33011);

var G__33012 = seq__33003_33007;
var G__33013 = chunk__33004_33008;
var G__33014 = count__33005_33009;
var G__33015 = (i__33006_33010 + (1));
seq__33003_33007 = G__33012;
chunk__33004_33008 = G__33013;
count__33005_33009 = G__33014;
i__33006_33010 = G__33015;
continue;
} else {
var temp__4425__auto___33016 = cljs.core.seq.call(null,seq__33003_33007);
if(temp__4425__auto___33016){
var seq__33003_33017__$1 = temp__4425__auto___33016;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33003_33017__$1)){
var c__17152__auto___33018 = cljs.core.chunk_first.call(null,seq__33003_33017__$1);
var G__33019 = cljs.core.chunk_rest.call(null,seq__33003_33017__$1);
var G__33020 = c__17152__auto___33018;
var G__33021 = cljs.core.count.call(null,c__17152__auto___33018);
var G__33022 = (0);
seq__33003_33007 = G__33019;
chunk__33004_33008 = G__33020;
count__33005_33009 = G__33021;
i__33006_33010 = G__33022;
continue;
} else {
var x_33023 = cljs.core.first.call(null,seq__33003_33017__$1);
ret.push(x_33023);

var G__33024 = cljs.core.next.call(null,seq__33003_33017__$1);
var G__33025 = null;
var G__33026 = (0);
var G__33027 = (0);
seq__33003_33007 = G__33024;
chunk__33004_33008 = G__33025;
count__33005_33009 = G__33026;
i__33006_33010 = G__33027;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 *   opts is a map containing a :handlers entry. :handlers is a map of
 *   type constructors to handler instances.
 */
cognitect.transit.writer = (function cognitect$transit$writer(var_args){
var args33028 = [];
var len__17407__auto___33039 = arguments.length;
var i__17408__auto___33040 = (0);
while(true){
if((i__17408__auto___33040 < len__17407__auto___33039)){
args33028.push((arguments[i__17408__auto___33040]));

var G__33041 = (i__17408__auto___33040 + (1));
i__17408__auto___33040 = G__33041;
continue;
} else {
}
break;
}

var G__33030 = args33028.length;
switch (G__33030) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33028.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.call(null,type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts));
return com.cognitect.transit.writer.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"objectBuilder": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv.call(null,((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__33031 = obj;
G__33031.push(kfn.call(null,k),vfn.call(null,v));

return G__33031;
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x33032 = cljs.core.clone.call(null,handlers);
x33032.forEach = ((function (x33032,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__33033 = cljs.core.seq.call(null,coll);
var chunk__33034 = null;
var count__33035 = (0);
var i__33036 = (0);
while(true){
if((i__33036 < count__33035)){
var vec__33037 = cljs.core._nth.call(null,chunk__33034,i__33036);
var k = cljs.core.nth.call(null,vec__33037,(0),null);
var v = cljs.core.nth.call(null,vec__33037,(1),null);
f.call(null,v,k);

var G__33043 = seq__33033;
var G__33044 = chunk__33034;
var G__33045 = count__33035;
var G__33046 = (i__33036 + (1));
seq__33033 = G__33043;
chunk__33034 = G__33044;
count__33035 = G__33045;
i__33036 = G__33046;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__33033);
if(temp__4425__auto__){
var seq__33033__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33033__$1)){
var c__17152__auto__ = cljs.core.chunk_first.call(null,seq__33033__$1);
var G__33047 = cljs.core.chunk_rest.call(null,seq__33033__$1);
var G__33048 = c__17152__auto__;
var G__33049 = cljs.core.count.call(null,c__17152__auto__);
var G__33050 = (0);
seq__33033 = G__33047;
chunk__33034 = G__33048;
count__33035 = G__33049;
i__33036 = G__33050;
continue;
} else {
var vec__33038 = cljs.core.first.call(null,seq__33033__$1);
var k = cljs.core.nth.call(null,vec__33038,(0),null);
var v = cljs.core.nth.call(null,vec__33038,(1),null);
f.call(null,v,k);

var G__33051 = cljs.core.next.call(null,seq__33033__$1);
var G__33052 = null;
var G__33053 = (0);
var G__33054 = (0);
seq__33033 = G__33051;
chunk__33034 = G__33052;
count__33035 = G__33053;
i__33036 = G__33054;
continue;
}
} else {
return null;
}
}
break;
}
});})(x33032,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x33032;
})(), "unpack": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;
/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(var_args){
var args33055 = [];
var len__17407__auto___33061 = arguments.length;
var i__17408__auto___33062 = (0);
while(true){
if((i__17408__auto___33062 < len__17407__auto___33061)){
args33055.push((arguments[i__17408__auto___33062]));

var G__33063 = (i__17408__auto___33062 + (1));
i__17408__auto___33062 = G__33063;
continue;
} else {
}
break;
}

var G__33057 = args33055.length;
switch (G__33057) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33055.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t_cognitect$transit33058 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cognitect.transit.Object}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cognitect.transit.t_cognitect$transit33058 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,meta33059){
this.tag_fn = tag_fn;
this.rep_fn = rep_fn;
this.str_rep_fn = str_rep_fn;
this.verbose_handler_fn = verbose_handler_fn;
this.meta33059 = meta33059;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cognitect.transit.t_cognitect$transit33058.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33060,meta33059__$1){
var self__ = this;
var _33060__$1 = this;
return (new cognitect.transit.t_cognitect$transit33058(self__.tag_fn,self__.rep_fn,self__.str_rep_fn,self__.verbose_handler_fn,meta33059__$1));
});

cognitect.transit.t_cognitect$transit33058.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33060){
var self__ = this;
var _33060__$1 = this;
return self__.meta33059;
});

cognitect.transit.t_cognitect$transit33058.prototype.tag = (function (o){
var self__ = this;
var _ = this;
return self__.tag_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit33058.prototype.rep = (function (o){
var self__ = this;
var _ = this;
return self__.rep_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit33058.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
return self__.str_rep_fn.call(null,o);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit33058.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return self__.verbose_handler_fn.call(null);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit33058.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tag-fn","tag-fn",242055482,null),new cljs.core.Symbol(null,"rep-fn","rep-fn",-1724891035,null),new cljs.core.Symbol(null,"str-rep-fn","str-rep-fn",-1179615016,null),new cljs.core.Symbol(null,"verbose-handler-fn","verbose-handler-fn",547340594,null),new cljs.core.Symbol(null,"meta33059","meta33059",1127831929,null)], null);
});

cognitect.transit.t_cognitect$transit33058.cljs$lang$type = true;

cognitect.transit.t_cognitect$transit33058.cljs$lang$ctorStr = "cognitect.transit/t_cognitect$transit33058";

cognitect.transit.t_cognitect$transit33058.cljs$lang$ctorPrWriter = (function (this__16947__auto__,writer__16948__auto__,opt__16949__auto__){
return cljs.core._write.call(null,writer__16948__auto__,"cognitect.transit/t_cognitect$transit33058");
});

cognitect.transit.__GT_t_cognitect$transit33058 = (function cognitect$transit$__GT_t_cognitect$transit33058(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta33059){
return (new cognitect.transit.t_cognitect$transit33058(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta33059));
});

}

return (new cognitect.transit.t_cognitect$transit33058(tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;
/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
return com.cognitect.transit.types.taggedValue.call(null,tag,rep);
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
return com.cognitect.transit.types.isTaggedValue.call(null,x);
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 *   in the 53bit integer range, a goog.math.Long instance if above. s
 *   may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
return com.cognitect.transit.types.intValue.call(null,s);
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 *   range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
return com.cognitect.transit.types.isInteger.call(null,x);
});
/**
 * Construct a big integer from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
return com.cognitect.transit.types.bigInteger.call(null,s);
});
/**
 * Returns true if x is a transit big integer value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
return com.cognitect.transit.types.isBigInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
return com.cognitect.transit.types.bigDecimalValue.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
return com.cognitect.transit.types.isBigDecimal.call(null,x);
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
return com.cognitect.transit.types.uri.call(null,s);
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
return com.cognitect.transit.types.isURI.call(null,x);
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
return com.cognitect.transit.types.uuid.call(null,s);
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var or__16349__auto__ = com.cognitect.transit.types.isUUID.call(null,x);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return (x instanceof cljs.core.UUID);
}
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
return com.cognitect.transit.types.binary.call(null,s);
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
return com.cognitect.transit.types.isBinary.call(null,x);
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
return com.cognitect.transit.types.quoted.call(null,x);
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
return com.cognitect.transit.types.isQuoted.call(null,x);
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
return com.cognitect.transit.types.link.call(null,x);
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
return com.cognitect.transit.types.isLink.call(null,x);
});

//# sourceMappingURL=transit.js.map?rel=1449783499107