// Compiled by ClojureScript 1.7.122 {}
goog.provide('plumbing.fnk.schema');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('schema.utils');
plumbing.fnk.schema.Schema = cljs.core.with_meta.call(null,schema.core.__GT_Protocol.call(null,schema.core.Schema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("s","Schema","s/Schema",-1305723789,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__27380__27381__auto__){
if(!((p1__27380__27381__auto__ == null))){
if((false) || (p1__27380__27381__auto__.schema$core$Schema$)){
return true;
} else {
if((!p1__27380__27381__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,p1__27380__27381__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,p1__27380__27381__auto__);
}
})], null));
plumbing.fnk.schema.InputSchema = cljs.core.PersistentArrayMap.fromArray([schema.core.either.call(null,schema.core.eq.call(null,schema.core.Keyword),schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.OutputSchema = plumbing.fnk.schema.Schema;
plumbing.fnk.schema.IOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.OutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
plumbing.fnk.schema.GraphInputSchema = cljs.core.PersistentArrayMap.fromArray([schema.core.either.call(null,schema.core.OptionalKey,schema.core.Keyword),plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.MapOutputSchema = cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,plumbing.fnk.schema.Schema], true, false);
plumbing.fnk.schema.GraphIOSchemata = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphInputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null);
/**
 * Like (assert (distinct? things)) but with a more helpful error message.
 */
plumbing.fnk.schema.assert_distinct = (function plumbing$fnk$schema$assert_distinct(things){
var repeated_things = cljs.core.seq.call(null,cljs.core.filter.call(null,(function (p1__36377_SHARP_){
return (cljs.core.val.call(null,p1__36377_SHARP_) > (1));
}),cljs.core.frequencies.call(null,things)));
if(cljs.core.empty_QMARK_.call(null,repeated_things)){
return null;
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Got repeated items (expected distinct): %s",repeated_things)));
}
});
/**
 * Like (get m k), but throws if k is not present in m.
 */
plumbing.fnk.schema.safe_get = (function plumbing$fnk$schema$safe_get(m,k,key_path){
if(cljs.core.map_QMARK_.call(null,m)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Expected a map at key-path %s, got type %s",key_path,schema.utils.type_of.call(null,m))));
}

var vec__36379 = cljs.core.find.call(null,m,k);
var _ = cljs.core.nth.call(null,vec__36379,(0),null);
var v = cljs.core.nth.call(null,vec__36379,(1),null);
var p = vec__36379;
if(cljs.core.truth_(p)){
} else {
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.keys.call(null,m)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"missing-key","missing-key",1259209562),new cljs.core.Keyword(null,"key","key",-1516042587),k,new cljs.core.Keyword(null,"map","map",1371690461),m], null));
}

return v;
});
plumbing.fnk.schema.non_map_union = (function plumbing$fnk$schema$non_map_union(s1,s2){
if(cljs.core._EQ_.call(null,s1,s2)){
return s1;
} else {
if(cljs.core._EQ_.call(null,s1,schema.core.Any)){
return s2;
} else {
if(cljs.core._EQ_.call(null,s2,schema.core.Any)){
return s1;
} else {
return schema.core.both.call(null,s1,s2);

}
}
}
});
/**
 * Return a difference of schmas s1 and s2, where one is not a map.
 * Punt for now, assuming s2 always satisfies s1.
 */
plumbing.fnk.schema.non_map_diff = (function plumbing$fnk$schema$non_map_diff(s1,s2){
return null;
});
plumbing.fnk.schema.map_schema_QMARK_ = (function plumbing$fnk$schema$map_schema_QMARK_(m){
return ((m instanceof cljs.core.PersistentArrayMap)) || ((m instanceof cljs.core.PersistentHashMap));
});
var ufv___36385 = schema.utils.use_fn_validation;
var output_schema36380_36386 = schema.core.maybe.call(null,schema.core.pair.call(null,schema.core.Keyword,"k",schema.core.Bool,"optional?"));
var input_schema36381_36387 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker36382_36388 = schema.core.checker.call(null,input_schema36381_36387);
var output_checker36383_36389 = schema.core.checker.call(null,output_schema36380_36386);
/**
 * Inputs: [k]
 *   Returns: (s/maybe (s/pair s/Keyword "k" s/Bool "optional?"))
 * 
 *   Given a possibly-unevaluated schema map key form, unpack an explicit keyword
 * and optional? flag, or return nil for a non-explicit key
 */
plumbing.fnk.schema.unwrap_schema_form_key = ((function (ufv___36385,output_schema36380_36386,input_schema36381_36387,input_checker36382_36388,output_checker36383_36389){
return (function plumbing$fnk$schema$unwrap_schema_form_key(G__36384){
var validate__26972__auto__ = ufv___36385.get_cell();
if(cljs.core.truth_(validate__26972__auto__)){
var args__26973__auto___36390 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36384], null);
var temp__4425__auto___36391 = input_checker36382_36388.call(null,args__26973__auto___36390);
if(cljs.core.truth_(temp__4425__auto___36391)){
var error__26974__auto___36392 = temp__4425__auto___36391;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),cljs.core.list(new cljs.core.Symbol("s","pair","s/pair",1193014306,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),"k",new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),"optional?")),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated schema map key form, unpack an explicit keyword\n   and optional? flag, or return nil for a non-explicit key"], null)),cljs.core.pr_str.call(null,error__26974__auto___36392)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36381_36387,new cljs.core.Keyword(null,"value","value",305978217),args__26973__auto___36390,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36392], null));
} else {
}
} else {
}

var o__26975__auto__ = (function (){var k = G__36384;
while(true){
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explicit_schema_key.call(null,k),schema.core.required_key_QMARK_.call(null,k)], null);
} else {
if((cljs.core.sequential_QMARK_.call(null,k)) && (!(cljs.core.vector_QMARK_.call(null,k))) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,k),(2))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,k),new cljs.core.Symbol("schema.core","optional-key","schema.core/optional-key",-170069547,null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,k),false], null);
} else {
return null;
}
}
break;
}
})();
if(cljs.core.truth_(validate__26972__auto__)){
var temp__4425__auto___36393 = output_checker36383_36389.call(null,o__26975__auto__);
if(cljs.core.truth_(temp__4425__auto___36393)){
var error__26974__auto___36394 = temp__4425__auto___36393;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"unwrap-schema-form-key","unwrap-schema-form-key",-300088791,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),cljs.core.list(new cljs.core.Symbol("s","pair","s/pair",1193014306,null),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),"k",new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),"optional?")),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated schema map key form, unpack an explicit keyword\n   and optional? flag, or return nil for a non-explicit key"], null)),cljs.core.pr_str.call(null,error__26974__auto___36394)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36380_36386,new cljs.core.Keyword(null,"value","value",305978217),o__26975__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36394], null));
} else {
}
} else {
}

return o__26975__auto__;
});})(ufv___36385,output_schema36380_36386,input_schema36381_36387,input_checker36382_36388,output_checker36383_36389))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.unwrap_schema_form_key),schema.core.make_fn_schema.call(null,output_schema36380_36386,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36381_36387], null)));
var ufv___36400 = schema.utils.use_fn_validation;
var output_schema36395_36401 = cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Bool], true, false);
var input_schema36396_36402 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker36397_36403 = schema.core.checker.call(null,input_schema36396_36402);
var output_checker36398_36404 = schema.core.checker.call(null,output_schema36395_36401);
/**
 * Inputs: [s]
 *   Returns: {s/Keyword s/Bool}
 * 
 *   Given a possibly-unevaluated map schema, return a map from bare keyword to true
 * (for required) or false (for optional)
 */
plumbing.fnk.schema.explicit_schema_key_map = ((function (ufv___36400,output_schema36395_36401,input_schema36396_36402,input_checker36397_36403,output_checker36398_36404){
return (function plumbing$fnk$schema$explicit_schema_key_map(G__36399){
var validate__26972__auto__ = ufv___36400.get_cell();
if(cljs.core.truth_(validate__26972__auto__)){
var args__26973__auto___36405 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36399], null);
var temp__4425__auto___36406 = input_checker36397_36403.call(null,args__26973__auto___36405);
if(cljs.core.truth_(temp__4425__auto___36406)){
var error__26974__auto___36407 = temp__4425__auto___36406;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated map schema, return a map from bare keyword to true\n   (for required) or false (for optional)"], null)),cljs.core.pr_str.call(null,error__26974__auto___36407)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36396_36402,new cljs.core.Keyword(null,"value","value",305978217),args__26973__auto___36405,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36407], null));
} else {
}
} else {
}

var o__26975__auto__ = (function (){var s = G__36399;
while(true){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.keep.call(null,plumbing.fnk.schema.unwrap_schema_form_key,cljs.core.keys.call(null,s)));
break;
}
})();
if(cljs.core.truth_(validate__26972__auto__)){
var temp__4425__auto___36408 = output_checker36398_36404.call(null,o__26975__auto__);
if(cljs.core.truth_(temp__4425__auto___36408)){
var error__26974__auto___36409 = temp__4425__auto___36408;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"explicit-schema-key-map","explicit-schema-key-map",1668953963,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a possibly-unevaluated map schema, return a map from bare keyword to true\n   (for required) or false (for optional)"], null)),cljs.core.pr_str.call(null,error__26974__auto___36409)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36395_36401,new cljs.core.Keyword(null,"value","value",305978217),o__26975__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36409], null));
} else {
}
} else {
}

return o__26975__auto__;
});})(ufv___36400,output_schema36395_36401,input_schema36396_36402,input_checker36397_36403,output_checker36398_36404))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.explicit_schema_key_map),schema.core.make_fn_schema.call(null,output_schema36395_36401,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36396_36402], null)));
var ufv___36415 = schema.utils.use_fn_validation;
var output_schema36410_36416 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"required","required",-846788763,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),new cljs.core.Symbol(null,"optional","optional",-600484260,null))], null);
var input_schema36411_36417 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,cljs.core.PersistentArrayMap.fromArray([schema.core.Keyword,schema.core.Bool], true, false),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null)], null)], null)))], null);
var input_checker36412_36418 = schema.core.checker.call(null,input_schema36411_36417);
var output_checker36413_36419 = schema.core.checker.call(null,output_schema36410_36416);
/**
 * Inputs: [s :- {s/Keyword s/Bool}]
 *   Returns: [(s/one [s/Keyword] (quote required)) (s/one [s/Keyword] (quote optional))]
 * 
 *   Given output of explicit-schema-key-map, split into seq [req opt].
 */
plumbing.fnk.schema.split_schema_keys = ((function (ufv___36415,output_schema36410_36416,input_schema36411_36417,input_checker36412_36418,output_checker36413_36419){
return (function plumbing$fnk$schema$split_schema_keys(G__36414){
var validate__26972__auto__ = ufv___36415.get_cell();
if(cljs.core.truth_(validate__26972__auto__)){
var args__26973__auto___36420 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36414], null);
var temp__4425__auto___36421 = input_checker36412_36418.call(null,args__26973__auto___36420);
if(cljs.core.truth_(temp__4425__auto___36421)){
var error__26974__auto___36422 = temp__4425__auto___36421;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"required","required",-846788763,null))),cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"optional","optional",-600484260,null)))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given output of explicit-schema-key-map, split into seq [req opt]."], null)),cljs.core.pr_str.call(null,error__26974__auto___36422)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36411_36417,new cljs.core.Keyword(null,"value","value",305978217),args__26973__auto___36420,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36422], null));
} else {
}
} else {
}

var o__26975__auto__ = (function (){var s = G__36414;
while(true){
return cljs.core.mapv.call(null,cljs.core.partial.call(null,cljs.core.mapv,cljs.core.key),cljs.core.juxt.call(null,cljs.core.filter,cljs.core.remove).call(null,cljs.core.val,s));
break;
}
})();
if(cljs.core.truth_(validate__26972__auto__)){
var temp__4425__auto___36423 = output_checker36413_36419.call(null,o__26975__auto__);
if(cljs.core.truth_(temp__4425__auto___36423)){
var error__26974__auto___36424 = temp__4425__auto___36423;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema-keys","split-schema-keys",933671594,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"required","required",-846788763,null))),cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),new cljs.core.Symbol(null,"optional","optional",-600484260,null)))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given output of explicit-schema-key-map, split into seq [req opt]."], null)),cljs.core.pr_str.call(null,error__26974__auto___36424)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36410_36416,new cljs.core.Keyword(null,"value","value",305978217),o__26975__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36424], null));
} else {
}
} else {
}

return o__26975__auto__;
});})(ufv___36415,output_schema36410_36416,input_schema36411_36417,input_checker36412_36418,output_checker36413_36419))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema_keys),schema.core.make_fn_schema.call(null,output_schema36410_36416,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36411_36417], null)));
/**
 * Like merge-with, but also projects keys to a smaller space and merges them similar to the
 * values.
 */
plumbing.fnk.schema.merge_on_with = (function plumbing$fnk$schema$merge_on_with(var_args){
var args__17414__auto__ = [];
var len__17407__auto___36432 = arguments.length;
var i__17408__auto___36433 = (0);
while(true){
if((i__17408__auto___36433 < len__17407__auto___36432)){
args__17414__auto__.push((arguments[i__17408__auto___36433]));

var G__36434 = (i__17408__auto___36433 + (1));
i__17408__auto___36433 = G__36434;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((3) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((3)),(0))):null);
return plumbing.fnk.schema.merge_on_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__17415__auto__);
});

plumbing.fnk.schema.merge_on_with.cljs$core$IFn$_invoke$arity$variadic = (function (key_project,key_combine,val_combine,maps){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (m,p__36429){
var vec__36430 = p__36429;
var k = cljs.core.nth.call(null,vec__36430,(0),null);
var v = cljs.core.nth.call(null,vec__36430,(1),null);
var pk = key_project.call(null,k);
var temp__4423__auto__ = cljs.core.get.call(null,m,pk);
if(cljs.core.truth_(temp__4423__auto__)){
var vec__36431 = temp__4423__auto__;
var ok = cljs.core.nth.call(null,vec__36431,(0),null);
var ov = cljs.core.nth.call(null,vec__36431,(1),null);
return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_combine.call(null,ok,k),val_combine.call(null,ov,v)], null));
} else {
return cljs.core.assoc.call(null,m,pk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
}
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.apply.call(null,cljs.core.concat,maps))));
});

plumbing.fnk.schema.merge_on_with.cljs$lang$maxFixedArity = (3);

plumbing.fnk.schema.merge_on_with.cljs$lang$applyTo = (function (seq36425){
var G__36426 = cljs.core.first.call(null,seq36425);
var seq36425__$1 = cljs.core.next.call(null,seq36425);
var G__36427 = cljs.core.first.call(null,seq36425__$1);
var seq36425__$2 = cljs.core.next.call(null,seq36425__$1);
var G__36428 = cljs.core.first.call(null,seq36425__$2);
var seq36425__$3 = cljs.core.next.call(null,seq36425__$2);
return plumbing.fnk.schema.merge_on_with.cljs$core$IFn$_invoke$arity$variadic(G__36426,G__36427,G__36428,seq36425__$3);
});
var ufv___36442 = schema.utils.use_fn_validation;
var output_schema36436_36443 = plumbing.fnk.schema.InputSchema;
var input_schema36437_36444 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"i1","i1",-572470430,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null))),schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"i2","i2",850408895,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null)))], null);
var input_checker36438_36445 = schema.core.checker.call(null,input_schema36437_36444);
var output_checker36439_36446 = schema.core.checker.call(null,output_schema36436_36443);
/**
 * Inputs: [i1 :- InputSchema i2 :- InputSchema]
 *   Returns: InputSchema
 * 
 *   Returns a minimal input schema schema that entails satisfaction of both s1 and s2
 */
plumbing.fnk.schema.union_input_schemata = ((function (ufv___36442,output_schema36436_36443,input_schema36437_36444,input_checker36438_36445,output_checker36439_36446){
return (function plumbing$fnk$schema$union_input_schemata(G__36440,G__36441){
var validate__26972__auto__ = ufv___36442.get_cell();
if(cljs.core.truth_(validate__26972__auto__)){
var args__26973__auto___36447 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36440,G__36441], null);
var temp__4425__auto___36448 = input_checker36438_36445.call(null,args__26973__auto___36447);
if(cljs.core.truth_(temp__4425__auto___36448)){
var error__26974__auto___36449 = temp__4425__auto___36448;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a minimal input schema schema that entails satisfaction of both s1 and s2"], null)),cljs.core.pr_str.call(null,error__26974__auto___36449)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36437_36444,new cljs.core.Keyword(null,"value","value",305978217),args__26973__auto___36447,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36449], null));
} else {
}
} else {
}

var o__26975__auto__ = (function (){var i1 = G__36440;
var i2 = G__36441;
while(true){
return plumbing.fnk.schema.merge_on_with.call(null,((function (validate__26972__auto__,ufv___36442,output_schema36436_36443,input_schema36437_36444,input_checker36438_36445,output_checker36439_36446){
return (function (p1__36435_SHARP_){
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,p1__36435_SHARP_))){
return schema.core.explicit_schema_key.call(null,p1__36435_SHARP_);
} else {
return new cljs.core.Keyword(null,"extra","extra",1612569067);
}
});})(validate__26972__auto__,ufv___36442,output_schema36436_36443,input_schema36437_36444,input_checker36438_36445,output_checker36439_36446))
,((function (validate__26972__auto__,ufv___36442,output_schema36436_36443,input_schema36437_36444,input_checker36438_36445,output_checker36439_36446){
return (function (k1,k2){
if(cljs.core.truth_(schema.core.required_key_QMARK_.call(null,k1))){
return k1;
} else {
if(cljs.core.truth_(schema.core.required_key_QMARK_.call(null,k2))){
return k2;
} else {
if(cljs.core.truth_(schema.core.optional_key_QMARK_.call(null,k1))){
if(cljs.core._EQ_.call(null,k1,k2)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"k1","k1",-1701777341,null),new cljs.core.Symbol(null,"k2","k2",-1225133949,null))))].join('')));
}

return k1;
} else {
if(cljs.core._EQ_.call(null,k1,k2)){
return k1;
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Only one extra schema allowed")));


}
}
}
}
});})(validate__26972__auto__,ufv___36442,output_schema36436_36443,input_schema36437_36444,input_checker36438_36445,output_checker36439_36446))
,((function (validate__26972__auto__,ufv___36442,output_schema36436_36443,input_schema36437_36444,input_checker36438_36445,output_checker36439_36446){
return (function (s1,s2){
if(cljs.core.truth_((function (){var and__16337__auto__ = plumbing.fnk.schema.map_schema_QMARK_.call(null,s1);
if(cljs.core.truth_(and__16337__auto__)){
return plumbing.fnk.schema.map_schema_QMARK_.call(null,s2);
} else {
return and__16337__auto__;
}
})())){
return plumbing$fnk$schema$union_input_schemata.call(null,s1,s2);
} else {
return plumbing.fnk.schema.non_map_union.call(null,s1,s2);
}
});})(validate__26972__auto__,ufv___36442,output_schema36436_36443,input_schema36437_36444,input_checker36438_36445,output_checker36439_36446))
,i1,i2);
break;
}
})();
if(cljs.core.truth_(validate__26972__auto__)){
var temp__4425__auto___36450 = output_checker36439_36446.call(null,o__26975__auto__);
if(cljs.core.truth_(temp__4425__auto___36450)){
var error__26974__auto___36451 = temp__4425__auto___36450;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"union-input-schemata","union-input-schemata",-1338811970,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a minimal input schema schema that entails satisfaction of both s1 and s2"], null)),cljs.core.pr_str.call(null,error__26974__auto___36451)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36436_36443,new cljs.core.Keyword(null,"value","value",305978217),o__26975__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36451], null));
} else {
}
} else {
}

return o__26975__auto__;
});})(ufv___36442,output_schema36436_36443,input_schema36437_36444,input_checker36438_36445,output_checker36439_36446))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.union_input_schemata),schema.core.make_fn_schema.call(null,output_schema36436_36443,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36437_36444], null)));
var ufv___36457 = schema.utils.use_fn_validation;
var output_schema36452_36458 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null);
var input_schema36453_36459 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"input-schema","input-schema",1373647181,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null)))], null);
var input_checker36454_36460 = schema.core.checker.call(null,input_schema36453_36459);
var output_checker36455_36461 = schema.core.checker.call(null,output_schema36452_36458);
/**
 * Inputs: [input-schema :- InputSchema]
 *   Returns: [s/Keyword]
 * 
 *   Which top-level keys are required (i.e., non-false) by this input schema.
 */
plumbing.fnk.schema.required_toplevel_keys = ((function (ufv___36457,output_schema36452_36458,input_schema36453_36459,input_checker36454_36460,output_checker36455_36461){
return (function plumbing$fnk$schema$required_toplevel_keys(G__36456){
var validate__26972__auto__ = ufv___36457.get_cell();
if(cljs.core.truth_(validate__26972__auto__)){
var args__26973__auto___36462 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36456], null);
var temp__4425__auto___36463 = input_checker36454_36460.call(null,args__26973__auto___36462);
if(cljs.core.truth_(temp__4425__auto___36463)){
var error__26974__auto___36464 = temp__4425__auto___36463;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Which top-level keys are required (i.e., non-false) by this input schema."], null)),cljs.core.pr_str.call(null,error__26974__auto___36464)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36453_36459,new cljs.core.Keyword(null,"value","value",305978217),args__26973__auto___36462,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36464], null));
} else {
}
} else {
}

var o__26975__auto__ = (function (){var input_schema = G__36456;
while(true){
return cljs.core.keep.call(null,((function (validate__26972__auto__,ufv___36457,output_schema36452_36458,input_schema36453_36459,input_checker36454_36460,output_checker36455_36461){
return (function (k){
if(cljs.core.truth_(schema.core.required_key_QMARK_.call(null,k))){
return schema.core.explicit_schema_key.call(null,k);
} else {
return null;
}
});})(validate__26972__auto__,ufv___36457,output_schema36452_36458,input_schema36453_36459,input_checker36454_36460,output_checker36455_36461))
,cljs.core.keys.call(null,input_schema));
break;
}
})();
if(cljs.core.truth_(validate__26972__auto__)){
var temp__4425__auto___36465 = output_checker36455_36461.call(null,o__26975__auto__);
if(cljs.core.truth_(temp__4425__auto___36465)){
var error__26974__auto___36466 = temp__4425__auto___36465;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"required-toplevel-keys","required-toplevel-keys",1052167617,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Which top-level keys are required (i.e., non-false) by this input schema."], null)),cljs.core.pr_str.call(null,error__26974__auto___36466)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36452_36458,new cljs.core.Keyword(null,"value","value",305978217),o__26975__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36466], null));
} else {
}
} else {
}

return o__26975__auto__;
});})(ufv___36457,output_schema36452_36458,input_schema36453_36459,input_checker36454_36460,output_checker36455_36461))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.required_toplevel_keys),schema.core.make_fn_schema.call(null,output_schema36452_36458,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36453_36459], null)));
/**
 * Guess an output schema for an expr.  Currently just looks for literal map structure and
 * all keyword keys.
 */
plumbing.fnk.schema.guess_expr_output_schema = (function plumbing$fnk$schema$guess_expr_output_schema(expr){
if((cljs.core.map_QMARK_.call(null,expr)) && (cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,cljs.core.keys.call(null,expr)))){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__17121__auto__ = (function plumbing$fnk$schema$guess_expr_output_schema_$_iter__36475(s__36476){
return (new cljs.core.LazySeq(null,(function (){
var s__36476__$1 = s__36476;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__36476__$1);
if(temp__4425__auto__){
var s__36476__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__36476__$2)){
var c__17119__auto__ = cljs.core.chunk_first.call(null,s__36476__$2);
var size__17120__auto__ = cljs.core.count.call(null,c__17119__auto__);
var b__36478 = cljs.core.chunk_buffer.call(null,size__17120__auto__);
if((function (){var i__36477 = (0);
while(true){
if((i__36477 < size__17120__auto__)){
var vec__36481 = cljs.core._nth.call(null,c__17119__auto__,i__36477);
var k = cljs.core.nth.call(null,vec__36481,(0),null);
var v = cljs.core.nth.call(null,vec__36481,(1),null);
cljs.core.chunk_append.call(null,b__36478,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,plumbing$fnk$schema$guess_expr_output_schema.call(null,v)], null));

var G__36483 = (i__36477 + (1));
i__36477 = G__36483;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36478),plumbing$fnk$schema$guess_expr_output_schema_$_iter__36475.call(null,cljs.core.chunk_rest.call(null,s__36476__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36478),null);
}
} else {
var vec__36482 = cljs.core.first.call(null,s__36476__$2);
var k = cljs.core.nth.call(null,vec__36482,(0),null);
var v = cljs.core.nth.call(null,vec__36482,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,plumbing$fnk$schema$guess_expr_output_schema.call(null,v)], null),plumbing$fnk$schema$guess_expr_output_schema_$_iter__36475.call(null,cljs.core.rest.call(null,s__36476__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__17121__auto__.call(null,expr);
})());
} else {
return new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null);
}
});
/**
 * Subtract output-schema from input-schema, returning nil if it's possible that an object
 * satisfying the output-schema satisfies the input-schema, or otherwise a description
 * of the part(s) of input-schema not met by output-schema.  Strict about the map structure
 * of output-schema matching input-schema, but loose about everything else (only looks at
 * required keys of output-schema.
 */
plumbing.fnk.schema.schema_diff = (function plumbing$fnk$schema$schema_diff(input_schema,output_schema){
if(cljs.core.not.call(null,plumbing.fnk.schema.map_schema_QMARK_.call(null,input_schema))){
return plumbing.fnk.schema.non_map_diff.call(null,input_schema,output_schema);
} else {
if(cljs.core.not.call(null,plumbing.fnk.schema.map_schema_QMARK_.call(null,output_schema))){
return schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,input_schema,output_schema,(new cljs.core.Delay((function (){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,schema.core.explain.call(null,output_schema)),new cljs.core.Symbol(null,"map?","map?",-1780568534,null));
}),null)),null));
} else {
return cljs.core.not_empty.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__17121__auto__ = (function plumbing$fnk$schema$schema_diff_$_iter__36492(s__36493){
return (new cljs.core.LazySeq(null,(function (){
var s__36493__$1 = s__36493;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__36493__$1);
if(temp__4425__auto__){
var s__36493__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__36493__$2)){
var c__17119__auto__ = cljs.core.chunk_first.call(null,s__36493__$2);
var size__17120__auto__ = cljs.core.count.call(null,c__17119__auto__);
var b__36495 = cljs.core.chunk_buffer.call(null,size__17120__auto__);
if((function (){var i__36494 = (0);
while(true){
if((i__36494 < size__17120__auto__)){
var vec__36498 = cljs.core._nth.call(null,c__17119__auto__,i__36494);
var k = cljs.core.nth.call(null,vec__36498,(0),null);
var v = cljs.core.nth.call(null,vec__36498,(1),null);
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,k))){
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
var raw_k = schema.core.explicit_schema_key.call(null,k);
var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);
if(cljs.core.truth_((function (){var or__16349__auto__ = required_QMARK_;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return present_QMARK_;
}
})())){
var fail = ((!(present_QMARK_))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):plumbing$fnk$schema$schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));
if(cljs.core.truth_(fail)){
cljs.core.chunk_append.call(null,b__36495,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null));

var G__36500 = (i__36494 + (1));
i__36494 = G__36500;
continue;
} else {
var G__36501 = (i__36494 + (1));
i__36494 = G__36501;
continue;
}
} else {
var G__36502 = (i__36494 + (1));
i__36494 = G__36502;
continue;
}
} else {
var G__36503 = (i__36494 + (1));
i__36494 = G__36503;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36495),plumbing$fnk$schema$schema_diff_$_iter__36492.call(null,cljs.core.chunk_rest.call(null,s__36493__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36495),null);
}
} else {
var vec__36499 = cljs.core.first.call(null,s__36493__$2);
var k = cljs.core.nth.call(null,vec__36499,(0),null);
var v = cljs.core.nth.call(null,vec__36499,(1),null);
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,k))){
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
var raw_k = schema.core.explicit_schema_key.call(null,k);
var present_QMARK_ = cljs.core.contains_QMARK_.call(null,output_schema,raw_k);
if(cljs.core.truth_((function (){var or__16349__auto__ = required_QMARK_;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return present_QMARK_;
}
})())){
var fail = ((!(present_QMARK_))?new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null):plumbing$fnk$schema$schema_diff.call(null,v,cljs.core.get.call(null,output_schema,raw_k)));
if(cljs.core.truth_(fail)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fail], null),plumbing$fnk$schema$schema_diff_$_iter__36492.call(null,cljs.core.rest.call(null,s__36493__$2)));
} else {
var G__36504 = cljs.core.rest.call(null,s__36493__$2);
s__36493__$1 = G__36504;
continue;
}
} else {
var G__36505 = cljs.core.rest.call(null,s__36493__$2);
s__36493__$1 = G__36505;
continue;
}
} else {
var G__36506 = cljs.core.rest.call(null,s__36493__$2);
s__36493__$1 = G__36506;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__17121__auto__.call(null,input_schema);
})()));

}
}
});
plumbing.fnk.schema.assert_satisfies_schema = (function plumbing$fnk$schema$assert_satisfies_schema(input_schema,output_schema){
var fails = plumbing.fnk.schema.schema_diff.call(null,input_schema,output_schema);
if(cljs.core.truth_(fails)){
throw cljs.core.ex_info.call(null,[cljs.core.str(fails)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"does-not-satisfy-schema","does-not-satisfy-schema",-1543152824),new cljs.core.Keyword(null,"failures","failures",-912916356),fails], null));
} else {
return null;
}
});
var ufv___36529 = schema.utils.use_fn_validation;
var output_schema36507_36530 = schema.core.Any;
var input_schema36508_36531 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,new cljs.core.Symbol(null,"input","input",-2097503808,null)),schema.core.one.call(null,plumbing.fnk.schema.MapOutputSchema,new cljs.core.Symbol(null,"output","output",534662484,null))], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);
var input_checker36509_36532 = schema.core.checker.call(null,input_schema36508_36531);
var output_checker36510_36533 = schema.core.checker.call(null,output_schema36507_36530);
/**
 * Inputs: [[i2 o2] :- IOSchemata [i1 o1] :- [(s/one InputSchema (quote input)) (s/one MapOutputSchema (quote output))]]
 * 
 *   Given pairs of input and output schemata for fnks f1 and f2,
 * return a pair of input and output schemata for #(f2 (merge % (f1 %))).
 * f1's output schema must not contain any optional keys.
 */
plumbing.fnk.schema.compose_schemata = ((function (ufv___36529,output_schema36507_36530,input_schema36508_36531,input_checker36509_36532,output_checker36510_36533){
return (function plumbing$fnk$schema$compose_schemata(G__36511,G__36512){
var validate__26972__auto__ = true;
if(validate__26972__auto__){
var args__26973__auto___36534 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36511,G__36512], null);
var temp__4425__auto___36535 = input_checker36509_36532.call(null,args__26973__auto___36534);
if(cljs.core.truth_(temp__4425__auto___36535)){
var error__26974__auto___36536 = temp__4425__auto___36535;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2,\n   return a pair of input and output schemata for #(f2 (merge % (f1 %))).\n   f1's output schema must not contain any optional keys."], null)),cljs.core.pr_str.call(null,error__26974__auto___36536)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36508_36531,new cljs.core.Keyword(null,"value","value",305978217),args__26973__auto___36534,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36536], null));
} else {
}
} else {
}

var o__26975__auto__ = (function (){var G__36523 = G__36511;
var vec__36525 = G__36523;
var i2 = cljs.core.nth.call(null,vec__36525,(0),null);
var o2 = cljs.core.nth.call(null,vec__36525,(1),null);
var G__36524 = G__36512;
var vec__36526 = G__36524;
var i1 = cljs.core.nth.call(null,vec__36526,(0),null);
var o1 = cljs.core.nth.call(null,vec__36526,(1),null);
var G__36523__$1 = G__36523;
var G__36524__$1 = G__36524;
while(true){
var vec__36527 = G__36523__$1;
var i2__$1 = cljs.core.nth.call(null,vec__36527,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__36527,(1),null);
var vec__36528 = G__36524__$1;
var i1__$1 = cljs.core.nth.call(null,vec__36528,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__36528,(1),null);
plumbing.fnk.schema.assert_satisfies_schema.call(null,cljs.core.select_keys.call(null,i2__$1,cljs.core.keys.call(null,o1__$1)),o1__$1);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,cljs.core.apply.call(null,cljs.core.dissoc,i2__$1,cljs.core.concat.call(null,cljs.core.keys.call(null,o1__$1),cljs.core.map.call(null,schema.core.optional_key,cljs.core.keys.call(null,o1__$1)))),i1__$1),o2__$1], null);
break;
}
})();
if(validate__26972__auto__){
var temp__4425__auto___36537 = output_checker36510_36533.call(null,o__26975__auto__);
if(cljs.core.truth_(temp__4425__auto___36537)){
var error__26974__auto___36538 = temp__4425__auto___36537;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"compose-schemata","compose-schemata",918607729,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"always-validate","always-validate",1031872127),true,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2,\n   return a pair of input and output schemata for #(f2 (merge % (f1 %))).\n   f1's output schema must not contain any optional keys."], null)),cljs.core.pr_str.call(null,error__26974__auto___36538)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36507_36530,new cljs.core.Keyword(null,"value","value",305978217),o__26975__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36538], null));
} else {
}
} else {
}

return o__26975__auto__;
});})(ufv___36529,output_schema36507_36530,input_schema36508_36531,input_checker36509_36532,output_checker36510_36533))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.compose_schemata),schema.core.make_fn_schema.call(null,output_schema36507_36530,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36508_36531], null)));
plumbing.fnk.schema.schema_key = (function plumbing$fnk$schema$schema_key(m,k){
if(cljs.core.contains_QMARK_.call(null,m,k)){
return k;
} else {
if(cljs.core.contains_QMARK_.call(null,m,schema.core.optional_key.call(null,k))){
return schema.core.optional_key.call(null,k);
} else {
return null;

}
}
});
plumbing.fnk.schema.possibly_contains_QMARK_ = (function plumbing$fnk$schema$possibly_contains_QMARK_(m,k){
return cljs.core.boolean$.call(null,plumbing.fnk.schema.schema_key.call(null,m,k));
});
var ufv___36617 = schema.utils.use_fn_validation;
var output_schema36539_36618 = schema.core.Any;
var input_schema36540_36619 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.InputSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"InputSchema","InputSchema",-824370558,null)], null))),schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"ks","ks",-754231827,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker36541_36620 = schema.core.checker.call(null,input_schema36540_36619);
var output_checker36542_36621 = schema.core.checker.call(null,output_schema36539_36618);
/**
 * Inputs: [s :- InputSchema ks :- [s/Keyword]]
 * 
 *   Return a pair [ks-part non-ks-part], with any extra schema removed.
 */
plumbing.fnk.schema.split_schema = ((function (ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621){
return (function plumbing$fnk$schema$split_schema(G__36543,G__36544){
var validate__26972__auto__ = ufv___36617.get_cell();
if(cljs.core.truth_(validate__26972__auto__)){
var args__26973__auto___36622 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36543,G__36544], null);
var temp__4425__auto___36623 = input_checker36541_36620.call(null,args__26973__auto___36622);
if(cljs.core.truth_(temp__4425__auto___36623)){
var error__26974__auto___36624 = temp__4425__auto___36623;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a pair [ks-part non-ks-part], with any extra schema removed."], null)),cljs.core.pr_str.call(null,error__26974__auto___36624)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36540_36619,new cljs.core.Keyword(null,"value","value",305978217),args__26973__auto___36622,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36624], null));
} else {
}
} else {
}

var o__26975__auto__ = (function (){var s = G__36543;
var ks = G__36544;
while(true){
var ks__$1 = cljs.core.set.call(null,ks);
var iter__17121__auto__ = ((function (ks__$1,validate__26972__auto__,ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621){
return (function plumbing$fnk$schema$split_schema_$_iter__36581(s__36582){
return (new cljs.core.LazySeq(null,((function (ks__$1,validate__26972__auto__,ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621){
return (function (){
var s__36582__$1 = s__36582;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__36582__$1);
if(temp__4425__auto__){
var s__36582__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__36582__$2)){
var c__17119__auto__ = cljs.core.chunk_first.call(null,s__36582__$2);
var size__17120__auto__ = cljs.core.count.call(null,c__17119__auto__);
var b__36584 = cljs.core.chunk_buffer.call(null,size__17120__auto__);
if((function (){var i__36583 = (0);
while(true){
if((i__36583 < size__17120__auto__)){
var in_QMARK_ = cljs.core._nth.call(null,c__17119__auto__,i__36583);
cljs.core.chunk_append.call(null,b__36584,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__17121__auto__ = ((function (i__36583,in_QMARK_,c__17119__auto__,size__17120__auto__,b__36584,s__36582__$2,temp__4425__auto__,ks__$1,validate__26972__auto__,ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621){
return (function plumbing$fnk$schema$split_schema_$_iter__36581_$_iter__36601(s__36602){
return (new cljs.core.LazySeq(null,((function (i__36583,in_QMARK_,c__17119__auto__,size__17120__auto__,b__36584,s__36582__$2,temp__4425__auto__,ks__$1,validate__26972__auto__,ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621){
return (function (){
var s__36602__$1 = s__36602;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__36602__$1);
if(temp__4425__auto____$1){
var s__36602__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__36602__$2)){
var c__17119__auto____$1 = cljs.core.chunk_first.call(null,s__36602__$2);
var size__17120__auto____$1 = cljs.core.count.call(null,c__17119__auto____$1);
var b__36604 = cljs.core.chunk_buffer.call(null,size__17120__auto____$1);
if((function (){var i__36603 = (0);
while(true){
if((i__36603 < size__17120__auto____$1)){
var vec__36607 = cljs.core._nth.call(null,c__17119__auto____$1,i__36603);
var k = cljs.core.nth.call(null,vec__36607,(0),null);
var v = cljs.core.nth.call(null,vec__36607,(1),null);
if(cljs.core.truth_((function (){var and__16337__auto__ = schema.core.specific_key_QMARK_.call(null,k);
if(cljs.core.truth_(and__16337__auto__)){
return cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)));
} else {
return and__16337__auto__;
}
})())){
cljs.core.chunk_append.call(null,b__36604,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__36625 = (i__36603 + (1));
i__36603 = G__36625;
continue;
} else {
var G__36626 = (i__36603 + (1));
i__36603 = G__36626;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36604),plumbing$fnk$schema$split_schema_$_iter__36581_$_iter__36601.call(null,cljs.core.chunk_rest.call(null,s__36602__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36604),null);
}
} else {
var vec__36608 = cljs.core.first.call(null,s__36602__$2);
var k = cljs.core.nth.call(null,vec__36608,(0),null);
var v = cljs.core.nth.call(null,vec__36608,(1),null);
if(cljs.core.truth_((function (){var and__16337__auto__ = schema.core.specific_key_QMARK_.call(null,k);
if(cljs.core.truth_(and__16337__auto__)){
return cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)));
} else {
return and__16337__auto__;
}
})())){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),plumbing$fnk$schema$split_schema_$_iter__36581_$_iter__36601.call(null,cljs.core.rest.call(null,s__36602__$2)));
} else {
var G__36627 = cljs.core.rest.call(null,s__36602__$2);
s__36602__$1 = G__36627;
continue;
}
}
} else {
return null;
}
break;
}
});})(i__36583,in_QMARK_,c__17119__auto__,size__17120__auto__,b__36584,s__36582__$2,temp__4425__auto__,ks__$1,validate__26972__auto__,ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621))
,null,null));
});})(i__36583,in_QMARK_,c__17119__auto__,size__17120__auto__,b__36584,s__36582__$2,temp__4425__auto__,ks__$1,validate__26972__auto__,ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621))
;
return iter__17121__auto__.call(null,s);
})()));

var G__36628 = (i__36583 + (1));
i__36583 = G__36628;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36584),plumbing$fnk$schema$split_schema_$_iter__36581.call(null,cljs.core.chunk_rest.call(null,s__36582__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36584),null);
}
} else {
var in_QMARK_ = cljs.core.first.call(null,s__36582__$2);
return cljs.core.cons.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__17121__auto__ = ((function (in_QMARK_,s__36582__$2,temp__4425__auto__,ks__$1,validate__26972__auto__,ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621){
return (function plumbing$fnk$schema$split_schema_$_iter__36581_$_iter__36609(s__36610){
return (new cljs.core.LazySeq(null,((function (in_QMARK_,s__36582__$2,temp__4425__auto__,ks__$1,validate__26972__auto__,ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621){
return (function (){
var s__36610__$1 = s__36610;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__36610__$1);
if(temp__4425__auto____$1){
var s__36610__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__36610__$2)){
var c__17119__auto__ = cljs.core.chunk_first.call(null,s__36610__$2);
var size__17120__auto__ = cljs.core.count.call(null,c__17119__auto__);
var b__36612 = cljs.core.chunk_buffer.call(null,size__17120__auto__);
if((function (){var i__36611 = (0);
while(true){
if((i__36611 < size__17120__auto__)){
var vec__36615 = cljs.core._nth.call(null,c__17119__auto__,i__36611);
var k = cljs.core.nth.call(null,vec__36615,(0),null);
var v = cljs.core.nth.call(null,vec__36615,(1),null);
if(cljs.core.truth_((function (){var and__16337__auto__ = schema.core.specific_key_QMARK_.call(null,k);
if(cljs.core.truth_(and__16337__auto__)){
return cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)));
} else {
return and__16337__auto__;
}
})())){
cljs.core.chunk_append.call(null,b__36612,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__36629 = (i__36611 + (1));
i__36611 = G__36629;
continue;
} else {
var G__36630 = (i__36611 + (1));
i__36611 = G__36630;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36612),plumbing$fnk$schema$split_schema_$_iter__36581_$_iter__36609.call(null,cljs.core.chunk_rest.call(null,s__36610__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36612),null);
}
} else {
var vec__36616 = cljs.core.first.call(null,s__36610__$2);
var k = cljs.core.nth.call(null,vec__36616,(0),null);
var v = cljs.core.nth.call(null,vec__36616,(1),null);
if(cljs.core.truth_((function (){var and__16337__auto__ = schema.core.specific_key_QMARK_.call(null,k);
if(cljs.core.truth_(and__16337__auto__)){
return cljs.core._EQ_.call(null,in_QMARK_,cljs.core.contains_QMARK_.call(null,ks__$1,schema.core.explicit_schema_key.call(null,k)));
} else {
return and__16337__auto__;
}
})())){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),plumbing$fnk$schema$split_schema_$_iter__36581_$_iter__36609.call(null,cljs.core.rest.call(null,s__36610__$2)));
} else {
var G__36631 = cljs.core.rest.call(null,s__36610__$2);
s__36610__$1 = G__36631;
continue;
}
}
} else {
return null;
}
break;
}
});})(in_QMARK_,s__36582__$2,temp__4425__auto__,ks__$1,validate__26972__auto__,ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621))
,null,null));
});})(in_QMARK_,s__36582__$2,temp__4425__auto__,ks__$1,validate__26972__auto__,ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621))
;
return iter__17121__auto__.call(null,s);
})()),plumbing$fnk$schema$split_schema_$_iter__36581.call(null,cljs.core.rest.call(null,s__36582__$2)));
}
} else {
return null;
}
break;
}
});})(ks__$1,validate__26972__auto__,ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621))
,null,null));
});})(ks__$1,validate__26972__auto__,ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621))
;
return iter__17121__auto__.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,false], null));
break;
}
})();
if(cljs.core.truth_(validate__26972__auto__)){
var temp__4425__auto___36632 = output_checker36542_36621.call(null,o__26975__auto__);
if(cljs.core.truth_(temp__4425__auto___36632)){
var error__26974__auto___36633 = temp__4425__auto___36632;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"split-schema","split-schema",1859174771,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a pair [ks-part non-ks-part], with any extra schema removed."], null)),cljs.core.pr_str.call(null,error__26974__auto___36633)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36539_36618,new cljs.core.Keyword(null,"value","value",305978217),o__26975__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36633], null));
} else {
}
} else {
}

return o__26975__auto__;
});})(ufv___36617,output_schema36539_36618,input_schema36540_36619,input_checker36541_36620,output_checker36542_36621))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.split_schema),schema.core.make_fn_schema.call(null,output_schema36539_36618,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36540_36619], null)));
var ufv___36664 = schema.utils.use_fn_validation;
var output_schema36634_36665 = plumbing.fnk.schema.GraphIOSchemata;
var input_schema36635_36666 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,plumbing.fnk.schema.GraphIOSchemata,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null)),schema.core.one.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Keyword,"key"),schema.core.one.call(null,plumbing.fnk.schema.IOSchemata,"inner-schemas")], null),new cljs.core.Symbol(null,"arg1","arg1",-1702536411,null))], null);
var input_checker36636_36667 = schema.core.checker.call(null,input_schema36635_36666);
var output_checker36637_36668 = schema.core.checker.call(null,output_schema36634_36665);
/**
 * Inputs: [[i1 o1] :- GraphIOSchemata [k [i2 o2]] :- [(s/one s/Keyword "key") (s/one IOSchemata "inner-schemas")]]
 *   Returns: GraphIOSchemata
 * 
 *   Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,
 * return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))
 */
plumbing.fnk.schema.sequence_schemata = ((function (ufv___36664,output_schema36634_36665,input_schema36635_36666,input_checker36636_36667,output_checker36637_36668){
return (function plumbing$fnk$schema$sequence_schemata(G__36638,G__36639){
var validate__26972__auto__ = ufv___36664.get_cell();
if(cljs.core.truth_(validate__26972__auto__)){
var args__26973__auto___36669 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__36638,G__36639], null);
var temp__4425__auto___36670 = input_checker36636_36667.call(null,args__26973__auto___36669);
if(cljs.core.truth_(temp__4425__auto___36670)){
var error__26974__auto___36671 = temp__4425__auto___36670;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"GraphIOSchemata","GraphIOSchemata",-2137701253,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,\n   return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))"], null)),cljs.core.pr_str.call(null,error__26974__auto___36671)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema36635_36666,new cljs.core.Keyword(null,"value","value",305978217),args__26973__auto___36669,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36671], null));
} else {
}
} else {
}

var o__26975__auto__ = (function (){var G__36655 = G__36638;
var vec__36657 = G__36655;
var i1 = cljs.core.nth.call(null,vec__36657,(0),null);
var o1 = cljs.core.nth.call(null,vec__36657,(1),null);
var G__36656 = G__36639;
var vec__36658 = G__36656;
var k = cljs.core.nth.call(null,vec__36658,(0),null);
var vec__36659 = cljs.core.nth.call(null,vec__36658,(1),null);
var i2 = cljs.core.nth.call(null,vec__36659,(0),null);
var o2 = cljs.core.nth.call(null,vec__36659,(1),null);
var G__36655__$1 = G__36655;
var G__36656__$1 = G__36656;
while(true){
var vec__36660 = G__36655__$1;
var i1__$1 = cljs.core.nth.call(null,vec__36660,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__36660,(1),null);
var vec__36661 = G__36656__$1;
var k__$1 = cljs.core.nth.call(null,vec__36661,(0),null);
var vec__36662 = cljs.core.nth.call(null,vec__36661,(1),null);
var i2__$1 = cljs.core.nth.call(null,vec__36662,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__36662,(1),null);
if(cljs.core.not.call(null,plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i1__$1,k__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Duplicate key output (possibly due to a misordered graph) %s for input %s from input %s",k__$1,schema.core.explain.call(null,i2__$1),schema.core.explain.call(null,i1__$1))));
}

if(cljs.core.not.call(null,plumbing.fnk.schema.possibly_contains_QMARK_.call(null,i2__$1,k__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Node outputs a key %s in its inputs %s",k__$1,schema.core.explain.call(null,i2__$1))));
}

if(cljs.core.not.call(null,plumbing.fnk.schema.possibly_contains_QMARK_.call(null,o1__$1,k__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Node outputs a duplicate key %s given inputs %s",k__$1,schema.core.explain.call(null,i1__$1))));
}

var vec__36663 = plumbing.fnk.schema.split_schema.call(null,i2__$1,cljs.core.keys.call(null,o1__$1));
var used = cljs.core.nth.call(null,vec__36663,(0),null);
var unused = cljs.core.nth.call(null,vec__36663,(1),null);
plumbing.fnk.schema.assert_satisfies_schema.call(null,used,o1__$1);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plumbing.fnk.schema.union_input_schemata.call(null,unused,i1__$1),cljs.core.assoc.call(null,o1__$1,k__$1,o2__$1)], null);
break;
}
})();
if(cljs.core.truth_(validate__26972__auto__)){
var temp__4425__auto___36672 = output_checker36637_36668.call(null,o__26975__auto__);
if(cljs.core.truth_(temp__4425__auto___36672)){
var error__26974__auto___36673 = temp__4425__auto___36672;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: %s",cljs.core.with_meta(new cljs.core.Symbol(null,"sequence-schemata","sequence-schemata",-2061205313,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"GraphIOSchemata","GraphIOSchemata",-2137701253,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given pairs of input and output schemata for fnks f1 and f2, and a keyword k,\n   return a pair of input and output schemata for #(let [v1 (f1 %)] (assoc v1 k (f2 (merge-disjoint % v1))))"], null)),cljs.core.pr_str.call(null,error__26974__auto___36673)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema36634_36665,new cljs.core.Keyword(null,"value","value",305978217),o__26975__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__26974__auto___36673], null));
} else {
}
} else {
}

return o__26975__auto__;
});})(ufv___36664,output_schema36634_36665,input_schema36635_36666,input_checker36636_36667,output_checker36637_36668))
;

schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,plumbing.fnk.schema.sequence_schemata),schema.core.make_fn_schema.call(null,output_schema36634_36665,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema36635_36666], null)));

//# sourceMappingURL=schema.js.map?rel=1449783507005