// Compiled by ClojureScript 1.7.122 {}
goog.provide('taoensso.encore');
goog.require('cljs.core');
goog.require('goog.net.XhrIoPool');
goog.require('goog.events');
goog.require('clojure.set');
goog.require('cljs.tools.reader.edn');
goog.require('goog.net.XhrIo');
goog.require('goog.Uri.QueryData');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.string.StringBuffer');
goog.require('goog.net.EventType');
goog.require('goog.structs');
goog.require('goog.string.format');
goog.require('clojure.string');
goog.require('cljs.reader');
goog.require('goog.net.ErrorCode');
taoensso.encore.as__QMARK_int;
/**
 * Used for lib-consumer version assertions
 */
taoensso.encore.encore_version = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),(26),(0)], null);
taoensso.encore.assert_min_encore_version = (function taoensso$encore$assert_min_encore_version(min_version){
var vec__33518 = taoensso.encore.encore_version;
var xc = cljs.core.nth.call(null,vec__33518,(0),null);
var yc = cljs.core.nth.call(null,vec__33518,(1),null);
var zc = cljs.core.nth.call(null,vec__33518,(2),null);
var vec__33519 = ((cljs.core.vector_QMARK_.call(null,min_version))?min_version:cljs.core.re_seq.call(null,/\d+/,[cljs.core.str(min_version)].join('')));
var xm = cljs.core.nth.call(null,vec__33519,(0),null);
var ym = cljs.core.nth.call(null,vec__33519,(1),null);
var zm = cljs.core.nth.call(null,vec__33519,(2),null);
var vec__33520 = cljs.core.mapv.call(null,((function (vec__33518,xc,yc,zc,vec__33519,xm,ym,zm){
return (function (p1__33514_SHARP_){
var or__16349__auto__ = taoensso.encore.as__QMARK_int.call(null,p1__33514_SHARP_);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return (0);
}
});})(vec__33518,xc,yc,zc,vec__33519,xm,ym,zm))
,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [xm,ym,zm], null));
var xm__$1 = cljs.core.nth.call(null,vec__33520,(0),null);
var ym__$1 = cljs.core.nth.call(null,vec__33520,(1),null);
var zm__$1 = cljs.core.nth.call(null,vec__33520,(2),null);
if(((xc > xm__$1)) || ((cljs.core._EQ_.call(null,xc,xm__$1)) && (((yc > ym__$1)) || ((cljs.core._EQ_.call(null,yc,ym__$1)) && ((zc >= zm__$1)))))){
return null;
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("Insufficient com.taoensso/encore version. You may have a Leiningen dependency conflict (see http://goo.gl/qBbLvC for solution).")].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"min-version","min-version",-1697197126),clojure.string.join.call(null,".",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [xm__$1,ym__$1,zm__$1], null)),new cljs.core.Keyword(null,"your-version","your-version",-351781765),clojure.string.join.call(null,".",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [xc,yc,zc], null))], null));
}
});
/**
 * Handles optional docstrings & attr maps for a macro def's name.
 *   Stolen from `clojure.tools.macro`.
 */
taoensso.encore.name_with_attrs = (function taoensso$encore$name_with_attrs(name,macro_args){
var vec__33523 = ((typeof cljs.core.first.call(null,macro_args) === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,macro_args),cljs.core.next.call(null,macro_args)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,macro_args], null));
var docstring = cljs.core.nth.call(null,vec__33523,(0),null);
var macro_args__$1 = cljs.core.nth.call(null,vec__33523,(1),null);
var vec__33524 = ((cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,macro_args__$1)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,macro_args__$1),cljs.core.next.call(null,macro_args__$1)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.EMPTY,macro_args__$1], null));
var attr = cljs.core.nth.call(null,vec__33524,(0),null);
var macro_args__$2 = cljs.core.nth.call(null,vec__33524,(1),null);
var attr__$1 = (cljs.core.truth_(docstring)?cljs.core.assoc.call(null,attr,new cljs.core.Keyword(null,"doc","doc",1913296891),docstring):attr);
var attr__$2 = (cljs.core.truth_(cljs.core.meta.call(null,name))?cljs.core.conj.call(null,cljs.core.meta.call(null,name),attr__$1):attr__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta.call(null,name,attr__$2),macro_args__$2], null);
});
taoensso.encore.map_keys;

taoensso.encore.kw_identical_QMARK_;
/**
 * Experimental. Attempts to pave over differences in:
 *  `clojure.edn/read-string`, `clojure.tools.edn/read-string`,
 *  `cljs.reader/read-string`, `cljs.tools.reader/read-string`.
 * `cljs.reader` in particular can be a bit of a pain.
 */
taoensso.encore.read_edn = (function taoensso$encore$read_edn(var_args){
var args33525 = [];
var len__17407__auto___33528 = arguments.length;
var i__17408__auto___33529 = (0);
while(true){
if((i__17408__auto___33529 < len__17407__auto___33528)){
args33525.push((arguments[i__17408__auto___33529]));

var G__33530 = (i__17408__auto___33529 + (1));
i__17408__auto___33529 = G__33530;
continue;
} else {
}
break;
}

var G__33527 = args33525.length;
switch (G__33527) {
case 1:
return taoensso.encore.read_edn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.read_edn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33525.length)].join('')));

}
});

taoensso.encore.read_edn.cljs$core$IFn$_invoke$arity$1 = (function (s){
return taoensso.encore.read_edn.call(null,null,s);
});

taoensso.encore.read_edn.cljs$core$IFn$_invoke$arity$2 = (function (opts,s){
if(((s == null)) || ((s === ""))){
return null;
} else {
if(!(typeof s === 'string')){
throw cljs.core.ex_info.call(null,"`read-edn` attempt against non-nil, non-string arg",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arg","arg",-1747261837),s,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,s)], null));
} else {
var readers = cljs.core.get.call(null,opts,new cljs.core.Keyword(null,"readers","readers",-2118263030),new cljs.core.Keyword("taoensso.encore","dynamic","taoensso.encore/dynamic",-1726758399));
var default$ = cljs.core.get.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword("taoensso.encore","dynamic","taoensso.encore/dynamic",-1726758399));
var readers__$1 = ((cljs.core.not.call(null,taoensso.encore.kw_identical_QMARK_.call(null,readers,new cljs.core.Keyword("taoensso.encore","dynamic","taoensso.encore/dynamic",-1726758399))))?readers:taoensso.encore.map_keys.call(null,cljs.core.symbol,cljs.core.deref.call(null,cljs.reader._STAR_tag_table_STAR_)));
var default$__$1 = ((cljs.core.not.call(null,taoensso.encore.kw_identical_QMARK_.call(null,default$,new cljs.core.Keyword("taoensso.encore","dynamic","taoensso.encore/dynamic",-1726758399))))?default$:cljs.core.deref.call(null,cljs.reader._STAR_default_data_reader_fn_STAR_));
var opts__$1 = cljs.core.merge.call(null,opts,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"readers","readers",-2118263030),readers__$1,new cljs.core.Keyword(null,"default","default",-1987822328),default$__$1], null));
return cljs.tools.reader.edn.read_string.call(null,opts__$1,s);
}
}
});

taoensso.encore.read_edn.cljs$lang$maxFixedArity = 2;
taoensso.encore.pr_edn = (function taoensso$encore$pr_edn(var_args){
var args33532 = [];
var len__17407__auto___33537 = arguments.length;
var i__17408__auto___33538 = (0);
while(true){
if((i__17408__auto___33538 < len__17407__auto___33537)){
args33532.push((arguments[i__17408__auto___33538]));

var G__33539 = (i__17408__auto___33538 + (1));
i__17408__auto___33538 = G__33539;
continue;
} else {
}
break;
}

var G__33534 = args33532.length;
switch (G__33534) {
case 1:
return taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33532.length)].join('')));

}
});

taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$1 = (function (x){
return taoensso.encore.pr_edn.call(null,null,x);
});

taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$2 = (function (_opts,x){
var _STAR_print_level_STAR_33535 = cljs.core._STAR_print_level_STAR_;
var _STAR_print_length_STAR_33536 = cljs.core._STAR_print_length_STAR_;
cljs.core._STAR_print_level_STAR_ = null;

cljs.core._STAR_print_length_STAR_ = null;

try{return cljs.core.pr_str.call(null,x);
}finally {cljs.core._STAR_print_length_STAR_ = _STAR_print_length_STAR_33536;

cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_33535;
}});

taoensso.encore.pr_edn.cljs$lang$maxFixedArity = 2;
taoensso.encore.kw_identical_QMARK_ = cljs.core.keyword_identical_QMARK_;
taoensso.encore.stringy_QMARK_ = (function taoensso$encore$stringy_QMARK_(x){
return ((x instanceof cljs.core.Keyword)) || (typeof x === 'string');
});
taoensso.encore.atom_QMARK_ = (function taoensso$encore$atom_QMARK_(x){
return (x instanceof cljs.core.Atom);
});
taoensso.encore.named_QMARK_ = (function taoensso$encore$named_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition1$ & (4096))) || (x.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
});
taoensso.encore.chan_QMARK_ = (function taoensso$encore$chan_QMARK_(x){
return (x instanceof cljs.core.async.impl.channels.ManyToManyChannel);
});
taoensso.encore.re_pattern_QMARK_ = (function taoensso$encore$re_pattern_QMARK_(x){
return (x instanceof RegExp);
});
taoensso.encore.error_QMARK_ = (function taoensso$encore$error_QMARK_(x){
return (x instanceof Error);
});
/**
 * Returns data map iff `x` is an error of any type on platform
 */
taoensso.encore.error_data = (function taoensso$encore$error_data(x){
var temp__4425__auto__ = (function (){var or__16349__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
if((x instanceof Error)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return null;
}
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var data_map = temp__4425__auto__;
return cljs.core.merge.call(null,(function (){var err = x;
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"err-type","err-type",-116717722),cljs.core.type.call(null,err),new cljs.core.Keyword(null,"err-msg","err-msg",-1158512684),err.message,new cljs.core.Keyword(null,"err-cause","err-cause",897008749),err.cause], null);
})(),data_map);
} else {
return null;
}
});
taoensso.encore.nnil_QMARK_ = (function taoensso$encore$nnil_QMARK_(x){
return !((x == null));
});
taoensso.encore.nblank_QMARK_ = (function taoensso$encore$nblank_QMARK_(x){
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,x));
});
taoensso.encore.nneg_QMARK_ = (function taoensso$encore$nneg_QMARK_(x){
return !((x < (0)));
});
taoensso.encore.pos_int_QMARK_ = (function taoensso$encore$pos_int_QMARK_(x){
return (cljs.core.integer_QMARK_.call(null,x)) && ((x > (0)));
});
taoensso.encore.nneg_int_QMARK_ = (function taoensso$encore$nneg_int_QMARK_(x){
return (cljs.core.integer_QMARK_.call(null,x)) && (!((x < (0))));
});
taoensso.encore.nvec_QMARK_ = (function taoensso$encore$nvec_QMARK_(n,x){
return (cljs.core.vector_QMARK_.call(null,x)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,x),n));
});
taoensso.encore.set_STAR_;
taoensso.encore.udt_QMARK_ = taoensso.encore.nneg_int_QMARK_;
taoensso.encore.vec2_QMARK_ = (function taoensso$encore$vec2_QMARK_(x){
return taoensso.encore.nvec_QMARK_.call(null,(2),x);
});
taoensso.encore.vec3_QMARK_ = (function taoensso$encore$vec3_QMARK_(x){
return taoensso.encore.nvec_QMARK_.call(null,(3),x);
});
taoensso.encore.distinct_elements_QMARK_ = (function taoensso$encore$distinct_elements_QMARK_(x){
return (cljs.core.set_QMARK_.call(null,x)) || (cljs.core._EQ_.call(null,cljs.core.count.call(null,x),cljs.core.count.call(null,taoensso.encore.set_STAR_.call(null,x))));
});
taoensso.encore.nblank_str_QMARK_ = (function taoensso$encore$nblank_str_QMARK_(x){
return (typeof x === 'string') && (cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,x)));
});
taoensso.encore.nneg_num_QMARK_ = (function taoensso$encore$nneg_num_QMARK_(x){
return (typeof x === 'number') && (!((x < (0))));
});
taoensso.encore.pos_num_QMARK_ = (function taoensso$encore$pos_num_QMARK_(x){
return (typeof x === 'number') && ((x > (0)));
});
taoensso.encore.zero_num_QMARK_ = (function taoensso$encore$zero_num_QMARK_(x){
return cljs.core._EQ_.call(null,(0),x);
});
taoensso.encore.as__QMARK_nblank = (function taoensso$encore$as__QMARK_nblank(x){
if(typeof x === 'string'){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,x))){
return null;
} else {
return x;
}
} else {
return null;
}
});
taoensso.encore.as__QMARK_kw = (function taoensso$encore$as__QMARK_kw(x){
if((x instanceof cljs.core.Keyword)){
return x;
} else {
if(typeof x === 'string'){
return cljs.core.keyword.call(null,x);
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_name = (function taoensso$encore$as__QMARK_name(x){
if(cljs.core.truth_(taoensso.encore.named_QMARK_.call(null,x))){
return cljs.core.name.call(null,x);
} else {
if(typeof x === 'string'){
return x;
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_qname = (function taoensso$encore$as__QMARK_qname(x){
if(cljs.core.truth_(taoensso.encore.named_QMARK_.call(null,x))){
var n = cljs.core.name.call(null,x);
var temp__4423__auto__ = cljs.core.namespace.call(null,x);
if(cljs.core.truth_(temp__4423__auto__)){
var ns = temp__4423__auto__;
return [cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(n)].join('');
} else {
return n;
}
} else {
if(typeof x === 'string'){
return x;
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_int = (function taoensso$encore$as__QMARK_int(x){
if((x == null)){
return null;
} else {
if(typeof x === 'number'){
return cljs.core.long$.call(null,x);
} else {
if(typeof x === 'string'){
var x__$1 = parseInt(x,(10));
if(cljs.core.truth_(isNaN(x__$1))){
return null;
} else {
return x__$1;
}
} else {
return null;
}
}
}
});
taoensso.encore.as__QMARK_float = (function taoensso$encore$as__QMARK_float(x){
if((x == null)){
return null;
} else {
if(typeof x === 'number'){
return x;
} else {
if(typeof x === 'string'){
var x__$1 = parseFloat(x);
if(cljs.core.truth_(isNan(x__$1))){
return null;
} else {
return x__$1;
}
} else {
return null;
}
}
}
});
taoensso.encore.as__QMARK_bool = (function taoensso$encore$as__QMARK_bool(x){
if((x == null)){
return null;
} else {
if((x === true) || (x === false)){
return x;
} else {
if((cljs.core._EQ_.call(null,x,(0))) || (cljs.core._EQ_.call(null,x,"false")) || (cljs.core._EQ_.call(null,x,"FALSE")) || (cljs.core._EQ_.call(null,x,"0"))){
return false;
} else {
if((cljs.core._EQ_.call(null,x,(1))) || (cljs.core._EQ_.call(null,x,"true")) || (cljs.core._EQ_.call(null,x,"TRUE")) || (cljs.core._EQ_.call(null,x,"1"))){
return true;
} else {
return null;
}
}
}
}
});
taoensso.encore.as__QMARK_email = (function taoensso$encore$as__QMARK_email(_QMARK_s){
if(cljs.core.truth_(_QMARK_s)){
return cljs.core.re_find.call(null,/^[^\s@]+@[^\s@]+\.\S*[^\.]$/,clojure.string.trim.call(null,_QMARK_s));
} else {
return null;
}
});
taoensso.encore.as__QMARK_nemail = (function taoensso$encore$as__QMARK_nemail(_QMARK_s){
var temp__4425__auto__ = taoensso.encore.as__QMARK_email.call(null,_QMARK_s);
if(cljs.core.truth_(temp__4425__auto__)){
var email = temp__4425__auto__;
return clojure.string.lower_case.call(null,email);
} else {
return null;
}
});
taoensso.encore._QMARK_as_throw = (function taoensso$encore$_QMARK_as_throw(as_name,x){
throw cljs.core.ex_info.call(null,[cljs.core.str("nil as-?"),cljs.core.str(cljs.core.name.call(null,as_name)),cljs.core.str(" against arg: "),cljs.core.str(cljs.core.pr_str.call(null,x))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arg","arg",-1747261837),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x)], null));
});
taoensso.encore.as_nblank = (function taoensso$encore$as_nblank(x){
var or__16349__auto__ = taoensso.encore.as__QMARK_nblank.call(null,x);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore._QMARK_as_throw.call(null,new cljs.core.Keyword(null,"nblank","nblank",626815585),x);
}
});
taoensso.encore.as_kw = (function taoensso$encore$as_kw(x){
var or__16349__auto__ = taoensso.encore.as__QMARK_kw.call(null,x);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore._QMARK_as_throw.call(null,new cljs.core.Keyword(null,"kw","kw",1158308175),x);
}
});
taoensso.encore.as_name = (function taoensso$encore$as_name(x){
var or__16349__auto__ = taoensso.encore.as__QMARK_name.call(null,x);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore._QMARK_as_throw.call(null,new cljs.core.Keyword(null,"name","name",1843675177),x);
}
});
taoensso.encore.as_qname = (function taoensso$encore$as_qname(x){
var or__16349__auto__ = taoensso.encore.as__QMARK_qname.call(null,x);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore._QMARK_as_throw.call(null,new cljs.core.Keyword(null,"qname","qname",-1983612179),x);
}
});
taoensso.encore.as_bool = (function taoensso$encore$as_bool(x){
var _QMARK_b = taoensso.encore.as__QMARK_bool.call(null,x);
if(!((_QMARK_b == null))){
return _QMARK_b;
} else {
return taoensso.encore._QMARK_as_throw.call(null,new cljs.core.Keyword(null,"bool","bool",1444635321),x);
}
});
taoensso.encore.as_int = (function taoensso$encore$as_int(x){
var or__16349__auto__ = taoensso.encore.as__QMARK_int.call(null,x);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore._QMARK_as_throw.call(null,new cljs.core.Keyword(null,"int","int",-1741416922),x);
}
});
taoensso.encore.as_float = (function taoensso$encore$as_float(x){
var or__16349__auto__ = taoensso.encore.as__QMARK_float.call(null,x);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore._QMARK_as_throw.call(null,new cljs.core.Keyword(null,"float","float",-1732389368),x);
}
});
taoensso.encore.as_email = (function taoensso$encore$as_email(x){
var or__16349__auto__ = taoensso.encore.as__QMARK_email.call(null,x);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore._QMARK_as_throw.call(null,new cljs.core.Keyword(null,"email","email",1415816706),x);
}
});
taoensso.encore.as_nemail = (function taoensso$encore$as_nemail(x){
var or__16349__auto__ = taoensso.encore.as__QMARK_nemail.call(null,x);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore._QMARK_as_throw.call(null,new cljs.core.Keyword(null,"nemail","nemail",318708381),x);
}
});
taoensso.encore.nnil_EQ_ = (function taoensso$encore$nnil_EQ_(var_args){
var args33545 = [];
var len__17407__auto___33551 = arguments.length;
var i__17408__auto___33552 = (0);
while(true){
if((i__17408__auto___33552 < len__17407__auto___33551)){
args33545.push((arguments[i__17408__auto___33552]));

var G__33553 = (i__17408__auto___33552 + (1));
i__17408__auto___33552 = G__33553;
continue;
} else {
}
break;
}

var G__33550 = args33545.length;
switch (G__33550) {
case 2:
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args33545.slice((2)),(0)));
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17426__auto__);

}
});

taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var and__16337__auto__ = taoensso.encore.nnil_QMARK_.call(null,x);
if(cljs.core.truth_(and__16337__auto__)){
return cljs.core._EQ_.call(null,x,y);
} else {
return and__16337__auto__;
}
});

taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
var and__16337__auto__ = taoensso.encore.nnil_QMARK_.call(null,x);
if(cljs.core.truth_(and__16337__auto__)){
return cljs.core.apply.call(null,cljs.core._EQ_,x,y,more);
} else {
return and__16337__auto__;
}
});

taoensso.encore.nnil_EQ_.cljs$lang$applyTo = (function (seq33546){
var G__33547 = cljs.core.first.call(null,seq33546);
var seq33546__$1 = cljs.core.next.call(null,seq33546);
var G__33548 = cljs.core.first.call(null,seq33546__$1);
var seq33546__$2 = cljs.core.next.call(null,seq33546__$1);
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__33547,G__33548,seq33546__$2);
});

taoensso.encore.nnil_EQ_.cljs$lang$maxFixedArity = (2);
taoensso.encore.vec_STAR_ = (function taoensso$encore$vec_STAR_(x){
if(cljs.core.vector_QMARK_.call(null,x)){
return x;
} else {
return cljs.core.vec.call(null,x);
}
});
taoensso.encore.set_STAR_ = (function taoensso$encore$set_STAR_(x){
if(cljs.core.set_QMARK_.call(null,x)){
return x;
} else {
return cljs.core.set.call(null,x);
}
});
taoensso.encore.ks_EQ_ = (function taoensso$encore$ks_EQ_(ks,m){
return cljs.core._EQ_.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,m)),taoensso.encore.set_STAR_.call(null,ks));
});
taoensso.encore.ks_LT__EQ_ = (function taoensso$encore$ks_LT__EQ_(ks,m){
return clojure.set.subset_QMARK_.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,m)),taoensso.encore.set_STAR_.call(null,ks));
});
taoensso.encore.ks_GT__EQ_ = (function taoensso$encore$ks_GT__EQ_(ks,m){
return clojure.set.superset_QMARK_.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,m)),taoensso.encore.set_STAR_.call(null,ks));
});
taoensso.encore.ks_nnil_QMARK_ = (function taoensso$encore$ks_nnil_QMARK_(ks,m){
return cljs.core.every_QMARK_.call(null,(function (p1__33555_SHARP_){
return taoensso.encore.nnil_QMARK_.call(null,cljs.core.get.call(null,m,p1__33555_SHARP_));
}),ks);
});
taoensso.encore.rsome;

taoensso.encore.revery_QMARK_;
taoensso.encore.non_throwing = (function taoensso$encore$non_throwing(pred){
return (function (x){
try{return pred.call(null,x);
}catch (e33557){if((e33557 instanceof Error)){
var _ = e33557;
return null;
} else {
throw e33557;

}
}});
});
taoensso.encore._invar_pred = (function taoensso$encore$_invar_pred(pred_form){
if(!(cljs.core.vector_QMARK_.call(null,pred_form))){
return pred_form;
} else {
var vec__33563 = pred_form;
var type = cljs.core.nth.call(null,vec__33563,(0),null);
var p1 = cljs.core.nth.call(null,vec__33563,(1),null);
var p2 = cljs.core.nth.call(null,vec__33563,(2),null);
var more = cljs.core.nthnext.call(null,vec__33563,(3));
var G__33564 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__33564) {
case "el":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
return cljs.core.contains_QMARK_.call(null,taoensso.encore.set_STAR_.call(null,p1),x);
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "ks-nnil?":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
return taoensso.encore.ks_nnil_QMARK_.call(null,p1,x);
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "ks<=":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
return taoensso.encore.ks_LT__EQ_.call(null,p1,x);
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "or":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
var or__16349__auto__ = (cljs.core.truth_(p1)?taoensso.encore.non_throwing.call(null,taoensso$encore$_invar_pred.call(null,p1)).call(null,x):null);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
var or__16349__auto____$1 = (cljs.core.truth_(p2)?taoensso.encore.non_throwing.call(null,taoensso$encore$_invar_pred.call(null,p2)).call(null,x):null);
if(cljs.core.truth_(or__16349__auto____$1)){
return or__16349__auto____$1;
} else {
return taoensso.encore.rsome.call(null,((function (or__16349__auto____$1,or__16349__auto__,G__33564,vec__33563,type,p1,p2,more){
return (function (p1__33559_SHARP_){
return taoensso.encore.non_throwing.call(null,taoensso$encore$_invar_pred.call(null,p1__33559_SHARP_)).call(null,x);
});})(or__16349__auto____$1,or__16349__auto__,G__33564,vec__33563,type,p1,p2,more))
,more);
}
}
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "not":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
var and__16337__auto__ = ((cljs.core.not.call(null,p1))?true:cljs.core.not.call(null,taoensso$encore$_invar_pred.call(null,p1).call(null,x)));
if(and__16337__auto__){
var and__16337__auto____$1 = ((cljs.core.not.call(null,p2))?true:cljs.core.not.call(null,taoensso$encore$_invar_pred.call(null,p2).call(null,x)));
if(and__16337__auto____$1){
return taoensso.encore.revery_QMARK_.call(null,((function (and__16337__auto____$1,and__16337__auto__,G__33564,vec__33563,type,p1,p2,more){
return (function (p1__33558_SHARP_){
return cljs.core.not.call(null,taoensso$encore$_invar_pred.call(null,p1__33558_SHARP_).call(null,x));
});})(and__16337__auto____$1,and__16337__auto__,G__33564,vec__33563,type,p1,p2,more))
,more);
} else {
return and__16337__auto____$1;
}
} else {
return and__16337__auto__;
}
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "ks=":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
return taoensso.encore.ks_EQ_.call(null,p1,x);
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "and":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
var and__16337__auto__ = ((cljs.core.not.call(null,p1))?true:taoensso$encore$_invar_pred.call(null,p1).call(null,x));
if(cljs.core.truth_(and__16337__auto__)){
var and__16337__auto____$1 = ((cljs.core.not.call(null,p2))?true:taoensso$encore$_invar_pred.call(null,p2).call(null,x));
if(cljs.core.truth_(and__16337__auto____$1)){
return taoensso.encore.revery_QMARK_.call(null,((function (and__16337__auto____$1,and__16337__auto__,G__33564,vec__33563,type,p1,p2,more){
return (function (p1__33560_SHARP_){
return taoensso$encore$_invar_pred.call(null,p1__33560_SHARP_).call(null,x);
});})(and__16337__auto____$1,and__16337__auto__,G__33564,vec__33563,type,p1,p2,more))
,more);
} else {
return and__16337__auto____$1;
}
} else {
return and__16337__auto__;
}
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "ks>=":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
return taoensso.encore.ks_GT__EQ_.call(null,p1,x);
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "not-in":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
return !(cljs.core.contains_QMARK_.call(null,taoensso.encore.set_STAR_.call(null,p1),x));
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "not-el":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
return !(cljs.core.contains_QMARK_.call(null,taoensso.encore.set_STAR_.call(null,p1),x));
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "set<=":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
return clojure.set.subset_QMARK_.call(null,taoensso.encore.set_STAR_.call(null,x),taoensso.encore.set_STAR_.call(null,p1));
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "set>=":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
return clojure.set.superset_QMARK_.call(null,taoensso.encore.set_STAR_.call(null,x),taoensso.encore.set_STAR_.call(null,p1));
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "set=":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
return cljs.core._EQ_.call(null,taoensso.encore.set_STAR_.call(null,x),taoensso.encore.set_STAR_.call(null,p1));
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
case "in":
return ((function (G__33564,vec__33563,type,p1,p2,more){
return (function (x){
return cljs.core.contains_QMARK_.call(null,taoensso.encore.set_STAR_.call(null,p1),x);
});
;})(G__33564,vec__33563,type,p1,p2,more))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}
}
});
taoensso.encore.format;

taoensso.encore.now_udt;
taoensso.encore.assertion_error = (function taoensso$encore$assertion_error(msg){
return (new Error(msg));
});
taoensso.encore._invar_undefined_val = new cljs.core.Keyword("invariant","undefined-val","invariant/undefined-val",-906909938);
taoensso.encore._invar_violation_BANG_ = (function taoensso$encore$_invar_violation_BANG_(var_args){
var args33566 = [];
var len__17407__auto___33569 = arguments.length;
var i__17408__auto___33570 = (0);
while(true){
if((i__17408__auto___33570 < len__17407__auto___33569)){
args33566.push((arguments[i__17408__auto___33570]));

var G__33571 = (i__17408__auto___33570 + (1));
i__17408__auto___33570 = G__33571;
continue;
} else {
}
break;
}

var G__33568 = args33566.length;
switch (G__33568) {
case 0:
return taoensso.encore._invar_violation_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 6:
return taoensso.encore._invar_violation_BANG_.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33566.length)].join('')));

}
});

taoensso.encore._invar_violation_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
throw cljs.core.ex_info.call(null,"Invariant violation",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"invariant-violation?","invariant-violation?",-356256378),true], null));
});

taoensso.encore._invar_violation_BANG_.cljs$core$IFn$_invoke$arity$6 = (function (assertion_QMARK_,ns_str,_QMARK_line,form,val,_QMARK_err){
var pattern = "Invariant violation in `%s:%s` [pred-form, val]:\n [%s, %s]";
var line_str = (function (){var or__16349__auto__ = _QMARK_line;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return "?";
}
})();
var form_str = [cljs.core.str(form)].join('');
var undefn_val_QMARK_ = cljs.core._EQ_.call(null,val,taoensso.encore._invar_undefined_val);
var val_str = ((undefn_val_QMARK_)?"<undefined>":[cljs.core.str((function (){var or__16349__auto__ = val;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return "<nil>";
}
})())].join(''));
var dummy_err_QMARK_ = new cljs.core.Keyword(null,"invariant-violation?","invariant-violation?",-356256378).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,_QMARK_err));
var _QMARK_err__$1 = (cljs.core.truth_(dummy_err_QMARK_)?null:_QMARK_err);
var _QMARK_err_str = (function (){var temp__4425__auto__ = _QMARK_err__$1;
if(cljs.core.truth_(temp__4425__auto__)){
var e = temp__4425__auto__;
return [cljs.core.str(_QMARK_err__$1)].join('');
} else {
return null;
}
})();
var msg = (function (){var msg = taoensso.encore.format.call(null,pattern,ns_str,line_str,form_str,val_str);
if(cljs.core.not.call(null,_QMARK_err__$1)){
return msg;
} else {
if(undefn_val_QMARK_){
return [cljs.core.str(msg),cljs.core.str("\n`val` error: "),cljs.core.str(_QMARK_err_str)].join('');
} else {
return [cljs.core.str(msg),cljs.core.str("\n`pred-form` error: "),cljs.core.str(_QMARK_err_str)].join('');

}
}
})();
throw cljs.core.ex_info.call(null,msg,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"?form","?form",-827526074),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"elidable?","elidable?",248362249),new cljs.core.Keyword(null,"val","val",128701612),new cljs.core.Keyword(null,"val-type","val-type",-279850094),new cljs.core.Keyword(null,"?err","?err",549653299),new cljs.core.Keyword(null,"*assert*","*assert*",-160895053),new cljs.core.Keyword(null,"?line","?line",-631853385),new cljs.core.Keyword(null,"form-str","form-str",871608859)],[((typeof form === 'string')?null:form),taoensso.encore.now_udt.call(null),ns_str,assertion_QMARK_,((undefn_val_QMARK_)?new cljs.core.Symbol("undefined","threw-error","undefined/threw-error",-2085122794,null):val),((undefn_val_QMARK_)?new cljs.core.Symbol("undefined","threw-error","undefined/threw-error",-2085122794,null):cljs.core.type.call(null,val)),_QMARK_err__$1,cljs.core._STAR_assert_STAR_,_QMARK_line,form_str]))
;
});

taoensso.encore._invar_violation_BANG_.cljs$lang$maxFixedArity = 6;
taoensso.encore.try_pred = (function taoensso$encore$try_pred(pred,x){
try{return pred.call(null,x);
}catch (e33575){if((e33575 instanceof Error)){
var _ = e33575;
return false;
} else {
throw e33575;

}
}});
/**
 * Experimental. Cheaper `have!` alt that provides less diagnostic info.
 */
taoensso.encore.is_BANG_ = (function taoensso$encore$is_BANG_(var_args){
var args33576 = [];
var len__17407__auto___33579 = arguments.length;
var i__17408__auto___33580 = (0);
while(true){
if((i__17408__auto___33580 < len__17407__auto___33579)){
args33576.push((arguments[i__17408__auto___33580]));

var G__33581 = (i__17408__auto___33580 + (1));
i__17408__auto___33580 = G__33581;
continue;
} else {
}
break;
}

var G__33578 = args33576.length;
switch (G__33578) {
case 1:
return taoensso.encore.is_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.is_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33576.length)].join('')));

}
});

taoensso.encore.is_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return taoensso.encore.is_BANG_.call(null,cljs.core.identity,x);
}
});

taoensso.encore.is_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (pred,x){
if(cljs.core.truth_(taoensso.encore.try_pred.call(null,pred,x))){
return x;
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("`is!` "),cljs.core.str([cljs.core.str(pred)].join('')),cljs.core.str(" failure against arg: "),cljs.core.str(cljs.core.pr_str.call(null,x))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arg","arg",-1747261837),x,new cljs.core.Keyword(null,"arg-type","arg-type",-2020167363),cljs.core.type.call(null,x)], null));
}
});

taoensso.encore.is_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * Experimental. For use with `if-let`s, `when-let`s, etc.
 */
taoensso.encore.when_QMARK_ = (function taoensso$encore$when_QMARK_(pred,x){
if(cljs.core.truth_(taoensso.encore.try_pred.call(null,pred,x))){
return x;
} else {
return null;
}
});
/**
 * Like `name` but includes keyword namespaces in name string
 */
taoensso.encore.qname = taoensso.encore.as_qname;
taoensso.encore.explode_keyword = (function taoensso$encore$explode_keyword(k){
return clojure.string.split.call(null,taoensso.encore.qname.call(null,k),/[\.\/]/);
});
taoensso.encore.merge_keywords = (function taoensso$encore$merge_keywords(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33587 = arguments.length;
var i__17408__auto___33588 = (0);
while(true){
if((i__17408__auto___33588 < len__17407__auto___33587)){
args__17414__auto__.push((arguments[i__17408__auto___33588]));

var G__33589 = (i__17408__auto___33588 + (1));
i__17408__auto___33588 = G__33589;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic = (function (ks,p__33585){
var vec__33586 = p__33585;
var no_slash_QMARK_ = cljs.core.nth.call(null,vec__33586,(0),null);
var parts = cljs.core.reduce.call(null,((function (vec__33586,no_slash_QMARK_){
return (function (acc,in$){
if(cljs.core.truth_(in$)){
return cljs.core.into.call(null,acc,taoensso.encore.explode_keyword.call(null,in$));
} else {
return acc;
}
});})(vec__33586,no_slash_QMARK_))
,cljs.core.PersistentVector.EMPTY,ks);
if(cljs.core.empty_QMARK_.call(null,parts)){
return null;
} else {
if(cljs.core.truth_(no_slash_QMARK_)){
return cljs.core.keyword.call(null,clojure.string.join.call(null,".",parts));
} else {
var ppop = cljs.core.pop.call(null,parts);
return cljs.core.keyword.call(null,((cljs.core.empty_QMARK_.call(null,ppop))?null:clojure.string.join.call(null,".",ppop)),cljs.core.peek.call(null,parts));
}
}
});

taoensso.encore.merge_keywords.cljs$lang$maxFixedArity = (1);

taoensso.encore.merge_keywords.cljs$lang$applyTo = (function (seq33583){
var G__33584 = cljs.core.first.call(null,seq33583);
var seq33583__$1 = cljs.core.next.call(null,seq33583);
return taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic(G__33584,seq33583__$1);
});
taoensso.encore.clamp = (function taoensso$encore$clamp(nmin,nmax,n){
if((n < nmin)){
return nmin;
} else {
if((n > nmax)){
return nmax;
} else {
return n;
}
}
});
taoensso.encore.pow = (function taoensso$encore$pow(n,exp){
return Math.pow(n,exp);
});
taoensso.encore.abs = (function taoensso$encore$abs(n){
if((n < (0))){
return (- n);
} else {
return n;
}
});
taoensso.encore.round_STAR_ = (function taoensso$encore$round_STAR_(var_args){
var args33590 = [];
var len__17407__auto___33594 = arguments.length;
var i__17408__auto___33595 = (0);
while(true){
if((i__17408__auto___33595 < len__17407__auto___33594)){
args33590.push((arguments[i__17408__auto___33595]));

var G__33596 = (i__17408__auto___33595 + (1));
i__17408__auto___33595 = G__33596;
continue;
} else {
}
break;
}

var G__33592 = args33590.length;
switch (G__33592) {
case 1:
return taoensso.encore.round_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.round_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.encore.round_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33590.length)].join('')));

}
});

taoensso.encore.round_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (n){
return taoensso.encore.round_STAR_.call(null,new cljs.core.Keyword(null,"round","round",2009433328),null,n);
});

taoensso.encore.round_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (type,n){
return taoensso.encore.round_STAR_.call(null,type,null,n);
});

taoensso.encore.round_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (type,nplaces,n){
var n__$1 = n;
var modifier = (cljs.core.truth_(nplaces)?Math.pow(10.0,nplaces):null);
var n_STAR_ = ((cljs.core.not.call(null,modifier))?n__$1:(n__$1 * modifier));
var rounded = (function (){var G__33593 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__33593) {
case "round":
return Math.round(n_STAR_);

break;
case "floor":
return Math.floor(n_STAR_);

break;
case "ceil":
return Math.ceil(n_STAR_);

break;
case "trunc":
return cljs.core.long$.call(null,n_STAR_);

break;
default:
throw cljs.core.ex_info.call(null,"Unknown round type",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),type], null));

}
})();
if(cljs.core.not.call(null,modifier)){
return cljs.core.long$.call(null,rounded);
} else {
return (rounded / modifier);
}
});

taoensso.encore.round_STAR_.cljs$lang$maxFixedArity = 3;
taoensso.encore.round0 = (function taoensso$encore$round0(n){
return Math.round(n);
});
taoensso.encore.round1 = (function taoensso$encore$round1(n){
return (Math.round((n * 10.0)) / 10.0);
});
taoensso.encore.round2 = (function taoensso$encore$round2(n){
return (Math.round((n * 100.0)) / 100.0);
});
/**
 * Returns binary exponential backoff value.
 */
taoensso.encore.exp_backoff = (function taoensso$encore$exp_backoff(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33605 = arguments.length;
var i__17408__auto___33606 = (0);
while(true){
if((i__17408__auto___33606 < len__17407__auto___33605)){
args__17414__auto__.push((arguments[i__17408__auto___33606]));

var G__33607 = (i__17408__auto___33606 + (1));
i__17408__auto___33606 = G__33607;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic = (function (nattempt,p__33601){
var vec__33602 = p__33601;
var map__33603 = cljs.core.nth.call(null,vec__33602,(0),null);
var map__33603__$1 = ((((!((map__33603 == null)))?((((map__33603.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33603.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33603):map__33603);
var min_SINGLEQUOTE_ = cljs.core.get.call(null,map__33603__$1,new cljs.core.Keyword(null,"min","min",444991522));
var max_SINGLEQUOTE_ = cljs.core.get.call(null,map__33603__$1,new cljs.core.Keyword(null,"max","max",61366548));
var factor = cljs.core.get.call(null,map__33603__$1,new cljs.core.Keyword(null,"factor","factor",-2103172748),(1000));
var binary_exp = Math.pow((2),(nattempt - (1)));
var time = (((binary_exp + cljs.core.rand.call(null,binary_exp)) * 0.5) * factor);
return cljs.core.long$.call(null,(function (){var time__$1 = (cljs.core.truth_(min_SINGLEQUOTE_)?(function (){var x__16680__auto__ = cljs.core.long$.call(null,min_SINGLEQUOTE_);
var y__16681__auto__ = cljs.core.long$.call(null,time);
return ((x__16680__auto__ > y__16681__auto__) ? x__16680__auto__ : y__16681__auto__);
})():time);
var time__$2 = (cljs.core.truth_(max_SINGLEQUOTE_)?(function (){var x__16687__auto__ = cljs.core.long$.call(null,max_SINGLEQUOTE_);
var y__16688__auto__ = cljs.core.long$.call(null,time__$1);
return ((x__16687__auto__ < y__16688__auto__) ? x__16687__auto__ : y__16688__auto__);
})():time__$1);
return time__$2;
})());
});

taoensso.encore.exp_backoff.cljs$lang$maxFixedArity = (1);

taoensso.encore.exp_backoff.cljs$lang$applyTo = (function (seq33599){
var G__33600 = cljs.core.first.call(null,seq33599);
var seq33599__$1 = cljs.core.next.call(null,seq33599);
return taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic(G__33600,seq33599__$1);
});
taoensso.encore.now_dt = (function taoensso$encore$now_dt(){
return (new Date());
});
taoensso.encore.now_udt = (function taoensso$encore$now_udt(){
return (new Date()).getTime();
});
taoensso.encore.secs__GT_ms = (function taoensso$encore$secs__GT_ms(secs){
return (cljs.core.long$.call(null,secs) * (1000));
});
taoensso.encore.ms__GT_secs = (function taoensso$encore$ms__GT_secs(ms){
return cljs.core.quot.call(null,cljs.core.long$.call(null,ms),(1000));
});
/**
 * Returns ~number of milliseconds in period defined by given args
 */
taoensso.encore.ms = (function taoensso$encore$ms(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33625 = arguments.length;
var i__17408__auto___33626 = (0);
while(true){
if((i__17408__auto___33626 < len__17407__auto___33625)){
args__17414__auto__.push((arguments[i__17408__auto___33626]));

var G__33627 = (i__17408__auto___33626 + (1));
i__17408__auto___33626 = G__33627;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((0) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((0)),(0))):null);
return taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(argseq__17415__auto__);
});

taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic = (function (p__33621){
var map__33622 = p__33621;
var map__33622__$1 = ((((!((map__33622 == null)))?((((map__33622.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33622.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33622):map__33622);
var opts = map__33622__$1;
var years = cljs.core.get.call(null,map__33622__$1,new cljs.core.Keyword(null,"years","years",-1298579689));
var months = cljs.core.get.call(null,map__33622__$1,new cljs.core.Keyword(null,"months","months",-45571637));
var weeks = cljs.core.get.call(null,map__33622__$1,new cljs.core.Keyword(null,"weeks","weeks",1844596125));
var days = cljs.core.get.call(null,map__33622__$1,new cljs.core.Keyword(null,"days","days",-1394072564));
var hours = cljs.core.get.call(null,map__33622__$1,new cljs.core.Keyword(null,"hours","hours",58380855));
var mins = cljs.core.get.call(null,map__33622__$1,new cljs.core.Keyword(null,"mins","mins",467369676));
var secs = cljs.core.get.call(null,map__33622__$1,new cljs.core.Keyword(null,"secs","secs",1532330091));
var msecs = cljs.core.get.call(null,map__33622__$1,new cljs.core.Keyword(null,"msecs","msecs",1711980553));
var ms = cljs.core.get.call(null,map__33622__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
if(cljs.core.truth_(cljs.core.mapv.call(null,((function (map__33622,map__33622__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms){
return (function (__in){
var __x = __in;
try{if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Keyword(null,"msecs","msecs",1711980553),null,new cljs.core.Keyword(null,"secs","secs",1532330091),null,new cljs.core.Keyword(null,"months","months",-45571637),null,new cljs.core.Keyword(null,"days","days",-1394072564),null,new cljs.core.Keyword(null,"mins","mins",467369676),null,new cljs.core.Keyword(null,"hours","hours",58380855),null,new cljs.core.Keyword(null,"years","years",-1298579689),null,new cljs.core.Keyword(null,"ms","ms",-1152709733),null,new cljs.core.Keyword(null,"weeks","weeks",1844596125),null], null), null).call(null,__x))){
return __x;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33624){if((e33624 instanceof Error)){
var t = e33624;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",831,"(#{:msecs :secs :months :days :mins :hours :years :ms :weeks} __in)",__x,t);
} else {
throw e33624;

}
}});})(map__33622,map__33622__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms))
,cljs.core.keys.call(null,opts)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have","have",574419306,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Keyword(null,"msecs","msecs",1711980553),null,new cljs.core.Keyword(null,"secs","secs",1532330091),null,new cljs.core.Keyword(null,"months","months",-45571637),null,new cljs.core.Keyword(null,"days","days",-1394072564),null,new cljs.core.Keyword(null,"mins","mins",467369676),null,new cljs.core.Keyword(null,"hours","hours",58380855),null,new cljs.core.Keyword(null,"years","years",-1298579689),null,new cljs.core.Keyword(null,"ms","ms",-1152709733),null,new cljs.core.Keyword(null,"weeks","weeks",1844596125),null], null), null),new cljs.core.Keyword(null,"in","in",-1531184865),cljs.core.list(new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null)))))].join('')));
}

return taoensso.encore.round_STAR_.call(null,(((((((((cljs.core.truth_(years)?(years * (31536000000)):0.0) + (cljs.core.truth_(months)?(months * 2.551392E9):0.0)) + (cljs.core.truth_(weeks)?(weeks * (604800000)):0.0)) + (cljs.core.truth_(days)?(days * (86400000)):0.0)) + (cljs.core.truth_(hours)?(hours * (3600000)):0.0)) + (cljs.core.truth_(mins)?(mins * (60000)):0.0)) + (cljs.core.truth_(secs)?(secs * (1000)):0.0)) + (cljs.core.truth_(msecs)?msecs:0.0)) + (cljs.core.truth_(ms)?ms:0.0)));
});

taoensso.encore.ms.cljs$lang$maxFixedArity = (0);

taoensso.encore.ms.cljs$lang$applyTo = (function (seq33620){
return taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33620));
});
taoensso.encore.secs = cljs.core.comp.call(null,taoensso.encore.ms__GT_secs,taoensso.encore.ms);
/**
 * Like `aget` for JS objects, Ref. https://goo.gl/eze8hY.
 *   Unlike `aget`, returns nil for missing keys instead of throwing.
 */
taoensso.encore.oget = (function taoensso$encore$oget(var_args){
var args33632 = [];
var len__17407__auto___33639 = arguments.length;
var i__17408__auto___33640 = (0);
while(true){
if((i__17408__auto___33640 < len__17407__auto___33639)){
args33632.push((arguments[i__17408__auto___33640]));

var G__33641 = (i__17408__auto___33640 + (1));
i__17408__auto___33640 = G__33641;
continue;
} else {
}
break;
}

var G__33638 = args33632.length;
switch (G__33638) {
case 2:
return taoensso.encore.oget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.encore.oget.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args33632.slice((3)),(0)));
return taoensso.encore.oget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__17426__auto__);

}
});

taoensso.encore.oget.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if(cljs.core.truth_(o)){
return goog.object.get(o,k,null);
} else {
return null;
}
});

taoensso.encore.oget.cljs$core$IFn$_invoke$arity$3 = (function (o,k1,k2){
var temp__4425__auto__ = taoensso.encore.oget.call(null,o,k1);
if(cljs.core.truth_(temp__4425__auto__)){
var o__$1 = temp__4425__auto__;
return goog.object.get(o__$1,k2,null);
} else {
return null;
}
});

taoensso.encore.oget.cljs$core$IFn$_invoke$arity$variadic = (function (o,k1,k2,ks){
var temp__4425__auto__ = taoensso.encore.oget.call(null,o,k1,k2);
if(cljs.core.truth_(temp__4425__auto__)){
var o__$1 = temp__4425__auto__;
return cljs.core.apply.call(null,taoensso.encore.oget,o__$1,ks);
} else {
return null;
}
});

taoensso.encore.oget.cljs$lang$applyTo = (function (seq33633){
var G__33634 = cljs.core.first.call(null,seq33633);
var seq33633__$1 = cljs.core.next.call(null,seq33633);
var G__33635 = cljs.core.first.call(null,seq33633__$1);
var seq33633__$2 = cljs.core.next.call(null,seq33633__$1);
var G__33636 = cljs.core.first.call(null,seq33633__$2);
var seq33633__$3 = cljs.core.next.call(null,seq33633__$2);
return taoensso.encore.oget.cljs$core$IFn$_invoke$arity$variadic(G__33634,G__33635,G__33636,seq33633__$3);
});

taoensso.encore.oget.cljs$lang$maxFixedArity = (3);
taoensso.encore.singleton_QMARK_ = (function taoensso$encore$singleton_QMARK_(coll){
if(cljs.core.counted_QMARK_.call(null,coll)){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,coll),(1));
} else {
return cljs.core.not.call(null,cljs.core.next.call(null,coll));
}
});
taoensso.encore.__GT__QMARK_singleton = (function taoensso$encore$__GT__QMARK_singleton(coll){
if(cljs.core.truth_(taoensso.encore.singleton_QMARK_.call(null,coll))){
var vec__33644 = coll;
var c1 = cljs.core.nth.call(null,vec__33644,(0),null);
return c1;
} else {
return null;
}
});
taoensso.encore.__GT_vec = (function taoensso$encore$__GT_vec(x){
if(cljs.core.vector_QMARK_.call(null,x)){
return x;
} else {
if(cljs.core.sequential_QMARK_.call(null,x)){
return cljs.core.vec.call(null,x);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);

}
}
});
taoensso.encore.vsplit_last = (function taoensso$encore$vsplit_last(v){
var c = cljs.core.count.call(null,v);
if((c > (0))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(((c > (1)))?cljs.core.pop.call(null,v):null),cljs.core.peek.call(null,v)], null);
} else {
return null;
}
});
taoensso.encore.vsplit_first = (function taoensso$encore$vsplit_first(v){
var c = cljs.core.count.call(null,v);
if((c > (0))){
var vec__33646 = v;
var v1 = cljs.core.nth.call(null,vec__33646,(0),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v1,(((c > (1)))?cljs.core.subvec.call(null,v,(1)):null)], null);
} else {
return null;
}
});
taoensso.encore.nnil_set = (function taoensso$encore$nnil_set(x){
return cljs.core.disj.call(null,taoensso.encore.set_STAR_.call(null,x),null);
});
taoensso.encore.conj_some = (function taoensso$encore$conj_some(var_args){
var args33647 = [];
var len__17407__auto___33653 = arguments.length;
var i__17408__auto___33654 = (0);
while(true){
if((i__17408__auto___33654 < len__17407__auto___33653)){
args33647.push((arguments[i__17408__auto___33654]));

var G__33655 = (i__17408__auto___33654 + (1));
i__17408__auto___33654 = G__33655;
continue;
} else {
}
break;
}

var G__33652 = args33647.length;
switch (G__33652) {
case 0:
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args33647.slice((2)),(0)));
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17426__auto__);

}
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2 = (function (coll,_QMARK_x){
if(cljs.core.truth_(taoensso.encore.nnil_QMARK_.call(null,_QMARK_x))){
return cljs.core.conj.call(null,coll,_QMARK_x);
} else {
return coll;
}
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic = (function (coll,_QMARK_x,_QMARK_xs){
return cljs.core.reduce.call(null,taoensso.encore.conj_some,taoensso.encore.conj_some.call(null,coll,_QMARK_x),_QMARK_xs);
});

taoensso.encore.conj_some.cljs$lang$applyTo = (function (seq33648){
var G__33649 = cljs.core.first.call(null,seq33648);
var seq33648__$1 = cljs.core.next.call(null,seq33648);
var G__33650 = cljs.core.first.call(null,seq33648__$1);
var seq33648__$2 = cljs.core.next.call(null,seq33648__$1);
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic(G__33649,G__33650,seq33648__$2);
});

taoensso.encore.conj_some.cljs$lang$maxFixedArity = (2);
/**
 * As `clojure.core/preserving-reduced`
 */
taoensso.encore.preserve_reduced = (function taoensso$encore$preserve_reduced(rf){
return (function (acc,in$){
var result = rf.call(null,acc,in$);
if(cljs.core.reduced_QMARK_.call(null,result)){
return cljs.core.reduced.call(null,result);
} else {
return result;
}
});
});
taoensso.encore.run_kv_BANG_ = (function taoensso$encore$run_kv_BANG_(proc,m){
cljs.core.reduce_kv.call(null,(function (p1__33659_SHARP_,p2__33657_SHARP_,p3__33658_SHARP_){
return proc.call(null,p2__33657_SHARP_,p3__33658_SHARP_);
}),null,m);

return null;
});
taoensso.encore.run_BANG__STAR_ = (function taoensso$encore$run_BANG__STAR_(proc,coll){
cljs.core.reduce.call(null,(function (p1__33661_SHARP_,p2__33660_SHARP_){
return proc.call(null,p2__33660_SHARP_);
}),null,coll);

return null;
});
/**
 * Faster `some` based on `reduce`
 */
taoensso.encore.rsome = (function taoensso$encore$rsome(pred,coll){
return cljs.core.reduce.call(null,(function (acc,in$){
var temp__4425__auto__ = pred.call(null,in$);
if(cljs.core.truth_(temp__4425__auto__)){
var p = temp__4425__auto__;
return cljs.core.reduced.call(null,p);
} else {
return null;
}
}),null,coll);
});
/**
 * Faster `every?` based on `reduce`
 */
taoensso.encore.revery_QMARK_ = (function taoensso$encore$revery_QMARK_(pred,coll){
return cljs.core.reduce.call(null,(function (acc,in$){
if(cljs.core.truth_(pred.call(null,in$))){
return true;
} else {
return cljs.core.reduced.call(null,false);
}
}),true,coll);
});
/**
 * Like `update-in` but faster, more flexible, and simpler (less ambiguous)
 */
taoensso.encore.update_in_STAR_ = (function taoensso$encore$update_in_STAR_(m,ks,f){
if(cljs.core.empty_QMARK_.call(null,ks)){
return f.call(null,m);
} else {
var vec__33663 = ks;
var k = cljs.core.nth.call(null,vec__33663,(0),null);
var ks__$1 = cljs.core.nthnext.call(null,vec__33663,(1));
if(cljs.core.truth_(ks__$1)){
return cljs.core.assoc.call(null,m,k,taoensso$encore$update_in_STAR_.call(null,cljs.core.get.call(null,m,k),ks__$1,f));
} else {
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k)));
}
}
});
taoensso.encore.translate_signed_idx = (function taoensso$encore$translate_signed_idx(signed_idx,max_idx){
if((signed_idx >= (0))){
var x__16687__auto__ = signed_idx;
var y__16688__auto__ = max_idx;
return ((x__16687__auto__ < y__16688__auto__) ? x__16687__auto__ : y__16688__auto__);
} else {
var x__16680__auto__ = (0);
var y__16681__auto__ = (signed_idx + max_idx);
return ((x__16680__auto__ > y__16681__auto__) ? x__16680__auto__ : y__16681__auto__);
}
});
/**
 * Returns [<inclusive-start-idx*> <exclusive-end-idx*>] for counted 0-indexed
 *   input (str, vec, etc.) with support for:
 *  * Clamping of indexes beyond limits.
 *  * Max-length -> end-index.
 *  * -ive indexes (as +ive indexes but work from back of input):
 *    (+0) (+1) (+2) (+3) (+4)  ; inclusive +ive indexes
 *      h    e    l    l    o   ; 5 count
 *    (-5) (-4) (-3) (-2) (-1)  ; inclusive -ive indexes
 */
taoensso.encore.sub_indexes = (function taoensso$encore$sub_indexes(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33671 = arguments.length;
var i__17408__auto___33672 = (0);
while(true){
if((i__17408__auto___33672 < len__17407__auto___33671)){
args__17414__auto__.push((arguments[i__17408__auto___33672]));

var G__33673 = (i__17408__auto___33672 + (1));
i__17408__auto___33672 = G__33673;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((2) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((2)),(0))):null);
return taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17415__auto__);
});

taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic = (function (x,start_idx,p__33667){
var map__33668 = p__33667;
var map__33668__$1 = ((((!((map__33668 == null)))?((((map__33668.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33668.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33668):map__33668);
var max_len = cljs.core.get.call(null,map__33668__$1,new cljs.core.Keyword(null,"max-len","max-len",-18846016));
var end_idx = cljs.core.get.call(null,map__33668__$1,new cljs.core.Keyword(null,"end-idx","end-idx",-85750788));
if(cljs.core.truth_((function (){var __x = max_len;
try{if(cljs.core.truth_(taoensso.encore._invar_pred.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"or","or",235744169),cljs.core.nil_QMARK_,taoensso.encore.nneg_int_QMARK_], null)).call(null,__x))){
return true;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33670){if((e33670 instanceof Error)){
var t = e33670;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",977,"([:or nil? nneg-int?] max-len)",__x,t);
} else {
throw e33670;

}
}})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"or","or",235744169),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"nneg-int?","nneg-int?",803479360,null)], null),new cljs.core.Symbol(null,"max-len","max-len",1621685511,null))))].join('')));
}

var start_idx__$1 = start_idx;
var xlen = cljs.core.count.call(null,x);
var start_idx_STAR_ = taoensso.encore.translate_signed_idx.call(null,start_idx__$1,xlen);
var end_idx_STAR_ = cljs.core.long$.call(null,(cljs.core.truth_(max_len)?(function (){var n1__30236__auto__ = (start_idx_STAR_ + max_len);
var n2__30237__auto__ = xlen;
if((n1__30236__auto__ > n2__30237__auto__)){
return n2__30237__auto__;
} else {
return n1__30236__auto__;
}
})():(cljs.core.truth_(end_idx)?(taoensso.encore.translate_signed_idx.call(null,end_idx,xlen) + (1)):xlen
)));
if((start_idx_STAR_ > end_idx_STAR_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_idx_STAR_,end_idx_STAR_], null);
}
});

taoensso.encore.sub_indexes.cljs$lang$maxFixedArity = (2);

taoensso.encore.sub_indexes.cljs$lang$applyTo = (function (seq33664){
var G__33665 = cljs.core.first.call(null,seq33664);
var seq33664__$1 = cljs.core.next.call(null,seq33664);
var G__33666 = cljs.core.first.call(null,seq33664__$1);
var seq33664__$2 = cljs.core.next.call(null,seq33664__$1);
return taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(G__33665,G__33666,seq33664__$2);
});
/**
 * Like `subvec` but uses `sub-indexes`
 */
taoensso.encore.subvec_STAR_ = (function taoensso$encore$subvec_STAR_(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33681 = arguments.length;
var i__17408__auto___33682 = (0);
while(true){
if((i__17408__auto___33682 < len__17407__auto___33681)){
args__17414__auto__.push((arguments[i__17408__auto___33682]));

var G__33683 = (i__17408__auto___33682 + (1));
i__17408__auto___33682 = G__33683;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((2) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((2)),(0))):null);
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17415__auto__);
});

taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (v,start_idx,p__33677){
var vec__33678 = p__33677;
var _QMARK_max_len = cljs.core.nth.call(null,vec__33678,(0),null);
if(cljs.core.truth_((function (){var __x = v;
try{if(cljs.core.vector_QMARK_.call(null,__x)){
return true;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33679){if((e33679 instanceof Error)){
var t = e33679;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1014,"(vector? v)",__x,t);
} else {
throw e33679;

}
}})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.Symbol(null,"vector?","vector?",-61367869,null),new cljs.core.Symbol(null,"v","v",1661996586,null))))].join('')));
}

var vec__33680 = taoensso.encore.sub_indexes.call(null,v,start_idx,new cljs.core.Keyword(null,"max-len","max-len",-18846016),_QMARK_max_len);
var start_idx_STAR_ = cljs.core.nth.call(null,vec__33680,(0),null);
var end_idx_STAR_ = cljs.core.nth.call(null,vec__33680,(1),null);
return cljs.core.subvec.call(null,v,start_idx_STAR_,end_idx_STAR_);
});

taoensso.encore.subvec_STAR_.cljs$lang$maxFixedArity = (2);

taoensso.encore.subvec_STAR_.cljs$lang$applyTo = (function (seq33674){
var G__33675 = cljs.core.first.call(null,seq33674);
var seq33674__$1 = cljs.core.next.call(null,seq33674);
var G__33676 = cljs.core.first.call(null,seq33674__$1);
var seq33674__$2 = cljs.core.next.call(null,seq33674__$1);
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__33675,G__33676,seq33674__$2);
});
taoensso.encore.into_BANG_ = (function taoensso$encore$into_BANG_(var_args){
var args33688 = [];
var len__17407__auto___33691 = arguments.length;
var i__17408__auto___33692 = (0);
while(true){
if((i__17408__auto___33692 < len__17407__auto___33691)){
args33688.push((arguments[i__17408__auto___33692]));

var G__33693 = (i__17408__auto___33692 + (1));
i__17408__auto___33692 = G__33693;
continue;
} else {
}
break;
}

var G__33690 = args33688.length;
switch (G__33690) {
case 2:
return taoensso.encore.into_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.encore.into_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33688.length)].join('')));

}
});

taoensso.encore.into_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
return cljs.core.reduce.call(null,cljs.core.conj_BANG_,to,from);
});

taoensso.encore.into_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
return cljs.core.transduce.call(null,xform,cljs.core.conj_BANG_,to,from);
});

taoensso.encore.into_BANG_.cljs$lang$maxFixedArity = 3;
taoensso.encore.sentinel = {};

taoensso.encore.sentinel_QMARK_ = (function taoensso$encore$sentinel_QMARK_(x){
return (x === taoensso.encore.sentinel);
});

taoensso.encore.nil__GT_sentinel = (function taoensso$encore$nil__GT_sentinel(x){
if((x == null)){
return taoensso.encore.sentinel;
} else {
return x;
}
});

taoensso.encore.sentinel__GT_nil = (function taoensso$encore$sentinel__GT_nil(x){
if(cljs.core.truth_(taoensso.encore.sentinel_QMARK_.call(null,x))){
return null;
} else {
return x;
}
});
taoensso.encore.repeatedly_into;
/**
 * Returns a sorted vector of the top n items from coll of N items in O(N.logn)
 *   time. (take n (sort-by ...)) is O(N.logN) time, so much slower when n << N.
 *   Ref. http://stevehanov.ca/blog/index.php?id=122
 */
taoensso.encore.top = (function taoensso$encore$top(var_args){
var args33697 = [];
var len__17407__auto___33700 = arguments.length;
var i__17408__auto___33701 = (0);
while(true){
if((i__17408__auto___33701 < len__17407__auto___33700)){
args33697.push((arguments[i__17408__auto___33701]));

var G__33702 = (i__17408__auto___33701 + (1));
i__17408__auto___33701 = G__33702;
continue;
} else {
}
break;
}

var G__33699 = args33697.length;
switch (G__33699) {
case 2:
return taoensso.encore.top.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.encore.top.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return taoensso.encore.top.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33697.length)].join('')));

}
});

taoensso.encore.top.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return taoensso.encore.top.call(null,n,cljs.core.identity,cljs.core.compare,coll);
});

taoensso.encore.top.cljs$core$IFn$_invoke$arity$3 = (function (n,keyfn,coll){
return taoensso.encore.top.call(null,n,keyfn,cljs.core.compare,coll);
});

taoensso.encore.top.cljs$core$IFn$_invoke$arity$4 = (function (n,keyfn,cmp,coll){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.take.call(null,n),cljs.core.sort_by.call(null,keyfn,cmp,coll));
});

taoensso.encore.top.cljs$lang$maxFixedArity = 4;

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.encore.Swapped = (function (new_val,return_val,__meta,__extmap,__hash){
this.new_val = new_val;
this.return_val = return_val;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.encore.Swapped.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__16963__auto__,k__16964__auto__){
var self__ = this;
var this__16963__auto____$1 = this;
return cljs.core._lookup.call(null,this__16963__auto____$1,k__16964__auto__,null);
});

taoensso.encore.Swapped.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__16965__auto__,k33705,else__16966__auto__){
var self__ = this;
var this__16965__auto____$1 = this;
var G__33707 = (((k33705 instanceof cljs.core.Keyword))?k33705.fqn:null);
switch (G__33707) {
case "new-val":
return self__.new_val;

break;
case "return-val":
return self__.return_val;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k33705,else__16966__auto__);

}
});

taoensso.encore.Swapped.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__16977__auto__,writer__16978__auto__,opts__16979__auto__){
var self__ = this;
var this__16977__auto____$1 = this;
var pr_pair__16980__auto__ = ((function (this__16977__auto____$1){
return (function (keyval__16981__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__16978__auto__,cljs.core.pr_writer,""," ","",opts__16979__auto__,keyval__16981__auto__);
});})(this__16977__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__16978__auto__,pr_pair__16980__auto__,"#taoensso.encore.Swapped{",", ","}",opts__16979__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"new-val","new-val",-738158599),self__.new_val],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"return-val","return-val",-512772489),self__.return_val],null))], null),self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IIterable$ = true;

taoensso.encore.Swapped.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__33704){
var self__ = this;
var G__33704__$1 = this;
return (new cljs.core.RecordIter((0),G__33704__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"new-val","new-val",-738158599),new cljs.core.Keyword(null,"return-val","return-val",-512772489)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

taoensso.encore.Swapped.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__16961__auto__){
var self__ = this;
var this__16961__auto____$1 = this;
return self__.__meta;
});

taoensso.encore.Swapped.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__16957__auto__){
var self__ = this;
var this__16957__auto____$1 = this;
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.encore.Swapped.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__16967__auto__){
var self__ = this;
var this__16967__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__16958__auto__){
var self__ = this;
var this__16958__auto____$1 = this;
var h__16784__auto__ = self__.__hash;
if(!((h__16784__auto__ == null))){
return h__16784__auto__;
} else {
var h__16784__auto____$1 = cljs.core.hash_imap.call(null,this__16958__auto____$1);
self__.__hash = h__16784__auto____$1;

return h__16784__auto____$1;
}
});

taoensso.encore.Swapped.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__16959__auto__,other__16960__auto__){
var self__ = this;
var this__16959__auto____$1 = this;
if(cljs.core.truth_((function (){var and__16337__auto__ = other__16960__auto__;
if(cljs.core.truth_(and__16337__auto__)){
var and__16337__auto____$1 = (this__16959__auto____$1.constructor === other__16960__auto__.constructor);
if(and__16337__auto____$1){
return cljs.core.equiv_map.call(null,this__16959__auto____$1,other__16960__auto__);
} else {
return and__16337__auto____$1;
}
} else {
return and__16337__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.encore.Swapped.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__16972__auto__,k__16973__auto__){
var self__ = this;
var this__16972__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"return-val","return-val",-512772489),null,new cljs.core.Keyword(null,"new-val","new-val",-738158599),null], null), null),k__16973__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__16972__auto____$1),self__.__meta),k__16973__auto__);
} else {
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__16973__auto__)),null));
}
});

taoensso.encore.Swapped.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__16970__auto__,k__16971__auto__,G__33704){
var self__ = this;
var this__16970__auto____$1 = this;
var pred__33708 = cljs.core.keyword_identical_QMARK_;
var expr__33709 = k__16971__auto__;
if(cljs.core.truth_(pred__33708.call(null,new cljs.core.Keyword(null,"new-val","new-val",-738158599),expr__33709))){
return (new taoensso.encore.Swapped(G__33704,self__.return_val,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33708.call(null,new cljs.core.Keyword(null,"return-val","return-val",-512772489),expr__33709))){
return (new taoensso.encore.Swapped(self__.new_val,G__33704,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__16971__auto__,G__33704),null));
}
}
});

taoensso.encore.Swapped.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__16975__auto__){
var self__ = this;
var this__16975__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"new-val","new-val",-738158599),self__.new_val],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"return-val","return-val",-512772489),self__.return_val],null))], null),self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__16962__auto__,G__33704){
var self__ = this;
var this__16962__auto____$1 = this;
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,G__33704,self__.__extmap,self__.__hash));
});

taoensso.encore.Swapped.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__16968__auto__,entry__16969__auto__){
var self__ = this;
var this__16968__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__16969__auto__)){
return cljs.core._assoc.call(null,this__16968__auto____$1,cljs.core._nth.call(null,entry__16969__auto__,(0)),cljs.core._nth.call(null,entry__16969__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__16968__auto____$1,entry__16969__auto__);
}
});

taoensso.encore.Swapped.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-val","new-val",902372928,null),new cljs.core.Symbol(null,"return-val","return-val",1127759038,null)], null);
});

taoensso.encore.Swapped.cljs$lang$type = true;

taoensso.encore.Swapped.cljs$lang$ctorPrSeq = (function (this__16997__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"taoensso.encore/Swapped");
});

taoensso.encore.Swapped.cljs$lang$ctorPrWriter = (function (this__16997__auto__,writer__16998__auto__){
return cljs.core._write.call(null,writer__16998__auto__,"taoensso.encore/Swapped");
});

taoensso.encore.__GT_Swapped = (function taoensso$encore$__GT_Swapped(new_val,return_val){
return (new taoensso.encore.Swapped(new_val,return_val,null,null,null));
});

taoensso.encore.map__GT_Swapped = (function taoensso$encore$map__GT_Swapped(G__33706){
return (new taoensso.encore.Swapped(new cljs.core.Keyword(null,"new-val","new-val",-738158599).cljs$core$IFn$_invoke$arity$1(G__33706),new cljs.core.Keyword(null,"return-val","return-val",-512772489).cljs$core$IFn$_invoke$arity$1(G__33706),null,cljs.core.dissoc.call(null,G__33706,new cljs.core.Keyword(null,"new-val","new-val",-738158599),new cljs.core.Keyword(null,"return-val","return-val",-512772489)),null));
});

taoensso.encore.swapped = (function taoensso$encore$swapped(new_val,return_val){
return (new taoensso.encore.Swapped(new_val,return_val,null,null,null));
});
taoensso.encore.swapped_QMARK_ = (function taoensso$encore$swapped_QMARK_(x){
return (x instanceof taoensso.encore.Swapped);
});
taoensso.encore.swapped_STAR_ = (function taoensso$encore$swapped_STAR_(x){
if(cljs.core.truth_(taoensso.encore.swapped_QMARK_.call(null,x))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"new-val","new-val",-738158599).cljs$core$IFn$_invoke$arity$1(x),new cljs.core.Keyword(null,"return-val","return-val",-512772489).cljs$core$IFn$_invoke$arity$1(x)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,x], null);
}
});
taoensso.encore.dissoc_in;
/**
 * [<new-val> <return-val>]
 */
taoensso.encore.swapped_STAR__in = (function taoensso$encore$swapped_STAR__in(m,ks,f){
if(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,f,new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782)))){
return taoensso.encore.swapped_STAR_.call(null,taoensso.encore.dissoc_in.call(null,m,cljs.core.butlast.call(null,ks),cljs.core.last.call(null,ks)));
} else {
var old_val_in = cljs.core.get_in.call(null,m,ks);
var vec__33713 = taoensso.encore.swapped_STAR_.call(null,f.call(null,old_val_in));
var new_val_in = cljs.core.nth.call(null,vec__33713,(0),null);
var return_val = cljs.core.nth.call(null,vec__33713,(1),null);
var new_val = (cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,new_val_in,new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782)))?taoensso.encore.dissoc_in.call(null,m,cljs.core.butlast.call(null,ks),cljs.core.last.call(null,ks)):cljs.core.assoc_in.call(null,m,ks,new_val_in));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_val,return_val], null);
}
});
/**
 * Reduces input with
 *   [<type> <ks> <reset-val-or-swap-fn>] or
 *       [<ks> <reset-val-or-swap-fn>] ops
 */
taoensso.encore.replace_in_STAR_ = (function taoensso$encore$replace_in_STAR_(_QMARK_vf_type,m,ops){
return cljs.core.reduce.call(null,(function (accum,_QMARK_op){
if(cljs.core.not.call(null,_QMARK_op)){
return accum;
} else {
var vec__33716 = ((cljs.core.not.call(null,_QMARK_vf_type))?_QMARK_op:cljs.core.cons.call(null,_QMARK_vf_type,_QMARK_op));
var vf_type = cljs.core.nth.call(null,vec__33716,(0),null);
var ks = cljs.core.nth.call(null,vec__33716,(1),null);
var valf = cljs.core.nth.call(null,vec__33716,(2),null);
var G__33717 = (((vf_type instanceof cljs.core.Keyword))?vf_type.fqn:null);
switch (G__33717) {
case "reset":
if(cljs.core.empty_QMARK_.call(null,ks)){
return valf;
} else {
return cljs.core.assoc_in.call(null,accum,ks,valf);
}

break;
case "swap":
if((valf == null)){
return accum;
} else {
if(cljs.core.empty_QMARK_.call(null,ks)){
return valf.call(null,accum);
} else {
return cljs.core.nth.call(null,taoensso.encore.swapped_STAR__in.call(null,accum,ks,valf),(0));
}
}

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(vf_type)].join('')));

}
}
}),m,ops);
});
/**
 * Experimental. For use with `swap!`, etc.
 */
taoensso.encore.replace_in = (function taoensso$encore$replace_in(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33721 = arguments.length;
var i__17408__auto___33722 = (0);
while(true){
if((i__17408__auto___33722 < len__17407__auto___33721)){
args__17414__auto__.push((arguments[i__17408__auto___33722]));

var G__33723 = (i__17408__auto___33722 + (1));
i__17408__auto___33722 = G__33723;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,ops){
return taoensso.encore.replace_in_STAR_.call(null,null,m,ops);
});

taoensso.encore.replace_in.cljs$lang$maxFixedArity = (1);

taoensso.encore.replace_in.cljs$lang$applyTo = (function (seq33719){
var G__33720 = cljs.core.first.call(null,seq33719);
var seq33719__$1 = cljs.core.next.call(null,seq33719);
return taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic(G__33720,seq33719__$1);
});
/**
 * More powerful version of `swap!`:
 *  * Supports optional `update-in` semantics.
 *  * Swap fn can return `(swapped <new-val> <return-val>)` rather than just
 *    <new-val>. This is useful when writing atomic pull fns, etc.
 */
taoensso.encore.swap_in_BANG_ = (function taoensso$encore$swap_in_BANG_(var_args){
var args33724 = [];
var len__17407__auto___33735 = arguments.length;
var i__17408__auto___33736 = (0);
while(true){
if((i__17408__auto___33736 < len__17407__auto___33735)){
args33724.push((arguments[i__17408__auto___33736]));

var G__33737 = (i__17408__auto___33736 + (1));
i__17408__auto___33736 = G__33737;
continue;
} else {
}
break;
}

var G__33730 = args33724.length;
switch (G__33730) {
case 3:
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args33724.slice((3)),(0)));
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__17426__auto__);

}
});

taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (atom_,ks,f){
if(cljs.core.empty_QMARK_.call(null,ks)){
while(true){
var old_val = cljs.core.deref.call(null,atom_);
var vec__33731 = taoensso.encore.swapped_STAR_.call(null,f.call(null,old_val));
var new_val = cljs.core.nth.call(null,vec__33731,(0),null);
var return_val = cljs.core.nth.call(null,vec__33731,(1),null);
if(cljs.core.not.call(null,cljs.core.compare_and_set_BANG_.call(null,atom_,old_val,new_val))){
continue;
} else {
return return_val;
}
break;
}
} else {
while(true){
var old_val = cljs.core.deref.call(null,atom_);
var vec__33732 = taoensso.encore.swapped_STAR__in.call(null,old_val,ks,f);
var new_val = cljs.core.nth.call(null,vec__33732,(0),null);
var return_val = cljs.core.nth.call(null,vec__33732,(1),null);
if(cljs.core.not.call(null,cljs.core.compare_and_set_BANG_.call(null,atom_,old_val,new_val))){
continue;
} else {
return return_val;
}
break;
}
}
});

taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (atom_,ks,f,more){
if(cljs.core.truth_((function (){var __x = (function (){try{return cljs.core.count.call(null,more);
}catch (e33733){if((e33733 instanceof Error)){
var t = e33733;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1158,"(even? (count more))",taoensso.encore._invar_undefined_val,t);
} else {
throw e33733;

}
}})();
try{if(cljs.core.even_QMARK_.call(null,__x)){
return true;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33734){if((e33734 instanceof Error)){
var t = e33734;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1158,"(even? (count more))",__x,t);
} else {
throw e33734;

}
}})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"more","more",-418290273,null)))))].join('')));
}

var pairs = cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ks,f], null)], null),cljs.core.partition.call(null,(2),more));
while(true){
var old_val = cljs.core.deref.call(null,atom_);
var new_val = taoensso.encore.replace_in_STAR_.call(null,new cljs.core.Keyword(null,"swap","swap",228675637),old_val,pairs);
if(cljs.core.not.call(null,cljs.core.compare_and_set_BANG_.call(null,atom_,old_val,new_val))){
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"old","old",-1825222690),old_val,new cljs.core.Keyword(null,"new","new",-2085437848),new_val], null);
}
break;
}
});

taoensso.encore.swap_in_BANG_.cljs$lang$applyTo = (function (seq33725){
var G__33726 = cljs.core.first.call(null,seq33725);
var seq33725__$1 = cljs.core.next.call(null,seq33725);
var G__33727 = cljs.core.first.call(null,seq33725__$1);
var seq33725__$2 = cljs.core.next.call(null,seq33725__$1);
var G__33728 = cljs.core.first.call(null,seq33725__$2);
var seq33725__$3 = cljs.core.next.call(null,seq33725__$2);
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33726,G__33727,G__33728,seq33725__$3);
});

taoensso.encore.swap_in_BANG_.cljs$lang$maxFixedArity = (3);
/**
 * Is to `reset!` as `swap-in!` is to `swap!`
 */
taoensso.encore.reset_in_BANG_ = (function taoensso$encore$reset_in_BANG_(var_args){
var args33739 = [];
var len__17407__auto___33748 = arguments.length;
var i__17408__auto___33749 = (0);
while(true){
if((i__17408__auto___33749 < len__17407__auto___33748)){
args33739.push((arguments[i__17408__auto___33749]));

var G__33750 = (i__17408__auto___33749 + (1));
i__17408__auto___33749 = G__33750;
continue;
} else {
}
break;
}

var G__33745 = args33739.length;
switch (G__33745) {
case 3:
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args33739.slice((3)),(0)));
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__17426__auto__);

}
});

taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (atom_,ks,new_val){
if(cljs.core.empty_QMARK_.call(null,ks)){
return cljs.core.reset_BANG_.call(null,atom_,new_val);
} else {
return cljs.core.swap_BANG_.call(null,atom_,(function (old_val){
return cljs.core.assoc_in.call(null,old_val,ks,new_val);
}));
}
});

taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (atom_,ks,new_val,more){
if(cljs.core.truth_((function (){var __x = (function (){try{return cljs.core.count.call(null,more);
}catch (e33746){if((e33746 instanceof Error)){
var t = e33746;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1174,"(even? (count more))",taoensso.encore._invar_undefined_val,t);
} else {
throw e33746;

}
}})();
try{if(cljs.core.even_QMARK_.call(null,__x)){
return true;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33747){if((e33747 instanceof Error)){
var t = e33747;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1174,"(even? (count more))",__x,t);
} else {
throw e33747;

}
}})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"more","more",-418290273,null)))))].join('')));
}

var pairs = cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ks,new_val], null)], null),cljs.core.partition.call(null,(2),more));
while(true){
var old_val = cljs.core.deref.call(null,atom_);
var new_val__$1 = taoensso.encore.replace_in_STAR_.call(null,new cljs.core.Keyword(null,"reset","reset",-800929946),old_val,pairs);
if(cljs.core.not.call(null,cljs.core.compare_and_set_BANG_.call(null,atom_,old_val,new_val__$1))){
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"old","old",-1825222690),old_val,new cljs.core.Keyword(null,"new","new",-2085437848),new_val__$1], null);
}
break;
}
});

taoensso.encore.reset_in_BANG_.cljs$lang$applyTo = (function (seq33740){
var G__33741 = cljs.core.first.call(null,seq33740);
var seq33740__$1 = cljs.core.next.call(null,seq33740);
var G__33742 = cljs.core.first.call(null,seq33740__$1);
var seq33740__$2 = cljs.core.next.call(null,seq33740__$1);
var G__33743 = cljs.core.first.call(null,seq33740__$2);
var seq33740__$3 = cljs.core.next.call(null,seq33740__$2);
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33741,G__33742,G__33743,seq33740__$3);
});

taoensso.encore.reset_in_BANG_.cljs$lang$maxFixedArity = (3);
taoensso.encore.contains_in_QMARK_ = (function taoensso$encore$contains_in_QMARK_(coll,ks){
return cljs.core.contains_QMARK_.call(null,cljs.core.get_in.call(null,coll,cljs.core.butlast.call(null,ks)),cljs.core.last.call(null,ks));
});
taoensso.encore.dissoc_in = (function taoensso$encore$dissoc_in(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33755 = arguments.length;
var i__17408__auto___33756 = (0);
while(true){
if((i__17408__auto___33756 < len__17407__auto___33755)){
args__17414__auto__.push((arguments[i__17408__auto___33756]));

var G__33757 = (i__17408__auto___33756 + (1));
i__17408__auto___33756 = G__33757;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((2) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((2)),(0))):null);
return taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17415__auto__);
});

taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,ks,dissoc_ks){
return taoensso.encore.update_in_STAR_.call(null,m,ks,(function (m__$1){
return cljs.core.apply.call(null,cljs.core.dissoc,m__$1,dissoc_ks);
}));
});

taoensso.encore.dissoc_in.cljs$lang$maxFixedArity = (2);

taoensso.encore.dissoc_in.cljs$lang$applyTo = (function (seq33752){
var G__33753 = cljs.core.first.call(null,seq33752);
var seq33752__$1 = cljs.core.next.call(null,seq33752);
var G__33754 = cljs.core.first.call(null,seq33752__$1);
var seq33752__$2 = cljs.core.next.call(null,seq33752__$1);
return taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic(G__33753,G__33754,seq33752__$2);
});
/**
 * Assocs each kv iff its value is not nil
 */
taoensso.encore.assoc_some = (function taoensso$encore$assoc_some(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33770 = arguments.length;
var i__17408__auto___33771 = (0);
while(true){
if((i__17408__auto___33771 < len__17407__auto___33770)){
args__17414__auto__.push((arguments[i__17408__auto___33771]));

var G__33772 = (i__17408__auto___33771 + (1));
i__17408__auto___33771 = G__33772;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if(cljs.core.truth_((function (){var __x = (function (){try{return cljs.core.count.call(null,kvs);
}catch (e33760){if((e33760 instanceof Error)){
var t = e33760;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1224,"(even? (count kvs))",taoensso.encore._invar_undefined_val,t);
} else {
throw e33760;

}
}})();
try{if(cljs.core.even_QMARK_.call(null,__x)){
return true;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33761){if((e33761 instanceof Error)){
var t = e33761;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1224,"(even? (count kvs))",__x,t);
} else {
throw e33761;

}
}})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

return cljs.core.into.call(null,(function (){var or__16349__auto__ = m;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__17121__auto__ = (function taoensso$encore$iter__33762(s__33763){
return (new cljs.core.LazySeq(null,(function (){
var s__33763__$1 = s__33763;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__33763__$1);
if(temp__4425__auto__){
var s__33763__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33763__$2)){
var c__17119__auto__ = cljs.core.chunk_first.call(null,s__33763__$2);
var size__17120__auto__ = cljs.core.count.call(null,c__17119__auto__);
var b__33765 = cljs.core.chunk_buffer.call(null,size__17120__auto__);
if((function (){var i__33764 = (0);
while(true){
if((i__33764 < size__17120__auto__)){
var vec__33768 = cljs.core._nth.call(null,c__17119__auto__,i__33764);
var k = cljs.core.nth.call(null,vec__33768,(0),null);
var v = cljs.core.nth.call(null,vec__33768,(1),null);
if(!((v == null))){
cljs.core.chunk_append.call(null,b__33765,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__33773 = (i__33764 + (1));
i__33764 = G__33773;
continue;
} else {
var G__33774 = (i__33764 + (1));
i__33764 = G__33774;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33765),taoensso$encore$iter__33762.call(null,cljs.core.chunk_rest.call(null,s__33763__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33765),null);
}
} else {
var vec__33769 = cljs.core.first.call(null,s__33763__$2);
var k = cljs.core.nth.call(null,vec__33769,(0),null);
var v = cljs.core.nth.call(null,vec__33769,(1),null);
if(!((v == null))){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),taoensso$encore$iter__33762.call(null,cljs.core.rest.call(null,s__33763__$2)));
} else {
var G__33775 = cljs.core.rest.call(null,s__33763__$2);
s__33763__$1 = G__33775;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__17121__auto__.call(null,cljs.core.partition.call(null,(2),kvs));
})());
});

taoensso.encore.assoc_some.cljs$lang$maxFixedArity = (1);

taoensso.encore.assoc_some.cljs$lang$applyTo = (function (seq33758){
var G__33759 = cljs.core.first.call(null,seq33758);
var seq33758__$1 = cljs.core.next.call(null,seq33758);
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic(G__33759,seq33758__$1);
});
/**
 * Assocs each kv iff its val is truthy
 */
taoensso.encore.assoc_when = (function taoensso$encore$assoc_when(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33788 = arguments.length;
var i__17408__auto___33789 = (0);
while(true){
if((i__17408__auto___33789 < len__17407__auto___33788)){
args__17414__auto__.push((arguments[i__17408__auto___33789]));

var G__33790 = (i__17408__auto___33789 + (1));
i__17408__auto___33789 = G__33790;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if(cljs.core.truth_((function (){var __x = (function (){try{return cljs.core.count.call(null,kvs);
}catch (e33778){if((e33778 instanceof Error)){
var t = e33778;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1228,"(even? (count kvs))",taoensso.encore._invar_undefined_val,t);
} else {
throw e33778;

}
}})();
try{if(cljs.core.even_QMARK_.call(null,__x)){
return true;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33779){if((e33779 instanceof Error)){
var t = e33779;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1228,"(even? (count kvs))",__x,t);
} else {
throw e33779;

}
}})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

return cljs.core.into.call(null,(function (){var or__16349__auto__ = m;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__17121__auto__ = (function taoensso$encore$iter__33780(s__33781){
return (new cljs.core.LazySeq(null,(function (){
var s__33781__$1 = s__33781;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__33781__$1);
if(temp__4425__auto__){
var s__33781__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33781__$2)){
var c__17119__auto__ = cljs.core.chunk_first.call(null,s__33781__$2);
var size__17120__auto__ = cljs.core.count.call(null,c__17119__auto__);
var b__33783 = cljs.core.chunk_buffer.call(null,size__17120__auto__);
if((function (){var i__33782 = (0);
while(true){
if((i__33782 < size__17120__auto__)){
var vec__33786 = cljs.core._nth.call(null,c__17119__auto__,i__33782);
var k = cljs.core.nth.call(null,vec__33786,(0),null);
var v = cljs.core.nth.call(null,vec__33786,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append.call(null,b__33783,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__33791 = (i__33782 + (1));
i__33782 = G__33791;
continue;
} else {
var G__33792 = (i__33782 + (1));
i__33782 = G__33792;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33783),taoensso$encore$iter__33780.call(null,cljs.core.chunk_rest.call(null,s__33781__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33783),null);
}
} else {
var vec__33787 = cljs.core.first.call(null,s__33781__$2);
var k = cljs.core.nth.call(null,vec__33787,(0),null);
var v = cljs.core.nth.call(null,vec__33787,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),taoensso$encore$iter__33780.call(null,cljs.core.rest.call(null,s__33781__$2)));
} else {
var G__33793 = cljs.core.rest.call(null,s__33781__$2);
s__33781__$1 = G__33793;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__17121__auto__.call(null,cljs.core.partition.call(null,(2),kvs));
})());
});

taoensso.encore.assoc_when.cljs$lang$maxFixedArity = (1);

taoensso.encore.assoc_when.cljs$lang$applyTo = (function (seq33776){
var G__33777 = cljs.core.first.call(null,seq33776);
var seq33776__$1 = cljs.core.next.call(null,seq33776);
return taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic(G__33777,seq33776__$1);
});
taoensso.encore.queue_QMARK_ = (function taoensso$encore$queue_QMARK_(x){
return (x instanceof cljs.core.PersistentQueue);
});
/**
 * Returns a PersistentQueue
 */
taoensso.encore.queue = (function taoensso$encore$queue(var_args){
var args33794 = [];
var len__17407__auto___33797 = arguments.length;
var i__17408__auto___33798 = (0);
while(true){
if((i__17408__auto___33798 < len__17407__auto___33797)){
args33794.push((arguments[i__17408__auto___33798]));

var G__33799 = (i__17408__auto___33798 + (1));
i__17408__auto___33798 = G__33799;
continue;
} else {
}
break;
}

var G__33796 = args33794.length;
switch (G__33796) {
case 1:
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33794.length)].join('')));

}
});

taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.into.call(null,taoensso.encore.queue.call(null),coll);
});

taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentQueue.EMPTY;
});

taoensso.encore.queue.cljs$lang$maxFixedArity = 1;
taoensso.encore.queue_STAR_ = (function taoensso$encore$queue_STAR_(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33802 = arguments.length;
var i__17408__auto___33803 = (0);
while(true){
if((i__17408__auto___33803 < len__17407__auto___33802)){
args__17414__auto__.push((arguments[i__17408__auto___33803]));

var G__33804 = (i__17408__auto___33803 + (1));
i__17408__auto___33803 = G__33804;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((0) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((0)),(0))):null);
return taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__17415__auto__);
});

taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (items){
return taoensso.encore.queue.call(null,items);
});

taoensso.encore.queue_STAR_.cljs$lang$maxFixedArity = (0);

taoensso.encore.queue_STAR_.cljs$lang$applyTo = (function (seq33801){
return taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33801));
});
/**
 * (seq     {:a :A}) => ([:a :A])
 * (seq-kvs {:a :A}) => (:a :A)
 */
taoensso.encore.seq_kvs = cljs.core.partial.call(null,cljs.core.reduce,cljs.core.concat);
/**
 * Like `apply` but assumes last arg is a map whose elements should be applied
 *   to `f` as an unpaired seq:
 *  (mapply (fn [x & {:keys [y z]}] (str x y z)) 1 {:y 2 :z 3})
 *    where fn will receive args as: `(1 :y 2 :z 3)`.
 */
taoensso.encore.mapply = (function taoensso$encore$mapply(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33807 = arguments.length;
var i__17408__auto___33808 = (0);
while(true){
if((i__17408__auto___33808 < len__17407__auto___33807)){
args__17414__auto__.push((arguments[i__17408__auto___33808]));

var G__33809 = (i__17408__auto___33808 + (1));
i__17408__auto___33808 = G__33809;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.call(null,f,cljs.core.concat.call(null,cljs.core.butlast.call(null,args),taoensso.encore.seq_kvs.call(null,cljs.core.last.call(null,args))));
});

taoensso.encore.mapply.cljs$lang$maxFixedArity = (1);

taoensso.encore.mapply.cljs$lang$applyTo = (function (seq33805){
var G__33806 = cljs.core.first.call(null,seq33805);
var seq33805__$1 = cljs.core.next.call(null,seq33805);
return taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic(G__33806,seq33805__$1);
});
taoensso.encore.map_kvs = (function taoensso$encore$map_kvs(kf,vf,m){
if(cljs.core.not.call(null,m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var vf__$1 = (((vf == null))?(function (_,v){
return v;
}):vf
);
var kf__$1 = (((kf == null))?((function (vf__$1){
return (function (k,_){
return k;
});})(vf__$1))
:(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,kf,new cljs.core.Keyword(null,"keywordize","keywordize",1381210758)))?((function (vf__$1){
return (function (k,_){
return cljs.core.keyword.call(null,k);
});})(vf__$1))
:kf
));
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,((function (vf__$1,kf__$1){
return (function (m__$1,k,v){
return cljs.core.assoc_BANG_.call(null,m__$1,kf__$1.call(null,k,v),vf__$1.call(null,k,v));
});})(vf__$1,kf__$1))
,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
}
});
taoensso.encore.map_vals = (function taoensso$encore$map_vals(f,m){
return taoensso.encore.map_kvs.call(null,null,(function (_,v){
return f.call(null,v);
}),m);
});
taoensso.encore.map_keys = (function taoensso$encore$map_keys(f,m){
return taoensso.encore.map_kvs.call(null,(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,f,new cljs.core.Keyword(null,"keywordize","keywordize",1381210758)))?new cljs.core.Keyword(null,"keywordize","keywordize",1381210758):(function (k,_){
return f.call(null,k);
})),null,m);
});
taoensso.encore.filter_kvs = (function taoensso$encore$filter_kvs(predk,predv,m){
if(cljs.core.not.call(null,m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv.call(null,(function (m__$1,k,v){
if(cljs.core.truth_((function (){var and__16337__auto__ = predk.call(null,k);
if(cljs.core.truth_(and__16337__auto__)){
return predv.call(null,v);
} else {
return and__16337__auto__;
}
})())){
return m__$1;
} else {
return cljs.core.dissoc.call(null,m__$1,k);
}
}),m,m);
}
});
taoensso.encore.filter_keys = (function taoensso$encore$filter_keys(pred,m){
return taoensso.encore.filter_kvs.call(null,pred,cljs.core.constantly.call(null,true),m);
});
taoensso.encore.filter_vals = (function taoensso$encore$filter_vals(pred,m){
return taoensso.encore.filter_kvs.call(null,cljs.core.constantly.call(null,true),pred,m);
});
/**
 * Smaller, common-case version of `filter-vals`. Esp useful with `nil?`/`blank?`
 *   pred when constructing maps: {:foo (when _ <...>) :bar (when _ <...>)} in a
 *   way that preservers :or semantics.
 */
taoensso.encore.remove_vals = (function taoensso$encore$remove_vals(pred,m){
if(cljs.core.not.call(null,m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv.call(null,(function (m__$1,k,v){
if(cljs.core.truth_(pred.call(null,v))){
return cljs.core.dissoc.call(null,m__$1,k);
} else {
return m__$1;
}
}),m,m);
}
});
taoensso.encore.keywordize_map = (function taoensso$encore$keywordize_map(m){
if(cljs.core.not.call(null,m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv.call(null,(function (m__$1,k,v){
return cljs.core.assoc.call(null,m__$1,cljs.core.keyword.call(null,k),v);
}),cljs.core.PersistentArrayMap.EMPTY,m);
}
});
taoensso.encore.as_map_STAR_ = (function taoensso$encore$as_map_STAR_(kf,vf,kvs){
return cljs.core.transduce.call(null,cljs.core.partition_all.call(null,(2)),cljs.core.completing.call(null,(function (acc,p__33816){
var vec__33817 = p__33816;
var k = cljs.core.nth.call(null,vec__33817,(0),null);
var v = cljs.core.nth.call(null,vec__33817,(1),null);
return cljs.core.assoc_BANG_.call(null,acc,kf.call(null,k,v),vf.call(null,k,v));
}),cljs.core.persistent_BANG_),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),kvs);
});
/**
 * Cross between `hash-map` & `map-kvs`
 */
taoensso.encore.as_map = (function taoensso$encore$as_map(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33822 = arguments.length;
var i__17408__auto___33823 = (0);
while(true){
if((i__17408__auto___33823 < len__17407__auto___33822)){
args__17414__auto__.push((arguments[i__17408__auto___33823]));

var G__33824 = (i__17408__auto___33823 + (1));
i__17408__auto___33823 = G__33824;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic = (function (kvs,p__33820){
var vec__33821 = p__33820;
var kf = cljs.core.nth.call(null,vec__33821,(0),null);
var vf = cljs.core.nth.call(null,vec__33821,(1),null);
if(cljs.core.empty_QMARK_.call(null,kvs)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var vf__$1 = (((vf == null))?((function (vec__33821,kf,vf){
return (function (_,v){
return v;
});})(vec__33821,kf,vf))
:vf
);
var kf__$1 = (((kf == null))?((function (vf__$1,vec__33821,kf,vf){
return (function (k,_){
return k;
});})(vf__$1,vec__33821,kf,vf))
:(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,kf,new cljs.core.Keyword(null,"keywordize","keywordize",1381210758)))?((function (vf__$1,vec__33821,kf,vf){
return (function (k,_){
return cljs.core.keyword.call(null,k);
});})(vf__$1,vec__33821,kf,vf))
:kf
));
return taoensso.encore.as_map_STAR_.call(null,kf__$1,vf__$1,kvs);
}
});

taoensso.encore.as_map.cljs$lang$maxFixedArity = (1);

taoensso.encore.as_map.cljs$lang$applyTo = (function (seq33818){
var G__33819 = cljs.core.first.call(null,seq33818);
var seq33818__$1 = cljs.core.next.call(null,seq33818);
return taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic(G__33819,seq33818__$1);
});
/**
 * Faster `zipmap` using transients
 */
taoensso.encore.fzipmap = (function taoensso$encore$fzipmap(ks,vs){
var m = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ks__$1 = cljs.core.seq.call(null,ks);
var vs__$1 = cljs.core.seq.call(null,vs);
while(true){
if(!((ks__$1) && (vs__$1))){
return cljs.core.persistent_BANG_.call(null,m);
} else {
var G__33825 = cljs.core.assoc_BANG_.call(null,m,cljs.core.first.call(null,ks__$1),cljs.core.first.call(null,vs__$1));
var G__33826 = cljs.core.next.call(null,ks__$1);
var G__33827 = cljs.core.next.call(null,vs__$1);
m = G__33825;
ks__$1 = G__33826;
vs__$1 = G__33827;
continue;
}
break;
}
});
/**
 * Like `into` but supports multiple "from"s
 */
taoensso.encore.into_all = (function taoensso$encore$into_all(var_args){
var args33828 = [];
var len__17407__auto___33834 = arguments.length;
var i__17408__auto___33835 = (0);
while(true){
if((i__17408__auto___33835 < len__17407__auto___33834)){
args33828.push((arguments[i__17408__auto___33835]));

var G__33836 = (i__17408__auto___33835 + (1));
i__17408__auto___33835 = G__33836;
continue;
} else {
}
break;
}

var G__33833 = args33828.length;
switch (G__33833) {
case 2:
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args33828.slice((2)),(0)));
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17426__auto__);

}
});

taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
return cljs.core.into.call(null,to,from);
});

taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic = (function (to,from,more){
return cljs.core.reduce.call(null,cljs.core.into,cljs.core.into.call(null,to,from),more);
});

taoensso.encore.into_all.cljs$lang$applyTo = (function (seq33829){
var G__33830 = cljs.core.first.call(null,seq33829);
var seq33829__$1 = cljs.core.next.call(null,seq33829);
var G__33831 = cljs.core.first.call(null,seq33829__$1);
var seq33829__$2 = cljs.core.next.call(null,seq33829__$1);
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic(G__33830,G__33831,seq33829__$2);
});

taoensso.encore.into_all.cljs$lang$maxFixedArity = (2);
/**
 * Greedy version of `interleave`, Ref. http://goo.gl/KvzqWb
 */
taoensso.encore.interleave_all = (function taoensso$encore$interleave_all(var_args){
var args33838 = [];
var len__17407__auto___33844 = arguments.length;
var i__17408__auto___33845 = (0);
while(true){
if((i__17408__auto___33845 < len__17407__auto___33844)){
args33838.push((arguments[i__17408__auto___33845]));

var G__33846 = (i__17408__auto___33845 + (1));
i__17408__auto___33845 = G__33846;
continue;
} else {
}
break;
}

var G__33843 = args33838.length;
switch (G__33843) {
case 0:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args33838.slice((2)),(0)));
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17426__auto__);

}
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.List.EMPTY;
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$1 = (function (c1){
return (new cljs.core.LazySeq(null,(function (){
return c1;
}),null,null));
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq.call(null,c1);
var s2 = cljs.core.seq.call(null,c2);
if((s1) && (s2)){
return cljs.core.cons.call(null,cljs.core.first.call(null,s1),cljs.core.cons.call(null,cljs.core.first.call(null,s2),taoensso.encore.interleave_all.call(null,cljs.core.rest.call(null,s1),cljs.core.rest.call(null,s2))));
} else {
if(s1){
return s1;
} else {
if(s2){
return s2;
} else {
return null;
}
}
}
}),null,null));
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.seq,cljs.core.conj.call(null,colls,c2,c1)));
return cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.first,ss),cljs.core.apply.call(null,taoensso.encore.interleave_all,cljs.core.map.call(null,cljs.core.rest,ss)));
}),null,null));
});

taoensso.encore.interleave_all.cljs$lang$applyTo = (function (seq33839){
var G__33840 = cljs.core.first.call(null,seq33839);
var seq33839__$1 = cljs.core.next.call(null,seq33839);
var G__33841 = cljs.core.first.call(null,seq33839__$1);
var seq33839__$2 = cljs.core.next.call(null,seq33839__$1);
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic(G__33840,G__33841,seq33839__$2);
});

taoensso.encore.interleave_all.cljs$lang$maxFixedArity = (2);
taoensso.encore.distinct_by = (function taoensso$encore$distinct_by(keyfn,coll){
var step = (function taoensso$encore$distinct_by_$_step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__33854,seen__$1){
while(true){
var vec__33855 = p__33854;
var v = cljs.core.nth.call(null,vec__33855,(0),null);
var xs__$1 = vec__33855;
var temp__4425__auto__ = cljs.core.seq.call(null,xs__$1);
if(temp__4425__auto__){
var s = temp__4425__auto__;
var v_STAR_ = keyfn.call(null,v);
if(cljs.core.contains_QMARK_.call(null,seen__$1,v_STAR_)){
var G__33856 = cljs.core.rest.call(null,s);
var G__33857 = seen__$1;
p__33854 = G__33856;
seen__$1 = G__33857;
continue;
} else {
return cljs.core.cons.call(null,v,taoensso$encore$distinct_by_$_step.call(null,cljs.core.rest.call(null,s),cljs.core.conj.call(null,seen__$1,v_STAR_)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step.call(null,coll,cljs.core.PersistentHashSet.EMPTY);
});
taoensso.encore.xdistinct = (function taoensso$encore$xdistinct(var_args){
var args33862 = [];
var len__17407__auto___33865 = arguments.length;
var i__17408__auto___33866 = (0);
while(true){
if((i__17408__auto___33866 < len__17407__auto___33865)){
args33862.push((arguments[i__17408__auto___33866]));

var G__33867 = (i__17408__auto___33866 + (1));
i__17408__auto___33866 = G__33867;
continue;
} else {
}
break;
}

var G__33864 = args33862.length;
switch (G__33864) {
case 0:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33862.length)].join('')));

}
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.distinct.call(null);
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (function (rf){
var seen_ = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
return ((function (seen_){
return (function() {
var G__33869 = null;
var G__33869__0 = (function (){
return rf.call(null);
});
var G__33869__1 = (function (acc){
return rf.call(null,acc);
});
var G__33869__2 = (function (acc,input){
var k = keyfn.call(null,input);
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,seen_),k)){
return acc;
} else {
cljs.core._vreset_BANG_.call(null,seen_,cljs.core.conj.call(null,cljs.core._deref.call(null,seen_),k));

return rf.call(null,acc,input);
}
});
G__33869 = function(acc,input){
switch(arguments.length){
case 0:
return G__33869__0.call(this);
case 1:
return G__33869__1.call(this,acc);
case 2:
return G__33869__2.call(this,acc,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33869.cljs$core$IFn$_invoke$arity$0 = G__33869__0;
G__33869.cljs$core$IFn$_invoke$arity$1 = G__33869__1;
G__33869.cljs$core$IFn$_invoke$arity$2 = G__33869__2;
return G__33869;
})()
;})(seen_))
});
});

taoensso.encore.xdistinct.cljs$lang$maxFixedArity = 1;
taoensso.encore.takev = (function taoensso$encore$takev(n,coll){
if(cljs.core.vector_QMARK_.call(null,coll)){
return taoensso.encore.subvec_STAR_.call(null,coll,(0),n);
} else {
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.take.call(null,n),coll);
}
});
taoensso.encore.removev = (function taoensso$encore$removev(pred,coll){
return cljs.core.filterv.call(null,cljs.core.complement.call(null,pred),coll);
});
taoensso.encore.distinctv = (function taoensso$encore$distinctv(var_args){
var args33874 = [];
var len__17407__auto___33879 = arguments.length;
var i__17408__auto___33880 = (0);
while(true){
if((i__17408__auto___33880 < len__17407__auto___33879)){
args33874.push((arguments[i__17408__auto___33880]));

var G__33881 = (i__17408__auto___33880 + (1));
i__17408__auto___33880 = G__33881;
continue;
} else {
}
break;
}

var G__33876 = args33874.length;
switch (G__33876) {
case 1:
return taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33874.length)].join('')));

}
});

taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return taoensso.encore.distinctv.call(null,cljs.core.identity,coll);
});

taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
var tr = cljs.core.reduce.call(null,(function (p__33877,in$){
var vec__33878 = p__33877;
var v = cljs.core.nth.call(null,vec__33878,(0),null);
var seen = cljs.core.nth.call(null,vec__33878,(1),null);
var in_STAR_ = keyfn.call(null,in$);
if(!(cljs.core.contains_QMARK_.call(null,seen,in_STAR_))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj_BANG_.call(null,v,in$),cljs.core.conj.call(null,seen,in_STAR_)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,seen], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY),cljs.core.PersistentHashSet.EMPTY], null),coll);
return cljs.core.persistent_BANG_.call(null,cljs.core.nth.call(null,tr,(0)));
});

taoensso.encore.distinctv.cljs$lang$maxFixedArity = 2;
/**
 * Reverse comparator
 */
taoensso.encore.rcompare = (function taoensso$encore$rcompare(x,y){
return cljs.core.compare.call(null,y,x);
});
taoensso.encore.nested_merge_with = (function taoensso$encore$nested_merge_with(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33885 = arguments.length;
var i__17408__auto___33886 = (0);
while(true){
if((i__17408__auto___33886 < len__17407__auto___33885)){
args__17414__auto__.push((arguments[i__17408__auto___33886]));

var G__33887 = (i__17408__auto___33886 + (1));
i__17408__auto___33886 = G__33887;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.key.call(null,e);
var rv = cljs.core.val.call(null,e);
if(!(cljs.core.contains_QMARK_.call(null,m,k))){
return cljs.core.assoc.call(null,m,k,rv);
} else {
var lv = cljs.core.get.call(null,m,k);
if((cljs.core.map_QMARK_.call(null,lv)) && (cljs.core.map_QMARK_.call(null,rv))){
return cljs.core.assoc.call(null,m,k,taoensso.encore.nested_merge_with.call(null,f,lv,rv));
} else {
return cljs.core.assoc.call(null,m,k,f.call(null,lv,rv));
}
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.call(null,merge_entry,(function (){var or__16349__auto__ = m1;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq.call(null,m2));
});})(merge_entry))
;
return cljs.core.reduce.call(null,merge2,maps);
} else {
return null;
}
});

taoensso.encore.nested_merge_with.cljs$lang$maxFixedArity = (1);

taoensso.encore.nested_merge_with.cljs$lang$applyTo = (function (seq33883){
var G__33884 = cljs.core.first.call(null,seq33883);
var seq33883__$1 = cljs.core.next.call(null,seq33883);
return taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic(G__33884,seq33883__$1);
});
taoensso.encore.nested_merge = cljs.core.partial.call(null,taoensso.encore.nested_merge_with,(function (x,y){
if((cljs.core.map_QMARK_.call(null,x)) && ((y == null))){
return x;
} else {
return y;
}
}));
/**
 * Like `repeatedly` but faster and `conj`s items into given collection
 */
taoensso.encore.repeatedly_into = (function taoensso$encore$repeatedly_into(coll,n,f){
if((function (){var and__16337__auto__ = (n > (10));
if(and__16337__auto__){
if(!((coll == null))){
if(((coll.cljs$lang$protocol_mask$partition1$ & (4))) || (coll.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
} else {
return and__16337__auto__;
}
})()){
var v = cljs.core.transient$.call(null,coll);
var idx = (0);
while(true){
if((idx === n)){
return cljs.core.persistent_BANG_.call(null,v);
} else {
var G__33892 = cljs.core.conj_BANG_.call(null,v,f.call(null));
var G__33893 = (idx + (1));
v = G__33892;
idx = G__33893;
continue;
}
break;
}
} else {
var v = coll;
var idx = (0);
while(true){
if((idx === n)){
return v;
} else {
var G__33894 = cljs.core.conj.call(null,v,f.call(null));
var G__33895 = (idx + (1));
v = G__33894;
idx = G__33895;
continue;
}
break;
}
}
});
taoensso.encore.str_builder_QMARK_ = (function taoensso$encore$str_builder_QMARK_(x){
return (x instanceof goog.string.StringBuffer);
});
/**
 * For cross-platform string building
 */
taoensso.encore.str_builder = (function() {
var taoensso$encore$str_builder = null;
var taoensso$encore$str_builder__0 = (function (){
return (new goog.string.StringBuffer());
});
var taoensso$encore$str_builder__1 = (function (s_init){
return (new goog.string.StringBuffer(s_init));
});
taoensso$encore$str_builder = function(s_init){
switch(arguments.length){
case 0:
return taoensso$encore$str_builder__0.call(this);
case 1:
return taoensso$encore$str_builder__1.call(this,s_init);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$encore$str_builder.cljs$core$IFn$_invoke$arity$0 = taoensso$encore$str_builder__0;
taoensso$encore$str_builder.cljs$core$IFn$_invoke$arity$1 = taoensso$encore$str_builder__1;
return taoensso$encore$str_builder;
})()
;
/**
 * For cross-platform string building
 */
taoensso.encore.sb_append = (function taoensso$encore$sb_append(str_builder,s){
return str_builder.append(s);
});
/**
 * String builder reducing fn
 */
taoensso.encore.str_rf = (function() {
var taoensso$encore$str_rf = null;
var taoensso$encore$str_rf__0 = (function (){
return taoensso.encore.str_builder.call(null);
});
var taoensso$encore$str_rf__1 = (function (acc){
if(cljs.core.truth_(taoensso.encore.str_builder_QMARK_.call(null,acc))){
return acc;
} else {
return taoensso.encore.str_builder.call(null,[cljs.core.str(acc)].join(''));
}
});
var taoensso$encore$str_rf__2 = (function (acc,in$){
return taoensso.encore.sb_append.call(null,(cljs.core.truth_(taoensso.encore.str_builder_QMARK_.call(null,acc))?acc:taoensso.encore.str_builder.call(null,[cljs.core.str(acc)].join(''))),[cljs.core.str(in$)].join(''));
});
taoensso$encore$str_rf = function(acc,in$){
switch(arguments.length){
case 0:
return taoensso$encore$str_rf__0.call(this);
case 1:
return taoensso$encore$str_rf__1.call(this,acc);
case 2:
return taoensso$encore$str_rf__2.call(this,acc,in$);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$encore$str_rf.cljs$core$IFn$_invoke$arity$0 = taoensso$encore$str_rf__0;
taoensso$encore$str_rf.cljs$core$IFn$_invoke$arity$1 = taoensso$encore$str_rf__1;
taoensso$encore$str_rf.cljs$core$IFn$_invoke$arity$2 = taoensso$encore$str_rf__2;
return taoensso$encore$str_rf;
})()
;
taoensso.encore.undefined__GT_nil = (function taoensso$encore$undefined__GT_nil(x){
if((void 0 === x)){
return null;
} else {
return x;
}
});
taoensso.encore.nil__GT_str = (function taoensso$encore$nil__GT_str(x){
if(((void 0 === x)) || ((x == null))){
return "nil";
} else {
return x;
}
});
taoensso.encore.spaced_str_with_nils = (function taoensso$encore$spaced_str_with_nils(xs){
return clojure.string.join.call(null," ",cljs.core.mapv.call(null,taoensso.encore.nil__GT_str,xs));
});
taoensso.encore.spaced_str = (function taoensso$encore$spaced_str(xs){
return clojure.string.join.call(null," ",cljs.core.mapv.call(null,taoensso.encore.undefined__GT_nil,xs));
});
taoensso.encore.format_STAR_ = (function taoensso$encore$format_STAR_(fmt,args){
var fmt__$1 = (function (){var or__16349__auto__ = fmt;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return "";
}
})();
var args__$1 = cljs.core.mapv.call(null,taoensso.encore.nil__GT_str,args);
return cljs.core.apply.call(null,goog.string.format,fmt__$1,args__$1);
});
/**
 * Like `clojure.core/format` but:
 *  * Returns "" when fmt is nil rather than throwing an NPE.
 *  * Formats nil as "nil" rather than "null".
 *  * Provides ClojureScript support via goog.string.format (this has fewer
 *    formatting options than Clojure's `format`!).
 */
taoensso.encore.format = (function taoensso$encore$format(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33898 = arguments.length;
var i__17408__auto___33899 = (0);
while(true){
if((i__17408__auto___33899 < len__17407__auto___33898)){
args__17414__auto__.push((arguments[i__17408__auto___33899]));

var G__33900 = (i__17408__auto___33899 + (1));
i__17408__auto___33899 = G__33900;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return taoensso.encore.format_STAR_.call(null,fmt,args);
});

taoensso.encore.format.cljs$lang$maxFixedArity = (1);

taoensso.encore.format.cljs$lang$applyTo = (function (seq33896){
var G__33897 = cljs.core.first.call(null,seq33896);
var seq33896__$1 = cljs.core.next.call(null,seq33896);
return taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic(G__33897,seq33896__$1);
});
/**
 * Workaround for http://dev.clojure.org/jira/browse/CLJS-794,
 *                http://dev.clojure.org/jira/browse/CLJS-911.
 * 
 *   Note that ClojureScript 1.7.145 technically introduced a breaking "fix" for
 *   CLJS-911 (Ref. https://goo.gl/bk5hcT) but it's a mess in an attempt to keep
 *   some compatibility with the previous broken behaviour. The merged CLJS-911 fix
 *   provides only inconsistent (single-match) and error-prone compatibility with
 *   Clojure's `str/replace`. CLJS-794 is also still unresolved.
 * 
 *   This util provides proper consistent Clojure/Script replace behaviour.
 */
taoensso.encore.str_replace = (function taoensso$encore$str_replace(s,match,replacement){
if(typeof match === 'string'){
return s.replace((new RegExp(goog.string.regExpEscape(match),"g")),replacement);
} else {
if((match instanceof RegExp)){
var flags = [cljs.core.str("g"),cljs.core.str((cljs.core.truth_(match.ignoreCase)?"i":null)),cljs.core.str((cljs.core.truth_(match.multiline)?"m":null))].join('');
var replacement__$1 = ((typeof replacement === 'string')?replacement:((function (flags){
return (function() { 
var G__33901__delegate = function (args){
return replacement.call(null,cljs.core.vec.call(null,args));
};
var G__33901 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33902__i = 0, G__33902__a = new Array(arguments.length -  0);
while (G__33902__i < G__33902__a.length) {G__33902__a[G__33902__i] = arguments[G__33902__i + 0]; ++G__33902__i;}
  args = new cljs.core.IndexedSeq(G__33902__a,0);
} 
return G__33901__delegate.call(this,args);};
G__33901.cljs$lang$maxFixedArity = 0;
G__33901.cljs$lang$applyTo = (function (arglist__33903){
var args = cljs.core.seq(arglist__33903);
return G__33901__delegate(args);
});
G__33901.cljs$core$IFn$_invoke$arity$variadic = G__33901__delegate;
return G__33901;
})()
;})(flags))
);
return s.replace((new RegExp(match.source,flags)),replacement__$1);
} else {
throw [cljs.core.str("Invalid match arg: "),cljs.core.str(match)].join('');

}
}
});
/**
 * Gives a consistent, flexible, cross-platform substring API built on
 *   `sub-indexes`
 */
taoensso.encore.substr = (function taoensso$encore$substr(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33911 = arguments.length;
var i__17408__auto___33912 = (0);
while(true){
if((i__17408__auto___33912 < len__17407__auto___33911)){
args__17414__auto__.push((arguments[i__17408__auto___33912]));

var G__33913 = (i__17408__auto___33912 + (1));
i__17408__auto___33912 = G__33913;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((2) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((2)),(0))):null);
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17415__auto__);
});

taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic = (function (s,start_idx,p__33907){
var vec__33908 = p__33907;
var _QMARK_max_len = cljs.core.nth.call(null,vec__33908,(0),null);
if(cljs.core.truth_((function (){var __x = s;
try{if(typeof __x === 'string'){
return true;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33909){if((e33909 instanceof Error)){
var t = e33909;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1558,"(string? s)",__x,t);
} else {
throw e33909;

}
}})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.Symbol(null,"string?","string?",-1129175764,null),new cljs.core.Symbol(null,"s","s",-948495851,null))))].join('')));
}

var vec__33910 = taoensso.encore.sub_indexes.call(null,s,start_idx,new cljs.core.Keyword(null,"max-len","max-len",-18846016),_QMARK_max_len);
var start_idx_STAR_ = cljs.core.nth.call(null,vec__33910,(0),null);
var end_idx_STAR_ = cljs.core.nth.call(null,vec__33910,(1),null);
return s.substring(start_idx_STAR_,end_idx_STAR_);
});

taoensso.encore.substr.cljs$lang$maxFixedArity = (2);

taoensso.encore.substr.cljs$lang$applyTo = (function (seq33904){
var G__33905 = cljs.core.first.call(null,seq33904);
var seq33904__$1 = cljs.core.next.call(null,seq33904);
var G__33906 = cljs.core.first.call(null,seq33904__$1);
var seq33904__$2 = cljs.core.next.call(null,seq33904__$1);
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(G__33905,G__33906,seq33904__$2);
});
taoensso.encore.str_contains_QMARK_ = (function taoensso$encore$str_contains_QMARK_(s,substr){
return cljs.core.not_EQ_.call(null,(-1),s.indexOf(substr));
});
taoensso.encore.str_starts_with_QMARK_ = (function taoensso$encore$str_starts_with_QMARK_(s,substr){
return (s.indexOf(substr) === (0));
});
taoensso.encore.str_ends_with_QMARK_ = (function taoensso$encore$str_ends_with_QMARK_(s,substr){
var s_len = s.length;
var substr_len = substr.length;
if((s_len >= substr_len)){
return cljs.core.not_EQ_.call(null,(-1),s.indexOf(substr,(s_len - substr_len)));
} else {
return null;
}
});
taoensso.encore.str__QMARK_index = (function taoensso$encore$str__QMARK_index(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33919 = arguments.length;
var i__17408__auto___33920 = (0);
while(true){
if((i__17408__auto___33920 < len__17407__auto___33919)){
args__17414__auto__.push((arguments[i__17408__auto___33920]));

var G__33921 = (i__17408__auto___33920 + (1));
i__17408__auto___33920 = G__33921;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((2) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((2)),(0))):null);
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17415__auto__);
});

taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic = (function (s,substr,p__33917){
var vec__33918 = p__33917;
var start_idx = cljs.core.nth.call(null,vec__33918,(0),null);
var last_QMARK_ = cljs.core.nth.call(null,vec__33918,(1),null);
var start_idx__$1 = ((function (){var or__16349__auto__ = start_idx;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return (0);
}
})() | (0));
var result = ((cljs.core.truth_(last_QMARK_)?s.lastIndexOf(substr,start_idx__$1):s.indexOf(substr,start_idx__$1)) | (0));
if(cljs.core.not_EQ_.call(null,result,(-1))){
return result;
} else {
return null;
}
});

taoensso.encore.str__QMARK_index.cljs$lang$maxFixedArity = (2);

taoensso.encore.str__QMARK_index.cljs$lang$applyTo = (function (seq33914){
var G__33915 = cljs.core.first.call(null,seq33914);
var seq33914__$1 = cljs.core.next.call(null,seq33914);
var G__33916 = cljs.core.first.call(null,seq33914__$1);
var seq33914__$2 = cljs.core.next.call(null,seq33914__$1);
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic(G__33915,G__33916,seq33914__$2);
});
/**
 * Like `clojure.string/join` but ensures no double separators
 */
taoensso.encore.join_once = (function taoensso$encore$join_once(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33924 = arguments.length;
var i__17408__auto___33925 = (0);
while(true){
if((i__17408__auto___33925 < len__17407__auto___33924)){
args__17414__auto__.push((arguments[i__17408__auto___33925]));

var G__33926 = (i__17408__auto___33925 + (1));
i__17408__auto___33925 = G__33926;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic = (function (separator,coll){
return cljs.core.reduce.call(null,(function (s1,s2){
var s1__$1 = [cljs.core.str(s1)].join('');
var s2__$1 = [cljs.core.str(s2)].join('');
if(cljs.core.truth_(taoensso.encore.str_ends_with_QMARK_.call(null,s1__$1,separator))){
if(cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_.call(null,s2__$1,separator))){
return [cljs.core.str(s1__$1),cljs.core.str(s2__$1.substring((1)))].join('');
} else {
return [cljs.core.str(s1__$1),cljs.core.str(s2__$1)].join('');
}
} else {
if(cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_.call(null,s2__$1,separator))){
return [cljs.core.str(s1__$1),cljs.core.str(s2__$1)].join('');
} else {
if((cljs.core._EQ_.call(null,s1__$1,"")) || (cljs.core._EQ_.call(null,s2__$1,""))){
return [cljs.core.str(s1__$1),cljs.core.str(s2__$1)].join('');
} else {
return [cljs.core.str(s1__$1),cljs.core.str(separator),cljs.core.str(s2__$1)].join('');
}
}
}
}),null,coll);
});

taoensso.encore.join_once.cljs$lang$maxFixedArity = (1);

taoensso.encore.join_once.cljs$lang$applyTo = (function (seq33922){
var G__33923 = cljs.core.first.call(null,seq33922);
var seq33922__$1 = cljs.core.next.call(null,seq33922);
return taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic(G__33923,seq33922__$1);
});
/**
 * Joins string paths (URLs, file paths, etc.) ensuring correct "/"
 *   interposition
 */
taoensso.encore.path = (function taoensso$encore$path(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33928 = arguments.length;
var i__17408__auto___33929 = (0);
while(true){
if((i__17408__auto___33929 < len__17407__auto___33928)){
args__17414__auto__.push((arguments[i__17408__auto___33929]));

var G__33930 = (i__17408__auto___33929 + (1));
i__17408__auto___33929 = G__33930;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((0) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((0)),(0))):null);
return taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(argseq__17415__auto__);
});

taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic = (function (parts){
return cljs.core.apply.call(null,taoensso.encore.join_once,"/",parts);
});

taoensso.encore.path.cljs$lang$maxFixedArity = (0);

taoensso.encore.path.cljs$lang$applyTo = (function (seq33927){
return taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33927));
});
/**
 * Converts all word breaks of any form and length (including line breaks of any
 *   form, tabs, spaces, etc.) to a single regular space
 */
taoensso.encore.norm_word_breaks = (function taoensso$encore$norm_word_breaks(s){
return clojure.string.replace.call(null,[cljs.core.str(s)].join(''),/\s+/," ");
});
taoensso.encore.count_words = (function taoensso$encore$count_words(s){
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))){
return (0);
} else {
return cljs.core.count.call(null,clojure.string.split.call(null,s,/\s+/));
}
});
/**
 * Returns a UUIDv4 string of form "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx",
 *   Ref. http://www.ietf.org/rfc/rfc4122.txt,
 *     https://gist.github.com/franks42/4159427
 */
taoensso.encore.uuid_str = (function taoensso$encore$uuid_str(var_args){
var args33931 = [];
var len__17407__auto___33934 = arguments.length;
var i__17408__auto___33935 = (0);
while(true){
if((i__17408__auto___33935 < len__17407__auto___33934)){
args33931.push((arguments[i__17408__auto___33935]));

var G__33936 = (i__17408__auto___33935 + (1));
i__17408__auto___33935 = G__33936;
continue;
} else {
}
break;
}

var G__33933 = args33931.length;
switch (G__33933) {
case 1:
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33931.length)].join('')));

}
});

taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1 = (function (max_length){
return taoensso.encore.substr.call(null,taoensso.encore.uuid_str.call(null),(0),max_length);
});

taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0 = (function (){
var hex = (function (){
return cljs.core.rand_int.call(null,(16)).toString((16));
});
var rhex = ((8) | ((3) & cljs.core.rand_int.call(null,(16)))).toString((16));
return [cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str("-"),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str("-"),cljs.core.str("4"),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str("-"),cljs.core.str(rhex),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str("-"),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null)),cljs.core.str(hex.call(null))].join('');
});

taoensso.encore.uuid_str.cljs$lang$maxFixedArity = 1;
taoensso.encore.gc_rate = (1.0 / (16000));
taoensso.encore.gc_now_QMARK_ = (function taoensso$encore$gc_now_QMARK_(){
return (cljs.core.rand.call(null) <= taoensso.encore.gc_rate);
});
/**
 * Swaps associative value at key and returns the new value. Specialized, fast
 *   `swap-in!` for use mostly by memoization utils.
 */
taoensso.encore.swap_val_BANG_ = (function taoensso$encore$swap_val_BANG_(atom_,k,f){
while(true){
var old_m = cljs.core.deref.call(null,atom_);
var new_v = f.call(null,cljs.core.get.call(null,old_m,k));
var new_m = cljs.core.assoc.call(null,old_m,k,new_v);
if(cljs.core.truth_(cljs.core.compare_and_set_BANG_.call(null,atom_,old_m,new_m))){
return new_v;
} else {
continue;
}
break;
}
});
/**
 * Like `clojure.core/memoize` but uses delays to avoid write races
 */
taoensso.encore.memoize_ = (function taoensso$encore$memoize_(f){
var cache_ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
return ((function (cache_){
return (function() { 
var G__33938__delegate = function (args){
return cljs.core.deref.call(null,(function (){var or__16349__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_),args);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore.swap_val_BANG_.call(null,cache_,args,((function (or__16349__auto__,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_(_QMARK_dv)){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__16349__auto__,cache_){
return (function (){
return cljs.core.apply.call(null,f,args);
});})(or__16349__auto__,cache_))
,null));
}
});})(or__16349__auto__,cache_))
);
}
})());
};
var G__33938 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33939__i = 0, G__33939__a = new Array(arguments.length -  0);
while (G__33939__i < G__33939__a.length) {G__33939__a[G__33939__i] = arguments[G__33939__i + 0]; ++G__33939__i;}
  args = new cljs.core.IndexedSeq(G__33939__a,0);
} 
return G__33938__delegate.call(this,args);};
G__33938.cljs$lang$maxFixedArity = 0;
G__33938.cljs$lang$applyTo = (function (arglist__33940){
var args = cljs.core.seq(arglist__33940);
return G__33938__delegate(args);
});
G__33938.cljs$core$IFn$_invoke$arity$variadic = G__33938__delegate;
return G__33938;
})()
;
;})(cache_))
});
/**
 * Fastest possible 0-arg `memoize_`
 */
taoensso.encore.a0_memoize_ = (function taoensso$encore$a0_memoize_(f){
var cache_ = cljs.core.atom.call(null,null);
return ((function (cache_){
return (function (){
return cljs.core.deref.call(null,(function (){var or__16349__auto__ = cljs.core.deref.call(null,cache_);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return cljs.core.swap_BANG_.call(null,cache_,((function (or__16349__auto__,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_(_QMARK_dv)){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__16349__auto__,cache_){
return (function (){
return f.call(null);
});})(or__16349__auto__,cache_))
,null));
}
});})(or__16349__auto__,cache_))
);
}
})());
});
;})(cache_))
});
/**
 * Fastest possible 0/1-arg `memoize_`
 */
taoensso.encore.a1_memoize_ = (function taoensso$encore$a1_memoize_(f){
var cache_ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
return ((function (cache_){
return (function() {
var G__33941 = null;
var G__33941__0 = (function (){
return cljs.core.deref.call(null,(function (){var or__16349__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_),taoensso.encore.sentinel);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore.swap_val_BANG_.call(null,cache_,taoensso.encore.sentinel,((function (or__16349__auto__,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_(_QMARK_dv)){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__16349__auto__,cache_){
return (function (){
return f.call(null);
});})(or__16349__auto__,cache_))
,null));
}
});})(or__16349__auto__,cache_))
);
}
})());
});
var G__33941__1 = (function (x){
return cljs.core.deref.call(null,(function (){var or__16349__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_),x);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore.swap_val_BANG_.call(null,cache_,x,((function (or__16349__auto__,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_(_QMARK_dv)){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__16349__auto__,cache_){
return (function (){
return f.call(null,x);
});})(or__16349__auto__,cache_))
,null));
}
});})(or__16349__auto__,cache_))
);
}
})());
});
G__33941 = function(x){
switch(arguments.length){
case 0:
return G__33941__0.call(this);
case 1:
return G__33941__1.call(this,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33941.cljs$core$IFn$_invoke$arity$0 = G__33941__0;
G__33941.cljs$core$IFn$_invoke$arity$1 = G__33941__1;
return G__33941;
})()
;})(cache_))
});
/**
 * Great for Reactjs render op caching on mobile devices, etc.
 */
taoensso.encore.memoize1 = (function taoensso$encore$memoize1(f){
var cache_ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
return ((function (cache_){
return (function() { 
var G__33942__delegate = function (args){
return cljs.core.deref.call(null,(function (){var or__16349__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_),args);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,cache_,((function (or__16349__auto__,cache_){
return (function (cache){
if(cljs.core.truth_(cljs.core.get.call(null,cache,args))){
return cache;
} else {
return cljs.core.PersistentArrayMap.fromArray([args,(new cljs.core.Delay(((function (or__16349__auto__,cache_){
return (function (){
return cljs.core.apply.call(null,f,args);
});})(or__16349__auto__,cache_))
,null))], true, false);
}
});})(or__16349__auto__,cache_))
),args);
}
})());
};
var G__33942 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33943__i = 0, G__33943__a = new Array(arguments.length -  0);
while (G__33943__i < G__33943__a.length) {G__33943__a[G__33943__i] = arguments[G__33943__i + 0]; ++G__33943__i;}
  args = new cljs.core.IndexedSeq(G__33943__a,0);
} 
return G__33942__delegate.call(this,args);};
G__33942.cljs$lang$maxFixedArity = 0;
G__33942.cljs$lang$applyTo = (function (arglist__33944){
var args = cljs.core.seq(arglist__33944);
return G__33942__delegate(args);
});
G__33942.cljs$core$IFn$_invoke$arity$variadic = G__33942__delegate;
return G__33942;
})()
;
;})(cache_))
});
/**
 * Like `(memoize* f)` but takes an explicit cache atom (possibly nil)
 *   and immediately applies memoized f to given arguments
 */
taoensso.encore.memoized = (function taoensso$encore$memoized(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33948 = arguments.length;
var i__17408__auto___33949 = (0);
while(true){
if((i__17408__auto___33949 < len__17407__auto___33948)){
args__17414__auto__.push((arguments[i__17408__auto___33949]));

var G__33950 = (i__17408__auto___33949 + (1));
i__17408__auto___33949 = G__33950;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((2) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((2)),(0))):null);
return taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17415__auto__);
});

taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic = (function (cache,f,args){
if(cljs.core.not.call(null,cache)){
return cljs.core.apply.call(null,f,args);
} else {
return cljs.core.deref.call(null,taoensso.encore.swap_val_BANG_.call(null,cache,args,(function (_QMARK_dv){
if(cljs.core.truth_(_QMARK_dv)){
return _QMARK_dv;
} else {
return (new cljs.core.Delay((function (){
return cljs.core.apply.call(null,f,args);
}),null));
}
})));
}
});

taoensso.encore.memoized.cljs$lang$maxFixedArity = (2);

taoensso.encore.memoized.cljs$lang$applyTo = (function (seq33945){
var G__33946 = cljs.core.first.call(null,seq33945);
var seq33945__$1 = cljs.core.next.call(null,seq33945);
var G__33947 = cljs.core.first.call(null,seq33945__$1);
var seq33945__$2 = cljs.core.next.call(null,seq33945__$1);
return taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic(G__33946,G__33947,seq33945__$2);
});
/**
 * Like `clojure.core/memoize` but:
 *  * Uses delays to prevent race conditions on writes.
 *  * Supports auto invalidation & gc with `ttl-ms` option.
 *  * Supports manual invalidation by prepending args with `:mem/del` or `:mem/fresh`.
 *  * Supports cache size limit & gc with `cache-size` option.
 * 
 *   Much faster than `clojure.core.memoize`.
 */
taoensso.encore.memoize_STAR_ = (function taoensso$encore$memoize_STAR_(var_args){
var args33951 = [];
var len__17407__auto___33975 = arguments.length;
var i__17408__auto___33976 = (0);
while(true){
if((i__17408__auto___33976 < len__17407__auto___33975)){
args33951.push((arguments[i__17408__auto___33976]));

var G__33977 = (i__17408__auto___33976 + (1));
i__17408__auto___33976 = G__33977;
continue;
} else {
}
break;
}

var G__33953 = args33951.length;
switch (G__33953) {
case 1:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33951.length)].join('')));

}
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
var cache_ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
return ((function (cache_){
return (function() { 
var G__33979__delegate = function (p__33954){
var vec__33955 = p__33954;
var arg1 = cljs.core.nth.call(null,vec__33955,(0),null);
var argn = cljs.core.nthnext.call(null,vec__33955,(1));
var args = vec__33955;
if(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,arg1,new cljs.core.Keyword("mem","get","mem/get",1683009136)))){
return cljs.core.deref.call(null,cache_);
} else {
if(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,arg1,new cljs.core.Keyword("mem","del","mem/del",574870667)))){
if(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,cljs.core.first.call(null,argn),new cljs.core.Keyword("mem","all","mem/all",892075139)))){
cljs.core.reset_BANG_.call(null,cache_,cljs.core.PersistentArrayMap.EMPTY);
} else {
cljs.core.swap_BANG_.call(null,cache_,cljs.core.dissoc,argn);
}

return null;
} else {
var fresh_QMARK_ = taoensso.encore.kw_identical_QMARK_.call(null,arg1,new cljs.core.Keyword("mem","fresh","mem/fresh",-1179989133));
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
return cljs.core.deref.call(null,(function (){var or__16349__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_),args__$1);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore.swap_val_BANG_.call(null,cache_,args__$1,((function (or__16349__auto__,fresh_QMARK_,args__$1,vec__33955,arg1,argn,args,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_((function (){var and__16337__auto__ = _QMARK_dv;
if(cljs.core.truth_(and__16337__auto__)){
return cljs.core.not.call(null,fresh_QMARK_);
} else {
return and__16337__auto__;
}
})())){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__16349__auto__,fresh_QMARK_,args__$1,vec__33955,arg1,argn,args,cache_){
return (function (){
return cljs.core.apply.call(null,f,args__$1);
});})(or__16349__auto__,fresh_QMARK_,args__$1,vec__33955,arg1,argn,args,cache_))
,null));
}
});})(or__16349__auto__,fresh_QMARK_,args__$1,vec__33955,arg1,argn,args,cache_))
);
}
})());

}
}
};
var G__33979 = function (var_args){
var p__33954 = null;
if (arguments.length > 0) {
var G__33980__i = 0, G__33980__a = new Array(arguments.length -  0);
while (G__33980__i < G__33980__a.length) {G__33980__a[G__33980__i] = arguments[G__33980__i + 0]; ++G__33980__i;}
  p__33954 = new cljs.core.IndexedSeq(G__33980__a,0);
} 
return G__33979__delegate.call(this,p__33954);};
G__33979.cljs$lang$maxFixedArity = 0;
G__33979.cljs$lang$applyTo = (function (arglist__33981){
var p__33954 = cljs.core.seq(arglist__33981);
return G__33979__delegate(p__33954);
});
G__33979.cljs$core$IFn$_invoke$arity$variadic = G__33979__delegate;
return G__33979;
})()
;
;})(cache_))
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (ttl_ms,f){
var __x_33982 = ttl_ms;
try{if(cljs.core.truth_(taoensso.encore.pos_int_QMARK_.call(null,__x_33982))){
} else {
taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33956){if((e33956 instanceof Error)){
var t_33983 = e33956;
taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1796,"(pos-int? ttl-ms)",__x_33982,t_33983);
} else {
throw e33956;

}
}
var cache_ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var gc_running_QMARK__ = cljs.core.atom.call(null,false);
var ttl_ms__$1 = cljs.core.long$.call(null,ttl_ms);
var gc_fn = ((function (cache_,gc_running_QMARK__,ttl_ms__$1){
return (function (){
if(cljs.core.truth_((function (){var and__16337__auto__ = taoensso.encore.gc_now_QMARK_.call(null);
if(cljs.core.truth_(and__16337__auto__)){
return taoensso.encore.swap_in_BANG_.call(null,gc_running_QMARK__,cljs.core.PersistentVector.EMPTY,((function (and__16337__auto__,cache_,gc_running_QMARK__,ttl_ms__$1){
return (function (b){
return taoensso.encore.swapped.call(null,true,cljs.core.not.call(null,b));
});})(and__16337__auto__,cache_,gc_running_QMARK__,ttl_ms__$1))
);
} else {
return and__16337__auto__;
}
})())){
var instant = taoensso.encore.now_udt.call(null);
var snapshot = cljs.core.deref.call(null,cache_);
var ks_to_gc = cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,((function (instant,snapshot,cache_,gc_running_QMARK__,ttl_ms__$1){
return (function (acc,k,p__33957){
var vec__33958 = p__33957;
var dv = cljs.core.nth.call(null,vec__33958,(0),null);
var udt = cljs.core.nth.call(null,vec__33958,(1),null);
var cv = vec__33958;
if(((instant - udt) > ttl_ms__$1)){
return cljs.core.conj_BANG_.call(null,acc,k);
} else {
return acc;
}
});})(instant,snapshot,cache_,gc_running_QMARK__,ttl_ms__$1))
,cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY),snapshot));
cljs.core.swap_BANG_.call(null,cache_,((function (instant,snapshot,ks_to_gc,cache_,gc_running_QMARK__,ttl_ms__$1){
return (function (m){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,((function (instant,snapshot,ks_to_gc,cache_,gc_running_QMARK__,ttl_ms__$1){
return (function (acc,in$){
return cljs.core.dissoc_BANG_.call(null,acc,in$);
});})(instant,snapshot,ks_to_gc,cache_,gc_running_QMARK__,ttl_ms__$1))
,cljs.core.transient$.call(null,m),ks_to_gc));
});})(instant,snapshot,ks_to_gc,cache_,gc_running_QMARK__,ttl_ms__$1))
);

return cljs.core.reset_BANG_.call(null,gc_running_QMARK__,false);
} else {
return null;
}
});})(cache_,gc_running_QMARK__,ttl_ms__$1))
;
return ((function (cache_,gc_running_QMARK__,ttl_ms__$1,gc_fn){
return (function() { 
var G__33984__delegate = function (p__33959){
var vec__33960 = p__33959;
var arg1 = cljs.core.nth.call(null,vec__33960,(0),null);
var argn = cljs.core.nthnext.call(null,vec__33960,(1));
var args = vec__33960;
if(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,arg1,new cljs.core.Keyword("mem","get","mem/get",1683009136)))){
return cljs.core.deref.call(null,cache_);
} else {
if(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,arg1,new cljs.core.Keyword("mem","del","mem/del",574870667)))){
if(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,cljs.core.first.call(null,argn),new cljs.core.Keyword("mem","all","mem/all",892075139)))){
cljs.core.reset_BANG_.call(null,cache_,cljs.core.PersistentArrayMap.EMPTY);
} else {
cljs.core.swap_BANG_.call(null,cache_,cljs.core.dissoc,argn);
}

return null;
} else {
gc_fn.call(null);

var fresh_QMARK_ = taoensso.encore.kw_identical_QMARK_.call(null,arg1,new cljs.core.Keyword("mem","fresh","mem/fresh",-1179989133));
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var instant = taoensso.encore.now_udt.call(null);
var vec__33961 = taoensso.encore.swap_val_BANG_.call(null,cache_,args__$1,((function (fresh_QMARK_,args__$1,instant,vec__33960,arg1,argn,args,cache_,gc_running_QMARK__,ttl_ms__$1,gc_fn){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__16337__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__16337__auto__)){
var and__16337__auto____$1 = cljs.core.not.call(null,fresh_QMARK_);
if(and__16337__auto____$1){
var vec__33963 = _QMARK_cv;
var _dv = cljs.core.nth.call(null,vec__33963,(0),null);
var udt = cljs.core.nth.call(null,vec__33963,(1),null);
return ((instant - udt) < ttl_ms__$1);
} else {
return and__16337__auto____$1;
}
} else {
return and__16337__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (fresh_QMARK_,args__$1,instant,vec__33960,arg1,argn,args,cache_,gc_running_QMARK__,ttl_ms__$1,gc_fn){
return (function (){
return cljs.core.apply.call(null,f,args__$1);
});})(fresh_QMARK_,args__$1,instant,vec__33960,arg1,argn,args,cache_,gc_running_QMARK__,ttl_ms__$1,gc_fn))
,null)),instant], null);
}
});})(fresh_QMARK_,args__$1,instant,vec__33960,arg1,argn,args,cache_,gc_running_QMARK__,ttl_ms__$1,gc_fn))
);
var dv = cljs.core.nth.call(null,vec__33961,(0),null);
return cljs.core.deref.call(null,dv);

}
}
};
var G__33984 = function (var_args){
var p__33959 = null;
if (arguments.length > 0) {
var G__33985__i = 0, G__33985__a = new Array(arguments.length -  0);
while (G__33985__i < G__33985__a.length) {G__33985__a[G__33985__i] = arguments[G__33985__i + 0]; ++G__33985__i;}
  p__33959 = new cljs.core.IndexedSeq(G__33985__a,0);
} 
return G__33984__delegate.call(this,p__33959);};
G__33984.cljs$lang$maxFixedArity = 0;
G__33984.cljs$lang$applyTo = (function (arglist__33986){
var p__33959 = cljs.core.seq(arglist__33986);
return G__33984__delegate(p__33959);
});
G__33984.cljs$core$IFn$_invoke$arity$variadic = G__33984__delegate;
return G__33984;
})()
;
;})(cache_,gc_running_QMARK__,ttl_ms__$1,gc_fn))
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (cache_size,ttl_ms,f){
var __x_33987 = ttl_ms;
try{if(cljs.core.truth_(taoensso.encore._invar_pred.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"or","or",235744169),cljs.core.nil_QMARK_,taoensso.encore.pos_int_QMARK_], null)).call(null,__x_33987))){
} else {
taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33964){if((e33964 instanceof Error)){
var t_33988 = e33964;
taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1849,"([:or nil? pos-int?] ttl-ms)",__x_33987,t_33988);
} else {
throw e33964;

}
}
var __x_33989 = cache_size;
try{if(cljs.core.truth_(taoensso.encore.pos_int_QMARK_.call(null,__x_33989))){
} else {
taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33965){if((e33965 instanceof Error)){
var t_33990 = e33965;
taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",1850,"(pos-int? cache-size)",__x_33989,t_33990);
} else {
throw e33965;

}
}
var state_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tick","tick",-835886976),(0)], null));
var gc_running_QMARK__ = cljs.core.atom.call(null,false);
var ttl_ms_QMARK_ = !((ttl_ms == null));
var ttl_ms__$1 = cljs.core.long$.call(null,(function (){var or__16349__auto__ = ttl_ms;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return (0);
}
})());
var cache_size__$1 = cljs.core.long$.call(null,cache_size);
var gc_fn = ((function (state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1){
return (function (){
if(cljs.core.truth_((function (){var and__16337__auto__ = taoensso.encore.gc_now_QMARK_.call(null);
if(cljs.core.truth_(and__16337__auto__)){
return taoensso.encore.swap_in_BANG_.call(null,gc_running_QMARK__,cljs.core.PersistentVector.EMPTY,((function (and__16337__auto__,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1){
return (function (b){
return taoensso.encore.swapped.call(null,true,cljs.core.not.call(null,b));
});})(and__16337__auto__,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1))
);
} else {
return and__16337__auto__;
}
})())){
var instant = taoensso.encore.now_udt.call(null);
if(ttl_ms_QMARK_){
var snapshot_33991 = cljs.core.dissoc.call(null,cljs.core.deref.call(null,state_),new cljs.core.Keyword(null,"tick","tick",-835886976));
var ks_to_gc_33992 = cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,((function (snapshot_33991,instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1){
return (function (acc,k,p__33966){
var vec__33967 = p__33966;
var dv = cljs.core.nth.call(null,vec__33967,(0),null);
var udt = cljs.core.nth.call(null,vec__33967,(1),null);
var _ = cljs.core.nth.call(null,vec__33967,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__33967,(3),null);
var cv = vec__33967;
if(((instant - udt) > ttl_ms__$1)){
return cljs.core.conj_BANG_.call(null,acc,k);
} else {
return acc;
}
});})(snapshot_33991,instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1))
,cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY),snapshot_33991));
cljs.core.swap_BANG_.call(null,state_,((function (snapshot_33991,ks_to_gc_33992,instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1){
return (function (m){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,((function (snapshot_33991,ks_to_gc_33992,instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1){
return (function (acc,in$){
return cljs.core.dissoc_BANG_.call(null,acc,in$);
});})(snapshot_33991,ks_to_gc_33992,instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1))
,cljs.core.transient$.call(null,m),ks_to_gc_33992));
});})(snapshot_33991,ks_to_gc_33992,instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1))
);
} else {
}

var snapshot_33993 = cljs.core.dissoc.call(null,cljs.core.deref.call(null,state_),new cljs.core.Keyword(null,"tick","tick",-835886976));
var n_to_gc_33994 = (cljs.core.count.call(null,snapshot_33993) - cache_size__$1);
if((n_to_gc_33994 > (64))){
var ks_to_gc_33995 = taoensso.encore.top.call(null,n_to_gc_33994,((function (snapshot_33993,n_to_gc_33994,instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1){
return (function (k){
var vec__33968 = snapshot_33993.call(null,k);
var _ = cljs.core.nth.call(null,vec__33968,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__33968,(1),null);
var tick_lru = cljs.core.nth.call(null,vec__33968,(2),null);
var tick_lfu = cljs.core.nth.call(null,vec__33968,(3),null);
return (tick_lru + tick_lfu);
});})(snapshot_33993,n_to_gc_33994,instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1))
,cljs.core.keys.call(null,snapshot_33993));
cljs.core.swap_BANG_.call(null,state_,((function (ks_to_gc_33995,snapshot_33993,n_to_gc_33994,instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1){
return (function (m){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,((function (ks_to_gc_33995,snapshot_33993,n_to_gc_33994,instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1){
return (function (acc,in$){
return cljs.core.dissoc_BANG_.call(null,acc,in$);
});})(ks_to_gc_33995,snapshot_33993,n_to_gc_33994,instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1))
,cljs.core.transient$.call(null,m),ks_to_gc_33995));
});})(ks_to_gc_33995,snapshot_33993,n_to_gc_33994,instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1))
);
} else {
}

return cljs.core.reset_BANG_.call(null,gc_running_QMARK__,false);
} else {
return null;
}
});})(state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1))
;
var cv_fn = ((!(ttl_ms_QMARK_))?((function (state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn){
return (function (args,fresh_QMARK_,tick){
return taoensso.encore.swap_val_BANG_.call(null,state_,args,((function (state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__16337__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__16337__auto__)){
return cljs.core.not.call(null,fresh_QMARK_);
} else {
return and__16337__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn){
return (function (){
return cljs.core.apply.call(null,f,args);
});})(state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn))
,null)),null,tick,(1)], null);
}
});})(state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn))
);
});})(state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn))
:((function (state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn){
return (function (args,fresh_QMARK_,tick){
var instant = taoensso.encore.now_udt.call(null);
return taoensso.encore.swap_val_BANG_.call(null,state_,args,((function (instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__16337__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__16337__auto__)){
var and__16337__auto____$1 = cljs.core.not.call(null,fresh_QMARK_);
if(and__16337__auto____$1){
var vec__33970 = _QMARK_cv;
var _dv = cljs.core.nth.call(null,vec__33970,(0),null);
var udt = cljs.core.nth.call(null,vec__33970,(1),null);
return ((instant - udt) < ttl_ms__$1);
} else {
return and__16337__auto____$1;
}
} else {
return and__16337__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn){
return (function (){
return cljs.core.apply.call(null,f,args);
});})(instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn))
,null)),instant,tick,(1)], null);
}
});})(instant,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn))
);
});})(state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn))
);
return ((function (state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn,cv_fn){
return (function() { 
var G__33996__delegate = function (p__33971){
var vec__33972 = p__33971;
var arg1 = cljs.core.nth.call(null,vec__33972,(0),null);
var argn = cljs.core.nthnext.call(null,vec__33972,(1));
var args = vec__33972;
if(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,arg1,new cljs.core.Keyword("mem","get","mem/get",1683009136)))){
return cljs.core.deref.call(null,state_);
} else {
if(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,arg1,new cljs.core.Keyword("mem","del","mem/del",574870667)))){
if(cljs.core.truth_(taoensso.encore.kw_identical_QMARK_.call(null,cljs.core.first.call(null,argn),new cljs.core.Keyword("mem","all","mem/all",892075139)))){
cljs.core.reset_BANG_.call(null,state_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tick","tick",-835886976),(0)], null));
} else {
cljs.core.swap_BANG_.call(null,state_,cljs.core.dissoc,argn);
}

return null;
} else {
gc_fn.call(null);

var fresh_QMARK_ = taoensso.encore.kw_identical_QMARK_.call(null,arg1,new cljs.core.Keyword("mem","fresh","mem/fresh",-1179989133));
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var tick = new cljs.core.Keyword(null,"tick","tick",-835886976).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state_));
var vec__33973 = cv_fn.call(null,args__$1,fresh_QMARK_,tick);
var dv = cljs.core.nth.call(null,vec__33973,(0),null);
cljs.core.swap_BANG_.call(null,state_,((function (fresh_QMARK_,args__$1,tick,vec__33973,dv,vec__33972,arg1,argn,args,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn,cv_fn){
return (function (m){
var temp__4423__auto__ = cljs.core.get.call(null,m,args__$1);
if(cljs.core.truth_(temp__4423__auto__)){
var vec__33974 = temp__4423__auto__;
var dv__$1 = cljs.core.nth.call(null,vec__33974,(0),null);
var _QMARK_udt = cljs.core.nth.call(null,vec__33974,(1),null);
var tick_lru = cljs.core.nth.call(null,vec__33974,(2),null);
var tick_lfu = cljs.core.nth.call(null,vec__33974,(3),null);
var cv = vec__33974;
return cljs.core.merge.call(null,m,cljs.core.PersistentArrayMap.fromArray([new cljs.core.Keyword(null,"tick","tick",-835886976),(tick + (1)),args__$1,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [dv__$1,_QMARK_udt,tick,(tick_lfu + (1))], null)], true, false));
} else {
return cljs.core.merge.call(null,m,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tick","tick",-835886976),(tick + (1))], null));
}
});})(fresh_QMARK_,args__$1,tick,vec__33973,dv,vec__33972,arg1,argn,args,state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn,cv_fn))
);

return cljs.core.deref.call(null,dv);

}
}
};
var G__33996 = function (var_args){
var p__33971 = null;
if (arguments.length > 0) {
var G__33997__i = 0, G__33997__a = new Array(arguments.length -  0);
while (G__33997__i < G__33997__a.length) {G__33997__a[G__33997__i] = arguments[G__33997__i + 0]; ++G__33997__i;}
  p__33971 = new cljs.core.IndexedSeq(G__33997__a,0);
} 
return G__33996__delegate.call(this,p__33971);};
G__33996.cljs$lang$maxFixedArity = 0;
G__33996.cljs$lang$applyTo = (function (arglist__33998){
var p__33971 = cljs.core.seq(arglist__33998);
return G__33996__delegate(p__33971);
});
G__33996.cljs$core$IFn$_invoke$arity$variadic = G__33996__delegate;
return G__33996;
})()
;
;})(state_,gc_running_QMARK__,ttl_ms_QMARK_,ttl_ms__$1,cache_size__$1,gc_fn,cv_fn))
});

taoensso.encore.memoize_STAR_.cljs$lang$maxFixedArity = 3;
/**
 * Takes one or more rate specs of form [ncalls-limit window-ms ?spec-id] and
 *   returns a (fn [& [req-id])) that returns `nil` (=> all rate limits passed), or
 *   [<ms-wait> <worst-offending-spec-id>] / <ms-wait>.
 */
taoensso.encore.rate_limiter_STAR_ = (function taoensso$encore$rate_limiter_STAR_(specs){
if(cljs.core.empty_QMARK_.call(null,specs)){
return cljs.core.constantly.call(null,null);
} else {
var vspecs = cljs.core.vec.call(null,specs);
var vstates_ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var max_win_ms = cljs.core.long$.call(null,cljs.core.reduce.call(null,cljs.core.max,(0),cljs.core.mapv.call(null,((function (vspecs,vstates_){
return (function (p__34034){
var vec__34035 = p__34034;
var _ = cljs.core.nth.call(null,vec__34035,(0),null);
var win_ms = cljs.core.nth.call(null,vec__34035,(1),null);
var ___$1 = cljs.core.nth.call(null,vec__34035,(2),null);
var spec = vec__34035;
return win_ms;
});})(vspecs,vstates_))
,vspecs)));
var nspecs = cljs.core.count.call(null,vspecs);
var nid_specs = cljs.core.count.call(null,cljs.core.filterv.call(null,((function (vspecs,vstates_,max_win_ms,nspecs){
return (function (p__34036){
var vec__34037 = p__34036;
var _ = cljs.core.nth.call(null,vec__34037,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__34037,(1),null);
var id = cljs.core.nth.call(null,vec__34037,(2),null);
return id;
});})(vspecs,vstates_,max_win_ms,nspecs))
,vspecs));
var _ = ((((nid_specs === (0))) || (cljs.core._EQ_.call(null,nid_specs,nspecs)))?null:(function(){throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),new cljs.core.Symbol(null,"nid-specs","nid-specs",-1204406222,null)),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"nid-specs","nid-specs",-1204406222,null),new cljs.core.Symbol(null,"nspecs","nspecs",-1621596945,null)))))].join('')))})());
var return_ids_QMARK_ = !((nid_specs === (0)));
return ((function (vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function() { 
var taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate = function (p__34038){
var vec__34054 = p__34038;
var req_id = cljs.core.nth.call(null,vec__34054,(0),null);
var instant = taoensso.encore.now_udt.call(null);
if(cljs.core.truth_((function (){var and__16337__auto__ = req_id;
if(cljs.core.truth_(and__16337__auto__)){
return taoensso.encore.gc_now_QMARK_.call(null);
} else {
return and__16337__auto__;
}
})())){
taoensso.encore.swap_in_BANG_.call(null,vstates_,cljs.core.PersistentVector.EMPTY,((function (instant,vec__34054,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function taoensso$encore$rate_limiter_STAR__$_check_rate_limits_$_gc(m){
return cljs.core.reduce_kv.call(null,((function (instant,vec__34054,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (m_STAR_,req_id__$1,vstate){
var max_udt_win_start = cljs.core.reduce.call(null,((function (instant,vec__34054,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (acc,p__34057){
var vec__34058 = p__34057;
var ___$1 = cljs.core.nth.call(null,vec__34058,(0),null);
var udt = cljs.core.nth.call(null,vec__34058,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__34058,(2),null);
var x__16680__auto__ = acc;
var y__16681__auto__ = udt;
return ((x__16680__auto__ > y__16681__auto__) ? x__16680__auto__ : y__16681__auto__);
});})(instant,vec__34054,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,(0),vstate);
var min_win_ms_elapsed = (instant - max_udt_win_start);
if((min_win_ms_elapsed > max_win_ms)){
return cljs.core.dissoc.call(null,m_STAR_,req_id__$1);
} else {
return m_STAR_;
}
});})(instant,vec__34054,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,m,m);
});})(instant,vec__34054,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
);
} else {
}

return taoensso.encore.swap_in_BANG_.call(null,vstates_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [req_id], null),((function (instant,vec__34054,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (_QMARK_vstate){
if(cljs.core.not.call(null,_QMARK_vstate)){
return taoensso.encore.swapped.call(null,cljs.core.vec.call(null,cljs.core.repeat.call(null,nspecs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),instant], null))),null);
} else {
var vec__34059 = (function (){var in_vspecs = vspecs;
var in_vstate = _QMARK_vstate;
var out_vstate = cljs.core.PersistentVector.EMPTY;
var _QMARK_worst_limit_offence = null;
while(true){
var vec__34060 = in_vspecs;
var vec__34061 = cljs.core.nth.call(null,vec__34060,(0),null);
var ncalls_limit = cljs.core.nth.call(null,vec__34061,(0),null);
var win_ms = cljs.core.nth.call(null,vec__34061,(1),null);
var _QMARK_spec_id = cljs.core.nth.call(null,vec__34061,(2),null);
var next_in_vspecs = cljs.core.nthnext.call(null,vec__34060,(1));
var vec__34062 = in_vstate;
var vec__34063 = cljs.core.nth.call(null,vec__34062,(0),null);
var ncalls = cljs.core.nth.call(null,vec__34063,(0),null);
var udt_win_start = cljs.core.nth.call(null,vec__34063,(1),null);
var next_in_vstate = cljs.core.nthnext.call(null,vec__34062,(1));
var win_ms_elapsed = (instant - udt_win_start);
var reset_due_QMARK_ = (win_ms_elapsed >= win_ms);
var rate_limited_QMARK_ = (!(reset_due_QMARK_)) && ((ncalls >= ncalls_limit));
var new_out_vstate = cljs.core.conj.call(null,out_vstate,((reset_due_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),instant], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls,udt_win_start], null)));
var new__QMARK_worst_limit_offence = ((!(rate_limited_QMARK_))?_QMARK_worst_limit_offence:(function (){var ms_wait = (win_ms - win_ms_elapsed);
if((function (){var or__16349__auto__ = (_QMARK_worst_limit_offence == null);
if(or__16349__auto__){
return or__16349__auto__;
} else {
var vec__34065 = _QMARK_worst_limit_offence;
var max_ms_wait = cljs.core.nth.call(null,vec__34065,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__34065,(1),null);
return (ms_wait > max_ms_wait);
}
})()){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ms_wait,_QMARK_spec_id], null);
} else {
return _QMARK_worst_limit_offence;
}
})());
if(cljs.core.not.call(null,next_in_vspecs)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_out_vstate,new__QMARK_worst_limit_offence], null);
} else {
var G__34069 = next_in_vspecs;
var G__34070 = next_in_vstate;
var G__34071 = new_out_vstate;
var G__34072 = new__QMARK_worst_limit_offence;
in_vspecs = G__34069;
in_vstate = G__34070;
out_vstate = G__34071;
_QMARK_worst_limit_offence = G__34072;
continue;
}
break;
}
})();
var vstate_with_resets = cljs.core.nth.call(null,vec__34059,(0),null);
var _QMARK_worst_limit_offence = cljs.core.nth.call(null,vec__34059,(1),null);
var all_limits_pass_QMARK_ = (_QMARK_worst_limit_offence == null);
var new_vstate = ((!(all_limits_pass_QMARK_))?vstate_with_resets:cljs.core.mapv.call(null,((function (vec__34059,vstate_with_resets,_QMARK_worst_limit_offence,all_limits_pass_QMARK_,instant,vec__34054,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (p__34066){
var vec__34067 = p__34066;
var ncalls = cljs.core.nth.call(null,vec__34067,(0),null);
var udt_win_start = cljs.core.nth.call(null,vec__34067,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(ncalls + (1)),udt_win_start], null);
});})(vec__34059,vstate_with_resets,_QMARK_worst_limit_offence,all_limits_pass_QMARK_,instant,vec__34054,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,vstate_with_resets));
var result = (function (){var temp__4425__auto__ = _QMARK_worst_limit_offence;
if(cljs.core.truth_(temp__4425__auto__)){
var wlo = temp__4425__auto__;
if(return_ids_QMARK_){
return wlo;
} else {
var vec__34068 = wlo;
var ms_wait = cljs.core.nth.call(null,vec__34068,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__34068,(1),null);
return ms_wait;
}
} else {
return null;
}
})();
return taoensso.encore.swapped.call(null,new_vstate,result);
}
});})(instant,vec__34054,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
);
};
var taoensso$encore$rate_limiter_STAR__$_check_rate_limits = function (var_args){
var p__34038 = null;
if (arguments.length > 0) {
var G__34073__i = 0, G__34073__a = new Array(arguments.length -  0);
while (G__34073__i < G__34073__a.length) {G__34073__a[G__34073__i] = arguments[G__34073__i + 0]; ++G__34073__i;}
  p__34038 = new cljs.core.IndexedSeq(G__34073__a,0);
} 
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate.call(this,p__34038);};
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$lang$maxFixedArity = 0;
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$lang$applyTo = (function (arglist__34074){
var p__34038 = cljs.core.seq(arglist__34074);
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate(p__34038);
});
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$core$IFn$_invoke$arity$variadic = taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate;
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits;
})()
;
;})(vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
}
});
taoensso.encore.rate_limit = (function taoensso$encore$rate_limit(specs,f){
var rl = taoensso.encore.rate_limiter_STAR_.call(null,specs);
return ((function (rl){
return (function() { 
var G__34075__delegate = function (args){
var temp__4423__auto__ = rl.call(null);
if(cljs.core.truth_(temp__4423__auto__)){
var backoff = temp__4423__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,backoff], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.call(null),null], null);
}
};
var G__34075 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34076__i = 0, G__34076__a = new Array(arguments.length -  0);
while (G__34076__i < G__34076__a.length) {G__34076__a[G__34076__i] = arguments[G__34076__i + 0]; ++G__34076__i;}
  args = new cljs.core.IndexedSeq(G__34076__a,0);
} 
return G__34075__delegate.call(this,args);};
G__34075.cljs$lang$maxFixedArity = 0;
G__34075.cljs$lang$applyTo = (function (arglist__34077){
var args = cljs.core.seq(arglist__34077);
return G__34075__delegate(args);
});
G__34075.cljs$core$IFn$_invoke$arity$variadic = G__34075__delegate;
return G__34075;
})()
;
;})(rl))
});
taoensso.encore.nano_time = (function (){var temp__4423__auto__ = (function (){var and__16337__auto__ = typeof window !== 'undefined';
if(and__16337__auto__){
return (window["performance"]);
} else {
return and__16337__auto__;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var perf = temp__4423__auto__;
var temp__4423__auto____$1 = (function (){var or__16349__auto__ = (perf["now"]);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
var or__16349__auto____$1 = (perf["mozNow"]);
if(cljs.core.truth_(or__16349__auto____$1)){
return or__16349__auto____$1;
} else {
var or__16349__auto____$2 = (perf["msNow"]);
if(cljs.core.truth_(or__16349__auto____$2)){
return or__16349__auto____$2;
} else {
var or__16349__auto____$3 = (perf["oNow"]);
if(cljs.core.truth_(or__16349__auto____$3)){
return or__16349__auto____$3;
} else {
return (perf["webkitNow"]);
}
}
}
}
})();
if(cljs.core.truth_(temp__4423__auto____$1)){
var f = temp__4423__auto____$1;
return ((function (f,temp__4423__auto____$1,perf,temp__4423__auto__){
return (function (){
return cljs.core.long$.call(null,(1000000.0 * f.call(perf)));
});
;})(f,temp__4423__auto____$1,perf,temp__4423__auto__))
} else {
return ((function (temp__4423__auto____$1,perf,temp__4423__auto__){
return (function (){
return (1000000.0 * taoensso.encore.now_udt.call(null));
});
;})(temp__4423__auto____$1,perf,temp__4423__auto__))
}
} else {
return ((function (temp__4423__auto__){
return (function (){
return (1000000.0 * taoensso.encore.now_udt.call(null));
});
;})(temp__4423__auto__))
}
})();
taoensso.encore.console_log = (function (){var temp__4423__auto__ = (function (){var and__16337__auto__ = typeof console !== 'undefined';
if(and__16337__auto__){
return console.log;
} else {
return and__16337__auto__;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var f = temp__4423__auto__;
return ((function (f,temp__4423__auto__){
return (function (xs){
return f.apply(console,cljs.core.into_array.call(null,xs));
});
;})(f,temp__4423__auto__))
} else {
return ((function (temp__4423__auto__){
return (function (xs){
return null;
});
;})(temp__4423__auto__))
}
})();

taoensso.encore.log = (function taoensso$encore$log(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34085 = arguments.length;
var i__17408__auto___34086 = (0);
while(true){
if((i__17408__auto___34086 < len__17407__auto___34085)){
args__17414__auto__.push((arguments[i__17408__auto___34086]));

var G__34087 = (i__17408__auto___34086 + (1));
i__17408__auto___34086 = G__34087;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((0) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((0)),(0))):null);
return taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic(argseq__17415__auto__);
});

taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
return taoensso.encore.console_log.call(null,xs);
});

taoensso.encore.log.cljs$lang$maxFixedArity = (0);

taoensso.encore.log.cljs$lang$applyTo = (function (seq34078){
return taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq34078));
});

taoensso.encore.logp = (function taoensso$encore$logp(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34088 = arguments.length;
var i__17408__auto___34089 = (0);
while(true){
if((i__17408__auto___34089 < len__17407__auto___34088)){
args__17414__auto__.push((arguments[i__17408__auto___34089]));

var G__34090 = (i__17408__auto___34089 + (1));
i__17408__auto___34089 = G__34090;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((0) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((0)),(0))):null);
return taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic(argseq__17415__auto__);
});

taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
return taoensso.encore.console_log.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.spaced_str.call(null,xs)], null));
});

taoensso.encore.logp.cljs$lang$maxFixedArity = (0);

taoensso.encore.logp.cljs$lang$applyTo = (function (seq34079){
return taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq34079));
});

taoensso.encore.logf = (function taoensso$encore$logf(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34091 = arguments.length;
var i__17408__auto___34092 = (0);
while(true){
if((i__17408__auto___34092 < len__17407__auto___34091)){
args__17414__auto__.push((arguments[i__17408__auto___34092]));

var G__34093 = (i__17408__auto___34092 + (1));
i__17408__auto___34092 = G__34093;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
return taoensso.encore.console_log.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.format_STAR_.call(null,fmt,xs)], null));
});

taoensso.encore.logf.cljs$lang$maxFixedArity = (1);

taoensso.encore.logf.cljs$lang$applyTo = (function (seq34080){
var G__34081 = cljs.core.first.call(null,seq34080);
var seq34080__$1 = cljs.core.next.call(null,seq34080);
return taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic(G__34081,seq34080__$1);
});

taoensso.encore.sayp = (function taoensso$encore$sayp(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34094 = arguments.length;
var i__17408__auto___34095 = (0);
while(true){
if((i__17408__auto___34095 < len__17407__auto___34094)){
args__17414__auto__.push((arguments[i__17408__auto___34095]));

var G__34096 = (i__17408__auto___34095 + (1));
i__17408__auto___34095 = G__34096;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((0) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((0)),(0))):null);
return taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic(argseq__17415__auto__);
});

taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
return alert(taoensso.encore.spaced_str.call(null,xs));
});

taoensso.encore.sayp.cljs$lang$maxFixedArity = (0);

taoensso.encore.sayp.cljs$lang$applyTo = (function (seq34082){
return taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq34082));
});

taoensso.encore.sayf = (function taoensso$encore$sayf(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34097 = arguments.length;
var i__17408__auto___34098 = (0);
while(true){
if((i__17408__auto___34098 < len__17407__auto___34097)){
args__17414__auto__.push((arguments[i__17408__auto___34098]));

var G__34099 = (i__17408__auto___34098 + (1));
i__17408__auto___34098 = G__34099;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
return alert(taoensso.encore.format_STAR_.call(null,fmt,xs));
});

taoensso.encore.sayf.cljs$lang$maxFixedArity = (1);

taoensso.encore.sayf.cljs$lang$applyTo = (function (seq34083){
var G__34084 = cljs.core.first.call(null,seq34083);
var seq34083__$1 = cljs.core.next.call(null,seq34083);
return taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic(G__34084,seq34083__$1);
});
/**
 * Returns browser window's current location. These details can be forged!
 */
taoensso.encore.get_window_location = (function taoensso$encore$get_window_location(){
var loc_STAR_ = window.location;
var loc = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"href","href",-793805698),loc_STAR_.href,new cljs.core.Keyword(null,"protocol","protocol",652470118),loc_STAR_.protocol,new cljs.core.Keyword(null,"hostname","hostname",2105669933),loc_STAR_.hostname,new cljs.core.Keyword(null,"host","host",-1558485167),loc_STAR_.host,new cljs.core.Keyword(null,"pathname","pathname",-1420497528),loc_STAR_.pathname,new cljs.core.Keyword(null,"search","search",1564939822),loc_STAR_.search,new cljs.core.Keyword(null,"hash","hash",-13781596),loc_STAR_.hash], null);
return loc;
});
taoensso.encore.xhr_pool_ = (new cljs.core.Delay((function (){
return (new goog.net.XhrIoPool());
}),null));
/**
 * Returns an immediately available XhrIo instance, or nil. The instance must be
 *   released back to pool manually.
 */
taoensso.encore.get_pooled_xhr_BANG_ = (function taoensso$encore$get_pooled_xhr_BANG_(){
var result = cljs.core.deref.call(null,taoensso.encore.xhr_pool_).getObject();
if((void 0 === result)){
return null;
} else {
return result;
}
});
/**
 * [uri method get-or-post-params] -> [uri post-content]
 */
taoensso.encore.coerce_xhr_params = (function taoensso$encore$coerce_xhr_params(uri,method,params){
if(cljs.core.truth_((function (){var __x = params;
try{if(cljs.core.truth_(taoensso.encore._invar_pred.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"or","or",235744169),cljs.core.nil_QMARK_,cljs.core.map_QMARK_], null)).call(null,__x))){
return true;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e34102){if((e34102 instanceof Error)){
var t = e34102;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",2244,"([:or nil? map?] params)",__x,t);
} else {
throw e34102;

}
}})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"or","or",235744169),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"map?","map?",-1780568534,null)], null),new cljs.core.Symbol(null,"params","params",-1943919534,null))))].join('')));
}

var _QMARK_pstr = ((cljs.core.empty_QMARK_.call(null,params))?null:(function (){var s = goog.Uri.QueryData.createFromMap((new goog.structs.Map(cljs.core.clj__GT_js.call(null,params)))).toString();
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))){
return null;
} else {
return s;
}
})());
var G__34103 = (((method instanceof cljs.core.Keyword))?method.fqn:null);
switch (G__34103) {
case "get":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(_QMARK_pstr)?[cljs.core.str(uri),cljs.core.str("?"),cljs.core.str(_QMARK_pstr)].join(''):uri),null], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,_QMARK_pstr], null);

break;
case "put":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,_QMARK_pstr], null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(method)].join('')));

}
});
/**
 * Alpha - subject to change.
 *   Simple+lightweight Ajax via Google Closure. Returns nil, or the xhr instance.
 *   Ref. https://developers.google.com/closure/library/docs/xhrio.
 * 
 *   (ajax-lite "/my-post-route"
 *  {:method     :post
 *   :params     {:username "Rich Hickey"
 *                :type     "Awesome"}
 *   :headers    {"Foo" "Bar"}
 *   :resp-type  :text
 *   :timeout-ms 7000
 *   :with-credentials? false ; Enable if using CORS (requires xhr v2+)
 *  }
 *  (fn async-callback [resp-map]
 *    (let [{:keys [success? ?status ?error ?content ?content-type]} resp-map]
 *      ;; ?status  - 200, 404, ..., or nil on no response
 *      ;; ?error   - e/o #{:xhr-pool-depleted :exception :http-error :abort
 *      ;;                  :timeout :no-content <http-error-status> nil}
 *      (js/alert (str "Ajax response: " resp-map)))))
 */
taoensso.encore.ajax_lite = (function taoensso$encore$ajax_lite(uri,p__34107,callback){
var map__34126 = p__34107;
var map__34126__$1 = ((((!((map__34126 == null)))?((((map__34126.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34126.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34126):map__34126);
var opts = map__34126__$1;
var method = cljs.core.get.call(null,map__34126__$1,new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755));
var params = cljs.core.get.call(null,map__34126__$1,new cljs.core.Keyword(null,"params","params",710516235));
var headers = cljs.core.get.call(null,map__34126__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var timeout_ms = cljs.core.get.call(null,map__34126__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),(10000));
var resp_type = cljs.core.get.call(null,map__34126__$1,new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"auto","auto",-566279492));
var with_credentials_QMARK_ = cljs.core.get.call(null,map__34126__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var progress_fn = cljs.core.get.call(null,map__34126__$1,new cljs.core.Keyword(null,"progress-fn","progress-fn",-1146547855));
var errorf = cljs.core.get.call(null,map__34126__$1,new cljs.core.Keyword(null,"errorf","errorf",-620376044),taoensso.encore.logf);
if(cljs.core.truth_((function (){var __x = timeout_ms;
try{if(cljs.core.truth_(taoensso.encore._invar_pred.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"or","or",235744169),cljs.core.nil_QMARK_,taoensso.encore.nneg_int_QMARK_], null)).call(null,__x))){
return true;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e34128){if((e34128 instanceof Error)){
var t = e34128;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",2284,"([:or nil? nneg-int?] timeout-ms)",__x,t);
} else {
throw e34128;

}
}})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"or","or",235744169),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"nneg-int?","nneg-int?",803479360,null)], null),new cljs.core.Symbol(null,"timeout-ms","timeout-ms",-1900214363,null))))].join('')));
}

var temp__4423__auto__ = taoensso.encore.get_pooled_xhr_BANG_.call(null);
if(cljs.core.truth_(temp__4423__auto__)){
var xhr = temp__4423__auto__;
try{var timeout_ms__$1 = (function (){var or__16349__auto__ = new cljs.core.Keyword(null,"timeout","timeout",-318625318).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return timeout_ms;
}
})();
var method_STAR_ = (function (){var G__34131 = (((method instanceof cljs.core.Keyword))?method.fqn:null);
switch (G__34131) {
case "get":
return "GET";

break;
case "post":
return "POST";

break;
case "put":
return "PUT";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(method)].join('')));

}
})();
var params__$1 = taoensso.encore.map_keys.call(null,cljs.core.name,params);
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["X-Requested-With","XMLHTTPRequest"], null),taoensso.encore.map_keys.call(null,cljs.core.name,headers));
var vec__34130 = taoensso.encore.coerce_xhr_params.call(null,uri,method,params__$1);
var uri_STAR_ = cljs.core.nth.call(null,vec__34130,(0),null);
var post_content_STAR_ = cljs.core.nth.call(null,vec__34130,(1),null);
var headers_STAR_ = cljs.core.clj__GT_js.call(null,((cljs.core.not.call(null,post_content_STAR_))?headers__$1:cljs.core.assoc.call(null,headers__$1,"Content-Type","application/x-www-form-urlencoded; charset=UTF-8")));
var G__34132_34145 = xhr;
goog.events.listenOnce(G__34132_34145,goog.net.EventType.READY,((function (G__34132_34145,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__34130,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4423__auto__,map__34126,map__34126__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (_){
return cljs.core.deref.call(null,taoensso.encore.xhr_pool_).releaseObject(xhr);
});})(G__34132_34145,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__34130,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4423__auto__,map__34126,map__34126__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
);

goog.events.listenOnce(G__34132_34145,goog.net.EventType.COMPLETE,((function (G__34132_34145,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__34130,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4423__auto__,map__34126,map__34126__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function taoensso$encore$ajax_lite_$_wrapped_callback(resp){
var status = xhr.getStatus();
var success_QMARK_ = xhr.isSuccess();
var _QMARK_http_status = ((cljs.core.not_EQ_.call(null,status,(-1)))?status:null);
var _QMARK_content_type = (cljs.core.truth_(_QMARK_http_status)?xhr.getResponseHeader("Content-Type"):null);
var _QMARK_content = (cljs.core.truth_(_QMARK_http_status)?(function (){var resp_type__$1 = ((!(cljs.core._EQ_.call(null,resp_type,new cljs.core.Keyword(null,"auto","auto",-566279492))))?resp_type:(function (){var pred__34138 = ((function (status,success_QMARK_,_QMARK_http_status,_QMARK_content_type,G__34132_34145,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__34130,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4423__auto__,map__34126,map__34126__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (p1__34106_SHARP_,p2__34105_SHARP_){
return taoensso.encore.str_contains_QMARK_.call(null,p2__34105_SHARP_,p1__34106_SHARP_);
});})(status,success_QMARK_,_QMARK_http_status,_QMARK_content_type,G__34132_34145,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__34130,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4423__auto__,map__34126,map__34126__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
var expr__34139 = [cljs.core.str(_QMARK_content_type)].join('');
if(cljs.core.truth_(pred__34138.call(null,"/edn",expr__34139))){
return new cljs.core.Keyword(null,"edn","edn",1317840885);
} else {
if(cljs.core.truth_(pred__34138.call(null,"/json",expr__34139))){
return new cljs.core.Keyword(null,"json","json",1279968570);
} else {
if(cljs.core.truth_(pred__34138.call(null,"/xml",expr__34139))){
return new cljs.core.Keyword(null,"xml","xml",-1170142052);
} else {
if(cljs.core.truth_(pred__34138.call(null,"/html",expr__34139))){
return new cljs.core.Keyword(null,"text","text",-1790561697);
} else {
return new cljs.core.Keyword(null,"text","text",-1790561697);
}
}
}
}
})());
try{var G__34142 = (((resp_type__$1 instanceof cljs.core.Keyword))?resp_type__$1.fqn:null);
switch (G__34142) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
case "xml":
return xhr.getResponseXml();

break;
case "edn":
return taoensso.encore.read_edn.call(null,xhr.getResponseText());

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(resp_type__$1)].join('')));

}
}catch (e34141){if((e34141 instanceof Error)){
var e = e34141;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("ajax","bad-response-type","ajax/bad-response-type",789441015),resp_type__$1,new cljs.core.Keyword("ajax","resp-as-text","ajax/resp-as-text",141416819),xhr.getResponseText()], null);
} else {
throw e34141;

}
}})():null);
var cb_arg = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"raw-resp","raw-resp",-1924342506),resp,new cljs.core.Keyword(null,"xhr","xhr",-177710851),xhr,new cljs.core.Keyword(null,"success?","success?",-122854052),success_QMARK_,new cljs.core.Keyword(null,"?content-type","?content-type",-2129759049),(cljs.core.truth_(_QMARK_http_status)?_QMARK_content_type:null),new cljs.core.Keyword(null,"?content","?content",1697782054),_QMARK_content,new cljs.core.Keyword(null,"?status","?status",938730360),_QMARK_http_status,new cljs.core.Keyword(null,"?error","?error",1070752222),(function (){var or__16349__auto__ = (cljs.core.truth_(_QMARK_http_status)?(function (){var n = _QMARK_http_status;
if(cljs.core.truth_(success_QMARK_)){
return null;
} else {
return _QMARK_http_status;
}
})():cljs.core.get.call(null,cljs.core.PersistentArrayMap.fromArray([goog.net.ErrorCode.EXCEPTION,new cljs.core.Keyword(null,"exception","exception",-335277064),goog.net.ErrorCode.HTTP_ERROR,new cljs.core.Keyword(null,"http-error","http-error",-1040049553),goog.net.ErrorCode.ABORT,new cljs.core.Keyword(null,"abort","abort",521193198),goog.net.ErrorCode.TIMEOUT,new cljs.core.Keyword(null,"timeout","timeout",-318625318)], true, false),xhr.getLastErrorCode(),new cljs.core.Keyword(null,"unknown","unknown",-935977881)));
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
if(((_QMARK_content == null)) && (cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(204),null,(1223),null], null), null).call(null,_QMARK_http_status)))){
return new cljs.core.Keyword(null,"no-content","no-content",-1860206018);
} else {
return null;
}
}
})()], null);
return callback.call(null,cb_arg);
});})(G__34132_34145,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__34130,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4423__auto__,map__34126,map__34126__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
);


var temp__4425__auto___34147 = progress_fn;
if(cljs.core.truth_(temp__4425__auto___34147)){
var pf_34148 = temp__4425__auto___34147;
goog.events.listen(xhr,goog.net.EventType.PROGRESS,((function (pf_34148,temp__4425__auto___34147,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__34130,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4423__auto__,map__34126,map__34126__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (ev){
var length_computable_QMARK_ = ev.lengthComputable;
var loaded = ev.loaded;
var total = ev.total;
var _QMARK_ratio = (cljs.core.truth_((function (){var and__16337__auto__ = length_computable_QMARK_;
if(cljs.core.truth_(and__16337__auto__)){
return cljs.core.not_EQ_.call(null,total,(0));
} else {
return and__16337__auto__;
}
})())?(loaded / total):null);
return pf_34148.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"?ratio","?ratio",-1275760831),_QMARK_ratio,new cljs.core.Keyword(null,"length-computable?","length-computable?",1915473276),length_computable_QMARK_,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),loaded,new cljs.core.Keyword(null,"total","total",1916810418),total,new cljs.core.Keyword(null,"ev","ev",-406827324),ev], null));
});})(pf_34148,temp__4425__auto___34147,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__34130,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4423__auto__,map__34126,map__34126__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
);
} else {
}

var G__34143_34149 = xhr;
var temp__4425__auto___34150 = new cljs.core.Keyword(null,"always","always",-1772028770);
if(cljs.core.truth_(temp__4425__auto___34150)){
var x_34151 = temp__4425__auto___34150;
G__34143_34149.setTimeoutInterval((function (){var or__16349__auto__ = timeout_ms__$1;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return (0);
}
})());
} else {
}

var temp__4425__auto___34152 = with_credentials_QMARK_;
if(cljs.core.truth_(temp__4425__auto___34152)){
var x_34153 = temp__4425__auto___34152;
G__34143_34149.setWithCredentials(true);
} else {
}

var temp__4425__auto___34154 = new cljs.core.Keyword(null,"always","always",-1772028770);
if(cljs.core.truth_(temp__4425__auto___34154)){
var x_34155 = temp__4425__auto___34154;
G__34143_34149.send(uri_STAR_,method_STAR_,post_content_STAR_,headers_STAR_);
} else {
}


return xhr;
}catch (e34129){if((e34129 instanceof Error)){
var e = e34129;
cljs.core.deref.call(null,taoensso.encore.xhr_pool_).releaseObject(xhr);

return null;
} else {
throw e34129;

}
}} else {
callback.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"?error","?error",1070752222),new cljs.core.Keyword(null,"xhr-pool-depleted","xhr-pool-depleted",-1812092376)], null));

return null;
}
});
/**
 * Stolen from http://goo.gl/99NSR1
 */
taoensso.encore.url_encode = (function taoensso$encore$url_encode(s){
if(cljs.core.truth_(s)){
return clojure.string.replace.call(null,clojure.string.replace.call(null,encodeURIComponent([cljs.core.str(s)].join(''),s),"*","%2A"),"'","%27");
} else {
return null;
}
});
/**
 * Stolen from http://goo.gl/99NSR1
 */
taoensso.encore.url_decode = (function taoensso$encore$url_decode(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34160 = arguments.length;
var i__17408__auto___34161 = (0);
while(true){
if((i__17408__auto___34161 < len__17407__auto___34160)){
args__17414__auto__.push((arguments[i__17408__auto___34161]));

var G__34162 = (i__17408__auto___34161 + (1));
i__17408__auto___34161 = G__34162;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__34158){
var vec__34159 = p__34158;
var encoding = cljs.core.nth.call(null,vec__34159,(0),null);
if(cljs.core.truth_(s)){
return decodeURIComponent(s);
} else {
return null;
}
});

taoensso.encore.url_decode.cljs$lang$maxFixedArity = (1);

taoensso.encore.url_decode.cljs$lang$applyTo = (function (seq34156){
var G__34157 = cljs.core.first.call(null,seq34156);
var seq34156__$1 = cljs.core.next.call(null,seq34156);
return taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(G__34157,seq34156__$1);
});
taoensso.encore.format_query_string = (function taoensso$encore$format_query_string(m){
var param = (function (k,v){
return [cljs.core.str(taoensso.encore.url_encode.call(null,taoensso.encore.qname.call(null,k))),cljs.core.str("="),cljs.core.str(taoensso.encore.url_encode.call(null,(function (){var or__16349__auto__ = taoensso.encore.as__QMARK_qname.call(null,v);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return [cljs.core.str(v)].join('');
}
})()))].join('');
});
var join = ((function (param){
return (function (strs){
return clojure.string.join.call(null,"&",strs);
});})(param))
;
if(cljs.core.empty_QMARK_.call(null,m)){
return "";
} else {
return join.call(null,(function (){var iter__17121__auto__ = ((function (param,join){
return (function taoensso$encore$format_query_string_$_iter__34171(s__34172){
return (new cljs.core.LazySeq(null,((function (param,join){
return (function (){
var s__34172__$1 = s__34172;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__34172__$1);
if(temp__4425__auto__){
var s__34172__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__34172__$2)){
var c__17119__auto__ = cljs.core.chunk_first.call(null,s__34172__$2);
var size__17120__auto__ = cljs.core.count.call(null,c__17119__auto__);
var b__34174 = cljs.core.chunk_buffer.call(null,size__17120__auto__);
if((function (){var i__34173 = (0);
while(true){
if((i__34173 < size__17120__auto__)){
var vec__34177 = cljs.core._nth.call(null,c__17119__auto__,i__34173);
var k = cljs.core.nth.call(null,vec__34177,(0),null);
var v = cljs.core.nth.call(null,vec__34177,(1),null);
if(cljs.core.truth_(taoensso.encore.nnil_QMARK_.call(null,v))){
cljs.core.chunk_append.call(null,b__34174,((cljs.core.sequential_QMARK_.call(null,v))?join.call(null,cljs.core.mapv.call(null,cljs.core.partial.call(null,param,k),(function (){var or__16349__auto__ = cljs.core.seq.call(null,v);
if(or__16349__auto__){
return or__16349__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
}
})())):param.call(null,k,v)));

var G__34179 = (i__34173 + (1));
i__34173 = G__34179;
continue;
} else {
var G__34180 = (i__34173 + (1));
i__34173 = G__34180;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34174),taoensso$encore$format_query_string_$_iter__34171.call(null,cljs.core.chunk_rest.call(null,s__34172__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__34174),null);
}
} else {
var vec__34178 = cljs.core.first.call(null,s__34172__$2);
var k = cljs.core.nth.call(null,vec__34178,(0),null);
var v = cljs.core.nth.call(null,vec__34178,(1),null);
if(cljs.core.truth_(taoensso.encore.nnil_QMARK_.call(null,v))){
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,v))?join.call(null,cljs.core.mapv.call(null,cljs.core.partial.call(null,param,k),(function (){var or__16349__auto__ = cljs.core.seq.call(null,v);
if(or__16349__auto__){
return or__16349__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
}
})())):param.call(null,k,v)),taoensso$encore$format_query_string_$_iter__34171.call(null,cljs.core.rest.call(null,s__34172__$2)));
} else {
var G__34181 = cljs.core.rest.call(null,s__34172__$2);
s__34172__$1 = G__34181;
continue;
}
}
} else {
return null;
}
break;
}
});})(param,join))
,null,null));
});})(param,join))
;
return iter__17121__auto__.call(null,m);
})());
}
});
taoensso.encore.assoc_conj = (function taoensso$encore$assoc_conj(m,k,v){
return cljs.core.assoc.call(null,m,k,(function (){var temp__4423__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(temp__4423__auto__)){
var cur = temp__4423__auto__;
if(cljs.core.vector_QMARK_.call(null,cur)){
return cljs.core.conj.call(null,cur,v);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cur,v], null);
}
} else {
return v;
}
})());
});
/**
 * Based on `ring-codec/form-decode`
 */
taoensso.encore.parse_query_params = (function taoensso$encore$parse_query_params(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34188 = arguments.length;
var i__17408__auto___34189 = (0);
while(true){
if((i__17408__auto___34189 < len__17407__auto___34188)){
args__17414__auto__.push((arguments[i__17408__auto___34189]));

var G__34190 = (i__17408__auto___34189 + (1));
i__17408__auto___34189 = G__34190;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__34184){
var vec__34185 = p__34184;
var keywordize_QMARK_ = cljs.core.nth.call(null,vec__34185,(0),null);
var encoding = cljs.core.nth.call(null,vec__34185,(1),null);
var _PERCENT_ = (cljs.core.truth_(clojure.string.blank_QMARK_.call(null,s))?cljs.core.PersistentArrayMap.EMPTY:(function (){var s__$1 = (cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_.call(null,s,"?"))?taoensso.encore.substr.call(null,s,(1)):s);
if(cljs.core.not.call(null,taoensso.encore.str_contains_QMARK_.call(null,s__$1,"="))){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var m = cljs.core.reduce.call(null,((function (s__$1,vec__34185,keywordize_QMARK_,encoding){
return (function (m,param){
var temp__4423__auto__ = clojure.string.split.call(null,param,/=/,(2));
if(cljs.core.truth_(temp__4423__auto__)){
var vec__34186 = temp__4423__auto__;
var k = cljs.core.nth.call(null,vec__34186,(0),null);
var v = cljs.core.nth.call(null,vec__34186,(1),null);
return taoensso.encore.assoc_conj.call(null,m,taoensso.encore.url_decode.call(null,k,encoding),taoensso.encore.url_decode.call(null,v,encoding));
} else {
return m;
}
});})(s__$1,vec__34185,keywordize_QMARK_,encoding))
,cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,s__$1,/&/));
if(cljs.core.not.call(null,keywordize_QMARK_)){
return m;
} else {
return taoensso.encore.keywordize_map.call(null,m);
}
}
})());
if(cljs.core.truth_((function (){var __x = _PERCENT_;
try{if(cljs.core.map_QMARK_.call(null,__x)){
return true;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e34187){if((e34187 instanceof Error)){
var t = e34187;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.encore",2489,"(map? %)",__x,t);
} else {
throw e34187;

}
}})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.Symbol(null,"map?","map?",-1780568534,null),new cljs.core.Symbol(null,"%","%",-950237169,null))))].join('')));
}

return _PERCENT_;
});

taoensso.encore.parse_query_params.cljs$lang$maxFixedArity = (1);

taoensso.encore.parse_query_params.cljs$lang$applyTo = (function (seq34182){
var G__34183 = cljs.core.first.call(null,seq34182);
var seq34182__$1 = cljs.core.next.call(null,seq34182);
return taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic(G__34183,seq34182__$1);
});
taoensso.encore.merge_url_with_query_string = (function taoensso$encore$merge_url_with_query_string(url,m){
var vec__34192 = clojure.string.split.call(null,[cljs.core.str(url)].join(''),/\?/,(2));
var url__$1 = cljs.core.nth.call(null,vec__34192,(0),null);
var _QMARK_qstr = cljs.core.nth.call(null,vec__34192,(1),null);
var qmap = cljs.core.merge.call(null,(cljs.core.truth_(_QMARK_qstr)?taoensso.encore.keywordize_map.call(null,taoensso.encore.parse_query_params.call(null,_QMARK_qstr)):null),taoensso.encore.keywordize_map.call(null,m));
var _QMARK_qstr__$1 = taoensso.encore.as__QMARK_nblank.call(null,taoensso.encore.format_query_string.call(null,qmap));
var temp__4423__auto__ = _QMARK_qstr__$1;
if(cljs.core.truth_(temp__4423__auto__)){
var qstr = temp__4423__auto__;
return [cljs.core.str(url__$1),cljs.core.str("?"),cljs.core.str(qstr)].join('');
} else {
return url__$1;
}
});
taoensso.encore.backport_run_BANG_ = taoensso.encore.run_BANG__STAR_;
taoensso.encore.fq_name = taoensso.encore.qname;
taoensso.encore.round = (function taoensso$encore$round(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34197 = arguments.length;
var i__17408__auto___34198 = (0);
while(true){
if((i__17408__auto___34198 < len__17407__auto___34197)){
args__17414__auto__.push((arguments[i__17408__auto___34198]));

var G__34199 = (i__17408__auto___34198 + (1));
i__17408__auto___34198 = G__34199;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__34195){
var vec__34196 = p__34195;
var type = cljs.core.nth.call(null,vec__34196,(0),null);
var nplaces = cljs.core.nth.call(null,vec__34196,(1),null);
return taoensso.encore.round_STAR_.call(null,(function (){var or__16349__auto__ = type;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return new cljs.core.Keyword(null,"round","round",2009433328);
}
})(),nplaces,n);
});

taoensso.encore.round.cljs$lang$maxFixedArity = (1);

taoensso.encore.round.cljs$lang$applyTo = (function (seq34193){
var G__34194 = cljs.core.first.call(null,seq34193);
var seq34193__$1 = cljs.core.next.call(null,seq34193);
return taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic(G__34194,seq34193__$1);
});
taoensso.encore.memoize_1 = taoensso.encore.memoize1;
taoensso.encore.logging_level = cljs.core.atom.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596));
taoensso.encore.set_exp_backoff_timeout_BANG_ = (function taoensso$encore$set_exp_backoff_timeout_BANG_(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34204 = arguments.length;
var i__17408__auto___34205 = (0);
while(true){
if((i__17408__auto___34205 < len__17407__auto___34204)){
args__17414__auto__.push((arguments[i__17408__auto___34205]));

var G__34206 = (i__17408__auto___34205 + (1));
i__17408__auto___34205 = G__34206;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (nullary_f,p__34202){
var vec__34203 = p__34202;
var nattempt = cljs.core.nth.call(null,vec__34203,(0),null);
return window.setTimeout(nullary_f,taoensso.encore.exp_backoff.call(null,(function (){var or__16349__auto__ = nattempt;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return (0);
}
})()));
});

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$lang$applyTo = (function (seq34200){
var G__34201 = cljs.core.first.call(null,seq34200);
var seq34200__$1 = cljs.core.next.call(null,seq34200);
return taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34201,seq34200__$1);
});
taoensso.encore.keys_EQ_ = (function taoensso$encore$keys_EQ_(m,ks){
return taoensso.encore.ks_EQ_.call(null,ks,m);
});
taoensso.encore.keys_LT__EQ_ = (function taoensso$encore$keys_LT__EQ_(m,ks){
return taoensso.encore.ks_LT__EQ_.call(null,ks,m);
});
taoensso.encore.keys_GT__EQ_ = (function taoensso$encore$keys_GT__EQ_(m,ks){
return taoensso.encore.ks_GT__EQ_.call(null,ks,m);
});
taoensso.encore.keys_EQ_nnil_QMARK_ = (function taoensso$encore$keys_EQ_nnil_QMARK_(m,ks){
return taoensso.encore.ks_nnil_QMARK_.call(null,ks,m);
});
taoensso.encore.parse_bool = taoensso.encore.as__QMARK_bool;
taoensso.encore.parse_int = taoensso.encore.as__QMARK_int;
taoensso.encore.parse_float = taoensso.encore.as__QMARK_float;
taoensso.encore.merge_deep_with = taoensso.encore.nested_merge_with;
taoensso.encore.merge_deep = taoensso.encore.nested_merge;
taoensso.encore.rate_limiter = (function taoensso$encore$rate_limiter(ncalls_limit,window_ms){
return taoensso.encore.rate_limiter_STAR_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls_limit,window_ms], null)], null));
});
taoensso.encore.rate_limited = (function taoensso$encore$rate_limited(ncalls_limit,window_ms,f){
var rl = taoensso.encore.rate_limiter_STAR_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls_limit,window_ms], null)], null));
return ((function (rl){
return (function() { 
var G__34207__delegate = function (args){
var temp__4423__auto__ = rl.call(null);
if(cljs.core.truth_(temp__4423__auto__)){
var backoff_ms = temp__4423__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"backoff-ms","backoff-ms",1679281507),backoff_ms], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"result","result",1415092211),f.call(null)], null);
}
};
var G__34207 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34208__i = 0, G__34208__a = new Array(arguments.length -  0);
while (G__34208__i < G__34208__a.length) {G__34208__a[G__34208__i] = arguments[G__34208__i + 0]; ++G__34208__i;}
  args = new cljs.core.IndexedSeq(G__34208__a,0);
} 
return G__34207__delegate.call(this,args);};
G__34207.cljs$lang$maxFixedArity = 0;
G__34207.cljs$lang$applyTo = (function (arglist__34209){
var args = cljs.core.seq(arglist__34209);
return G__34207__delegate(args);
});
G__34207.cljs$core$IFn$_invoke$arity$variadic = G__34207__delegate;
return G__34207;
})()
;
;})(rl))
});
if(typeof taoensso.encore._STAR_log_level_STAR_ !== 'undefined'){
} else {
/**
 * DEPRECATED
 */
taoensso.encore._STAR_log_level_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596);
}

taoensso.encore.log_QMARK_ = (function (){var __GT_n = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"trace","trace",-1082747415),(1),new cljs.core.Keyword(null,"debug","debug",-1608172596),(2),new cljs.core.Keyword(null,"info","info",-317069002),(3),new cljs.core.Keyword(null,"warn","warn",-436710552),(4),new cljs.core.Keyword(null,"error","error",-978969032),(5),new cljs.core.Keyword(null,"fatal","fatal",1874419888),(6),new cljs.core.Keyword(null,"report","report",1394055010),(7)], null);
return ((function (__GT_n){
return (function (level){
return (__GT_n.call(null,level) >= __GT_n.call(null,taoensso.encore._STAR_log_level_STAR_));
});
;})(__GT_n))
})();

taoensso.encore.tracef = (function taoensso$encore$tracef(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34224 = arguments.length;
var i__17408__auto___34225 = (0);
while(true){
if((i__17408__auto___34225 < len__17407__auto___34224)){
args__17414__auto__.push((arguments[i__17408__auto___34225]));

var G__34226 = (i__17408__auto___34225 + (1));
i__17408__auto___34225 = G__34226;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_(taoensso.encore.log_QMARK_.call(null,new cljs.core.Keyword(null,"trace","trace",-1082747415)))){
return cljs.core.apply.call(null,taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.tracef.cljs$lang$maxFixedArity = (1);

taoensso.encore.tracef.cljs$lang$applyTo = (function (seq34210){
var G__34211 = cljs.core.first.call(null,seq34210);
var seq34210__$1 = cljs.core.next.call(null,seq34210);
return taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic(G__34211,seq34210__$1);
});

taoensso.encore.debugf = (function taoensso$encore$debugf(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34227 = arguments.length;
var i__17408__auto___34228 = (0);
while(true){
if((i__17408__auto___34228 < len__17407__auto___34227)){
args__17414__auto__.push((arguments[i__17408__auto___34228]));

var G__34229 = (i__17408__auto___34228 + (1));
i__17408__auto___34228 = G__34229;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_(taoensso.encore.log_QMARK_.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596)))){
return cljs.core.apply.call(null,taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.debugf.cljs$lang$maxFixedArity = (1);

taoensso.encore.debugf.cljs$lang$applyTo = (function (seq34212){
var G__34213 = cljs.core.first.call(null,seq34212);
var seq34212__$1 = cljs.core.next.call(null,seq34212);
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic(G__34213,seq34212__$1);
});

taoensso.encore.infof = (function taoensso$encore$infof(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34230 = arguments.length;
var i__17408__auto___34231 = (0);
while(true){
if((i__17408__auto___34231 < len__17407__auto___34230)){
args__17414__auto__.push((arguments[i__17408__auto___34231]));

var G__34232 = (i__17408__auto___34231 + (1));
i__17408__auto___34231 = G__34232;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_(taoensso.encore.log_QMARK_.call(null,new cljs.core.Keyword(null,"info","info",-317069002)))){
return cljs.core.apply.call(null,taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.infof.cljs$lang$maxFixedArity = (1);

taoensso.encore.infof.cljs$lang$applyTo = (function (seq34214){
var G__34215 = cljs.core.first.call(null,seq34214);
var seq34214__$1 = cljs.core.next.call(null,seq34214);
return taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic(G__34215,seq34214__$1);
});

taoensso.encore.warnf = (function taoensso$encore$warnf(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34233 = arguments.length;
var i__17408__auto___34234 = (0);
while(true){
if((i__17408__auto___34234 < len__17407__auto___34233)){
args__17414__auto__.push((arguments[i__17408__auto___34234]));

var G__34235 = (i__17408__auto___34234 + (1));
i__17408__auto___34234 = G__34235;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_(taoensso.encore.log_QMARK_.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552)))){
return cljs.core.apply.call(null,taoensso.encore.logf,[cljs.core.str("WARN: "),cljs.core.str(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.warnf.cljs$lang$maxFixedArity = (1);

taoensso.encore.warnf.cljs$lang$applyTo = (function (seq34216){
var G__34217 = cljs.core.first.call(null,seq34216);
var seq34216__$1 = cljs.core.next.call(null,seq34216);
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic(G__34217,seq34216__$1);
});

taoensso.encore.errorf = (function taoensso$encore$errorf(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34236 = arguments.length;
var i__17408__auto___34237 = (0);
while(true){
if((i__17408__auto___34237 < len__17407__auto___34236)){
args__17414__auto__.push((arguments[i__17408__auto___34237]));

var G__34238 = (i__17408__auto___34237 + (1));
i__17408__auto___34237 = G__34238;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_(taoensso.encore.log_QMARK_.call(null,new cljs.core.Keyword(null,"error","error",-978969032)))){
return cljs.core.apply.call(null,taoensso.encore.logf,[cljs.core.str("ERROR: "),cljs.core.str(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.errorf.cljs$lang$maxFixedArity = (1);

taoensso.encore.errorf.cljs$lang$applyTo = (function (seq34218){
var G__34219 = cljs.core.first.call(null,seq34218);
var seq34218__$1 = cljs.core.next.call(null,seq34218);
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic(G__34219,seq34218__$1);
});

taoensso.encore.fatalf = (function taoensso$encore$fatalf(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34239 = arguments.length;
var i__17408__auto___34240 = (0);
while(true){
if((i__17408__auto___34240 < len__17407__auto___34239)){
args__17414__auto__.push((arguments[i__17408__auto___34240]));

var G__34241 = (i__17408__auto___34240 + (1));
i__17408__auto___34240 = G__34241;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_(taoensso.encore.log_QMARK_.call(null,new cljs.core.Keyword(null,"fatal","fatal",1874419888)))){
return cljs.core.apply.call(null,taoensso.encore.logf,[cljs.core.str("FATAL: "),cljs.core.str(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.fatalf.cljs$lang$maxFixedArity = (1);

taoensso.encore.fatalf.cljs$lang$applyTo = (function (seq34220){
var G__34221 = cljs.core.first.call(null,seq34220);
var seq34220__$1 = cljs.core.next.call(null,seq34220);
return taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic(G__34221,seq34220__$1);
});

taoensso.encore.reportf = (function taoensso$encore$reportf(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34242 = arguments.length;
var i__17408__auto___34243 = (0);
while(true){
if((i__17408__auto___34243 < len__17407__auto___34242)){
args__17414__auto__.push((arguments[i__17408__auto___34243]));

var G__34244 = (i__17408__auto___34243 + (1));
i__17408__auto___34243 = G__34244;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_(taoensso.encore.log_QMARK_.call(null,new cljs.core.Keyword(null,"report","report",1394055010)))){
return cljs.core.apply.call(null,taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.reportf.cljs$lang$maxFixedArity = (1);

taoensso.encore.reportf.cljs$lang$applyTo = (function (seq34222){
var G__34223 = cljs.core.first.call(null,seq34222);
var seq34222__$1 = cljs.core.next.call(null,seq34222);
return taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic(G__34223,seq34222__$1);
});
/**
 * Deprecated
 */
taoensso.encore.greatest = (function taoensso$encore$greatest(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34251 = arguments.length;
var i__17408__auto___34252 = (0);
while(true){
if((i__17408__auto___34252 < len__17407__auto___34251)){
args__17414__auto__.push((arguments[i__17408__auto___34252]));

var G__34253 = (i__17408__auto___34252 + (1));
i__17408__auto___34252 = G__34253;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic = (function (coll,p__34249){
var vec__34250 = p__34249;
var _QMARK_comparator = cljs.core.nth.call(null,vec__34250,(0),null);
var comparator = (function (){var or__16349__auto__ = _QMARK_comparator;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore.rcompare;
}
})();
return cljs.core.reduce.call(null,((function (comparator,vec__34250,_QMARK_comparator){
return (function (p1__34245_SHARP_,p2__34246_SHARP_){
if((comparator.call(null,p1__34245_SHARP_,p2__34246_SHARP_) > (0))){
return p2__34246_SHARP_;
} else {
return p1__34245_SHARP_;
}
});})(comparator,vec__34250,_QMARK_comparator))
,coll);
});

taoensso.encore.greatest.cljs$lang$maxFixedArity = (1);

taoensso.encore.greatest.cljs$lang$applyTo = (function (seq34247){
var G__34248 = cljs.core.first.call(null,seq34247);
var seq34247__$1 = cljs.core.next.call(null,seq34247);
return taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic(G__34248,seq34247__$1);
});
/**
 * Deprecated
 */
taoensso.encore.least = (function taoensso$encore$least(var_args){
var args__17414__auto__ = [];
var len__17407__auto___34260 = arguments.length;
var i__17408__auto___34261 = (0);
while(true){
if((i__17408__auto___34261 < len__17407__auto___34260)){
args__17414__auto__.push((arguments[i__17408__auto___34261]));

var G__34262 = (i__17408__auto___34261 + (1));
i__17408__auto___34261 = G__34262;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic = (function (coll,p__34258){
var vec__34259 = p__34258;
var _QMARK_comparator = cljs.core.nth.call(null,vec__34259,(0),null);
var comparator = (function (){var or__16349__auto__ = _QMARK_comparator;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore.rcompare;
}
})();
return cljs.core.reduce.call(null,((function (comparator,vec__34259,_QMARK_comparator){
return (function (p1__34254_SHARP_,p2__34255_SHARP_){
if((comparator.call(null,p1__34254_SHARP_,p2__34255_SHARP_) < (0))){
return p2__34255_SHARP_;
} else {
return p1__34254_SHARP_;
}
});})(comparator,vec__34259,_QMARK_comparator))
,coll);
});

taoensso.encore.least.cljs$lang$maxFixedArity = (1);

taoensso.encore.least.cljs$lang$applyTo = (function (seq34256){
var G__34257 = cljs.core.first.call(null,seq34256);
var seq34256__$1 = cljs.core.next.call(null,seq34256);
return taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic(G__34257,seq34256__$1);
});
taoensso.encore.clj1098 = (function taoensso$encore$clj1098(x){
var or__16349__auto__ = x;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});

//# sourceMappingURL=encore.js.map?rel=1449783501849