// Compiled by ClojureScript 1.7.122 {}
goog.provide('taoensso.sente');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('taoensso.sente.interfaces');
goog.require('cljs.core.async');
goog.require('taoensso.encore');
goog.require('clojure.string');
if(cljs.core.vector_QMARK_.call(null,taoensso.encore.encore_version)){
taoensso.encore.assert_min_encore_version.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),(11),(0)], null));
} else {
taoensso.encore.assert_min_encore_version.call(null,2.11);
}
taoensso.sente.validate_event = (function taoensso$sente$validate_event(x){
if(!(cljs.core.vector_QMARK_.call(null,x))){
return new cljs.core.Keyword(null,"wrong-type","wrong-type",929556915);
} else {
if(cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(1),null,(2),null], null), null).call(null,cljs.core.count.call(null,x)))){
return new cljs.core.Keyword(null,"wrong-length","wrong-length",1367572281);
} else {
var vec__33072 = x;
var ev_id = cljs.core.nth.call(null,vec__33072,(0),null);
var _ = cljs.core.nth.call(null,vec__33072,(1),null);
if(!((ev_id instanceof cljs.core.Keyword))){
return new cljs.core.Keyword(null,"wrong-id-type","wrong-id-type",-1213601689);
} else {
if(cljs.core.not.call(null,cljs.core.namespace.call(null,ev_id))){
return new cljs.core.Keyword(null,"unnamespaced-id","unnamespaced-id",1976189772);
} else {
return null;

}
}

}
}
});
/**
 * Valid [ev-id ?ev-data] form?
 */
taoensso.sente.event_QMARK_ = (function taoensso$sente$event_QMARK_(x){
return (taoensso.sente.validate_event.call(null,x) == null);
});
taoensso.sente.as_event = (function taoensso$sente$as_event(x){
if(cljs.core.truth_(taoensso.sente.event_QMARK_.call(null,x))){
return x;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","bad-event","chsk/bad-event",-565206930),x], null);
}
});
taoensso.sente.assert_event = (function taoensso$sente$assert_event(x){
var temp__4425__auto__ = taoensso.sente.validate_event.call(null,x);
if(cljs.core.truth_(temp__4425__auto__)){
var _QMARK_err = temp__4425__auto__;
var err_fmt = [cljs.core.str((function (){var G__33074 = (((_QMARK_err instanceof cljs.core.Keyword))?_QMARK_err.fqn:null);
switch (G__33074) {
case "wrong-type":
return "Malformed event (wrong type).";

break;
case "wrong-length":
return "Malformed event (wrong length).";

break;
case "wrong-id-type":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "unnamespaced-id":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "else":
return "Malformed event (unknown error).";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(_QMARK_err)].join('')));

}
})()),cljs.core.str(" Event should be of `[ev-id ?ev-data]` form: %s")].join('');
throw cljs.core.ex_info.call(null,taoensso.encore.format.call(null,err_fmt,[cljs.core.str(x)].join('')),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"malformed-event","malformed-event",-2090896605),x], null));
} else {
return null;
}
});
taoensso.sente.event_msg_QMARK_ = (function taoensso$sente$event_msg_QMARK_(x){
var and__16337__auto__ = cljs.core.map_QMARK_.call(null,x);
if(and__16337__auto__){
var and__16337__auto____$1 = taoensso.encore.keys_EQ_.call(null,x,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"event","event",301435442),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"?data","?data",-9471433),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null], null), null));
if(cljs.core.truth_(and__16337__auto____$1)){
var map__33078 = x;
var map__33078__$1 = ((((!((map__33078 == null)))?((((map__33078.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33078.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33078):map__33078);
var ch_recv = cljs.core.get.call(null,map__33078__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.call(null,map__33078__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__33078__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__33078__$1,new cljs.core.Keyword(null,"event","event",301435442));
var and__16337__auto____$2 = taoensso.encore.chan_QMARK_.call(null,ch_recv);
if(cljs.core.truth_(and__16337__auto____$2)){
var and__16337__auto____$3 = cljs.core.ifn_QMARK_.call(null,send_fn);
if(and__16337__auto____$3){
var and__16337__auto____$4 = taoensso.encore.atom_QMARK_.call(null,state);
if(cljs.core.truth_(and__16337__auto____$4)){
return taoensso.sente.event_QMARK_.call(null,event);
} else {
return and__16337__auto____$4;
}
} else {
return and__16337__auto____$3;
}
} else {
return and__16337__auto____$2;
}
} else {
return and__16337__auto____$1;
}
} else {
return and__16337__auto__;
}
});
taoensso.sente.cb_error_QMARK_ = (function taoensso$sente$cb_error_QMARK_(cb_reply_clj){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264),null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439),null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489),null], null), null).call(null,cb_reply_clj);
});
taoensso.sente.cb_success_QMARK_ = (function taoensso$sente$cb_success_QMARK_(cb_reply_clj){
return cljs.core.not.call(null,taoensso.sente.cb_error_QMARK_.call(null,cb_reply_clj));
});
/**
 * pstr->clj
 */
taoensso.sente.unpack_STAR_ = (function taoensso$sente$unpack_STAR_(packer,pstr){
try{return taoensso.sente.interfaces.unpack.call(null,packer,(function (){var __x = pstr;
try{if(typeof __x === 'string'){
return __x;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33083){if((e33083 instanceof Error)){
var t = e33083;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.sente",170,"(string? pstr)",__x,t);
} else {
throw e33083;

}
}})());
}catch (e33082){var t = e33082;
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (t){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Bad package: %s (%s)",pstr,t], null);
});})(t))
,null)),null);

throw t;
}});
taoensso.sente.with__QMARK_meta = (function taoensso$sente$with__QMARK_meta(x,_QMARK_m){
if(cljs.core.seq.call(null,_QMARK_m)){
return cljs.core.with_meta.call(null,x,_QMARK_m);
} else {
return x;
}
});
/**
 * clj->prefixed-pstr
 */
taoensso.sente.pack_STAR_ = (function taoensso$sente$pack_STAR_(var_args){
var args33084 = [];
var len__17407__auto___33087 = arguments.length;
var i__17408__auto___33088 = (0);
while(true){
if((i__17408__auto___33088 < len__17407__auto___33087)){
args33084.push((arguments[i__17408__auto___33088]));

var G__33089 = (i__17408__auto___33088 + (1));
i__17408__auto___33088 = G__33089;
continue;
} else {
}
break;
}

var G__33086 = args33084.length;
switch (G__33086) {
case 3:
return taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33084.length)].join('')));

}
});

taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (packer,_QMARK_packer_meta,clj){
return [cljs.core.str("-"),cljs.core.str(taoensso.sente.interfaces.pack.call(null,packer,taoensso.sente.with__QMARK_meta.call(null,clj,_QMARK_packer_meta)))].join('');
});

taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (packer,_QMARK_packer_meta,clj,_QMARK_cb_uuid){
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.call(null,_QMARK_cb_uuid,new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321)))?(0):_QMARK_cb_uuid);
var wrapped_clj = (cljs.core.truth_(_QMARK_cb_uuid__$1)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,_QMARK_cb_uuid__$1], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj], null));
return [cljs.core.str("+"),cljs.core.str(taoensso.sente.interfaces.pack.call(null,packer,taoensso.sente.with__QMARK_meta.call(null,wrapped_clj,_QMARK_packer_meta)))].join('');
});

taoensso.sente.pack_STAR_.cljs$lang$maxFixedArity = 4;
taoensso.sente.pack = (function taoensso$sente$pack(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33092 = arguments.length;
var i__17408__auto___33093 = (0);
while(true){
if((i__17408__auto___33093 < len__17407__auto___33092)){
args__17414__auto__.push((arguments[i__17408__auto___33093]));

var G__33094 = (i__17408__auto___33093 + (1));
i__17408__auto___33093 = G__33094;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((0) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((0)),(0))):null);
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(argseq__17415__auto__);
});

taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var pstr = cljs.core.apply.call(null,taoensso.sente.pack_STAR_,args);
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (pstr){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Packing: %s -> %s",args,pstr], null);
});})(pstr))
,null)),null);

return pstr;
});

taoensso.sente.pack.cljs$lang$maxFixedArity = (0);

taoensso.sente.pack.cljs$lang$applyTo = (function (seq33091){
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33091));
});
/**
 * prefixed-pstr->[clj ?cb-uuid]
 */
taoensso.sente.unpack = (function taoensso$sente$unpack(packer,prefixed_pstr){
var __x_33101 = prefixed_pstr;
try{if(typeof __x_33101 === 'string'){
} else {
taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33098){if((e33098 instanceof Error)){
var t_33102 = e33098;
taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.sente",197,"(string? prefixed-pstr)",__x_33101,t_33102);
} else {
throw e33098;

}
}
var prefix = taoensso.encore.substr.call(null,prefixed_pstr,(0),(1));
var pstr = taoensso.encore.substr.call(null,prefixed_pstr,(1));
var clj = taoensso.sente.unpack_STAR_.call(null,packer,pstr);
var wrapped_QMARK_ = (function (){var G__33100 = prefix;
switch (G__33100) {
case "-":
return false;

break;
case "+":
return true;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(prefix)].join('')));

}
})();
var vec__33099 = (cljs.core.truth_(wrapped_QMARK_)?clj:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,null], null));
var clj__$1 = cljs.core.nth.call(null,vec__33099,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__33099,(1),null);
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.call(null,(0),_QMARK_cb_uuid))?new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321):_QMARK_cb_uuid);
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (prefix,pstr,clj,wrapped_QMARK_,vec__33099,clj__$1,_QMARK_cb_uuid,_QMARK_cb_uuid__$1){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unpacking: %s -> %s",prefixed_pstr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null)], null);
});})(prefix,pstr,clj,wrapped_QMARK_,vec__33099,clj__$1,_QMARK_cb_uuid,_QMARK_cb_uuid__$1))
,null)),null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null);
});

/**
 * @interface
 */
taoensso.sente.IChSocket = function(){};

/**
 * Implementation detail.
 */
taoensso.sente.chsk_init_BANG_ = (function taoensso$sente$chsk_init_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_init_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_init_BANG_$arity$1(chsk);
} else {
var x__17004__auto__ = (((chsk == null))?null:chsk);
var m__17005__auto__ = (taoensso.sente.chsk_init_BANG_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,chsk);
} else {
var m__17005__auto____$1 = (taoensso.sente.chsk_init_BANG_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-init!",chsk);
}
}
}
});

/**
 * Kills socket, stops auto-reconnects.
 */
taoensso.sente.chsk_destroy_BANG_ = (function taoensso$sente$chsk_destroy_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1(chsk);
} else {
var x__17004__auto__ = (((chsk == null))?null:chsk);
var m__17005__auto__ = (taoensso.sente.chsk_destroy_BANG_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,chsk);
} else {
var m__17005__auto____$1 = (taoensso.sente.chsk_destroy_BANG_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-destroy!",chsk);
}
}
}
});

/**
 * Drops connection, allows auto-reconnect. Useful for reauthenticating after login/logout.
 */
taoensso.sente.chsk_reconnect_BANG_ = (function taoensso$sente$chsk_reconnect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1(chsk);
} else {
var x__17004__auto__ = (((chsk == null))?null:chsk);
var m__17005__auto__ = (taoensso.sente.chsk_reconnect_BANG_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,chsk);
} else {
var m__17005__auto____$1 = (taoensso.sente.chsk_reconnect_BANG_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-reconnect!",chsk);
}
}
}
});

/**
 * Implementation detail.
 */
taoensso.sente.chsk_send_BANG__STAR_ = (function taoensso$sente$chsk_send_BANG__STAR_(chsk,ev,opts){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_send_BANG__STAR_$arity$3 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_send_BANG__STAR_$arity$3(chsk,ev,opts);
} else {
var x__17004__auto__ = (((chsk == null))?null:chsk);
var m__17005__auto__ = (taoensso.sente.chsk_send_BANG__STAR_[goog.typeOf(x__17004__auto__)]);
if(!((m__17005__auto__ == null))){
return m__17005__auto__.call(null,chsk,ev,opts);
} else {
var m__17005__auto____$1 = (taoensso.sente.chsk_send_BANG__STAR_["_"]);
if(!((m__17005__auto____$1 == null))){
return m__17005__auto____$1.call(null,chsk,ev,opts);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-send!*",chsk);
}
}
}
});

/**
 * Sends `[ev-id ev-?data :as event]`, returns true on apparent success.
 */
taoensso.sente.chsk_send_BANG_ = (function taoensso$sente$chsk_send_BANG_(var_args){
var args33104 = [];
var len__17407__auto___33107 = arguments.length;
var i__17408__auto___33108 = (0);
while(true){
if((i__17408__auto___33108 < len__17407__auto___33107)){
args33104.push((arguments[i__17408__auto___33108]));

var G__33109 = (i__17408__auto___33108 + (1));
i__17408__auto___33108 = G__33109;
continue;
} else {
}
break;
}

var G__33106 = args33104.length;
switch (G__33106) {
case 2:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33104.length)].join('')));

}
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (chsk,ev){
return taoensso.sente.chsk_send_BANG_.call(null,chsk,ev,cljs.core.PersistentArrayMap.EMPTY);
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (chsk,ev,_QMARK_timeout_ms,_QMARK_cb){
return taoensso.sente.chsk_send_BANG_.call(null,chsk,ev,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),_QMARK_timeout_ms,new cljs.core.Keyword(null,"cb","cb",589947841),_QMARK_cb], null));
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (chsk,ev,opts){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send: (%s) %s",cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"cb","cb",589947841),cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"cb","cb",589947841).cljs$core$IFn$_invoke$arity$1(opts))),ev], null);
}),null)),null);

return taoensso.sente.chsk_send_BANG__STAR_.call(null,chsk,ev,opts);
});

taoensso.sente.chsk_send_BANG_.cljs$lang$maxFixedArity = 4;
taoensso.sente.assert_send_args = (function taoensso$sente$assert_send_args(x,_QMARK_timeout_ms,_QMARK_cb){
taoensso.sente.assert_event.call(null,x);

if(cljs.core.truth_((function (){var or__16349__auto__ = ((_QMARK_timeout_ms == null)) && ((_QMARK_cb == null));
if(or__16349__auto__){
return or__16349__auto__;
} else {
return taoensso.encore.nneg_int_QMARK_.call(null,_QMARK_timeout_ms);
}
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(taoensso.encore.format.call(null,"cb requires a timeout; timeout-ms should be a +ive integer: %s",_QMARK_timeout_ms)),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),cljs.core.list(new cljs.core.Symbol(null,"and","and",668631710,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"?timeout-ms","?timeout-ms",-651193632,null)),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"?cb","?cb",-1346810436,null))),cljs.core.list(new cljs.core.Symbol(null,"and","and",668631710,null),cljs.core.list(new cljs.core.Symbol("enc","nneg-int?","enc/nneg-int?",803640858,null),new cljs.core.Symbol(null,"?timeout-ms","?timeout-ms",-651193632,null))))))].join('')));
}

if(cljs.core.truth_((function (){var or__16349__auto__ = (_QMARK_cb == null);
if(or__16349__auto__){
return or__16349__auto__;
} else {
var or__16349__auto____$1 = cljs.core.ifn_QMARK_.call(null,_QMARK_cb);
if(or__16349__auto____$1){
return or__16349__auto____$1;
} else {
return taoensso.encore.chan_QMARK_.call(null,_QMARK_cb);
}
}
})())){
return null;
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(taoensso.encore.format.call(null,"cb should be nil, an ifn, or a channel: %s",cljs.core.type.call(null,_QMARK_cb))),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"?cb","?cb",-1346810436,null)),cljs.core.list(new cljs.core.Symbol(null,"ifn?","ifn?",-2106461064,null),new cljs.core.Symbol(null,"?cb","?cb",-1346810436,null)),cljs.core.list(new cljs.core.Symbol("enc","chan?","enc/chan?",1377166,null),new cljs.core.Symbol(null,"?cb","?cb",-1346810436,null)))))].join('')));
}
});
taoensso.sente.pull_unused_cb_fn_BANG_ = (function taoensso$sente$pull_unused_cb_fn_BANG_(cbs_waiting_,_QMARK_cb_uuid){
var temp__4425__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4425__auto__)){
var cb_uuid = temp__4425__auto__;
return taoensso.encore.swap_in_BANG_.call(null,cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid], null),((function (cb_uuid,temp__4425__auto__){
return (function (_QMARK_f){
return taoensso.encore.swapped.call(null,new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782),_QMARK_f);
});})(cb_uuid,temp__4425__auto__))
);
} else {
return null;
}
});
taoensso.sente.merge_GT_chsk_state_BANG_ = (function taoensso$sente$merge_GT_chsk_state_BANG_(p__33111,merge_state){
var map__33115 = p__33111;
var map__33115__$1 = ((((!((map__33115 == null)))?((((map__33115.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33115.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33115):map__33115);
var chsk = map__33115__$1;
var chs = cljs.core.get.call(null,map__33115__$1,new cljs.core.Keyword(null,"chs","chs",376886120));
var state_ = cljs.core.get.call(null,map__33115__$1,new cljs.core.Keyword(null,"state_","state_",957667102));
var vec__33117 = taoensso.encore.swap_in_BANG_.call(null,state_,cljs.core.PersistentVector.EMPTY,((function (map__33115,map__33115__$1,chsk,chs,state_){
return (function (old_state){
var new_state = cljs.core.merge.call(null,old_state,merge_state);
var new_state__$1 = ((cljs.core.not.call(null,(function (){var and__16337__auto__ = new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116).cljs$core$IFn$_invoke$arity$1(old_state);
if(cljs.core.truth_(and__16337__auto__)){
var and__16337__auto____$1 = new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(new_state);
if(cljs.core.truth_(and__16337__auto____$1)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(old_state));
} else {
return and__16337__auto____$1;
}
} else {
return and__16337__auto__;
}
})()))?new_state:cljs.core.assoc.call(null,cljs.core.dissoc.call(null,new_state,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116)),new cljs.core.Keyword(null,"requested-reconnect?","requested-reconnect?",-1504983666),true));
return taoensso.encore.swapped.call(null,new_state__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_state,new_state__$1], null));
});})(map__33115,map__33115__$1,chsk,chs,state_))
);
var old_state = cljs.core.nth.call(null,vec__33117,(0),null);
var new_state = cljs.core.nth.call(null,vec__33117,(1),null);
if(cljs.core.not_EQ_.call(null,old_state,new_state)){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(chs),new_state);

return new_state;
} else {
return null;
}
});
/**
 * Experimental, undocumented. Allows a core.async channel to be provided
 *   instead of a cb-fn. The channel will receive values of form
 *   [<event-id>.cb <reply>].
 */
taoensso.sente.cb_chan_as_fn = (function taoensso$sente$cb_chan_as_fn(_QMARK_cb,ev){
if(((_QMARK_cb == null)) || (cljs.core.ifn_QMARK_.call(null,_QMARK_cb))){
return _QMARK_cb;
} else {
var __x_33122 = _QMARK_cb;
try{if(cljs.core.truth_(taoensso.encore.chan_QMARK_.call(null,__x_33122))){
} else {
taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33120){if((e33120 instanceof Error)){
var t_33123 = e33120;
taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.sente",691,"(enc/chan? ?cb)",__x_33122,t_33123);
} else {
throw e33120;

}
}
taoensso.sente.assert_event.call(null,ev);

var vec__33121 = ev;
var ev_id = cljs.core.nth.call(null,vec__33121,(0),null);
var _ = cljs.core.nth.call(null,vec__33121,(1),null);
var cb_ch = _QMARK_cb;
return ((function (vec__33121,ev_id,_,cb_ch){
return (function (reply){
return cljs.core.async.put_BANG_.call(null,cb_ch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,[cljs.core.str(taoensso.encore.fq_name.call(null,ev_id)),cljs.core.str(".cb")].join('')),reply], null));
});
;})(vec__33121,ev_id,_,cb_ch))
}
});
taoensso.sente.receive_buffered_evs_BANG_ = (function taoensso$sente$receive_buffered_evs_BANG_(chs,clj){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["receive-buffered-evs!: %s",clj], null);
}),null)),null);

var buffered_evs = (function (){var __x = clj;
try{if(cljs.core.vector_QMARK_.call(null,__x)){
return __x;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33129){if((e33129 instanceof Error)){
var t = e33129;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.sente",702,"(vector? clj)",__x,t);
} else {
throw e33129;

}
}})();
var seq__33130 = cljs.core.seq.call(null,buffered_evs);
var chunk__33131 = null;
var count__33132 = (0);
var i__33133 = (0);
while(true){
if((i__33133 < count__33132)){
var ev = cljs.core._nth.call(null,chunk__33131,i__33133);
taoensso.sente.assert_event.call(null,ev);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__33134 = seq__33130;
var G__33135 = chunk__33131;
var G__33136 = count__33132;
var G__33137 = (i__33133 + (1));
seq__33130 = G__33134;
chunk__33131 = G__33135;
count__33132 = G__33136;
i__33133 = G__33137;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__33130);
if(temp__4425__auto__){
var seq__33130__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33130__$1)){
var c__17152__auto__ = cljs.core.chunk_first.call(null,seq__33130__$1);
var G__33138 = cljs.core.chunk_rest.call(null,seq__33130__$1);
var G__33139 = c__17152__auto__;
var G__33140 = cljs.core.count.call(null,c__17152__auto__);
var G__33141 = (0);
seq__33130 = G__33138;
chunk__33131 = G__33139;
count__33132 = G__33140;
i__33133 = G__33141;
continue;
} else {
var ev = cljs.core.first.call(null,seq__33130__$1);
taoensso.sente.assert_event.call(null,ev);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__33142 = cljs.core.next.call(null,seq__33130__$1);
var G__33143 = null;
var G__33144 = (0);
var G__33145 = (0);
seq__33130 = G__33142;
chunk__33131 = G__33143;
count__33132 = G__33144;
i__33133 = G__33145;
continue;
}
} else {
return null;
}
}
break;
}
});
taoensso.sente.handle_when_handshake_BANG_ = (function taoensso$sente$handle_when_handshake_BANG_(chsk,chs,clj){
var handshake_QMARK_ = (cljs.core.vector_QMARK_.call(null,clj)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,clj),new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686)));
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (handshake_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["handle-when-handshake (%s): %s",((handshake_QMARK_)?new cljs.core.Keyword(null,"handshake","handshake",68079331):new cljs.core.Keyword(null,"non-handshake","non-handshake",576986062)),clj], null);
});})(handshake_QMARK_))
,null)),null);

if(handshake_QMARK_){
var vec__33148 = clj;
var _ = cljs.core.nth.call(null,vec__33148,(0),null);
var vec__33149 = cljs.core.nth.call(null,vec__33148,(1),null);
var _QMARK_uid = cljs.core.nth.call(null,vec__33149,(0),null);
var _QMARK_csrf_token = cljs.core.nth.call(null,vec__33149,(1),null);
var _QMARK_handshake_data = cljs.core.nth.call(null,vec__33149,(2),null);
var handshake_ev = vec__33148;
if(cljs.core.truth_(clojure.string.blank_QMARK_.call(null,_QMARK_csrf_token))){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (vec__33148,_,vec__33149,_QMARK_uid,_QMARK_csrf_token,_QMARK_handshake_data,handshake_ev,handshake_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SECURITY WARNING: no CSRF token available for use by Sente"], null);
});})(vec__33148,_,vec__33149,_QMARK_uid,_QMARK_csrf_token,_QMARK_handshake_data,handshake_ev,handshake_QMARK_))
,null)),null);
} else {
}

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"open?","open?",1238443125),true,new cljs.core.Keyword(null,"uid","uid",-1447769400),_QMARK_uid,new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),_QMARK_csrf_token], null));

taoensso.sente.assert_event.call(null,handshake_ev);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(chs),handshake_ev);

return new cljs.core.Keyword(null,"handled","handled",1889700151);
} else {
return null;
}
});
taoensso.sente.set_exp_backoff_timeout_BANG_ = (function taoensso$sente$set_exp_backoff_timeout_BANG_(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33155 = arguments.length;
var i__17408__auto___33156 = (0);
while(true){
if((i__17408__auto___33156 < len__17407__auto___33155)){
args__17414__auto__.push((arguments[i__17408__auto___33156]));

var G__33157 = (i__17408__auto___33156 + (1));
i__17408__auto___33156 = G__33157;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((2) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((2)),(0))):null);
return taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17415__auto__);
});

taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (nullary_f,nattempt,p__33153){
var vec__33154 = p__33153;
var backoff_ms_fn = cljs.core.nth.call(null,vec__33154,(0),null);
var timeout_ms = backoff_ms_fn.call(null,(function (){var or__16349__auto__ = nattempt;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return (0);
}
})());
return window.setTimeout(nullary_f,timeout_ms);
});

taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$lang$maxFixedArity = (2);

taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$lang$applyTo = (function (seq33150){
var G__33151 = cljs.core.first.call(null,seq33150);
var seq33150__$1 = cljs.core.next.call(null,seq33150);
var G__33152 = cljs.core.first.call(null,seq33150__$1);
var seq33150__$2 = cljs.core.next.call(null,seq33150__$1);
return taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33151,G__33152,seq33150__$2);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChWebSocket = (function (client_id,url,params,chs,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,nattempt_,cbs_waiting_,state_,packer,backoff_ms_fn,__meta,__extmap,__hash){
this.client_id = client_id;
this.url = url;
this.params = params;
this.chs = chs;
this.socket_ = socket_;
this.kalive_ms = kalive_ms;
this.kalive_timer_ = kalive_timer_;
this.kalive_due_QMARK__ = kalive_due_QMARK__;
this.nattempt_ = nattempt_;
this.cbs_waiting_ = cbs_waiting_;
this.state_ = state_;
this.packer = packer;
this.backoff_ms_fn = backoff_ms_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__16963__auto__,k__16964__auto__){
var self__ = this;
var this__16963__auto____$1 = this;
return cljs.core._lookup.call(null,this__16963__auto____$1,k__16964__auto__,null);
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__16965__auto__,k33159,else__16966__auto__){
var self__ = this;
var this__16965__auto____$1 = this;
var G__33161 = (((k33159 instanceof cljs.core.Keyword))?k33159.fqn:null);
switch (G__33161) {
case "client-id":
return self__.client_id;

break;
case "kalive-ms":
return self__.kalive_ms;

break;
case "nattempt_":
return self__.nattempt_;

break;
case "packer":
return self__.packer;

break;
case "chs":
return self__.chs;

break;
case "params":
return self__.params;

break;
case "backoff-ms-fn":
return self__.backoff_ms_fn;

break;
case "socket_":
return self__.socket_;

break;
case "url":
return self__.url;

break;
case "kalive-due?_":
return self__.kalive_due_QMARK__;

break;
case "cbs-waiting_":
return self__.cbs_waiting_;

break;
case "kalive-timer_":
return self__.kalive_timer_;

break;
case "state_":
return self__.state_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k33159,else__16966__auto__);

}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__16977__auto__,writer__16978__auto__,opts__16979__auto__){
var self__ = this;
var this__16977__auto____$1 = this;
var pr_pair__16980__auto__ = ((function (this__16977__auto____$1){
return (function (keyval__16981__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__16978__auto__,cljs.core.pr_writer,""," ","",opts__16979__auto__,keyval__16981__auto__);
});})(this__16977__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__16978__auto__,pr_pair__16980__auto__,"#taoensso.sente.ChWebSocket{",", ","}",opts__16979__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"socket_","socket_",-361048908),self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),self__.kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),self__.kalive_timer_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),self__.kalive_due_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"nattempt_","nattempt_",1980196552),self__.nattempt_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$ = true;

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__33158){
var self__ = this;
var G__33158__$1 = this;
return (new cljs.core.RecordIter((0),G__33158__$1,13,new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),new cljs.core.Keyword(null,"nattempt_","nattempt_",1980196552),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__16961__auto__){
var self__ = this;
var this__16961__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__16957__auto__){
var self__ = this;
var this__16957__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__16967__auto__){
var self__ = this;
var this__16967__auto____$1 = this;
return (13 + cljs.core.count.call(null,self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__16958__auto__){
var self__ = this;
var this__16958__auto____$1 = this;
var h__16784__auto__ = self__.__hash;
if(!((h__16784__auto__ == null))){
return h__16784__auto__;
} else {
var h__16784__auto____$1 = cljs.core.hash_imap.call(null,this__16958__auto____$1);
self__.__hash = h__16784__auto____$1;

return h__16784__auto____$1;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__16959__auto__,other__16960__auto__){
var self__ = this;
var this__16959__auto____$1 = this;
if(cljs.core.truth_((function (){var and__16337__auto__ = other__16960__auto__;
if(cljs.core.truth_(and__16337__auto__)){
var and__16337__auto____$1 = (this__16959__auto____$1.constructor === other__16960__auto__.constructor);
if(and__16337__auto____$1){
return cljs.core.equiv_map.call(null,this__16959__auto____$1,other__16960__auto__);
} else {
return and__16337__auto____$1;
}
} else {
return and__16337__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__16972__auto__,k__16973__auto__){
var self__ = this;
var this__16972__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),null,new cljs.core.Keyword(null,"nattempt_","nattempt_",1980196552),null,new cljs.core.Keyword(null,"packer","packer",66077544),null,new cljs.core.Keyword(null,"chs","chs",376886120),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),null,new cljs.core.Keyword(null,"socket_","socket_",-361048908),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),null,new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),null,new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),null,new cljs.core.Keyword(null,"state_","state_",957667102),null], null), null),k__16973__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__16972__auto____$1),self__.__meta),k__16973__auto__);
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__16973__auto__)),null));
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__16970__auto__,k__16971__auto__,G__33158){
var self__ = this;
var this__16970__auto____$1 = this;
var pred__33162 = cljs.core.keyword_identical_QMARK_;
var expr__33163 = k__16971__auto__;
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),expr__33163))){
return (new taoensso.sente.ChWebSocket(G__33158,self__.url,self__.params,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__33163))){
return (new taoensso.sente.ChWebSocket(self__.client_id,G__33158,self__.params,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__33163))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,G__33158,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"chs","chs",376886120),expr__33163))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,G__33158,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"socket_","socket_",-361048908),expr__33163))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,G__33158,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),expr__33163))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.socket_,G__33158,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),expr__33163))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.socket_,self__.kalive_ms,G__33158,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),expr__33163))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,G__33158,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"nattempt_","nattempt_",1980196552),expr__33163))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,G__33158,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),expr__33163))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,G__33158,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"state_","state_",957667102),expr__33163))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,G__33158,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"packer","packer",66077544),expr__33163))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,G__33158,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33162.call(null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),expr__33163))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,G__33158,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__16971__auto__,G__33158),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__16975__auto__){
var self__ = this;
var this__16975__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"socket_","socket_",-361048908),self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),self__.kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),self__.kalive_timer_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),self__.kalive_due_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"nattempt_","nattempt_",1980196552),self__.nattempt_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__16962__auto__,G__33158){
var self__ = this;
var this__16962__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.backoff_ms_fn,G__33158,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__16968__auto__,entry__16969__auto__){
var self__ = this;
var this__16968__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__16969__auto__)){
return cljs.core._assoc.call(null,this__16968__auto____$1,cljs.core._nth.call(null,entry__16969__auto__,(0)),cljs.core._nth.call(null,entry__16969__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__16968__auto____$1,entry__16969__auto__);
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$ = true;

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_send_BANG__STAR_$arity$3 = (function (chsk,ev,p__33165){
var self__ = this;
var map__33166 = p__33165;
var map__33166__$1 = ((((!((map__33166 == null)))?((((map__33166.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33166.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33166):map__33166);
var opts = map__33166__$1;
var _QMARK_timeout_ms = cljs.core.get.call(null,map__33166__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var _QMARK_cb = cljs.core.get.call(null,map__33166__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var flush_QMARK_ = cljs.core.get.call(null,map__33166__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var chsk__$1 = this;
taoensso.sente.assert_send_args.call(null,ev,_QMARK_timeout_ms,_QMARK_cb);

var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn.call(null,_QMARK_cb,ev);
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (_QMARK_cb_fn,chsk__$1,map__33166,map__33166__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send against closed chsk."], null);
});})(_QMARK_cb_fn,chsk__$1,map__33166,map__33166__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264));
} else {
return null;
}
} else {
var _QMARK_cb_uuid = (cljs.core.truth_(_QMARK_cb_fn)?taoensso.encore.uuid_str.call(null,(6)):null);
var ppstr = taoensso.sente.pack.call(null,self__.packer,cljs.core.meta.call(null,ev),ev,_QMARK_cb_uuid);
var temp__4425__auto___33202 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4425__auto___33202)){
var cb_uuid_33203 = temp__4425__auto___33202;
taoensso.encore.reset_in_BANG_.call(null,self__.cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid_33203], null),(function (){var __x = _QMARK_cb_fn;
try{if(cljs.core.truth_(taoensso.encore.nnil_QMARK_.call(null,__x))){
return __x;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33168){if((e33168 instanceof Error)){
var t = e33168;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.sente",768,"(taoensso.encore/nnil? ?cb-fn)",__x,t);
} else {
throw e33168;

}
}})());

var temp__4425__auto___33204__$1 = _QMARK_timeout_ms;
if(cljs.core.truth_(temp__4425__auto___33204__$1)){
var timeout_ms_33205 = temp__4425__auto___33204__$1;
var c__19429__auto___33206 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___33206,timeout_ms_33205,temp__4425__auto___33204__$1,cb_uuid_33203,temp__4425__auto___33202,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__33166,map__33166__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___33206,timeout_ms_33205,temp__4425__auto___33204__$1,cb_uuid_33203,temp__4425__auto___33202,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__33166,map__33166__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (state_33179){
var state_val_33180 = (state_33179[(1)]);
if((state_val_33180 === (1))){
var inst_33169 = cljs.core.async.timeout.call(null,timeout_ms_33205);
var state_33179__$1 = state_33179;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33179__$1,(2),inst_33169);
} else {
if((state_val_33180 === (2))){
var inst_33172 = (state_33179[(7)]);
var inst_33171 = (state_33179[(2)]);
var inst_33172__$1 = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,_QMARK_cb_uuid);
var state_33179__$1 = (function (){var statearr_33181 = state_33179;
(statearr_33181[(7)] = inst_33172__$1);

(statearr_33181[(8)] = inst_33171);

return statearr_33181;
})();
if(cljs.core.truth_(inst_33172__$1)){
var statearr_33182_33207 = state_33179__$1;
(statearr_33182_33207[(1)] = (3));

} else {
var statearr_33183_33208 = state_33179__$1;
(statearr_33183_33208[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33180 === (3))){
var inst_33172 = (state_33179[(7)]);
var inst_33174 = inst_33172.call(null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
var state_33179__$1 = state_33179;
var statearr_33184_33209 = state_33179__$1;
(statearr_33184_33209[(2)] = inst_33174);

(statearr_33184_33209[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33180 === (4))){
var state_33179__$1 = state_33179;
var statearr_33185_33210 = state_33179__$1;
(statearr_33185_33210[(2)] = null);

(statearr_33185_33210[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33180 === (5))){
var inst_33177 = (state_33179[(2)]);
var state_33179__$1 = state_33179;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33179__$1,inst_33177);
} else {
return null;
}
}
}
}
}
});})(c__19429__auto___33206,timeout_ms_33205,temp__4425__auto___33204__$1,cb_uuid_33203,temp__4425__auto___33202,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__33166,map__33166__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
;
return ((function (switch__19364__auto__,c__19429__auto___33206,timeout_ms_33205,temp__4425__auto___33204__$1,cb_uuid_33203,temp__4425__auto___33202,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__33166,map__33166__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function() {
var taoensso$sente$state_machine__19365__auto__ = null;
var taoensso$sente$state_machine__19365__auto____0 = (function (){
var statearr_33189 = [null,null,null,null,null,null,null,null,null];
(statearr_33189[(0)] = taoensso$sente$state_machine__19365__auto__);

(statearr_33189[(1)] = (1));

return statearr_33189;
});
var taoensso$sente$state_machine__19365__auto____1 = (function (state_33179){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_33179);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e33190){if((e33190 instanceof Object)){
var ex__19368__auto__ = e33190;
var statearr_33191_33211 = state_33179;
(statearr_33191_33211[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33179);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33190;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33212 = state_33179;
state_33179 = G__33212;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
taoensso$sente$state_machine__19365__auto__ = function(state_33179){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__19365__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__19365__auto____1.call(this,state_33179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__19365__auto____0;
taoensso$sente$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__19365__auto____1;
return taoensso$sente$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___33206,timeout_ms_33205,temp__4425__auto___33204__$1,cb_uuid_33203,temp__4425__auto___33202,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__33166,map__33166__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
})();
var state__19431__auto__ = (function (){var statearr_33192 = f__19430__auto__.call(null);
(statearr_33192[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___33206);

return statearr_33192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___33206,timeout_ms_33205,temp__4425__auto___33204__$1,cb_uuid_33203,temp__4425__auto___33202,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__33166,map__33166__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
);

} else {
}
} else {
}

try{cljs.core.deref.call(null,self__.socket_).send(ppstr);

cljs.core.reset_BANG_.call(null,self__.kalive_due_QMARK__,false);

return new cljs.core.Keyword(null,"apparent-success","apparent-success",242592222);
}catch (e33193){if((e33193 instanceof Error)){
var e = e33193;
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__33166,map__33166__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"Chsk send error"], null);
});})(e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__33166,map__33166__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);

var temp__4425__auto___33213 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4425__auto___33213)){
var cb_uuid_33214 = temp__4425__auto___33213;
var cb_fn_STAR__33215 = (function (){var or__16349__auto__ = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,cb_uuid_33214);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
var __x = _QMARK_cb_fn;
try{if(cljs.core.truth_(taoensso.encore.nnil_QMARK_.call(null,__x))){
return __x;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33194){if((e33194 instanceof Error)){
var t = e33194;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.sente",782,"(taoensso.encore/nnil? ?cb-fn)",__x,t);
} else {
throw e33194;

}
}}
})();
cb_fn_STAR__33215.call(null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439));
} else {
}

return false;
} else {
throw e33193;

}
}}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116),true], null));

var temp__4425__auto__ = cljs.core.deref.call(null,self__.socket_);
if(cljs.core.truth_(temp__4425__auto__)){
var s = temp__4425__auto__;
return s.close((3000),"SENTE_RECONNECT");
} else {
return null;
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"destroyed?","destroyed?",1049634064),true], null));

var temp__4425__auto__ = cljs.core.deref.call(null,self__.socket_);
if(cljs.core.truth_(temp__4425__auto__)){
var s = temp__4425__auto__;
return s.close((1000),"CLOSE_NORMAL");
} else {
return null;
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_init_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var temp__4425__auto__ = (function (){var or__16349__auto__ = taoensso.encore.oget.call(null,window,"WebSocket");
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore.oget.call(null,window,"MozWebSocket");
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var WebSocket = temp__4425__auto__;
((function (WebSocket,temp__4425__auto__,chsk__$1){
return (function taoensso$sente$connect_BANG_(){
if(cljs.core.truth_(new cljs.core.Keyword(null,"destroyed?","destroyed?",1049634064).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))){
return null;
} else {
var retry_BANG_ = ((function (WebSocket,temp__4425__auto__,chsk__$1){
return (function (){
var nattempt_STAR_ = cljs.core.swap_BANG_.call(null,self__.nattempt_,cljs.core.inc);
window.clearInterval(cljs.core.deref.call(null,self__.kalive_timer_));

taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (nattempt_STAR_,WebSocket,temp__4425__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk is closed: will try reconnect (%s).",nattempt_STAR_], null);
});})(nattempt_STAR_,WebSocket,temp__4425__auto__,chsk__$1))
,null)),null);

return taoensso.sente.set_exp_backoff_timeout_BANG_.call(null,taoensso$sente$connect_BANG_,nattempt_STAR_,self__.backoff_ms_fn);
});})(WebSocket,temp__4425__auto__,chsk__$1))
;
var temp__4423__auto__ = (function (){try{return (new WebSocket(taoensso.encore.merge_url_with_query_string.call(null,self__.url,cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id], null)))));
}catch (e33198){if((e33198 instanceof Error)){
var e = e33198;
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (e,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"WebSocket js/Error"], null);
});})(e,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1))
,null)),null);

return null;
} else {
throw e33198;

}
}})();
if(cljs.core.truth_(temp__4423__auto__)){
var socket = temp__4423__auto__;
return cljs.core.reset_BANG_.call(null,self__.socket_,(function (){var G__33199 = socket;
(G__33199["onerror"] = ((function (G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1){
return (function (ws_ev){
return taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["WebSocket error: %s",ws_ev], null);
});})(G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1))
,null)),null);
});})(G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1))
);

(G__33199["onmessage"] = ((function (G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1){
return (function (ws_ev){
var ppstr = taoensso.encore.oget.call(null,ws_ev,"data");
var vec__33200 = taoensso.sente.unpack.call(null,self__.packer,ppstr);
var clj = cljs.core.nth.call(null,vec__33200,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__33200,(1),null);
var or__16349__auto__ = (function (){var and__16337__auto__ = taoensso.sente.handle_when_handshake_BANG_.call(null,chsk__$1,self__.chs,clj);
if(cljs.core.truth_(and__16337__auto__)){
return cljs.core.reset_BANG_.call(null,self__.nattempt_,(0));
} else {
return and__16337__auto__;
}
})();
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
var temp__4423__auto____$1 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4423__auto____$1)){
var cb_uuid = temp__4423__auto____$1;
var temp__4423__auto____$2 = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,cb_uuid);
if(cljs.core.truth_(temp__4423__auto____$2)){
var cb_fn = temp__4423__auto____$2;
return cb_fn.call(null,clj);
} else {
return taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (temp__4423__auto____$2,cb_uuid,temp__4423__auto____$1,or__16349__auto__,ppstr,vec__33200,clj,_QMARK_cb_uuid,G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cb reply w/o local cb-fn: %s",clj], null);
});})(temp__4423__auto____$2,cb_uuid,temp__4423__auto____$1,or__16349__auto__,ppstr,vec__33200,clj,_QMARK_cb_uuid,G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1))
,null)),null);
}
} else {
var buffered_evs = clj;
return taoensso.sente.receive_buffered_evs_BANG_.call(null,self__.chs,buffered_evs);
}
}
});})(G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1))
);

(G__33199["onopen"] = ((function (G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1){
return (function (_ws_ev){
return cljs.core.reset_BANG_.call(null,self__.kalive_timer_,window.setInterval(((function (G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1){
return (function (){
if(cljs.core.truth_(cljs.core.deref.call(null,self__.kalive_due_QMARK__))){
taoensso.sente.chsk_send_BANG_.call(null,chsk__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","ws-ping","chsk/ws-ping",191675304)], null));
} else {
}

return cljs.core.reset_BANG_.call(null,self__.kalive_due_QMARK__,true);
});})(G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1))
,self__.kalive_ms));
});})(G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1))
);

(G__33199["onclose"] = ((function (G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1){
return (function (_ws_ev){
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

return retry_BANG_.call(null);
});})(G__33199,socket,temp__4423__auto__,retry_BANG_,WebSocket,temp__4425__auto__,chsk__$1))
);

return G__33199;
})());
} else {
return retry_BANG_.call(null);
}
}
});})(WebSocket,temp__4425__auto__,chsk__$1))
.call(null);

return chsk__$1;
} else {
return null;
}
});

taoensso.sente.ChWebSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"chs","chs",2017417647,null),new cljs.core.Symbol(null,"socket_","socket_",1279482619,null),new cljs.core.Symbol(null,"kalive-ms","kalive-ms",1851265548,null),new cljs.core.Symbol(null,"kalive-timer_","kalive-timer_",-1096022620,null),new cljs.core.Symbol(null,"kalive-due?_","kalive-due?_",1679969599,null),new cljs.core.Symbol(null,"nattempt_","nattempt_",-674239217,null),new cljs.core.Symbol(null,"cbs-waiting_","cbs-waiting_",121502466,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"packer","packer",1706609071,null),new cljs.core.Symbol(null,"backoff-ms-fn","backoff-ms-fn",-1881539814,null)], null);
});

taoensso.sente.ChWebSocket.cljs$lang$type = true;

taoensso.sente.ChWebSocket.cljs$lang$ctorPrSeq = (function (this__16997__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"taoensso.sente/ChWebSocket");
});

taoensso.sente.ChWebSocket.cljs$lang$ctorPrWriter = (function (this__16997__auto__,writer__16998__auto__){
return cljs.core._write.call(null,writer__16998__auto__,"taoensso.sente/ChWebSocket");
});

taoensso.sente.__GT_ChWebSocket = (function taoensso$sente$__GT_ChWebSocket(client_id,url,params,chs,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,nattempt_,cbs_waiting_,state_,packer,backoff_ms_fn){
return (new taoensso.sente.ChWebSocket(client_id,url,params,chs,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,nattempt_,cbs_waiting_,state_,packer,backoff_ms_fn,null,null,null));
});

taoensso.sente.map__GT_ChWebSocket = (function taoensso$sente$map__GT_ChWebSocket(G__33160){
return (new taoensso.sente.ChWebSocket(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(G__33160),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__33160),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__33160),new cljs.core.Keyword(null,"chs","chs",376886120).cljs$core$IFn$_invoke$arity$1(G__33160),new cljs.core.Keyword(null,"socket_","socket_",-361048908).cljs$core$IFn$_invoke$arity$1(G__33160),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021).cljs$core$IFn$_invoke$arity$1(G__33160),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149).cljs$core$IFn$_invoke$arity$1(G__33160),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072).cljs$core$IFn$_invoke$arity$1(G__33160),new cljs.core.Keyword(null,"nattempt_","nattempt_",1980196552).cljs$core$IFn$_invoke$arity$1(G__33160),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061).cljs$core$IFn$_invoke$arity$1(G__33160),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__33160),new cljs.core.Keyword(null,"packer","packer",66077544).cljs$core$IFn$_invoke$arity$1(G__33160),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955).cljs$core$IFn$_invoke$arity$1(G__33160),null,cljs.core.dissoc.call(null,G__33160,new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),new cljs.core.Keyword(null,"nattempt_","nattempt_",1980196552),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955)),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChAjaxSocket = (function (client_id,url,params,chs,timeout_ms,ajax_opts,curr_xhr_,state_,packer,backoff_ms_fn,__meta,__extmap,__hash){
this.client_id = client_id;
this.url = url;
this.params = params;
this.chs = chs;
this.timeout_ms = timeout_ms;
this.ajax_opts = ajax_opts;
this.curr_xhr_ = curr_xhr_;
this.state_ = state_;
this.packer = packer;
this.backoff_ms_fn = backoff_ms_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__16963__auto__,k__16964__auto__){
var self__ = this;
var this__16963__auto____$1 = this;
return cljs.core._lookup.call(null,this__16963__auto____$1,k__16964__auto__,null);
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__16965__auto__,k33217,else__16966__auto__){
var self__ = this;
var this__16965__auto____$1 = this;
var G__33219 = (((k33217 instanceof cljs.core.Keyword))?k33217.fqn:null);
switch (G__33219) {
case "curr-xhr_":
return self__.curr_xhr_;

break;
case "client-id":
return self__.client_id;

break;
case "packer":
return self__.packer;

break;
case "chs":
return self__.chs;

break;
case "params":
return self__.params;

break;
case "backoff-ms-fn":
return self__.backoff_ms_fn;

break;
case "url":
return self__.url;

break;
case "ajax-opts":
return self__.ajax_opts;

break;
case "timeout-ms":
return self__.timeout_ms;

break;
case "state_":
return self__.state_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k33217,else__16966__auto__);

}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__16977__auto__,writer__16978__auto__,opts__16979__auto__){
var self__ = this;
var this__16977__auto____$1 = this;
var pr_pair__16980__auto__ = ((function (this__16977__auto____$1){
return (function (keyval__16981__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__16978__auto__,cljs.core.pr_writer,""," ","",opts__16979__auto__,keyval__16981__auto__);
});})(this__16977__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__16978__auto__,pr_pair__16980__auto__,"#taoensso.sente.ChAjaxSocket{",", ","}",opts__16979__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),self__.timeout_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),self__.curr_xhr_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$ = true;

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__33216){
var self__ = this;
var G__33216__$1 = this;
return (new cljs.core.RecordIter((0),G__33216__$1,10,new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__16961__auto__){
var self__ = this;
var this__16961__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__16957__auto__){
var self__ = this;
var this__16957__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__16967__auto__){
var self__ = this;
var this__16967__auto____$1 = this;
return (10 + cljs.core.count.call(null,self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__16958__auto__){
var self__ = this;
var this__16958__auto____$1 = this;
var h__16784__auto__ = self__.__hash;
if(!((h__16784__auto__ == null))){
return h__16784__auto__;
} else {
var h__16784__auto____$1 = cljs.core.hash_imap.call(null,this__16958__auto____$1);
self__.__hash = h__16784__auto____$1;

return h__16784__auto____$1;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__16959__auto__,other__16960__auto__){
var self__ = this;
var this__16959__auto____$1 = this;
if(cljs.core.truth_((function (){var and__16337__auto__ = other__16960__auto__;
if(cljs.core.truth_(and__16337__auto__)){
var and__16337__auto____$1 = (this__16959__auto____$1.constructor === other__16960__auto__.constructor);
if(and__16337__auto____$1){
return cljs.core.equiv_map.call(null,this__16959__auto____$1,other__16960__auto__);
} else {
return and__16337__auto____$1;
}
} else {
return and__16337__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__16972__auto__,k__16973__auto__){
var self__ = this;
var this__16972__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"packer","packer",66077544),null,new cljs.core.Keyword(null,"chs","chs",376886120),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),null,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),null,new cljs.core.Keyword(null,"state_","state_",957667102),null], null), null),k__16973__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__16972__auto____$1),self__.__meta),k__16973__auto__);
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__16973__auto__)),null));
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__16970__auto__,k__16971__auto__,G__33216){
var self__ = this;
var this__16970__auto____$1 = this;
var pred__33220 = cljs.core.keyword_identical_QMARK_;
var expr__33221 = k__16971__auto__;
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),expr__33221))){
return (new taoensso.sente.ChAjaxSocket(G__33216,self__.url,self__.params,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__33221))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,G__33216,self__.params,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__33221))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,G__33216,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"chs","chs",376886120),expr__33221))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.params,G__33216,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),expr__33221))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.params,self__.chs,G__33216,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),expr__33221))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.timeout_ms,G__33216,self__.curr_xhr_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),expr__33221))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.timeout_ms,self__.ajax_opts,G__33216,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"state_","state_",957667102),expr__33221))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,G__33216,self__.packer,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"packer","packer",66077544),expr__33221))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,G__33216,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__33220.call(null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),expr__33221))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,G__33216,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.backoff_ms_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__16971__auto__,G__33216),null));
}
}
}
}
}
}
}
}
}
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__16975__auto__){
var self__ = this;
var this__16975__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),self__.timeout_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),self__.curr_xhr_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__16962__auto__,G__33216){
var self__ = this;
var this__16962__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.params,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.backoff_ms_fn,G__33216,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__16968__auto__,entry__16969__auto__){
var self__ = this;
var this__16968__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__16969__auto__)){
return cljs.core._assoc.call(null,this__16968__auto____$1,cljs.core._nth.call(null,entry__16969__auto__,(0)),cljs.core._nth.call(null,entry__16969__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__16968__auto____$1,entry__16969__auto__);
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$ = true;

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_send_BANG__STAR_$arity$3 = (function (chsk,ev,p__33223){
var self__ = this;
var map__33224 = p__33223;
var map__33224__$1 = ((((!((map__33224 == null)))?((((map__33224.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33224.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33224):map__33224);
var opts = map__33224__$1;
var _QMARK_timeout_ms = cljs.core.get.call(null,map__33224__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var _QMARK_cb = cljs.core.get.call(null,map__33224__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var flush_QMARK_ = cljs.core.get.call(null,map__33224__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var chsk__$1 = this;
taoensso.sente.assert_send_args.call(null,ev,_QMARK_timeout_ms,_QMARK_cb);

var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn.call(null,_QMARK_cb,ev);
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (_QMARK_cb_fn,chsk__$1,map__33224,map__33224__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send against closed chsk."], null);
});})(_QMARK_cb_fn,chsk__$1,map__33224,map__33224__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264));
} else {
return null;
}
} else {
taoensso.encore.ajax_lite.call(null,self__.url,cljs.core.merge.call(null,self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),_QMARK_timeout_ms,new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"params","params",710516235),(function (){var ppstr = taoensso.sente.pack.call(null,self__.packer,cljs.core.meta.call(null,ev),ev,(cljs.core.truth_(_QMARK_cb_fn)?new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321):null));
return cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"_","_",1453416199),taoensso.encore.now_udt.call(null),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)),new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id,new cljs.core.Keyword(null,"ppstr","ppstr",1557495252),ppstr], null));
})()], null)),((function (_QMARK_cb_fn,chsk__$1,map__33224,map__33224__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function taoensso$sente$ajax_cb(p__33226){
var map__33230 = p__33226;
var map__33230__$1 = ((((!((map__33230 == null)))?((((map__33230.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33230.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33230):map__33230);
var _QMARK_error = cljs.core.get.call(null,map__33230__$1,new cljs.core.Keyword(null,"?error","?error",1070752222));
var _QMARK_content = cljs.core.get.call(null,map__33230__$1,new cljs.core.Keyword(null,"?content","?content",1697782054));
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.call(null,_QMARK_error,new cljs.core.Keyword(null,"timeout","timeout",-318625318))){
if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
} else {
return null;
}
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439));
} else {
return null;
}
}
} else {
var content = _QMARK_content;
var resp_ppstr = content;
var vec__33232 = taoensso.sente.unpack.call(null,self__.packer,resp_ppstr);
var resp_clj = cljs.core.nth.call(null,vec__33232,(0),null);
var _ = cljs.core.nth.call(null,vec__33232,(1),null);
if(cljs.core.truth_(_QMARK_cb_fn)){
_QMARK_cb_fn.call(null,resp_clj);
} else {
if(cljs.core.not_EQ_.call(null,resp_clj,new cljs.core.Keyword("chsk","dummy-cb-200","chsk/dummy-cb-200",-1663130337))){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (content,resp_ppstr,vec__33232,resp_clj,_,map__33230,map__33230__$1,_QMARK_error,_QMARK_content,_QMARK_cb_fn,chsk__$1,map__33224,map__33224__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cb reply w/o local cb-fn: %s",resp_clj], null);
});})(content,resp_ppstr,vec__33232,resp_clj,_,map__33230,map__33230__$1,_QMARK_error,_QMARK_content,_QMARK_cb_fn,chsk__$1,map__33224,map__33224__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);
} else {
}
}

return taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),true], null));
}
});})(_QMARK_cb_fn,chsk__$1,map__33224,map__33224__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
);

return new cljs.core.Keyword(null,"apparent-success","apparent-success",242592222);
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116),true], null));

var temp__4425__auto__ = cljs.core.deref.call(null,self__.curr_xhr_);
if(cljs.core.truth_(temp__4425__auto__)){
var x = temp__4425__auto__;
return x.abort();
} else {
return null;
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"destroyed?","destroyed?",1049634064),true], null));

var temp__4425__auto__ = cljs.core.deref.call(null,self__.curr_xhr_);
if(cljs.core.truth_(temp__4425__auto__)){
var x = temp__4425__auto__;
return x.abort();
} else {
return null;
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_init_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
((function (chsk__$1){
return (function taoensso$sente$async_poll_for_update_BANG_(nattempt){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["async-poll-for-update!"], null);
});})(chsk__$1))
,null)),null);

if(cljs.core.truth_(new cljs.core.Keyword(null,"destroyed?","destroyed?",1049634064).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))){
return null;
} else {
var retry_BANG_ = ((function (chsk__$1){
return (function (){
var nattempt_STAR_ = (nattempt + (1));
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (nattempt_STAR_,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk is closed: will try reconnect (%s).",nattempt_STAR_], null);
});})(nattempt_STAR_,chsk__$1))
,null)),null);

return taoensso.sente.set_exp_backoff_timeout_BANG_.call(null,cljs.core.partial.call(null,taoensso$sente$async_poll_for_update_BANG_,nattempt_STAR_),nattempt_STAR_,self__.backoff_ms_fn);
});})(chsk__$1))
;
return cljs.core.reset_BANG_.call(null,self__.curr_xhr_,taoensso.encore.ajax_lite.call(null,self__.url,cljs.core.merge.call(null,self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),self__.timeout_ms,new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"_","_",1453416199),taoensso.encore.now_udt.call(null),new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id], null),(cljs.core.truth_(new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))?null:new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handshake?","handshake?",-423743093),true], null)))], null)),((function (retry_BANG_,chsk__$1){
return (function taoensso$sente$async_poll_for_update_BANG__$_ajax_cb(p__33240){
var map__33244 = p__33240;
var map__33244__$1 = ((((!((map__33244 == null)))?((((map__33244.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33244.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33244):map__33244);
var _QMARK_error = cljs.core.get.call(null,map__33244__$1,new cljs.core.Keyword(null,"?error","?error",1070752222));
var _QMARK_content = cljs.core.get.call(null,map__33244__$1,new cljs.core.Keyword(null,"?content","?content",1697782054));
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.call(null,_QMARK_error,new cljs.core.Keyword(null,"timeout","timeout",-318625318))){
return taoensso$sente$async_poll_for_update_BANG_.call(null,(0));
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

return retry_BANG_.call(null);

}
} else {
var content = _QMARK_content;
var ppstr = content;
var vec__33246 = taoensso.sente.unpack.call(null,self__.packer,ppstr);
var clj = cljs.core.nth.call(null,vec__33246,(0),null);
var _ = cljs.core.nth.call(null,vec__33246,(1),null);
var or__16349__auto___33248 = taoensso.sente.handle_when_handshake_BANG_.call(null,chsk__$1,self__.chs,clj);
if(cljs.core.truth_(or__16349__auto___33248)){
} else {
var buffered_evs_33249 = clj;
taoensso.sente.receive_buffered_evs_BANG_.call(null,self__.chs,buffered_evs_33249);

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),true], null));
}

return taoensso$sente$async_poll_for_update_BANG_.call(null,(0));
}
});})(retry_BANG_,chsk__$1))
));
}
});})(chsk__$1))
.call(null,(0));

return chsk__$1;
});

taoensso.sente.ChAjaxSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"chs","chs",2017417647,null),new cljs.core.Symbol(null,"timeout-ms","timeout-ms",-1900214363,null),new cljs.core.Symbol(null,"ajax-opts","ajax-opts",1122292418,null),new cljs.core.Symbol(null,"curr-xhr_","curr-xhr_",321757831,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"packer","packer",1706609071,null),new cljs.core.Symbol(null,"backoff-ms-fn","backoff-ms-fn",-1881539814,null)], null);
});

taoensso.sente.ChAjaxSocket.cljs$lang$type = true;

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrSeq = (function (this__16997__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrWriter = (function (this__16997__auto__,writer__16998__auto__){
return cljs.core._write.call(null,writer__16998__auto__,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.__GT_ChAjaxSocket = (function taoensso$sente$__GT_ChAjaxSocket(client_id,url,params,chs,timeout_ms,ajax_opts,curr_xhr_,state_,packer,backoff_ms_fn){
return (new taoensso.sente.ChAjaxSocket(client_id,url,params,chs,timeout_ms,ajax_opts,curr_xhr_,state_,packer,backoff_ms_fn,null,null,null));
});

taoensso.sente.map__GT_ChAjaxSocket = (function taoensso$sente$map__GT_ChAjaxSocket(G__33218){
return (new taoensso.sente.ChAjaxSocket(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(G__33218),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__33218),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__33218),new cljs.core.Keyword(null,"chs","chs",376886120).cljs$core$IFn$_invoke$arity$1(G__33218),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406).cljs$core$IFn$_invoke$arity$1(G__33218),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109).cljs$core$IFn$_invoke$arity$1(G__33218),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696).cljs$core$IFn$_invoke$arity$1(G__33218),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__33218),new cljs.core.Keyword(null,"packer","packer",66077544).cljs$core$IFn$_invoke$arity$1(G__33218),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955).cljs$core$IFn$_invoke$arity$1(G__33218),null,cljs.core.dissoc.call(null,G__33218,new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955)),null));
});

taoensso.sente.get_chsk_url = (function taoensso$sente$get_chsk_url(protocol,chsk_host,chsk_path,type){
var protocol__$1 = (function (){var G__33251 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__33251) {
case "ajax":
return protocol;

break;
case "ws":
if(cljs.core._EQ_.call(null,protocol,"https:")){
return "wss:";
} else {
return "ws:";
}

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}
})();
return [cljs.core.str(protocol__$1),cljs.core.str("//"),cljs.core.str(taoensso.encore.path.call(null,chsk_host,chsk_path))].join('');
});
/**
 * Returns a map with keys:
 *  :ch-recv ; core.async channel to receive `event-msg`s (internal or from clients).
 *           ; May `put!` (inject) arbitrary `event`s to this channel.
 *  :send-fn ; (fn [event & [?timeout-ms ?cb-fn]]) for client>server send.
 *  :state   ; Watchable, read-only (atom {:type _ :open? _ :uid _ :csrf-token _}).
 *  :chsk    ; IChSocket implementer. You can usu. ignore this.
 * 
 *   Common options:
 *  :type           ; e/o #{:auto :ws :ajax}. You'll usually want the default (:auto)
 *  :host           ; Server host (defaults to current page's host)
 *  :params         ; Map of any params to incl. in chsk Ring requests (handy for
 *                  ; application-level auth, etc.)
 *  :ws-kalive-ms   ; Ping to keep a WebSocket conn alive if no activity w/in given
 *                  ; number of milliseconds
 *  :lp-timeout-ms  ; Ping to keep a long-polling (Ajax) conn alive '' [1]
 *  :packer         ; :edn (default), or an IPacker implementation (experimental)
 *  :ajax-opts      ; Base opts map provided to `taoensso.encore/ajax-lite`
 *  :wrap-recv-evs? ; Should events from server be wrapped in [:chsk/recv _]?
 * 
 *   [1] If you're using Immutant and override the default :lp-timeout-ms, you'll
 *    need to provide the same timeout value to
 *    `taoensso.sente.server-adapters.immutant/make-immutant-adapter` and use
 *    the result of that function as the web server adapter to your server-side
 *    `make-channel-socket!`.
 */
taoensso.sente.make_channel_socket_BANG_ = (function taoensso$sente$make_channel_socket_BANG_(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33267 = arguments.length;
var i__17408__auto___33268 = (0);
while(true){
if((i__17408__auto___33268 < len__17407__auto___33267)){
args__17414__auto__.push((arguments[i__17408__auto___33268]));

var G__33269 = (i__17408__auto___33268 + (1));
i__17408__auto___33268 = G__33269;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return taoensso.sente.make_channel_socket_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

taoensso.sente.make_channel_socket_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (path,p__33256){
var vec__33257 = p__33256;
var map__33258 = cljs.core.nth.call(null,vec__33257,(0),null);
var map__33258__$1 = ((((!((map__33258 == null)))?((((map__33258.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33258.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33258):map__33258);
var opts = map__33258__$1;
var ajax_opts = cljs.core.get.call(null,map__33258__$1,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109));
var ws_kalive_ms = cljs.core.get.call(null,map__33258__$1,new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),(25000));
var lp_timeout_ms = cljs.core.get.call(null,map__33258__$1,new cljs.core.Keyword(null,"lp-timeout-ms","lp-timeout-ms",-1451963133),(25000));
var client_id = cljs.core.get.call(null,map__33258__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140),(function (){var or__16349__auto__ = new cljs.core.Keyword(null,"client-uuid","client-uuid",-1717531965).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return taoensso.encore.uuid_str.call(null);
}
})());
var packer = cljs.core.get.call(null,map__33258__$1,new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"edn","edn",1317840885));
var params = cljs.core.get.call(null,map__33258__$1,new cljs.core.Keyword(null,"params","params",710516235));
var type = cljs.core.get.call(null,map__33258__$1,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"auto","auto",-566279492));
var host = cljs.core.get.call(null,map__33258__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var recv_buf_or_n = cljs.core.get.call(null,map__33258__$1,new cljs.core.Keyword(null,"recv-buf-or-n","recv-buf-or-n",1363950355),cljs.core.async.sliding_buffer.call(null,(2048)));
var backoff_ms_fn = cljs.core.get.call(null,map__33258__$1,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),taoensso.encore.exp_backoff);
var wrap_recv_evs_QMARK_ = cljs.core.get.call(null,map__33258__$1,new cljs.core.Keyword(null,"wrap-recv-evs?","wrap-recv-evs?",-1996694153),true);
var _deprecated_more_opts = cljs.core.nth.call(null,vec__33257,(1),null);
if(cljs.core.truth_((function (){var __x = type;
try{if(cljs.core.truth_(taoensso.encore._invar_pred.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),null,new cljs.core.Keyword(null,"ajax","ajax",814345549),null,new cljs.core.Keyword(null,"auto","auto",-566279492),null], null), null)], null)).call(null,__x))){
return true;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33260){if((e33260 instanceof Error)){
var t = e33260;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.sente",1029,"([:in #{:ws :ajax :auto}] type)",__x,t);
} else {
throw e33260;

}
}})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),null,new cljs.core.Keyword(null,"ajax","ajax",814345549),null,new cljs.core.Keyword(null,"auto","auto",-566279492),null], null), null)], null),new cljs.core.Symbol(null,"type","type",-1480165421,null))))].join('')));
}

if(cljs.core.truth_((function (){var __x = client_id;
try{if(cljs.core.truth_(taoensso.encore.nblank_str_QMARK_.call(null,__x))){
return true;
} else {
return taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33261){if((e33261 instanceof Error)){
var t = e33261;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.sente",1030,"(enc/nblank-str? client-id)",__x,t);
} else {
throw e33261;

}
}})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.Symbol("enc","nblank-str?","enc/nblank-str?",19952870,null),new cljs.core.Symbol(null,"client-id","client-id",1175909387,null))))].join('')));
}

if(!((_deprecated_more_opts == null))){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["`make-channel-socket!` fn signature CHANGED with Sente v0.10.0."], null);
});})(vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null);
} else {
}

if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"lp-timeout","lp-timeout",1149461302))){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [":lp-timeout opt has CHANGED; please use :lp-timout-ms."], null);
});})(vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null);
} else {
}

var packer__$1 = taoensso.sente.interfaces.coerce_packer.call(null,packer);
var win_location = taoensso.encore.get_window_location.call(null);
var win_protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(win_location);
var host__$1 = (function (){var or__16349__auto__ = host;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return new cljs.core.Keyword(null,"host","host",-1558485167).cljs$core$IFn$_invoke$arity$1(win_location);
}
})();
var path__$1 = (function (){var or__16349__auto__ = path;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return new cljs.core.Keyword(null,"pathname","pathname",-1420497528).cljs$core$IFn$_invoke$arity$1(win_location);
}
})();
var private_chs = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(10))),new cljs.core.Keyword(null,"internal","internal",-854870097),cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(10))),new cljs.core.Keyword(null,"<server","<server",-2135373537),cljs.core.async.chan.call(null,recv_buf_or_n)], null);
var ever_opened_QMARK__ = cljs.core.atom.call(null,false);
var state_STAR_ = ((function (packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (state){
if(cljs.core.truth_((function (){var or__16349__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(state));
if(or__16349__auto__){
return or__16349__auto__;
} else {
return cljs.core.deref.call(null,ever_opened_QMARK__);
}
})())){
return state;
} else {
cljs.core.reset_BANG_.call(null,ever_opened_QMARK__,true);

return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"first-open?","first-open?",396686530),true);
}
});})(packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
;
var public_ch_recv = cljs.core.async.merge.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(private_chs),cljs.core.async.map_LT_.call(null,((function (packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (state){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","state","chsk/state",-1991397620),state_STAR_.call(null,state)], null);
});})(packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(private_chs)),(function (){var _LT_server_ch = new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(private_chs);
if(cljs.core.truth_(wrap_recv_evs_QMARK_)){
return cljs.core.async.map_LT_.call(null,((function (_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (ev){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","recv","chsk/recv",561097091),ev], null);
});})(_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,_LT_server_ch);
} else {
return cljs.core.async.map_LT_.call(null,((function (_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (ev){
var vec__33262 = ev;
var id = cljs.core.nth.call(null,vec__33262,(0),null);
var _QMARK_data = cljs.core.nth.call(null,vec__33262,(1),null);
var __x_33270 = (function (){try{return cljs.core.namespace.call(null,id);
}catch (e33263){if((e33263 instanceof Error)){
var t = e33263;
return taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.sente",1069,"((fn* [p1__33253#] (not= p1__33253# \"chsk\")) (namespace id))",taoensso.encore._invar_undefined_val,t);
} else {
throw e33263;

}
}})();
try{if(((function (__x_33270,vec__33262,id,_QMARK_data,_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (p1__33253_SHARP_){
return cljs.core.not_EQ_.call(null,p1__33253_SHARP_,"chsk");
});})(__x_33270,vec__33262,id,_QMARK_data,_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
.call(null,__x_33270)){
} else {
taoensso.encore._invar_violation_BANG_.call(null);
}
}catch (e33264){if((e33264 instanceof Error)){
var t_33271 = e33264;
taoensso.encore._invar_violation_BANG_.call(null,true,"taoensso.sente",1069,"((fn* [p1__33253#] (not= p1__33253# \"chsk\")) (namespace id))",__x_33270,t_33271);
} else {
throw e33264;

}
}
return ev;
});})(_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,_LT_server_ch);
}
})()], null));
var chsk = (function (){var or__16349__auto__ = (function (){var and__16337__auto__ = cljs.core.not_EQ_.call(null,type,new cljs.core.Keyword(null,"ajax","ajax",814345549));
if(and__16337__auto__){
return taoensso.sente.chsk_init_BANG_.call(null,taoensso.sente.map__GT_ChWebSocket.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),new cljs.core.Keyword(null,"nattempt_","nattempt_",1980196552),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),new cljs.core.Keyword(null,"state_","state_",957667102)],[client_id,ws_kalive_ms,cljs.core.atom.call(null,(0)),packer__$1,private_chs,params,backoff_ms_fn,cljs.core.atom.call(null,null),(function (){var temp__4423__auto__ = new cljs.core.Keyword(null,"chsk-url-fn","chsk-url-fn",1968894294).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4423__auto__)){
var f = temp__4423__auto__;
return f.call(null,path__$1,win_location,new cljs.core.Keyword(null,"ws","ws",86841443));
} else {
return taoensso.sente.get_chsk_url.call(null,win_protocol,host__$1,path__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
}
})(),cljs.core.atom.call(null,true),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.call(null,null),cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"destroyed?","destroyed?",1049634064),false], null))])));
} else {
return and__16337__auto__;
}
})();
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
var and__16337__auto__ = cljs.core.not_EQ_.call(null,type,new cljs.core.Keyword(null,"ws","ws",86841443));
if(and__16337__auto__){
return taoensso.sente.chsk_init_BANG_.call(null,taoensso.sente.map__GT_ChAjaxSocket.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),new cljs.core.Keyword(null,"state_","state_",957667102)],[cljs.core.atom.call(null,null),client_id,packer__$1,private_chs,params,backoff_ms_fn,(function (){var temp__4423__auto__ = new cljs.core.Keyword(null,"chsk-url-fn","chsk-url-fn",1968894294).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4423__auto__)){
var f = temp__4423__auto__;
return f.call(null,path__$1,win_location,new cljs.core.Keyword(null,"ajax","ajax",814345549));
} else {
return taoensso.sente.get_chsk_url.call(null,win_protocol,host__$1,path__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
}
})(),ajax_opts,lp_timeout_ms,cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ajax","ajax",814345549),new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"destroyed?","destroyed?",1049634064),false], null))])));
} else {
return and__16337__auto__;
}
}
})();
var _ = (cljs.core.truth_(chsk)?null:(function(){throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Failed to create channel socket"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"chsk","chsk",776828446,null)))].join('')))})());
var send_fn = cljs.core.partial.call(null,taoensso.sente.chsk_send_BANG_,chsk);
var public_ch_recv__$1 = cljs.core.async.map_LT_.call(null,((function (packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,public_ch_recv,chsk,_,send_fn,vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function taoensso$sente$ev__GT_ev_msg(ev){
var vec__33266 = taoensso.sente.as_event.call(null,ev);
var ev_id = cljs.core.nth.call(null,vec__33266,(0),null);
var ev__QMARK_data = cljs.core.nth.call(null,vec__33266,(1),null);
var ev__$1 = vec__33266;
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),public_ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk),new cljs.core.Keyword(null,"event","event",301435442),ev__$1,new cljs.core.Keyword(null,"id","id",-1388402092),ev_id,new cljs.core.Keyword(null,"?data","?data",-9471433),ev__QMARK_data], null);
});})(packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,public_ch_recv,chsk,_,send_fn,vec__33257,map__33258,map__33258__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,public_ch_recv);
if(cljs.core.truth_(chsk)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"chsk","chsk",-863703081),chsk,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),public_ch_recv__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk)], null);
} else {
return null;
}
});

taoensso.sente.make_channel_socket_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.make_channel_socket_BANG_.cljs$lang$applyTo = (function (seq33254){
var G__33255 = cljs.core.first.call(null,seq33254);
var seq33254__$1 = cljs.core.next.call(null,seq33254);
return taoensso.sente.make_channel_socket_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33255,seq33254__$1);
});
/**
 * Creates a go-loop to call `(event-msg-handler <event-msg>)` and returns a
 *   `(fn stop! [])`. Catches & logs errors. Advanced users may choose to instead
 *   write their own loop against `ch-recv`.
 */
taoensso.sente.start_chsk_router_BANG_ = (function taoensso$sente$start_chsk_router_BANG_(var_args){
var args__17414__auto__ = [];
var len__17407__auto___33454 = arguments.length;
var i__17408__auto___33455 = (0);
while(true){
if((i__17408__auto___33455 < len__17407__auto___33454)){
args__17414__auto__.push((arguments[i__17408__auto___33455]));

var G__33456 = (i__17408__auto___33455 + (1));
i__17408__auto___33455 = G__33456;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((2) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((2)),(0))):null);
return taoensso.sente.start_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17415__auto__);
});

taoensso.sente.start_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__33275){
var vec__33276 = p__33275;
var map__33277 = cljs.core.nth.call(null,vec__33276,(0),null);
var map__33277__$1 = ((((!((map__33277 == null)))?((((map__33277.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33277.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33277):map__33277);
var opts = map__33277__$1;
var trace_evs_QMARK_ = cljs.core.get.call(null,map__33277__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__33277__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
var ch_ctrl = cljs.core.async.chan.call(null);
var c__19429__auto___33457 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___33457,ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___33457,ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler){
return (function (state_33390){
var state_val_33391 = (state_33390[(1)]);
if((state_val_33391 === (7))){
var inst_33386 = (state_33390[(2)]);
var state_33390__$1 = state_33390;
var statearr_33392_33458 = state_33390__$1;
(statearr_33392_33458[(2)] = inst_33386);

(statearr_33392_33458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (20))){
var inst_33288 = (state_33390[(7)]);
var inst_33313 = (state_33390[(8)]);
var inst_33287 = (state_33390[(9)]);
var inst_33312 = (state_33390[(10)]);
var inst_33286 = (state_33390[(11)]);
var inst_33285 = (state_33390[(12)]);
var inst_33323 = (function (){var vec__33280 = inst_33285;
var v = inst_33286;
var p = inst_33287;
var stop_QMARK_ = inst_33288;
var map__33291 = inst_33312;
var event_msg = inst_33312;
var event = inst_33313;
return ((function (vec__33280,v,p,stop_QMARK_,map__33291,event_msg,event,inst_33288,inst_33313,inst_33287,inst_33312,inst_33286,inst_33285,state_val_33391,c__19429__auto___33457,ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Pre-handler event: %s",event], null);
});
;})(vec__33280,v,p,stop_QMARK_,map__33291,event_msg,event,inst_33288,inst_33313,inst_33287,inst_33312,inst_33286,inst_33285,state_val_33391,c__19429__auto___33457,ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler))
})();
var inst_33324 = (new cljs.core.Delay(inst_33323,null));
var inst_33325 = taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),inst_33324,null);
var state_33390__$1 = state_33390;
var statearr_33393_33459 = state_33390__$1;
(statearr_33393_33459[(2)] = inst_33325);

(statearr_33393_33459[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (27))){
var inst_33338 = taoensso.encore._invar_violation_BANG_.call(null);
var state_33390__$1 = state_33390;
var statearr_33394_33460 = state_33390__$1;
(statearr_33394_33460[(2)] = inst_33338);

(statearr_33394_33460[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (1))){
var state_33390__$1 = state_33390;
var statearr_33395_33461 = state_33390__$1;
(statearr_33395_33461[(2)] = null);

(statearr_33395_33461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (24))){
var inst_33312 = (state_33390[(10)]);
var inst_33329 = (state_33390[(2)]);
var inst_33330 = "(event-msg? event-msg)";
var inst_33331 = taoensso.encore._invar_violation_BANG_.call(null,false,"taoensso.sente",1154,inst_33330,inst_33312,inst_33329);
var state_33390__$1 = state_33390;
var statearr_33396_33462 = state_33390__$1;
(statearr_33396_33462[(2)] = inst_33331);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33390__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (39))){
var state_33390__$1 = state_33390;
var statearr_33397_33463 = state_33390__$1;
(statearr_33397_33463[(2)] = null);

(statearr_33397_33463[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (4))){
var inst_33288 = (state_33390[(7)]);
var inst_33287 = (state_33390[(9)]);
var inst_33285 = (state_33390[(12)]);
var inst_33285__$1 = (state_33390[(2)]);
var inst_33286 = cljs.core.nth.call(null,inst_33285__$1,(0),null);
var inst_33287__$1 = cljs.core.nth.call(null,inst_33285__$1,(1),null);
var inst_33288__$1 = taoensso.encore.kw_identical_QMARK_.call(null,inst_33287__$1,ch_ctrl);
var state_33390__$1 = (function (){var statearr_33398 = state_33390;
(statearr_33398[(7)] = inst_33288__$1);

(statearr_33398[(9)] = inst_33287__$1);

(statearr_33398[(11)] = inst_33286);

(statearr_33398[(12)] = inst_33285__$1);

return statearr_33398;
})();
if(cljs.core.truth_(inst_33288__$1)){
var statearr_33399_33464 = state_33390__$1;
(statearr_33399_33464[(1)] = (5));

} else {
var statearr_33400_33465 = state_33390__$1;
(statearr_33400_33465[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (15))){
var inst_33286 = (state_33390[(11)]);
var state_33390__$1 = state_33390;
var statearr_33401_33466 = state_33390__$1;
(statearr_33401_33466[(2)] = inst_33286);

(statearr_33401_33466[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (21))){
var state_33390__$1 = state_33390;
var statearr_33402_33467 = state_33390__$1;
(statearr_33402_33467[(2)] = null);

(statearr_33402_33467[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (31))){
var inst_33383 = (state_33390[(2)]);
var state_33390__$1 = (function (){var statearr_33403 = state_33390;
(statearr_33403[(13)] = inst_33383);

return statearr_33403;
})();
var statearr_33404_33468 = state_33390__$1;
(statearr_33404_33468[(2)] = null);

(statearr_33404_33468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (32))){
var inst_33371 = (state_33390[(14)]);
var inst_33373 = (state_33390[(15)]);
var inst_33371__$1 = (state_33390[(2)]);
var inst_33372 = cljs.core.nth.call(null,inst_33371__$1,(0),null);
var inst_33373__$1 = cljs.core.nth.call(null,inst_33371__$1,(1),null);
var state_33390__$1 = (function (){var statearr_33405 = state_33390;
(statearr_33405[(14)] = inst_33371__$1);

(statearr_33405[(16)] = inst_33372);

(statearr_33405[(15)] = inst_33373__$1);

return statearr_33405;
})();
if(cljs.core.truth_(inst_33373__$1)){
var statearr_33406_33469 = state_33390__$1;
(statearr_33406_33469[(1)] = (38));

} else {
var statearr_33407_33470 = state_33390__$1;
(statearr_33407_33470[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (40))){
var inst_33380 = (state_33390[(2)]);
var state_33390__$1 = state_33390;
var statearr_33408_33471 = state_33390__$1;
(statearr_33408_33471[(2)] = inst_33380);

(statearr_33408_33471[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (33))){
var inst_33352 = (state_33390[(2)]);
var inst_33353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33354 = [null,inst_33352];
var inst_33355 = (new cljs.core.PersistentVector(null,2,(5),inst_33353,inst_33354,null));
var state_33390__$1 = state_33390;
var statearr_33409_33472 = state_33390__$1;
(statearr_33409_33472[(2)] = inst_33355);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33390__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (13))){
var inst_33304 = (state_33390[(2)]);
var state_33390__$1 = state_33390;
var statearr_33410_33473 = state_33390__$1;
(statearr_33410_33473[(2)] = inst_33304);

(statearr_33410_33473[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (22))){
var inst_33328 = (state_33390[(2)]);
var state_33390__$1 = (function (){var statearr_33411 = state_33390;
(statearr_33411[(17)] = inst_33328);

return statearr_33411;
})();
var statearr_33412_33474 = state_33390__$1;
(statearr_33412_33474[(2)] = null);

(statearr_33412_33474[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (36))){
var inst_33288 = (state_33390[(7)]);
var inst_33313 = (state_33390[(8)]);
var inst_33287 = (state_33390[(9)]);
var inst_33347 = (state_33390[(18)]);
var inst_33312 = (state_33390[(10)]);
var inst_33286 = (state_33390[(11)]);
var inst_33285 = (state_33390[(12)]);
var inst_33349 = (state_33390[(19)]);
var inst_33348 = (state_33390[(20)]);
var inst_33363 = (function (){var vec__33292 = inst_33347;
var p = inst_33287;
var _QMARK_error = inst_33349;
var temp__4425__auto__ = inst_33349;
var v = inst_33286;
var temp__4423__auto__ = error_handler;
var _ = inst_33348;
var vec__33280 = inst_33285;
var event_msg = inst_33312;
var e = inst_33349;
var map__33291 = inst_33312;
var event = inst_33313;
var stop_QMARK_ = inst_33288;
return ((function (vec__33292,p,_QMARK_error,temp__4425__auto__,v,temp__4423__auto__,_,vec__33280,event_msg,e,map__33291,event,stop_QMARK_,inst_33288,inst_33313,inst_33287,inst_33347,inst_33312,inst_33286,inst_33285,inst_33349,inst_33348,state_val_33391,c__19429__auto___33457,ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"Chsk router `event-msg-handler` error: %s",event], null);
});
;})(vec__33292,p,_QMARK_error,temp__4425__auto__,v,temp__4423__auto__,_,vec__33280,event_msg,e,map__33291,event,stop_QMARK_,inst_33288,inst_33313,inst_33287,inst_33347,inst_33312,inst_33286,inst_33285,inst_33349,inst_33348,state_val_33391,c__19429__auto___33457,ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler))
})();
var inst_33364 = (new cljs.core.Delay(inst_33363,null));
var inst_33365 = taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),inst_33364,null);
var state_33390__$1 = state_33390;
var statearr_33413_33475 = state_33390__$1;
(statearr_33413_33475[(2)] = inst_33365);

(statearr_33413_33475[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (29))){
var state_33390__$1 = state_33390;
var statearr_33414_33476 = state_33390__$1;
(statearr_33414_33476[(2)] = null);

(statearr_33414_33476[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (6))){
var inst_33286 = (state_33390[(11)]);
var inst_33294 = (inst_33286 == null);
var inst_33295 = cljs.core.not.call(null,inst_33294);
var state_33390__$1 = state_33390;
if(inst_33295){
var statearr_33415_33477 = state_33390__$1;
(statearr_33415_33477[(1)] = (8));

} else {
var statearr_33416_33478 = state_33390__$1;
(statearr_33416_33478[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (28))){
var inst_33340 = (state_33390[(2)]);
var state_33390__$1 = state_33390;
var statearr_33417_33479 = state_33390__$1;
(statearr_33417_33479[(2)] = inst_33340);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33390__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (25))){
var inst_33312 = (state_33390[(10)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_33390,(24),Error,null,(23));
var inst_33335 = taoensso.sente.event_msg_QMARK_.call(null,inst_33312);
var state_33390__$1 = state_33390;
if(cljs.core.truth_(inst_33335)){
var statearr_33418_33480 = state_33390__$1;
(statearr_33418_33480[(1)] = (26));

} else {
var statearr_33419_33481 = state_33390__$1;
(statearr_33419_33481[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (34))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_33390,(33),Error,null,(32));
var inst_33359 = cljs.core.PersistentVector.EMPTY_NODE;
var state_33390__$1 = (function (){var statearr_33420 = state_33390;
(statearr_33420[(21)] = inst_33359);

return statearr_33420;
})();
if(cljs.core.truth_(error_handler)){
var statearr_33421_33482 = state_33390__$1;
(statearr_33421_33482[(1)] = (35));

} else {
var statearr_33422_33483 = state_33390__$1;
(statearr_33422_33483[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (17))){
var inst_33347 = (state_33390[(18)]);
var inst_33349 = (state_33390[(19)]);
var inst_33347__$1 = (state_33390[(2)]);
var inst_33348 = cljs.core.nth.call(null,inst_33347__$1,(0),null);
var inst_33349__$1 = cljs.core.nth.call(null,inst_33347__$1,(1),null);
var state_33390__$1 = (function (){var statearr_33423 = state_33390;
(statearr_33423[(18)] = inst_33347__$1);

(statearr_33423[(19)] = inst_33349__$1);

(statearr_33423[(20)] = inst_33348);

return statearr_33423;
})();
if(cljs.core.truth_(inst_33349__$1)){
var statearr_33424_33484 = state_33390__$1;
(statearr_33424_33484[(1)] = (29));

} else {
var statearr_33425_33485 = state_33390__$1;
(statearr_33425_33485[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (3))){
var inst_33388 = (state_33390[(2)]);
var state_33390__$1 = state_33390;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33390__$1,inst_33388);
} else {
if((state_val_33391 === (12))){
var state_33390__$1 = state_33390;
var statearr_33426_33486 = state_33390__$1;
(statearr_33426_33486[(2)] = false);

(statearr_33426_33486[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (2))){
var inst_33281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33282 = [ch_recv,ch_ctrl];
var inst_33283 = (new cljs.core.PersistentVector(null,2,(5),inst_33281,inst_33282,null));
var state_33390__$1 = state_33390;
return cljs.core.async.ioc_alts_BANG_.call(null,state_33390__$1,(4),inst_33283);
} else {
if((state_val_33391 === (23))){
var inst_33321 = (state_33390[(22)]);
var inst_33342 = (state_33390[(2)]);
var inst_33343 = event_msg_handler.call(null,inst_33342);
var inst_33344 = [inst_33343,null];
var inst_33345 = (new cljs.core.PersistentVector(null,2,(5),inst_33321,inst_33344,null));
var state_33390__$1 = state_33390;
var statearr_33427_33487 = state_33390__$1;
(statearr_33427_33487[(2)] = inst_33345);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33390__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (35))){
var inst_33312 = (state_33390[(10)]);
var inst_33349 = (state_33390[(19)]);
var inst_33361 = error_handler.call(null,inst_33349,inst_33312);
var state_33390__$1 = state_33390;
var statearr_33428_33488 = state_33390__$1;
(statearr_33428_33488[(2)] = inst_33361);

(statearr_33428_33488[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (19))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_33390,(18),Error,null,(17));
var inst_33321 = cljs.core.PersistentVector.EMPTY_NODE;
var state_33390__$1 = (function (){var statearr_33429 = state_33390;
(statearr_33429[(22)] = inst_33321);

return statearr_33429;
})();
if(cljs.core.truth_(trace_evs_QMARK_)){
var statearr_33430_33489 = state_33390__$1;
(statearr_33430_33489[(1)] = (20));

} else {
var statearr_33431_33490 = state_33390__$1;
(statearr_33431_33490[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (11))){
var state_33390__$1 = state_33390;
var statearr_33432_33491 = state_33390__$1;
(statearr_33432_33491[(2)] = true);

(statearr_33432_33491[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (9))){
var state_33390__$1 = state_33390;
var statearr_33433_33492 = state_33390__$1;
(statearr_33433_33492[(2)] = false);

(statearr_33433_33492[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (5))){
var state_33390__$1 = state_33390;
var statearr_33434_33493 = state_33390__$1;
(statearr_33434_33493[(2)] = null);

(statearr_33434_33493[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (14))){
var inst_33286 = (state_33390[(11)]);
var inst_33309 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33286);
var state_33390__$1 = state_33390;
var statearr_33435_33494 = state_33390__$1;
(statearr_33435_33494[(2)] = inst_33309);

(statearr_33435_33494[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (26))){
var inst_33312 = (state_33390[(10)]);
var state_33390__$1 = state_33390;
var statearr_33436_33495 = state_33390__$1;
(statearr_33436_33495[(2)] = inst_33312);

(statearr_33436_33495[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (16))){
var inst_33312 = (state_33390[(10)]);
var inst_33312__$1 = (state_33390[(2)]);
var inst_33313 = cljs.core.get.call(null,inst_33312__$1,new cljs.core.Keyword(null,"event","event",301435442));
var state_33390__$1 = (function (){var statearr_33437 = state_33390;
(statearr_33437[(8)] = inst_33313);

(statearr_33437[(10)] = inst_33312__$1);

return statearr_33437;
})();
var statearr_33438_33496 = state_33390__$1;
(statearr_33438_33496[(2)] = null);

(statearr_33438_33496[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (38))){
var inst_33288 = (state_33390[(7)]);
var inst_33313 = (state_33390[(8)]);
var inst_33287 = (state_33390[(9)]);
var inst_33347 = (state_33390[(18)]);
var inst_33371 = (state_33390[(14)]);
var inst_33372 = (state_33390[(16)]);
var inst_33373 = (state_33390[(15)]);
var inst_33312 = (state_33390[(10)]);
var inst_33286 = (state_33390[(11)]);
var inst_33285 = (state_33390[(12)]);
var inst_33349 = (state_33390[(19)]);
var inst_33375 = (function (){var vec__33292 = inst_33347;
var p = inst_33287;
var _QMARK_error = inst_33349;
var temp__4425__auto__ = inst_33373;
var v = inst_33286;
var _ = inst_33372;
var e2 = inst_33373;
var vec__33280 = inst_33285;
var _QMARK_error2 = inst_33373;
var event_msg = inst_33312;
var e = inst_33349;
var map__33291 = inst_33312;
var event = inst_33313;
var vec__33351 = inst_33371;
var stop_QMARK_ = inst_33288;
return ((function (vec__33292,p,_QMARK_error,temp__4425__auto__,v,_,e2,vec__33280,_QMARK_error2,event_msg,e,map__33291,event,vec__33351,stop_QMARK_,inst_33288,inst_33313,inst_33287,inst_33347,inst_33371,inst_33372,inst_33373,inst_33312,inst_33286,inst_33285,inst_33349,state_val_33391,c__19429__auto___33457,ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e2,"Chsk router `error-handler` error: %s",event], null);
});
;})(vec__33292,p,_QMARK_error,temp__4425__auto__,v,_,e2,vec__33280,_QMARK_error2,event_msg,e,map__33291,event,vec__33351,stop_QMARK_,inst_33288,inst_33313,inst_33287,inst_33347,inst_33371,inst_33372,inst_33373,inst_33312,inst_33286,inst_33285,inst_33349,state_val_33391,c__19429__auto___33457,ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler))
})();
var inst_33376 = (new cljs.core.Delay(inst_33375,null));
var inst_33377 = taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/y4/k5vnhw4s6t16vs9m__y_hkcc0000gn/T/form-init7145221391605092520.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),inst_33376,null);
var state_33390__$1 = state_33390;
var statearr_33439_33497 = state_33390__$1;
(statearr_33439_33497[(2)] = inst_33377);

(statearr_33439_33497[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (30))){
var state_33390__$1 = state_33390;
var statearr_33440_33498 = state_33390__$1;
(statearr_33440_33498[(2)] = null);

(statearr_33440_33498[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (10))){
var inst_33307 = (state_33390[(2)]);
var state_33390__$1 = state_33390;
if(cljs.core.truth_(inst_33307)){
var statearr_33441_33499 = state_33390__$1;
(statearr_33441_33499[(1)] = (14));

} else {
var statearr_33442_33500 = state_33390__$1;
(statearr_33442_33500[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (18))){
var inst_33314 = (state_33390[(2)]);
var inst_33315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33316 = [null,inst_33314];
var inst_33317 = (new cljs.core.PersistentVector(null,2,(5),inst_33315,inst_33316,null));
var state_33390__$1 = state_33390;
var statearr_33443_33501 = state_33390__$1;
(statearr_33443_33501[(2)] = inst_33317);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33390__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (37))){
var inst_33359 = (state_33390[(21)]);
var inst_33367 = (state_33390[(2)]);
var inst_33368 = [inst_33367,null];
var inst_33369 = (new cljs.core.PersistentVector(null,2,(5),inst_33359,inst_33368,null));
var state_33390__$1 = state_33390;
var statearr_33444_33502 = state_33390__$1;
(statearr_33444_33502[(2)] = inst_33369);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33390__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33391 === (8))){
var inst_33286 = (state_33390[(11)]);
var inst_33297 = inst_33286.cljs$lang$protocol_mask$partition0$;
var inst_33298 = (inst_33297 & (64));
var inst_33299 = inst_33286.cljs$core$ISeq$;
var inst_33300 = (inst_33298) || (inst_33299);
var state_33390__$1 = state_33390;
if(cljs.core.truth_(inst_33300)){
var statearr_33445_33503 = state_33390__$1;
(statearr_33445_33503[(1)] = (11));

} else {
var statearr_33446_33504 = state_33390__$1;
(statearr_33446_33504[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___33457,ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler))
;
return ((function (switch__19364__auto__,c__19429__auto___33457,ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler){
return (function() {
var taoensso$sente$state_machine__19365__auto__ = null;
var taoensso$sente$state_machine__19365__auto____0 = (function (){
var statearr_33450 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33450[(0)] = taoensso$sente$state_machine__19365__auto__);

(statearr_33450[(1)] = (1));

return statearr_33450;
});
var taoensso$sente$state_machine__19365__auto____1 = (function (state_33390){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_33390);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e33451){if((e33451 instanceof Object)){
var ex__19368__auto__ = e33451;
var statearr_33452_33505 = state_33390;
(statearr_33452_33505[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33390);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33451;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33506 = state_33390;
state_33390 = G__33506;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
taoensso$sente$state_machine__19365__auto__ = function(state_33390){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__19365__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__19365__auto____1.call(this,state_33390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__19365__auto____0;
taoensso$sente$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__19365__auto____1;
return taoensso$sente$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___33457,ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler))
})();
var state__19431__auto__ = (function (){var statearr_33453 = f__19430__auto__.call(null);
(statearr_33453[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___33457);

return statearr_33453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___33457,ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler))
);


return ((function (ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler){
return (function taoensso$sente$stop_BANG_(){
return cljs.core.async.close_BANG_.call(null,ch_ctrl);
});
;})(ch_ctrl,vec__33276,map__33277,map__33277__$1,opts,trace_evs_QMARK_,error_handler))
});

taoensso.sente.start_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

taoensso.sente.start_chsk_router_BANG_.cljs$lang$applyTo = (function (seq33272){
var G__33273 = cljs.core.first.call(null,seq33272);
var seq33272__$1 = cljs.core.next.call(null,seq33272);
var G__33274 = cljs.core.first.call(null,seq33272__$1);
var seq33272__$2 = cljs.core.next.call(null,seq33272__$1);
return taoensso.sente.start_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33273,G__33274,seq33272__$2);
});
/**
 * DEPRECATED: Please use `start-chsk-router!` instead.
 */
taoensso.sente.start_chsk_router_loop_BANG_ = (function taoensso$sente$start_chsk_router_loop_BANG_(event_handler,ch_recv){
return taoensso.sente.start_chsk_router_BANG_.call(null,ch_recv,(function (ev_msg){
return event_handler.call(null,new cljs.core.Keyword(null,"event","event",301435442).cljs$core$IFn$_invoke$arity$1(ev_msg),new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861).cljs$core$IFn$_invoke$arity$1(ev_msg));
}));
});
/**
 * DEPRECATED. Please use `timbre/set-level!` instead.
 */
taoensso.sente.set_logging_level_BANG_ = (function taoensso$sente$set_logging_level_BANG_(level){
return taoensso.timbre.set_level_BANG_.call(null,level);
});
/**
 * DEPRECATED. Please use `taoensso.encore/ajax-lite` instead.
 */
taoensso.sente.ajax_call = taoensso.encore.ajax_lite;
/**
 * DEPRECATED.
 */
taoensso.sente.default_chsk_url_fn = (function taoensso$sente$default_chsk_url_fn(path,p__33507,websocket_QMARK_){
var map__33510 = p__33507;
var map__33510__$1 = ((((!((map__33510 == null)))?((((map__33510.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33510.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33510):map__33510);
var location = map__33510__$1;
var adjusted_protocol = cljs.core.get.call(null,map__33510__$1,new cljs.core.Keyword(null,"adjusted-protocol","adjusted-protocol",37431492));
var host = cljs.core.get.call(null,map__33510__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var pathname = cljs.core.get.call(null,map__33510__$1,new cljs.core.Keyword(null,"pathname","pathname",-1420497528));
return [cljs.core.str(adjusted_protocol),cljs.core.str("//"),cljs.core.str(host),cljs.core.str((function (){var or__16349__auto__ = path;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return pathname;
}
})())].join('');
});

//# sourceMappingURL=sente.js.map?rel=1449783500098