(ns yunjia.util.db
  (:require [clojure.java.jdbc :as j]
            [clojure.string :as str]))

(defn execute!
  "clojure.java.jdbc/execute!的包裹函数"
  [db-spec sql-params & {:keys [transaction? multi?]
                    :or {transaction? true multi? false}}]
  (j/execute! db-spec sql-params :transaction? transaction? :multi? multi?))

(defn query
  "clojure.java.jdbc/query的包裹函数"
  [db-spec sql-params & {:keys [result-set-fn row-fn identifiers as-arrays?]
                    :or {row-fn identity
                         identifiers str/lower-case}}]
  (j/query db-spec
           sql-params
           :result-set-fn result-set-fn
           :row-fn row-fn
           :identifiers identifiers
           :as-arrays? as-arrays?))


