(ns yunjia.util.tree
  "树结构相关操作。")

(defn seq-to-tree
  "传入一个seq，元素类型是map。将其转换为树结构。
  root-key: 待构造的树根节点的key。
  node-key-fn: 从node中获取key的函数。
  parent-key-fn: 从node中获取父节点key的函数。
  children-key: 在节点中存储子树的key。
  sort-key-fn: 可选，从node中获取排序key的函数。"
  [node-seq root-key node-key-fn parent-key-fn children-key & [sort-key-fn]]
  (let [n-seq (if sort-key-fn
                (sort-by sort-key-fn node-seq)
                node-seq)
        parent-to-children (group-by parent-key-fn n-seq)
        root-children (get parent-to-children root-key)
        make-tree (fn mt [node]
                    (let [nodes (if-let [children (get parent-to-children
                                                       (node-key-fn node))]
                                  (for [c children]
                                    (mt c))
                                  [])]
                      (assoc node children-key nodes)))]
    (for [c root-children]
      (make-tree c))))
