(ns yunjia.util.component.jetty
  "定义jetty组件。"
  (:require [com.stuartsierra.component :as component]
            [ring.adapter.jetty :as jetty]
            [taoensso.timbre :refer [debug]]
            [ring.logger.timbre :refer [wrap-with-logger]]))

;; Jetty组件，运行jetty启动服务。依赖config组件、handler组件。
(defrecord Jetty [config handler options jetty]
  component/Lifecycle

  (start [this]
    (debug "Starting Jetty component...")
    (if (:jetty this)
      this
      (let [host (or (get-in config [:value :http-host])
                     "0.0.0.0")
            port (-> (or (get-in config [:value :http-port])
                         9999)
                     str
                     Integer/parseInt)]
        (assoc this :jetty (jetty/run-jetty
                             (:handler handler)
                             (merge {:join? false
                                     :host host
                                     :port  port}
                                    options))))))

  (stop [this]
    (debug "Stopping Jetty component...")
    (if (:jetty this)
      (.stop (:jetty this)))
    (assoc this :jetty nil)))

(defn make-jetty
  ([] (make-jetty {}))
  ([options] (map->Jetty {:options options})))