(ns yunjia.util.business.city
  "省市区相关的业务操作。"
  (:require [yunjia.util.business.config :as config]))

(defn province-code-to-name
  [config-db-spec province-code-seq]
  (config/code-to-name config-db-spec province-code-seq :province :code :name))

(defn city-code-to-name
  [config-db-spec city-code-seq]
  (config/code-to-name config-db-spec city-code-seq :city :code :name))

(defn area-code-to-name
  [config-db-spec area-code-seq]
  (config/code-to-name config-db-spec area-code-seq :area :code :name))

(defn city-code-by
  [^String area-code]
  (str (subs area-code 0 4) "00"))

(defn province-code-by
  [^String area-code-or-city-code]
  (str (subs area-code-or-city-code 0 2) "0000"))

