(ns yunjia.util.component.redis-client
  "使用jedis访问redis
  create by yan 2018/01/02 15:37"
  (:require [com.stuartsierra.component :as component]
            [taoensso.timbre :as timbre])
  (:import (java.util HashSet)
           (redis.clients.jedis HostAndPort JedisCluster Jedis)))

(defrecord redis-client [config-redis-key config]
  component/Lifecycle

  (start [this]
    (timbre/debug "Starting redis-client component...")
    (if (:redis_client this)
      this
      (let [redis-key (if config-redis-key
                     (keyword config-redis-key)
                     :redis-cluster)
            redis-config (get-in config [:value redis-key])
            {:keys [nodes host port password
                    connection-timeout so-timeout max-attempts]} redis-config

            connection-timeout (-> (or connection-timeout 2000)
                                   (str)
                                   (Integer/parseInt))

            so-timeout (-> (or so-timeout 2000)
                           (str)
                           (Integer/parseInt))

            max-attempts (-> (or so-timeout 5)
                             (str)
                             (Integer/parseInt))

            ;;非集群部署
            redis-host (or host "127.0.0.1")
            redis-port (-> (or port 6379)
                           (str)
                           (Integer/parseInt))

            ;;集群部署
            ;;new 一个cluster 节点
            jedis-cluster-nodes (new HashSet)

            ;;添加节点的host、port
            _ (doseq [{:keys [host ports]} nodes]
                (doseq [port ports]
                  (let [node-host (or host "127.0.0.1")
                        node-port (-> (or port 6379)
                                       str
                                       Integer/parseInt)]
                    (->> (new HostAndPort node-host node-port)
                         (.add jedis-cluster-nodes)))))

            ;;优先选择连接集群
            jedis-client (if-not (.isEmpty jedis-cluster-nodes)
                           (if password
                             (new JedisCluster jedis-cluster-nodes connection-timeout so-timeout max-attempts password)
                             (new JedisCluster jedis-cluster-nodes connection-timeout so-timeout max-attempts))
                           (new Jedis redis-host redis-port connection-timeout so-timeout))]
        (assoc this :redis_client jedis-client))))

  (stop [this]
    (timbre/debug "Stopping redis-client component...")
    ;(if (:redis_client this)
    ;  ;(component/stop (:redis_client this))
    ;  )
    (assoc this :redis_client nil)))

(defn make-redis-client
  ([] (make-redis-client :redis-cluster))
  ([config-redis-key] (map->redis-client {:config-redis-key (keyword config-redis-key)})))