(ns yunjia.util.coll
  "Collection相关的工具。")

(defn comparator-by-coll
  "输入一个Collection，构造一个comparator，按照被比较对象在coll中的先后来比较。"
  [coll]
  (let [item-to-index (into {} (map-indexed #(vector %2 %1) coll))]
    (fn [x y]
     (compare (item-to-index x) (item-to-index y)))))
