(ns yunjia.util.ring
  (:require [taoensso.encore :as enc])
  (:import (redis.clients.jedis JedisCluster)))


(deftype jedis-session-store [^JedisCluster jedis-cluster
                              ^String key-prefix
                              expiration-secs]
  ring.middleware.session.store/SessionStore
  (read-session [_ key]
    (.get jedis-cluster key))
  (write-session [_ key data]
    (let [key (or key
                  (str key-prefix "-" (enc/uuid-str)))]
      (if expiration-secs
        (.set jedis-cluster key data expiration-secs)
        (.set jedis-cluster key data))
      key))
  (delete-session [_ key]
    (.del jedis-cluster key)
    nil))

(defn custom-store
  "create by yan 2018/01/02 15:23"
  [jedis-cluster & [{:keys [key-prefix expiration-secs]
                     :or   {key-prefix      "ring:session"
                            expiration-secs (enc/secs :days 1)}}]]
  (jedis-session-store. jedis-cluster key-prefix expiration-secs))