(ns yunjia.util.business.config
  "配置数据库的公共操作。"
  (:require [honeysql.helpers :as h :refer :all :exclude [update]]
            [honeysql.core :as sql]
            [yunjia.util.db :as db]))

(defn code-to-name
  [config-db-spec code-seq table-name code-field name-field]
  (let [code-key (keyword code-field)
        name-key (keyword name-field)
        h-sql (-> (select code-key name-key)
                  (from (keyword table-name))
                  (where [:and
                          [:= :enable 1]
                          [:in code-key code-seq]]))
        rows (if (seq code-seq)
               (db/query! config-db-spec (sql/format h-sql))
               [])]
    (->> rows
         (map #(vector (code-key %) (name-key %)))
         (into {}))))
