(ns yunjia.util.business.geo
  "地理地图相关的操作。")

(defn ^Double distance
  "根据经纬度坐标，计算地图上两点间距离"
  [^Double lat1
   ^Double lng1
   ^Double lat2
   ^Double lng2]
  (let [EARTH_RADIUS 6378.137
        rad #(/ (* % Math/PI)
                180.0)
        radLat1 (rad lat1)
        radLat2 (rad lat2)
        a (- radLat1 radLat2)
        b (- (rad lng1) (rad lng2))
        s (* 2
             (Math/asin
               (Math/sqrt
                 (+ (Math/pow (Math/sin (/ a 2)) 2)
                    (* (Math/cos radLat1) (Math/cos radLat2) (Math/pow (Math/sin (/ b 2)) 2))))))]
    (/ (Math/round (* s EARTH_RADIUS 10000))
       10000)))
