(ns yunjia.util.component.scheduler
  (:require [com.stuartsierra.component :as component]
            [taoensso.timbre :as timbre])
  (:import (org.quartz.impl StdSchedulerFactory)))

;; scheduler组件，用于管理Quartz的scheduler。依赖config组件。
(defrecord Scheduler [config daily-scheduler]
  component/Lifecycle

  (start [this]
    (timbre/debug "Starting Scheduler component...")
    (if (:scheduler this)
      this
      (let [scheduler (StdSchedulerFactory/getDefaultScheduler)]
        (.start scheduler)
        (assoc this :scheduler scheduler))))

  (stop [this]
    (timbre/debug "Stopping Scheduler component...")
    (when-let [scheduler (:scheduler this)]
      (.shutdown ^org.quartz.Scheduler scheduler)
      (assoc this :scheduler nil))))

(defn make-scheduler
  []
  (map->Scheduler {}))