package weixin;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;



/**
 *
 * @author Awoke
 * @version 2018-1-24
 * @see AESUtil
 * @since
 */
public class AESUtil
{
    public static boolean initialized = false;

    /**
     * AES解密
     * @param content 密文
     * @return
     * @throws InvalidAlgorithmParameterException
     * @throws NoSuchProviderException
     */
    public static byte[] decrypt(byte[] content, byte[] keyByte, byte[] ivByte)
            throws InvalidAlgorithmParameterException
    {
        initialize();
        try
        {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            Key sKeySpec = new SecretKeySpec(keyByte, "AES");

            cipher.init(Cipher.DECRYPT_MODE, sKeySpec, generateIV(ivByte));// 初始化
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (NoSuchAlgorithmException e)
        {
            return e.toString().getBytes();
        }
        catch (NoSuchPaddingException e)
        {
            return e.toString().getBytes();
        }
        catch (InvalidKeyException e)
        {
            return e.toString().getBytes();
        }
        catch (IllegalBlockSizeException e)
        {
            return e.toString().getBytes();
        }
        catch (BadPaddingException e)
        {
            return e.toString().getBytes();
        }
        catch (NoSuchProviderException e)
        {
            // TODO Auto-generated catch block
            return e.toString().getBytes();
        }
        catch (Exception e)
        {
            // TODO Auto-generated catch block
            return e.toString().getBytes();
        }
//        return null;
    }

    public static void initialize()
    {
        if (initialized) return;
        Security.addProvider(new BouncyCastleProvider());
        initialized = true;
    }

    /**
     * 生成iv
     * @param iv
     * @return
     * @throws Exception
     * @see
     */
    public static AlgorithmParameters generateIV(byte[] iv)
            throws Exception
    {
        AlgorithmParameters params = AlgorithmParameters.getInstance("AES");
        params.init(new IvParameterSpec(iv));
        return params;
    }

}
