(ns api-comm.flickr
  (:require [clojure.string :refer [join split]]
            [ajax.core :as ajax]))

(def api-configs
  {:flickr {:api-url "https://api.flickr.com/services/rest/?"
            :args    {:format  "json"
                      :nojsoncallback 1
                      :per_page 100}}})

(def extras [:description :url_c :url_l :date_taken :date_upload :tags])

(defn search-by-tags [c-args tags handler]
  (let [c-api (update-in api-configs [:flickr :args] #(merge % c-args))]
    (ajax/GET
      (get-in c-api [:flickr :api-url])
      {:response-format :json
       :keywords? true
       :handler
         (fn [response]
           (-> response
               :photos
               :photo
               ((fn [photo-maps]
                  (map (fn [photo-map]
                         (-> photo-map
                             (select-keys
                               (concat extras [:id :title :datetaken :dateupload
                                               :width_c :height_c]))
                             (update-in [:tags] #(set (split % #" ")))))
                       photo-maps)))
               handler))
       :params
         (merge (get-in c-api [:flickr :args])
           {:method  "flickr.photos.search"
            :tags    tags
            :extras  (->> extras (map name) (join ","))})})))

(defn search-by-set [c-args user-id set-id handler]
  (let [c-api (update-in api-configs [:flickr :args] #(merge % c-args))]
    (ajax/GET
      (get-in c-api [:flickr :api-url])
      {:response-format :json
       :keywords? true
       :handler
         (fn [response]
           (-> response
               :photoset
               :photo
               ((fn [photo-maps]
                  (map (fn [photo-map]
                         (-> photo-map
                             (select-keys
                               (concat extras [:id :title :datetaken :dateupload
                                               :width_c :height_c]))
                             (update-in [:tags] #(set (split % #" ")))))
                       photo-maps)))
               handler))
       :params
         (merge (get-in c-api [:flickr :args])
           {:method  "flickr.photosets.getPhotos"
            :user_id user-id
            :photoset_id set-id
            :extras  (->> extras (map name) (join ","))})})))
