(ns carousel.demo
  (:require [cljs.reader :as reader]
            [reagent.core  :as r]
            [carousel.core :as c]
            [ajax.core :refer [GET]]
            [api-comm.flickr :as flickr]
            [api-comm.time-util :as time]))

(def mill-on-liberty {:author "John Stuart Mill" :source "On Liberty" :date "1859"})

(def quotes
  [(merge mill-on-liberty
     {:text "The peculiar evil of silencing the expression of an opinion is, that it is robbing the human race; posterity as well as the existing generation; those who dissent from the opinion, still more than those who hold it.  If the opinion is right, they are deprived of the opportunity of exchanging error for truth:  if wrong, they lose, what is almost as great a benefit, the clearer perception and livelier impression of truth, produced by its collision with error."})

   (merge mill-on-liberty
     {:text "We can never be sure that the opinion we are endeavoring to stifle is a false opinion; and if we were sure, stifling it would be an evil still."})

   (merge mill-on-liberty
     {:text "If all mankind minus one were of one opinion, mankind would be no more justified in silencing that one person than he, if he had the power, would be justified in silencing mankind."})

   (merge mill-on-liberty
     {:text "The greatest orator, save one, of antiquity, has left it on record that he always studied his adversary’s case with as great, if not with still greater, intensity than even his own. What Cicero practised as the means of forensic success, requires to be imitated by all who study any subject in order to arrive at the truth. He who knows only his own side of the case, knows little of that. His reasons may be good, and no one may have been able to refute them. But if he is equally unable to refute the reasons on the opposite side; if he does not so much as know what they are, he has no ground for preferring either opinion."})])

(def flickr-response (r/atom nil))

(flickr/search-by-tags
  {:api_key "3dafe467aabf03a796f940da7be18854"
   :min_upload_date 1445089447
   :user_id "zto450"}
  "zval"
  (fn [photo-maps]
    (reset! flickr-response photo-maps)))

(defn quote-view [{:keys [text author source date]}]
  [:div.quote
    [:div.text text]
    [:div.info {:style {:text-align "right"}}
      " —" author " (" source ", " date ")"]])

(defn photo-thumb [{:as photo-map
                    :keys [src-orig url_c width_c height_c
                           datetaken title id tags]}]
  (let [theme "dark"]
    ^{:key url_c}
    [:div.photo-thumb
      [:a {:href (str "http://flickr.com/photos/zto450/" id)}
        [:img {:width width_c :height height_c :src url_c}]]
      [:div.photo-info {:class theme}
        [:span.date (str "Taken " (time/conv-time-str datetaken))]
        [:span.caption title]]]))

(defn demo []
  (r/with-let [n  (r/atom 0)
               n2 (r/atom 0)]
    [:div.demo
      [:h1 "Carousel Demo"]
      [:div
        [:h3 "Quotes"
          [:span.badge (str (inc @n) " of " (count quotes))]]
        [c/carousel-items
          {:idx-model n
           :items (map quote-view quotes)}]
        (if @flickr-response
          [:div
            [:h3 "Photos"
              [:span.badge (str (inc @n2) " of " (count @flickr-response))]]
            [c/carousel-items
              {:idx-model n2
               :items (map photo-thumb @flickr-response)}]]
          [:div "loading..."])]]))

(defn mount-root []
  (r/render [demo] (.getElementById js/document "root")))

(mount-root)
