(ns carousel-demo.util
  (:require [cljs-time.core :as t]
            [cljs-time.format :as tf]))

(def source-format (tf/formatter "yyyy-MM-dd HH:mm:ss"))
(def target-format (tf/formatter "HH:mm"))

(defn n-to-month [n]
  (case n
    1 "January" 2 "February" 3 "March" 4 "April" 5 "May" 6 "June"
    7 "July" 8 "August" 9 "September" 10 "October" 11 "November" 12 "December"))

(defn n-to-nth [n]
  (case n
    1  "1st"   2 "2nd"   3 "3rd"
    21 "21st" 22 "22nd" 23 "23rd"
    31 "31st"
    (str n "th")))

(defn conv-time-str [in]
  (let [t (tf/parse source-format in)]
    (str (n-to-month (t/month t)) " " (n-to-nth (t/day t)) ", "
         (tf/unparse target-format t))))
