// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args29875 = [];
var len__27761__auto___29881 = arguments.length;
var i__27762__auto___29882 = (0);
while(true){
if((i__27762__auto___29882 < len__27761__auto___29881)){
args29875.push((arguments[i__27762__auto___29882]));

var G__29883 = (i__27762__auto___29882 + (1));
i__27762__auto___29882 = G__29883;
continue;
} else {
}
break;
}

var G__29877 = args29875.length;
switch (G__29877) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29875.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async29878 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29878 = (function (f,blockable,meta29879){
this.f = f;
this.blockable = blockable;
this.meta29879 = meta29879;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29878.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29880,meta29879__$1){
var self__ = this;
var _29880__$1 = this;
return (new cljs.core.async.t_cljs$core$async29878(self__.f,self__.blockable,meta29879__$1));
});

cljs.core.async.t_cljs$core$async29878.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29880){
var self__ = this;
var _29880__$1 = this;
return self__.meta29879;
});

cljs.core.async.t_cljs$core$async29878.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async29878.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29878.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async29878.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async29878.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta29879","meta29879",940261713,null)], null);
});

cljs.core.async.t_cljs$core$async29878.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29878.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29878";

cljs.core.async.t_cljs$core$async29878.cljs$lang$ctorPrWriter = (function (this__27230__auto__,writer__27231__auto__,opt__27232__auto__){
return cljs.core._write.call(null,writer__27231__auto__,"cljs.core.async/t_cljs$core$async29878");
});

cljs.core.async.__GT_t_cljs$core$async29878 = (function cljs$core$async$__GT_t_cljs$core$async29878(f__$1,blockable__$1,meta29879){
return (new cljs.core.async.t_cljs$core$async29878(f__$1,blockable__$1,meta29879));
});

}

return (new cljs.core.async.t_cljs$core$async29878(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args29887 = [];
var len__27761__auto___29890 = arguments.length;
var i__27762__auto___29891 = (0);
while(true){
if((i__27762__auto___29891 < len__27761__auto___29890)){
args29887.push((arguments[i__27762__auto___29891]));

var G__29892 = (i__27762__auto___29891 + (1));
i__27762__auto___29891 = G__29892;
continue;
} else {
}
break;
}

var G__29889 = args29887.length;
switch (G__29889) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29887.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args29894 = [];
var len__27761__auto___29897 = arguments.length;
var i__27762__auto___29898 = (0);
while(true){
if((i__27762__auto___29898 < len__27761__auto___29897)){
args29894.push((arguments[i__27762__auto___29898]));

var G__29899 = (i__27762__auto___29898 + (1));
i__27762__auto___29898 = G__29899;
continue;
} else {
}
break;
}

var G__29896 = args29894.length;
switch (G__29896) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29894.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args29901 = [];
var len__27761__auto___29904 = arguments.length;
var i__27762__auto___29905 = (0);
while(true){
if((i__27762__auto___29905 < len__27761__auto___29904)){
args29901.push((arguments[i__27762__auto___29905]));

var G__29906 = (i__27762__auto___29905 + (1));
i__27762__auto___29905 = G__29906;
continue;
} else {
}
break;
}

var G__29903 = args29901.length;
switch (G__29903) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29901.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_29908 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_29908);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_29908,ret){
return (function (){
return fn1.call(null,val_29908);
});})(val_29908,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args29909 = [];
var len__27761__auto___29912 = arguments.length;
var i__27762__auto___29913 = (0);
while(true){
if((i__27762__auto___29913 < len__27761__auto___29912)){
args29909.push((arguments[i__27762__auto___29913]));

var G__29914 = (i__27762__auto___29913 + (1));
i__27762__auto___29913 = G__29914;
continue;
} else {
}
break;
}

var G__29911 = args29909.length;
switch (G__29911) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29909.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6745__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6745__auto__)){
var ret = temp__6745__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6745__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6745__auto__)){
var retb = temp__6745__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6745__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6745__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__27591__auto___29916 = n;
var x_29917 = (0);
while(true){
if((x_29917 < n__27591__auto___29916)){
(a[x_29917] = (0));

var G__29918 = (x_29917 + (1));
x_29917 = G__29918;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__29919 = (i + (1));
i = G__29919;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async29923 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29923 = (function (alt_flag,flag,meta29924){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta29924 = meta29924;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29923.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29925,meta29924__$1){
var self__ = this;
var _29925__$1 = this;
return (new cljs.core.async.t_cljs$core$async29923(self__.alt_flag,self__.flag,meta29924__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async29923.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29925){
var self__ = this;
var _29925__$1 = this;
return self__.meta29924;
});})(flag))
;

cljs.core.async.t_cljs$core$async29923.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async29923.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async29923.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29923.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29923.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29924","meta29924",607062236,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async29923.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29923.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29923";

cljs.core.async.t_cljs$core$async29923.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27230__auto__,writer__27231__auto__,opt__27232__auto__){
return cljs.core._write.call(null,writer__27231__auto__,"cljs.core.async/t_cljs$core$async29923");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async29923 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async29923(alt_flag__$1,flag__$1,meta29924){
return (new cljs.core.async.t_cljs$core$async29923(alt_flag__$1,flag__$1,meta29924));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async29923(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async29929 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29929 = (function (alt_handler,flag,cb,meta29930){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta29930 = meta29930;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29929.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29931,meta29930__$1){
var self__ = this;
var _29931__$1 = this;
return (new cljs.core.async.t_cljs$core$async29929(self__.alt_handler,self__.flag,self__.cb,meta29930__$1));
});

cljs.core.async.t_cljs$core$async29929.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29931){
var self__ = this;
var _29931__$1 = this;
return self__.meta29930;
});

cljs.core.async.t_cljs$core$async29929.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async29929.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async29929.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29929.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async29929.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29930","meta29930",-1817535745,null)], null);
});

cljs.core.async.t_cljs$core$async29929.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29929.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29929";

cljs.core.async.t_cljs$core$async29929.cljs$lang$ctorPrWriter = (function (this__27230__auto__,writer__27231__auto__,opt__27232__auto__){
return cljs.core._write.call(null,writer__27231__auto__,"cljs.core.async/t_cljs$core$async29929");
});

cljs.core.async.__GT_t_cljs$core$async29929 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async29929(alt_handler__$1,flag__$1,cb__$1,meta29930){
return (new cljs.core.async.t_cljs$core$async29929(alt_handler__$1,flag__$1,cb__$1,meta29930));
});

}

return (new cljs.core.async.t_cljs$core$async29929(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29932_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29932_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29933_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29933_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__26578__auto__ = wport;
if(cljs.core.truth_(or__26578__auto__)){
return or__26578__auto__;
} else {
return port;
}
})()], null));
} else {
var G__29934 = (i + (1));
i = G__29934;
continue;
}
} else {
return null;
}
break;
}
})();
var or__26578__auto__ = ret;
if(cljs.core.truth_(or__26578__auto__)){
return or__26578__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6747__auto__ = (function (){var and__26566__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__26566__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__26566__auto__;
}
})();
if(cljs.core.truth_(temp__6747__auto__)){
var got = temp__6747__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__27768__auto__ = [];
var len__27761__auto___29940 = arguments.length;
var i__27762__auto___29941 = (0);
while(true){
if((i__27762__auto___29941 < len__27761__auto___29940)){
args__27768__auto__.push((arguments[i__27762__auto___29941]));

var G__29942 = (i__27762__auto___29941 + (1));
i__27762__auto___29941 = G__29942;
continue;
} else {
}
break;
}

var argseq__27769__auto__ = ((((1) < args__27768__auto__.length))?(new cljs.core.IndexedSeq(args__27768__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__27769__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29937){
var map__29938 = p__29937;
var map__29938__$1 = ((((!((map__29938 == null)))?((((map__29938.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29938.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29938):map__29938);
var opts = map__29938__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29935){
var G__29936 = cljs.core.first.call(null,seq29935);
var seq29935__$1 = cljs.core.next.call(null,seq29935);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29936,seq29935__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args29943 = [];
var len__27761__auto___29993 = arguments.length;
var i__27762__auto___29994 = (0);
while(true){
if((i__27762__auto___29994 < len__27761__auto___29993)){
args29943.push((arguments[i__27762__auto___29994]));

var G__29995 = (i__27762__auto___29994 + (1));
i__27762__auto___29994 = G__29995;
continue;
} else {
}
break;
}

var G__29945 = args29943.length;
switch (G__29945) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29943.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__29816__auto___29997 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___29997){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___29997){
return (function (state_29969){
var state_val_29970 = (state_29969[(1)]);
if((state_val_29970 === (7))){
var inst_29965 = (state_29969[(2)]);
var state_29969__$1 = state_29969;
var statearr_29971_29998 = state_29969__$1;
(statearr_29971_29998[(2)] = inst_29965);

(statearr_29971_29998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (1))){
var state_29969__$1 = state_29969;
var statearr_29972_29999 = state_29969__$1;
(statearr_29972_29999[(2)] = null);

(statearr_29972_29999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (4))){
var inst_29948 = (state_29969[(7)]);
var inst_29948__$1 = (state_29969[(2)]);
var inst_29949 = (inst_29948__$1 == null);
var state_29969__$1 = (function (){var statearr_29973 = state_29969;
(statearr_29973[(7)] = inst_29948__$1);

return statearr_29973;
})();
if(cljs.core.truth_(inst_29949)){
var statearr_29974_30000 = state_29969__$1;
(statearr_29974_30000[(1)] = (5));

} else {
var statearr_29975_30001 = state_29969__$1;
(statearr_29975_30001[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (13))){
var state_29969__$1 = state_29969;
var statearr_29976_30002 = state_29969__$1;
(statearr_29976_30002[(2)] = null);

(statearr_29976_30002[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (6))){
var inst_29948 = (state_29969[(7)]);
var state_29969__$1 = state_29969;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29969__$1,(11),to,inst_29948);
} else {
if((state_val_29970 === (3))){
var inst_29967 = (state_29969[(2)]);
var state_29969__$1 = state_29969;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29969__$1,inst_29967);
} else {
if((state_val_29970 === (12))){
var state_29969__$1 = state_29969;
var statearr_29977_30003 = state_29969__$1;
(statearr_29977_30003[(2)] = null);

(statearr_29977_30003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (2))){
var state_29969__$1 = state_29969;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29969__$1,(4),from);
} else {
if((state_val_29970 === (11))){
var inst_29958 = (state_29969[(2)]);
var state_29969__$1 = state_29969;
if(cljs.core.truth_(inst_29958)){
var statearr_29978_30004 = state_29969__$1;
(statearr_29978_30004[(1)] = (12));

} else {
var statearr_29979_30005 = state_29969__$1;
(statearr_29979_30005[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (9))){
var state_29969__$1 = state_29969;
var statearr_29980_30006 = state_29969__$1;
(statearr_29980_30006[(2)] = null);

(statearr_29980_30006[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (5))){
var state_29969__$1 = state_29969;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29981_30007 = state_29969__$1;
(statearr_29981_30007[(1)] = (8));

} else {
var statearr_29982_30008 = state_29969__$1;
(statearr_29982_30008[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (14))){
var inst_29963 = (state_29969[(2)]);
var state_29969__$1 = state_29969;
var statearr_29983_30009 = state_29969__$1;
(statearr_29983_30009[(2)] = inst_29963);

(statearr_29983_30009[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (10))){
var inst_29955 = (state_29969[(2)]);
var state_29969__$1 = state_29969;
var statearr_29984_30010 = state_29969__$1;
(statearr_29984_30010[(2)] = inst_29955);

(statearr_29984_30010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (8))){
var inst_29952 = cljs.core.async.close_BANG_.call(null,to);
var state_29969__$1 = state_29969;
var statearr_29985_30011 = state_29969__$1;
(statearr_29985_30011[(2)] = inst_29952);

(statearr_29985_30011[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___29997))
;
return ((function (switch__29702__auto__,c__29816__auto___29997){
return (function() {
var cljs$core$async$state_machine__29703__auto__ = null;
var cljs$core$async$state_machine__29703__auto____0 = (function (){
var statearr_29989 = [null,null,null,null,null,null,null,null];
(statearr_29989[(0)] = cljs$core$async$state_machine__29703__auto__);

(statearr_29989[(1)] = (1));

return statearr_29989;
});
var cljs$core$async$state_machine__29703__auto____1 = (function (state_29969){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_29969);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e29990){if((e29990 instanceof Object)){
var ex__29706__auto__ = e29990;
var statearr_29991_30012 = state_29969;
(statearr_29991_30012[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29969);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29990;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30013 = state_29969;
state_29969 = G__30013;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$state_machine__29703__auto__ = function(state_29969){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29703__auto____1.call(this,state_29969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29703__auto____0;
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29703__auto____1;
return cljs$core$async$state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___29997))
})();
var state__29818__auto__ = (function (){var statearr_29992 = f__29817__auto__.call(null);
(statearr_29992[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___29997);

return statearr_29992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___29997))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__30201){
var vec__30202 = p__30201;
var v = cljs.core.nth.call(null,vec__30202,(0),null);
var p = cljs.core.nth.call(null,vec__30202,(1),null);
var job = vec__30202;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__29816__auto___30388 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___30388,res,vec__30202,v,p,job,jobs,results){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___30388,res,vec__30202,v,p,job,jobs,results){
return (function (state_30209){
var state_val_30210 = (state_30209[(1)]);
if((state_val_30210 === (1))){
var state_30209__$1 = state_30209;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30209__$1,(2),res,v);
} else {
if((state_val_30210 === (2))){
var inst_30206 = (state_30209[(2)]);
var inst_30207 = cljs.core.async.close_BANG_.call(null,res);
var state_30209__$1 = (function (){var statearr_30211 = state_30209;
(statearr_30211[(7)] = inst_30206);

return statearr_30211;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30209__$1,inst_30207);
} else {
return null;
}
}
});})(c__29816__auto___30388,res,vec__30202,v,p,job,jobs,results))
;
return ((function (switch__29702__auto__,c__29816__auto___30388,res,vec__30202,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0 = (function (){
var statearr_30215 = [null,null,null,null,null,null,null,null];
(statearr_30215[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__);

(statearr_30215[(1)] = (1));

return statearr_30215;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1 = (function (state_30209){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_30209);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e30216){if((e30216 instanceof Object)){
var ex__29706__auto__ = e30216;
var statearr_30217_30389 = state_30209;
(statearr_30217_30389[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30209);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30216;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30390 = state_30209;
state_30209 = G__30390;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__ = function(state_30209){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1.call(this,state_30209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___30388,res,vec__30202,v,p,job,jobs,results))
})();
var state__29818__auto__ = (function (){var statearr_30218 = f__29817__auto__.call(null);
(statearr_30218[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___30388);

return statearr_30218;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___30388,res,vec__30202,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__30219){
var vec__30220 = p__30219;
var v = cljs.core.nth.call(null,vec__30220,(0),null);
var p = cljs.core.nth.call(null,vec__30220,(1),null);
var job = vec__30220;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__27591__auto___30391 = n;
var __30392 = (0);
while(true){
if((__30392 < n__27591__auto___30391)){
var G__30223_30393 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__30223_30393) {
case "compute":
var c__29816__auto___30395 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30392,c__29816__auto___30395,G__30223_30393,n__27591__auto___30391,jobs,results,process,async){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (__30392,c__29816__auto___30395,G__30223_30393,n__27591__auto___30391,jobs,results,process,async){
return (function (state_30236){
var state_val_30237 = (state_30236[(1)]);
if((state_val_30237 === (1))){
var state_30236__$1 = state_30236;
var statearr_30238_30396 = state_30236__$1;
(statearr_30238_30396[(2)] = null);

(statearr_30238_30396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30237 === (2))){
var state_30236__$1 = state_30236;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30236__$1,(4),jobs);
} else {
if((state_val_30237 === (3))){
var inst_30234 = (state_30236[(2)]);
var state_30236__$1 = state_30236;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30236__$1,inst_30234);
} else {
if((state_val_30237 === (4))){
var inst_30226 = (state_30236[(2)]);
var inst_30227 = process.call(null,inst_30226);
var state_30236__$1 = state_30236;
if(cljs.core.truth_(inst_30227)){
var statearr_30239_30397 = state_30236__$1;
(statearr_30239_30397[(1)] = (5));

} else {
var statearr_30240_30398 = state_30236__$1;
(statearr_30240_30398[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30237 === (5))){
var state_30236__$1 = state_30236;
var statearr_30241_30399 = state_30236__$1;
(statearr_30241_30399[(2)] = null);

(statearr_30241_30399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30237 === (6))){
var state_30236__$1 = state_30236;
var statearr_30242_30400 = state_30236__$1;
(statearr_30242_30400[(2)] = null);

(statearr_30242_30400[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30237 === (7))){
var inst_30232 = (state_30236[(2)]);
var state_30236__$1 = state_30236;
var statearr_30243_30401 = state_30236__$1;
(statearr_30243_30401[(2)] = inst_30232);

(statearr_30243_30401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30392,c__29816__auto___30395,G__30223_30393,n__27591__auto___30391,jobs,results,process,async))
;
return ((function (__30392,switch__29702__auto__,c__29816__auto___30395,G__30223_30393,n__27591__auto___30391,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0 = (function (){
var statearr_30247 = [null,null,null,null,null,null,null];
(statearr_30247[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__);

(statearr_30247[(1)] = (1));

return statearr_30247;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1 = (function (state_30236){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_30236);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e30248){if((e30248 instanceof Object)){
var ex__29706__auto__ = e30248;
var statearr_30249_30402 = state_30236;
(statearr_30249_30402[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30236);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30248;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30403 = state_30236;
state_30236 = G__30403;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__ = function(state_30236){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1.call(this,state_30236);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__;
})()
;})(__30392,switch__29702__auto__,c__29816__auto___30395,G__30223_30393,n__27591__auto___30391,jobs,results,process,async))
})();
var state__29818__auto__ = (function (){var statearr_30250 = f__29817__auto__.call(null);
(statearr_30250[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___30395);

return statearr_30250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(__30392,c__29816__auto___30395,G__30223_30393,n__27591__auto___30391,jobs,results,process,async))
);


break;
case "async":
var c__29816__auto___30404 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30392,c__29816__auto___30404,G__30223_30393,n__27591__auto___30391,jobs,results,process,async){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (__30392,c__29816__auto___30404,G__30223_30393,n__27591__auto___30391,jobs,results,process,async){
return (function (state_30263){
var state_val_30264 = (state_30263[(1)]);
if((state_val_30264 === (1))){
var state_30263__$1 = state_30263;
var statearr_30265_30405 = state_30263__$1;
(statearr_30265_30405[(2)] = null);

(statearr_30265_30405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30264 === (2))){
var state_30263__$1 = state_30263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30263__$1,(4),jobs);
} else {
if((state_val_30264 === (3))){
var inst_30261 = (state_30263[(2)]);
var state_30263__$1 = state_30263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30263__$1,inst_30261);
} else {
if((state_val_30264 === (4))){
var inst_30253 = (state_30263[(2)]);
var inst_30254 = async.call(null,inst_30253);
var state_30263__$1 = state_30263;
if(cljs.core.truth_(inst_30254)){
var statearr_30266_30406 = state_30263__$1;
(statearr_30266_30406[(1)] = (5));

} else {
var statearr_30267_30407 = state_30263__$1;
(statearr_30267_30407[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30264 === (5))){
var state_30263__$1 = state_30263;
var statearr_30268_30408 = state_30263__$1;
(statearr_30268_30408[(2)] = null);

(statearr_30268_30408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30264 === (6))){
var state_30263__$1 = state_30263;
var statearr_30269_30409 = state_30263__$1;
(statearr_30269_30409[(2)] = null);

(statearr_30269_30409[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30264 === (7))){
var inst_30259 = (state_30263[(2)]);
var state_30263__$1 = state_30263;
var statearr_30270_30410 = state_30263__$1;
(statearr_30270_30410[(2)] = inst_30259);

(statearr_30270_30410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30392,c__29816__auto___30404,G__30223_30393,n__27591__auto___30391,jobs,results,process,async))
;
return ((function (__30392,switch__29702__auto__,c__29816__auto___30404,G__30223_30393,n__27591__auto___30391,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0 = (function (){
var statearr_30274 = [null,null,null,null,null,null,null];
(statearr_30274[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__);

(statearr_30274[(1)] = (1));

return statearr_30274;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1 = (function (state_30263){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_30263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e30275){if((e30275 instanceof Object)){
var ex__29706__auto__ = e30275;
var statearr_30276_30411 = state_30263;
(statearr_30276_30411[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30263);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30275;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30412 = state_30263;
state_30263 = G__30412;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__ = function(state_30263){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1.call(this,state_30263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__;
})()
;})(__30392,switch__29702__auto__,c__29816__auto___30404,G__30223_30393,n__27591__auto___30391,jobs,results,process,async))
})();
var state__29818__auto__ = (function (){var statearr_30277 = f__29817__auto__.call(null);
(statearr_30277[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___30404);

return statearr_30277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(__30392,c__29816__auto___30404,G__30223_30393,n__27591__auto___30391,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__30413 = (__30392 + (1));
__30392 = G__30413;
continue;
} else {
}
break;
}

var c__29816__auto___30414 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___30414,jobs,results,process,async){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___30414,jobs,results,process,async){
return (function (state_30299){
var state_val_30300 = (state_30299[(1)]);
if((state_val_30300 === (1))){
var state_30299__$1 = state_30299;
var statearr_30301_30415 = state_30299__$1;
(statearr_30301_30415[(2)] = null);

(statearr_30301_30415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (2))){
var state_30299__$1 = state_30299;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30299__$1,(4),from);
} else {
if((state_val_30300 === (3))){
var inst_30297 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30299__$1,inst_30297);
} else {
if((state_val_30300 === (4))){
var inst_30280 = (state_30299[(7)]);
var inst_30280__$1 = (state_30299[(2)]);
var inst_30281 = (inst_30280__$1 == null);
var state_30299__$1 = (function (){var statearr_30302 = state_30299;
(statearr_30302[(7)] = inst_30280__$1);

return statearr_30302;
})();
if(cljs.core.truth_(inst_30281)){
var statearr_30303_30416 = state_30299__$1;
(statearr_30303_30416[(1)] = (5));

} else {
var statearr_30304_30417 = state_30299__$1;
(statearr_30304_30417[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (5))){
var inst_30283 = cljs.core.async.close_BANG_.call(null,jobs);
var state_30299__$1 = state_30299;
var statearr_30305_30418 = state_30299__$1;
(statearr_30305_30418[(2)] = inst_30283);

(statearr_30305_30418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (6))){
var inst_30285 = (state_30299[(8)]);
var inst_30280 = (state_30299[(7)]);
var inst_30285__$1 = cljs.core.async.chan.call(null,(1));
var inst_30286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30287 = [inst_30280,inst_30285__$1];
var inst_30288 = (new cljs.core.PersistentVector(null,2,(5),inst_30286,inst_30287,null));
var state_30299__$1 = (function (){var statearr_30306 = state_30299;
(statearr_30306[(8)] = inst_30285__$1);

return statearr_30306;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30299__$1,(8),jobs,inst_30288);
} else {
if((state_val_30300 === (7))){
var inst_30295 = (state_30299[(2)]);
var state_30299__$1 = state_30299;
var statearr_30307_30419 = state_30299__$1;
(statearr_30307_30419[(2)] = inst_30295);

(statearr_30307_30419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30300 === (8))){
var inst_30285 = (state_30299[(8)]);
var inst_30290 = (state_30299[(2)]);
var state_30299__$1 = (function (){var statearr_30308 = state_30299;
(statearr_30308[(9)] = inst_30290);

return statearr_30308;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30299__$1,(9),results,inst_30285);
} else {
if((state_val_30300 === (9))){
var inst_30292 = (state_30299[(2)]);
var state_30299__$1 = (function (){var statearr_30309 = state_30299;
(statearr_30309[(10)] = inst_30292);

return statearr_30309;
})();
var statearr_30310_30420 = state_30299__$1;
(statearr_30310_30420[(2)] = null);

(statearr_30310_30420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___30414,jobs,results,process,async))
;
return ((function (switch__29702__auto__,c__29816__auto___30414,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0 = (function (){
var statearr_30314 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30314[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__);

(statearr_30314[(1)] = (1));

return statearr_30314;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1 = (function (state_30299){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_30299);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e30315){if((e30315 instanceof Object)){
var ex__29706__auto__ = e30315;
var statearr_30316_30421 = state_30299;
(statearr_30316_30421[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30299);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30315;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30422 = state_30299;
state_30299 = G__30422;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__ = function(state_30299){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1.call(this,state_30299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___30414,jobs,results,process,async))
})();
var state__29818__auto__ = (function (){var statearr_30317 = f__29817__auto__.call(null);
(statearr_30317[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___30414);

return statearr_30317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___30414,jobs,results,process,async))
);


var c__29816__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto__,jobs,results,process,async){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto__,jobs,results,process,async){
return (function (state_30355){
var state_val_30356 = (state_30355[(1)]);
if((state_val_30356 === (7))){
var inst_30351 = (state_30355[(2)]);
var state_30355__$1 = state_30355;
var statearr_30357_30423 = state_30355__$1;
(statearr_30357_30423[(2)] = inst_30351);

(statearr_30357_30423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (20))){
var state_30355__$1 = state_30355;
var statearr_30358_30424 = state_30355__$1;
(statearr_30358_30424[(2)] = null);

(statearr_30358_30424[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (1))){
var state_30355__$1 = state_30355;
var statearr_30359_30425 = state_30355__$1;
(statearr_30359_30425[(2)] = null);

(statearr_30359_30425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (4))){
var inst_30320 = (state_30355[(7)]);
var inst_30320__$1 = (state_30355[(2)]);
var inst_30321 = (inst_30320__$1 == null);
var state_30355__$1 = (function (){var statearr_30360 = state_30355;
(statearr_30360[(7)] = inst_30320__$1);

return statearr_30360;
})();
if(cljs.core.truth_(inst_30321)){
var statearr_30361_30426 = state_30355__$1;
(statearr_30361_30426[(1)] = (5));

} else {
var statearr_30362_30427 = state_30355__$1;
(statearr_30362_30427[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (15))){
var inst_30333 = (state_30355[(8)]);
var state_30355__$1 = state_30355;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30355__$1,(18),to,inst_30333);
} else {
if((state_val_30356 === (21))){
var inst_30346 = (state_30355[(2)]);
var state_30355__$1 = state_30355;
var statearr_30363_30428 = state_30355__$1;
(statearr_30363_30428[(2)] = inst_30346);

(statearr_30363_30428[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (13))){
var inst_30348 = (state_30355[(2)]);
var state_30355__$1 = (function (){var statearr_30364 = state_30355;
(statearr_30364[(9)] = inst_30348);

return statearr_30364;
})();
var statearr_30365_30429 = state_30355__$1;
(statearr_30365_30429[(2)] = null);

(statearr_30365_30429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (6))){
var inst_30320 = (state_30355[(7)]);
var state_30355__$1 = state_30355;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30355__$1,(11),inst_30320);
} else {
if((state_val_30356 === (17))){
var inst_30341 = (state_30355[(2)]);
var state_30355__$1 = state_30355;
if(cljs.core.truth_(inst_30341)){
var statearr_30366_30430 = state_30355__$1;
(statearr_30366_30430[(1)] = (19));

} else {
var statearr_30367_30431 = state_30355__$1;
(statearr_30367_30431[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (3))){
var inst_30353 = (state_30355[(2)]);
var state_30355__$1 = state_30355;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30355__$1,inst_30353);
} else {
if((state_val_30356 === (12))){
var inst_30330 = (state_30355[(10)]);
var state_30355__$1 = state_30355;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30355__$1,(14),inst_30330);
} else {
if((state_val_30356 === (2))){
var state_30355__$1 = state_30355;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30355__$1,(4),results);
} else {
if((state_val_30356 === (19))){
var state_30355__$1 = state_30355;
var statearr_30368_30432 = state_30355__$1;
(statearr_30368_30432[(2)] = null);

(statearr_30368_30432[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (11))){
var inst_30330 = (state_30355[(2)]);
var state_30355__$1 = (function (){var statearr_30369 = state_30355;
(statearr_30369[(10)] = inst_30330);

return statearr_30369;
})();
var statearr_30370_30433 = state_30355__$1;
(statearr_30370_30433[(2)] = null);

(statearr_30370_30433[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (9))){
var state_30355__$1 = state_30355;
var statearr_30371_30434 = state_30355__$1;
(statearr_30371_30434[(2)] = null);

(statearr_30371_30434[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (5))){
var state_30355__$1 = state_30355;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30372_30435 = state_30355__$1;
(statearr_30372_30435[(1)] = (8));

} else {
var statearr_30373_30436 = state_30355__$1;
(statearr_30373_30436[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (14))){
var inst_30335 = (state_30355[(11)]);
var inst_30333 = (state_30355[(8)]);
var inst_30333__$1 = (state_30355[(2)]);
var inst_30334 = (inst_30333__$1 == null);
var inst_30335__$1 = cljs.core.not.call(null,inst_30334);
var state_30355__$1 = (function (){var statearr_30374 = state_30355;
(statearr_30374[(11)] = inst_30335__$1);

(statearr_30374[(8)] = inst_30333__$1);

return statearr_30374;
})();
if(inst_30335__$1){
var statearr_30375_30437 = state_30355__$1;
(statearr_30375_30437[(1)] = (15));

} else {
var statearr_30376_30438 = state_30355__$1;
(statearr_30376_30438[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (16))){
var inst_30335 = (state_30355[(11)]);
var state_30355__$1 = state_30355;
var statearr_30377_30439 = state_30355__$1;
(statearr_30377_30439[(2)] = inst_30335);

(statearr_30377_30439[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (10))){
var inst_30327 = (state_30355[(2)]);
var state_30355__$1 = state_30355;
var statearr_30378_30440 = state_30355__$1;
(statearr_30378_30440[(2)] = inst_30327);

(statearr_30378_30440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (18))){
var inst_30338 = (state_30355[(2)]);
var state_30355__$1 = state_30355;
var statearr_30379_30441 = state_30355__$1;
(statearr_30379_30441[(2)] = inst_30338);

(statearr_30379_30441[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30356 === (8))){
var inst_30324 = cljs.core.async.close_BANG_.call(null,to);
var state_30355__$1 = state_30355;
var statearr_30380_30442 = state_30355__$1;
(statearr_30380_30442[(2)] = inst_30324);

(statearr_30380_30442[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto__,jobs,results,process,async))
;
return ((function (switch__29702__auto__,c__29816__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0 = (function (){
var statearr_30384 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30384[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__);

(statearr_30384[(1)] = (1));

return statearr_30384;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1 = (function (state_30355){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_30355);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e30385){if((e30385 instanceof Object)){
var ex__29706__auto__ = e30385;
var statearr_30386_30443 = state_30355;
(statearr_30386_30443[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30355);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30385;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30444 = state_30355;
state_30355 = G__30444;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__ = function(state_30355){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1.call(this,state_30355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29703__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto__,jobs,results,process,async))
})();
var state__29818__auto__ = (function (){var statearr_30387 = f__29817__auto__.call(null);
(statearr_30387[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto__);

return statearr_30387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto__,jobs,results,process,async))
);

return c__29816__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args30445 = [];
var len__27761__auto___30448 = arguments.length;
var i__27762__auto___30449 = (0);
while(true){
if((i__27762__auto___30449 < len__27761__auto___30448)){
args30445.push((arguments[i__27762__auto___30449]));

var G__30450 = (i__27762__auto___30449 + (1));
i__27762__auto___30449 = G__30450;
continue;
} else {
}
break;
}

var G__30447 = args30445.length;
switch (G__30447) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30445.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args30452 = [];
var len__27761__auto___30455 = arguments.length;
var i__27762__auto___30456 = (0);
while(true){
if((i__27762__auto___30456 < len__27761__auto___30455)){
args30452.push((arguments[i__27762__auto___30456]));

var G__30457 = (i__27762__auto___30456 + (1));
i__27762__auto___30456 = G__30457;
continue;
} else {
}
break;
}

var G__30454 = args30452.length;
switch (G__30454) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30452.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args30459 = [];
var len__27761__auto___30512 = arguments.length;
var i__27762__auto___30513 = (0);
while(true){
if((i__27762__auto___30513 < len__27761__auto___30512)){
args30459.push((arguments[i__27762__auto___30513]));

var G__30514 = (i__27762__auto___30513 + (1));
i__27762__auto___30513 = G__30514;
continue;
} else {
}
break;
}

var G__30461 = args30459.length;
switch (G__30461) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30459.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__29816__auto___30516 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___30516,tc,fc){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___30516,tc,fc){
return (function (state_30487){
var state_val_30488 = (state_30487[(1)]);
if((state_val_30488 === (7))){
var inst_30483 = (state_30487[(2)]);
var state_30487__$1 = state_30487;
var statearr_30489_30517 = state_30487__$1;
(statearr_30489_30517[(2)] = inst_30483);

(statearr_30489_30517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30488 === (1))){
var state_30487__$1 = state_30487;
var statearr_30490_30518 = state_30487__$1;
(statearr_30490_30518[(2)] = null);

(statearr_30490_30518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30488 === (4))){
var inst_30464 = (state_30487[(7)]);
var inst_30464__$1 = (state_30487[(2)]);
var inst_30465 = (inst_30464__$1 == null);
var state_30487__$1 = (function (){var statearr_30491 = state_30487;
(statearr_30491[(7)] = inst_30464__$1);

return statearr_30491;
})();
if(cljs.core.truth_(inst_30465)){
var statearr_30492_30519 = state_30487__$1;
(statearr_30492_30519[(1)] = (5));

} else {
var statearr_30493_30520 = state_30487__$1;
(statearr_30493_30520[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30488 === (13))){
var state_30487__$1 = state_30487;
var statearr_30494_30521 = state_30487__$1;
(statearr_30494_30521[(2)] = null);

(statearr_30494_30521[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30488 === (6))){
var inst_30464 = (state_30487[(7)]);
var inst_30470 = p.call(null,inst_30464);
var state_30487__$1 = state_30487;
if(cljs.core.truth_(inst_30470)){
var statearr_30495_30522 = state_30487__$1;
(statearr_30495_30522[(1)] = (9));

} else {
var statearr_30496_30523 = state_30487__$1;
(statearr_30496_30523[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30488 === (3))){
var inst_30485 = (state_30487[(2)]);
var state_30487__$1 = state_30487;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30487__$1,inst_30485);
} else {
if((state_val_30488 === (12))){
var state_30487__$1 = state_30487;
var statearr_30497_30524 = state_30487__$1;
(statearr_30497_30524[(2)] = null);

(statearr_30497_30524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30488 === (2))){
var state_30487__$1 = state_30487;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30487__$1,(4),ch);
} else {
if((state_val_30488 === (11))){
var inst_30464 = (state_30487[(7)]);
var inst_30474 = (state_30487[(2)]);
var state_30487__$1 = state_30487;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30487__$1,(8),inst_30474,inst_30464);
} else {
if((state_val_30488 === (9))){
var state_30487__$1 = state_30487;
var statearr_30498_30525 = state_30487__$1;
(statearr_30498_30525[(2)] = tc);

(statearr_30498_30525[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30488 === (5))){
var inst_30467 = cljs.core.async.close_BANG_.call(null,tc);
var inst_30468 = cljs.core.async.close_BANG_.call(null,fc);
var state_30487__$1 = (function (){var statearr_30499 = state_30487;
(statearr_30499[(8)] = inst_30467);

return statearr_30499;
})();
var statearr_30500_30526 = state_30487__$1;
(statearr_30500_30526[(2)] = inst_30468);

(statearr_30500_30526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30488 === (14))){
var inst_30481 = (state_30487[(2)]);
var state_30487__$1 = state_30487;
var statearr_30501_30527 = state_30487__$1;
(statearr_30501_30527[(2)] = inst_30481);

(statearr_30501_30527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30488 === (10))){
var state_30487__$1 = state_30487;
var statearr_30502_30528 = state_30487__$1;
(statearr_30502_30528[(2)] = fc);

(statearr_30502_30528[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30488 === (8))){
var inst_30476 = (state_30487[(2)]);
var state_30487__$1 = state_30487;
if(cljs.core.truth_(inst_30476)){
var statearr_30503_30529 = state_30487__$1;
(statearr_30503_30529[(1)] = (12));

} else {
var statearr_30504_30530 = state_30487__$1;
(statearr_30504_30530[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___30516,tc,fc))
;
return ((function (switch__29702__auto__,c__29816__auto___30516,tc,fc){
return (function() {
var cljs$core$async$state_machine__29703__auto__ = null;
var cljs$core$async$state_machine__29703__auto____0 = (function (){
var statearr_30508 = [null,null,null,null,null,null,null,null,null];
(statearr_30508[(0)] = cljs$core$async$state_machine__29703__auto__);

(statearr_30508[(1)] = (1));

return statearr_30508;
});
var cljs$core$async$state_machine__29703__auto____1 = (function (state_30487){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_30487);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e30509){if((e30509 instanceof Object)){
var ex__29706__auto__ = e30509;
var statearr_30510_30531 = state_30487;
(statearr_30510_30531[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30487);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30509;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30532 = state_30487;
state_30487 = G__30532;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$state_machine__29703__auto__ = function(state_30487){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29703__auto____1.call(this,state_30487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29703__auto____0;
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29703__auto____1;
return cljs$core$async$state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___30516,tc,fc))
})();
var state__29818__auto__ = (function (){var statearr_30511 = f__29817__auto__.call(null);
(statearr_30511[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___30516);

return statearr_30511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___30516,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__29816__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto__){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto__){
return (function (state_30596){
var state_val_30597 = (state_30596[(1)]);
if((state_val_30597 === (7))){
var inst_30592 = (state_30596[(2)]);
var state_30596__$1 = state_30596;
var statearr_30598_30619 = state_30596__$1;
(statearr_30598_30619[(2)] = inst_30592);

(statearr_30598_30619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30597 === (1))){
var inst_30576 = init;
var state_30596__$1 = (function (){var statearr_30599 = state_30596;
(statearr_30599[(7)] = inst_30576);

return statearr_30599;
})();
var statearr_30600_30620 = state_30596__$1;
(statearr_30600_30620[(2)] = null);

(statearr_30600_30620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30597 === (4))){
var inst_30579 = (state_30596[(8)]);
var inst_30579__$1 = (state_30596[(2)]);
var inst_30580 = (inst_30579__$1 == null);
var state_30596__$1 = (function (){var statearr_30601 = state_30596;
(statearr_30601[(8)] = inst_30579__$1);

return statearr_30601;
})();
if(cljs.core.truth_(inst_30580)){
var statearr_30602_30621 = state_30596__$1;
(statearr_30602_30621[(1)] = (5));

} else {
var statearr_30603_30622 = state_30596__$1;
(statearr_30603_30622[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30597 === (6))){
var inst_30583 = (state_30596[(9)]);
var inst_30579 = (state_30596[(8)]);
var inst_30576 = (state_30596[(7)]);
var inst_30583__$1 = f.call(null,inst_30576,inst_30579);
var inst_30584 = cljs.core.reduced_QMARK_.call(null,inst_30583__$1);
var state_30596__$1 = (function (){var statearr_30604 = state_30596;
(statearr_30604[(9)] = inst_30583__$1);

return statearr_30604;
})();
if(inst_30584){
var statearr_30605_30623 = state_30596__$1;
(statearr_30605_30623[(1)] = (8));

} else {
var statearr_30606_30624 = state_30596__$1;
(statearr_30606_30624[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30597 === (3))){
var inst_30594 = (state_30596[(2)]);
var state_30596__$1 = state_30596;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30596__$1,inst_30594);
} else {
if((state_val_30597 === (2))){
var state_30596__$1 = state_30596;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30596__$1,(4),ch);
} else {
if((state_val_30597 === (9))){
var inst_30583 = (state_30596[(9)]);
var inst_30576 = inst_30583;
var state_30596__$1 = (function (){var statearr_30607 = state_30596;
(statearr_30607[(7)] = inst_30576);

return statearr_30607;
})();
var statearr_30608_30625 = state_30596__$1;
(statearr_30608_30625[(2)] = null);

(statearr_30608_30625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30597 === (5))){
var inst_30576 = (state_30596[(7)]);
var state_30596__$1 = state_30596;
var statearr_30609_30626 = state_30596__$1;
(statearr_30609_30626[(2)] = inst_30576);

(statearr_30609_30626[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30597 === (10))){
var inst_30590 = (state_30596[(2)]);
var state_30596__$1 = state_30596;
var statearr_30610_30627 = state_30596__$1;
(statearr_30610_30627[(2)] = inst_30590);

(statearr_30610_30627[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30597 === (8))){
var inst_30583 = (state_30596[(9)]);
var inst_30586 = cljs.core.deref.call(null,inst_30583);
var state_30596__$1 = state_30596;
var statearr_30611_30628 = state_30596__$1;
(statearr_30611_30628[(2)] = inst_30586);

(statearr_30611_30628[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto__))
;
return ((function (switch__29702__auto__,c__29816__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__29703__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29703__auto____0 = (function (){
var statearr_30615 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30615[(0)] = cljs$core$async$reduce_$_state_machine__29703__auto__);

(statearr_30615[(1)] = (1));

return statearr_30615;
});
var cljs$core$async$reduce_$_state_machine__29703__auto____1 = (function (state_30596){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_30596);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e30616){if((e30616 instanceof Object)){
var ex__29706__auto__ = e30616;
var statearr_30617_30629 = state_30596;
(statearr_30617_30629[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30596);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30616;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30630 = state_30596;
state_30596 = G__30630;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29703__auto__ = function(state_30596){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29703__auto____1.call(this,state_30596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29703__auto____0;
cljs$core$async$reduce_$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29703__auto____1;
return cljs$core$async$reduce_$_state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto__))
})();
var state__29818__auto__ = (function (){var statearr_30618 = f__29817__auto__.call(null);
(statearr_30618[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto__);

return statearr_30618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto__))
);

return c__29816__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args30631 = [];
var len__27761__auto___30683 = arguments.length;
var i__27762__auto___30684 = (0);
while(true){
if((i__27762__auto___30684 < len__27761__auto___30683)){
args30631.push((arguments[i__27762__auto___30684]));

var G__30685 = (i__27762__auto___30684 + (1));
i__27762__auto___30684 = G__30685;
continue;
} else {
}
break;
}

var G__30633 = args30631.length;
switch (G__30633) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30631.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__29816__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto__){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto__){
return (function (state_30658){
var state_val_30659 = (state_30658[(1)]);
if((state_val_30659 === (7))){
var inst_30640 = (state_30658[(2)]);
var state_30658__$1 = state_30658;
var statearr_30660_30687 = state_30658__$1;
(statearr_30660_30687[(2)] = inst_30640);

(statearr_30660_30687[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30659 === (1))){
var inst_30634 = cljs.core.seq.call(null,coll);
var inst_30635 = inst_30634;
var state_30658__$1 = (function (){var statearr_30661 = state_30658;
(statearr_30661[(7)] = inst_30635);

return statearr_30661;
})();
var statearr_30662_30688 = state_30658__$1;
(statearr_30662_30688[(2)] = null);

(statearr_30662_30688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30659 === (4))){
var inst_30635 = (state_30658[(7)]);
var inst_30638 = cljs.core.first.call(null,inst_30635);
var state_30658__$1 = state_30658;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30658__$1,(7),ch,inst_30638);
} else {
if((state_val_30659 === (13))){
var inst_30652 = (state_30658[(2)]);
var state_30658__$1 = state_30658;
var statearr_30663_30689 = state_30658__$1;
(statearr_30663_30689[(2)] = inst_30652);

(statearr_30663_30689[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30659 === (6))){
var inst_30643 = (state_30658[(2)]);
var state_30658__$1 = state_30658;
if(cljs.core.truth_(inst_30643)){
var statearr_30664_30690 = state_30658__$1;
(statearr_30664_30690[(1)] = (8));

} else {
var statearr_30665_30691 = state_30658__$1;
(statearr_30665_30691[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30659 === (3))){
var inst_30656 = (state_30658[(2)]);
var state_30658__$1 = state_30658;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30658__$1,inst_30656);
} else {
if((state_val_30659 === (12))){
var state_30658__$1 = state_30658;
var statearr_30666_30692 = state_30658__$1;
(statearr_30666_30692[(2)] = null);

(statearr_30666_30692[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30659 === (2))){
var inst_30635 = (state_30658[(7)]);
var state_30658__$1 = state_30658;
if(cljs.core.truth_(inst_30635)){
var statearr_30667_30693 = state_30658__$1;
(statearr_30667_30693[(1)] = (4));

} else {
var statearr_30668_30694 = state_30658__$1;
(statearr_30668_30694[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30659 === (11))){
var inst_30649 = cljs.core.async.close_BANG_.call(null,ch);
var state_30658__$1 = state_30658;
var statearr_30669_30695 = state_30658__$1;
(statearr_30669_30695[(2)] = inst_30649);

(statearr_30669_30695[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30659 === (9))){
var state_30658__$1 = state_30658;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30670_30696 = state_30658__$1;
(statearr_30670_30696[(1)] = (11));

} else {
var statearr_30671_30697 = state_30658__$1;
(statearr_30671_30697[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30659 === (5))){
var inst_30635 = (state_30658[(7)]);
var state_30658__$1 = state_30658;
var statearr_30672_30698 = state_30658__$1;
(statearr_30672_30698[(2)] = inst_30635);

(statearr_30672_30698[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30659 === (10))){
var inst_30654 = (state_30658[(2)]);
var state_30658__$1 = state_30658;
var statearr_30673_30699 = state_30658__$1;
(statearr_30673_30699[(2)] = inst_30654);

(statearr_30673_30699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30659 === (8))){
var inst_30635 = (state_30658[(7)]);
var inst_30645 = cljs.core.next.call(null,inst_30635);
var inst_30635__$1 = inst_30645;
var state_30658__$1 = (function (){var statearr_30674 = state_30658;
(statearr_30674[(7)] = inst_30635__$1);

return statearr_30674;
})();
var statearr_30675_30700 = state_30658__$1;
(statearr_30675_30700[(2)] = null);

(statearr_30675_30700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto__))
;
return ((function (switch__29702__auto__,c__29816__auto__){
return (function() {
var cljs$core$async$state_machine__29703__auto__ = null;
var cljs$core$async$state_machine__29703__auto____0 = (function (){
var statearr_30679 = [null,null,null,null,null,null,null,null];
(statearr_30679[(0)] = cljs$core$async$state_machine__29703__auto__);

(statearr_30679[(1)] = (1));

return statearr_30679;
});
var cljs$core$async$state_machine__29703__auto____1 = (function (state_30658){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_30658);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e30680){if((e30680 instanceof Object)){
var ex__29706__auto__ = e30680;
var statearr_30681_30701 = state_30658;
(statearr_30681_30701[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30658);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30680;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30702 = state_30658;
state_30658 = G__30702;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$state_machine__29703__auto__ = function(state_30658){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29703__auto____1.call(this,state_30658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29703__auto____0;
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29703__auto____1;
return cljs$core$async$state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto__))
})();
var state__29818__auto__ = (function (){var statearr_30682 = f__29817__auto__.call(null);
(statearr_30682[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto__);

return statearr_30682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto__))
);

return c__29816__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27291__auto__ = (((_ == null))?null:_);
var m__27292__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,_);
} else {
var m__27292__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27291__auto__ = (((m == null))?null:m);
var m__27292__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27292__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27291__auto__ = (((m == null))?null:m);
var m__27292__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,m,ch);
} else {
var m__27292__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27291__auto__ = (((m == null))?null:m);
var m__27292__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,m);
} else {
var m__27292__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async30928 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30928 = (function (mult,ch,cs,meta30929){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta30929 = meta30929;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30928.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30930,meta30929__$1){
var self__ = this;
var _30930__$1 = this;
return (new cljs.core.async.t_cljs$core$async30928(self__.mult,self__.ch,self__.cs,meta30929__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async30928.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30930){
var self__ = this;
var _30930__$1 = this;
return self__.meta30929;
});})(cs))
;

cljs.core.async.t_cljs$core$async30928.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async30928.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async30928.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async30928.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30928.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30928.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30928.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30929","meta30929",1146904490,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async30928.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30928.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30928";

cljs.core.async.t_cljs$core$async30928.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27230__auto__,writer__27231__auto__,opt__27232__auto__){
return cljs.core._write.call(null,writer__27231__auto__,"cljs.core.async/t_cljs$core$async30928");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async30928 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async30928(mult__$1,ch__$1,cs__$1,meta30929){
return (new cljs.core.async.t_cljs$core$async30928(mult__$1,ch__$1,cs__$1,meta30929));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async30928(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__29816__auto___31153 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___31153,cs,m,dchan,dctr,done){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___31153,cs,m,dchan,dctr,done){
return (function (state_31065){
var state_val_31066 = (state_31065[(1)]);
if((state_val_31066 === (7))){
var inst_31061 = (state_31065[(2)]);
var state_31065__$1 = state_31065;
var statearr_31067_31154 = state_31065__$1;
(statearr_31067_31154[(2)] = inst_31061);

(statearr_31067_31154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (20))){
var inst_30964 = (state_31065[(7)]);
var inst_30976 = cljs.core.first.call(null,inst_30964);
var inst_30977 = cljs.core.nth.call(null,inst_30976,(0),null);
var inst_30978 = cljs.core.nth.call(null,inst_30976,(1),null);
var state_31065__$1 = (function (){var statearr_31068 = state_31065;
(statearr_31068[(8)] = inst_30977);

return statearr_31068;
})();
if(cljs.core.truth_(inst_30978)){
var statearr_31069_31155 = state_31065__$1;
(statearr_31069_31155[(1)] = (22));

} else {
var statearr_31070_31156 = state_31065__$1;
(statearr_31070_31156[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (27))){
var inst_30933 = (state_31065[(9)]);
var inst_31013 = (state_31065[(10)]);
var inst_31006 = (state_31065[(11)]);
var inst_31008 = (state_31065[(12)]);
var inst_31013__$1 = cljs.core._nth.call(null,inst_31006,inst_31008);
var inst_31014 = cljs.core.async.put_BANG_.call(null,inst_31013__$1,inst_30933,done);
var state_31065__$1 = (function (){var statearr_31071 = state_31065;
(statearr_31071[(10)] = inst_31013__$1);

return statearr_31071;
})();
if(cljs.core.truth_(inst_31014)){
var statearr_31072_31157 = state_31065__$1;
(statearr_31072_31157[(1)] = (30));

} else {
var statearr_31073_31158 = state_31065__$1;
(statearr_31073_31158[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (1))){
var state_31065__$1 = state_31065;
var statearr_31074_31159 = state_31065__$1;
(statearr_31074_31159[(2)] = null);

(statearr_31074_31159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (24))){
var inst_30964 = (state_31065[(7)]);
var inst_30983 = (state_31065[(2)]);
var inst_30984 = cljs.core.next.call(null,inst_30964);
var inst_30942 = inst_30984;
var inst_30943 = null;
var inst_30944 = (0);
var inst_30945 = (0);
var state_31065__$1 = (function (){var statearr_31075 = state_31065;
(statearr_31075[(13)] = inst_30943);

(statearr_31075[(14)] = inst_30944);

(statearr_31075[(15)] = inst_30983);

(statearr_31075[(16)] = inst_30945);

(statearr_31075[(17)] = inst_30942);

return statearr_31075;
})();
var statearr_31076_31160 = state_31065__$1;
(statearr_31076_31160[(2)] = null);

(statearr_31076_31160[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (39))){
var state_31065__$1 = state_31065;
var statearr_31080_31161 = state_31065__$1;
(statearr_31080_31161[(2)] = null);

(statearr_31080_31161[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (4))){
var inst_30933 = (state_31065[(9)]);
var inst_30933__$1 = (state_31065[(2)]);
var inst_30934 = (inst_30933__$1 == null);
var state_31065__$1 = (function (){var statearr_31081 = state_31065;
(statearr_31081[(9)] = inst_30933__$1);

return statearr_31081;
})();
if(cljs.core.truth_(inst_30934)){
var statearr_31082_31162 = state_31065__$1;
(statearr_31082_31162[(1)] = (5));

} else {
var statearr_31083_31163 = state_31065__$1;
(statearr_31083_31163[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (15))){
var inst_30943 = (state_31065[(13)]);
var inst_30944 = (state_31065[(14)]);
var inst_30945 = (state_31065[(16)]);
var inst_30942 = (state_31065[(17)]);
var inst_30960 = (state_31065[(2)]);
var inst_30961 = (inst_30945 + (1));
var tmp31077 = inst_30943;
var tmp31078 = inst_30944;
var tmp31079 = inst_30942;
var inst_30942__$1 = tmp31079;
var inst_30943__$1 = tmp31077;
var inst_30944__$1 = tmp31078;
var inst_30945__$1 = inst_30961;
var state_31065__$1 = (function (){var statearr_31084 = state_31065;
(statearr_31084[(13)] = inst_30943__$1);

(statearr_31084[(14)] = inst_30944__$1);

(statearr_31084[(16)] = inst_30945__$1);

(statearr_31084[(17)] = inst_30942__$1);

(statearr_31084[(18)] = inst_30960);

return statearr_31084;
})();
var statearr_31085_31164 = state_31065__$1;
(statearr_31085_31164[(2)] = null);

(statearr_31085_31164[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (21))){
var inst_30987 = (state_31065[(2)]);
var state_31065__$1 = state_31065;
var statearr_31089_31165 = state_31065__$1;
(statearr_31089_31165[(2)] = inst_30987);

(statearr_31089_31165[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (31))){
var inst_31013 = (state_31065[(10)]);
var inst_31017 = done.call(null,null);
var inst_31018 = cljs.core.async.untap_STAR_.call(null,m,inst_31013);
var state_31065__$1 = (function (){var statearr_31090 = state_31065;
(statearr_31090[(19)] = inst_31017);

return statearr_31090;
})();
var statearr_31091_31166 = state_31065__$1;
(statearr_31091_31166[(2)] = inst_31018);

(statearr_31091_31166[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (32))){
var inst_31007 = (state_31065[(20)]);
var inst_31005 = (state_31065[(21)]);
var inst_31006 = (state_31065[(11)]);
var inst_31008 = (state_31065[(12)]);
var inst_31020 = (state_31065[(2)]);
var inst_31021 = (inst_31008 + (1));
var tmp31086 = inst_31007;
var tmp31087 = inst_31005;
var tmp31088 = inst_31006;
var inst_31005__$1 = tmp31087;
var inst_31006__$1 = tmp31088;
var inst_31007__$1 = tmp31086;
var inst_31008__$1 = inst_31021;
var state_31065__$1 = (function (){var statearr_31092 = state_31065;
(statearr_31092[(20)] = inst_31007__$1);

(statearr_31092[(21)] = inst_31005__$1);

(statearr_31092[(11)] = inst_31006__$1);

(statearr_31092[(22)] = inst_31020);

(statearr_31092[(12)] = inst_31008__$1);

return statearr_31092;
})();
var statearr_31093_31167 = state_31065__$1;
(statearr_31093_31167[(2)] = null);

(statearr_31093_31167[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (40))){
var inst_31033 = (state_31065[(23)]);
var inst_31037 = done.call(null,null);
var inst_31038 = cljs.core.async.untap_STAR_.call(null,m,inst_31033);
var state_31065__$1 = (function (){var statearr_31094 = state_31065;
(statearr_31094[(24)] = inst_31037);

return statearr_31094;
})();
var statearr_31095_31168 = state_31065__$1;
(statearr_31095_31168[(2)] = inst_31038);

(statearr_31095_31168[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (33))){
var inst_31024 = (state_31065[(25)]);
var inst_31026 = cljs.core.chunked_seq_QMARK_.call(null,inst_31024);
var state_31065__$1 = state_31065;
if(inst_31026){
var statearr_31096_31169 = state_31065__$1;
(statearr_31096_31169[(1)] = (36));

} else {
var statearr_31097_31170 = state_31065__$1;
(statearr_31097_31170[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (13))){
var inst_30954 = (state_31065[(26)]);
var inst_30957 = cljs.core.async.close_BANG_.call(null,inst_30954);
var state_31065__$1 = state_31065;
var statearr_31098_31171 = state_31065__$1;
(statearr_31098_31171[(2)] = inst_30957);

(statearr_31098_31171[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (22))){
var inst_30977 = (state_31065[(8)]);
var inst_30980 = cljs.core.async.close_BANG_.call(null,inst_30977);
var state_31065__$1 = state_31065;
var statearr_31099_31172 = state_31065__$1;
(statearr_31099_31172[(2)] = inst_30980);

(statearr_31099_31172[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (36))){
var inst_31024 = (state_31065[(25)]);
var inst_31028 = cljs.core.chunk_first.call(null,inst_31024);
var inst_31029 = cljs.core.chunk_rest.call(null,inst_31024);
var inst_31030 = cljs.core.count.call(null,inst_31028);
var inst_31005 = inst_31029;
var inst_31006 = inst_31028;
var inst_31007 = inst_31030;
var inst_31008 = (0);
var state_31065__$1 = (function (){var statearr_31100 = state_31065;
(statearr_31100[(20)] = inst_31007);

(statearr_31100[(21)] = inst_31005);

(statearr_31100[(11)] = inst_31006);

(statearr_31100[(12)] = inst_31008);

return statearr_31100;
})();
var statearr_31101_31173 = state_31065__$1;
(statearr_31101_31173[(2)] = null);

(statearr_31101_31173[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (41))){
var inst_31024 = (state_31065[(25)]);
var inst_31040 = (state_31065[(2)]);
var inst_31041 = cljs.core.next.call(null,inst_31024);
var inst_31005 = inst_31041;
var inst_31006 = null;
var inst_31007 = (0);
var inst_31008 = (0);
var state_31065__$1 = (function (){var statearr_31102 = state_31065;
(statearr_31102[(20)] = inst_31007);

(statearr_31102[(21)] = inst_31005);

(statearr_31102[(27)] = inst_31040);

(statearr_31102[(11)] = inst_31006);

(statearr_31102[(12)] = inst_31008);

return statearr_31102;
})();
var statearr_31103_31174 = state_31065__$1;
(statearr_31103_31174[(2)] = null);

(statearr_31103_31174[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (43))){
var state_31065__$1 = state_31065;
var statearr_31104_31175 = state_31065__$1;
(statearr_31104_31175[(2)] = null);

(statearr_31104_31175[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (29))){
var inst_31049 = (state_31065[(2)]);
var state_31065__$1 = state_31065;
var statearr_31105_31176 = state_31065__$1;
(statearr_31105_31176[(2)] = inst_31049);

(statearr_31105_31176[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (44))){
var inst_31058 = (state_31065[(2)]);
var state_31065__$1 = (function (){var statearr_31106 = state_31065;
(statearr_31106[(28)] = inst_31058);

return statearr_31106;
})();
var statearr_31107_31177 = state_31065__$1;
(statearr_31107_31177[(2)] = null);

(statearr_31107_31177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (6))){
var inst_30997 = (state_31065[(29)]);
var inst_30996 = cljs.core.deref.call(null,cs);
var inst_30997__$1 = cljs.core.keys.call(null,inst_30996);
var inst_30998 = cljs.core.count.call(null,inst_30997__$1);
var inst_30999 = cljs.core.reset_BANG_.call(null,dctr,inst_30998);
var inst_31004 = cljs.core.seq.call(null,inst_30997__$1);
var inst_31005 = inst_31004;
var inst_31006 = null;
var inst_31007 = (0);
var inst_31008 = (0);
var state_31065__$1 = (function (){var statearr_31108 = state_31065;
(statearr_31108[(29)] = inst_30997__$1);

(statearr_31108[(20)] = inst_31007);

(statearr_31108[(21)] = inst_31005);

(statearr_31108[(11)] = inst_31006);

(statearr_31108[(12)] = inst_31008);

(statearr_31108[(30)] = inst_30999);

return statearr_31108;
})();
var statearr_31109_31178 = state_31065__$1;
(statearr_31109_31178[(2)] = null);

(statearr_31109_31178[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (28))){
var inst_31024 = (state_31065[(25)]);
var inst_31005 = (state_31065[(21)]);
var inst_31024__$1 = cljs.core.seq.call(null,inst_31005);
var state_31065__$1 = (function (){var statearr_31110 = state_31065;
(statearr_31110[(25)] = inst_31024__$1);

return statearr_31110;
})();
if(inst_31024__$1){
var statearr_31111_31179 = state_31065__$1;
(statearr_31111_31179[(1)] = (33));

} else {
var statearr_31112_31180 = state_31065__$1;
(statearr_31112_31180[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (25))){
var inst_31007 = (state_31065[(20)]);
var inst_31008 = (state_31065[(12)]);
var inst_31010 = (inst_31008 < inst_31007);
var inst_31011 = inst_31010;
var state_31065__$1 = state_31065;
if(cljs.core.truth_(inst_31011)){
var statearr_31113_31181 = state_31065__$1;
(statearr_31113_31181[(1)] = (27));

} else {
var statearr_31114_31182 = state_31065__$1;
(statearr_31114_31182[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (34))){
var state_31065__$1 = state_31065;
var statearr_31115_31183 = state_31065__$1;
(statearr_31115_31183[(2)] = null);

(statearr_31115_31183[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (17))){
var state_31065__$1 = state_31065;
var statearr_31116_31184 = state_31065__$1;
(statearr_31116_31184[(2)] = null);

(statearr_31116_31184[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (3))){
var inst_31063 = (state_31065[(2)]);
var state_31065__$1 = state_31065;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31065__$1,inst_31063);
} else {
if((state_val_31066 === (12))){
var inst_30992 = (state_31065[(2)]);
var state_31065__$1 = state_31065;
var statearr_31117_31185 = state_31065__$1;
(statearr_31117_31185[(2)] = inst_30992);

(statearr_31117_31185[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (2))){
var state_31065__$1 = state_31065;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31065__$1,(4),ch);
} else {
if((state_val_31066 === (23))){
var state_31065__$1 = state_31065;
var statearr_31118_31186 = state_31065__$1;
(statearr_31118_31186[(2)] = null);

(statearr_31118_31186[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (35))){
var inst_31047 = (state_31065[(2)]);
var state_31065__$1 = state_31065;
var statearr_31119_31187 = state_31065__$1;
(statearr_31119_31187[(2)] = inst_31047);

(statearr_31119_31187[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (19))){
var inst_30964 = (state_31065[(7)]);
var inst_30968 = cljs.core.chunk_first.call(null,inst_30964);
var inst_30969 = cljs.core.chunk_rest.call(null,inst_30964);
var inst_30970 = cljs.core.count.call(null,inst_30968);
var inst_30942 = inst_30969;
var inst_30943 = inst_30968;
var inst_30944 = inst_30970;
var inst_30945 = (0);
var state_31065__$1 = (function (){var statearr_31120 = state_31065;
(statearr_31120[(13)] = inst_30943);

(statearr_31120[(14)] = inst_30944);

(statearr_31120[(16)] = inst_30945);

(statearr_31120[(17)] = inst_30942);

return statearr_31120;
})();
var statearr_31121_31188 = state_31065__$1;
(statearr_31121_31188[(2)] = null);

(statearr_31121_31188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (11))){
var inst_30964 = (state_31065[(7)]);
var inst_30942 = (state_31065[(17)]);
var inst_30964__$1 = cljs.core.seq.call(null,inst_30942);
var state_31065__$1 = (function (){var statearr_31122 = state_31065;
(statearr_31122[(7)] = inst_30964__$1);

return statearr_31122;
})();
if(inst_30964__$1){
var statearr_31123_31189 = state_31065__$1;
(statearr_31123_31189[(1)] = (16));

} else {
var statearr_31124_31190 = state_31065__$1;
(statearr_31124_31190[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (9))){
var inst_30994 = (state_31065[(2)]);
var state_31065__$1 = state_31065;
var statearr_31125_31191 = state_31065__$1;
(statearr_31125_31191[(2)] = inst_30994);

(statearr_31125_31191[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (5))){
var inst_30940 = cljs.core.deref.call(null,cs);
var inst_30941 = cljs.core.seq.call(null,inst_30940);
var inst_30942 = inst_30941;
var inst_30943 = null;
var inst_30944 = (0);
var inst_30945 = (0);
var state_31065__$1 = (function (){var statearr_31126 = state_31065;
(statearr_31126[(13)] = inst_30943);

(statearr_31126[(14)] = inst_30944);

(statearr_31126[(16)] = inst_30945);

(statearr_31126[(17)] = inst_30942);

return statearr_31126;
})();
var statearr_31127_31192 = state_31065__$1;
(statearr_31127_31192[(2)] = null);

(statearr_31127_31192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (14))){
var state_31065__$1 = state_31065;
var statearr_31128_31193 = state_31065__$1;
(statearr_31128_31193[(2)] = null);

(statearr_31128_31193[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (45))){
var inst_31055 = (state_31065[(2)]);
var state_31065__$1 = state_31065;
var statearr_31129_31194 = state_31065__$1;
(statearr_31129_31194[(2)] = inst_31055);

(statearr_31129_31194[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (26))){
var inst_30997 = (state_31065[(29)]);
var inst_31051 = (state_31065[(2)]);
var inst_31052 = cljs.core.seq.call(null,inst_30997);
var state_31065__$1 = (function (){var statearr_31130 = state_31065;
(statearr_31130[(31)] = inst_31051);

return statearr_31130;
})();
if(inst_31052){
var statearr_31131_31195 = state_31065__$1;
(statearr_31131_31195[(1)] = (42));

} else {
var statearr_31132_31196 = state_31065__$1;
(statearr_31132_31196[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (16))){
var inst_30964 = (state_31065[(7)]);
var inst_30966 = cljs.core.chunked_seq_QMARK_.call(null,inst_30964);
var state_31065__$1 = state_31065;
if(inst_30966){
var statearr_31133_31197 = state_31065__$1;
(statearr_31133_31197[(1)] = (19));

} else {
var statearr_31134_31198 = state_31065__$1;
(statearr_31134_31198[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (38))){
var inst_31044 = (state_31065[(2)]);
var state_31065__$1 = state_31065;
var statearr_31135_31199 = state_31065__$1;
(statearr_31135_31199[(2)] = inst_31044);

(statearr_31135_31199[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (30))){
var state_31065__$1 = state_31065;
var statearr_31136_31200 = state_31065__$1;
(statearr_31136_31200[(2)] = null);

(statearr_31136_31200[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (10))){
var inst_30943 = (state_31065[(13)]);
var inst_30945 = (state_31065[(16)]);
var inst_30953 = cljs.core._nth.call(null,inst_30943,inst_30945);
var inst_30954 = cljs.core.nth.call(null,inst_30953,(0),null);
var inst_30955 = cljs.core.nth.call(null,inst_30953,(1),null);
var state_31065__$1 = (function (){var statearr_31137 = state_31065;
(statearr_31137[(26)] = inst_30954);

return statearr_31137;
})();
if(cljs.core.truth_(inst_30955)){
var statearr_31138_31201 = state_31065__$1;
(statearr_31138_31201[(1)] = (13));

} else {
var statearr_31139_31202 = state_31065__$1;
(statearr_31139_31202[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (18))){
var inst_30990 = (state_31065[(2)]);
var state_31065__$1 = state_31065;
var statearr_31140_31203 = state_31065__$1;
(statearr_31140_31203[(2)] = inst_30990);

(statearr_31140_31203[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (42))){
var state_31065__$1 = state_31065;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31065__$1,(45),dchan);
} else {
if((state_val_31066 === (37))){
var inst_31033 = (state_31065[(23)]);
var inst_30933 = (state_31065[(9)]);
var inst_31024 = (state_31065[(25)]);
var inst_31033__$1 = cljs.core.first.call(null,inst_31024);
var inst_31034 = cljs.core.async.put_BANG_.call(null,inst_31033__$1,inst_30933,done);
var state_31065__$1 = (function (){var statearr_31141 = state_31065;
(statearr_31141[(23)] = inst_31033__$1);

return statearr_31141;
})();
if(cljs.core.truth_(inst_31034)){
var statearr_31142_31204 = state_31065__$1;
(statearr_31142_31204[(1)] = (39));

} else {
var statearr_31143_31205 = state_31065__$1;
(statearr_31143_31205[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31066 === (8))){
var inst_30944 = (state_31065[(14)]);
var inst_30945 = (state_31065[(16)]);
var inst_30947 = (inst_30945 < inst_30944);
var inst_30948 = inst_30947;
var state_31065__$1 = state_31065;
if(cljs.core.truth_(inst_30948)){
var statearr_31144_31206 = state_31065__$1;
(statearr_31144_31206[(1)] = (10));

} else {
var statearr_31145_31207 = state_31065__$1;
(statearr_31145_31207[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___31153,cs,m,dchan,dctr,done))
;
return ((function (switch__29702__auto__,c__29816__auto___31153,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__29703__auto__ = null;
var cljs$core$async$mult_$_state_machine__29703__auto____0 = (function (){
var statearr_31149 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31149[(0)] = cljs$core$async$mult_$_state_machine__29703__auto__);

(statearr_31149[(1)] = (1));

return statearr_31149;
});
var cljs$core$async$mult_$_state_machine__29703__auto____1 = (function (state_31065){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_31065);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e31150){if((e31150 instanceof Object)){
var ex__29706__auto__ = e31150;
var statearr_31151_31208 = state_31065;
(statearr_31151_31208[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31065);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31150;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31209 = state_31065;
state_31065 = G__31209;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29703__auto__ = function(state_31065){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29703__auto____1.call(this,state_31065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29703__auto____0;
cljs$core$async$mult_$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29703__auto____1;
return cljs$core$async$mult_$_state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___31153,cs,m,dchan,dctr,done))
})();
var state__29818__auto__ = (function (){var statearr_31152 = f__29817__auto__.call(null);
(statearr_31152[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___31153);

return statearr_31152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___31153,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args31210 = [];
var len__27761__auto___31213 = arguments.length;
var i__27762__auto___31214 = (0);
while(true){
if((i__27762__auto___31214 < len__27761__auto___31213)){
args31210.push((arguments[i__27762__auto___31214]));

var G__31215 = (i__27762__auto___31214 + (1));
i__27762__auto___31214 = G__31215;
continue;
} else {
}
break;
}

var G__31212 = args31210.length;
switch (G__31212) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31210.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27291__auto__ = (((m == null))?null:m);
var m__27292__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,m,ch);
} else {
var m__27292__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27291__auto__ = (((m == null))?null:m);
var m__27292__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,m,ch);
} else {
var m__27292__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27291__auto__ = (((m == null))?null:m);
var m__27292__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,m);
} else {
var m__27292__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27291__auto__ = (((m == null))?null:m);
var m__27292__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,m,state_map);
} else {
var m__27292__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27291__auto__ = (((m == null))?null:m);
var m__27292__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,m,mode);
} else {
var m__27292__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__27768__auto__ = [];
var len__27761__auto___31227 = arguments.length;
var i__27762__auto___31228 = (0);
while(true){
if((i__27762__auto___31228 < len__27761__auto___31227)){
args__27768__auto__.push((arguments[i__27762__auto___31228]));

var G__31229 = (i__27762__auto___31228 + (1));
i__27762__auto___31228 = G__31229;
continue;
} else {
}
break;
}

var argseq__27769__auto__ = ((((3) < args__27768__auto__.length))?(new cljs.core.IndexedSeq(args__27768__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__27769__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31221){
var map__31222 = p__31221;
var map__31222__$1 = ((((!((map__31222 == null)))?((((map__31222.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31222.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31222):map__31222);
var opts = map__31222__$1;
var statearr_31224_31230 = state;
(statearr_31224_31230[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6747__auto__ = cljs.core.async.do_alts.call(null,((function (map__31222,map__31222__$1,opts){
return (function (val){
var statearr_31225_31231 = state;
(statearr_31225_31231[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__31222,map__31222__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6747__auto__)){
var cb = temp__6747__auto__;
var statearr_31226_31232 = state;
(statearr_31226_31232[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31217){
var G__31218 = cljs.core.first.call(null,seq31217);
var seq31217__$1 = cljs.core.next.call(null,seq31217);
var G__31219 = cljs.core.first.call(null,seq31217__$1);
var seq31217__$2 = cljs.core.next.call(null,seq31217__$1);
var G__31220 = cljs.core.first.call(null,seq31217__$2);
var seq31217__$3 = cljs.core.next.call(null,seq31217__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31218,G__31219,G__31220,seq31217__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31398 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31398 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31399){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta31399 = meta31399;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31398.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31400,meta31399__$1){
var self__ = this;
var _31400__$1 = this;
return (new cljs.core.async.t_cljs$core$async31398(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta31399__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31398.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31400){
var self__ = this;
var _31400__$1 = this;
return self__.meta31399;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31398.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async31398.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31398.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async31398.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31398.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31398.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31398.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31398.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31398.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta31399","meta31399",1912597020,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31398.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31398.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31398";

cljs.core.async.t_cljs$core$async31398.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27230__auto__,writer__27231__auto__,opt__27232__auto__){
return cljs.core._write.call(null,writer__27231__auto__,"cljs.core.async/t_cljs$core$async31398");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async31398 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async31398(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31399){
return (new cljs.core.async.t_cljs$core$async31398(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31399));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async31398(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29816__auto___31563 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___31563,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___31563,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31500){
var state_val_31501 = (state_31500[(1)]);
if((state_val_31501 === (7))){
var inst_31416 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
var statearr_31502_31564 = state_31500__$1;
(statearr_31502_31564[(2)] = inst_31416);

(statearr_31502_31564[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (20))){
var inst_31428 = (state_31500[(7)]);
var state_31500__$1 = state_31500;
var statearr_31503_31565 = state_31500__$1;
(statearr_31503_31565[(2)] = inst_31428);

(statearr_31503_31565[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (27))){
var state_31500__$1 = state_31500;
var statearr_31504_31566 = state_31500__$1;
(statearr_31504_31566[(2)] = null);

(statearr_31504_31566[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (1))){
var inst_31404 = (state_31500[(8)]);
var inst_31404__$1 = calc_state.call(null);
var inst_31406 = (inst_31404__$1 == null);
var inst_31407 = cljs.core.not.call(null,inst_31406);
var state_31500__$1 = (function (){var statearr_31505 = state_31500;
(statearr_31505[(8)] = inst_31404__$1);

return statearr_31505;
})();
if(inst_31407){
var statearr_31506_31567 = state_31500__$1;
(statearr_31506_31567[(1)] = (2));

} else {
var statearr_31507_31568 = state_31500__$1;
(statearr_31507_31568[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (24))){
var inst_31474 = (state_31500[(9)]);
var inst_31460 = (state_31500[(10)]);
var inst_31451 = (state_31500[(11)]);
var inst_31474__$1 = inst_31451.call(null,inst_31460);
var state_31500__$1 = (function (){var statearr_31508 = state_31500;
(statearr_31508[(9)] = inst_31474__$1);

return statearr_31508;
})();
if(cljs.core.truth_(inst_31474__$1)){
var statearr_31509_31569 = state_31500__$1;
(statearr_31509_31569[(1)] = (29));

} else {
var statearr_31510_31570 = state_31500__$1;
(statearr_31510_31570[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (4))){
var inst_31419 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
if(cljs.core.truth_(inst_31419)){
var statearr_31511_31571 = state_31500__$1;
(statearr_31511_31571[(1)] = (8));

} else {
var statearr_31512_31572 = state_31500__$1;
(statearr_31512_31572[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (15))){
var inst_31445 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
if(cljs.core.truth_(inst_31445)){
var statearr_31513_31573 = state_31500__$1;
(statearr_31513_31573[(1)] = (19));

} else {
var statearr_31514_31574 = state_31500__$1;
(statearr_31514_31574[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (21))){
var inst_31450 = (state_31500[(12)]);
var inst_31450__$1 = (state_31500[(2)]);
var inst_31451 = cljs.core.get.call(null,inst_31450__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31452 = cljs.core.get.call(null,inst_31450__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31453 = cljs.core.get.call(null,inst_31450__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31500__$1 = (function (){var statearr_31515 = state_31500;
(statearr_31515[(12)] = inst_31450__$1);

(statearr_31515[(11)] = inst_31451);

(statearr_31515[(13)] = inst_31452);

return statearr_31515;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31500__$1,(22),inst_31453);
} else {
if((state_val_31501 === (31))){
var inst_31482 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
if(cljs.core.truth_(inst_31482)){
var statearr_31516_31575 = state_31500__$1;
(statearr_31516_31575[(1)] = (32));

} else {
var statearr_31517_31576 = state_31500__$1;
(statearr_31517_31576[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (32))){
var inst_31459 = (state_31500[(14)]);
var state_31500__$1 = state_31500;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31500__$1,(35),out,inst_31459);
} else {
if((state_val_31501 === (33))){
var inst_31450 = (state_31500[(12)]);
var inst_31428 = inst_31450;
var state_31500__$1 = (function (){var statearr_31518 = state_31500;
(statearr_31518[(7)] = inst_31428);

return statearr_31518;
})();
var statearr_31519_31577 = state_31500__$1;
(statearr_31519_31577[(2)] = null);

(statearr_31519_31577[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (13))){
var inst_31428 = (state_31500[(7)]);
var inst_31435 = inst_31428.cljs$lang$protocol_mask$partition0$;
var inst_31436 = (inst_31435 & (64));
var inst_31437 = inst_31428.cljs$core$ISeq$;
var inst_31438 = (inst_31436) || (inst_31437);
var state_31500__$1 = state_31500;
if(cljs.core.truth_(inst_31438)){
var statearr_31520_31578 = state_31500__$1;
(statearr_31520_31578[(1)] = (16));

} else {
var statearr_31521_31579 = state_31500__$1;
(statearr_31521_31579[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (22))){
var inst_31459 = (state_31500[(14)]);
var inst_31460 = (state_31500[(10)]);
var inst_31458 = (state_31500[(2)]);
var inst_31459__$1 = cljs.core.nth.call(null,inst_31458,(0),null);
var inst_31460__$1 = cljs.core.nth.call(null,inst_31458,(1),null);
var inst_31461 = (inst_31459__$1 == null);
var inst_31462 = cljs.core._EQ_.call(null,inst_31460__$1,change);
var inst_31463 = (inst_31461) || (inst_31462);
var state_31500__$1 = (function (){var statearr_31522 = state_31500;
(statearr_31522[(14)] = inst_31459__$1);

(statearr_31522[(10)] = inst_31460__$1);

return statearr_31522;
})();
if(cljs.core.truth_(inst_31463)){
var statearr_31523_31580 = state_31500__$1;
(statearr_31523_31580[(1)] = (23));

} else {
var statearr_31524_31581 = state_31500__$1;
(statearr_31524_31581[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (36))){
var inst_31450 = (state_31500[(12)]);
var inst_31428 = inst_31450;
var state_31500__$1 = (function (){var statearr_31525 = state_31500;
(statearr_31525[(7)] = inst_31428);

return statearr_31525;
})();
var statearr_31526_31582 = state_31500__$1;
(statearr_31526_31582[(2)] = null);

(statearr_31526_31582[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (29))){
var inst_31474 = (state_31500[(9)]);
var state_31500__$1 = state_31500;
var statearr_31527_31583 = state_31500__$1;
(statearr_31527_31583[(2)] = inst_31474);

(statearr_31527_31583[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (6))){
var state_31500__$1 = state_31500;
var statearr_31528_31584 = state_31500__$1;
(statearr_31528_31584[(2)] = false);

(statearr_31528_31584[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (28))){
var inst_31470 = (state_31500[(2)]);
var inst_31471 = calc_state.call(null);
var inst_31428 = inst_31471;
var state_31500__$1 = (function (){var statearr_31529 = state_31500;
(statearr_31529[(7)] = inst_31428);

(statearr_31529[(15)] = inst_31470);

return statearr_31529;
})();
var statearr_31530_31585 = state_31500__$1;
(statearr_31530_31585[(2)] = null);

(statearr_31530_31585[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (25))){
var inst_31496 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
var statearr_31531_31586 = state_31500__$1;
(statearr_31531_31586[(2)] = inst_31496);

(statearr_31531_31586[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (34))){
var inst_31494 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
var statearr_31532_31587 = state_31500__$1;
(statearr_31532_31587[(2)] = inst_31494);

(statearr_31532_31587[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (17))){
var state_31500__$1 = state_31500;
var statearr_31533_31588 = state_31500__$1;
(statearr_31533_31588[(2)] = false);

(statearr_31533_31588[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (3))){
var state_31500__$1 = state_31500;
var statearr_31534_31589 = state_31500__$1;
(statearr_31534_31589[(2)] = false);

(statearr_31534_31589[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (12))){
var inst_31498 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31500__$1,inst_31498);
} else {
if((state_val_31501 === (2))){
var inst_31404 = (state_31500[(8)]);
var inst_31409 = inst_31404.cljs$lang$protocol_mask$partition0$;
var inst_31410 = (inst_31409 & (64));
var inst_31411 = inst_31404.cljs$core$ISeq$;
var inst_31412 = (inst_31410) || (inst_31411);
var state_31500__$1 = state_31500;
if(cljs.core.truth_(inst_31412)){
var statearr_31535_31590 = state_31500__$1;
(statearr_31535_31590[(1)] = (5));

} else {
var statearr_31536_31591 = state_31500__$1;
(statearr_31536_31591[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (23))){
var inst_31459 = (state_31500[(14)]);
var inst_31465 = (inst_31459 == null);
var state_31500__$1 = state_31500;
if(cljs.core.truth_(inst_31465)){
var statearr_31537_31592 = state_31500__$1;
(statearr_31537_31592[(1)] = (26));

} else {
var statearr_31538_31593 = state_31500__$1;
(statearr_31538_31593[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (35))){
var inst_31485 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
if(cljs.core.truth_(inst_31485)){
var statearr_31539_31594 = state_31500__$1;
(statearr_31539_31594[(1)] = (36));

} else {
var statearr_31540_31595 = state_31500__$1;
(statearr_31540_31595[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (19))){
var inst_31428 = (state_31500[(7)]);
var inst_31447 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31428);
var state_31500__$1 = state_31500;
var statearr_31541_31596 = state_31500__$1;
(statearr_31541_31596[(2)] = inst_31447);

(statearr_31541_31596[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (11))){
var inst_31428 = (state_31500[(7)]);
var inst_31432 = (inst_31428 == null);
var inst_31433 = cljs.core.not.call(null,inst_31432);
var state_31500__$1 = state_31500;
if(inst_31433){
var statearr_31542_31597 = state_31500__$1;
(statearr_31542_31597[(1)] = (13));

} else {
var statearr_31543_31598 = state_31500__$1;
(statearr_31543_31598[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (9))){
var inst_31404 = (state_31500[(8)]);
var state_31500__$1 = state_31500;
var statearr_31544_31599 = state_31500__$1;
(statearr_31544_31599[(2)] = inst_31404);

(statearr_31544_31599[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (5))){
var state_31500__$1 = state_31500;
var statearr_31545_31600 = state_31500__$1;
(statearr_31545_31600[(2)] = true);

(statearr_31545_31600[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (14))){
var state_31500__$1 = state_31500;
var statearr_31546_31601 = state_31500__$1;
(statearr_31546_31601[(2)] = false);

(statearr_31546_31601[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (26))){
var inst_31460 = (state_31500[(10)]);
var inst_31467 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_31460);
var state_31500__$1 = state_31500;
var statearr_31547_31602 = state_31500__$1;
(statearr_31547_31602[(2)] = inst_31467);

(statearr_31547_31602[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (16))){
var state_31500__$1 = state_31500;
var statearr_31548_31603 = state_31500__$1;
(statearr_31548_31603[(2)] = true);

(statearr_31548_31603[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (38))){
var inst_31490 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
var statearr_31549_31604 = state_31500__$1;
(statearr_31549_31604[(2)] = inst_31490);

(statearr_31549_31604[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (30))){
var inst_31460 = (state_31500[(10)]);
var inst_31451 = (state_31500[(11)]);
var inst_31452 = (state_31500[(13)]);
var inst_31477 = cljs.core.empty_QMARK_.call(null,inst_31451);
var inst_31478 = inst_31452.call(null,inst_31460);
var inst_31479 = cljs.core.not.call(null,inst_31478);
var inst_31480 = (inst_31477) && (inst_31479);
var state_31500__$1 = state_31500;
var statearr_31550_31605 = state_31500__$1;
(statearr_31550_31605[(2)] = inst_31480);

(statearr_31550_31605[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (10))){
var inst_31404 = (state_31500[(8)]);
var inst_31424 = (state_31500[(2)]);
var inst_31425 = cljs.core.get.call(null,inst_31424,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31426 = cljs.core.get.call(null,inst_31424,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31427 = cljs.core.get.call(null,inst_31424,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31428 = inst_31404;
var state_31500__$1 = (function (){var statearr_31551 = state_31500;
(statearr_31551[(16)] = inst_31425);

(statearr_31551[(7)] = inst_31428);

(statearr_31551[(17)] = inst_31426);

(statearr_31551[(18)] = inst_31427);

return statearr_31551;
})();
var statearr_31552_31606 = state_31500__$1;
(statearr_31552_31606[(2)] = null);

(statearr_31552_31606[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (18))){
var inst_31442 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
var statearr_31553_31607 = state_31500__$1;
(statearr_31553_31607[(2)] = inst_31442);

(statearr_31553_31607[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (37))){
var state_31500__$1 = state_31500;
var statearr_31554_31608 = state_31500__$1;
(statearr_31554_31608[(2)] = null);

(statearr_31554_31608[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31501 === (8))){
var inst_31404 = (state_31500[(8)]);
var inst_31421 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31404);
var state_31500__$1 = state_31500;
var statearr_31555_31609 = state_31500__$1;
(statearr_31555_31609[(2)] = inst_31421);

(statearr_31555_31609[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___31563,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__29702__auto__,c__29816__auto___31563,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__29703__auto__ = null;
var cljs$core$async$mix_$_state_machine__29703__auto____0 = (function (){
var statearr_31559 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31559[(0)] = cljs$core$async$mix_$_state_machine__29703__auto__);

(statearr_31559[(1)] = (1));

return statearr_31559;
});
var cljs$core$async$mix_$_state_machine__29703__auto____1 = (function (state_31500){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_31500);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e31560){if((e31560 instanceof Object)){
var ex__29706__auto__ = e31560;
var statearr_31561_31610 = state_31500;
(statearr_31561_31610[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31500);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31560;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31611 = state_31500;
state_31500 = G__31611;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29703__auto__ = function(state_31500){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29703__auto____1.call(this,state_31500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29703__auto____0;
cljs$core$async$mix_$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29703__auto____1;
return cljs$core$async$mix_$_state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___31563,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__29818__auto__ = (function (){var statearr_31562 = f__29817__auto__.call(null);
(statearr_31562[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___31563);

return statearr_31562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___31563,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27291__auto__ = (((p == null))?null:p);
var m__27292__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27292__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27291__auto__ = (((p == null))?null:p);
var m__27292__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,p,v,ch);
} else {
var m__27292__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args31612 = [];
var len__27761__auto___31615 = arguments.length;
var i__27762__auto___31616 = (0);
while(true){
if((i__27762__auto___31616 < len__27761__auto___31615)){
args31612.push((arguments[i__27762__auto___31616]));

var G__31617 = (i__27762__auto___31616 + (1));
i__27762__auto___31616 = G__31617;
continue;
} else {
}
break;
}

var G__31614 = args31612.length;
switch (G__31614) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31612.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27291__auto__ = (((p == null))?null:p);
var m__27292__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,p);
} else {
var m__27292__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27291__auto__ = (((p == null))?null:p);
var m__27292__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27291__auto__)]);
if(!((m__27292__auto__ == null))){
return m__27292__auto__.call(null,p,v);
} else {
var m__27292__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27292__auto____$1 == null))){
return m__27292__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args31620 = [];
var len__27761__auto___31745 = arguments.length;
var i__27762__auto___31746 = (0);
while(true){
if((i__27762__auto___31746 < len__27761__auto___31745)){
args31620.push((arguments[i__27762__auto___31746]));

var G__31747 = (i__27762__auto___31746 + (1));
i__27762__auto___31746 = G__31747;
continue;
} else {
}
break;
}

var G__31622 = args31620.length;
switch (G__31622) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31620.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__26578__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__26578__auto__)){
return or__26578__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__26578__auto__,mults){
return (function (p1__31619_SHARP_){
if(cljs.core.truth_(p1__31619_SHARP_.call(null,topic))){
return p1__31619_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__31619_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__26578__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async31623 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31623 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31624){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31624 = meta31624;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31623.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31625,meta31624__$1){
var self__ = this;
var _31625__$1 = this;
return (new cljs.core.async.t_cljs$core$async31623(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31624__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31623.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31625){
var self__ = this;
var _31625__$1 = this;
return self__.meta31624;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31623.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async31623.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31623.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async31623.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31623.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6747__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6747__auto__)){
var m = temp__6747__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31623.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31623.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31623.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31624","meta31624",1352584156,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31623.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31623.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31623";

cljs.core.async.t_cljs$core$async31623.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27230__auto__,writer__27231__auto__,opt__27232__auto__){
return cljs.core._write.call(null,writer__27231__auto__,"cljs.core.async/t_cljs$core$async31623");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async31623 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async31623(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31624){
return (new cljs.core.async.t_cljs$core$async31623(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31624));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async31623(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29816__auto___31749 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___31749,mults,ensure_mult,p){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___31749,mults,ensure_mult,p){
return (function (state_31697){
var state_val_31698 = (state_31697[(1)]);
if((state_val_31698 === (7))){
var inst_31693 = (state_31697[(2)]);
var state_31697__$1 = state_31697;
var statearr_31699_31750 = state_31697__$1;
(statearr_31699_31750[(2)] = inst_31693);

(statearr_31699_31750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (20))){
var state_31697__$1 = state_31697;
var statearr_31700_31751 = state_31697__$1;
(statearr_31700_31751[(2)] = null);

(statearr_31700_31751[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (1))){
var state_31697__$1 = state_31697;
var statearr_31701_31752 = state_31697__$1;
(statearr_31701_31752[(2)] = null);

(statearr_31701_31752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (24))){
var inst_31676 = (state_31697[(7)]);
var inst_31685 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_31676);
var state_31697__$1 = state_31697;
var statearr_31702_31753 = state_31697__$1;
(statearr_31702_31753[(2)] = inst_31685);

(statearr_31702_31753[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (4))){
var inst_31628 = (state_31697[(8)]);
var inst_31628__$1 = (state_31697[(2)]);
var inst_31629 = (inst_31628__$1 == null);
var state_31697__$1 = (function (){var statearr_31703 = state_31697;
(statearr_31703[(8)] = inst_31628__$1);

return statearr_31703;
})();
if(cljs.core.truth_(inst_31629)){
var statearr_31704_31754 = state_31697__$1;
(statearr_31704_31754[(1)] = (5));

} else {
var statearr_31705_31755 = state_31697__$1;
(statearr_31705_31755[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (15))){
var inst_31670 = (state_31697[(2)]);
var state_31697__$1 = state_31697;
var statearr_31706_31756 = state_31697__$1;
(statearr_31706_31756[(2)] = inst_31670);

(statearr_31706_31756[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (21))){
var inst_31690 = (state_31697[(2)]);
var state_31697__$1 = (function (){var statearr_31707 = state_31697;
(statearr_31707[(9)] = inst_31690);

return statearr_31707;
})();
var statearr_31708_31757 = state_31697__$1;
(statearr_31708_31757[(2)] = null);

(statearr_31708_31757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (13))){
var inst_31652 = (state_31697[(10)]);
var inst_31654 = cljs.core.chunked_seq_QMARK_.call(null,inst_31652);
var state_31697__$1 = state_31697;
if(inst_31654){
var statearr_31709_31758 = state_31697__$1;
(statearr_31709_31758[(1)] = (16));

} else {
var statearr_31710_31759 = state_31697__$1;
(statearr_31710_31759[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (22))){
var inst_31682 = (state_31697[(2)]);
var state_31697__$1 = state_31697;
if(cljs.core.truth_(inst_31682)){
var statearr_31711_31760 = state_31697__$1;
(statearr_31711_31760[(1)] = (23));

} else {
var statearr_31712_31761 = state_31697__$1;
(statearr_31712_31761[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (6))){
var inst_31678 = (state_31697[(11)]);
var inst_31628 = (state_31697[(8)]);
var inst_31676 = (state_31697[(7)]);
var inst_31676__$1 = topic_fn.call(null,inst_31628);
var inst_31677 = cljs.core.deref.call(null,mults);
var inst_31678__$1 = cljs.core.get.call(null,inst_31677,inst_31676__$1);
var state_31697__$1 = (function (){var statearr_31713 = state_31697;
(statearr_31713[(11)] = inst_31678__$1);

(statearr_31713[(7)] = inst_31676__$1);

return statearr_31713;
})();
if(cljs.core.truth_(inst_31678__$1)){
var statearr_31714_31762 = state_31697__$1;
(statearr_31714_31762[(1)] = (19));

} else {
var statearr_31715_31763 = state_31697__$1;
(statearr_31715_31763[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (25))){
var inst_31687 = (state_31697[(2)]);
var state_31697__$1 = state_31697;
var statearr_31716_31764 = state_31697__$1;
(statearr_31716_31764[(2)] = inst_31687);

(statearr_31716_31764[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (17))){
var inst_31652 = (state_31697[(10)]);
var inst_31661 = cljs.core.first.call(null,inst_31652);
var inst_31662 = cljs.core.async.muxch_STAR_.call(null,inst_31661);
var inst_31663 = cljs.core.async.close_BANG_.call(null,inst_31662);
var inst_31664 = cljs.core.next.call(null,inst_31652);
var inst_31638 = inst_31664;
var inst_31639 = null;
var inst_31640 = (0);
var inst_31641 = (0);
var state_31697__$1 = (function (){var statearr_31717 = state_31697;
(statearr_31717[(12)] = inst_31638);

(statearr_31717[(13)] = inst_31663);

(statearr_31717[(14)] = inst_31641);

(statearr_31717[(15)] = inst_31640);

(statearr_31717[(16)] = inst_31639);

return statearr_31717;
})();
var statearr_31718_31765 = state_31697__$1;
(statearr_31718_31765[(2)] = null);

(statearr_31718_31765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (3))){
var inst_31695 = (state_31697[(2)]);
var state_31697__$1 = state_31697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31697__$1,inst_31695);
} else {
if((state_val_31698 === (12))){
var inst_31672 = (state_31697[(2)]);
var state_31697__$1 = state_31697;
var statearr_31719_31766 = state_31697__$1;
(statearr_31719_31766[(2)] = inst_31672);

(statearr_31719_31766[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (2))){
var state_31697__$1 = state_31697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31697__$1,(4),ch);
} else {
if((state_val_31698 === (23))){
var state_31697__$1 = state_31697;
var statearr_31720_31767 = state_31697__$1;
(statearr_31720_31767[(2)] = null);

(statearr_31720_31767[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (19))){
var inst_31678 = (state_31697[(11)]);
var inst_31628 = (state_31697[(8)]);
var inst_31680 = cljs.core.async.muxch_STAR_.call(null,inst_31678);
var state_31697__$1 = state_31697;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31697__$1,(22),inst_31680,inst_31628);
} else {
if((state_val_31698 === (11))){
var inst_31652 = (state_31697[(10)]);
var inst_31638 = (state_31697[(12)]);
var inst_31652__$1 = cljs.core.seq.call(null,inst_31638);
var state_31697__$1 = (function (){var statearr_31721 = state_31697;
(statearr_31721[(10)] = inst_31652__$1);

return statearr_31721;
})();
if(inst_31652__$1){
var statearr_31722_31768 = state_31697__$1;
(statearr_31722_31768[(1)] = (13));

} else {
var statearr_31723_31769 = state_31697__$1;
(statearr_31723_31769[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (9))){
var inst_31674 = (state_31697[(2)]);
var state_31697__$1 = state_31697;
var statearr_31724_31770 = state_31697__$1;
(statearr_31724_31770[(2)] = inst_31674);

(statearr_31724_31770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (5))){
var inst_31635 = cljs.core.deref.call(null,mults);
var inst_31636 = cljs.core.vals.call(null,inst_31635);
var inst_31637 = cljs.core.seq.call(null,inst_31636);
var inst_31638 = inst_31637;
var inst_31639 = null;
var inst_31640 = (0);
var inst_31641 = (0);
var state_31697__$1 = (function (){var statearr_31725 = state_31697;
(statearr_31725[(12)] = inst_31638);

(statearr_31725[(14)] = inst_31641);

(statearr_31725[(15)] = inst_31640);

(statearr_31725[(16)] = inst_31639);

return statearr_31725;
})();
var statearr_31726_31771 = state_31697__$1;
(statearr_31726_31771[(2)] = null);

(statearr_31726_31771[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (14))){
var state_31697__$1 = state_31697;
var statearr_31730_31772 = state_31697__$1;
(statearr_31730_31772[(2)] = null);

(statearr_31730_31772[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (16))){
var inst_31652 = (state_31697[(10)]);
var inst_31656 = cljs.core.chunk_first.call(null,inst_31652);
var inst_31657 = cljs.core.chunk_rest.call(null,inst_31652);
var inst_31658 = cljs.core.count.call(null,inst_31656);
var inst_31638 = inst_31657;
var inst_31639 = inst_31656;
var inst_31640 = inst_31658;
var inst_31641 = (0);
var state_31697__$1 = (function (){var statearr_31731 = state_31697;
(statearr_31731[(12)] = inst_31638);

(statearr_31731[(14)] = inst_31641);

(statearr_31731[(15)] = inst_31640);

(statearr_31731[(16)] = inst_31639);

return statearr_31731;
})();
var statearr_31732_31773 = state_31697__$1;
(statearr_31732_31773[(2)] = null);

(statearr_31732_31773[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (10))){
var inst_31638 = (state_31697[(12)]);
var inst_31641 = (state_31697[(14)]);
var inst_31640 = (state_31697[(15)]);
var inst_31639 = (state_31697[(16)]);
var inst_31646 = cljs.core._nth.call(null,inst_31639,inst_31641);
var inst_31647 = cljs.core.async.muxch_STAR_.call(null,inst_31646);
var inst_31648 = cljs.core.async.close_BANG_.call(null,inst_31647);
var inst_31649 = (inst_31641 + (1));
var tmp31727 = inst_31638;
var tmp31728 = inst_31640;
var tmp31729 = inst_31639;
var inst_31638__$1 = tmp31727;
var inst_31639__$1 = tmp31729;
var inst_31640__$1 = tmp31728;
var inst_31641__$1 = inst_31649;
var state_31697__$1 = (function (){var statearr_31733 = state_31697;
(statearr_31733[(12)] = inst_31638__$1);

(statearr_31733[(17)] = inst_31648);

(statearr_31733[(14)] = inst_31641__$1);

(statearr_31733[(15)] = inst_31640__$1);

(statearr_31733[(16)] = inst_31639__$1);

return statearr_31733;
})();
var statearr_31734_31774 = state_31697__$1;
(statearr_31734_31774[(2)] = null);

(statearr_31734_31774[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (18))){
var inst_31667 = (state_31697[(2)]);
var state_31697__$1 = state_31697;
var statearr_31735_31775 = state_31697__$1;
(statearr_31735_31775[(2)] = inst_31667);

(statearr_31735_31775[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31698 === (8))){
var inst_31641 = (state_31697[(14)]);
var inst_31640 = (state_31697[(15)]);
var inst_31643 = (inst_31641 < inst_31640);
var inst_31644 = inst_31643;
var state_31697__$1 = state_31697;
if(cljs.core.truth_(inst_31644)){
var statearr_31736_31776 = state_31697__$1;
(statearr_31736_31776[(1)] = (10));

} else {
var statearr_31737_31777 = state_31697__$1;
(statearr_31737_31777[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___31749,mults,ensure_mult,p))
;
return ((function (switch__29702__auto__,c__29816__auto___31749,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__29703__auto__ = null;
var cljs$core$async$state_machine__29703__auto____0 = (function (){
var statearr_31741 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31741[(0)] = cljs$core$async$state_machine__29703__auto__);

(statearr_31741[(1)] = (1));

return statearr_31741;
});
var cljs$core$async$state_machine__29703__auto____1 = (function (state_31697){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_31697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e31742){if((e31742 instanceof Object)){
var ex__29706__auto__ = e31742;
var statearr_31743_31778 = state_31697;
(statearr_31743_31778[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31697);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31742;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31779 = state_31697;
state_31697 = G__31779;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$state_machine__29703__auto__ = function(state_31697){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29703__auto____1.call(this,state_31697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29703__auto____0;
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29703__auto____1;
return cljs$core$async$state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___31749,mults,ensure_mult,p))
})();
var state__29818__auto__ = (function (){var statearr_31744 = f__29817__auto__.call(null);
(statearr_31744[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___31749);

return statearr_31744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___31749,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args31780 = [];
var len__27761__auto___31783 = arguments.length;
var i__27762__auto___31784 = (0);
while(true){
if((i__27762__auto___31784 < len__27761__auto___31783)){
args31780.push((arguments[i__27762__auto___31784]));

var G__31785 = (i__27762__auto___31784 + (1));
i__27762__auto___31784 = G__31785;
continue;
} else {
}
break;
}

var G__31782 = args31780.length;
switch (G__31782) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31780.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args31787 = [];
var len__27761__auto___31790 = arguments.length;
var i__27762__auto___31791 = (0);
while(true){
if((i__27762__auto___31791 < len__27761__auto___31790)){
args31787.push((arguments[i__27762__auto___31791]));

var G__31792 = (i__27762__auto___31791 + (1));
i__27762__auto___31791 = G__31792;
continue;
} else {
}
break;
}

var G__31789 = args31787.length;
switch (G__31789) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31787.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args31794 = [];
var len__27761__auto___31865 = arguments.length;
var i__27762__auto___31866 = (0);
while(true){
if((i__27762__auto___31866 < len__27761__auto___31865)){
args31794.push((arguments[i__27762__auto___31866]));

var G__31867 = (i__27762__auto___31866 + (1));
i__27762__auto___31866 = G__31867;
continue;
} else {
}
break;
}

var G__31796 = args31794.length;
switch (G__31796) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31794.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__29816__auto___31869 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___31869,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___31869,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_31835){
var state_val_31836 = (state_31835[(1)]);
if((state_val_31836 === (7))){
var state_31835__$1 = state_31835;
var statearr_31837_31870 = state_31835__$1;
(statearr_31837_31870[(2)] = null);

(statearr_31837_31870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31836 === (1))){
var state_31835__$1 = state_31835;
var statearr_31838_31871 = state_31835__$1;
(statearr_31838_31871[(2)] = null);

(statearr_31838_31871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31836 === (4))){
var inst_31799 = (state_31835[(7)]);
var inst_31801 = (inst_31799 < cnt);
var state_31835__$1 = state_31835;
if(cljs.core.truth_(inst_31801)){
var statearr_31839_31872 = state_31835__$1;
(statearr_31839_31872[(1)] = (6));

} else {
var statearr_31840_31873 = state_31835__$1;
(statearr_31840_31873[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31836 === (15))){
var inst_31831 = (state_31835[(2)]);
var state_31835__$1 = state_31835;
var statearr_31841_31874 = state_31835__$1;
(statearr_31841_31874[(2)] = inst_31831);

(statearr_31841_31874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31836 === (13))){
var inst_31824 = cljs.core.async.close_BANG_.call(null,out);
var state_31835__$1 = state_31835;
var statearr_31842_31875 = state_31835__$1;
(statearr_31842_31875[(2)] = inst_31824);

(statearr_31842_31875[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31836 === (6))){
var state_31835__$1 = state_31835;
var statearr_31843_31876 = state_31835__$1;
(statearr_31843_31876[(2)] = null);

(statearr_31843_31876[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31836 === (3))){
var inst_31833 = (state_31835[(2)]);
var state_31835__$1 = state_31835;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31835__$1,inst_31833);
} else {
if((state_val_31836 === (12))){
var inst_31821 = (state_31835[(8)]);
var inst_31821__$1 = (state_31835[(2)]);
var inst_31822 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_31821__$1);
var state_31835__$1 = (function (){var statearr_31844 = state_31835;
(statearr_31844[(8)] = inst_31821__$1);

return statearr_31844;
})();
if(cljs.core.truth_(inst_31822)){
var statearr_31845_31877 = state_31835__$1;
(statearr_31845_31877[(1)] = (13));

} else {
var statearr_31846_31878 = state_31835__$1;
(statearr_31846_31878[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31836 === (2))){
var inst_31798 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_31799 = (0);
var state_31835__$1 = (function (){var statearr_31847 = state_31835;
(statearr_31847[(9)] = inst_31798);

(statearr_31847[(7)] = inst_31799);

return statearr_31847;
})();
var statearr_31848_31879 = state_31835__$1;
(statearr_31848_31879[(2)] = null);

(statearr_31848_31879[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31836 === (11))){
var inst_31799 = (state_31835[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_31835,(10),Object,null,(9));
var inst_31808 = chs__$1.call(null,inst_31799);
var inst_31809 = done.call(null,inst_31799);
var inst_31810 = cljs.core.async.take_BANG_.call(null,inst_31808,inst_31809);
var state_31835__$1 = state_31835;
var statearr_31849_31880 = state_31835__$1;
(statearr_31849_31880[(2)] = inst_31810);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31835__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31836 === (9))){
var inst_31799 = (state_31835[(7)]);
var inst_31812 = (state_31835[(2)]);
var inst_31813 = (inst_31799 + (1));
var inst_31799__$1 = inst_31813;
var state_31835__$1 = (function (){var statearr_31850 = state_31835;
(statearr_31850[(10)] = inst_31812);

(statearr_31850[(7)] = inst_31799__$1);

return statearr_31850;
})();
var statearr_31851_31881 = state_31835__$1;
(statearr_31851_31881[(2)] = null);

(statearr_31851_31881[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31836 === (5))){
var inst_31819 = (state_31835[(2)]);
var state_31835__$1 = (function (){var statearr_31852 = state_31835;
(statearr_31852[(11)] = inst_31819);

return statearr_31852;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31835__$1,(12),dchan);
} else {
if((state_val_31836 === (14))){
var inst_31821 = (state_31835[(8)]);
var inst_31826 = cljs.core.apply.call(null,f,inst_31821);
var state_31835__$1 = state_31835;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31835__$1,(16),out,inst_31826);
} else {
if((state_val_31836 === (16))){
var inst_31828 = (state_31835[(2)]);
var state_31835__$1 = (function (){var statearr_31853 = state_31835;
(statearr_31853[(12)] = inst_31828);

return statearr_31853;
})();
var statearr_31854_31882 = state_31835__$1;
(statearr_31854_31882[(2)] = null);

(statearr_31854_31882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31836 === (10))){
var inst_31803 = (state_31835[(2)]);
var inst_31804 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_31835__$1 = (function (){var statearr_31855 = state_31835;
(statearr_31855[(13)] = inst_31803);

return statearr_31855;
})();
var statearr_31856_31883 = state_31835__$1;
(statearr_31856_31883[(2)] = inst_31804);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31835__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31836 === (8))){
var inst_31817 = (state_31835[(2)]);
var state_31835__$1 = state_31835;
var statearr_31857_31884 = state_31835__$1;
(statearr_31857_31884[(2)] = inst_31817);

(statearr_31857_31884[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___31869,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__29702__auto__,c__29816__auto___31869,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__29703__auto__ = null;
var cljs$core$async$state_machine__29703__auto____0 = (function (){
var statearr_31861 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31861[(0)] = cljs$core$async$state_machine__29703__auto__);

(statearr_31861[(1)] = (1));

return statearr_31861;
});
var cljs$core$async$state_machine__29703__auto____1 = (function (state_31835){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_31835);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e31862){if((e31862 instanceof Object)){
var ex__29706__auto__ = e31862;
var statearr_31863_31885 = state_31835;
(statearr_31863_31885[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31835);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31862;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31886 = state_31835;
state_31835 = G__31886;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$state_machine__29703__auto__ = function(state_31835){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29703__auto____1.call(this,state_31835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29703__auto____0;
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29703__auto____1;
return cljs$core$async$state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___31869,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__29818__auto__ = (function (){var statearr_31864 = f__29817__auto__.call(null);
(statearr_31864[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___31869);

return statearr_31864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___31869,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args31888 = [];
var len__27761__auto___31946 = arguments.length;
var i__27762__auto___31947 = (0);
while(true){
if((i__27762__auto___31947 < len__27761__auto___31946)){
args31888.push((arguments[i__27762__auto___31947]));

var G__31948 = (i__27762__auto___31947 + (1));
i__27762__auto___31947 = G__31948;
continue;
} else {
}
break;
}

var G__31890 = args31888.length;
switch (G__31890) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31888.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29816__auto___31950 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___31950,out){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___31950,out){
return (function (state_31922){
var state_val_31923 = (state_31922[(1)]);
if((state_val_31923 === (7))){
var inst_31902 = (state_31922[(7)]);
var inst_31901 = (state_31922[(8)]);
var inst_31901__$1 = (state_31922[(2)]);
var inst_31902__$1 = cljs.core.nth.call(null,inst_31901__$1,(0),null);
var inst_31903 = cljs.core.nth.call(null,inst_31901__$1,(1),null);
var inst_31904 = (inst_31902__$1 == null);
var state_31922__$1 = (function (){var statearr_31924 = state_31922;
(statearr_31924[(9)] = inst_31903);

(statearr_31924[(7)] = inst_31902__$1);

(statearr_31924[(8)] = inst_31901__$1);

return statearr_31924;
})();
if(cljs.core.truth_(inst_31904)){
var statearr_31925_31951 = state_31922__$1;
(statearr_31925_31951[(1)] = (8));

} else {
var statearr_31926_31952 = state_31922__$1;
(statearr_31926_31952[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31923 === (1))){
var inst_31891 = cljs.core.vec.call(null,chs);
var inst_31892 = inst_31891;
var state_31922__$1 = (function (){var statearr_31927 = state_31922;
(statearr_31927[(10)] = inst_31892);

return statearr_31927;
})();
var statearr_31928_31953 = state_31922__$1;
(statearr_31928_31953[(2)] = null);

(statearr_31928_31953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31923 === (4))){
var inst_31892 = (state_31922[(10)]);
var state_31922__$1 = state_31922;
return cljs.core.async.ioc_alts_BANG_.call(null,state_31922__$1,(7),inst_31892);
} else {
if((state_val_31923 === (6))){
var inst_31918 = (state_31922[(2)]);
var state_31922__$1 = state_31922;
var statearr_31929_31954 = state_31922__$1;
(statearr_31929_31954[(2)] = inst_31918);

(statearr_31929_31954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31923 === (3))){
var inst_31920 = (state_31922[(2)]);
var state_31922__$1 = state_31922;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31922__$1,inst_31920);
} else {
if((state_val_31923 === (2))){
var inst_31892 = (state_31922[(10)]);
var inst_31894 = cljs.core.count.call(null,inst_31892);
var inst_31895 = (inst_31894 > (0));
var state_31922__$1 = state_31922;
if(cljs.core.truth_(inst_31895)){
var statearr_31931_31955 = state_31922__$1;
(statearr_31931_31955[(1)] = (4));

} else {
var statearr_31932_31956 = state_31922__$1;
(statearr_31932_31956[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31923 === (11))){
var inst_31892 = (state_31922[(10)]);
var inst_31911 = (state_31922[(2)]);
var tmp31930 = inst_31892;
var inst_31892__$1 = tmp31930;
var state_31922__$1 = (function (){var statearr_31933 = state_31922;
(statearr_31933[(11)] = inst_31911);

(statearr_31933[(10)] = inst_31892__$1);

return statearr_31933;
})();
var statearr_31934_31957 = state_31922__$1;
(statearr_31934_31957[(2)] = null);

(statearr_31934_31957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31923 === (9))){
var inst_31902 = (state_31922[(7)]);
var state_31922__$1 = state_31922;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31922__$1,(11),out,inst_31902);
} else {
if((state_val_31923 === (5))){
var inst_31916 = cljs.core.async.close_BANG_.call(null,out);
var state_31922__$1 = state_31922;
var statearr_31935_31958 = state_31922__$1;
(statearr_31935_31958[(2)] = inst_31916);

(statearr_31935_31958[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31923 === (10))){
var inst_31914 = (state_31922[(2)]);
var state_31922__$1 = state_31922;
var statearr_31936_31959 = state_31922__$1;
(statearr_31936_31959[(2)] = inst_31914);

(statearr_31936_31959[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31923 === (8))){
var inst_31903 = (state_31922[(9)]);
var inst_31902 = (state_31922[(7)]);
var inst_31892 = (state_31922[(10)]);
var inst_31901 = (state_31922[(8)]);
var inst_31906 = (function (){var cs = inst_31892;
var vec__31897 = inst_31901;
var v = inst_31902;
var c = inst_31903;
return ((function (cs,vec__31897,v,c,inst_31903,inst_31902,inst_31892,inst_31901,state_val_31923,c__29816__auto___31950,out){
return (function (p1__31887_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__31887_SHARP_);
});
;})(cs,vec__31897,v,c,inst_31903,inst_31902,inst_31892,inst_31901,state_val_31923,c__29816__auto___31950,out))
})();
var inst_31907 = cljs.core.filterv.call(null,inst_31906,inst_31892);
var inst_31892__$1 = inst_31907;
var state_31922__$1 = (function (){var statearr_31937 = state_31922;
(statearr_31937[(10)] = inst_31892__$1);

return statearr_31937;
})();
var statearr_31938_31960 = state_31922__$1;
(statearr_31938_31960[(2)] = null);

(statearr_31938_31960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___31950,out))
;
return ((function (switch__29702__auto__,c__29816__auto___31950,out){
return (function() {
var cljs$core$async$state_machine__29703__auto__ = null;
var cljs$core$async$state_machine__29703__auto____0 = (function (){
var statearr_31942 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31942[(0)] = cljs$core$async$state_machine__29703__auto__);

(statearr_31942[(1)] = (1));

return statearr_31942;
});
var cljs$core$async$state_machine__29703__auto____1 = (function (state_31922){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_31922);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e31943){if((e31943 instanceof Object)){
var ex__29706__auto__ = e31943;
var statearr_31944_31961 = state_31922;
(statearr_31944_31961[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31922);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31943;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31962 = state_31922;
state_31922 = G__31962;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$state_machine__29703__auto__ = function(state_31922){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29703__auto____1.call(this,state_31922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29703__auto____0;
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29703__auto____1;
return cljs$core$async$state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___31950,out))
})();
var state__29818__auto__ = (function (){var statearr_31945 = f__29817__auto__.call(null);
(statearr_31945[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___31950);

return statearr_31945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___31950,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args31963 = [];
var len__27761__auto___32012 = arguments.length;
var i__27762__auto___32013 = (0);
while(true){
if((i__27762__auto___32013 < len__27761__auto___32012)){
args31963.push((arguments[i__27762__auto___32013]));

var G__32014 = (i__27762__auto___32013 + (1));
i__27762__auto___32013 = G__32014;
continue;
} else {
}
break;
}

var G__31965 = args31963.length;
switch (G__31965) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31963.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29816__auto___32016 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___32016,out){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___32016,out){
return (function (state_31989){
var state_val_31990 = (state_31989[(1)]);
if((state_val_31990 === (7))){
var inst_31971 = (state_31989[(7)]);
var inst_31971__$1 = (state_31989[(2)]);
var inst_31972 = (inst_31971__$1 == null);
var inst_31973 = cljs.core.not.call(null,inst_31972);
var state_31989__$1 = (function (){var statearr_31991 = state_31989;
(statearr_31991[(7)] = inst_31971__$1);

return statearr_31991;
})();
if(inst_31973){
var statearr_31992_32017 = state_31989__$1;
(statearr_31992_32017[(1)] = (8));

} else {
var statearr_31993_32018 = state_31989__$1;
(statearr_31993_32018[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31990 === (1))){
var inst_31966 = (0);
var state_31989__$1 = (function (){var statearr_31994 = state_31989;
(statearr_31994[(8)] = inst_31966);

return statearr_31994;
})();
var statearr_31995_32019 = state_31989__$1;
(statearr_31995_32019[(2)] = null);

(statearr_31995_32019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31990 === (4))){
var state_31989__$1 = state_31989;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31989__$1,(7),ch);
} else {
if((state_val_31990 === (6))){
var inst_31984 = (state_31989[(2)]);
var state_31989__$1 = state_31989;
var statearr_31996_32020 = state_31989__$1;
(statearr_31996_32020[(2)] = inst_31984);

(statearr_31996_32020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31990 === (3))){
var inst_31986 = (state_31989[(2)]);
var inst_31987 = cljs.core.async.close_BANG_.call(null,out);
var state_31989__$1 = (function (){var statearr_31997 = state_31989;
(statearr_31997[(9)] = inst_31986);

return statearr_31997;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31989__$1,inst_31987);
} else {
if((state_val_31990 === (2))){
var inst_31966 = (state_31989[(8)]);
var inst_31968 = (inst_31966 < n);
var state_31989__$1 = state_31989;
if(cljs.core.truth_(inst_31968)){
var statearr_31998_32021 = state_31989__$1;
(statearr_31998_32021[(1)] = (4));

} else {
var statearr_31999_32022 = state_31989__$1;
(statearr_31999_32022[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31990 === (11))){
var inst_31966 = (state_31989[(8)]);
var inst_31976 = (state_31989[(2)]);
var inst_31977 = (inst_31966 + (1));
var inst_31966__$1 = inst_31977;
var state_31989__$1 = (function (){var statearr_32000 = state_31989;
(statearr_32000[(10)] = inst_31976);

(statearr_32000[(8)] = inst_31966__$1);

return statearr_32000;
})();
var statearr_32001_32023 = state_31989__$1;
(statearr_32001_32023[(2)] = null);

(statearr_32001_32023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31990 === (9))){
var state_31989__$1 = state_31989;
var statearr_32002_32024 = state_31989__$1;
(statearr_32002_32024[(2)] = null);

(statearr_32002_32024[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31990 === (5))){
var state_31989__$1 = state_31989;
var statearr_32003_32025 = state_31989__$1;
(statearr_32003_32025[(2)] = null);

(statearr_32003_32025[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31990 === (10))){
var inst_31981 = (state_31989[(2)]);
var state_31989__$1 = state_31989;
var statearr_32004_32026 = state_31989__$1;
(statearr_32004_32026[(2)] = inst_31981);

(statearr_32004_32026[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31990 === (8))){
var inst_31971 = (state_31989[(7)]);
var state_31989__$1 = state_31989;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31989__$1,(11),out,inst_31971);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___32016,out))
;
return ((function (switch__29702__auto__,c__29816__auto___32016,out){
return (function() {
var cljs$core$async$state_machine__29703__auto__ = null;
var cljs$core$async$state_machine__29703__auto____0 = (function (){
var statearr_32008 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32008[(0)] = cljs$core$async$state_machine__29703__auto__);

(statearr_32008[(1)] = (1));

return statearr_32008;
});
var cljs$core$async$state_machine__29703__auto____1 = (function (state_31989){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_31989);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e32009){if((e32009 instanceof Object)){
var ex__29706__auto__ = e32009;
var statearr_32010_32027 = state_31989;
(statearr_32010_32027[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31989);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32009;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32028 = state_31989;
state_31989 = G__32028;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$state_machine__29703__auto__ = function(state_31989){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29703__auto____1.call(this,state_31989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29703__auto____0;
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29703__auto____1;
return cljs$core$async$state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___32016,out))
})();
var state__29818__auto__ = (function (){var statearr_32011 = f__29817__auto__.call(null);
(statearr_32011[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___32016);

return statearr_32011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___32016,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32036 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32036 = (function (map_LT_,f,ch,meta32037){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta32037 = meta32037;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32036.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32038,meta32037__$1){
var self__ = this;
var _32038__$1 = this;
return (new cljs.core.async.t_cljs$core$async32036(self__.map_LT_,self__.f,self__.ch,meta32037__$1));
});

cljs.core.async.t_cljs$core$async32036.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32038){
var self__ = this;
var _32038__$1 = this;
return self__.meta32037;
});

cljs.core.async.t_cljs$core$async32036.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async32036.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32036.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32036.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async32036.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async32039 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32039 = (function (map_LT_,f,ch,meta32037,_,fn1,meta32040){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta32037 = meta32037;
this._ = _;
this.fn1 = fn1;
this.meta32040 = meta32040;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32039.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_32041,meta32040__$1){
var self__ = this;
var _32041__$1 = this;
return (new cljs.core.async.t_cljs$core$async32039(self__.map_LT_,self__.f,self__.ch,self__.meta32037,self__._,self__.fn1,meta32040__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async32039.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_32041){
var self__ = this;
var _32041__$1 = this;
return self__.meta32040;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32039.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async32039.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32039.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32039.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32029_SHARP_){
return f1.call(null,(((p1__32029_SHARP_ == null))?null:self__.f.call(null,p1__32029_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async32039.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32037","meta32037",2047145690,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32036","cljs.core.async/t_cljs$core$async32036",-1391941670,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32040","meta32040",721592877,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32039.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32039.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32039";

cljs.core.async.t_cljs$core$async32039.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27230__auto__,writer__27231__auto__,opt__27232__auto__){
return cljs.core._write.call(null,writer__27231__auto__,"cljs.core.async/t_cljs$core$async32039");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async32039 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32039(map_LT___$1,f__$1,ch__$1,meta32037__$1,___$2,fn1__$1,meta32040){
return (new cljs.core.async.t_cljs$core$async32039(map_LT___$1,f__$1,ch__$1,meta32037__$1,___$2,fn1__$1,meta32040));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async32039(self__.map_LT_,self__.f,self__.ch,self__.meta32037,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__26566__auto__ = ret;
if(cljs.core.truth_(and__26566__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__26566__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async32036.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async32036.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async32036.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32037","meta32037",2047145690,null)], null);
});

cljs.core.async.t_cljs$core$async32036.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32036.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32036";

cljs.core.async.t_cljs$core$async32036.cljs$lang$ctorPrWriter = (function (this__27230__auto__,writer__27231__auto__,opt__27232__auto__){
return cljs.core._write.call(null,writer__27231__auto__,"cljs.core.async/t_cljs$core$async32036");
});

cljs.core.async.__GT_t_cljs$core$async32036 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32036(map_LT___$1,f__$1,ch__$1,meta32037){
return (new cljs.core.async.t_cljs$core$async32036(map_LT___$1,f__$1,ch__$1,meta32037));
});

}

return (new cljs.core.async.t_cljs$core$async32036(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32045 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32045 = (function (map_GT_,f,ch,meta32046){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta32046 = meta32046;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32045.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32047,meta32046__$1){
var self__ = this;
var _32047__$1 = this;
return (new cljs.core.async.t_cljs$core$async32045(self__.map_GT_,self__.f,self__.ch,meta32046__$1));
});

cljs.core.async.t_cljs$core$async32045.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32047){
var self__ = this;
var _32047__$1 = this;
return self__.meta32046;
});

cljs.core.async.t_cljs$core$async32045.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async32045.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32045.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async32045.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32045.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async32045.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async32045.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32046","meta32046",-2061605192,null)], null);
});

cljs.core.async.t_cljs$core$async32045.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32045.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32045";

cljs.core.async.t_cljs$core$async32045.cljs$lang$ctorPrWriter = (function (this__27230__auto__,writer__27231__auto__,opt__27232__auto__){
return cljs.core._write.call(null,writer__27231__auto__,"cljs.core.async/t_cljs$core$async32045");
});

cljs.core.async.__GT_t_cljs$core$async32045 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32045(map_GT___$1,f__$1,ch__$1,meta32046){
return (new cljs.core.async.t_cljs$core$async32045(map_GT___$1,f__$1,ch__$1,meta32046));
});

}

return (new cljs.core.async.t_cljs$core$async32045(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async32051 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32051 = (function (filter_GT_,p,ch,meta32052){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta32052 = meta32052;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32051.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32053,meta32052__$1){
var self__ = this;
var _32053__$1 = this;
return (new cljs.core.async.t_cljs$core$async32051(self__.filter_GT_,self__.p,self__.ch,meta32052__$1));
});

cljs.core.async.t_cljs$core$async32051.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32053){
var self__ = this;
var _32053__$1 = this;
return self__.meta32052;
});

cljs.core.async.t_cljs$core$async32051.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async32051.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32051.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32051.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async32051.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32051.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async32051.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async32051.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32052","meta32052",1744387682,null)], null);
});

cljs.core.async.t_cljs$core$async32051.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32051.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32051";

cljs.core.async.t_cljs$core$async32051.cljs$lang$ctorPrWriter = (function (this__27230__auto__,writer__27231__auto__,opt__27232__auto__){
return cljs.core._write.call(null,writer__27231__auto__,"cljs.core.async/t_cljs$core$async32051");
});

cljs.core.async.__GT_t_cljs$core$async32051 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32051(filter_GT___$1,p__$1,ch__$1,meta32052){
return (new cljs.core.async.t_cljs$core$async32051(filter_GT___$1,p__$1,ch__$1,meta32052));
});

}

return (new cljs.core.async.t_cljs$core$async32051(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args32054 = [];
var len__27761__auto___32098 = arguments.length;
var i__27762__auto___32099 = (0);
while(true){
if((i__27762__auto___32099 < len__27761__auto___32098)){
args32054.push((arguments[i__27762__auto___32099]));

var G__32100 = (i__27762__auto___32099 + (1));
i__27762__auto___32099 = G__32100;
continue;
} else {
}
break;
}

var G__32056 = args32054.length;
switch (G__32056) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32054.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29816__auto___32102 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___32102,out){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___32102,out){
return (function (state_32077){
var state_val_32078 = (state_32077[(1)]);
if((state_val_32078 === (7))){
var inst_32073 = (state_32077[(2)]);
var state_32077__$1 = state_32077;
var statearr_32079_32103 = state_32077__$1;
(statearr_32079_32103[(2)] = inst_32073);

(statearr_32079_32103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (1))){
var state_32077__$1 = state_32077;
var statearr_32080_32104 = state_32077__$1;
(statearr_32080_32104[(2)] = null);

(statearr_32080_32104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (4))){
var inst_32059 = (state_32077[(7)]);
var inst_32059__$1 = (state_32077[(2)]);
var inst_32060 = (inst_32059__$1 == null);
var state_32077__$1 = (function (){var statearr_32081 = state_32077;
(statearr_32081[(7)] = inst_32059__$1);

return statearr_32081;
})();
if(cljs.core.truth_(inst_32060)){
var statearr_32082_32105 = state_32077__$1;
(statearr_32082_32105[(1)] = (5));

} else {
var statearr_32083_32106 = state_32077__$1;
(statearr_32083_32106[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (6))){
var inst_32059 = (state_32077[(7)]);
var inst_32064 = p.call(null,inst_32059);
var state_32077__$1 = state_32077;
if(cljs.core.truth_(inst_32064)){
var statearr_32084_32107 = state_32077__$1;
(statearr_32084_32107[(1)] = (8));

} else {
var statearr_32085_32108 = state_32077__$1;
(statearr_32085_32108[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (3))){
var inst_32075 = (state_32077[(2)]);
var state_32077__$1 = state_32077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32077__$1,inst_32075);
} else {
if((state_val_32078 === (2))){
var state_32077__$1 = state_32077;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32077__$1,(4),ch);
} else {
if((state_val_32078 === (11))){
var inst_32067 = (state_32077[(2)]);
var state_32077__$1 = state_32077;
var statearr_32086_32109 = state_32077__$1;
(statearr_32086_32109[(2)] = inst_32067);

(statearr_32086_32109[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (9))){
var state_32077__$1 = state_32077;
var statearr_32087_32110 = state_32077__$1;
(statearr_32087_32110[(2)] = null);

(statearr_32087_32110[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (5))){
var inst_32062 = cljs.core.async.close_BANG_.call(null,out);
var state_32077__$1 = state_32077;
var statearr_32088_32111 = state_32077__$1;
(statearr_32088_32111[(2)] = inst_32062);

(statearr_32088_32111[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (10))){
var inst_32070 = (state_32077[(2)]);
var state_32077__$1 = (function (){var statearr_32089 = state_32077;
(statearr_32089[(8)] = inst_32070);

return statearr_32089;
})();
var statearr_32090_32112 = state_32077__$1;
(statearr_32090_32112[(2)] = null);

(statearr_32090_32112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (8))){
var inst_32059 = (state_32077[(7)]);
var state_32077__$1 = state_32077;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32077__$1,(11),out,inst_32059);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___32102,out))
;
return ((function (switch__29702__auto__,c__29816__auto___32102,out){
return (function() {
var cljs$core$async$state_machine__29703__auto__ = null;
var cljs$core$async$state_machine__29703__auto____0 = (function (){
var statearr_32094 = [null,null,null,null,null,null,null,null,null];
(statearr_32094[(0)] = cljs$core$async$state_machine__29703__auto__);

(statearr_32094[(1)] = (1));

return statearr_32094;
});
var cljs$core$async$state_machine__29703__auto____1 = (function (state_32077){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_32077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e32095){if((e32095 instanceof Object)){
var ex__29706__auto__ = e32095;
var statearr_32096_32113 = state_32077;
(statearr_32096_32113[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32077);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32095;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32114 = state_32077;
state_32077 = G__32114;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$state_machine__29703__auto__ = function(state_32077){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29703__auto____1.call(this,state_32077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29703__auto____0;
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29703__auto____1;
return cljs$core$async$state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___32102,out))
})();
var state__29818__auto__ = (function (){var statearr_32097 = f__29817__auto__.call(null);
(statearr_32097[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___32102);

return statearr_32097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___32102,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args32115 = [];
var len__27761__auto___32118 = arguments.length;
var i__27762__auto___32119 = (0);
while(true){
if((i__27762__auto___32119 < len__27761__auto___32118)){
args32115.push((arguments[i__27762__auto___32119]));

var G__32120 = (i__27762__auto___32119 + (1));
i__27762__auto___32119 = G__32120;
continue;
} else {
}
break;
}

var G__32117 = args32115.length;
switch (G__32117) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32115.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__29816__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto__){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto__){
return (function (state_32287){
var state_val_32288 = (state_32287[(1)]);
if((state_val_32288 === (7))){
var inst_32283 = (state_32287[(2)]);
var state_32287__$1 = state_32287;
var statearr_32289_32330 = state_32287__$1;
(statearr_32289_32330[(2)] = inst_32283);

(statearr_32289_32330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (20))){
var inst_32253 = (state_32287[(7)]);
var inst_32264 = (state_32287[(2)]);
var inst_32265 = cljs.core.next.call(null,inst_32253);
var inst_32239 = inst_32265;
var inst_32240 = null;
var inst_32241 = (0);
var inst_32242 = (0);
var state_32287__$1 = (function (){var statearr_32290 = state_32287;
(statearr_32290[(8)] = inst_32242);

(statearr_32290[(9)] = inst_32240);

(statearr_32290[(10)] = inst_32241);

(statearr_32290[(11)] = inst_32239);

(statearr_32290[(12)] = inst_32264);

return statearr_32290;
})();
var statearr_32291_32331 = state_32287__$1;
(statearr_32291_32331[(2)] = null);

(statearr_32291_32331[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (1))){
var state_32287__$1 = state_32287;
var statearr_32292_32332 = state_32287__$1;
(statearr_32292_32332[(2)] = null);

(statearr_32292_32332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (4))){
var inst_32228 = (state_32287[(13)]);
var inst_32228__$1 = (state_32287[(2)]);
var inst_32229 = (inst_32228__$1 == null);
var state_32287__$1 = (function (){var statearr_32293 = state_32287;
(statearr_32293[(13)] = inst_32228__$1);

return statearr_32293;
})();
if(cljs.core.truth_(inst_32229)){
var statearr_32294_32333 = state_32287__$1;
(statearr_32294_32333[(1)] = (5));

} else {
var statearr_32295_32334 = state_32287__$1;
(statearr_32295_32334[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (15))){
var state_32287__$1 = state_32287;
var statearr_32299_32335 = state_32287__$1;
(statearr_32299_32335[(2)] = null);

(statearr_32299_32335[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (21))){
var state_32287__$1 = state_32287;
var statearr_32300_32336 = state_32287__$1;
(statearr_32300_32336[(2)] = null);

(statearr_32300_32336[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (13))){
var inst_32242 = (state_32287[(8)]);
var inst_32240 = (state_32287[(9)]);
var inst_32241 = (state_32287[(10)]);
var inst_32239 = (state_32287[(11)]);
var inst_32249 = (state_32287[(2)]);
var inst_32250 = (inst_32242 + (1));
var tmp32296 = inst_32240;
var tmp32297 = inst_32241;
var tmp32298 = inst_32239;
var inst_32239__$1 = tmp32298;
var inst_32240__$1 = tmp32296;
var inst_32241__$1 = tmp32297;
var inst_32242__$1 = inst_32250;
var state_32287__$1 = (function (){var statearr_32301 = state_32287;
(statearr_32301[(8)] = inst_32242__$1);

(statearr_32301[(9)] = inst_32240__$1);

(statearr_32301[(14)] = inst_32249);

(statearr_32301[(10)] = inst_32241__$1);

(statearr_32301[(11)] = inst_32239__$1);

return statearr_32301;
})();
var statearr_32302_32337 = state_32287__$1;
(statearr_32302_32337[(2)] = null);

(statearr_32302_32337[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (22))){
var state_32287__$1 = state_32287;
var statearr_32303_32338 = state_32287__$1;
(statearr_32303_32338[(2)] = null);

(statearr_32303_32338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (6))){
var inst_32228 = (state_32287[(13)]);
var inst_32237 = f.call(null,inst_32228);
var inst_32238 = cljs.core.seq.call(null,inst_32237);
var inst_32239 = inst_32238;
var inst_32240 = null;
var inst_32241 = (0);
var inst_32242 = (0);
var state_32287__$1 = (function (){var statearr_32304 = state_32287;
(statearr_32304[(8)] = inst_32242);

(statearr_32304[(9)] = inst_32240);

(statearr_32304[(10)] = inst_32241);

(statearr_32304[(11)] = inst_32239);

return statearr_32304;
})();
var statearr_32305_32339 = state_32287__$1;
(statearr_32305_32339[(2)] = null);

(statearr_32305_32339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (17))){
var inst_32253 = (state_32287[(7)]);
var inst_32257 = cljs.core.chunk_first.call(null,inst_32253);
var inst_32258 = cljs.core.chunk_rest.call(null,inst_32253);
var inst_32259 = cljs.core.count.call(null,inst_32257);
var inst_32239 = inst_32258;
var inst_32240 = inst_32257;
var inst_32241 = inst_32259;
var inst_32242 = (0);
var state_32287__$1 = (function (){var statearr_32306 = state_32287;
(statearr_32306[(8)] = inst_32242);

(statearr_32306[(9)] = inst_32240);

(statearr_32306[(10)] = inst_32241);

(statearr_32306[(11)] = inst_32239);

return statearr_32306;
})();
var statearr_32307_32340 = state_32287__$1;
(statearr_32307_32340[(2)] = null);

(statearr_32307_32340[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (3))){
var inst_32285 = (state_32287[(2)]);
var state_32287__$1 = state_32287;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32287__$1,inst_32285);
} else {
if((state_val_32288 === (12))){
var inst_32273 = (state_32287[(2)]);
var state_32287__$1 = state_32287;
var statearr_32308_32341 = state_32287__$1;
(statearr_32308_32341[(2)] = inst_32273);

(statearr_32308_32341[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (2))){
var state_32287__$1 = state_32287;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32287__$1,(4),in$);
} else {
if((state_val_32288 === (23))){
var inst_32281 = (state_32287[(2)]);
var state_32287__$1 = state_32287;
var statearr_32309_32342 = state_32287__$1;
(statearr_32309_32342[(2)] = inst_32281);

(statearr_32309_32342[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (19))){
var inst_32268 = (state_32287[(2)]);
var state_32287__$1 = state_32287;
var statearr_32310_32343 = state_32287__$1;
(statearr_32310_32343[(2)] = inst_32268);

(statearr_32310_32343[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (11))){
var inst_32253 = (state_32287[(7)]);
var inst_32239 = (state_32287[(11)]);
var inst_32253__$1 = cljs.core.seq.call(null,inst_32239);
var state_32287__$1 = (function (){var statearr_32311 = state_32287;
(statearr_32311[(7)] = inst_32253__$1);

return statearr_32311;
})();
if(inst_32253__$1){
var statearr_32312_32344 = state_32287__$1;
(statearr_32312_32344[(1)] = (14));

} else {
var statearr_32313_32345 = state_32287__$1;
(statearr_32313_32345[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (9))){
var inst_32275 = (state_32287[(2)]);
var inst_32276 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_32287__$1 = (function (){var statearr_32314 = state_32287;
(statearr_32314[(15)] = inst_32275);

return statearr_32314;
})();
if(cljs.core.truth_(inst_32276)){
var statearr_32315_32346 = state_32287__$1;
(statearr_32315_32346[(1)] = (21));

} else {
var statearr_32316_32347 = state_32287__$1;
(statearr_32316_32347[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (5))){
var inst_32231 = cljs.core.async.close_BANG_.call(null,out);
var state_32287__$1 = state_32287;
var statearr_32317_32348 = state_32287__$1;
(statearr_32317_32348[(2)] = inst_32231);

(statearr_32317_32348[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (14))){
var inst_32253 = (state_32287[(7)]);
var inst_32255 = cljs.core.chunked_seq_QMARK_.call(null,inst_32253);
var state_32287__$1 = state_32287;
if(inst_32255){
var statearr_32318_32349 = state_32287__$1;
(statearr_32318_32349[(1)] = (17));

} else {
var statearr_32319_32350 = state_32287__$1;
(statearr_32319_32350[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (16))){
var inst_32271 = (state_32287[(2)]);
var state_32287__$1 = state_32287;
var statearr_32320_32351 = state_32287__$1;
(statearr_32320_32351[(2)] = inst_32271);

(statearr_32320_32351[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32288 === (10))){
var inst_32242 = (state_32287[(8)]);
var inst_32240 = (state_32287[(9)]);
var inst_32247 = cljs.core._nth.call(null,inst_32240,inst_32242);
var state_32287__$1 = state_32287;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32287__$1,(13),out,inst_32247);
} else {
if((state_val_32288 === (18))){
var inst_32253 = (state_32287[(7)]);
var inst_32262 = cljs.core.first.call(null,inst_32253);
var state_32287__$1 = state_32287;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32287__$1,(20),out,inst_32262);
} else {
if((state_val_32288 === (8))){
var inst_32242 = (state_32287[(8)]);
var inst_32241 = (state_32287[(10)]);
var inst_32244 = (inst_32242 < inst_32241);
var inst_32245 = inst_32244;
var state_32287__$1 = state_32287;
if(cljs.core.truth_(inst_32245)){
var statearr_32321_32352 = state_32287__$1;
(statearr_32321_32352[(1)] = (10));

} else {
var statearr_32322_32353 = state_32287__$1;
(statearr_32322_32353[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto__))
;
return ((function (switch__29702__auto__,c__29816__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29703__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29703__auto____0 = (function (){
var statearr_32326 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32326[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29703__auto__);

(statearr_32326[(1)] = (1));

return statearr_32326;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29703__auto____1 = (function (state_32287){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_32287);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e32327){if((e32327 instanceof Object)){
var ex__29706__auto__ = e32327;
var statearr_32328_32354 = state_32287;
(statearr_32328_32354[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32287);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32327;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32355 = state_32287;
state_32287 = G__32355;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29703__auto__ = function(state_32287){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29703__auto____1.call(this,state_32287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29703__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29703__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto__))
})();
var state__29818__auto__ = (function (){var statearr_32329 = f__29817__auto__.call(null);
(statearr_32329[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto__);

return statearr_32329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto__))
);

return c__29816__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args32356 = [];
var len__27761__auto___32359 = arguments.length;
var i__27762__auto___32360 = (0);
while(true){
if((i__27762__auto___32360 < len__27761__auto___32359)){
args32356.push((arguments[i__27762__auto___32360]));

var G__32361 = (i__27762__auto___32360 + (1));
i__27762__auto___32360 = G__32361;
continue;
} else {
}
break;
}

var G__32358 = args32356.length;
switch (G__32358) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32356.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args32363 = [];
var len__27761__auto___32366 = arguments.length;
var i__27762__auto___32367 = (0);
while(true){
if((i__27762__auto___32367 < len__27761__auto___32366)){
args32363.push((arguments[i__27762__auto___32367]));

var G__32368 = (i__27762__auto___32367 + (1));
i__27762__auto___32367 = G__32368;
continue;
} else {
}
break;
}

var G__32365 = args32363.length;
switch (G__32365) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32363.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args32370 = [];
var len__27761__auto___32421 = arguments.length;
var i__27762__auto___32422 = (0);
while(true){
if((i__27762__auto___32422 < len__27761__auto___32421)){
args32370.push((arguments[i__27762__auto___32422]));

var G__32423 = (i__27762__auto___32422 + (1));
i__27762__auto___32422 = G__32423;
continue;
} else {
}
break;
}

var G__32372 = args32370.length;
switch (G__32372) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32370.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29816__auto___32425 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___32425,out){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___32425,out){
return (function (state_32396){
var state_val_32397 = (state_32396[(1)]);
if((state_val_32397 === (7))){
var inst_32391 = (state_32396[(2)]);
var state_32396__$1 = state_32396;
var statearr_32398_32426 = state_32396__$1;
(statearr_32398_32426[(2)] = inst_32391);

(statearr_32398_32426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32397 === (1))){
var inst_32373 = null;
var state_32396__$1 = (function (){var statearr_32399 = state_32396;
(statearr_32399[(7)] = inst_32373);

return statearr_32399;
})();
var statearr_32400_32427 = state_32396__$1;
(statearr_32400_32427[(2)] = null);

(statearr_32400_32427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32397 === (4))){
var inst_32376 = (state_32396[(8)]);
var inst_32376__$1 = (state_32396[(2)]);
var inst_32377 = (inst_32376__$1 == null);
var inst_32378 = cljs.core.not.call(null,inst_32377);
var state_32396__$1 = (function (){var statearr_32401 = state_32396;
(statearr_32401[(8)] = inst_32376__$1);

return statearr_32401;
})();
if(inst_32378){
var statearr_32402_32428 = state_32396__$1;
(statearr_32402_32428[(1)] = (5));

} else {
var statearr_32403_32429 = state_32396__$1;
(statearr_32403_32429[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32397 === (6))){
var state_32396__$1 = state_32396;
var statearr_32404_32430 = state_32396__$1;
(statearr_32404_32430[(2)] = null);

(statearr_32404_32430[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32397 === (3))){
var inst_32393 = (state_32396[(2)]);
var inst_32394 = cljs.core.async.close_BANG_.call(null,out);
var state_32396__$1 = (function (){var statearr_32405 = state_32396;
(statearr_32405[(9)] = inst_32393);

return statearr_32405;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32396__$1,inst_32394);
} else {
if((state_val_32397 === (2))){
var state_32396__$1 = state_32396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32396__$1,(4),ch);
} else {
if((state_val_32397 === (11))){
var inst_32376 = (state_32396[(8)]);
var inst_32385 = (state_32396[(2)]);
var inst_32373 = inst_32376;
var state_32396__$1 = (function (){var statearr_32406 = state_32396;
(statearr_32406[(7)] = inst_32373);

(statearr_32406[(10)] = inst_32385);

return statearr_32406;
})();
var statearr_32407_32431 = state_32396__$1;
(statearr_32407_32431[(2)] = null);

(statearr_32407_32431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32397 === (9))){
var inst_32376 = (state_32396[(8)]);
var state_32396__$1 = state_32396;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32396__$1,(11),out,inst_32376);
} else {
if((state_val_32397 === (5))){
var inst_32373 = (state_32396[(7)]);
var inst_32376 = (state_32396[(8)]);
var inst_32380 = cljs.core._EQ_.call(null,inst_32376,inst_32373);
var state_32396__$1 = state_32396;
if(inst_32380){
var statearr_32409_32432 = state_32396__$1;
(statearr_32409_32432[(1)] = (8));

} else {
var statearr_32410_32433 = state_32396__$1;
(statearr_32410_32433[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32397 === (10))){
var inst_32388 = (state_32396[(2)]);
var state_32396__$1 = state_32396;
var statearr_32411_32434 = state_32396__$1;
(statearr_32411_32434[(2)] = inst_32388);

(statearr_32411_32434[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32397 === (8))){
var inst_32373 = (state_32396[(7)]);
var tmp32408 = inst_32373;
var inst_32373__$1 = tmp32408;
var state_32396__$1 = (function (){var statearr_32412 = state_32396;
(statearr_32412[(7)] = inst_32373__$1);

return statearr_32412;
})();
var statearr_32413_32435 = state_32396__$1;
(statearr_32413_32435[(2)] = null);

(statearr_32413_32435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___32425,out))
;
return ((function (switch__29702__auto__,c__29816__auto___32425,out){
return (function() {
var cljs$core$async$state_machine__29703__auto__ = null;
var cljs$core$async$state_machine__29703__auto____0 = (function (){
var statearr_32417 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32417[(0)] = cljs$core$async$state_machine__29703__auto__);

(statearr_32417[(1)] = (1));

return statearr_32417;
});
var cljs$core$async$state_machine__29703__auto____1 = (function (state_32396){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_32396);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e32418){if((e32418 instanceof Object)){
var ex__29706__auto__ = e32418;
var statearr_32419_32436 = state_32396;
(statearr_32419_32436[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32396);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32418;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32437 = state_32396;
state_32396 = G__32437;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$state_machine__29703__auto__ = function(state_32396){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29703__auto____1.call(this,state_32396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29703__auto____0;
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29703__auto____1;
return cljs$core$async$state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___32425,out))
})();
var state__29818__auto__ = (function (){var statearr_32420 = f__29817__auto__.call(null);
(statearr_32420[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___32425);

return statearr_32420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___32425,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args32438 = [];
var len__27761__auto___32508 = arguments.length;
var i__27762__auto___32509 = (0);
while(true){
if((i__27762__auto___32509 < len__27761__auto___32508)){
args32438.push((arguments[i__27762__auto___32509]));

var G__32510 = (i__27762__auto___32509 + (1));
i__27762__auto___32509 = G__32510;
continue;
} else {
}
break;
}

var G__32440 = args32438.length;
switch (G__32440) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32438.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29816__auto___32512 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___32512,out){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___32512,out){
return (function (state_32478){
var state_val_32479 = (state_32478[(1)]);
if((state_val_32479 === (7))){
var inst_32474 = (state_32478[(2)]);
var state_32478__$1 = state_32478;
var statearr_32480_32513 = state_32478__$1;
(statearr_32480_32513[(2)] = inst_32474);

(statearr_32480_32513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32479 === (1))){
var inst_32441 = (new Array(n));
var inst_32442 = inst_32441;
var inst_32443 = (0);
var state_32478__$1 = (function (){var statearr_32481 = state_32478;
(statearr_32481[(7)] = inst_32442);

(statearr_32481[(8)] = inst_32443);

return statearr_32481;
})();
var statearr_32482_32514 = state_32478__$1;
(statearr_32482_32514[(2)] = null);

(statearr_32482_32514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32479 === (4))){
var inst_32446 = (state_32478[(9)]);
var inst_32446__$1 = (state_32478[(2)]);
var inst_32447 = (inst_32446__$1 == null);
var inst_32448 = cljs.core.not.call(null,inst_32447);
var state_32478__$1 = (function (){var statearr_32483 = state_32478;
(statearr_32483[(9)] = inst_32446__$1);

return statearr_32483;
})();
if(inst_32448){
var statearr_32484_32515 = state_32478__$1;
(statearr_32484_32515[(1)] = (5));

} else {
var statearr_32485_32516 = state_32478__$1;
(statearr_32485_32516[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32479 === (15))){
var inst_32468 = (state_32478[(2)]);
var state_32478__$1 = state_32478;
var statearr_32486_32517 = state_32478__$1;
(statearr_32486_32517[(2)] = inst_32468);

(statearr_32486_32517[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32479 === (13))){
var state_32478__$1 = state_32478;
var statearr_32487_32518 = state_32478__$1;
(statearr_32487_32518[(2)] = null);

(statearr_32487_32518[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32479 === (6))){
var inst_32443 = (state_32478[(8)]);
var inst_32464 = (inst_32443 > (0));
var state_32478__$1 = state_32478;
if(cljs.core.truth_(inst_32464)){
var statearr_32488_32519 = state_32478__$1;
(statearr_32488_32519[(1)] = (12));

} else {
var statearr_32489_32520 = state_32478__$1;
(statearr_32489_32520[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32479 === (3))){
var inst_32476 = (state_32478[(2)]);
var state_32478__$1 = state_32478;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32478__$1,inst_32476);
} else {
if((state_val_32479 === (12))){
var inst_32442 = (state_32478[(7)]);
var inst_32466 = cljs.core.vec.call(null,inst_32442);
var state_32478__$1 = state_32478;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32478__$1,(15),out,inst_32466);
} else {
if((state_val_32479 === (2))){
var state_32478__$1 = state_32478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32478__$1,(4),ch);
} else {
if((state_val_32479 === (11))){
var inst_32458 = (state_32478[(2)]);
var inst_32459 = (new Array(n));
var inst_32442 = inst_32459;
var inst_32443 = (0);
var state_32478__$1 = (function (){var statearr_32490 = state_32478;
(statearr_32490[(10)] = inst_32458);

(statearr_32490[(7)] = inst_32442);

(statearr_32490[(8)] = inst_32443);

return statearr_32490;
})();
var statearr_32491_32521 = state_32478__$1;
(statearr_32491_32521[(2)] = null);

(statearr_32491_32521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32479 === (9))){
var inst_32442 = (state_32478[(7)]);
var inst_32456 = cljs.core.vec.call(null,inst_32442);
var state_32478__$1 = state_32478;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32478__$1,(11),out,inst_32456);
} else {
if((state_val_32479 === (5))){
var inst_32442 = (state_32478[(7)]);
var inst_32446 = (state_32478[(9)]);
var inst_32451 = (state_32478[(11)]);
var inst_32443 = (state_32478[(8)]);
var inst_32450 = (inst_32442[inst_32443] = inst_32446);
var inst_32451__$1 = (inst_32443 + (1));
var inst_32452 = (inst_32451__$1 < n);
var state_32478__$1 = (function (){var statearr_32492 = state_32478;
(statearr_32492[(11)] = inst_32451__$1);

(statearr_32492[(12)] = inst_32450);

return statearr_32492;
})();
if(cljs.core.truth_(inst_32452)){
var statearr_32493_32522 = state_32478__$1;
(statearr_32493_32522[(1)] = (8));

} else {
var statearr_32494_32523 = state_32478__$1;
(statearr_32494_32523[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32479 === (14))){
var inst_32471 = (state_32478[(2)]);
var inst_32472 = cljs.core.async.close_BANG_.call(null,out);
var state_32478__$1 = (function (){var statearr_32496 = state_32478;
(statearr_32496[(13)] = inst_32471);

return statearr_32496;
})();
var statearr_32497_32524 = state_32478__$1;
(statearr_32497_32524[(2)] = inst_32472);

(statearr_32497_32524[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32479 === (10))){
var inst_32462 = (state_32478[(2)]);
var state_32478__$1 = state_32478;
var statearr_32498_32525 = state_32478__$1;
(statearr_32498_32525[(2)] = inst_32462);

(statearr_32498_32525[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32479 === (8))){
var inst_32442 = (state_32478[(7)]);
var inst_32451 = (state_32478[(11)]);
var tmp32495 = inst_32442;
var inst_32442__$1 = tmp32495;
var inst_32443 = inst_32451;
var state_32478__$1 = (function (){var statearr_32499 = state_32478;
(statearr_32499[(7)] = inst_32442__$1);

(statearr_32499[(8)] = inst_32443);

return statearr_32499;
})();
var statearr_32500_32526 = state_32478__$1;
(statearr_32500_32526[(2)] = null);

(statearr_32500_32526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___32512,out))
;
return ((function (switch__29702__auto__,c__29816__auto___32512,out){
return (function() {
var cljs$core$async$state_machine__29703__auto__ = null;
var cljs$core$async$state_machine__29703__auto____0 = (function (){
var statearr_32504 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32504[(0)] = cljs$core$async$state_machine__29703__auto__);

(statearr_32504[(1)] = (1));

return statearr_32504;
});
var cljs$core$async$state_machine__29703__auto____1 = (function (state_32478){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_32478);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e32505){if((e32505 instanceof Object)){
var ex__29706__auto__ = e32505;
var statearr_32506_32527 = state_32478;
(statearr_32506_32527[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32478);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32505;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32528 = state_32478;
state_32478 = G__32528;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$state_machine__29703__auto__ = function(state_32478){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29703__auto____1.call(this,state_32478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29703__auto____0;
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29703__auto____1;
return cljs$core$async$state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___32512,out))
})();
var state__29818__auto__ = (function (){var statearr_32507 = f__29817__auto__.call(null);
(statearr_32507[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___32512);

return statearr_32507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___32512,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args32529 = [];
var len__27761__auto___32603 = arguments.length;
var i__27762__auto___32604 = (0);
while(true){
if((i__27762__auto___32604 < len__27761__auto___32603)){
args32529.push((arguments[i__27762__auto___32604]));

var G__32605 = (i__27762__auto___32604 + (1));
i__27762__auto___32604 = G__32605;
continue;
} else {
}
break;
}

var G__32531 = args32529.length;
switch (G__32531) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32529.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29816__auto___32607 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29816__auto___32607,out){
return (function (){
var f__29817__auto__ = (function (){var switch__29702__auto__ = ((function (c__29816__auto___32607,out){
return (function (state_32573){
var state_val_32574 = (state_32573[(1)]);
if((state_val_32574 === (7))){
var inst_32569 = (state_32573[(2)]);
var state_32573__$1 = state_32573;
var statearr_32575_32608 = state_32573__$1;
(statearr_32575_32608[(2)] = inst_32569);

(statearr_32575_32608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32574 === (1))){
var inst_32532 = [];
var inst_32533 = inst_32532;
var inst_32534 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32573__$1 = (function (){var statearr_32576 = state_32573;
(statearr_32576[(7)] = inst_32534);

(statearr_32576[(8)] = inst_32533);

return statearr_32576;
})();
var statearr_32577_32609 = state_32573__$1;
(statearr_32577_32609[(2)] = null);

(statearr_32577_32609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32574 === (4))){
var inst_32537 = (state_32573[(9)]);
var inst_32537__$1 = (state_32573[(2)]);
var inst_32538 = (inst_32537__$1 == null);
var inst_32539 = cljs.core.not.call(null,inst_32538);
var state_32573__$1 = (function (){var statearr_32578 = state_32573;
(statearr_32578[(9)] = inst_32537__$1);

return statearr_32578;
})();
if(inst_32539){
var statearr_32579_32610 = state_32573__$1;
(statearr_32579_32610[(1)] = (5));

} else {
var statearr_32580_32611 = state_32573__$1;
(statearr_32580_32611[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32574 === (15))){
var inst_32563 = (state_32573[(2)]);
var state_32573__$1 = state_32573;
var statearr_32581_32612 = state_32573__$1;
(statearr_32581_32612[(2)] = inst_32563);

(statearr_32581_32612[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32574 === (13))){
var state_32573__$1 = state_32573;
var statearr_32582_32613 = state_32573__$1;
(statearr_32582_32613[(2)] = null);

(statearr_32582_32613[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32574 === (6))){
var inst_32533 = (state_32573[(8)]);
var inst_32558 = inst_32533.length;
var inst_32559 = (inst_32558 > (0));
var state_32573__$1 = state_32573;
if(cljs.core.truth_(inst_32559)){
var statearr_32583_32614 = state_32573__$1;
(statearr_32583_32614[(1)] = (12));

} else {
var statearr_32584_32615 = state_32573__$1;
(statearr_32584_32615[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32574 === (3))){
var inst_32571 = (state_32573[(2)]);
var state_32573__$1 = state_32573;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32573__$1,inst_32571);
} else {
if((state_val_32574 === (12))){
var inst_32533 = (state_32573[(8)]);
var inst_32561 = cljs.core.vec.call(null,inst_32533);
var state_32573__$1 = state_32573;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32573__$1,(15),out,inst_32561);
} else {
if((state_val_32574 === (2))){
var state_32573__$1 = state_32573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32573__$1,(4),ch);
} else {
if((state_val_32574 === (11))){
var inst_32537 = (state_32573[(9)]);
var inst_32541 = (state_32573[(10)]);
var inst_32551 = (state_32573[(2)]);
var inst_32552 = [];
var inst_32553 = inst_32552.push(inst_32537);
var inst_32533 = inst_32552;
var inst_32534 = inst_32541;
var state_32573__$1 = (function (){var statearr_32585 = state_32573;
(statearr_32585[(7)] = inst_32534);

(statearr_32585[(11)] = inst_32551);

(statearr_32585[(8)] = inst_32533);

(statearr_32585[(12)] = inst_32553);

return statearr_32585;
})();
var statearr_32586_32616 = state_32573__$1;
(statearr_32586_32616[(2)] = null);

(statearr_32586_32616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32574 === (9))){
var inst_32533 = (state_32573[(8)]);
var inst_32549 = cljs.core.vec.call(null,inst_32533);
var state_32573__$1 = state_32573;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32573__$1,(11),out,inst_32549);
} else {
if((state_val_32574 === (5))){
var inst_32537 = (state_32573[(9)]);
var inst_32534 = (state_32573[(7)]);
var inst_32541 = (state_32573[(10)]);
var inst_32541__$1 = f.call(null,inst_32537);
var inst_32542 = cljs.core._EQ_.call(null,inst_32541__$1,inst_32534);
var inst_32543 = cljs.core.keyword_identical_QMARK_.call(null,inst_32534,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_32544 = (inst_32542) || (inst_32543);
var state_32573__$1 = (function (){var statearr_32587 = state_32573;
(statearr_32587[(10)] = inst_32541__$1);

return statearr_32587;
})();
if(cljs.core.truth_(inst_32544)){
var statearr_32588_32617 = state_32573__$1;
(statearr_32588_32617[(1)] = (8));

} else {
var statearr_32589_32618 = state_32573__$1;
(statearr_32589_32618[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32574 === (14))){
var inst_32566 = (state_32573[(2)]);
var inst_32567 = cljs.core.async.close_BANG_.call(null,out);
var state_32573__$1 = (function (){var statearr_32591 = state_32573;
(statearr_32591[(13)] = inst_32566);

return statearr_32591;
})();
var statearr_32592_32619 = state_32573__$1;
(statearr_32592_32619[(2)] = inst_32567);

(statearr_32592_32619[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32574 === (10))){
var inst_32556 = (state_32573[(2)]);
var state_32573__$1 = state_32573;
var statearr_32593_32620 = state_32573__$1;
(statearr_32593_32620[(2)] = inst_32556);

(statearr_32593_32620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32574 === (8))){
var inst_32537 = (state_32573[(9)]);
var inst_32533 = (state_32573[(8)]);
var inst_32541 = (state_32573[(10)]);
var inst_32546 = inst_32533.push(inst_32537);
var tmp32590 = inst_32533;
var inst_32533__$1 = tmp32590;
var inst_32534 = inst_32541;
var state_32573__$1 = (function (){var statearr_32594 = state_32573;
(statearr_32594[(7)] = inst_32534);

(statearr_32594[(14)] = inst_32546);

(statearr_32594[(8)] = inst_32533__$1);

return statearr_32594;
})();
var statearr_32595_32621 = state_32573__$1;
(statearr_32595_32621[(2)] = null);

(statearr_32595_32621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29816__auto___32607,out))
;
return ((function (switch__29702__auto__,c__29816__auto___32607,out){
return (function() {
var cljs$core$async$state_machine__29703__auto__ = null;
var cljs$core$async$state_machine__29703__auto____0 = (function (){
var statearr_32599 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32599[(0)] = cljs$core$async$state_machine__29703__auto__);

(statearr_32599[(1)] = (1));

return statearr_32599;
});
var cljs$core$async$state_machine__29703__auto____1 = (function (state_32573){
while(true){
var ret_value__29704__auto__ = (function (){try{while(true){
var result__29705__auto__ = switch__29702__auto__.call(null,state_32573);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29705__auto__;
}
break;
}
}catch (e32600){if((e32600 instanceof Object)){
var ex__29706__auto__ = e32600;
var statearr_32601_32623 = state_32573;
(statearr_32601_32623[(5)] = ex__29706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32573);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32600;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32624 = state_32573;
state_32573 = G__32624;
continue;
} else {
return ret_value__29704__auto__;
}
break;
}
});
cljs$core$async$state_machine__29703__auto__ = function(state_32573){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29703__auto____1.call(this,state_32573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29703__auto____0;
cljs$core$async$state_machine__29703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29703__auto____1;
return cljs$core$async$state_machine__29703__auto__;
})()
;})(switch__29702__auto__,c__29816__auto___32607,out))
})();
var state__29818__auto__ = (function (){var statearr_32602 = f__29817__auto__.call(null);
(statearr_32602[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29816__auto___32607);

return statearr_32602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29818__auto__);
});})(c__29816__auto___32607,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1479550491621