(ns elastic-input.demo
  (:require [reagent.core :as r]
            [elastic-input.core :as in-flex]))

(defn demo []
  [:div.demo
    [:h1 "Demo"]
    (r/with-let [t (r/atom "Lorem ipsum dolor sit amet")
                 b (r/atom false)
                 f (r/atom true)
                 x (r/atom 10)]
      [:div.card
        [:h2 "input-auto-w"]
        [:div {:style {:display "flex"}}
          [:div.card-demo
            [in-flex/input-auto-w
              {:container {}
               :focused? @f
               :buffer?  @b
               :text     @t
               :extra-w  (int @x)
               :on-text-change #(reset! t %)}]]
          [:table.card-attr
            [:tbody
              [:tr
                [:td [:code ":buffer?"]]
                [:td [:input {:type      "checkbox"
                              :on-change #(swap! b not)
                              :checked   @b}]]]
              [:tr
                [:td [:code ":focused"]]
                [:td [:input {:type      "checkbox"
                              :on-change #(swap! f not)
                              :checked   @f}]]]
              [:tr
                [:td [:code ":text"]]
                [:td [:textarea {:value @t :read-only true}]]]
              [:tr
                [:td [:code ":extra-w"]]
                [:td [:code @x]]]
              [:tr
                [:td [:code ":on-text-change"]]
                [:td [:code "#(reset! ... %)"]]]]]]])

    (r/with-let [t (r/atom "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")
                 b (r/atom false)
                 f (r/atom false)]
      [:div.card
        [:h2 "textarea-auto-h"]
        [:div {:style {:display "flex"}}
          [:div.card-demo
            [in-flex/textarea-auto-h
              {:container {}
               :focused? @f
               :buffer?  @b
               :text     @t
               :width    300
               :on-text-change #(reset! t %)}]]
          [:table.card-attr
            [:tbody
              [:tr
                [:td [:code ":buffer?"]]
                [:td [:input {:type      "checkbox"
                              :on-change #(swap! b not)
                              :checked   @b}]]]
              [:tr
                [:td [:code ":focused"]]
                [:td [:input {:type      "checkbox"
                              :on-change #(swap! f not)
                              :checked   @f}]]]
              [:tr
                [:td [:code ":text"]]
                [:td [:textarea {:value @t :read-only true}]]]
              [:tr
                [:td [:code ":on-text-change"]]
                [:td [:code "#(reset! ... %)"]]]]]]])])

(defn mount-root []
  (r/render [demo] (.getElementById js/document "root")))

(mount-root)
