# Elastic-Input

Input/textarea Reagent component with auto-sizing based on a phantom element (demo: https://aw7.github.io/z-com-demo/#elastic-input).

## Installation

*To install the entire library see https://github.com/aw7/z-com.*

* add the dependency:
  ```Clojure
  :dependencies [[z-com/elastic-input "0.3.0"]]
  ````

* include the stylesheet `resources/public/css/elastic-input.css` in your HTML

## Usage

The *elastic-input* component supports `:width` and `:height` arguments, one of which can be set to `:auto`.

```Clojure
  (ns elastic-input-app
    (:require [reagent.core :as r]
              [z-com.core :as z]))

  (defn index []
    (r/with-let [text-ratom (r/atom "")]
      [:div [:h1 "Form"]
        [z/elastic-input
          :width       :auto
          :text        @text-ratom
          :placeholder "enter text..."
          :focused?    true
          :buffer?     true
          :extra-len   5
          :on-text-change #(reset! text %)]]))
```

* `:width :auto` yields an `<input ...>` element

* `:height :auto` yields a `<textarea ...>` element and requires the specification of a fixed `:width`

* if `:buffer?` is false (default) the `:on-text-change` function is invoked after every keystroke, otherwise when pressing *enter* or when removing focus

* a `:placeholder` string can be specified to be shown when the input is empty

* when `:focused?` is true the input component is automatically given focus when mounted
