(ns input-flex.demo
  (:require [reagent.core :as r]
            [input-flex.core :as in-flex]))

(defn demo []
  [:div.demo
    [:h1 "Demo"]
    (r/with-let [t (r/atom "ABCDEFGEHIJKLM")
                 b (r/atom false)
                 f (r/atom false)
                 x (r/atom 10)]
      [:div.card
        [:h2 "input-auto-w"]
        [:div {:style {:display "flex"}}
          [:table.attr
            [:tbody
              [:tr
                [:td [:code ":buffer?"]]
                [:td [:input {:type      "checkbox"
                              :on-change #(swap! b not)
                              :checked   @b}]]]
              [:tr
                [:td [:code ":focused"]]
                [:td [:input {:type      "checkbox"
                              :on-change #(swap! f not)
                              :checked   @f}]]]
              [:tr
                [:td [:code ":text"]]
                [:td [:textarea {:value @t}]]]
              [:tr
                [:td [:code ":extra-w"]]
                [:td [:code @x]]]
              [:tr
                [:td [:code ":on-text-change"]]
                [:td [:code "#(reset! ... %)"]]]
              [:tr [:td [:code ":on-focus"]] [:td [:code "nil"]]]
              [:tr [:td [:code ":on-blur"]]  [:td [:code "nil"]]]]]
          [:div
            [in-flex/input-auto-w
              {:container {:style {:display "inline-block"
                                   :background-color "white"
                                   :border "2px solid black"}}
               :focused? @f
               :buffer?  @b
               :text     @t
               :extra-w  (int @x)
               :on-text-change #(reset! t %)}]]]])

    (r/with-let [t (r/atom "ABCDEFGEHIJKLMNOPQRSTUVWXYZ")
                 b (r/atom false)
                 f (r/atom false)]
      [:div.card
        [:h2 "textarea-auto-h"]
        [:div {:style {:display "flex"}}
          [:table.attr
            [:tbody
              [:tr
                [:td [:code ":buffer?"]]
                [:td [:input {:type      "checkbox"
                              :on-change #(swap! b not)
                              :checked   @b}]]]
              [:tr
                [:td [:code ":focused"]]
                [:td [:input {:type      "checkbox"
                              :on-change #(swap! f not)
                              :checked   @f}]]]
              [:tr
                [:td [:code ":text"]]
                [:td [:textarea {:value @t :read-only true}]]]
              [:tr
                [:td [:code ":on-text-change"]]
                [:td [:code "#(reset! ... %)"]]]]]
          [:div
            [in-flex/textarea-auto-h
              {:container {:style {:width "150px"
                                   :background-color "white"
                                   :border "2px solid black"}}
               :focused? @f
               :buffer?  @b
               :text     @t
               :on-text-change #(reset! t %)}]]]])])

(defn mount-root []
  (r/render [demo] (.getElementById js/document "root")))

(mount-root)
