// Compiled by ClojureScript 1.9.293 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('reagent.impl.util');
goog.require('reagent.interop');
goog.require('reagent.ratom');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('cljsjs.react.dom');
goog.require('reagent.debug');
if(typeof reagent.dom.imported !== 'undefined'){
} else {
reagent.dom.imported = null;
}
reagent.dom.module = (function reagent$dom$module(){
if(cljs.core.some_QMARK_.call(null,reagent.dom.imported)){
return reagent.dom.imported;
} else {
if(typeof ReactDOM !== 'undefined'){
return reagent.dom.imported = ReactDOM;
} else {
if(typeof require !== 'undefined'){
var or__20277__auto__ = reagent.dom.imported = require("react-dom");
if(cljs.core.truth_(or__20277__auto__)){
return or__20277__auto__;
} else {
throw (new Error("require('react-dom') failed"));
}
} else {
throw (new Error("js/ReactDOM is missing"));

}
}
}
});
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.module.call(null)["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_22170 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.module.call(null)["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_22170){
return (function (){
var _STAR_always_update_STAR_22171 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

reagent.impl.batching.flush_after_render.call(null);

if(cljs.core.some_QMARK_.call(null,callback)){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_22171;
}});})(_STAR_always_update_STAR_22170))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_22170;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args22172 = [];
var len__21493__auto___22175 = arguments.length;
var i__21494__auto___22176 = (0);
while(true){
if((i__21494__auto___22176 < len__21493__auto___22175)){
args22172.push((arguments[i__21494__auto___22176]));

var G__22177 = (i__21494__auto___22176 + (1));
i__21494__auto___22176 = G__22177;
continue;
} else {
}
break;
}

var G__22174 = args22172.length;
switch (G__22174) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22172.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
reagent.ratom.flush_BANG_.call(null);

var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.module.call(null)["findDOMNode"])(this$);
});
reagent.impl.template.find_dom_node = reagent.dom.dom_node;
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__22183_22187 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__22184_22188 = null;
var count__22185_22189 = (0);
var i__22186_22190 = (0);
while(true){
if((i__22186_22190 < count__22185_22189)){
var v_22191 = cljs.core._nth.call(null,chunk__22184_22188,i__22186_22190);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_22191);

var G__22192 = seq__22183_22187;
var G__22193 = chunk__22184_22188;
var G__22194 = count__22185_22189;
var G__22195 = (i__22186_22190 + (1));
seq__22183_22187 = G__22192;
chunk__22184_22188 = G__22193;
count__22185_22189 = G__22194;
i__22186_22190 = G__22195;
continue;
} else {
var temp__6753__auto___22196 = cljs.core.seq.call(null,seq__22183_22187);
if(temp__6753__auto___22196){
var seq__22183_22197__$1 = temp__6753__auto___22196;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22183_22197__$1)){
var c__21183__auto___22198 = cljs.core.chunk_first.call(null,seq__22183_22197__$1);
var G__22199 = cljs.core.chunk_rest.call(null,seq__22183_22197__$1);
var G__22200 = c__21183__auto___22198;
var G__22201 = cljs.core.count.call(null,c__21183__auto___22198);
var G__22202 = (0);
seq__22183_22187 = G__22199;
chunk__22184_22188 = G__22200;
count__22185_22189 = G__22201;
i__22186_22190 = G__22202;
continue;
} else {
var v_22203 = cljs.core.first.call(null,seq__22183_22197__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_22203);

var G__22204 = cljs.core.next.call(null,seq__22183_22197__$1);
var G__22205 = null;
var G__22206 = (0);
var G__22207 = (0);
seq__22183_22187 = G__22204;
chunk__22184_22188 = G__22205;
count__22185_22189 = G__22206;
i__22186_22190 = G__22207;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map