(ns linetree.core
  (:require [linetree.flex  :as flextree]
            [linetree.table :as tabletree]))

(defn linetree [& {:as varargs}]
  (let [{:as args :keys [repr] :or {repr :flex}} (or (:args varargs) varargs)]
    (case repr
      :flex  [flextree/tree  args]
      :table [tabletree/tree args])))
