// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args30093 = [];
var len__27957__auto___30099 = arguments.length;
var i__27958__auto___30100 = (0);
while(true){
if((i__27958__auto___30100 < len__27957__auto___30099)){
args30093.push((arguments[i__27958__auto___30100]));

var G__30101 = (i__27958__auto___30100 + (1));
i__27958__auto___30100 = G__30101;
continue;
} else {
}
break;
}

var G__30095 = args30093.length;
switch (G__30095) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30093.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async30096 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30096 = (function (f,blockable,meta30097){
this.f = f;
this.blockable = blockable;
this.meta30097 = meta30097;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30096.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30098,meta30097__$1){
var self__ = this;
var _30098__$1 = this;
return (new cljs.core.async.t_cljs$core$async30096(self__.f,self__.blockable,meta30097__$1));
});

cljs.core.async.t_cljs$core$async30096.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30098){
var self__ = this;
var _30098__$1 = this;
return self__.meta30097;
});

cljs.core.async.t_cljs$core$async30096.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30096.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30096.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async30096.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async30096.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30097","meta30097",-276448642,null)], null);
});

cljs.core.async.t_cljs$core$async30096.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30096.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30096";

cljs.core.async.t_cljs$core$async30096.cljs$lang$ctorPrWriter = (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async30096");
});

cljs.core.async.__GT_t_cljs$core$async30096 = (function cljs$core$async$__GT_t_cljs$core$async30096(f__$1,blockable__$1,meta30097){
return (new cljs.core.async.t_cljs$core$async30096(f__$1,blockable__$1,meta30097));
});

}

return (new cljs.core.async.t_cljs$core$async30096(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args30105 = [];
var len__27957__auto___30108 = arguments.length;
var i__27958__auto___30109 = (0);
while(true){
if((i__27958__auto___30109 < len__27957__auto___30108)){
args30105.push((arguments[i__27958__auto___30109]));

var G__30110 = (i__27958__auto___30109 + (1));
i__27958__auto___30109 = G__30110;
continue;
} else {
}
break;
}

var G__30107 = args30105.length;
switch (G__30107) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30105.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args30112 = [];
var len__27957__auto___30115 = arguments.length;
var i__27958__auto___30116 = (0);
while(true){
if((i__27958__auto___30116 < len__27957__auto___30115)){
args30112.push((arguments[i__27958__auto___30116]));

var G__30117 = (i__27958__auto___30116 + (1));
i__27958__auto___30116 = G__30117;
continue;
} else {
}
break;
}

var G__30114 = args30112.length;
switch (G__30114) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30112.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args30119 = [];
var len__27957__auto___30122 = arguments.length;
var i__27958__auto___30123 = (0);
while(true){
if((i__27958__auto___30123 < len__27957__auto___30122)){
args30119.push((arguments[i__27958__auto___30123]));

var G__30124 = (i__27958__auto___30123 + (1));
i__27958__auto___30123 = G__30124;
continue;
} else {
}
break;
}

var G__30121 = args30119.length;
switch (G__30121) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30119.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_30126 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_30126);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_30126,ret){
return (function (){
return fn1.call(null,val_30126);
});})(val_30126,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args30127 = [];
var len__27957__auto___30130 = arguments.length;
var i__27958__auto___30131 = (0);
while(true){
if((i__27958__auto___30131 < len__27957__auto___30130)){
args30127.push((arguments[i__27958__auto___30131]));

var G__30132 = (i__27958__auto___30131 + (1));
i__27958__auto___30131 = G__30132;
continue;
} else {
}
break;
}

var G__30129 = args30127.length;
switch (G__30129) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30127.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__27757__auto___30134 = n;
var x_30135 = (0);
while(true){
if((x_30135 < n__27757__auto___30134)){
(a[x_30135] = (0));

var G__30136 = (x_30135 + (1));
x_30135 = G__30136;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__30137 = (i + (1));
i = G__30137;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async30141 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30141 = (function (flag,meta30142){
this.flag = flag;
this.meta30142 = meta30142;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30141.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_30143,meta30142__$1){
var self__ = this;
var _30143__$1 = this;
return (new cljs.core.async.t_cljs$core$async30141(self__.flag,meta30142__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async30141.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_30143){
var self__ = this;
var _30143__$1 = this;
return self__.meta30142;
});})(flag))
;

cljs.core.async.t_cljs$core$async30141.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30141.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async30141.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async30141.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async30141.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30142","meta30142",701007147,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async30141.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30141.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30141";

cljs.core.async.t_cljs$core$async30141.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async30141");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async30141 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async30141(flag__$1,meta30142){
return (new cljs.core.async.t_cljs$core$async30141(flag__$1,meta30142));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async30141(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async30147 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30147 = (function (flag,cb,meta30148){
this.flag = flag;
this.cb = cb;
this.meta30148 = meta30148;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30147.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30149,meta30148__$1){
var self__ = this;
var _30149__$1 = this;
return (new cljs.core.async.t_cljs$core$async30147(self__.flag,self__.cb,meta30148__$1));
});

cljs.core.async.t_cljs$core$async30147.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30149){
var self__ = this;
var _30149__$1 = this;
return self__.meta30148;
});

cljs.core.async.t_cljs$core$async30147.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30147.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async30147.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30147.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async30147.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30148","meta30148",-317995787,null)], null);
});

cljs.core.async.t_cljs$core$async30147.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30147.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30147";

cljs.core.async.t_cljs$core$async30147.cljs$lang$ctorPrWriter = (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async30147");
});

cljs.core.async.__GT_t_cljs$core$async30147 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async30147(flag__$1,cb__$1,meta30148){
return (new cljs.core.async.t_cljs$core$async30147(flag__$1,cb__$1,meta30148));
});

}

return (new cljs.core.async.t_cljs$core$async30147(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30150_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30150_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30151_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30151_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__26741__auto__ = wport;
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30152 = (i + (1));
i = G__30152;
continue;
}
} else {
return null;
}
break;
}
})();
var or__26741__auto__ = ret;
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__26729__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__26729__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__26729__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__27964__auto__ = [];
var len__27957__auto___30158 = arguments.length;
var i__27958__auto___30159 = (0);
while(true){
if((i__27958__auto___30159 < len__27957__auto___30158)){
args__27964__auto__.push((arguments[i__27958__auto___30159]));

var G__30160 = (i__27958__auto___30159 + (1));
i__27958__auto___30159 = G__30160;
continue;
} else {
}
break;
}

var argseq__27965__auto__ = ((((1) < args__27964__auto__.length))?(new cljs.core.IndexedSeq(args__27964__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__27965__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30155){
var map__30156 = p__30155;
var map__30156__$1 = ((((!((map__30156 == null)))?((((map__30156.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30156.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30156):map__30156);
var opts = map__30156__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30153){
var G__30154 = cljs.core.first.call(null,seq30153);
var seq30153__$1 = cljs.core.next.call(null,seq30153);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30154,seq30153__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args30161 = [];
var len__27957__auto___30211 = arguments.length;
var i__27958__auto___30212 = (0);
while(true){
if((i__27958__auto___30212 < len__27957__auto___30211)){
args30161.push((arguments[i__27958__auto___30212]));

var G__30213 = (i__27958__auto___30212 + (1));
i__27958__auto___30212 = G__30213;
continue;
} else {
}
break;
}

var G__30163 = args30161.length;
switch (G__30163) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30161.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30034__auto___30215 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___30215){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___30215){
return (function (state_30187){
var state_val_30188 = (state_30187[(1)]);
if((state_val_30188 === (7))){
var inst_30183 = (state_30187[(2)]);
var state_30187__$1 = state_30187;
var statearr_30189_30216 = state_30187__$1;
(statearr_30189_30216[(2)] = inst_30183);

(statearr_30189_30216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (1))){
var state_30187__$1 = state_30187;
var statearr_30190_30217 = state_30187__$1;
(statearr_30190_30217[(2)] = null);

(statearr_30190_30217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (4))){
var inst_30166 = (state_30187[(7)]);
var inst_30166__$1 = (state_30187[(2)]);
var inst_30167 = (inst_30166__$1 == null);
var state_30187__$1 = (function (){var statearr_30191 = state_30187;
(statearr_30191[(7)] = inst_30166__$1);

return statearr_30191;
})();
if(cljs.core.truth_(inst_30167)){
var statearr_30192_30218 = state_30187__$1;
(statearr_30192_30218[(1)] = (5));

} else {
var statearr_30193_30219 = state_30187__$1;
(statearr_30193_30219[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (13))){
var state_30187__$1 = state_30187;
var statearr_30194_30220 = state_30187__$1;
(statearr_30194_30220[(2)] = null);

(statearr_30194_30220[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (6))){
var inst_30166 = (state_30187[(7)]);
var state_30187__$1 = state_30187;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30187__$1,(11),to,inst_30166);
} else {
if((state_val_30188 === (3))){
var inst_30185 = (state_30187[(2)]);
var state_30187__$1 = state_30187;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30187__$1,inst_30185);
} else {
if((state_val_30188 === (12))){
var state_30187__$1 = state_30187;
var statearr_30195_30221 = state_30187__$1;
(statearr_30195_30221[(2)] = null);

(statearr_30195_30221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (2))){
var state_30187__$1 = state_30187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30187__$1,(4),from);
} else {
if((state_val_30188 === (11))){
var inst_30176 = (state_30187[(2)]);
var state_30187__$1 = state_30187;
if(cljs.core.truth_(inst_30176)){
var statearr_30196_30222 = state_30187__$1;
(statearr_30196_30222[(1)] = (12));

} else {
var statearr_30197_30223 = state_30187__$1;
(statearr_30197_30223[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (9))){
var state_30187__$1 = state_30187;
var statearr_30198_30224 = state_30187__$1;
(statearr_30198_30224[(2)] = null);

(statearr_30198_30224[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (5))){
var state_30187__$1 = state_30187;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30199_30225 = state_30187__$1;
(statearr_30199_30225[(1)] = (8));

} else {
var statearr_30200_30226 = state_30187__$1;
(statearr_30200_30226[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (14))){
var inst_30181 = (state_30187[(2)]);
var state_30187__$1 = state_30187;
var statearr_30201_30227 = state_30187__$1;
(statearr_30201_30227[(2)] = inst_30181);

(statearr_30201_30227[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (10))){
var inst_30173 = (state_30187[(2)]);
var state_30187__$1 = state_30187;
var statearr_30202_30228 = state_30187__$1;
(statearr_30202_30228[(2)] = inst_30173);

(statearr_30202_30228[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30188 === (8))){
var inst_30170 = cljs.core.async.close_BANG_.call(null,to);
var state_30187__$1 = state_30187;
var statearr_30203_30229 = state_30187__$1;
(statearr_30203_30229[(2)] = inst_30170);

(statearr_30203_30229[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___30215))
;
return ((function (switch__29920__auto__,c__30034__auto___30215){
return (function() {
var cljs$core$async$state_machine__29921__auto__ = null;
var cljs$core$async$state_machine__29921__auto____0 = (function (){
var statearr_30207 = [null,null,null,null,null,null,null,null];
(statearr_30207[(0)] = cljs$core$async$state_machine__29921__auto__);

(statearr_30207[(1)] = (1));

return statearr_30207;
});
var cljs$core$async$state_machine__29921__auto____1 = (function (state_30187){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_30187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e30208){if((e30208 instanceof Object)){
var ex__29924__auto__ = e30208;
var statearr_30209_30230 = state_30187;
(statearr_30209_30230[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30187);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30208;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30231 = state_30187;
state_30187 = G__30231;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$state_machine__29921__auto__ = function(state_30187){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29921__auto____1.call(this,state_30187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29921__auto____0;
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29921__auto____1;
return cljs$core$async$state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___30215))
})();
var state__30036__auto__ = (function (){var statearr_30210 = f__30035__auto__.call(null);
(statearr_30210[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___30215);

return statearr_30210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___30215))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__30419){
var vec__30420 = p__30419;
var v = cljs.core.nth.call(null,vec__30420,(0),null);
var p = cljs.core.nth.call(null,vec__30420,(1),null);
var job = vec__30420;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__30034__auto___30606 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___30606,res,vec__30420,v,p,job,jobs,results){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___30606,res,vec__30420,v,p,job,jobs,results){
return (function (state_30427){
var state_val_30428 = (state_30427[(1)]);
if((state_val_30428 === (1))){
var state_30427__$1 = state_30427;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30427__$1,(2),res,v);
} else {
if((state_val_30428 === (2))){
var inst_30424 = (state_30427[(2)]);
var inst_30425 = cljs.core.async.close_BANG_.call(null,res);
var state_30427__$1 = (function (){var statearr_30429 = state_30427;
(statearr_30429[(7)] = inst_30424);

return statearr_30429;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30427__$1,inst_30425);
} else {
return null;
}
}
});})(c__30034__auto___30606,res,vec__30420,v,p,job,jobs,results))
;
return ((function (switch__29920__auto__,c__30034__auto___30606,res,vec__30420,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0 = (function (){
var statearr_30433 = [null,null,null,null,null,null,null,null];
(statearr_30433[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__);

(statearr_30433[(1)] = (1));

return statearr_30433;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1 = (function (state_30427){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_30427);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e30434){if((e30434 instanceof Object)){
var ex__29924__auto__ = e30434;
var statearr_30435_30607 = state_30427;
(statearr_30435_30607[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30427);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30434;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30608 = state_30427;
state_30427 = G__30608;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__ = function(state_30427){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1.call(this,state_30427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___30606,res,vec__30420,v,p,job,jobs,results))
})();
var state__30036__auto__ = (function (){var statearr_30436 = f__30035__auto__.call(null);
(statearr_30436[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___30606);

return statearr_30436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___30606,res,vec__30420,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__30437){
var vec__30438 = p__30437;
var v = cljs.core.nth.call(null,vec__30438,(0),null);
var p = cljs.core.nth.call(null,vec__30438,(1),null);
var job = vec__30438;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__27757__auto___30609 = n;
var __30610 = (0);
while(true){
if((__30610 < n__27757__auto___30609)){
var G__30441_30611 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__30441_30611) {
case "compute":
var c__30034__auto___30613 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30610,c__30034__auto___30613,G__30441_30611,n__27757__auto___30609,jobs,results,process,async){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (__30610,c__30034__auto___30613,G__30441_30611,n__27757__auto___30609,jobs,results,process,async){
return (function (state_30454){
var state_val_30455 = (state_30454[(1)]);
if((state_val_30455 === (1))){
var state_30454__$1 = state_30454;
var statearr_30456_30614 = state_30454__$1;
(statearr_30456_30614[(2)] = null);

(statearr_30456_30614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30455 === (2))){
var state_30454__$1 = state_30454;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30454__$1,(4),jobs);
} else {
if((state_val_30455 === (3))){
var inst_30452 = (state_30454[(2)]);
var state_30454__$1 = state_30454;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30454__$1,inst_30452);
} else {
if((state_val_30455 === (4))){
var inst_30444 = (state_30454[(2)]);
var inst_30445 = process.call(null,inst_30444);
var state_30454__$1 = state_30454;
if(cljs.core.truth_(inst_30445)){
var statearr_30457_30615 = state_30454__$1;
(statearr_30457_30615[(1)] = (5));

} else {
var statearr_30458_30616 = state_30454__$1;
(statearr_30458_30616[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30455 === (5))){
var state_30454__$1 = state_30454;
var statearr_30459_30617 = state_30454__$1;
(statearr_30459_30617[(2)] = null);

(statearr_30459_30617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30455 === (6))){
var state_30454__$1 = state_30454;
var statearr_30460_30618 = state_30454__$1;
(statearr_30460_30618[(2)] = null);

(statearr_30460_30618[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30455 === (7))){
var inst_30450 = (state_30454[(2)]);
var state_30454__$1 = state_30454;
var statearr_30461_30619 = state_30454__$1;
(statearr_30461_30619[(2)] = inst_30450);

(statearr_30461_30619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30610,c__30034__auto___30613,G__30441_30611,n__27757__auto___30609,jobs,results,process,async))
;
return ((function (__30610,switch__29920__auto__,c__30034__auto___30613,G__30441_30611,n__27757__auto___30609,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0 = (function (){
var statearr_30465 = [null,null,null,null,null,null,null];
(statearr_30465[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__);

(statearr_30465[(1)] = (1));

return statearr_30465;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1 = (function (state_30454){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_30454);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e30466){if((e30466 instanceof Object)){
var ex__29924__auto__ = e30466;
var statearr_30467_30620 = state_30454;
(statearr_30467_30620[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30454);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30466;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30621 = state_30454;
state_30454 = G__30621;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__ = function(state_30454){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1.call(this,state_30454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__;
})()
;})(__30610,switch__29920__auto__,c__30034__auto___30613,G__30441_30611,n__27757__auto___30609,jobs,results,process,async))
})();
var state__30036__auto__ = (function (){var statearr_30468 = f__30035__auto__.call(null);
(statearr_30468[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___30613);

return statearr_30468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(__30610,c__30034__auto___30613,G__30441_30611,n__27757__auto___30609,jobs,results,process,async))
);


break;
case "async":
var c__30034__auto___30622 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30610,c__30034__auto___30622,G__30441_30611,n__27757__auto___30609,jobs,results,process,async){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (__30610,c__30034__auto___30622,G__30441_30611,n__27757__auto___30609,jobs,results,process,async){
return (function (state_30481){
var state_val_30482 = (state_30481[(1)]);
if((state_val_30482 === (1))){
var state_30481__$1 = state_30481;
var statearr_30483_30623 = state_30481__$1;
(statearr_30483_30623[(2)] = null);

(statearr_30483_30623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30482 === (2))){
var state_30481__$1 = state_30481;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30481__$1,(4),jobs);
} else {
if((state_val_30482 === (3))){
var inst_30479 = (state_30481[(2)]);
var state_30481__$1 = state_30481;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30481__$1,inst_30479);
} else {
if((state_val_30482 === (4))){
var inst_30471 = (state_30481[(2)]);
var inst_30472 = async.call(null,inst_30471);
var state_30481__$1 = state_30481;
if(cljs.core.truth_(inst_30472)){
var statearr_30484_30624 = state_30481__$1;
(statearr_30484_30624[(1)] = (5));

} else {
var statearr_30485_30625 = state_30481__$1;
(statearr_30485_30625[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30482 === (5))){
var state_30481__$1 = state_30481;
var statearr_30486_30626 = state_30481__$1;
(statearr_30486_30626[(2)] = null);

(statearr_30486_30626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30482 === (6))){
var state_30481__$1 = state_30481;
var statearr_30487_30627 = state_30481__$1;
(statearr_30487_30627[(2)] = null);

(statearr_30487_30627[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30482 === (7))){
var inst_30477 = (state_30481[(2)]);
var state_30481__$1 = state_30481;
var statearr_30488_30628 = state_30481__$1;
(statearr_30488_30628[(2)] = inst_30477);

(statearr_30488_30628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30610,c__30034__auto___30622,G__30441_30611,n__27757__auto___30609,jobs,results,process,async))
;
return ((function (__30610,switch__29920__auto__,c__30034__auto___30622,G__30441_30611,n__27757__auto___30609,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0 = (function (){
var statearr_30492 = [null,null,null,null,null,null,null];
(statearr_30492[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__);

(statearr_30492[(1)] = (1));

return statearr_30492;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1 = (function (state_30481){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_30481);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e30493){if((e30493 instanceof Object)){
var ex__29924__auto__ = e30493;
var statearr_30494_30629 = state_30481;
(statearr_30494_30629[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30481);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30493;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30630 = state_30481;
state_30481 = G__30630;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__ = function(state_30481){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1.call(this,state_30481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__;
})()
;})(__30610,switch__29920__auto__,c__30034__auto___30622,G__30441_30611,n__27757__auto___30609,jobs,results,process,async))
})();
var state__30036__auto__ = (function (){var statearr_30495 = f__30035__auto__.call(null);
(statearr_30495[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___30622);

return statearr_30495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(__30610,c__30034__auto___30622,G__30441_30611,n__27757__auto___30609,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__30631 = (__30610 + (1));
__30610 = G__30631;
continue;
} else {
}
break;
}

var c__30034__auto___30632 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___30632,jobs,results,process,async){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___30632,jobs,results,process,async){
return (function (state_30517){
var state_val_30518 = (state_30517[(1)]);
if((state_val_30518 === (1))){
var state_30517__$1 = state_30517;
var statearr_30519_30633 = state_30517__$1;
(statearr_30519_30633[(2)] = null);

(statearr_30519_30633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30518 === (2))){
var state_30517__$1 = state_30517;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30517__$1,(4),from);
} else {
if((state_val_30518 === (3))){
var inst_30515 = (state_30517[(2)]);
var state_30517__$1 = state_30517;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30517__$1,inst_30515);
} else {
if((state_val_30518 === (4))){
var inst_30498 = (state_30517[(7)]);
var inst_30498__$1 = (state_30517[(2)]);
var inst_30499 = (inst_30498__$1 == null);
var state_30517__$1 = (function (){var statearr_30520 = state_30517;
(statearr_30520[(7)] = inst_30498__$1);

return statearr_30520;
})();
if(cljs.core.truth_(inst_30499)){
var statearr_30521_30634 = state_30517__$1;
(statearr_30521_30634[(1)] = (5));

} else {
var statearr_30522_30635 = state_30517__$1;
(statearr_30522_30635[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30518 === (5))){
var inst_30501 = cljs.core.async.close_BANG_.call(null,jobs);
var state_30517__$1 = state_30517;
var statearr_30523_30636 = state_30517__$1;
(statearr_30523_30636[(2)] = inst_30501);

(statearr_30523_30636[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30518 === (6))){
var inst_30503 = (state_30517[(8)]);
var inst_30498 = (state_30517[(7)]);
var inst_30503__$1 = cljs.core.async.chan.call(null,(1));
var inst_30504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30505 = [inst_30498,inst_30503__$1];
var inst_30506 = (new cljs.core.PersistentVector(null,2,(5),inst_30504,inst_30505,null));
var state_30517__$1 = (function (){var statearr_30524 = state_30517;
(statearr_30524[(8)] = inst_30503__$1);

return statearr_30524;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30517__$1,(8),jobs,inst_30506);
} else {
if((state_val_30518 === (7))){
var inst_30513 = (state_30517[(2)]);
var state_30517__$1 = state_30517;
var statearr_30525_30637 = state_30517__$1;
(statearr_30525_30637[(2)] = inst_30513);

(statearr_30525_30637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30518 === (8))){
var inst_30503 = (state_30517[(8)]);
var inst_30508 = (state_30517[(2)]);
var state_30517__$1 = (function (){var statearr_30526 = state_30517;
(statearr_30526[(9)] = inst_30508);

return statearr_30526;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30517__$1,(9),results,inst_30503);
} else {
if((state_val_30518 === (9))){
var inst_30510 = (state_30517[(2)]);
var state_30517__$1 = (function (){var statearr_30527 = state_30517;
(statearr_30527[(10)] = inst_30510);

return statearr_30527;
})();
var statearr_30528_30638 = state_30517__$1;
(statearr_30528_30638[(2)] = null);

(statearr_30528_30638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___30632,jobs,results,process,async))
;
return ((function (switch__29920__auto__,c__30034__auto___30632,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0 = (function (){
var statearr_30532 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30532[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__);

(statearr_30532[(1)] = (1));

return statearr_30532;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1 = (function (state_30517){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_30517);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e30533){if((e30533 instanceof Object)){
var ex__29924__auto__ = e30533;
var statearr_30534_30639 = state_30517;
(statearr_30534_30639[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30517);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30533;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30640 = state_30517;
state_30517 = G__30640;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__ = function(state_30517){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1.call(this,state_30517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___30632,jobs,results,process,async))
})();
var state__30036__auto__ = (function (){var statearr_30535 = f__30035__auto__.call(null);
(statearr_30535[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___30632);

return statearr_30535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___30632,jobs,results,process,async))
);


var c__30034__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto__,jobs,results,process,async){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto__,jobs,results,process,async){
return (function (state_30573){
var state_val_30574 = (state_30573[(1)]);
if((state_val_30574 === (7))){
var inst_30569 = (state_30573[(2)]);
var state_30573__$1 = state_30573;
var statearr_30575_30641 = state_30573__$1;
(statearr_30575_30641[(2)] = inst_30569);

(statearr_30575_30641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (20))){
var state_30573__$1 = state_30573;
var statearr_30576_30642 = state_30573__$1;
(statearr_30576_30642[(2)] = null);

(statearr_30576_30642[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (1))){
var state_30573__$1 = state_30573;
var statearr_30577_30643 = state_30573__$1;
(statearr_30577_30643[(2)] = null);

(statearr_30577_30643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (4))){
var inst_30538 = (state_30573[(7)]);
var inst_30538__$1 = (state_30573[(2)]);
var inst_30539 = (inst_30538__$1 == null);
var state_30573__$1 = (function (){var statearr_30578 = state_30573;
(statearr_30578[(7)] = inst_30538__$1);

return statearr_30578;
})();
if(cljs.core.truth_(inst_30539)){
var statearr_30579_30644 = state_30573__$1;
(statearr_30579_30644[(1)] = (5));

} else {
var statearr_30580_30645 = state_30573__$1;
(statearr_30580_30645[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (15))){
var inst_30551 = (state_30573[(8)]);
var state_30573__$1 = state_30573;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30573__$1,(18),to,inst_30551);
} else {
if((state_val_30574 === (21))){
var inst_30564 = (state_30573[(2)]);
var state_30573__$1 = state_30573;
var statearr_30581_30646 = state_30573__$1;
(statearr_30581_30646[(2)] = inst_30564);

(statearr_30581_30646[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (13))){
var inst_30566 = (state_30573[(2)]);
var state_30573__$1 = (function (){var statearr_30582 = state_30573;
(statearr_30582[(9)] = inst_30566);

return statearr_30582;
})();
var statearr_30583_30647 = state_30573__$1;
(statearr_30583_30647[(2)] = null);

(statearr_30583_30647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (6))){
var inst_30538 = (state_30573[(7)]);
var state_30573__$1 = state_30573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30573__$1,(11),inst_30538);
} else {
if((state_val_30574 === (17))){
var inst_30559 = (state_30573[(2)]);
var state_30573__$1 = state_30573;
if(cljs.core.truth_(inst_30559)){
var statearr_30584_30648 = state_30573__$1;
(statearr_30584_30648[(1)] = (19));

} else {
var statearr_30585_30649 = state_30573__$1;
(statearr_30585_30649[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (3))){
var inst_30571 = (state_30573[(2)]);
var state_30573__$1 = state_30573;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30573__$1,inst_30571);
} else {
if((state_val_30574 === (12))){
var inst_30548 = (state_30573[(10)]);
var state_30573__$1 = state_30573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30573__$1,(14),inst_30548);
} else {
if((state_val_30574 === (2))){
var state_30573__$1 = state_30573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30573__$1,(4),results);
} else {
if((state_val_30574 === (19))){
var state_30573__$1 = state_30573;
var statearr_30586_30650 = state_30573__$1;
(statearr_30586_30650[(2)] = null);

(statearr_30586_30650[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (11))){
var inst_30548 = (state_30573[(2)]);
var state_30573__$1 = (function (){var statearr_30587 = state_30573;
(statearr_30587[(10)] = inst_30548);

return statearr_30587;
})();
var statearr_30588_30651 = state_30573__$1;
(statearr_30588_30651[(2)] = null);

(statearr_30588_30651[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (9))){
var state_30573__$1 = state_30573;
var statearr_30589_30652 = state_30573__$1;
(statearr_30589_30652[(2)] = null);

(statearr_30589_30652[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (5))){
var state_30573__$1 = state_30573;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30590_30653 = state_30573__$1;
(statearr_30590_30653[(1)] = (8));

} else {
var statearr_30591_30654 = state_30573__$1;
(statearr_30591_30654[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (14))){
var inst_30551 = (state_30573[(8)]);
var inst_30553 = (state_30573[(11)]);
var inst_30551__$1 = (state_30573[(2)]);
var inst_30552 = (inst_30551__$1 == null);
var inst_30553__$1 = cljs.core.not.call(null,inst_30552);
var state_30573__$1 = (function (){var statearr_30592 = state_30573;
(statearr_30592[(8)] = inst_30551__$1);

(statearr_30592[(11)] = inst_30553__$1);

return statearr_30592;
})();
if(inst_30553__$1){
var statearr_30593_30655 = state_30573__$1;
(statearr_30593_30655[(1)] = (15));

} else {
var statearr_30594_30656 = state_30573__$1;
(statearr_30594_30656[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (16))){
var inst_30553 = (state_30573[(11)]);
var state_30573__$1 = state_30573;
var statearr_30595_30657 = state_30573__$1;
(statearr_30595_30657[(2)] = inst_30553);

(statearr_30595_30657[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (10))){
var inst_30545 = (state_30573[(2)]);
var state_30573__$1 = state_30573;
var statearr_30596_30658 = state_30573__$1;
(statearr_30596_30658[(2)] = inst_30545);

(statearr_30596_30658[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (18))){
var inst_30556 = (state_30573[(2)]);
var state_30573__$1 = state_30573;
var statearr_30597_30659 = state_30573__$1;
(statearr_30597_30659[(2)] = inst_30556);

(statearr_30597_30659[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30574 === (8))){
var inst_30542 = cljs.core.async.close_BANG_.call(null,to);
var state_30573__$1 = state_30573;
var statearr_30598_30660 = state_30573__$1;
(statearr_30598_30660[(2)] = inst_30542);

(statearr_30598_30660[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto__,jobs,results,process,async))
;
return ((function (switch__29920__auto__,c__30034__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0 = (function (){
var statearr_30602 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30602[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__);

(statearr_30602[(1)] = (1));

return statearr_30602;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1 = (function (state_30573){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_30573);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e30603){if((e30603 instanceof Object)){
var ex__29924__auto__ = e30603;
var statearr_30604_30661 = state_30573;
(statearr_30604_30661[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30573);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30603;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30662 = state_30573;
state_30573 = G__30662;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__ = function(state_30573){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1.call(this,state_30573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29921__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto__,jobs,results,process,async))
})();
var state__30036__auto__ = (function (){var statearr_30605 = f__30035__auto__.call(null);
(statearr_30605[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto__);

return statearr_30605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto__,jobs,results,process,async))
);

return c__30034__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args30663 = [];
var len__27957__auto___30666 = arguments.length;
var i__27958__auto___30667 = (0);
while(true){
if((i__27958__auto___30667 < len__27957__auto___30666)){
args30663.push((arguments[i__27958__auto___30667]));

var G__30668 = (i__27958__auto___30667 + (1));
i__27958__auto___30667 = G__30668;
continue;
} else {
}
break;
}

var G__30665 = args30663.length;
switch (G__30665) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30663.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args30670 = [];
var len__27957__auto___30673 = arguments.length;
var i__27958__auto___30674 = (0);
while(true){
if((i__27958__auto___30674 < len__27957__auto___30673)){
args30670.push((arguments[i__27958__auto___30674]));

var G__30675 = (i__27958__auto___30674 + (1));
i__27958__auto___30674 = G__30675;
continue;
} else {
}
break;
}

var G__30672 = args30670.length;
switch (G__30672) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30670.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args30677 = [];
var len__27957__auto___30730 = arguments.length;
var i__27958__auto___30731 = (0);
while(true){
if((i__27958__auto___30731 < len__27957__auto___30730)){
args30677.push((arguments[i__27958__auto___30731]));

var G__30732 = (i__27958__auto___30731 + (1));
i__27958__auto___30731 = G__30732;
continue;
} else {
}
break;
}

var G__30679 = args30677.length;
switch (G__30679) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30677.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__30034__auto___30734 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___30734,tc,fc){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___30734,tc,fc){
return (function (state_30705){
var state_val_30706 = (state_30705[(1)]);
if((state_val_30706 === (7))){
var inst_30701 = (state_30705[(2)]);
var state_30705__$1 = state_30705;
var statearr_30707_30735 = state_30705__$1;
(statearr_30707_30735[(2)] = inst_30701);

(statearr_30707_30735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30706 === (1))){
var state_30705__$1 = state_30705;
var statearr_30708_30736 = state_30705__$1;
(statearr_30708_30736[(2)] = null);

(statearr_30708_30736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30706 === (4))){
var inst_30682 = (state_30705[(7)]);
var inst_30682__$1 = (state_30705[(2)]);
var inst_30683 = (inst_30682__$1 == null);
var state_30705__$1 = (function (){var statearr_30709 = state_30705;
(statearr_30709[(7)] = inst_30682__$1);

return statearr_30709;
})();
if(cljs.core.truth_(inst_30683)){
var statearr_30710_30737 = state_30705__$1;
(statearr_30710_30737[(1)] = (5));

} else {
var statearr_30711_30738 = state_30705__$1;
(statearr_30711_30738[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30706 === (13))){
var state_30705__$1 = state_30705;
var statearr_30712_30739 = state_30705__$1;
(statearr_30712_30739[(2)] = null);

(statearr_30712_30739[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30706 === (6))){
var inst_30682 = (state_30705[(7)]);
var inst_30688 = p.call(null,inst_30682);
var state_30705__$1 = state_30705;
if(cljs.core.truth_(inst_30688)){
var statearr_30713_30740 = state_30705__$1;
(statearr_30713_30740[(1)] = (9));

} else {
var statearr_30714_30741 = state_30705__$1;
(statearr_30714_30741[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30706 === (3))){
var inst_30703 = (state_30705[(2)]);
var state_30705__$1 = state_30705;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30705__$1,inst_30703);
} else {
if((state_val_30706 === (12))){
var state_30705__$1 = state_30705;
var statearr_30715_30742 = state_30705__$1;
(statearr_30715_30742[(2)] = null);

(statearr_30715_30742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30706 === (2))){
var state_30705__$1 = state_30705;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30705__$1,(4),ch);
} else {
if((state_val_30706 === (11))){
var inst_30682 = (state_30705[(7)]);
var inst_30692 = (state_30705[(2)]);
var state_30705__$1 = state_30705;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30705__$1,(8),inst_30692,inst_30682);
} else {
if((state_val_30706 === (9))){
var state_30705__$1 = state_30705;
var statearr_30716_30743 = state_30705__$1;
(statearr_30716_30743[(2)] = tc);

(statearr_30716_30743[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30706 === (5))){
var inst_30685 = cljs.core.async.close_BANG_.call(null,tc);
var inst_30686 = cljs.core.async.close_BANG_.call(null,fc);
var state_30705__$1 = (function (){var statearr_30717 = state_30705;
(statearr_30717[(8)] = inst_30685);

return statearr_30717;
})();
var statearr_30718_30744 = state_30705__$1;
(statearr_30718_30744[(2)] = inst_30686);

(statearr_30718_30744[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30706 === (14))){
var inst_30699 = (state_30705[(2)]);
var state_30705__$1 = state_30705;
var statearr_30719_30745 = state_30705__$1;
(statearr_30719_30745[(2)] = inst_30699);

(statearr_30719_30745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30706 === (10))){
var state_30705__$1 = state_30705;
var statearr_30720_30746 = state_30705__$1;
(statearr_30720_30746[(2)] = fc);

(statearr_30720_30746[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30706 === (8))){
var inst_30694 = (state_30705[(2)]);
var state_30705__$1 = state_30705;
if(cljs.core.truth_(inst_30694)){
var statearr_30721_30747 = state_30705__$1;
(statearr_30721_30747[(1)] = (12));

} else {
var statearr_30722_30748 = state_30705__$1;
(statearr_30722_30748[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___30734,tc,fc))
;
return ((function (switch__29920__auto__,c__30034__auto___30734,tc,fc){
return (function() {
var cljs$core$async$state_machine__29921__auto__ = null;
var cljs$core$async$state_machine__29921__auto____0 = (function (){
var statearr_30726 = [null,null,null,null,null,null,null,null,null];
(statearr_30726[(0)] = cljs$core$async$state_machine__29921__auto__);

(statearr_30726[(1)] = (1));

return statearr_30726;
});
var cljs$core$async$state_machine__29921__auto____1 = (function (state_30705){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_30705);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e30727){if((e30727 instanceof Object)){
var ex__29924__auto__ = e30727;
var statearr_30728_30749 = state_30705;
(statearr_30728_30749[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30705);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30727;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30750 = state_30705;
state_30705 = G__30750;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$state_machine__29921__auto__ = function(state_30705){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29921__auto____1.call(this,state_30705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29921__auto____0;
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29921__auto____1;
return cljs$core$async$state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___30734,tc,fc))
})();
var state__30036__auto__ = (function (){var statearr_30729 = f__30035__auto__.call(null);
(statearr_30729[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___30734);

return statearr_30729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___30734,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30034__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto__){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto__){
return (function (state_30814){
var state_val_30815 = (state_30814[(1)]);
if((state_val_30815 === (7))){
var inst_30810 = (state_30814[(2)]);
var state_30814__$1 = state_30814;
var statearr_30816_30837 = state_30814__$1;
(statearr_30816_30837[(2)] = inst_30810);

(statearr_30816_30837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30815 === (1))){
var inst_30794 = init;
var state_30814__$1 = (function (){var statearr_30817 = state_30814;
(statearr_30817[(7)] = inst_30794);

return statearr_30817;
})();
var statearr_30818_30838 = state_30814__$1;
(statearr_30818_30838[(2)] = null);

(statearr_30818_30838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30815 === (4))){
var inst_30797 = (state_30814[(8)]);
var inst_30797__$1 = (state_30814[(2)]);
var inst_30798 = (inst_30797__$1 == null);
var state_30814__$1 = (function (){var statearr_30819 = state_30814;
(statearr_30819[(8)] = inst_30797__$1);

return statearr_30819;
})();
if(cljs.core.truth_(inst_30798)){
var statearr_30820_30839 = state_30814__$1;
(statearr_30820_30839[(1)] = (5));

} else {
var statearr_30821_30840 = state_30814__$1;
(statearr_30821_30840[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30815 === (6))){
var inst_30797 = (state_30814[(8)]);
var inst_30794 = (state_30814[(7)]);
var inst_30801 = (state_30814[(9)]);
var inst_30801__$1 = f.call(null,inst_30794,inst_30797);
var inst_30802 = cljs.core.reduced_QMARK_.call(null,inst_30801__$1);
var state_30814__$1 = (function (){var statearr_30822 = state_30814;
(statearr_30822[(9)] = inst_30801__$1);

return statearr_30822;
})();
if(inst_30802){
var statearr_30823_30841 = state_30814__$1;
(statearr_30823_30841[(1)] = (8));

} else {
var statearr_30824_30842 = state_30814__$1;
(statearr_30824_30842[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30815 === (3))){
var inst_30812 = (state_30814[(2)]);
var state_30814__$1 = state_30814;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30814__$1,inst_30812);
} else {
if((state_val_30815 === (2))){
var state_30814__$1 = state_30814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30814__$1,(4),ch);
} else {
if((state_val_30815 === (9))){
var inst_30801 = (state_30814[(9)]);
var inst_30794 = inst_30801;
var state_30814__$1 = (function (){var statearr_30825 = state_30814;
(statearr_30825[(7)] = inst_30794);

return statearr_30825;
})();
var statearr_30826_30843 = state_30814__$1;
(statearr_30826_30843[(2)] = null);

(statearr_30826_30843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30815 === (5))){
var inst_30794 = (state_30814[(7)]);
var state_30814__$1 = state_30814;
var statearr_30827_30844 = state_30814__$1;
(statearr_30827_30844[(2)] = inst_30794);

(statearr_30827_30844[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30815 === (10))){
var inst_30808 = (state_30814[(2)]);
var state_30814__$1 = state_30814;
var statearr_30828_30845 = state_30814__$1;
(statearr_30828_30845[(2)] = inst_30808);

(statearr_30828_30845[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30815 === (8))){
var inst_30801 = (state_30814[(9)]);
var inst_30804 = cljs.core.deref.call(null,inst_30801);
var state_30814__$1 = state_30814;
var statearr_30829_30846 = state_30814__$1;
(statearr_30829_30846[(2)] = inst_30804);

(statearr_30829_30846[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto__))
;
return ((function (switch__29920__auto__,c__30034__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__29921__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29921__auto____0 = (function (){
var statearr_30833 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30833[(0)] = cljs$core$async$reduce_$_state_machine__29921__auto__);

(statearr_30833[(1)] = (1));

return statearr_30833;
});
var cljs$core$async$reduce_$_state_machine__29921__auto____1 = (function (state_30814){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_30814);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e30834){if((e30834 instanceof Object)){
var ex__29924__auto__ = e30834;
var statearr_30835_30847 = state_30814;
(statearr_30835_30847[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30814);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30834;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30848 = state_30814;
state_30814 = G__30848;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29921__auto__ = function(state_30814){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29921__auto____1.call(this,state_30814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29921__auto____0;
cljs$core$async$reduce_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29921__auto____1;
return cljs$core$async$reduce_$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto__))
})();
var state__30036__auto__ = (function (){var statearr_30836 = f__30035__auto__.call(null);
(statearr_30836[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto__);

return statearr_30836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto__))
);

return c__30034__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args30849 = [];
var len__27957__auto___30901 = arguments.length;
var i__27958__auto___30902 = (0);
while(true){
if((i__27958__auto___30902 < len__27957__auto___30901)){
args30849.push((arguments[i__27958__auto___30902]));

var G__30903 = (i__27958__auto___30902 + (1));
i__27958__auto___30902 = G__30903;
continue;
} else {
}
break;
}

var G__30851 = args30849.length;
switch (G__30851) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30849.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30034__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto__){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto__){
return (function (state_30876){
var state_val_30877 = (state_30876[(1)]);
if((state_val_30877 === (7))){
var inst_30858 = (state_30876[(2)]);
var state_30876__$1 = state_30876;
var statearr_30878_30905 = state_30876__$1;
(statearr_30878_30905[(2)] = inst_30858);

(statearr_30878_30905[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30877 === (1))){
var inst_30852 = cljs.core.seq.call(null,coll);
var inst_30853 = inst_30852;
var state_30876__$1 = (function (){var statearr_30879 = state_30876;
(statearr_30879[(7)] = inst_30853);

return statearr_30879;
})();
var statearr_30880_30906 = state_30876__$1;
(statearr_30880_30906[(2)] = null);

(statearr_30880_30906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30877 === (4))){
var inst_30853 = (state_30876[(7)]);
var inst_30856 = cljs.core.first.call(null,inst_30853);
var state_30876__$1 = state_30876;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30876__$1,(7),ch,inst_30856);
} else {
if((state_val_30877 === (13))){
var inst_30870 = (state_30876[(2)]);
var state_30876__$1 = state_30876;
var statearr_30881_30907 = state_30876__$1;
(statearr_30881_30907[(2)] = inst_30870);

(statearr_30881_30907[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30877 === (6))){
var inst_30861 = (state_30876[(2)]);
var state_30876__$1 = state_30876;
if(cljs.core.truth_(inst_30861)){
var statearr_30882_30908 = state_30876__$1;
(statearr_30882_30908[(1)] = (8));

} else {
var statearr_30883_30909 = state_30876__$1;
(statearr_30883_30909[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30877 === (3))){
var inst_30874 = (state_30876[(2)]);
var state_30876__$1 = state_30876;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30876__$1,inst_30874);
} else {
if((state_val_30877 === (12))){
var state_30876__$1 = state_30876;
var statearr_30884_30910 = state_30876__$1;
(statearr_30884_30910[(2)] = null);

(statearr_30884_30910[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30877 === (2))){
var inst_30853 = (state_30876[(7)]);
var state_30876__$1 = state_30876;
if(cljs.core.truth_(inst_30853)){
var statearr_30885_30911 = state_30876__$1;
(statearr_30885_30911[(1)] = (4));

} else {
var statearr_30886_30912 = state_30876__$1;
(statearr_30886_30912[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30877 === (11))){
var inst_30867 = cljs.core.async.close_BANG_.call(null,ch);
var state_30876__$1 = state_30876;
var statearr_30887_30913 = state_30876__$1;
(statearr_30887_30913[(2)] = inst_30867);

(statearr_30887_30913[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30877 === (9))){
var state_30876__$1 = state_30876;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30888_30914 = state_30876__$1;
(statearr_30888_30914[(1)] = (11));

} else {
var statearr_30889_30915 = state_30876__$1;
(statearr_30889_30915[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30877 === (5))){
var inst_30853 = (state_30876[(7)]);
var state_30876__$1 = state_30876;
var statearr_30890_30916 = state_30876__$1;
(statearr_30890_30916[(2)] = inst_30853);

(statearr_30890_30916[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30877 === (10))){
var inst_30872 = (state_30876[(2)]);
var state_30876__$1 = state_30876;
var statearr_30891_30917 = state_30876__$1;
(statearr_30891_30917[(2)] = inst_30872);

(statearr_30891_30917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30877 === (8))){
var inst_30853 = (state_30876[(7)]);
var inst_30863 = cljs.core.next.call(null,inst_30853);
var inst_30853__$1 = inst_30863;
var state_30876__$1 = (function (){var statearr_30892 = state_30876;
(statearr_30892[(7)] = inst_30853__$1);

return statearr_30892;
})();
var statearr_30893_30918 = state_30876__$1;
(statearr_30893_30918[(2)] = null);

(statearr_30893_30918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto__))
;
return ((function (switch__29920__auto__,c__30034__auto__){
return (function() {
var cljs$core$async$state_machine__29921__auto__ = null;
var cljs$core$async$state_machine__29921__auto____0 = (function (){
var statearr_30897 = [null,null,null,null,null,null,null,null];
(statearr_30897[(0)] = cljs$core$async$state_machine__29921__auto__);

(statearr_30897[(1)] = (1));

return statearr_30897;
});
var cljs$core$async$state_machine__29921__auto____1 = (function (state_30876){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_30876);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e30898){if((e30898 instanceof Object)){
var ex__29924__auto__ = e30898;
var statearr_30899_30919 = state_30876;
(statearr_30899_30919[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30876);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30898;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30920 = state_30876;
state_30876 = G__30920;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$state_machine__29921__auto__ = function(state_30876){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29921__auto____1.call(this,state_30876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29921__auto____0;
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29921__auto____1;
return cljs$core$async$state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto__))
})();
var state__30036__auto__ = (function (){var statearr_30900 = f__30035__auto__.call(null);
(statearr_30900[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto__);

return statearr_30900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto__))
);

return c__30034__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27454__auto__ = (((_ == null))?null:_);
var m__27455__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,_);
} else {
var m__27455__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27455__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m,ch);
} else {
var m__27455__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m);
} else {
var m__27455__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31146 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31146 = (function (ch,cs,meta31147){
this.ch = ch;
this.cs = cs;
this.meta31147 = meta31147;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_31148,meta31147__$1){
var self__ = this;
var _31148__$1 = this;
return (new cljs.core.async.t_cljs$core$async31146(self__.ch,self__.cs,meta31147__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_31148){
var self__ = this;
var _31148__$1 = this;
return self__.meta31147;
});})(cs))
;

cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31146.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31146.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31147","meta31147",1868148959,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async31146.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31146.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31146";

cljs.core.async.t_cljs$core$async31146.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async31146");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async31146 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async31146(ch__$1,cs__$1,meta31147){
return (new cljs.core.async.t_cljs$core$async31146(ch__$1,cs__$1,meta31147));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async31146(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__30034__auto___31371 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___31371,cs,m,dchan,dctr,done){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___31371,cs,m,dchan,dctr,done){
return (function (state_31283){
var state_val_31284 = (state_31283[(1)]);
if((state_val_31284 === (7))){
var inst_31279 = (state_31283[(2)]);
var state_31283__$1 = state_31283;
var statearr_31285_31372 = state_31283__$1;
(statearr_31285_31372[(2)] = inst_31279);

(statearr_31285_31372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (20))){
var inst_31182 = (state_31283[(7)]);
var inst_31194 = cljs.core.first.call(null,inst_31182);
var inst_31195 = cljs.core.nth.call(null,inst_31194,(0),null);
var inst_31196 = cljs.core.nth.call(null,inst_31194,(1),null);
var state_31283__$1 = (function (){var statearr_31286 = state_31283;
(statearr_31286[(8)] = inst_31195);

return statearr_31286;
})();
if(cljs.core.truth_(inst_31196)){
var statearr_31287_31373 = state_31283__$1;
(statearr_31287_31373[(1)] = (22));

} else {
var statearr_31288_31374 = state_31283__$1;
(statearr_31288_31374[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (27))){
var inst_31231 = (state_31283[(9)]);
var inst_31224 = (state_31283[(10)]);
var inst_31226 = (state_31283[(11)]);
var inst_31151 = (state_31283[(12)]);
var inst_31231__$1 = cljs.core._nth.call(null,inst_31224,inst_31226);
var inst_31232 = cljs.core.async.put_BANG_.call(null,inst_31231__$1,inst_31151,done);
var state_31283__$1 = (function (){var statearr_31289 = state_31283;
(statearr_31289[(9)] = inst_31231__$1);

return statearr_31289;
})();
if(cljs.core.truth_(inst_31232)){
var statearr_31290_31375 = state_31283__$1;
(statearr_31290_31375[(1)] = (30));

} else {
var statearr_31291_31376 = state_31283__$1;
(statearr_31291_31376[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (1))){
var state_31283__$1 = state_31283;
var statearr_31292_31377 = state_31283__$1;
(statearr_31292_31377[(2)] = null);

(statearr_31292_31377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (24))){
var inst_31182 = (state_31283[(7)]);
var inst_31201 = (state_31283[(2)]);
var inst_31202 = cljs.core.next.call(null,inst_31182);
var inst_31160 = inst_31202;
var inst_31161 = null;
var inst_31162 = (0);
var inst_31163 = (0);
var state_31283__$1 = (function (){var statearr_31293 = state_31283;
(statearr_31293[(13)] = inst_31162);

(statearr_31293[(14)] = inst_31160);

(statearr_31293[(15)] = inst_31163);

(statearr_31293[(16)] = inst_31201);

(statearr_31293[(17)] = inst_31161);

return statearr_31293;
})();
var statearr_31294_31378 = state_31283__$1;
(statearr_31294_31378[(2)] = null);

(statearr_31294_31378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (39))){
var state_31283__$1 = state_31283;
var statearr_31298_31379 = state_31283__$1;
(statearr_31298_31379[(2)] = null);

(statearr_31298_31379[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (4))){
var inst_31151 = (state_31283[(12)]);
var inst_31151__$1 = (state_31283[(2)]);
var inst_31152 = (inst_31151__$1 == null);
var state_31283__$1 = (function (){var statearr_31299 = state_31283;
(statearr_31299[(12)] = inst_31151__$1);

return statearr_31299;
})();
if(cljs.core.truth_(inst_31152)){
var statearr_31300_31380 = state_31283__$1;
(statearr_31300_31380[(1)] = (5));

} else {
var statearr_31301_31381 = state_31283__$1;
(statearr_31301_31381[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (15))){
var inst_31162 = (state_31283[(13)]);
var inst_31160 = (state_31283[(14)]);
var inst_31163 = (state_31283[(15)]);
var inst_31161 = (state_31283[(17)]);
var inst_31178 = (state_31283[(2)]);
var inst_31179 = (inst_31163 + (1));
var tmp31295 = inst_31162;
var tmp31296 = inst_31160;
var tmp31297 = inst_31161;
var inst_31160__$1 = tmp31296;
var inst_31161__$1 = tmp31297;
var inst_31162__$1 = tmp31295;
var inst_31163__$1 = inst_31179;
var state_31283__$1 = (function (){var statearr_31302 = state_31283;
(statearr_31302[(13)] = inst_31162__$1);

(statearr_31302[(14)] = inst_31160__$1);

(statearr_31302[(15)] = inst_31163__$1);

(statearr_31302[(18)] = inst_31178);

(statearr_31302[(17)] = inst_31161__$1);

return statearr_31302;
})();
var statearr_31303_31382 = state_31283__$1;
(statearr_31303_31382[(2)] = null);

(statearr_31303_31382[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (21))){
var inst_31205 = (state_31283[(2)]);
var state_31283__$1 = state_31283;
var statearr_31307_31383 = state_31283__$1;
(statearr_31307_31383[(2)] = inst_31205);

(statearr_31307_31383[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (31))){
var inst_31231 = (state_31283[(9)]);
var inst_31235 = done.call(null,null);
var inst_31236 = cljs.core.async.untap_STAR_.call(null,m,inst_31231);
var state_31283__$1 = (function (){var statearr_31308 = state_31283;
(statearr_31308[(19)] = inst_31235);

return statearr_31308;
})();
var statearr_31309_31384 = state_31283__$1;
(statearr_31309_31384[(2)] = inst_31236);

(statearr_31309_31384[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (32))){
var inst_31225 = (state_31283[(20)]);
var inst_31223 = (state_31283[(21)]);
var inst_31224 = (state_31283[(10)]);
var inst_31226 = (state_31283[(11)]);
var inst_31238 = (state_31283[(2)]);
var inst_31239 = (inst_31226 + (1));
var tmp31304 = inst_31225;
var tmp31305 = inst_31223;
var tmp31306 = inst_31224;
var inst_31223__$1 = tmp31305;
var inst_31224__$1 = tmp31306;
var inst_31225__$1 = tmp31304;
var inst_31226__$1 = inst_31239;
var state_31283__$1 = (function (){var statearr_31310 = state_31283;
(statearr_31310[(20)] = inst_31225__$1);

(statearr_31310[(21)] = inst_31223__$1);

(statearr_31310[(10)] = inst_31224__$1);

(statearr_31310[(11)] = inst_31226__$1);

(statearr_31310[(22)] = inst_31238);

return statearr_31310;
})();
var statearr_31311_31385 = state_31283__$1;
(statearr_31311_31385[(2)] = null);

(statearr_31311_31385[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (40))){
var inst_31251 = (state_31283[(23)]);
var inst_31255 = done.call(null,null);
var inst_31256 = cljs.core.async.untap_STAR_.call(null,m,inst_31251);
var state_31283__$1 = (function (){var statearr_31312 = state_31283;
(statearr_31312[(24)] = inst_31255);

return statearr_31312;
})();
var statearr_31313_31386 = state_31283__$1;
(statearr_31313_31386[(2)] = inst_31256);

(statearr_31313_31386[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (33))){
var inst_31242 = (state_31283[(25)]);
var inst_31244 = cljs.core.chunked_seq_QMARK_.call(null,inst_31242);
var state_31283__$1 = state_31283;
if(inst_31244){
var statearr_31314_31387 = state_31283__$1;
(statearr_31314_31387[(1)] = (36));

} else {
var statearr_31315_31388 = state_31283__$1;
(statearr_31315_31388[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (13))){
var inst_31172 = (state_31283[(26)]);
var inst_31175 = cljs.core.async.close_BANG_.call(null,inst_31172);
var state_31283__$1 = state_31283;
var statearr_31316_31389 = state_31283__$1;
(statearr_31316_31389[(2)] = inst_31175);

(statearr_31316_31389[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (22))){
var inst_31195 = (state_31283[(8)]);
var inst_31198 = cljs.core.async.close_BANG_.call(null,inst_31195);
var state_31283__$1 = state_31283;
var statearr_31317_31390 = state_31283__$1;
(statearr_31317_31390[(2)] = inst_31198);

(statearr_31317_31390[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (36))){
var inst_31242 = (state_31283[(25)]);
var inst_31246 = cljs.core.chunk_first.call(null,inst_31242);
var inst_31247 = cljs.core.chunk_rest.call(null,inst_31242);
var inst_31248 = cljs.core.count.call(null,inst_31246);
var inst_31223 = inst_31247;
var inst_31224 = inst_31246;
var inst_31225 = inst_31248;
var inst_31226 = (0);
var state_31283__$1 = (function (){var statearr_31318 = state_31283;
(statearr_31318[(20)] = inst_31225);

(statearr_31318[(21)] = inst_31223);

(statearr_31318[(10)] = inst_31224);

(statearr_31318[(11)] = inst_31226);

return statearr_31318;
})();
var statearr_31319_31391 = state_31283__$1;
(statearr_31319_31391[(2)] = null);

(statearr_31319_31391[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (41))){
var inst_31242 = (state_31283[(25)]);
var inst_31258 = (state_31283[(2)]);
var inst_31259 = cljs.core.next.call(null,inst_31242);
var inst_31223 = inst_31259;
var inst_31224 = null;
var inst_31225 = (0);
var inst_31226 = (0);
var state_31283__$1 = (function (){var statearr_31320 = state_31283;
(statearr_31320[(20)] = inst_31225);

(statearr_31320[(21)] = inst_31223);

(statearr_31320[(27)] = inst_31258);

(statearr_31320[(10)] = inst_31224);

(statearr_31320[(11)] = inst_31226);

return statearr_31320;
})();
var statearr_31321_31392 = state_31283__$1;
(statearr_31321_31392[(2)] = null);

(statearr_31321_31392[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (43))){
var state_31283__$1 = state_31283;
var statearr_31322_31393 = state_31283__$1;
(statearr_31322_31393[(2)] = null);

(statearr_31322_31393[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (29))){
var inst_31267 = (state_31283[(2)]);
var state_31283__$1 = state_31283;
var statearr_31323_31394 = state_31283__$1;
(statearr_31323_31394[(2)] = inst_31267);

(statearr_31323_31394[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (44))){
var inst_31276 = (state_31283[(2)]);
var state_31283__$1 = (function (){var statearr_31324 = state_31283;
(statearr_31324[(28)] = inst_31276);

return statearr_31324;
})();
var statearr_31325_31395 = state_31283__$1;
(statearr_31325_31395[(2)] = null);

(statearr_31325_31395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (6))){
var inst_31215 = (state_31283[(29)]);
var inst_31214 = cljs.core.deref.call(null,cs);
var inst_31215__$1 = cljs.core.keys.call(null,inst_31214);
var inst_31216 = cljs.core.count.call(null,inst_31215__$1);
var inst_31217 = cljs.core.reset_BANG_.call(null,dctr,inst_31216);
var inst_31222 = cljs.core.seq.call(null,inst_31215__$1);
var inst_31223 = inst_31222;
var inst_31224 = null;
var inst_31225 = (0);
var inst_31226 = (0);
var state_31283__$1 = (function (){var statearr_31326 = state_31283;
(statearr_31326[(29)] = inst_31215__$1);

(statearr_31326[(20)] = inst_31225);

(statearr_31326[(21)] = inst_31223);

(statearr_31326[(10)] = inst_31224);

(statearr_31326[(11)] = inst_31226);

(statearr_31326[(30)] = inst_31217);

return statearr_31326;
})();
var statearr_31327_31396 = state_31283__$1;
(statearr_31327_31396[(2)] = null);

(statearr_31327_31396[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (28))){
var inst_31223 = (state_31283[(21)]);
var inst_31242 = (state_31283[(25)]);
var inst_31242__$1 = cljs.core.seq.call(null,inst_31223);
var state_31283__$1 = (function (){var statearr_31328 = state_31283;
(statearr_31328[(25)] = inst_31242__$1);

return statearr_31328;
})();
if(inst_31242__$1){
var statearr_31329_31397 = state_31283__$1;
(statearr_31329_31397[(1)] = (33));

} else {
var statearr_31330_31398 = state_31283__$1;
(statearr_31330_31398[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (25))){
var inst_31225 = (state_31283[(20)]);
var inst_31226 = (state_31283[(11)]);
var inst_31228 = (inst_31226 < inst_31225);
var inst_31229 = inst_31228;
var state_31283__$1 = state_31283;
if(cljs.core.truth_(inst_31229)){
var statearr_31331_31399 = state_31283__$1;
(statearr_31331_31399[(1)] = (27));

} else {
var statearr_31332_31400 = state_31283__$1;
(statearr_31332_31400[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (34))){
var state_31283__$1 = state_31283;
var statearr_31333_31401 = state_31283__$1;
(statearr_31333_31401[(2)] = null);

(statearr_31333_31401[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (17))){
var state_31283__$1 = state_31283;
var statearr_31334_31402 = state_31283__$1;
(statearr_31334_31402[(2)] = null);

(statearr_31334_31402[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (3))){
var inst_31281 = (state_31283[(2)]);
var state_31283__$1 = state_31283;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31283__$1,inst_31281);
} else {
if((state_val_31284 === (12))){
var inst_31210 = (state_31283[(2)]);
var state_31283__$1 = state_31283;
var statearr_31335_31403 = state_31283__$1;
(statearr_31335_31403[(2)] = inst_31210);

(statearr_31335_31403[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (2))){
var state_31283__$1 = state_31283;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31283__$1,(4),ch);
} else {
if((state_val_31284 === (23))){
var state_31283__$1 = state_31283;
var statearr_31336_31404 = state_31283__$1;
(statearr_31336_31404[(2)] = null);

(statearr_31336_31404[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (35))){
var inst_31265 = (state_31283[(2)]);
var state_31283__$1 = state_31283;
var statearr_31337_31405 = state_31283__$1;
(statearr_31337_31405[(2)] = inst_31265);

(statearr_31337_31405[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (19))){
var inst_31182 = (state_31283[(7)]);
var inst_31186 = cljs.core.chunk_first.call(null,inst_31182);
var inst_31187 = cljs.core.chunk_rest.call(null,inst_31182);
var inst_31188 = cljs.core.count.call(null,inst_31186);
var inst_31160 = inst_31187;
var inst_31161 = inst_31186;
var inst_31162 = inst_31188;
var inst_31163 = (0);
var state_31283__$1 = (function (){var statearr_31338 = state_31283;
(statearr_31338[(13)] = inst_31162);

(statearr_31338[(14)] = inst_31160);

(statearr_31338[(15)] = inst_31163);

(statearr_31338[(17)] = inst_31161);

return statearr_31338;
})();
var statearr_31339_31406 = state_31283__$1;
(statearr_31339_31406[(2)] = null);

(statearr_31339_31406[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (11))){
var inst_31160 = (state_31283[(14)]);
var inst_31182 = (state_31283[(7)]);
var inst_31182__$1 = cljs.core.seq.call(null,inst_31160);
var state_31283__$1 = (function (){var statearr_31340 = state_31283;
(statearr_31340[(7)] = inst_31182__$1);

return statearr_31340;
})();
if(inst_31182__$1){
var statearr_31341_31407 = state_31283__$1;
(statearr_31341_31407[(1)] = (16));

} else {
var statearr_31342_31408 = state_31283__$1;
(statearr_31342_31408[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (9))){
var inst_31212 = (state_31283[(2)]);
var state_31283__$1 = state_31283;
var statearr_31343_31409 = state_31283__$1;
(statearr_31343_31409[(2)] = inst_31212);

(statearr_31343_31409[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (5))){
var inst_31158 = cljs.core.deref.call(null,cs);
var inst_31159 = cljs.core.seq.call(null,inst_31158);
var inst_31160 = inst_31159;
var inst_31161 = null;
var inst_31162 = (0);
var inst_31163 = (0);
var state_31283__$1 = (function (){var statearr_31344 = state_31283;
(statearr_31344[(13)] = inst_31162);

(statearr_31344[(14)] = inst_31160);

(statearr_31344[(15)] = inst_31163);

(statearr_31344[(17)] = inst_31161);

return statearr_31344;
})();
var statearr_31345_31410 = state_31283__$1;
(statearr_31345_31410[(2)] = null);

(statearr_31345_31410[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (14))){
var state_31283__$1 = state_31283;
var statearr_31346_31411 = state_31283__$1;
(statearr_31346_31411[(2)] = null);

(statearr_31346_31411[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (45))){
var inst_31273 = (state_31283[(2)]);
var state_31283__$1 = state_31283;
var statearr_31347_31412 = state_31283__$1;
(statearr_31347_31412[(2)] = inst_31273);

(statearr_31347_31412[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (26))){
var inst_31215 = (state_31283[(29)]);
var inst_31269 = (state_31283[(2)]);
var inst_31270 = cljs.core.seq.call(null,inst_31215);
var state_31283__$1 = (function (){var statearr_31348 = state_31283;
(statearr_31348[(31)] = inst_31269);

return statearr_31348;
})();
if(inst_31270){
var statearr_31349_31413 = state_31283__$1;
(statearr_31349_31413[(1)] = (42));

} else {
var statearr_31350_31414 = state_31283__$1;
(statearr_31350_31414[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (16))){
var inst_31182 = (state_31283[(7)]);
var inst_31184 = cljs.core.chunked_seq_QMARK_.call(null,inst_31182);
var state_31283__$1 = state_31283;
if(inst_31184){
var statearr_31351_31415 = state_31283__$1;
(statearr_31351_31415[(1)] = (19));

} else {
var statearr_31352_31416 = state_31283__$1;
(statearr_31352_31416[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (38))){
var inst_31262 = (state_31283[(2)]);
var state_31283__$1 = state_31283;
var statearr_31353_31417 = state_31283__$1;
(statearr_31353_31417[(2)] = inst_31262);

(statearr_31353_31417[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (30))){
var state_31283__$1 = state_31283;
var statearr_31354_31418 = state_31283__$1;
(statearr_31354_31418[(2)] = null);

(statearr_31354_31418[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (10))){
var inst_31163 = (state_31283[(15)]);
var inst_31161 = (state_31283[(17)]);
var inst_31171 = cljs.core._nth.call(null,inst_31161,inst_31163);
var inst_31172 = cljs.core.nth.call(null,inst_31171,(0),null);
var inst_31173 = cljs.core.nth.call(null,inst_31171,(1),null);
var state_31283__$1 = (function (){var statearr_31355 = state_31283;
(statearr_31355[(26)] = inst_31172);

return statearr_31355;
})();
if(cljs.core.truth_(inst_31173)){
var statearr_31356_31419 = state_31283__$1;
(statearr_31356_31419[(1)] = (13));

} else {
var statearr_31357_31420 = state_31283__$1;
(statearr_31357_31420[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (18))){
var inst_31208 = (state_31283[(2)]);
var state_31283__$1 = state_31283;
var statearr_31358_31421 = state_31283__$1;
(statearr_31358_31421[(2)] = inst_31208);

(statearr_31358_31421[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (42))){
var state_31283__$1 = state_31283;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31283__$1,(45),dchan);
} else {
if((state_val_31284 === (37))){
var inst_31251 = (state_31283[(23)]);
var inst_31151 = (state_31283[(12)]);
var inst_31242 = (state_31283[(25)]);
var inst_31251__$1 = cljs.core.first.call(null,inst_31242);
var inst_31252 = cljs.core.async.put_BANG_.call(null,inst_31251__$1,inst_31151,done);
var state_31283__$1 = (function (){var statearr_31359 = state_31283;
(statearr_31359[(23)] = inst_31251__$1);

return statearr_31359;
})();
if(cljs.core.truth_(inst_31252)){
var statearr_31360_31422 = state_31283__$1;
(statearr_31360_31422[(1)] = (39));

} else {
var statearr_31361_31423 = state_31283__$1;
(statearr_31361_31423[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31284 === (8))){
var inst_31162 = (state_31283[(13)]);
var inst_31163 = (state_31283[(15)]);
var inst_31165 = (inst_31163 < inst_31162);
var inst_31166 = inst_31165;
var state_31283__$1 = state_31283;
if(cljs.core.truth_(inst_31166)){
var statearr_31362_31424 = state_31283__$1;
(statearr_31362_31424[(1)] = (10));

} else {
var statearr_31363_31425 = state_31283__$1;
(statearr_31363_31425[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___31371,cs,m,dchan,dctr,done))
;
return ((function (switch__29920__auto__,c__30034__auto___31371,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__29921__auto__ = null;
var cljs$core$async$mult_$_state_machine__29921__auto____0 = (function (){
var statearr_31367 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31367[(0)] = cljs$core$async$mult_$_state_machine__29921__auto__);

(statearr_31367[(1)] = (1));

return statearr_31367;
});
var cljs$core$async$mult_$_state_machine__29921__auto____1 = (function (state_31283){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_31283);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e31368){if((e31368 instanceof Object)){
var ex__29924__auto__ = e31368;
var statearr_31369_31426 = state_31283;
(statearr_31369_31426[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31283);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31368;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31427 = state_31283;
state_31283 = G__31427;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29921__auto__ = function(state_31283){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29921__auto____1.call(this,state_31283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29921__auto____0;
cljs$core$async$mult_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29921__auto____1;
return cljs$core$async$mult_$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___31371,cs,m,dchan,dctr,done))
})();
var state__30036__auto__ = (function (){var statearr_31370 = f__30035__auto__.call(null);
(statearr_31370[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___31371);

return statearr_31370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___31371,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args31428 = [];
var len__27957__auto___31431 = arguments.length;
var i__27958__auto___31432 = (0);
while(true){
if((i__27958__auto___31432 < len__27957__auto___31431)){
args31428.push((arguments[i__27958__auto___31432]));

var G__31433 = (i__27958__auto___31432 + (1));
i__27958__auto___31432 = G__31433;
continue;
} else {
}
break;
}

var G__31430 = args31428.length;
switch (G__31430) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31428.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m,ch);
} else {
var m__27455__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m,ch);
} else {
var m__27455__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m);
} else {
var m__27455__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m,state_map);
} else {
var m__27455__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m,mode);
} else {
var m__27455__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__27964__auto__ = [];
var len__27957__auto___31445 = arguments.length;
var i__27958__auto___31446 = (0);
while(true){
if((i__27958__auto___31446 < len__27957__auto___31445)){
args__27964__auto__.push((arguments[i__27958__auto___31446]));

var G__31447 = (i__27958__auto___31446 + (1));
i__27958__auto___31446 = G__31447;
continue;
} else {
}
break;
}

var argseq__27965__auto__ = ((((3) < args__27964__auto__.length))?(new cljs.core.IndexedSeq(args__27964__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__27965__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31439){
var map__31440 = p__31439;
var map__31440__$1 = ((((!((map__31440 == null)))?((((map__31440.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31440.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31440):map__31440);
var opts = map__31440__$1;
var statearr_31442_31448 = state;
(statearr_31442_31448[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__31440,map__31440__$1,opts){
return (function (val){
var statearr_31443_31449 = state;
(statearr_31443_31449[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__31440,map__31440__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_31444_31450 = state;
(statearr_31444_31450[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31435){
var G__31436 = cljs.core.first.call(null,seq31435);
var seq31435__$1 = cljs.core.next.call(null,seq31435);
var G__31437 = cljs.core.first.call(null,seq31435__$1);
var seq31435__$2 = cljs.core.next.call(null,seq31435__$1);
var G__31438 = cljs.core.first.call(null,seq31435__$2);
var seq31435__$3 = cljs.core.next.call(null,seq31435__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31436,G__31437,G__31438,seq31435__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31618 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31618 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta31619){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta31619 = meta31619;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31618.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31620,meta31619__$1){
var self__ = this;
var _31620__$1 = this;
return (new cljs.core.async.t_cljs$core$async31618(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta31619__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31618.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31620){
var self__ = this;
var _31620__$1 = this;
return self__.meta31619;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31618.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31618.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31618.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31618.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31618.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31618.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31618.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31618.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31618.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta31619","meta31619",-1774813902,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31618.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31618.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31618";

cljs.core.async.t_cljs$core$async31618.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async31618");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async31618 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async31618(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31619){
return (new cljs.core.async.t_cljs$core$async31618(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31619));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async31618(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30034__auto___31785 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___31785,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___31785,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31722){
var state_val_31723 = (state_31722[(1)]);
if((state_val_31723 === (7))){
var inst_31637 = (state_31722[(2)]);
var state_31722__$1 = state_31722;
var statearr_31724_31786 = state_31722__$1;
(statearr_31724_31786[(2)] = inst_31637);

(statearr_31724_31786[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (20))){
var inst_31649 = (state_31722[(7)]);
var state_31722__$1 = state_31722;
var statearr_31725_31787 = state_31722__$1;
(statearr_31725_31787[(2)] = inst_31649);

(statearr_31725_31787[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (27))){
var state_31722__$1 = state_31722;
var statearr_31726_31788 = state_31722__$1;
(statearr_31726_31788[(2)] = null);

(statearr_31726_31788[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (1))){
var inst_31624 = (state_31722[(8)]);
var inst_31624__$1 = calc_state.call(null);
var inst_31626 = (inst_31624__$1 == null);
var inst_31627 = cljs.core.not.call(null,inst_31626);
var state_31722__$1 = (function (){var statearr_31727 = state_31722;
(statearr_31727[(8)] = inst_31624__$1);

return statearr_31727;
})();
if(inst_31627){
var statearr_31728_31789 = state_31722__$1;
(statearr_31728_31789[(1)] = (2));

} else {
var statearr_31729_31790 = state_31722__$1;
(statearr_31729_31790[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (24))){
var inst_31696 = (state_31722[(9)]);
var inst_31682 = (state_31722[(10)]);
var inst_31673 = (state_31722[(11)]);
var inst_31696__$1 = inst_31673.call(null,inst_31682);
var state_31722__$1 = (function (){var statearr_31730 = state_31722;
(statearr_31730[(9)] = inst_31696__$1);

return statearr_31730;
})();
if(cljs.core.truth_(inst_31696__$1)){
var statearr_31731_31791 = state_31722__$1;
(statearr_31731_31791[(1)] = (29));

} else {
var statearr_31732_31792 = state_31722__$1;
(statearr_31732_31792[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (4))){
var inst_31640 = (state_31722[(2)]);
var state_31722__$1 = state_31722;
if(cljs.core.truth_(inst_31640)){
var statearr_31733_31793 = state_31722__$1;
(statearr_31733_31793[(1)] = (8));

} else {
var statearr_31734_31794 = state_31722__$1;
(statearr_31734_31794[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (15))){
var inst_31667 = (state_31722[(2)]);
var state_31722__$1 = state_31722;
if(cljs.core.truth_(inst_31667)){
var statearr_31735_31795 = state_31722__$1;
(statearr_31735_31795[(1)] = (19));

} else {
var statearr_31736_31796 = state_31722__$1;
(statearr_31736_31796[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (21))){
var inst_31672 = (state_31722[(12)]);
var inst_31672__$1 = (state_31722[(2)]);
var inst_31673 = cljs.core.get.call(null,inst_31672__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31674 = cljs.core.get.call(null,inst_31672__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31675 = cljs.core.get.call(null,inst_31672__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31722__$1 = (function (){var statearr_31737 = state_31722;
(statearr_31737[(13)] = inst_31674);

(statearr_31737[(12)] = inst_31672__$1);

(statearr_31737[(11)] = inst_31673);

return statearr_31737;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31722__$1,(22),inst_31675);
} else {
if((state_val_31723 === (31))){
var inst_31704 = (state_31722[(2)]);
var state_31722__$1 = state_31722;
if(cljs.core.truth_(inst_31704)){
var statearr_31738_31797 = state_31722__$1;
(statearr_31738_31797[(1)] = (32));

} else {
var statearr_31739_31798 = state_31722__$1;
(statearr_31739_31798[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (32))){
var inst_31681 = (state_31722[(14)]);
var state_31722__$1 = state_31722;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31722__$1,(35),out,inst_31681);
} else {
if((state_val_31723 === (33))){
var inst_31672 = (state_31722[(12)]);
var inst_31649 = inst_31672;
var state_31722__$1 = (function (){var statearr_31740 = state_31722;
(statearr_31740[(7)] = inst_31649);

return statearr_31740;
})();
var statearr_31741_31799 = state_31722__$1;
(statearr_31741_31799[(2)] = null);

(statearr_31741_31799[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (13))){
var inst_31649 = (state_31722[(7)]);
var inst_31656 = inst_31649.cljs$lang$protocol_mask$partition0$;
var inst_31657 = (inst_31656 & (64));
var inst_31658 = inst_31649.cljs$core$ISeq$;
var inst_31659 = (cljs.core.PROTOCOL_SENTINEL === inst_31658);
var inst_31660 = (inst_31657) || (inst_31659);
var state_31722__$1 = state_31722;
if(cljs.core.truth_(inst_31660)){
var statearr_31742_31800 = state_31722__$1;
(statearr_31742_31800[(1)] = (16));

} else {
var statearr_31743_31801 = state_31722__$1;
(statearr_31743_31801[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (22))){
var inst_31682 = (state_31722[(10)]);
var inst_31681 = (state_31722[(14)]);
var inst_31680 = (state_31722[(2)]);
var inst_31681__$1 = cljs.core.nth.call(null,inst_31680,(0),null);
var inst_31682__$1 = cljs.core.nth.call(null,inst_31680,(1),null);
var inst_31683 = (inst_31681__$1 == null);
var inst_31684 = cljs.core._EQ_.call(null,inst_31682__$1,change);
var inst_31685 = (inst_31683) || (inst_31684);
var state_31722__$1 = (function (){var statearr_31744 = state_31722;
(statearr_31744[(10)] = inst_31682__$1);

(statearr_31744[(14)] = inst_31681__$1);

return statearr_31744;
})();
if(cljs.core.truth_(inst_31685)){
var statearr_31745_31802 = state_31722__$1;
(statearr_31745_31802[(1)] = (23));

} else {
var statearr_31746_31803 = state_31722__$1;
(statearr_31746_31803[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (36))){
var inst_31672 = (state_31722[(12)]);
var inst_31649 = inst_31672;
var state_31722__$1 = (function (){var statearr_31747 = state_31722;
(statearr_31747[(7)] = inst_31649);

return statearr_31747;
})();
var statearr_31748_31804 = state_31722__$1;
(statearr_31748_31804[(2)] = null);

(statearr_31748_31804[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (29))){
var inst_31696 = (state_31722[(9)]);
var state_31722__$1 = state_31722;
var statearr_31749_31805 = state_31722__$1;
(statearr_31749_31805[(2)] = inst_31696);

(statearr_31749_31805[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (6))){
var state_31722__$1 = state_31722;
var statearr_31750_31806 = state_31722__$1;
(statearr_31750_31806[(2)] = false);

(statearr_31750_31806[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (28))){
var inst_31692 = (state_31722[(2)]);
var inst_31693 = calc_state.call(null);
var inst_31649 = inst_31693;
var state_31722__$1 = (function (){var statearr_31751 = state_31722;
(statearr_31751[(7)] = inst_31649);

(statearr_31751[(15)] = inst_31692);

return statearr_31751;
})();
var statearr_31752_31807 = state_31722__$1;
(statearr_31752_31807[(2)] = null);

(statearr_31752_31807[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (25))){
var inst_31718 = (state_31722[(2)]);
var state_31722__$1 = state_31722;
var statearr_31753_31808 = state_31722__$1;
(statearr_31753_31808[(2)] = inst_31718);

(statearr_31753_31808[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (34))){
var inst_31716 = (state_31722[(2)]);
var state_31722__$1 = state_31722;
var statearr_31754_31809 = state_31722__$1;
(statearr_31754_31809[(2)] = inst_31716);

(statearr_31754_31809[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (17))){
var state_31722__$1 = state_31722;
var statearr_31755_31810 = state_31722__$1;
(statearr_31755_31810[(2)] = false);

(statearr_31755_31810[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (3))){
var state_31722__$1 = state_31722;
var statearr_31756_31811 = state_31722__$1;
(statearr_31756_31811[(2)] = false);

(statearr_31756_31811[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (12))){
var inst_31720 = (state_31722[(2)]);
var state_31722__$1 = state_31722;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31722__$1,inst_31720);
} else {
if((state_val_31723 === (2))){
var inst_31624 = (state_31722[(8)]);
var inst_31629 = inst_31624.cljs$lang$protocol_mask$partition0$;
var inst_31630 = (inst_31629 & (64));
var inst_31631 = inst_31624.cljs$core$ISeq$;
var inst_31632 = (cljs.core.PROTOCOL_SENTINEL === inst_31631);
var inst_31633 = (inst_31630) || (inst_31632);
var state_31722__$1 = state_31722;
if(cljs.core.truth_(inst_31633)){
var statearr_31757_31812 = state_31722__$1;
(statearr_31757_31812[(1)] = (5));

} else {
var statearr_31758_31813 = state_31722__$1;
(statearr_31758_31813[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (23))){
var inst_31681 = (state_31722[(14)]);
var inst_31687 = (inst_31681 == null);
var state_31722__$1 = state_31722;
if(cljs.core.truth_(inst_31687)){
var statearr_31759_31814 = state_31722__$1;
(statearr_31759_31814[(1)] = (26));

} else {
var statearr_31760_31815 = state_31722__$1;
(statearr_31760_31815[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (35))){
var inst_31707 = (state_31722[(2)]);
var state_31722__$1 = state_31722;
if(cljs.core.truth_(inst_31707)){
var statearr_31761_31816 = state_31722__$1;
(statearr_31761_31816[(1)] = (36));

} else {
var statearr_31762_31817 = state_31722__$1;
(statearr_31762_31817[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (19))){
var inst_31649 = (state_31722[(7)]);
var inst_31669 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31649);
var state_31722__$1 = state_31722;
var statearr_31763_31818 = state_31722__$1;
(statearr_31763_31818[(2)] = inst_31669);

(statearr_31763_31818[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (11))){
var inst_31649 = (state_31722[(7)]);
var inst_31653 = (inst_31649 == null);
var inst_31654 = cljs.core.not.call(null,inst_31653);
var state_31722__$1 = state_31722;
if(inst_31654){
var statearr_31764_31819 = state_31722__$1;
(statearr_31764_31819[(1)] = (13));

} else {
var statearr_31765_31820 = state_31722__$1;
(statearr_31765_31820[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (9))){
var inst_31624 = (state_31722[(8)]);
var state_31722__$1 = state_31722;
var statearr_31766_31821 = state_31722__$1;
(statearr_31766_31821[(2)] = inst_31624);

(statearr_31766_31821[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (5))){
var state_31722__$1 = state_31722;
var statearr_31767_31822 = state_31722__$1;
(statearr_31767_31822[(2)] = true);

(statearr_31767_31822[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (14))){
var state_31722__$1 = state_31722;
var statearr_31768_31823 = state_31722__$1;
(statearr_31768_31823[(2)] = false);

(statearr_31768_31823[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (26))){
var inst_31682 = (state_31722[(10)]);
var inst_31689 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_31682);
var state_31722__$1 = state_31722;
var statearr_31769_31824 = state_31722__$1;
(statearr_31769_31824[(2)] = inst_31689);

(statearr_31769_31824[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (16))){
var state_31722__$1 = state_31722;
var statearr_31770_31825 = state_31722__$1;
(statearr_31770_31825[(2)] = true);

(statearr_31770_31825[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (38))){
var inst_31712 = (state_31722[(2)]);
var state_31722__$1 = state_31722;
var statearr_31771_31826 = state_31722__$1;
(statearr_31771_31826[(2)] = inst_31712);

(statearr_31771_31826[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (30))){
var inst_31674 = (state_31722[(13)]);
var inst_31682 = (state_31722[(10)]);
var inst_31673 = (state_31722[(11)]);
var inst_31699 = cljs.core.empty_QMARK_.call(null,inst_31673);
var inst_31700 = inst_31674.call(null,inst_31682);
var inst_31701 = cljs.core.not.call(null,inst_31700);
var inst_31702 = (inst_31699) && (inst_31701);
var state_31722__$1 = state_31722;
var statearr_31772_31827 = state_31722__$1;
(statearr_31772_31827[(2)] = inst_31702);

(statearr_31772_31827[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (10))){
var inst_31624 = (state_31722[(8)]);
var inst_31645 = (state_31722[(2)]);
var inst_31646 = cljs.core.get.call(null,inst_31645,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31647 = cljs.core.get.call(null,inst_31645,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31648 = cljs.core.get.call(null,inst_31645,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31649 = inst_31624;
var state_31722__$1 = (function (){var statearr_31773 = state_31722;
(statearr_31773[(7)] = inst_31649);

(statearr_31773[(16)] = inst_31647);

(statearr_31773[(17)] = inst_31648);

(statearr_31773[(18)] = inst_31646);

return statearr_31773;
})();
var statearr_31774_31828 = state_31722__$1;
(statearr_31774_31828[(2)] = null);

(statearr_31774_31828[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (18))){
var inst_31664 = (state_31722[(2)]);
var state_31722__$1 = state_31722;
var statearr_31775_31829 = state_31722__$1;
(statearr_31775_31829[(2)] = inst_31664);

(statearr_31775_31829[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (37))){
var state_31722__$1 = state_31722;
var statearr_31776_31830 = state_31722__$1;
(statearr_31776_31830[(2)] = null);

(statearr_31776_31830[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31723 === (8))){
var inst_31624 = (state_31722[(8)]);
var inst_31642 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31624);
var state_31722__$1 = state_31722;
var statearr_31777_31831 = state_31722__$1;
(statearr_31777_31831[(2)] = inst_31642);

(statearr_31777_31831[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___31785,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__29920__auto__,c__30034__auto___31785,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__29921__auto__ = null;
var cljs$core$async$mix_$_state_machine__29921__auto____0 = (function (){
var statearr_31781 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31781[(0)] = cljs$core$async$mix_$_state_machine__29921__auto__);

(statearr_31781[(1)] = (1));

return statearr_31781;
});
var cljs$core$async$mix_$_state_machine__29921__auto____1 = (function (state_31722){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_31722);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e31782){if((e31782 instanceof Object)){
var ex__29924__auto__ = e31782;
var statearr_31783_31832 = state_31722;
(statearr_31783_31832[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31722);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31782;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31833 = state_31722;
state_31722 = G__31833;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29921__auto__ = function(state_31722){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29921__auto____1.call(this,state_31722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29921__auto____0;
cljs$core$async$mix_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29921__auto____1;
return cljs$core$async$mix_$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___31785,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__30036__auto__ = (function (){var statearr_31784 = f__30035__auto__.call(null);
(statearr_31784[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___31785);

return statearr_31784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___31785,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27454__auto__ = (((p == null))?null:p);
var m__27455__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27455__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27454__auto__ = (((p == null))?null:p);
var m__27455__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,p,v,ch);
} else {
var m__27455__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args31834 = [];
var len__27957__auto___31837 = arguments.length;
var i__27958__auto___31838 = (0);
while(true){
if((i__27958__auto___31838 < len__27957__auto___31837)){
args31834.push((arguments[i__27958__auto___31838]));

var G__31839 = (i__27958__auto___31838 + (1));
i__27958__auto___31838 = G__31839;
continue;
} else {
}
break;
}

var G__31836 = args31834.length;
switch (G__31836) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31834.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27454__auto__ = (((p == null))?null:p);
var m__27455__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,p);
} else {
var m__27455__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27454__auto__ = (((p == null))?null:p);
var m__27455__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,p,v);
} else {
var m__27455__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args31842 = [];
var len__27957__auto___31967 = arguments.length;
var i__27958__auto___31968 = (0);
while(true){
if((i__27958__auto___31968 < len__27957__auto___31967)){
args31842.push((arguments[i__27958__auto___31968]));

var G__31969 = (i__27958__auto___31968 + (1));
i__27958__auto___31968 = G__31969;
continue;
} else {
}
break;
}

var G__31844 = args31842.length;
switch (G__31844) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31842.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__26741__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__26741__auto__,mults){
return (function (p1__31841_SHARP_){
if(cljs.core.truth_(p1__31841_SHARP_.call(null,topic))){
return p1__31841_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__31841_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__26741__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async31845 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31845 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31846){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31846 = meta31846;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31845.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31847,meta31846__$1){
var self__ = this;
var _31847__$1 = this;
return (new cljs.core.async.t_cljs$core$async31845(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31846__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31845.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31847){
var self__ = this;
var _31847__$1 = this;
return self__.meta31846;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31845.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31845.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31845.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31845.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31845.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31845.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31845.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31845.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31846","meta31846",-1517297252,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31845.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31845.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31845";

cljs.core.async.t_cljs$core$async31845.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async31845");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async31845 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async31845(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31846){
return (new cljs.core.async.t_cljs$core$async31845(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31846));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async31845(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30034__auto___31971 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___31971,mults,ensure_mult,p){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___31971,mults,ensure_mult,p){
return (function (state_31919){
var state_val_31920 = (state_31919[(1)]);
if((state_val_31920 === (7))){
var inst_31915 = (state_31919[(2)]);
var state_31919__$1 = state_31919;
var statearr_31921_31972 = state_31919__$1;
(statearr_31921_31972[(2)] = inst_31915);

(statearr_31921_31972[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (20))){
var state_31919__$1 = state_31919;
var statearr_31922_31973 = state_31919__$1;
(statearr_31922_31973[(2)] = null);

(statearr_31922_31973[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (1))){
var state_31919__$1 = state_31919;
var statearr_31923_31974 = state_31919__$1;
(statearr_31923_31974[(2)] = null);

(statearr_31923_31974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (24))){
var inst_31898 = (state_31919[(7)]);
var inst_31907 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_31898);
var state_31919__$1 = state_31919;
var statearr_31924_31975 = state_31919__$1;
(statearr_31924_31975[(2)] = inst_31907);

(statearr_31924_31975[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (4))){
var inst_31850 = (state_31919[(8)]);
var inst_31850__$1 = (state_31919[(2)]);
var inst_31851 = (inst_31850__$1 == null);
var state_31919__$1 = (function (){var statearr_31925 = state_31919;
(statearr_31925[(8)] = inst_31850__$1);

return statearr_31925;
})();
if(cljs.core.truth_(inst_31851)){
var statearr_31926_31976 = state_31919__$1;
(statearr_31926_31976[(1)] = (5));

} else {
var statearr_31927_31977 = state_31919__$1;
(statearr_31927_31977[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (15))){
var inst_31892 = (state_31919[(2)]);
var state_31919__$1 = state_31919;
var statearr_31928_31978 = state_31919__$1;
(statearr_31928_31978[(2)] = inst_31892);

(statearr_31928_31978[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (21))){
var inst_31912 = (state_31919[(2)]);
var state_31919__$1 = (function (){var statearr_31929 = state_31919;
(statearr_31929[(9)] = inst_31912);

return statearr_31929;
})();
var statearr_31930_31979 = state_31919__$1;
(statearr_31930_31979[(2)] = null);

(statearr_31930_31979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (13))){
var inst_31874 = (state_31919[(10)]);
var inst_31876 = cljs.core.chunked_seq_QMARK_.call(null,inst_31874);
var state_31919__$1 = state_31919;
if(inst_31876){
var statearr_31931_31980 = state_31919__$1;
(statearr_31931_31980[(1)] = (16));

} else {
var statearr_31932_31981 = state_31919__$1;
(statearr_31932_31981[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (22))){
var inst_31904 = (state_31919[(2)]);
var state_31919__$1 = state_31919;
if(cljs.core.truth_(inst_31904)){
var statearr_31933_31982 = state_31919__$1;
(statearr_31933_31982[(1)] = (23));

} else {
var statearr_31934_31983 = state_31919__$1;
(statearr_31934_31983[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (6))){
var inst_31900 = (state_31919[(11)]);
var inst_31898 = (state_31919[(7)]);
var inst_31850 = (state_31919[(8)]);
var inst_31898__$1 = topic_fn.call(null,inst_31850);
var inst_31899 = cljs.core.deref.call(null,mults);
var inst_31900__$1 = cljs.core.get.call(null,inst_31899,inst_31898__$1);
var state_31919__$1 = (function (){var statearr_31935 = state_31919;
(statearr_31935[(11)] = inst_31900__$1);

(statearr_31935[(7)] = inst_31898__$1);

return statearr_31935;
})();
if(cljs.core.truth_(inst_31900__$1)){
var statearr_31936_31984 = state_31919__$1;
(statearr_31936_31984[(1)] = (19));

} else {
var statearr_31937_31985 = state_31919__$1;
(statearr_31937_31985[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (25))){
var inst_31909 = (state_31919[(2)]);
var state_31919__$1 = state_31919;
var statearr_31938_31986 = state_31919__$1;
(statearr_31938_31986[(2)] = inst_31909);

(statearr_31938_31986[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (17))){
var inst_31874 = (state_31919[(10)]);
var inst_31883 = cljs.core.first.call(null,inst_31874);
var inst_31884 = cljs.core.async.muxch_STAR_.call(null,inst_31883);
var inst_31885 = cljs.core.async.close_BANG_.call(null,inst_31884);
var inst_31886 = cljs.core.next.call(null,inst_31874);
var inst_31860 = inst_31886;
var inst_31861 = null;
var inst_31862 = (0);
var inst_31863 = (0);
var state_31919__$1 = (function (){var statearr_31939 = state_31919;
(statearr_31939[(12)] = inst_31862);

(statearr_31939[(13)] = inst_31863);

(statearr_31939[(14)] = inst_31885);

(statearr_31939[(15)] = inst_31860);

(statearr_31939[(16)] = inst_31861);

return statearr_31939;
})();
var statearr_31940_31987 = state_31919__$1;
(statearr_31940_31987[(2)] = null);

(statearr_31940_31987[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (3))){
var inst_31917 = (state_31919[(2)]);
var state_31919__$1 = state_31919;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31919__$1,inst_31917);
} else {
if((state_val_31920 === (12))){
var inst_31894 = (state_31919[(2)]);
var state_31919__$1 = state_31919;
var statearr_31941_31988 = state_31919__$1;
(statearr_31941_31988[(2)] = inst_31894);

(statearr_31941_31988[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (2))){
var state_31919__$1 = state_31919;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31919__$1,(4),ch);
} else {
if((state_val_31920 === (23))){
var state_31919__$1 = state_31919;
var statearr_31942_31989 = state_31919__$1;
(statearr_31942_31989[(2)] = null);

(statearr_31942_31989[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (19))){
var inst_31900 = (state_31919[(11)]);
var inst_31850 = (state_31919[(8)]);
var inst_31902 = cljs.core.async.muxch_STAR_.call(null,inst_31900);
var state_31919__$1 = state_31919;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31919__$1,(22),inst_31902,inst_31850);
} else {
if((state_val_31920 === (11))){
var inst_31860 = (state_31919[(15)]);
var inst_31874 = (state_31919[(10)]);
var inst_31874__$1 = cljs.core.seq.call(null,inst_31860);
var state_31919__$1 = (function (){var statearr_31943 = state_31919;
(statearr_31943[(10)] = inst_31874__$1);

return statearr_31943;
})();
if(inst_31874__$1){
var statearr_31944_31990 = state_31919__$1;
(statearr_31944_31990[(1)] = (13));

} else {
var statearr_31945_31991 = state_31919__$1;
(statearr_31945_31991[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (9))){
var inst_31896 = (state_31919[(2)]);
var state_31919__$1 = state_31919;
var statearr_31946_31992 = state_31919__$1;
(statearr_31946_31992[(2)] = inst_31896);

(statearr_31946_31992[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (5))){
var inst_31857 = cljs.core.deref.call(null,mults);
var inst_31858 = cljs.core.vals.call(null,inst_31857);
var inst_31859 = cljs.core.seq.call(null,inst_31858);
var inst_31860 = inst_31859;
var inst_31861 = null;
var inst_31862 = (0);
var inst_31863 = (0);
var state_31919__$1 = (function (){var statearr_31947 = state_31919;
(statearr_31947[(12)] = inst_31862);

(statearr_31947[(13)] = inst_31863);

(statearr_31947[(15)] = inst_31860);

(statearr_31947[(16)] = inst_31861);

return statearr_31947;
})();
var statearr_31948_31993 = state_31919__$1;
(statearr_31948_31993[(2)] = null);

(statearr_31948_31993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (14))){
var state_31919__$1 = state_31919;
var statearr_31952_31994 = state_31919__$1;
(statearr_31952_31994[(2)] = null);

(statearr_31952_31994[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (16))){
var inst_31874 = (state_31919[(10)]);
var inst_31878 = cljs.core.chunk_first.call(null,inst_31874);
var inst_31879 = cljs.core.chunk_rest.call(null,inst_31874);
var inst_31880 = cljs.core.count.call(null,inst_31878);
var inst_31860 = inst_31879;
var inst_31861 = inst_31878;
var inst_31862 = inst_31880;
var inst_31863 = (0);
var state_31919__$1 = (function (){var statearr_31953 = state_31919;
(statearr_31953[(12)] = inst_31862);

(statearr_31953[(13)] = inst_31863);

(statearr_31953[(15)] = inst_31860);

(statearr_31953[(16)] = inst_31861);

return statearr_31953;
})();
var statearr_31954_31995 = state_31919__$1;
(statearr_31954_31995[(2)] = null);

(statearr_31954_31995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (10))){
var inst_31862 = (state_31919[(12)]);
var inst_31863 = (state_31919[(13)]);
var inst_31860 = (state_31919[(15)]);
var inst_31861 = (state_31919[(16)]);
var inst_31868 = cljs.core._nth.call(null,inst_31861,inst_31863);
var inst_31869 = cljs.core.async.muxch_STAR_.call(null,inst_31868);
var inst_31870 = cljs.core.async.close_BANG_.call(null,inst_31869);
var inst_31871 = (inst_31863 + (1));
var tmp31949 = inst_31862;
var tmp31950 = inst_31860;
var tmp31951 = inst_31861;
var inst_31860__$1 = tmp31950;
var inst_31861__$1 = tmp31951;
var inst_31862__$1 = tmp31949;
var inst_31863__$1 = inst_31871;
var state_31919__$1 = (function (){var statearr_31955 = state_31919;
(statearr_31955[(12)] = inst_31862__$1);

(statearr_31955[(13)] = inst_31863__$1);

(statearr_31955[(15)] = inst_31860__$1);

(statearr_31955[(16)] = inst_31861__$1);

(statearr_31955[(17)] = inst_31870);

return statearr_31955;
})();
var statearr_31956_31996 = state_31919__$1;
(statearr_31956_31996[(2)] = null);

(statearr_31956_31996[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (18))){
var inst_31889 = (state_31919[(2)]);
var state_31919__$1 = state_31919;
var statearr_31957_31997 = state_31919__$1;
(statearr_31957_31997[(2)] = inst_31889);

(statearr_31957_31997[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31920 === (8))){
var inst_31862 = (state_31919[(12)]);
var inst_31863 = (state_31919[(13)]);
var inst_31865 = (inst_31863 < inst_31862);
var inst_31866 = inst_31865;
var state_31919__$1 = state_31919;
if(cljs.core.truth_(inst_31866)){
var statearr_31958_31998 = state_31919__$1;
(statearr_31958_31998[(1)] = (10));

} else {
var statearr_31959_31999 = state_31919__$1;
(statearr_31959_31999[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___31971,mults,ensure_mult,p))
;
return ((function (switch__29920__auto__,c__30034__auto___31971,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__29921__auto__ = null;
var cljs$core$async$state_machine__29921__auto____0 = (function (){
var statearr_31963 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31963[(0)] = cljs$core$async$state_machine__29921__auto__);

(statearr_31963[(1)] = (1));

return statearr_31963;
});
var cljs$core$async$state_machine__29921__auto____1 = (function (state_31919){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_31919);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e31964){if((e31964 instanceof Object)){
var ex__29924__auto__ = e31964;
var statearr_31965_32000 = state_31919;
(statearr_31965_32000[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31919);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31964;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32001 = state_31919;
state_31919 = G__32001;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$state_machine__29921__auto__ = function(state_31919){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29921__auto____1.call(this,state_31919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29921__auto____0;
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29921__auto____1;
return cljs$core$async$state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___31971,mults,ensure_mult,p))
})();
var state__30036__auto__ = (function (){var statearr_31966 = f__30035__auto__.call(null);
(statearr_31966[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___31971);

return statearr_31966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___31971,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args32002 = [];
var len__27957__auto___32005 = arguments.length;
var i__27958__auto___32006 = (0);
while(true){
if((i__27958__auto___32006 < len__27957__auto___32005)){
args32002.push((arguments[i__27958__auto___32006]));

var G__32007 = (i__27958__auto___32006 + (1));
i__27958__auto___32006 = G__32007;
continue;
} else {
}
break;
}

var G__32004 = args32002.length;
switch (G__32004) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32002.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args32009 = [];
var len__27957__auto___32012 = arguments.length;
var i__27958__auto___32013 = (0);
while(true){
if((i__27958__auto___32013 < len__27957__auto___32012)){
args32009.push((arguments[i__27958__auto___32013]));

var G__32014 = (i__27958__auto___32013 + (1));
i__27958__auto___32013 = G__32014;
continue;
} else {
}
break;
}

var G__32011 = args32009.length;
switch (G__32011) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32009.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args32016 = [];
var len__27957__auto___32087 = arguments.length;
var i__27958__auto___32088 = (0);
while(true){
if((i__27958__auto___32088 < len__27957__auto___32087)){
args32016.push((arguments[i__27958__auto___32088]));

var G__32089 = (i__27958__auto___32088 + (1));
i__27958__auto___32088 = G__32089;
continue;
} else {
}
break;
}

var G__32018 = args32016.length;
switch (G__32018) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32016.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__30034__auto___32091 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___32091,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___32091,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32057){
var state_val_32058 = (state_32057[(1)]);
if((state_val_32058 === (7))){
var state_32057__$1 = state_32057;
var statearr_32059_32092 = state_32057__$1;
(statearr_32059_32092[(2)] = null);

(statearr_32059_32092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32058 === (1))){
var state_32057__$1 = state_32057;
var statearr_32060_32093 = state_32057__$1;
(statearr_32060_32093[(2)] = null);

(statearr_32060_32093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32058 === (4))){
var inst_32021 = (state_32057[(7)]);
var inst_32023 = (inst_32021 < cnt);
var state_32057__$1 = state_32057;
if(cljs.core.truth_(inst_32023)){
var statearr_32061_32094 = state_32057__$1;
(statearr_32061_32094[(1)] = (6));

} else {
var statearr_32062_32095 = state_32057__$1;
(statearr_32062_32095[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32058 === (15))){
var inst_32053 = (state_32057[(2)]);
var state_32057__$1 = state_32057;
var statearr_32063_32096 = state_32057__$1;
(statearr_32063_32096[(2)] = inst_32053);

(statearr_32063_32096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32058 === (13))){
var inst_32046 = cljs.core.async.close_BANG_.call(null,out);
var state_32057__$1 = state_32057;
var statearr_32064_32097 = state_32057__$1;
(statearr_32064_32097[(2)] = inst_32046);

(statearr_32064_32097[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32058 === (6))){
var state_32057__$1 = state_32057;
var statearr_32065_32098 = state_32057__$1;
(statearr_32065_32098[(2)] = null);

(statearr_32065_32098[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32058 === (3))){
var inst_32055 = (state_32057[(2)]);
var state_32057__$1 = state_32057;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32057__$1,inst_32055);
} else {
if((state_val_32058 === (12))){
var inst_32043 = (state_32057[(8)]);
var inst_32043__$1 = (state_32057[(2)]);
var inst_32044 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_32043__$1);
var state_32057__$1 = (function (){var statearr_32066 = state_32057;
(statearr_32066[(8)] = inst_32043__$1);

return statearr_32066;
})();
if(cljs.core.truth_(inst_32044)){
var statearr_32067_32099 = state_32057__$1;
(statearr_32067_32099[(1)] = (13));

} else {
var statearr_32068_32100 = state_32057__$1;
(statearr_32068_32100[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32058 === (2))){
var inst_32020 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_32021 = (0);
var state_32057__$1 = (function (){var statearr_32069 = state_32057;
(statearr_32069[(9)] = inst_32020);

(statearr_32069[(7)] = inst_32021);

return statearr_32069;
})();
var statearr_32070_32101 = state_32057__$1;
(statearr_32070_32101[(2)] = null);

(statearr_32070_32101[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32058 === (11))){
var inst_32021 = (state_32057[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_32057,(10),Object,null,(9));
var inst_32030 = chs__$1.call(null,inst_32021);
var inst_32031 = done.call(null,inst_32021);
var inst_32032 = cljs.core.async.take_BANG_.call(null,inst_32030,inst_32031);
var state_32057__$1 = state_32057;
var statearr_32071_32102 = state_32057__$1;
(statearr_32071_32102[(2)] = inst_32032);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32057__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32058 === (9))){
var inst_32021 = (state_32057[(7)]);
var inst_32034 = (state_32057[(2)]);
var inst_32035 = (inst_32021 + (1));
var inst_32021__$1 = inst_32035;
var state_32057__$1 = (function (){var statearr_32072 = state_32057;
(statearr_32072[(10)] = inst_32034);

(statearr_32072[(7)] = inst_32021__$1);

return statearr_32072;
})();
var statearr_32073_32103 = state_32057__$1;
(statearr_32073_32103[(2)] = null);

(statearr_32073_32103[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32058 === (5))){
var inst_32041 = (state_32057[(2)]);
var state_32057__$1 = (function (){var statearr_32074 = state_32057;
(statearr_32074[(11)] = inst_32041);

return statearr_32074;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32057__$1,(12),dchan);
} else {
if((state_val_32058 === (14))){
var inst_32043 = (state_32057[(8)]);
var inst_32048 = cljs.core.apply.call(null,f,inst_32043);
var state_32057__$1 = state_32057;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32057__$1,(16),out,inst_32048);
} else {
if((state_val_32058 === (16))){
var inst_32050 = (state_32057[(2)]);
var state_32057__$1 = (function (){var statearr_32075 = state_32057;
(statearr_32075[(12)] = inst_32050);

return statearr_32075;
})();
var statearr_32076_32104 = state_32057__$1;
(statearr_32076_32104[(2)] = null);

(statearr_32076_32104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32058 === (10))){
var inst_32025 = (state_32057[(2)]);
var inst_32026 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_32057__$1 = (function (){var statearr_32077 = state_32057;
(statearr_32077[(13)] = inst_32025);

return statearr_32077;
})();
var statearr_32078_32105 = state_32057__$1;
(statearr_32078_32105[(2)] = inst_32026);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32057__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32058 === (8))){
var inst_32039 = (state_32057[(2)]);
var state_32057__$1 = state_32057;
var statearr_32079_32106 = state_32057__$1;
(statearr_32079_32106[(2)] = inst_32039);

(statearr_32079_32106[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___32091,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__29920__auto__,c__30034__auto___32091,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__29921__auto__ = null;
var cljs$core$async$state_machine__29921__auto____0 = (function (){
var statearr_32083 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32083[(0)] = cljs$core$async$state_machine__29921__auto__);

(statearr_32083[(1)] = (1));

return statearr_32083;
});
var cljs$core$async$state_machine__29921__auto____1 = (function (state_32057){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_32057);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e32084){if((e32084 instanceof Object)){
var ex__29924__auto__ = e32084;
var statearr_32085_32107 = state_32057;
(statearr_32085_32107[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32057);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32084;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32108 = state_32057;
state_32057 = G__32108;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$state_machine__29921__auto__ = function(state_32057){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29921__auto____1.call(this,state_32057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29921__auto____0;
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29921__auto____1;
return cljs$core$async$state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___32091,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__30036__auto__ = (function (){var statearr_32086 = f__30035__auto__.call(null);
(statearr_32086[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___32091);

return statearr_32086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___32091,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args32110 = [];
var len__27957__auto___32168 = arguments.length;
var i__27958__auto___32169 = (0);
while(true){
if((i__27958__auto___32169 < len__27957__auto___32168)){
args32110.push((arguments[i__27958__auto___32169]));

var G__32170 = (i__27958__auto___32169 + (1));
i__27958__auto___32169 = G__32170;
continue;
} else {
}
break;
}

var G__32112 = args32110.length;
switch (G__32112) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32110.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30034__auto___32172 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___32172,out){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___32172,out){
return (function (state_32144){
var state_val_32145 = (state_32144[(1)]);
if((state_val_32145 === (7))){
var inst_32124 = (state_32144[(7)]);
var inst_32123 = (state_32144[(8)]);
var inst_32123__$1 = (state_32144[(2)]);
var inst_32124__$1 = cljs.core.nth.call(null,inst_32123__$1,(0),null);
var inst_32125 = cljs.core.nth.call(null,inst_32123__$1,(1),null);
var inst_32126 = (inst_32124__$1 == null);
var state_32144__$1 = (function (){var statearr_32146 = state_32144;
(statearr_32146[(7)] = inst_32124__$1);

(statearr_32146[(8)] = inst_32123__$1);

(statearr_32146[(9)] = inst_32125);

return statearr_32146;
})();
if(cljs.core.truth_(inst_32126)){
var statearr_32147_32173 = state_32144__$1;
(statearr_32147_32173[(1)] = (8));

} else {
var statearr_32148_32174 = state_32144__$1;
(statearr_32148_32174[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32145 === (1))){
var inst_32113 = cljs.core.vec.call(null,chs);
var inst_32114 = inst_32113;
var state_32144__$1 = (function (){var statearr_32149 = state_32144;
(statearr_32149[(10)] = inst_32114);

return statearr_32149;
})();
var statearr_32150_32175 = state_32144__$1;
(statearr_32150_32175[(2)] = null);

(statearr_32150_32175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32145 === (4))){
var inst_32114 = (state_32144[(10)]);
var state_32144__$1 = state_32144;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32144__$1,(7),inst_32114);
} else {
if((state_val_32145 === (6))){
var inst_32140 = (state_32144[(2)]);
var state_32144__$1 = state_32144;
var statearr_32151_32176 = state_32144__$1;
(statearr_32151_32176[(2)] = inst_32140);

(statearr_32151_32176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32145 === (3))){
var inst_32142 = (state_32144[(2)]);
var state_32144__$1 = state_32144;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32144__$1,inst_32142);
} else {
if((state_val_32145 === (2))){
var inst_32114 = (state_32144[(10)]);
var inst_32116 = cljs.core.count.call(null,inst_32114);
var inst_32117 = (inst_32116 > (0));
var state_32144__$1 = state_32144;
if(cljs.core.truth_(inst_32117)){
var statearr_32153_32177 = state_32144__$1;
(statearr_32153_32177[(1)] = (4));

} else {
var statearr_32154_32178 = state_32144__$1;
(statearr_32154_32178[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32145 === (11))){
var inst_32114 = (state_32144[(10)]);
var inst_32133 = (state_32144[(2)]);
var tmp32152 = inst_32114;
var inst_32114__$1 = tmp32152;
var state_32144__$1 = (function (){var statearr_32155 = state_32144;
(statearr_32155[(10)] = inst_32114__$1);

(statearr_32155[(11)] = inst_32133);

return statearr_32155;
})();
var statearr_32156_32179 = state_32144__$1;
(statearr_32156_32179[(2)] = null);

(statearr_32156_32179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32145 === (9))){
var inst_32124 = (state_32144[(7)]);
var state_32144__$1 = state_32144;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32144__$1,(11),out,inst_32124);
} else {
if((state_val_32145 === (5))){
var inst_32138 = cljs.core.async.close_BANG_.call(null,out);
var state_32144__$1 = state_32144;
var statearr_32157_32180 = state_32144__$1;
(statearr_32157_32180[(2)] = inst_32138);

(statearr_32157_32180[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32145 === (10))){
var inst_32136 = (state_32144[(2)]);
var state_32144__$1 = state_32144;
var statearr_32158_32181 = state_32144__$1;
(statearr_32158_32181[(2)] = inst_32136);

(statearr_32158_32181[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32145 === (8))){
var inst_32114 = (state_32144[(10)]);
var inst_32124 = (state_32144[(7)]);
var inst_32123 = (state_32144[(8)]);
var inst_32125 = (state_32144[(9)]);
var inst_32128 = (function (){var cs = inst_32114;
var vec__32119 = inst_32123;
var v = inst_32124;
var c = inst_32125;
return ((function (cs,vec__32119,v,c,inst_32114,inst_32124,inst_32123,inst_32125,state_val_32145,c__30034__auto___32172,out){
return (function (p1__32109_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__32109_SHARP_);
});
;})(cs,vec__32119,v,c,inst_32114,inst_32124,inst_32123,inst_32125,state_val_32145,c__30034__auto___32172,out))
})();
var inst_32129 = cljs.core.filterv.call(null,inst_32128,inst_32114);
var inst_32114__$1 = inst_32129;
var state_32144__$1 = (function (){var statearr_32159 = state_32144;
(statearr_32159[(10)] = inst_32114__$1);

return statearr_32159;
})();
var statearr_32160_32182 = state_32144__$1;
(statearr_32160_32182[(2)] = null);

(statearr_32160_32182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___32172,out))
;
return ((function (switch__29920__auto__,c__30034__auto___32172,out){
return (function() {
var cljs$core$async$state_machine__29921__auto__ = null;
var cljs$core$async$state_machine__29921__auto____0 = (function (){
var statearr_32164 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32164[(0)] = cljs$core$async$state_machine__29921__auto__);

(statearr_32164[(1)] = (1));

return statearr_32164;
});
var cljs$core$async$state_machine__29921__auto____1 = (function (state_32144){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_32144);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e32165){if((e32165 instanceof Object)){
var ex__29924__auto__ = e32165;
var statearr_32166_32183 = state_32144;
(statearr_32166_32183[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32144);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32165;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32184 = state_32144;
state_32144 = G__32184;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$state_machine__29921__auto__ = function(state_32144){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29921__auto____1.call(this,state_32144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29921__auto____0;
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29921__auto____1;
return cljs$core$async$state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___32172,out))
})();
var state__30036__auto__ = (function (){var statearr_32167 = f__30035__auto__.call(null);
(statearr_32167[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___32172);

return statearr_32167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___32172,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args32185 = [];
var len__27957__auto___32234 = arguments.length;
var i__27958__auto___32235 = (0);
while(true){
if((i__27958__auto___32235 < len__27957__auto___32234)){
args32185.push((arguments[i__27958__auto___32235]));

var G__32236 = (i__27958__auto___32235 + (1));
i__27958__auto___32235 = G__32236;
continue;
} else {
}
break;
}

var G__32187 = args32185.length;
switch (G__32187) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32185.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30034__auto___32238 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___32238,out){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___32238,out){
return (function (state_32211){
var state_val_32212 = (state_32211[(1)]);
if((state_val_32212 === (7))){
var inst_32193 = (state_32211[(7)]);
var inst_32193__$1 = (state_32211[(2)]);
var inst_32194 = (inst_32193__$1 == null);
var inst_32195 = cljs.core.not.call(null,inst_32194);
var state_32211__$1 = (function (){var statearr_32213 = state_32211;
(statearr_32213[(7)] = inst_32193__$1);

return statearr_32213;
})();
if(inst_32195){
var statearr_32214_32239 = state_32211__$1;
(statearr_32214_32239[(1)] = (8));

} else {
var statearr_32215_32240 = state_32211__$1;
(statearr_32215_32240[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (1))){
var inst_32188 = (0);
var state_32211__$1 = (function (){var statearr_32216 = state_32211;
(statearr_32216[(8)] = inst_32188);

return statearr_32216;
})();
var statearr_32217_32241 = state_32211__$1;
(statearr_32217_32241[(2)] = null);

(statearr_32217_32241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (4))){
var state_32211__$1 = state_32211;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32211__$1,(7),ch);
} else {
if((state_val_32212 === (6))){
var inst_32206 = (state_32211[(2)]);
var state_32211__$1 = state_32211;
var statearr_32218_32242 = state_32211__$1;
(statearr_32218_32242[(2)] = inst_32206);

(statearr_32218_32242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (3))){
var inst_32208 = (state_32211[(2)]);
var inst_32209 = cljs.core.async.close_BANG_.call(null,out);
var state_32211__$1 = (function (){var statearr_32219 = state_32211;
(statearr_32219[(9)] = inst_32208);

return statearr_32219;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32211__$1,inst_32209);
} else {
if((state_val_32212 === (2))){
var inst_32188 = (state_32211[(8)]);
var inst_32190 = (inst_32188 < n);
var state_32211__$1 = state_32211;
if(cljs.core.truth_(inst_32190)){
var statearr_32220_32243 = state_32211__$1;
(statearr_32220_32243[(1)] = (4));

} else {
var statearr_32221_32244 = state_32211__$1;
(statearr_32221_32244[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (11))){
var inst_32188 = (state_32211[(8)]);
var inst_32198 = (state_32211[(2)]);
var inst_32199 = (inst_32188 + (1));
var inst_32188__$1 = inst_32199;
var state_32211__$1 = (function (){var statearr_32222 = state_32211;
(statearr_32222[(8)] = inst_32188__$1);

(statearr_32222[(10)] = inst_32198);

return statearr_32222;
})();
var statearr_32223_32245 = state_32211__$1;
(statearr_32223_32245[(2)] = null);

(statearr_32223_32245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (9))){
var state_32211__$1 = state_32211;
var statearr_32224_32246 = state_32211__$1;
(statearr_32224_32246[(2)] = null);

(statearr_32224_32246[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (5))){
var state_32211__$1 = state_32211;
var statearr_32225_32247 = state_32211__$1;
(statearr_32225_32247[(2)] = null);

(statearr_32225_32247[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (10))){
var inst_32203 = (state_32211[(2)]);
var state_32211__$1 = state_32211;
var statearr_32226_32248 = state_32211__$1;
(statearr_32226_32248[(2)] = inst_32203);

(statearr_32226_32248[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32212 === (8))){
var inst_32193 = (state_32211[(7)]);
var state_32211__$1 = state_32211;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32211__$1,(11),out,inst_32193);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___32238,out))
;
return ((function (switch__29920__auto__,c__30034__auto___32238,out){
return (function() {
var cljs$core$async$state_machine__29921__auto__ = null;
var cljs$core$async$state_machine__29921__auto____0 = (function (){
var statearr_32230 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32230[(0)] = cljs$core$async$state_machine__29921__auto__);

(statearr_32230[(1)] = (1));

return statearr_32230;
});
var cljs$core$async$state_machine__29921__auto____1 = (function (state_32211){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_32211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e32231){if((e32231 instanceof Object)){
var ex__29924__auto__ = e32231;
var statearr_32232_32249 = state_32211;
(statearr_32232_32249[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32211);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32231;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32250 = state_32211;
state_32211 = G__32250;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$state_machine__29921__auto__ = function(state_32211){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29921__auto____1.call(this,state_32211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29921__auto____0;
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29921__auto____1;
return cljs$core$async$state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___32238,out))
})();
var state__30036__auto__ = (function (){var statearr_32233 = f__30035__auto__.call(null);
(statearr_32233[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___32238);

return statearr_32233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___32238,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32258 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32258 = (function (f,ch,meta32259){
this.f = f;
this.ch = ch;
this.meta32259 = meta32259;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32260,meta32259__$1){
var self__ = this;
var _32260__$1 = this;
return (new cljs.core.async.t_cljs$core$async32258(self__.f,self__.ch,meta32259__$1));
});

cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32260){
var self__ = this;
var _32260__$1 = this;
return self__.meta32259;
});

cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async32261 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32261 = (function (f,ch,meta32259,_,fn1,meta32262){
this.f = f;
this.ch = ch;
this.meta32259 = meta32259;
this._ = _;
this.fn1 = fn1;
this.meta32262 = meta32262;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_32263,meta32262__$1){
var self__ = this;
var _32263__$1 = this;
return (new cljs.core.async.t_cljs$core$async32261(self__.f,self__.ch,self__.meta32259,self__._,self__.fn1,meta32262__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_32263){
var self__ = this;
var _32263__$1 = this;
return self__.meta32262;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32261.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32251_SHARP_){
return f1.call(null,(((p1__32251_SHARP_ == null))?null:self__.f.call(null,p1__32251_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async32261.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32259","meta32259",-450042833,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32258","cljs.core.async/t_cljs$core$async32258",-1294507451,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32262","meta32262",-984269054,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32261.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32261.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32261";

cljs.core.async.t_cljs$core$async32261.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async32261");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async32261 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32261(f__$1,ch__$1,meta32259__$1,___$2,fn1__$1,meta32262){
return (new cljs.core.async.t_cljs$core$async32261(f__$1,ch__$1,meta32259__$1,___$2,fn1__$1,meta32262));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async32261(self__.f,self__.ch,self__.meta32259,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__26729__auto__ = ret;
if(cljs.core.truth_(and__26729__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__26729__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32258.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async32258.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32259","meta32259",-450042833,null)], null);
});

cljs.core.async.t_cljs$core$async32258.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32258.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32258";

cljs.core.async.t_cljs$core$async32258.cljs$lang$ctorPrWriter = (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async32258");
});

cljs.core.async.__GT_t_cljs$core$async32258 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32258(f__$1,ch__$1,meta32259){
return (new cljs.core.async.t_cljs$core$async32258(f__$1,ch__$1,meta32259));
});

}

return (new cljs.core.async.t_cljs$core$async32258(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32267 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32267 = (function (f,ch,meta32268){
this.f = f;
this.ch = ch;
this.meta32268 = meta32268;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32267.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32269,meta32268__$1){
var self__ = this;
var _32269__$1 = this;
return (new cljs.core.async.t_cljs$core$async32267(self__.f,self__.ch,meta32268__$1));
});

cljs.core.async.t_cljs$core$async32267.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32269){
var self__ = this;
var _32269__$1 = this;
return self__.meta32268;
});

cljs.core.async.t_cljs$core$async32267.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32267.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32267.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32267.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32267.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32267.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async32267.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32268","meta32268",-201950164,null)], null);
});

cljs.core.async.t_cljs$core$async32267.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32267.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32267";

cljs.core.async.t_cljs$core$async32267.cljs$lang$ctorPrWriter = (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async32267");
});

cljs.core.async.__GT_t_cljs$core$async32267 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32267(f__$1,ch__$1,meta32268){
return (new cljs.core.async.t_cljs$core$async32267(f__$1,ch__$1,meta32268));
});

}

return (new cljs.core.async.t_cljs$core$async32267(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async32273 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32273 = (function (p,ch,meta32274){
this.p = p;
this.ch = ch;
this.meta32274 = meta32274;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32273.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32275,meta32274__$1){
var self__ = this;
var _32275__$1 = this;
return (new cljs.core.async.t_cljs$core$async32273(self__.p,self__.ch,meta32274__$1));
});

cljs.core.async.t_cljs$core$async32273.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32275){
var self__ = this;
var _32275__$1 = this;
return self__.meta32274;
});

cljs.core.async.t_cljs$core$async32273.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32273.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32273.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32273.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32273.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32273.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32273.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async32273.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32274","meta32274",43471515,null)], null);
});

cljs.core.async.t_cljs$core$async32273.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32273.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32273";

cljs.core.async.t_cljs$core$async32273.cljs$lang$ctorPrWriter = (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async32273");
});

cljs.core.async.__GT_t_cljs$core$async32273 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32273(p__$1,ch__$1,meta32274){
return (new cljs.core.async.t_cljs$core$async32273(p__$1,ch__$1,meta32274));
});

}

return (new cljs.core.async.t_cljs$core$async32273(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args32276 = [];
var len__27957__auto___32320 = arguments.length;
var i__27958__auto___32321 = (0);
while(true){
if((i__27958__auto___32321 < len__27957__auto___32320)){
args32276.push((arguments[i__27958__auto___32321]));

var G__32322 = (i__27958__auto___32321 + (1));
i__27958__auto___32321 = G__32322;
continue;
} else {
}
break;
}

var G__32278 = args32276.length;
switch (G__32278) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32276.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30034__auto___32324 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___32324,out){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___32324,out){
return (function (state_32299){
var state_val_32300 = (state_32299[(1)]);
if((state_val_32300 === (7))){
var inst_32295 = (state_32299[(2)]);
var state_32299__$1 = state_32299;
var statearr_32301_32325 = state_32299__$1;
(statearr_32301_32325[(2)] = inst_32295);

(statearr_32301_32325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32300 === (1))){
var state_32299__$1 = state_32299;
var statearr_32302_32326 = state_32299__$1;
(statearr_32302_32326[(2)] = null);

(statearr_32302_32326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32300 === (4))){
var inst_32281 = (state_32299[(7)]);
var inst_32281__$1 = (state_32299[(2)]);
var inst_32282 = (inst_32281__$1 == null);
var state_32299__$1 = (function (){var statearr_32303 = state_32299;
(statearr_32303[(7)] = inst_32281__$1);

return statearr_32303;
})();
if(cljs.core.truth_(inst_32282)){
var statearr_32304_32327 = state_32299__$1;
(statearr_32304_32327[(1)] = (5));

} else {
var statearr_32305_32328 = state_32299__$1;
(statearr_32305_32328[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32300 === (6))){
var inst_32281 = (state_32299[(7)]);
var inst_32286 = p.call(null,inst_32281);
var state_32299__$1 = state_32299;
if(cljs.core.truth_(inst_32286)){
var statearr_32306_32329 = state_32299__$1;
(statearr_32306_32329[(1)] = (8));

} else {
var statearr_32307_32330 = state_32299__$1;
(statearr_32307_32330[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32300 === (3))){
var inst_32297 = (state_32299[(2)]);
var state_32299__$1 = state_32299;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32299__$1,inst_32297);
} else {
if((state_val_32300 === (2))){
var state_32299__$1 = state_32299;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32299__$1,(4),ch);
} else {
if((state_val_32300 === (11))){
var inst_32289 = (state_32299[(2)]);
var state_32299__$1 = state_32299;
var statearr_32308_32331 = state_32299__$1;
(statearr_32308_32331[(2)] = inst_32289);

(statearr_32308_32331[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32300 === (9))){
var state_32299__$1 = state_32299;
var statearr_32309_32332 = state_32299__$1;
(statearr_32309_32332[(2)] = null);

(statearr_32309_32332[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32300 === (5))){
var inst_32284 = cljs.core.async.close_BANG_.call(null,out);
var state_32299__$1 = state_32299;
var statearr_32310_32333 = state_32299__$1;
(statearr_32310_32333[(2)] = inst_32284);

(statearr_32310_32333[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32300 === (10))){
var inst_32292 = (state_32299[(2)]);
var state_32299__$1 = (function (){var statearr_32311 = state_32299;
(statearr_32311[(8)] = inst_32292);

return statearr_32311;
})();
var statearr_32312_32334 = state_32299__$1;
(statearr_32312_32334[(2)] = null);

(statearr_32312_32334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32300 === (8))){
var inst_32281 = (state_32299[(7)]);
var state_32299__$1 = state_32299;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32299__$1,(11),out,inst_32281);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___32324,out))
;
return ((function (switch__29920__auto__,c__30034__auto___32324,out){
return (function() {
var cljs$core$async$state_machine__29921__auto__ = null;
var cljs$core$async$state_machine__29921__auto____0 = (function (){
var statearr_32316 = [null,null,null,null,null,null,null,null,null];
(statearr_32316[(0)] = cljs$core$async$state_machine__29921__auto__);

(statearr_32316[(1)] = (1));

return statearr_32316;
});
var cljs$core$async$state_machine__29921__auto____1 = (function (state_32299){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_32299);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e32317){if((e32317 instanceof Object)){
var ex__29924__auto__ = e32317;
var statearr_32318_32335 = state_32299;
(statearr_32318_32335[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32299);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32317;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32336 = state_32299;
state_32299 = G__32336;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$state_machine__29921__auto__ = function(state_32299){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29921__auto____1.call(this,state_32299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29921__auto____0;
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29921__auto____1;
return cljs$core$async$state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___32324,out))
})();
var state__30036__auto__ = (function (){var statearr_32319 = f__30035__auto__.call(null);
(statearr_32319[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___32324);

return statearr_32319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___32324,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args32337 = [];
var len__27957__auto___32340 = arguments.length;
var i__27958__auto___32341 = (0);
while(true){
if((i__27958__auto___32341 < len__27957__auto___32340)){
args32337.push((arguments[i__27958__auto___32341]));

var G__32342 = (i__27958__auto___32341 + (1));
i__27958__auto___32341 = G__32342;
continue;
} else {
}
break;
}

var G__32339 = args32337.length;
switch (G__32339) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32337.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30034__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto__){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto__){
return (function (state_32509){
var state_val_32510 = (state_32509[(1)]);
if((state_val_32510 === (7))){
var inst_32505 = (state_32509[(2)]);
var state_32509__$1 = state_32509;
var statearr_32511_32552 = state_32509__$1;
(statearr_32511_32552[(2)] = inst_32505);

(statearr_32511_32552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (20))){
var inst_32475 = (state_32509[(7)]);
var inst_32486 = (state_32509[(2)]);
var inst_32487 = cljs.core.next.call(null,inst_32475);
var inst_32461 = inst_32487;
var inst_32462 = null;
var inst_32463 = (0);
var inst_32464 = (0);
var state_32509__$1 = (function (){var statearr_32512 = state_32509;
(statearr_32512[(8)] = inst_32462);

(statearr_32512[(9)] = inst_32464);

(statearr_32512[(10)] = inst_32461);

(statearr_32512[(11)] = inst_32463);

(statearr_32512[(12)] = inst_32486);

return statearr_32512;
})();
var statearr_32513_32553 = state_32509__$1;
(statearr_32513_32553[(2)] = null);

(statearr_32513_32553[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (1))){
var state_32509__$1 = state_32509;
var statearr_32514_32554 = state_32509__$1;
(statearr_32514_32554[(2)] = null);

(statearr_32514_32554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (4))){
var inst_32450 = (state_32509[(13)]);
var inst_32450__$1 = (state_32509[(2)]);
var inst_32451 = (inst_32450__$1 == null);
var state_32509__$1 = (function (){var statearr_32515 = state_32509;
(statearr_32515[(13)] = inst_32450__$1);

return statearr_32515;
})();
if(cljs.core.truth_(inst_32451)){
var statearr_32516_32555 = state_32509__$1;
(statearr_32516_32555[(1)] = (5));

} else {
var statearr_32517_32556 = state_32509__$1;
(statearr_32517_32556[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (15))){
var state_32509__$1 = state_32509;
var statearr_32521_32557 = state_32509__$1;
(statearr_32521_32557[(2)] = null);

(statearr_32521_32557[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (21))){
var state_32509__$1 = state_32509;
var statearr_32522_32558 = state_32509__$1;
(statearr_32522_32558[(2)] = null);

(statearr_32522_32558[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (13))){
var inst_32462 = (state_32509[(8)]);
var inst_32464 = (state_32509[(9)]);
var inst_32461 = (state_32509[(10)]);
var inst_32463 = (state_32509[(11)]);
var inst_32471 = (state_32509[(2)]);
var inst_32472 = (inst_32464 + (1));
var tmp32518 = inst_32462;
var tmp32519 = inst_32461;
var tmp32520 = inst_32463;
var inst_32461__$1 = tmp32519;
var inst_32462__$1 = tmp32518;
var inst_32463__$1 = tmp32520;
var inst_32464__$1 = inst_32472;
var state_32509__$1 = (function (){var statearr_32523 = state_32509;
(statearr_32523[(8)] = inst_32462__$1);

(statearr_32523[(9)] = inst_32464__$1);

(statearr_32523[(14)] = inst_32471);

(statearr_32523[(10)] = inst_32461__$1);

(statearr_32523[(11)] = inst_32463__$1);

return statearr_32523;
})();
var statearr_32524_32559 = state_32509__$1;
(statearr_32524_32559[(2)] = null);

(statearr_32524_32559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (22))){
var state_32509__$1 = state_32509;
var statearr_32525_32560 = state_32509__$1;
(statearr_32525_32560[(2)] = null);

(statearr_32525_32560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (6))){
var inst_32450 = (state_32509[(13)]);
var inst_32459 = f.call(null,inst_32450);
var inst_32460 = cljs.core.seq.call(null,inst_32459);
var inst_32461 = inst_32460;
var inst_32462 = null;
var inst_32463 = (0);
var inst_32464 = (0);
var state_32509__$1 = (function (){var statearr_32526 = state_32509;
(statearr_32526[(8)] = inst_32462);

(statearr_32526[(9)] = inst_32464);

(statearr_32526[(10)] = inst_32461);

(statearr_32526[(11)] = inst_32463);

return statearr_32526;
})();
var statearr_32527_32561 = state_32509__$1;
(statearr_32527_32561[(2)] = null);

(statearr_32527_32561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (17))){
var inst_32475 = (state_32509[(7)]);
var inst_32479 = cljs.core.chunk_first.call(null,inst_32475);
var inst_32480 = cljs.core.chunk_rest.call(null,inst_32475);
var inst_32481 = cljs.core.count.call(null,inst_32479);
var inst_32461 = inst_32480;
var inst_32462 = inst_32479;
var inst_32463 = inst_32481;
var inst_32464 = (0);
var state_32509__$1 = (function (){var statearr_32528 = state_32509;
(statearr_32528[(8)] = inst_32462);

(statearr_32528[(9)] = inst_32464);

(statearr_32528[(10)] = inst_32461);

(statearr_32528[(11)] = inst_32463);

return statearr_32528;
})();
var statearr_32529_32562 = state_32509__$1;
(statearr_32529_32562[(2)] = null);

(statearr_32529_32562[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (3))){
var inst_32507 = (state_32509[(2)]);
var state_32509__$1 = state_32509;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32509__$1,inst_32507);
} else {
if((state_val_32510 === (12))){
var inst_32495 = (state_32509[(2)]);
var state_32509__$1 = state_32509;
var statearr_32530_32563 = state_32509__$1;
(statearr_32530_32563[(2)] = inst_32495);

(statearr_32530_32563[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (2))){
var state_32509__$1 = state_32509;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32509__$1,(4),in$);
} else {
if((state_val_32510 === (23))){
var inst_32503 = (state_32509[(2)]);
var state_32509__$1 = state_32509;
var statearr_32531_32564 = state_32509__$1;
(statearr_32531_32564[(2)] = inst_32503);

(statearr_32531_32564[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (19))){
var inst_32490 = (state_32509[(2)]);
var state_32509__$1 = state_32509;
var statearr_32532_32565 = state_32509__$1;
(statearr_32532_32565[(2)] = inst_32490);

(statearr_32532_32565[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (11))){
var inst_32475 = (state_32509[(7)]);
var inst_32461 = (state_32509[(10)]);
var inst_32475__$1 = cljs.core.seq.call(null,inst_32461);
var state_32509__$1 = (function (){var statearr_32533 = state_32509;
(statearr_32533[(7)] = inst_32475__$1);

return statearr_32533;
})();
if(inst_32475__$1){
var statearr_32534_32566 = state_32509__$1;
(statearr_32534_32566[(1)] = (14));

} else {
var statearr_32535_32567 = state_32509__$1;
(statearr_32535_32567[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (9))){
var inst_32497 = (state_32509[(2)]);
var inst_32498 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_32509__$1 = (function (){var statearr_32536 = state_32509;
(statearr_32536[(15)] = inst_32497);

return statearr_32536;
})();
if(cljs.core.truth_(inst_32498)){
var statearr_32537_32568 = state_32509__$1;
(statearr_32537_32568[(1)] = (21));

} else {
var statearr_32538_32569 = state_32509__$1;
(statearr_32538_32569[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (5))){
var inst_32453 = cljs.core.async.close_BANG_.call(null,out);
var state_32509__$1 = state_32509;
var statearr_32539_32570 = state_32509__$1;
(statearr_32539_32570[(2)] = inst_32453);

(statearr_32539_32570[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (14))){
var inst_32475 = (state_32509[(7)]);
var inst_32477 = cljs.core.chunked_seq_QMARK_.call(null,inst_32475);
var state_32509__$1 = state_32509;
if(inst_32477){
var statearr_32540_32571 = state_32509__$1;
(statearr_32540_32571[(1)] = (17));

} else {
var statearr_32541_32572 = state_32509__$1;
(statearr_32541_32572[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (16))){
var inst_32493 = (state_32509[(2)]);
var state_32509__$1 = state_32509;
var statearr_32542_32573 = state_32509__$1;
(statearr_32542_32573[(2)] = inst_32493);

(statearr_32542_32573[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32510 === (10))){
var inst_32462 = (state_32509[(8)]);
var inst_32464 = (state_32509[(9)]);
var inst_32469 = cljs.core._nth.call(null,inst_32462,inst_32464);
var state_32509__$1 = state_32509;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32509__$1,(13),out,inst_32469);
} else {
if((state_val_32510 === (18))){
var inst_32475 = (state_32509[(7)]);
var inst_32484 = cljs.core.first.call(null,inst_32475);
var state_32509__$1 = state_32509;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32509__$1,(20),out,inst_32484);
} else {
if((state_val_32510 === (8))){
var inst_32464 = (state_32509[(9)]);
var inst_32463 = (state_32509[(11)]);
var inst_32466 = (inst_32464 < inst_32463);
var inst_32467 = inst_32466;
var state_32509__$1 = state_32509;
if(cljs.core.truth_(inst_32467)){
var statearr_32543_32574 = state_32509__$1;
(statearr_32543_32574[(1)] = (10));

} else {
var statearr_32544_32575 = state_32509__$1;
(statearr_32544_32575[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto__))
;
return ((function (switch__29920__auto__,c__30034__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29921__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29921__auto____0 = (function (){
var statearr_32548 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32548[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29921__auto__);

(statearr_32548[(1)] = (1));

return statearr_32548;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29921__auto____1 = (function (state_32509){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_32509);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e32549){if((e32549 instanceof Object)){
var ex__29924__auto__ = e32549;
var statearr_32550_32576 = state_32509;
(statearr_32550_32576[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32509);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32549;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32577 = state_32509;
state_32509 = G__32577;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29921__auto__ = function(state_32509){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29921__auto____1.call(this,state_32509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29921__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29921__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto__))
})();
var state__30036__auto__ = (function (){var statearr_32551 = f__30035__auto__.call(null);
(statearr_32551[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto__);

return statearr_32551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto__))
);

return c__30034__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args32578 = [];
var len__27957__auto___32581 = arguments.length;
var i__27958__auto___32582 = (0);
while(true){
if((i__27958__auto___32582 < len__27957__auto___32581)){
args32578.push((arguments[i__27958__auto___32582]));

var G__32583 = (i__27958__auto___32582 + (1));
i__27958__auto___32582 = G__32583;
continue;
} else {
}
break;
}

var G__32580 = args32578.length;
switch (G__32580) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32578.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args32585 = [];
var len__27957__auto___32588 = arguments.length;
var i__27958__auto___32589 = (0);
while(true){
if((i__27958__auto___32589 < len__27957__auto___32588)){
args32585.push((arguments[i__27958__auto___32589]));

var G__32590 = (i__27958__auto___32589 + (1));
i__27958__auto___32589 = G__32590;
continue;
} else {
}
break;
}

var G__32587 = args32585.length;
switch (G__32587) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32585.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args32592 = [];
var len__27957__auto___32643 = arguments.length;
var i__27958__auto___32644 = (0);
while(true){
if((i__27958__auto___32644 < len__27957__auto___32643)){
args32592.push((arguments[i__27958__auto___32644]));

var G__32645 = (i__27958__auto___32644 + (1));
i__27958__auto___32644 = G__32645;
continue;
} else {
}
break;
}

var G__32594 = args32592.length;
switch (G__32594) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32592.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30034__auto___32647 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___32647,out){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___32647,out){
return (function (state_32618){
var state_val_32619 = (state_32618[(1)]);
if((state_val_32619 === (7))){
var inst_32613 = (state_32618[(2)]);
var state_32618__$1 = state_32618;
var statearr_32620_32648 = state_32618__$1;
(statearr_32620_32648[(2)] = inst_32613);

(statearr_32620_32648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32619 === (1))){
var inst_32595 = null;
var state_32618__$1 = (function (){var statearr_32621 = state_32618;
(statearr_32621[(7)] = inst_32595);

return statearr_32621;
})();
var statearr_32622_32649 = state_32618__$1;
(statearr_32622_32649[(2)] = null);

(statearr_32622_32649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32619 === (4))){
var inst_32598 = (state_32618[(8)]);
var inst_32598__$1 = (state_32618[(2)]);
var inst_32599 = (inst_32598__$1 == null);
var inst_32600 = cljs.core.not.call(null,inst_32599);
var state_32618__$1 = (function (){var statearr_32623 = state_32618;
(statearr_32623[(8)] = inst_32598__$1);

return statearr_32623;
})();
if(inst_32600){
var statearr_32624_32650 = state_32618__$1;
(statearr_32624_32650[(1)] = (5));

} else {
var statearr_32625_32651 = state_32618__$1;
(statearr_32625_32651[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32619 === (6))){
var state_32618__$1 = state_32618;
var statearr_32626_32652 = state_32618__$1;
(statearr_32626_32652[(2)] = null);

(statearr_32626_32652[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32619 === (3))){
var inst_32615 = (state_32618[(2)]);
var inst_32616 = cljs.core.async.close_BANG_.call(null,out);
var state_32618__$1 = (function (){var statearr_32627 = state_32618;
(statearr_32627[(9)] = inst_32615);

return statearr_32627;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32618__$1,inst_32616);
} else {
if((state_val_32619 === (2))){
var state_32618__$1 = state_32618;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32618__$1,(4),ch);
} else {
if((state_val_32619 === (11))){
var inst_32598 = (state_32618[(8)]);
var inst_32607 = (state_32618[(2)]);
var inst_32595 = inst_32598;
var state_32618__$1 = (function (){var statearr_32628 = state_32618;
(statearr_32628[(7)] = inst_32595);

(statearr_32628[(10)] = inst_32607);

return statearr_32628;
})();
var statearr_32629_32653 = state_32618__$1;
(statearr_32629_32653[(2)] = null);

(statearr_32629_32653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32619 === (9))){
var inst_32598 = (state_32618[(8)]);
var state_32618__$1 = state_32618;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32618__$1,(11),out,inst_32598);
} else {
if((state_val_32619 === (5))){
var inst_32598 = (state_32618[(8)]);
var inst_32595 = (state_32618[(7)]);
var inst_32602 = cljs.core._EQ_.call(null,inst_32598,inst_32595);
var state_32618__$1 = state_32618;
if(inst_32602){
var statearr_32631_32654 = state_32618__$1;
(statearr_32631_32654[(1)] = (8));

} else {
var statearr_32632_32655 = state_32618__$1;
(statearr_32632_32655[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32619 === (10))){
var inst_32610 = (state_32618[(2)]);
var state_32618__$1 = state_32618;
var statearr_32633_32656 = state_32618__$1;
(statearr_32633_32656[(2)] = inst_32610);

(statearr_32633_32656[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32619 === (8))){
var inst_32595 = (state_32618[(7)]);
var tmp32630 = inst_32595;
var inst_32595__$1 = tmp32630;
var state_32618__$1 = (function (){var statearr_32634 = state_32618;
(statearr_32634[(7)] = inst_32595__$1);

return statearr_32634;
})();
var statearr_32635_32657 = state_32618__$1;
(statearr_32635_32657[(2)] = null);

(statearr_32635_32657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___32647,out))
;
return ((function (switch__29920__auto__,c__30034__auto___32647,out){
return (function() {
var cljs$core$async$state_machine__29921__auto__ = null;
var cljs$core$async$state_machine__29921__auto____0 = (function (){
var statearr_32639 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32639[(0)] = cljs$core$async$state_machine__29921__auto__);

(statearr_32639[(1)] = (1));

return statearr_32639;
});
var cljs$core$async$state_machine__29921__auto____1 = (function (state_32618){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_32618);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e32640){if((e32640 instanceof Object)){
var ex__29924__auto__ = e32640;
var statearr_32641_32658 = state_32618;
(statearr_32641_32658[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32618);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32640;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32659 = state_32618;
state_32618 = G__32659;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$state_machine__29921__auto__ = function(state_32618){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29921__auto____1.call(this,state_32618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29921__auto____0;
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29921__auto____1;
return cljs$core$async$state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___32647,out))
})();
var state__30036__auto__ = (function (){var statearr_32642 = f__30035__auto__.call(null);
(statearr_32642[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___32647);

return statearr_32642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___32647,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args32660 = [];
var len__27957__auto___32730 = arguments.length;
var i__27958__auto___32731 = (0);
while(true){
if((i__27958__auto___32731 < len__27957__auto___32730)){
args32660.push((arguments[i__27958__auto___32731]));

var G__32732 = (i__27958__auto___32731 + (1));
i__27958__auto___32731 = G__32732;
continue;
} else {
}
break;
}

var G__32662 = args32660.length;
switch (G__32662) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32660.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30034__auto___32734 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___32734,out){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___32734,out){
return (function (state_32700){
var state_val_32701 = (state_32700[(1)]);
if((state_val_32701 === (7))){
var inst_32696 = (state_32700[(2)]);
var state_32700__$1 = state_32700;
var statearr_32702_32735 = state_32700__$1;
(statearr_32702_32735[(2)] = inst_32696);

(statearr_32702_32735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32701 === (1))){
var inst_32663 = (new Array(n));
var inst_32664 = inst_32663;
var inst_32665 = (0);
var state_32700__$1 = (function (){var statearr_32703 = state_32700;
(statearr_32703[(7)] = inst_32664);

(statearr_32703[(8)] = inst_32665);

return statearr_32703;
})();
var statearr_32704_32736 = state_32700__$1;
(statearr_32704_32736[(2)] = null);

(statearr_32704_32736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32701 === (4))){
var inst_32668 = (state_32700[(9)]);
var inst_32668__$1 = (state_32700[(2)]);
var inst_32669 = (inst_32668__$1 == null);
var inst_32670 = cljs.core.not.call(null,inst_32669);
var state_32700__$1 = (function (){var statearr_32705 = state_32700;
(statearr_32705[(9)] = inst_32668__$1);

return statearr_32705;
})();
if(inst_32670){
var statearr_32706_32737 = state_32700__$1;
(statearr_32706_32737[(1)] = (5));

} else {
var statearr_32707_32738 = state_32700__$1;
(statearr_32707_32738[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32701 === (15))){
var inst_32690 = (state_32700[(2)]);
var state_32700__$1 = state_32700;
var statearr_32708_32739 = state_32700__$1;
(statearr_32708_32739[(2)] = inst_32690);

(statearr_32708_32739[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32701 === (13))){
var state_32700__$1 = state_32700;
var statearr_32709_32740 = state_32700__$1;
(statearr_32709_32740[(2)] = null);

(statearr_32709_32740[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32701 === (6))){
var inst_32665 = (state_32700[(8)]);
var inst_32686 = (inst_32665 > (0));
var state_32700__$1 = state_32700;
if(cljs.core.truth_(inst_32686)){
var statearr_32710_32741 = state_32700__$1;
(statearr_32710_32741[(1)] = (12));

} else {
var statearr_32711_32742 = state_32700__$1;
(statearr_32711_32742[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32701 === (3))){
var inst_32698 = (state_32700[(2)]);
var state_32700__$1 = state_32700;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32700__$1,inst_32698);
} else {
if((state_val_32701 === (12))){
var inst_32664 = (state_32700[(7)]);
var inst_32688 = cljs.core.vec.call(null,inst_32664);
var state_32700__$1 = state_32700;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32700__$1,(15),out,inst_32688);
} else {
if((state_val_32701 === (2))){
var state_32700__$1 = state_32700;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32700__$1,(4),ch);
} else {
if((state_val_32701 === (11))){
var inst_32680 = (state_32700[(2)]);
var inst_32681 = (new Array(n));
var inst_32664 = inst_32681;
var inst_32665 = (0);
var state_32700__$1 = (function (){var statearr_32712 = state_32700;
(statearr_32712[(7)] = inst_32664);

(statearr_32712[(10)] = inst_32680);

(statearr_32712[(8)] = inst_32665);

return statearr_32712;
})();
var statearr_32713_32743 = state_32700__$1;
(statearr_32713_32743[(2)] = null);

(statearr_32713_32743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32701 === (9))){
var inst_32664 = (state_32700[(7)]);
var inst_32678 = cljs.core.vec.call(null,inst_32664);
var state_32700__$1 = state_32700;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32700__$1,(11),out,inst_32678);
} else {
if((state_val_32701 === (5))){
var inst_32668 = (state_32700[(9)]);
var inst_32664 = (state_32700[(7)]);
var inst_32673 = (state_32700[(11)]);
var inst_32665 = (state_32700[(8)]);
var inst_32672 = (inst_32664[inst_32665] = inst_32668);
var inst_32673__$1 = (inst_32665 + (1));
var inst_32674 = (inst_32673__$1 < n);
var state_32700__$1 = (function (){var statearr_32714 = state_32700;
(statearr_32714[(12)] = inst_32672);

(statearr_32714[(11)] = inst_32673__$1);

return statearr_32714;
})();
if(cljs.core.truth_(inst_32674)){
var statearr_32715_32744 = state_32700__$1;
(statearr_32715_32744[(1)] = (8));

} else {
var statearr_32716_32745 = state_32700__$1;
(statearr_32716_32745[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32701 === (14))){
var inst_32693 = (state_32700[(2)]);
var inst_32694 = cljs.core.async.close_BANG_.call(null,out);
var state_32700__$1 = (function (){var statearr_32718 = state_32700;
(statearr_32718[(13)] = inst_32693);

return statearr_32718;
})();
var statearr_32719_32746 = state_32700__$1;
(statearr_32719_32746[(2)] = inst_32694);

(statearr_32719_32746[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32701 === (10))){
var inst_32684 = (state_32700[(2)]);
var state_32700__$1 = state_32700;
var statearr_32720_32747 = state_32700__$1;
(statearr_32720_32747[(2)] = inst_32684);

(statearr_32720_32747[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32701 === (8))){
var inst_32664 = (state_32700[(7)]);
var inst_32673 = (state_32700[(11)]);
var tmp32717 = inst_32664;
var inst_32664__$1 = tmp32717;
var inst_32665 = inst_32673;
var state_32700__$1 = (function (){var statearr_32721 = state_32700;
(statearr_32721[(7)] = inst_32664__$1);

(statearr_32721[(8)] = inst_32665);

return statearr_32721;
})();
var statearr_32722_32748 = state_32700__$1;
(statearr_32722_32748[(2)] = null);

(statearr_32722_32748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___32734,out))
;
return ((function (switch__29920__auto__,c__30034__auto___32734,out){
return (function() {
var cljs$core$async$state_machine__29921__auto__ = null;
var cljs$core$async$state_machine__29921__auto____0 = (function (){
var statearr_32726 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32726[(0)] = cljs$core$async$state_machine__29921__auto__);

(statearr_32726[(1)] = (1));

return statearr_32726;
});
var cljs$core$async$state_machine__29921__auto____1 = (function (state_32700){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_32700);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e32727){if((e32727 instanceof Object)){
var ex__29924__auto__ = e32727;
var statearr_32728_32749 = state_32700;
(statearr_32728_32749[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32700);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32727;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32750 = state_32700;
state_32700 = G__32750;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$state_machine__29921__auto__ = function(state_32700){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29921__auto____1.call(this,state_32700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29921__auto____0;
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29921__auto____1;
return cljs$core$async$state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___32734,out))
})();
var state__30036__auto__ = (function (){var statearr_32729 = f__30035__auto__.call(null);
(statearr_32729[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___32734);

return statearr_32729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___32734,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args32751 = [];
var len__27957__auto___32825 = arguments.length;
var i__27958__auto___32826 = (0);
while(true){
if((i__27958__auto___32826 < len__27957__auto___32825)){
args32751.push((arguments[i__27958__auto___32826]));

var G__32827 = (i__27958__auto___32826 + (1));
i__27958__auto___32826 = G__32827;
continue;
} else {
}
break;
}

var G__32753 = args32751.length;
switch (G__32753) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32751.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30034__auto___32829 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___32829,out){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___32829,out){
return (function (state_32795){
var state_val_32796 = (state_32795[(1)]);
if((state_val_32796 === (7))){
var inst_32791 = (state_32795[(2)]);
var state_32795__$1 = state_32795;
var statearr_32797_32830 = state_32795__$1;
(statearr_32797_32830[(2)] = inst_32791);

(statearr_32797_32830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32796 === (1))){
var inst_32754 = [];
var inst_32755 = inst_32754;
var inst_32756 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32795__$1 = (function (){var statearr_32798 = state_32795;
(statearr_32798[(7)] = inst_32755);

(statearr_32798[(8)] = inst_32756);

return statearr_32798;
})();
var statearr_32799_32831 = state_32795__$1;
(statearr_32799_32831[(2)] = null);

(statearr_32799_32831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32796 === (4))){
var inst_32759 = (state_32795[(9)]);
var inst_32759__$1 = (state_32795[(2)]);
var inst_32760 = (inst_32759__$1 == null);
var inst_32761 = cljs.core.not.call(null,inst_32760);
var state_32795__$1 = (function (){var statearr_32800 = state_32795;
(statearr_32800[(9)] = inst_32759__$1);

return statearr_32800;
})();
if(inst_32761){
var statearr_32801_32832 = state_32795__$1;
(statearr_32801_32832[(1)] = (5));

} else {
var statearr_32802_32833 = state_32795__$1;
(statearr_32802_32833[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32796 === (15))){
var inst_32785 = (state_32795[(2)]);
var state_32795__$1 = state_32795;
var statearr_32803_32834 = state_32795__$1;
(statearr_32803_32834[(2)] = inst_32785);

(statearr_32803_32834[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32796 === (13))){
var state_32795__$1 = state_32795;
var statearr_32804_32835 = state_32795__$1;
(statearr_32804_32835[(2)] = null);

(statearr_32804_32835[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32796 === (6))){
var inst_32755 = (state_32795[(7)]);
var inst_32780 = inst_32755.length;
var inst_32781 = (inst_32780 > (0));
var state_32795__$1 = state_32795;
if(cljs.core.truth_(inst_32781)){
var statearr_32805_32836 = state_32795__$1;
(statearr_32805_32836[(1)] = (12));

} else {
var statearr_32806_32837 = state_32795__$1;
(statearr_32806_32837[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32796 === (3))){
var inst_32793 = (state_32795[(2)]);
var state_32795__$1 = state_32795;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32795__$1,inst_32793);
} else {
if((state_val_32796 === (12))){
var inst_32755 = (state_32795[(7)]);
var inst_32783 = cljs.core.vec.call(null,inst_32755);
var state_32795__$1 = state_32795;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32795__$1,(15),out,inst_32783);
} else {
if((state_val_32796 === (2))){
var state_32795__$1 = state_32795;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32795__$1,(4),ch);
} else {
if((state_val_32796 === (11))){
var inst_32759 = (state_32795[(9)]);
var inst_32763 = (state_32795[(10)]);
var inst_32773 = (state_32795[(2)]);
var inst_32774 = [];
var inst_32775 = inst_32774.push(inst_32759);
var inst_32755 = inst_32774;
var inst_32756 = inst_32763;
var state_32795__$1 = (function (){var statearr_32807 = state_32795;
(statearr_32807[(7)] = inst_32755);

(statearr_32807[(8)] = inst_32756);

(statearr_32807[(11)] = inst_32773);

(statearr_32807[(12)] = inst_32775);

return statearr_32807;
})();
var statearr_32808_32838 = state_32795__$1;
(statearr_32808_32838[(2)] = null);

(statearr_32808_32838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32796 === (9))){
var inst_32755 = (state_32795[(7)]);
var inst_32771 = cljs.core.vec.call(null,inst_32755);
var state_32795__$1 = state_32795;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32795__$1,(11),out,inst_32771);
} else {
if((state_val_32796 === (5))){
var inst_32759 = (state_32795[(9)]);
var inst_32763 = (state_32795[(10)]);
var inst_32756 = (state_32795[(8)]);
var inst_32763__$1 = f.call(null,inst_32759);
var inst_32764 = cljs.core._EQ_.call(null,inst_32763__$1,inst_32756);
var inst_32765 = cljs.core.keyword_identical_QMARK_.call(null,inst_32756,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_32766 = (inst_32764) || (inst_32765);
var state_32795__$1 = (function (){var statearr_32809 = state_32795;
(statearr_32809[(10)] = inst_32763__$1);

return statearr_32809;
})();
if(cljs.core.truth_(inst_32766)){
var statearr_32810_32839 = state_32795__$1;
(statearr_32810_32839[(1)] = (8));

} else {
var statearr_32811_32840 = state_32795__$1;
(statearr_32811_32840[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32796 === (14))){
var inst_32788 = (state_32795[(2)]);
var inst_32789 = cljs.core.async.close_BANG_.call(null,out);
var state_32795__$1 = (function (){var statearr_32813 = state_32795;
(statearr_32813[(13)] = inst_32788);

return statearr_32813;
})();
var statearr_32814_32841 = state_32795__$1;
(statearr_32814_32841[(2)] = inst_32789);

(statearr_32814_32841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32796 === (10))){
var inst_32778 = (state_32795[(2)]);
var state_32795__$1 = state_32795;
var statearr_32815_32842 = state_32795__$1;
(statearr_32815_32842[(2)] = inst_32778);

(statearr_32815_32842[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32796 === (8))){
var inst_32755 = (state_32795[(7)]);
var inst_32759 = (state_32795[(9)]);
var inst_32763 = (state_32795[(10)]);
var inst_32768 = inst_32755.push(inst_32759);
var tmp32812 = inst_32755;
var inst_32755__$1 = tmp32812;
var inst_32756 = inst_32763;
var state_32795__$1 = (function (){var statearr_32816 = state_32795;
(statearr_32816[(7)] = inst_32755__$1);

(statearr_32816[(8)] = inst_32756);

(statearr_32816[(14)] = inst_32768);

return statearr_32816;
})();
var statearr_32817_32843 = state_32795__$1;
(statearr_32817_32843[(2)] = null);

(statearr_32817_32843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___32829,out))
;
return ((function (switch__29920__auto__,c__30034__auto___32829,out){
return (function() {
var cljs$core$async$state_machine__29921__auto__ = null;
var cljs$core$async$state_machine__29921__auto____0 = (function (){
var statearr_32821 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32821[(0)] = cljs$core$async$state_machine__29921__auto__);

(statearr_32821[(1)] = (1));

return statearr_32821;
});
var cljs$core$async$state_machine__29921__auto____1 = (function (state_32795){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_32795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e32822){if((e32822 instanceof Object)){
var ex__29924__auto__ = e32822;
var statearr_32823_32844 = state_32795;
(statearr_32823_32844[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32795);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32822;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32845 = state_32795;
state_32795 = G__32845;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
cljs$core$async$state_machine__29921__auto__ = function(state_32795){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29921__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29921__auto____1.call(this,state_32795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29921__auto____0;
cljs$core$async$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29921__auto____1;
return cljs$core$async$state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___32829,out))
})();
var state__30036__auto__ = (function (){var statearr_32824 = f__30035__auto__.call(null);
(statearr_32824[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___32829);

return statearr_32824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___32829,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1489589589920